package software.amazon.awscdk.services.elasticloadbalancing;

/**
 * Construction properties for a LoadBalancer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * TaskDefinition taskDefinition;
 * Vpc vpc;
 * Ec2Service service = Ec2Service.Builder.create(this, "Service").cluster(cluster).taskDefinition(taskDefinition).minHealthyPercent(100).build();
 * LoadBalancer lb = LoadBalancer.Builder.create(this, "LB").vpc(vpc).build();
 * lb.addListener(LoadBalancerListener.builder().externalPort(80).build());
 * lb.addTarget(service);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:51.737Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancing.LoadBalancerProps")
@software.amazon.jsii.Jsii.Proxy(LoadBalancerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LoadBalancerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * VPC network of the fleet instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * Enable Loadbalancer access logs Can be used to avoid manual work as aws console Required S3 bucket name , enabled flag Can add interval for pushing log Can set bucket prefix in order to provide folder name inside bucket.
     * <p>
     * Default: - disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.AccessLoggingPolicyProperty getAccessLoggingPolicy() {
        return null;
    }

    /**
     * Whether cross zone load balancing is enabled.
     * <p>
     * This controls whether the load balancer evenly distributes requests
     * across each availability zone
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCrossZone() {
        return null;
    }

    /**
     * Health check settings for the load balancing targets.
     * <p>
     * Not required but recommended.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancing.HealthCheck getHealthCheck() {
        return null;
    }

    /**
     * Whether this is an internet-facing Load Balancer.
     * <p>
     * This controls whether the LB has a public IP address assigned. It does
     * not open up the Load Balancer's security groups to public internet access.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getInternetFacing() {
        return null;
    }

    /**
     * What listeners to set up for the load balancer.
     * <p>
     * Can also be added by .addListener()
     * <p>
     * Default: -
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerListener> getListeners() {
        return null;
    }

    /**
     * Which subnets to deploy the load balancer.
     * <p>
     * Can be used to define a specific set of subnets to deploy the load balancer to.
     * Useful multiple public or private subnets are covering the same availability zone.
     * <p>
     * Default: - Public subnets if internetFacing, Private subnets otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
        return null;
    }

    /**
     * What targets to load balance to.
     * <p>
     * Can also be added by .addTarget()
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget> getTargets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LoadBalancerProps> {
        software.amazon.awscdk.services.ec2.IVpc vpc;
        software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.AccessLoggingPolicyProperty accessLoggingPolicy;
        java.lang.Boolean crossZone;
        software.amazon.awscdk.services.elasticloadbalancing.HealthCheck healthCheck;
        java.lang.Boolean internetFacing;
        java.util.List<software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerListener> listeners;
        software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        java.util.List<software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget> targets;

        /**
         * Sets the value of {@link LoadBalancerProps#getVpc}
         * @param vpc VPC network of the fleet instances. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerProps#getAccessLoggingPolicy}
         * @param accessLoggingPolicy Enable Loadbalancer access logs Can be used to avoid manual work as aws console Required S3 bucket name , enabled flag Can add interval for pushing log Can set bucket prefix in order to provide folder name inside bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLoggingPolicy(software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.AccessLoggingPolicyProperty accessLoggingPolicy) {
            this.accessLoggingPolicy = accessLoggingPolicy;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerProps#getCrossZone}
         * @param crossZone Whether cross zone load balancing is enabled.
         *                  This controls whether the load balancer evenly distributes requests
         *                  across each availability zone
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossZone(java.lang.Boolean crossZone) {
            this.crossZone = crossZone;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerProps#getHealthCheck}
         * @param healthCheck Health check settings for the load balancing targets.
         *                    Not required but recommended.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(software.amazon.awscdk.services.elasticloadbalancing.HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerProps#getInternetFacing}
         * @param internetFacing Whether this is an internet-facing Load Balancer.
         *                       This controls whether the LB has a public IP address assigned. It does
         *                       not open up the Load Balancer's security groups to public internet access.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internetFacing(java.lang.Boolean internetFacing) {
            this.internetFacing = internetFacing;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerProps#getListeners}
         * @param listeners What listeners to set up for the load balancer.
         *                  Can also be added by .addListener()
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder listeners(java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerListener> listeners) {
            this.listeners = (java.util.List<software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerListener>)listeners;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerProps#getSubnetSelection}
         * @param subnetSelection Which subnets to deploy the load balancer.
         *                        Can be used to define a specific set of subnets to deploy the load balancer to.
         *                        Useful multiple public or private subnets are covering the same availability zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerProps#getTargets}
         * @param targets What targets to load balance to.
         *                Can also be added by .addTarget()
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder targets(java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget> targets) {
            this.targets = (java.util.List<software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget>)targets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LoadBalancerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LoadBalancerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadBalancerProps {
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.AccessLoggingPolicyProperty accessLoggingPolicy;
        private final java.lang.Boolean crossZone;
        private final software.amazon.awscdk.services.elasticloadbalancing.HealthCheck healthCheck;
        private final java.lang.Boolean internetFacing;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerListener> listeners;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget> targets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.accessLoggingPolicy = software.amazon.jsii.Kernel.get(this, "accessLoggingPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.AccessLoggingPolicyProperty.class));
            this.crossZone = software.amazon.jsii.Kernel.get(this, "crossZone", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.healthCheck = software.amazon.jsii.Kernel.get(this, "healthCheck", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancing.HealthCheck.class));
            this.internetFacing = software.amazon.jsii.Kernel.get(this, "internetFacing", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.listeners = software.amazon.jsii.Kernel.get(this, "listeners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerListener.class)));
            this.subnetSelection = software.amazon.jsii.Kernel.get(this, "subnetSelection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.targets = software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
            this.accessLoggingPolicy = builder.accessLoggingPolicy;
            this.crossZone = builder.crossZone;
            this.healthCheck = builder.healthCheck;
            this.internetFacing = builder.internetFacing;
            this.listeners = (java.util.List<software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerListener>)builder.listeners;
            this.subnetSelection = builder.subnetSelection;
            this.targets = (java.util.List<software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget>)builder.targets;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.AccessLoggingPolicyProperty getAccessLoggingPolicy() {
            return this.accessLoggingPolicy;
        }

        @Override
        public final java.lang.Boolean getCrossZone() {
            return this.crossZone;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancing.HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public final java.lang.Boolean getInternetFacing() {
            return this.internetFacing;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerListener> getListeners() {
            return this.listeners;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
            return this.subnetSelection;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget> getTargets() {
            return this.targets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getAccessLoggingPolicy() != null) {
                data.set("accessLoggingPolicy", om.valueToTree(this.getAccessLoggingPolicy()));
            }
            if (this.getCrossZone() != null) {
                data.set("crossZone", om.valueToTree(this.getCrossZone()));
            }
            if (this.getHealthCheck() != null) {
                data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
            }
            if (this.getInternetFacing() != null) {
                data.set("internetFacing", om.valueToTree(this.getInternetFacing()));
            }
            if (this.getListeners() != null) {
                data.set("listeners", om.valueToTree(this.getListeners()));
            }
            if (this.getSubnetSelection() != null) {
                data.set("subnetSelection", om.valueToTree(this.getSubnetSelection()));
            }
            if (this.getTargets() != null) {
                data.set("targets", om.valueToTree(this.getTargets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancing.LoadBalancerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LoadBalancerProps.Jsii$Proxy that = (LoadBalancerProps.Jsii$Proxy) o;

            if (!vpc.equals(that.vpc)) return false;
            if (this.accessLoggingPolicy != null ? !this.accessLoggingPolicy.equals(that.accessLoggingPolicy) : that.accessLoggingPolicy != null) return false;
            if (this.crossZone != null ? !this.crossZone.equals(that.crossZone) : that.crossZone != null) return false;
            if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
            if (this.internetFacing != null ? !this.internetFacing.equals(that.internetFacing) : that.internetFacing != null) return false;
            if (this.listeners != null ? !this.listeners.equals(that.listeners) : that.listeners != null) return false;
            if (this.subnetSelection != null ? !this.subnetSelection.equals(that.subnetSelection) : that.subnetSelection != null) return false;
            return this.targets != null ? this.targets.equals(that.targets) : that.targets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.vpc.hashCode();
            result = 31 * result + (this.accessLoggingPolicy != null ? this.accessLoggingPolicy.hashCode() : 0);
            result = 31 * result + (this.crossZone != null ? this.crossZone.hashCode() : 0);
            result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
            result = 31 * result + (this.internetFacing != null ? this.internetFacing.hashCode() : 0);
            result = 31 * result + (this.listeners != null ? this.listeners.hashCode() : 0);
            result = 31 * result + (this.subnetSelection != null ? this.subnetSelection.hashCode() : 0);
            result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
            return result;
        }
    }
}
