package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining a <code>CfnListenerRule</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * CfnListenerRuleProps cfnListenerRuleProps = CfnListenerRuleProps.builder()
 *         .actions(List.of(ActionProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .authenticateCognitoConfig(AuthenticateCognitoConfigProperty.builder()
 *                         .userPoolArn("userPoolArn")
 *                         .userPoolClientId("userPoolClientId")
 *                         .userPoolDomain("userPoolDomain")
 *                         // the properties below are optional
 *                         .authenticationRequestExtraParams(Map.of(
 *                                 "authenticationRequestExtraParamsKey", "authenticationRequestExtraParams"))
 *                         .onUnauthenticatedRequest("onUnauthenticatedRequest")
 *                         .scope("scope")
 *                         .sessionCookieName("sessionCookieName")
 *                         .sessionTimeout(123)
 *                         .build())
 *                 .authenticateOidcConfig(AuthenticateOidcConfigProperty.builder()
 *                         .authorizationEndpoint("authorizationEndpoint")
 *                         .clientId("clientId")
 *                         .issuer("issuer")
 *                         .tokenEndpoint("tokenEndpoint")
 *                         .userInfoEndpoint("userInfoEndpoint")
 *                         // the properties below are optional
 *                         .authenticationRequestExtraParams(Map.of(
 *                                 "authenticationRequestExtraParamsKey", "authenticationRequestExtraParams"))
 *                         .clientSecret("clientSecret")
 *                         .onUnauthenticatedRequest("onUnauthenticatedRequest")
 *                         .scope("scope")
 *                         .sessionCookieName("sessionCookieName")
 *                         .sessionTimeout(123)
 *                         .useExistingClientSecret(false)
 *                         .build())
 *                 .fixedResponseConfig(FixedResponseConfigProperty.builder()
 *                         .statusCode("statusCode")
 *                         // the properties below are optional
 *                         .contentType("contentType")
 *                         .messageBody("messageBody")
 *                         .build())
 *                 .forwardConfig(ForwardConfigProperty.builder()
 *                         .targetGroups(List.of(TargetGroupTupleProperty.builder()
 *                                 .targetGroupArn("targetGroupArn")
 *                                 .weight(123)
 *                                 .build()))
 *                         .targetGroupStickinessConfig(TargetGroupStickinessConfigProperty.builder()
 *                                 .durationSeconds(123)
 *                                 .enabled(false)
 *                                 .build())
 *                         .build())
 *                 .jwtValidationConfig(JwtValidationConfigProperty.builder()
 *                         .issuer("issuer")
 *                         .jwksEndpoint("jwksEndpoint")
 *                         // the properties below are optional
 *                         .additionalClaims(List.of(JwtValidationActionAdditionalClaimProperty.builder()
 *                                 .format("format")
 *                                 .name("name")
 *                                 .values(List.of("values"))
 *                                 .build()))
 *                         .build())
 *                 .order(123)
 *                 .redirectConfig(RedirectConfigProperty.builder()
 *                         .statusCode("statusCode")
 *                         // the properties below are optional
 *                         .host("host")
 *                         .path("path")
 *                         .port("port")
 *                         .protocol("protocol")
 *                         .query("query")
 *                         .build())
 *                 .targetGroupArn("targetGroupArn")
 *                 .build()))
 *         .conditions(List.of(RuleConditionProperty.builder()
 *                 .field("field")
 *                 .hostHeaderConfig(HostHeaderConfigProperty.builder()
 *                         .regexValues(List.of("regexValues"))
 *                         .values(List.of("values"))
 *                         .build())
 *                 .httpHeaderConfig(HttpHeaderConfigProperty.builder()
 *                         .httpHeaderName("httpHeaderName")
 *                         .regexValues(List.of("regexValues"))
 *                         .values(List.of("values"))
 *                         .build())
 *                 .httpRequestMethodConfig(HttpRequestMethodConfigProperty.builder()
 *                         .values(List.of("values"))
 *                         .build())
 *                 .pathPatternConfig(PathPatternConfigProperty.builder()
 *                         .regexValues(List.of("regexValues"))
 *                         .values(List.of("values"))
 *                         .build())
 *                 .queryStringConfig(QueryStringConfigProperty.builder()
 *                         .values(List.of(QueryStringKeyValueProperty.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .build())
 *                 .regexValues(List.of("regexValues"))
 *                 .sourceIpConfig(SourceIpConfigProperty.builder()
 *                         .values(List.of("values"))
 *                         .build())
 *                 .values(List.of("values"))
 *                 .build()))
 *         .priority(123)
 *         // the properties below are optional
 *         .listenerArn("listenerArn")
 *         .transforms(List.of(TransformProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .hostHeaderRewriteConfig(RewriteConfigObjectProperty.builder()
 *                         .rewrites(List.of(RewriteConfigProperty.builder()
 *                                 .regex("regex")
 *                                 .replace("replace")
 *                                 .build()))
 *                         .build())
 *                 .urlRewriteConfig(RewriteConfigObjectProperty.builder()
 *                         .rewrites(List.of(RewriteConfigProperty.builder()
 *                                 .regex("regex")
 *                                 .replace("replace")
 *                                 .build()))
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:51.944Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRuleProps")
@software.amazon.jsii.Jsii.Proxy(CfnListenerRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnListenerRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The actions.
     * <p>
     * The rule must include exactly one of the following types of actions: <code>forward</code> , <code>fixed-response</code> , or <code>redirect</code> , and it must be the last action to be performed. If the rule is for an HTTPS listener, it can also optionally include an authentication action.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.ActionProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-actions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getActions();

    /**
     * The conditions.
     * <p>
     * The rule can optionally include up to one of each of the following conditions: <code>http-request-method</code> , <code>host-header</code> , <code>path-pattern</code> , and <code>source-ip</code> . A rule can also optionally include one or more of each of the following conditions: <code>http-header</code> and <code>query-string</code> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.RuleConditionProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-conditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-conditions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getConditions();

    /**
     * The rule priority. A listener can't have multiple rules with the same priority.
     * <p>
     * If you try to reorder rules by updating their priorities, do not specify a new priority if an existing rule already uses this priority, as this can cause an error. If you need to reuse a priority with a different rule, you must remove it as a priority first, and then specify it in a subsequent update.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-priority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-priority</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getPriority();

    /**
     * The Amazon Resource Name (ARN) of the listener.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-listenerarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-listenerarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getListenerArn() {
        return null;
    }

    /**
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.TransformProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-transforms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-transforms</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTransforms() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnListenerRuleProps> {
        java.lang.Object actions;
        java.lang.Object conditions;
        java.lang.Number priority;
        java.lang.String listenerArn;
        java.lang.Object transforms;

        /**
         * Sets the value of {@link CfnListenerRuleProps#getActions}
         * @param actions The actions. This parameter is required.
         *                The rule must include exactly one of the following types of actions: <code>forward</code> , <code>fixed-response</code> , or <code>redirect</code> , and it must be the last action to be performed. If the rule is for an HTTPS listener, it can also optionally include an authentication action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(software.amazon.awscdk.IResolvable actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerRuleProps#getActions}
         * @param actions The actions. This parameter is required.
         *                The rule must include exactly one of the following types of actions: <code>forward</code> , <code>fixed-response</code> , or <code>redirect</code> , and it must be the last action to be performed. If the rule is for an HTTPS listener, it can also optionally include an authentication action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(java.util.List<? extends java.lang.Object> actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerRuleProps#getConditions}
         * @param conditions The conditions. This parameter is required.
         *                   The rule can optionally include up to one of each of the following conditions: <code>http-request-method</code> , <code>host-header</code> , <code>path-pattern</code> , and <code>source-ip</code> . A rule can also optionally include one or more of each of the following conditions: <code>http-header</code> and <code>query-string</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conditions(software.amazon.awscdk.IResolvable conditions) {
            this.conditions = conditions;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerRuleProps#getConditions}
         * @param conditions The conditions. This parameter is required.
         *                   The rule can optionally include up to one of each of the following conditions: <code>http-request-method</code> , <code>host-header</code> , <code>path-pattern</code> , and <code>source-ip</code> . A rule can also optionally include one or more of each of the following conditions: <code>http-header</code> and <code>query-string</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conditions(java.util.List<? extends java.lang.Object> conditions) {
            this.conditions = conditions;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerRuleProps#getPriority}
         * @param priority The rule priority. A listener can't have multiple rules with the same priority. This parameter is required.
         *                 If you try to reorder rules by updating their priorities, do not specify a new priority if an existing rule already uses this priority, as this can cause an error. If you need to reuse a priority with a different rule, you must remove it as a priority first, and then specify it in a subsequent update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerRuleProps#getListenerArn}
         * @param listenerArn The Amazon Resource Name (ARN) of the listener.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listenerArn(java.lang.String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerRuleProps#getTransforms}
         * @param transforms the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transforms(software.amazon.awscdk.IResolvable transforms) {
            this.transforms = transforms;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerRuleProps#getTransforms}
         * @param transforms the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transforms(java.util.List<? extends java.lang.Object> transforms) {
            this.transforms = transforms;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnListenerRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnListenerRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnListenerRuleProps {
        private final java.lang.Object actions;
        private final java.lang.Object conditions;
        private final java.lang.Number priority;
        private final java.lang.String listenerArn;
        private final java.lang.Object transforms;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.conditions = software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.listenerArn = software.amazon.jsii.Kernel.get(this, "listenerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.transforms = software.amazon.jsii.Kernel.get(this, "transforms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
            this.conditions = java.util.Objects.requireNonNull(builder.conditions, "conditions is required");
            this.priority = java.util.Objects.requireNonNull(builder.priority, "priority is required");
            this.listenerArn = builder.listenerArn;
            this.transforms = builder.transforms;
        }

        @Override
        public final java.lang.Object getActions() {
            return this.actions;
        }

        @Override
        public final java.lang.Object getConditions() {
            return this.conditions;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public final java.lang.String getListenerArn() {
            return this.listenerArn;
        }

        @Override
        public final java.lang.Object getTransforms() {
            return this.transforms;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("actions", om.valueToTree(this.getActions()));
            data.set("conditions", om.valueToTree(this.getConditions()));
            data.set("priority", om.valueToTree(this.getPriority()));
            if (this.getListenerArn() != null) {
                data.set("listenerArn", om.valueToTree(this.getListenerArn()));
            }
            if (this.getTransforms() != null) {
                data.set("transforms", om.valueToTree(this.getTransforms()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnListenerRuleProps.Jsii$Proxy that = (CfnListenerRuleProps.Jsii$Proxy) o;

            if (!actions.equals(that.actions)) return false;
            if (!conditions.equals(that.conditions)) return false;
            if (!priority.equals(that.priority)) return false;
            if (this.listenerArn != null ? !this.listenerArn.equals(that.listenerArn) : that.listenerArn != null) return false;
            return this.transforms != null ? this.transforms.equals(that.transforms) : that.transforms == null;
        }

        @Override
        public final int hashCode() {
            int result = this.actions.hashCode();
            result = 31 * result + (this.conditions.hashCode());
            result = 31 * result + (this.priority.hashCode());
            result = 31 * result + (this.listenerArn != null ? this.listenerArn.hashCode() : 0);
            result = 31 * result + (this.transforms != null ? this.transforms.hashCode() : 0);
            return result;
        }
    }
}
