package software.amazon.awscdk.services.elasticsearch;

/**
 * The AWS::Elasticsearch::Domain resource creates an Amazon OpenSearch Service domain.
 * <p>
 * <blockquote>
 * <p>
 * The <code>AWS::Elasticsearch::Domain</code> resource is being replaced by the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html">AWS::OpenSearchService::Domain</a> resource. While the legacy Elasticsearch resource and options are still supported, we recommend modifying your existing Cloudformation templates to use the new OpenSearch Service resource, which supports both OpenSearch and legacy Elasticsearch. For instructions to upgrade domains defined within CloudFormation from Elasticsearch to OpenSearch, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#aws-resource-opensearchservice-domain--remarks">Remarks</a> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticsearch.*;
 * Object accessPolicies;
 * CfnDomain cfnDomain = CfnDomain.Builder.create(this, "MyCfnDomain")
 *         .accessPolicies(accessPolicies)
 *         .advancedOptions(Map.of(
 *                 "advancedOptionsKey", "advancedOptions"))
 *         .advancedSecurityOptions(AdvancedSecurityOptionsInputProperty.builder()
 *                 .anonymousAuthEnabled(false)
 *                 .enabled(false)
 *                 .internalUserDatabaseEnabled(false)
 *                 .masterUserOptions(MasterUserOptionsProperty.builder()
 *                         .masterUserArn("masterUserArn")
 *                         .masterUserName("masterUserName")
 *                         .masterUserPassword("masterUserPassword")
 *                         .build())
 *                 .build())
 *         .cognitoOptions(CognitoOptionsProperty.builder()
 *                 .enabled(false)
 *                 .identityPoolId("identityPoolId")
 *                 .roleArn("roleArn")
 *                 .userPoolId("userPoolId")
 *                 .build())
 *         .domainArn("domainArn")
 *         .domainEndpointOptions(DomainEndpointOptionsProperty.builder()
 *                 .customEndpoint("customEndpoint")
 *                 .customEndpointCertificateArn("customEndpointCertificateArn")
 *                 .customEndpointEnabled(false)
 *                 .enforceHttps(false)
 *                 .tlsSecurityPolicy("tlsSecurityPolicy")
 *                 .build())
 *         .domainName("domainName")
 *         .ebsOptions(EBSOptionsProperty.builder()
 *                 .ebsEnabled(false)
 *                 .iops(123)
 *                 .volumeSize(123)
 *                 .volumeType("volumeType")
 *                 .build())
 *         .elasticsearchClusterConfig(ElasticsearchClusterConfigProperty.builder()
 *                 .coldStorageOptions(ColdStorageOptionsProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .dedicatedMasterCount(123)
 *                 .dedicatedMasterEnabled(false)
 *                 .dedicatedMasterType("dedicatedMasterType")
 *                 .instanceCount(123)
 *                 .instanceType("instanceType")
 *                 .warmCount(123)
 *                 .warmEnabled(false)
 *                 .warmType("warmType")
 *                 .zoneAwarenessConfig(ZoneAwarenessConfigProperty.builder()
 *                         .availabilityZoneCount(123)
 *                         .build())
 *                 .zoneAwarenessEnabled(false)
 *                 .build())
 *         .elasticsearchVersion("elasticsearchVersion")
 *         .encryptionAtRestOptions(EncryptionAtRestOptionsProperty.builder()
 *                 .enabled(false)
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .logPublishingOptions(Map.of(
 *                 "logPublishingOptionsKey", LogPublishingOptionProperty.builder()
 *                         .cloudWatchLogsLogGroupArn("cloudWatchLogsLogGroupArn")
 *                         .enabled(false)
 *                         .build()))
 *         .nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsProperty.builder()
 *                 .enabled(false)
 *                 .build())
 *         .snapshotOptions(SnapshotOptionsProperty.builder()
 *                 .automatedSnapshotStartHour(123)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcOptions(VPCOptionsProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:52.196Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticsearch.CfnDomain")
public class CfnDomain extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.elasticsearch.IDomainRef, software.amazon.awscdk.ITaggable {

    protected CfnDomain(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDomain(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticsearch.CfnDomain.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::Elasticsearch::Domain</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDomain(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.CfnDomainProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new <code>AWS::Elasticsearch::Domain</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDomain(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the domain, such as <code>arn:aws:es:us-west-2:123456789012:domain/mystack-elasti-1ab2cdefghij</code> .
     * <p>
     * This returned value is the same as the one returned by <code>AWS::Elasticsearch::Domain.DomainArn</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The domain-specific endpoint that's used for requests to the OpenSearch APIs, such as <code>search-mystack-elasti-1ab2cdefghij-ab1c2deckoyb3hofw7wpqa3cm.us-west-1.es.amazonaws.com</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDomainEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "attrDomainEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a Domain resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.elasticsearch.DomainReference getDomainRef() {
        return software.amazon.jsii.Kernel.get(this, "domainRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.elasticsearch.DomainReference.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * An AWS Identity and Access Management ( IAM ) policy document that specifies who can access the OpenSearch Service domain and their permissions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAccessPolicies() {
        return software.amazon.jsii.Kernel.get(this, "accessPolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An AWS Identity and Access Management ( IAM ) policy document that specifies who can access the OpenSearch Service domain and their permissions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessPolicies(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "accessPolicies", value);
    }

    /**
     * Additional options to specify for the OpenSearch Service domain.
     * <p>
     * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedOptions() {
        return software.amazon.jsii.Kernel.get(this, "advancedOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Additional options to specify for the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdvancedOptions(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "advancedOptions", value);
    }

    /**
     * Additional options to specify for the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdvancedOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "advancedOptions", value);
    }

    /**
     * Specifies options for fine-grained access control.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.elasticsearch.CfnDomain.AdvancedSecurityOptionsInputProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedSecurityOptions() {
        return software.amazon.jsii.Kernel.get(this, "advancedSecurityOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies options for fine-grained access control.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdvancedSecurityOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "advancedSecurityOptions", value);
    }

    /**
     * Specifies options for fine-grained access control.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdvancedSecurityOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.CfnDomain.AdvancedSecurityOptionsInputProperty value) {
        software.amazon.jsii.Kernel.set(this, "advancedSecurityOptions", value);
    }

    /**
     * Configures OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.elasticsearch.CfnDomain.CognitoOptionsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCognitoOptions() {
        return software.amazon.jsii.Kernel.get(this, "cognitoOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configures OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCognitoOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cognitoOptions", value);
    }

    /**
     * Configures OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCognitoOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.CfnDomain.CognitoOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "cognitoOptions", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomainArn() {
        return software.amazon.jsii.Kernel.get(this, "domainArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainArn", value);
    }

    /**
     * Specifies additional options for the domain endpoint, such as whether to require HTTPS for all traffic or whether to use a custom endpoint rather than the default endpoint.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.elasticsearch.CfnDomain.DomainEndpointOptionsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDomainEndpointOptions() {
        return software.amazon.jsii.Kernel.get(this, "domainEndpointOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies additional options for the domain endpoint, such as whether to require HTTPS for all traffic or whether to use a custom endpoint rather than the default endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainEndpointOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "domainEndpointOptions", value);
    }

    /**
     * Specifies additional options for the domain endpoint, such as whether to require HTTPS for all traffic or whether to use a custom endpoint rather than the default endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainEndpointOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.CfnDomain.DomainEndpointOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "domainEndpointOptions", value);
    }

    /**
     * A name for the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainName", value);
    }

    /**
     * The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the OpenSearch Service domain.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.elasticsearch.CfnDomain.EBSOptionsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEbsOptions() {
        return software.amazon.jsii.Kernel.get(this, "ebsOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEbsOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ebsOptions", value);
    }

    /**
     * The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEbsOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.CfnDomain.EBSOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "ebsOptions", value);
    }

    /**
     * ElasticsearchClusterConfig is a property of the AWS::Elasticsearch::Domain resource that configures the cluster of an Amazon OpenSearch Service domain.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.elasticsearch.CfnDomain.ElasticsearchClusterConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getElasticsearchClusterConfig() {
        return software.amazon.jsii.Kernel.get(this, "elasticsearchClusterConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * ElasticsearchClusterConfig is a property of the AWS::Elasticsearch::Domain resource that configures the cluster of an Amazon OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticsearchClusterConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "elasticsearchClusterConfig", value);
    }

    /**
     * ElasticsearchClusterConfig is a property of the AWS::Elasticsearch::Domain resource that configures the cluster of an Amazon OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticsearchClusterConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.CfnDomain.ElasticsearchClusterConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "elasticsearchClusterConfig", value);
    }

    /**
     * The version of Elasticsearch to use, such as 2.3. If not specified, 1.5 is used as the default. For information about the versions that OpenSearch Service supports, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/what-is.html#choosing-version">Supported versions of OpenSearch and Elasticsearch</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getElasticsearchVersion() {
        return software.amazon.jsii.Kernel.get(this, "elasticsearchVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of Elasticsearch to use, such as 2.3. If not specified, 1.5 is used as the default. For information about the versions that OpenSearch Service supports, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/what-is.html#choosing-version">Supported versions of OpenSearch and Elasticsearch</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticsearchVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "elasticsearchVersion", value);
    }

    /**
     * Whether the domain should encrypt data at rest, and if so, the AWS Key Management Service key to use.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.elasticsearch.CfnDomain.EncryptionAtRestOptionsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionAtRestOptions() {
        return software.amazon.jsii.Kernel.get(this, "encryptionAtRestOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Whether the domain should encrypt data at rest, and if so, the AWS Key Management Service key to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionAtRestOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "encryptionAtRestOptions", value);
    }

    /**
     * Whether the domain should encrypt data at rest, and if so, the AWS Key Management Service key to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionAtRestOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.CfnDomain.EncryptionAtRestOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "encryptionAtRestOptions", value);
    }

    /**
     * An object with one or more of the following keys: <code>SEARCH_SLOW_LOGS</code> , <code>ES_APPLICATION_LOGS</code> , <code>INDEX_SLOW_LOGS</code> , <code>AUDIT_LOGS</code> , depending on the types of logs you want to publish.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or Map<String, either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.elasticsearch.CfnDomain.LogPublishingOptionProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogPublishingOptions() {
        return software.amazon.jsii.Kernel.get(this, "logPublishingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object with one or more of the following keys: <code>SEARCH_SLOW_LOGS</code> , <code>ES_APPLICATION_LOGS</code> , <code>INDEX_SLOW_LOGS</code> , <code>AUDIT_LOGS</code> , depending on the types of logs you want to publish.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogPublishingOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "logPublishingOptions", value);
    }

    /**
     * An object with one or more of the following keys: <code>SEARCH_SLOW_LOGS</code> , <code>ES_APPLICATION_LOGS</code> , <code>INDEX_SLOW_LOGS</code> , <code>AUDIT_LOGS</code> , depending on the types of logs you want to publish.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogPublishingOptions(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.elasticsearch.CfnDomain.LogPublishingOptionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.elasticsearch.CfnDomain.LogPublishingOptionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "logPublishingOptions", value);
    }

    /**
     * Specifies whether node-to-node encryption is enabled.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.elasticsearch.CfnDomain.NodeToNodeEncryptionOptionsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNodeToNodeEncryptionOptions() {
        return software.amazon.jsii.Kernel.get(this, "nodeToNodeEncryptionOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether node-to-node encryption is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNodeToNodeEncryptionOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "nodeToNodeEncryptionOptions", value);
    }

    /**
     * Specifies whether node-to-node encryption is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNodeToNodeEncryptionOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.CfnDomain.NodeToNodeEncryptionOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "nodeToNodeEncryptionOptions", value);
    }

    /**
     * <em>DEPRECATED</em> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.elasticsearch.CfnDomain.SnapshotOptionsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSnapshotOptions() {
        return software.amazon.jsii.Kernel.get(this, "snapshotOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * <em>DEPRECATED</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "snapshotOptions", value);
    }

    /**
     * <em>DEPRECATED</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.CfnDomain.SnapshotOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "snapshotOptions", value);
    }

    /**
     * An arbitrary set of tags (key–value pairs) to associate with the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An arbitrary set of tags (key–value pairs) to associate with the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The virtual private cloud (VPC) configuration for the OpenSearch Service domain.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.elasticsearch.CfnDomain.VPCOptionsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpcOptions() {
        return software.amazon.jsii.Kernel.get(this, "vpcOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The virtual private cloud (VPC) configuration for the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpcOptions", value);
    }

    /**
     * The virtual private cloud (VPC) configuration for the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticsearch.CfnDomain.VPCOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "vpcOptions", value);
    }
    /**
     * Specifies options for fine-grained access control.
     * <p>
     * <blockquote>
     * <p>
     * The <code>AWS::Elasticsearch::Domain</code> resource is being replaced by the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html">AWS::OpenSearchService::Domain</a> resource. While the legacy Elasticsearch resource and options are still supported, we recommend modifying your existing Cloudformation templates to use the new OpenSearch Service resource, which supports both OpenSearch and Elasticsearch. For more information about the service rename, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/rename.html#rename-resource">New resource types</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticsearch.*;
     * AdvancedSecurityOptionsInputProperty advancedSecurityOptionsInputProperty = AdvancedSecurityOptionsInputProperty.builder()
     *         .anonymousAuthEnabled(false)
     *         .enabled(false)
     *         .internalUserDatabaseEnabled(false)
     *         .masterUserOptions(MasterUserOptionsProperty.builder()
     *                 .masterUserArn("masterUserArn")
     *                 .masterUserName("masterUserName")
     *                 .masterUserPassword("masterUserPassword")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-advancedsecurityoptionsinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-advancedsecurityoptionsinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticsearch.CfnDomain.AdvancedSecurityOptionsInputProperty")
    @software.amazon.jsii.Jsii.Proxy(AdvancedSecurityOptionsInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdvancedSecurityOptionsInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-advancedsecurityoptionsinput.html#cfn-elasticsearch-domain-advancedsecurityoptionsinput-anonymousauthenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-advancedsecurityoptionsinput.html#cfn-elasticsearch-domain-advancedsecurityoptionsinput-anonymousauthenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAnonymousAuthEnabled() {
            return null;
        }

        /**
         * True to enable fine-grained access control.
         * <p>
         * You must also enable encryption of data at rest and node-to-node encryption.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-advancedsecurityoptionsinput.html#cfn-elasticsearch-domain-advancedsecurityoptionsinput-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-advancedsecurityoptionsinput.html#cfn-elasticsearch-domain-advancedsecurityoptionsinput-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * True to enable the internal user database.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-advancedsecurityoptionsinput.html#cfn-elasticsearch-domain-advancedsecurityoptionsinput-internaluserdatabaseenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-advancedsecurityoptionsinput.html#cfn-elasticsearch-domain-advancedsecurityoptionsinput-internaluserdatabaseenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInternalUserDatabaseEnabled() {
            return null;
        }

        /**
         * Specifies information about the master user.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.elasticsearch.CfnDomain.MasterUserOptionsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-advancedsecurityoptionsinput.html#cfn-elasticsearch-domain-advancedsecurityoptionsinput-masteruseroptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-advancedsecurityoptionsinput.html#cfn-elasticsearch-domain-advancedsecurityoptionsinput-masteruseroptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMasterUserOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdvancedSecurityOptionsInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdvancedSecurityOptionsInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdvancedSecurityOptionsInputProperty> {
            java.lang.Object anonymousAuthEnabled;
            java.lang.Object enabled;
            java.lang.Object internalUserDatabaseEnabled;
            java.lang.Object masterUserOptions;

            /**
             * Sets the value of {@link AdvancedSecurityOptionsInputProperty#getAnonymousAuthEnabled}
             * @param anonymousAuthEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder anonymousAuthEnabled(java.lang.Boolean anonymousAuthEnabled) {
                this.anonymousAuthEnabled = anonymousAuthEnabled;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedSecurityOptionsInputProperty#getAnonymousAuthEnabled}
             * @param anonymousAuthEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder anonymousAuthEnabled(software.amazon.awscdk.IResolvable anonymousAuthEnabled) {
                this.anonymousAuthEnabled = anonymousAuthEnabled;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedSecurityOptionsInputProperty#getEnabled}
             * @param enabled True to enable fine-grained access control.
             *                You must also enable encryption of data at rest and node-to-node encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedSecurityOptionsInputProperty#getEnabled}
             * @param enabled True to enable fine-grained access control.
             *                You must also enable encryption of data at rest and node-to-node encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedSecurityOptionsInputProperty#getInternalUserDatabaseEnabled}
             * @param internalUserDatabaseEnabled True to enable the internal user database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder internalUserDatabaseEnabled(java.lang.Boolean internalUserDatabaseEnabled) {
                this.internalUserDatabaseEnabled = internalUserDatabaseEnabled;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedSecurityOptionsInputProperty#getInternalUserDatabaseEnabled}
             * @param internalUserDatabaseEnabled True to enable the internal user database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder internalUserDatabaseEnabled(software.amazon.awscdk.IResolvable internalUserDatabaseEnabled) {
                this.internalUserDatabaseEnabled = internalUserDatabaseEnabled;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedSecurityOptionsInputProperty#getMasterUserOptions}
             * @param masterUserOptions Specifies information about the master user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder masterUserOptions(software.amazon.awscdk.IResolvable masterUserOptions) {
                this.masterUserOptions = masterUserOptions;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedSecurityOptionsInputProperty#getMasterUserOptions}
             * @param masterUserOptions Specifies information about the master user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder masterUserOptions(software.amazon.awscdk.services.elasticsearch.CfnDomain.MasterUserOptionsProperty masterUserOptions) {
                this.masterUserOptions = masterUserOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdvancedSecurityOptionsInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdvancedSecurityOptionsInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdvancedSecurityOptionsInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdvancedSecurityOptionsInputProperty {
            private final java.lang.Object anonymousAuthEnabled;
            private final java.lang.Object enabled;
            private final java.lang.Object internalUserDatabaseEnabled;
            private final java.lang.Object masterUserOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.anonymousAuthEnabled = software.amazon.jsii.Kernel.get(this, "anonymousAuthEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.internalUserDatabaseEnabled = software.amazon.jsii.Kernel.get(this, "internalUserDatabaseEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.masterUserOptions = software.amazon.jsii.Kernel.get(this, "masterUserOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.anonymousAuthEnabled = builder.anonymousAuthEnabled;
                this.enabled = builder.enabled;
                this.internalUserDatabaseEnabled = builder.internalUserDatabaseEnabled;
                this.masterUserOptions = builder.masterUserOptions;
            }

            @Override
            public final java.lang.Object getAnonymousAuthEnabled() {
                return this.anonymousAuthEnabled;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getInternalUserDatabaseEnabled() {
                return this.internalUserDatabaseEnabled;
            }

            @Override
            public final java.lang.Object getMasterUserOptions() {
                return this.masterUserOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAnonymousAuthEnabled() != null) {
                    data.set("anonymousAuthEnabled", om.valueToTree(this.getAnonymousAuthEnabled()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getInternalUserDatabaseEnabled() != null) {
                    data.set("internalUserDatabaseEnabled", om.valueToTree(this.getInternalUserDatabaseEnabled()));
                }
                if (this.getMasterUserOptions() != null) {
                    data.set("masterUserOptions", om.valueToTree(this.getMasterUserOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticsearch.CfnDomain.AdvancedSecurityOptionsInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdvancedSecurityOptionsInputProperty.Jsii$Proxy that = (AdvancedSecurityOptionsInputProperty.Jsii$Proxy) o;

                if (this.anonymousAuthEnabled != null ? !this.anonymousAuthEnabled.equals(that.anonymousAuthEnabled) : that.anonymousAuthEnabled != null) return false;
                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.internalUserDatabaseEnabled != null ? !this.internalUserDatabaseEnabled.equals(that.internalUserDatabaseEnabled) : that.internalUserDatabaseEnabled != null) return false;
                return this.masterUserOptions != null ? this.masterUserOptions.equals(that.masterUserOptions) : that.masterUserOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.anonymousAuthEnabled != null ? this.anonymousAuthEnabled.hashCode() : 0;
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                result = 31 * result + (this.internalUserDatabaseEnabled != null ? this.internalUserDatabaseEnabled.hashCode() : 0);
                result = 31 * result + (this.masterUserOptions != null ? this.masterUserOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configures OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards.
     * <p>
     * <blockquote>
     * <p>
     * The <code>AWS::Elasticsearch::Domain</code> resource is being replaced by the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html">AWS::OpenSearchService::Domain</a> resource. While the legacy Elasticsearch resource and options are still supported, we recommend modifying your existing Cloudformation templates to use the new OpenSearch Service resource, which supports both OpenSearch and Elasticsearch. For more information about the service rename, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/rename.html#rename-resource">New resource types</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticsearch.*;
     * CognitoOptionsProperty cognitoOptionsProperty = CognitoOptionsProperty.builder()
     *         .enabled(false)
     *         .identityPoolId("identityPoolId")
     *         .roleArn("roleArn")
     *         .userPoolId("userPoolId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticsearch.CfnDomain.CognitoOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(CognitoOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CognitoOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether to enable or disable Amazon Cognito authentication for OpenSearch Dashboards.
         * <p>
         * See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html">Amazon Cognito authentication for OpenSearch Dashboards</a> .
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html#cfn-elasticsearch-domain-cognitooptions-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html#cfn-elasticsearch-domain-cognitooptions-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The Amazon Cognito identity pool ID that you want OpenSearch Service to use for OpenSearch Dashboards authentication.
         * <p>
         * Required if you enable Cognito authentication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html#cfn-elasticsearch-domain-cognitooptions-identitypoolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html#cfn-elasticsearch-domain-cognitooptions-identitypoolid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIdentityPoolId() {
            return null;
        }

        /**
         * The <code>AmazonESCognitoAccess</code> role that allows OpenSearch Service to configure your user pool and identity pool.
         * <p>
         * Required if you enable Cognito authentication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html#cfn-elasticsearch-domain-cognitooptions-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html#cfn-elasticsearch-domain-cognitooptions-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * The Amazon Cognito user pool ID that you want OpenSearch Service to use for OpenSearch Dashboards authentication.
         * <p>
         * Required if you enable Cognito authentication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html#cfn-elasticsearch-domain-cognitooptions-userpoolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html#cfn-elasticsearch-domain-cognitooptions-userpoolid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserPoolId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CognitoOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CognitoOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CognitoOptionsProperty> {
            java.lang.Object enabled;
            java.lang.String identityPoolId;
            java.lang.String roleArn;
            java.lang.String userPoolId;

            /**
             * Sets the value of {@link CognitoOptionsProperty#getEnabled}
             * @param enabled Whether to enable or disable Amazon Cognito authentication for OpenSearch Dashboards.
             *                See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html">Amazon Cognito authentication for OpenSearch Dashboards</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link CognitoOptionsProperty#getEnabled}
             * @param enabled Whether to enable or disable Amazon Cognito authentication for OpenSearch Dashboards.
             *                See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html">Amazon Cognito authentication for OpenSearch Dashboards</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link CognitoOptionsProperty#getIdentityPoolId}
             * @param identityPoolId The Amazon Cognito identity pool ID that you want OpenSearch Service to use for OpenSearch Dashboards authentication.
             *                       Required if you enable Cognito authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identityPoolId(java.lang.String identityPoolId) {
                this.identityPoolId = identityPoolId;
                return this;
            }

            /**
             * Sets the value of {@link CognitoOptionsProperty#getRoleArn}
             * @param roleArn The <code>AmazonESCognitoAccess</code> role that allows OpenSearch Service to configure your user pool and identity pool.
             *                Required if you enable Cognito authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link CognitoOptionsProperty#getUserPoolId}
             * @param userPoolId The Amazon Cognito user pool ID that you want OpenSearch Service to use for OpenSearch Dashboards authentication.
             *                   Required if you enable Cognito authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolId(java.lang.String userPoolId) {
                this.userPoolId = userPoolId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CognitoOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CognitoOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CognitoOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CognitoOptionsProperty {
            private final java.lang.Object enabled;
            private final java.lang.String identityPoolId;
            private final java.lang.String roleArn;
            private final java.lang.String userPoolId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.identityPoolId = software.amazon.jsii.Kernel.get(this, "identityPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userPoolId = software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.identityPoolId = builder.identityPoolId;
                this.roleArn = builder.roleArn;
                this.userPoolId = builder.userPoolId;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getIdentityPoolId() {
                return this.identityPoolId;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getUserPoolId() {
                return this.userPoolId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getIdentityPoolId() != null) {
                    data.set("identityPoolId", om.valueToTree(this.getIdentityPoolId()));
                }
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }
                if (this.getUserPoolId() != null) {
                    data.set("userPoolId", om.valueToTree(this.getUserPoolId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticsearch.CfnDomain.CognitoOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CognitoOptionsProperty.Jsii$Proxy that = (CognitoOptionsProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.identityPoolId != null ? !this.identityPoolId.equals(that.identityPoolId) : that.identityPoolId != null) return false;
                if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
                return this.userPoolId != null ? this.userPoolId.equals(that.userPoolId) : that.userPoolId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.identityPoolId != null ? this.identityPoolId.hashCode() : 0);
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                result = 31 * result + (this.userPoolId != null ? this.userPoolId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies options for cold storage. For more information, see <a href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/cold-storage.html">Cold storage for Amazon Elasticsearch Service</a> .
     * <p>
     * <blockquote>
     * <p>
     * The <code>AWS::Elasticsearch::Domain</code> resource is being replaced by the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html">AWS::OpenSearchService::Domain</a> resource. While the legacy Elasticsearch resource and options are still supported, we recommend modifying your existing Cloudformation templates to use the new OpenSearch Service resource, which supports both OpenSearch and Elasticsearch. For more information about the service rename, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/rename.html#rename-resource">New resource types</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticsearch.*;
     * ColdStorageOptionsProperty coldStorageOptionsProperty = ColdStorageOptionsProperty.builder()
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-coldstorageoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-coldstorageoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticsearch.CfnDomain.ColdStorageOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ColdStorageOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColdStorageOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether to enable or disable cold storage on the domain.
         * <p>
         * You must enable UltraWarm storage in order to enable cold storage.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-coldstorageoptions.html#cfn-elasticsearch-domain-coldstorageoptions-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-coldstorageoptions.html#cfn-elasticsearch-domain-coldstorageoptions-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColdStorageOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColdStorageOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColdStorageOptionsProperty> {
            java.lang.Object enabled;

            /**
             * Sets the value of {@link ColdStorageOptionsProperty#getEnabled}
             * @param enabled Whether to enable or disable cold storage on the domain.
             *                You must enable UltraWarm storage in order to enable cold storage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ColdStorageOptionsProperty#getEnabled}
             * @param enabled Whether to enable or disable cold storage on the domain.
             *                You must enable UltraWarm storage in order to enable cold storage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColdStorageOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColdStorageOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColdStorageOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColdStorageOptionsProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticsearch.CfnDomain.ColdStorageOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColdStorageOptionsProperty.Jsii$Proxy that = (ColdStorageOptionsProperty.Jsii$Proxy) o;

                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies additional options for the domain endpoint, such as whether to require HTTPS for all traffic or whether to use a custom endpoint rather than the default endpoint.
     * <p>
     * <blockquote>
     * <p>
     * The <code>AWS::Elasticsearch::Domain</code> resource is being replaced by the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html">AWS::OpenSearchService::Domain</a> resource. While the legacy Elasticsearch resource and options are still supported, we recommend modifying your existing Cloudformation templates to use the new OpenSearch Service resource, which supports both OpenSearch and Elasticsearch. For more information about the service rename, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/rename.html#rename-resource">New resource types</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticsearch.*;
     * DomainEndpointOptionsProperty domainEndpointOptionsProperty = DomainEndpointOptionsProperty.builder()
     *         .customEndpoint("customEndpoint")
     *         .customEndpointCertificateArn("customEndpointCertificateArn")
     *         .customEndpointEnabled(false)
     *         .enforceHttps(false)
     *         .tlsSecurityPolicy("tlsSecurityPolicy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-domainendpointoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-domainendpointoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticsearch.CfnDomain.DomainEndpointOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(DomainEndpointOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DomainEndpointOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The fully qualified URL for your custom endpoint.
         * <p>
         * Required if you enabled a custom endpoint for the domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-domainendpointoptions.html#cfn-elasticsearch-domain-domainendpointoptions-customendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-domainendpointoptions.html#cfn-elasticsearch-domain-domainendpointoptions-customendpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomEndpoint() {
            return null;
        }

        /**
         * The Certificate Manager ARN for your domain's SSL/TLS certificate.
         * <p>
         * Required if you enabled a custom endpoint for the domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-domainendpointoptions.html#cfn-elasticsearch-domain-domainendpointoptions-customendpointcertificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-domainendpointoptions.html#cfn-elasticsearch-domain-domainendpointoptions-customendpointcertificatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomEndpointCertificateArn() {
            return null;
        }

        /**
         * True to enable a custom endpoint for the domain.
         * <p>
         * If enabled, you must also provide values for <code>CustomEndpoint</code> and <code>CustomEndpointCertificateArn</code> .
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-domainendpointoptions.html#cfn-elasticsearch-domain-domainendpointoptions-customendpointenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-domainendpointoptions.html#cfn-elasticsearch-domain-domainendpointoptions-customendpointenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomEndpointEnabled() {
            return null;
        }

        /**
         * True to require that all traffic to the domain arrive over HTTPS.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-domainendpointoptions.html#cfn-elasticsearch-domain-domainendpointoptions-enforcehttps">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-domainendpointoptions.html#cfn-elasticsearch-domain-domainendpointoptions-enforcehttps</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnforceHttps() {
            return null;
        }

        /**
         * The minimum TLS version required for traffic to the domain. Valid values are TLS 1.3 (recommended) or 1.2:.
         * <p>
         * <ul>
         * <li><code>Policy-Min-TLS-1-0-2019-07</code></li>
         * <li><code>Policy-Min-TLS-1-2-2019-07</code></li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-domainendpointoptions.html#cfn-elasticsearch-domain-domainendpointoptions-tlssecuritypolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-domainendpointoptions.html#cfn-elasticsearch-domain-domainendpointoptions-tlssecuritypolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTlsSecurityPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DomainEndpointOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DomainEndpointOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DomainEndpointOptionsProperty> {
            java.lang.String customEndpoint;
            java.lang.String customEndpointCertificateArn;
            java.lang.Object customEndpointEnabled;
            java.lang.Object enforceHttps;
            java.lang.String tlsSecurityPolicy;

            /**
             * Sets the value of {@link DomainEndpointOptionsProperty#getCustomEndpoint}
             * @param customEndpoint The fully qualified URL for your custom endpoint.
             *                       Required if you enabled a custom endpoint for the domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customEndpoint(java.lang.String customEndpoint) {
                this.customEndpoint = customEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link DomainEndpointOptionsProperty#getCustomEndpointCertificateArn}
             * @param customEndpointCertificateArn The Certificate Manager ARN for your domain's SSL/TLS certificate.
             *                                     Required if you enabled a custom endpoint for the domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customEndpointCertificateArn(java.lang.String customEndpointCertificateArn) {
                this.customEndpointCertificateArn = customEndpointCertificateArn;
                return this;
            }

            /**
             * Sets the value of {@link DomainEndpointOptionsProperty#getCustomEndpointEnabled}
             * @param customEndpointEnabled True to enable a custom endpoint for the domain.
             *                              If enabled, you must also provide values for <code>CustomEndpoint</code> and <code>CustomEndpointCertificateArn</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customEndpointEnabled(java.lang.Boolean customEndpointEnabled) {
                this.customEndpointEnabled = customEndpointEnabled;
                return this;
            }

            /**
             * Sets the value of {@link DomainEndpointOptionsProperty#getCustomEndpointEnabled}
             * @param customEndpointEnabled True to enable a custom endpoint for the domain.
             *                              If enabled, you must also provide values for <code>CustomEndpoint</code> and <code>CustomEndpointCertificateArn</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customEndpointEnabled(software.amazon.awscdk.IResolvable customEndpointEnabled) {
                this.customEndpointEnabled = customEndpointEnabled;
                return this;
            }

            /**
             * Sets the value of {@link DomainEndpointOptionsProperty#getEnforceHttps}
             * @param enforceHttps True to require that all traffic to the domain arrive over HTTPS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enforceHttps(java.lang.Boolean enforceHttps) {
                this.enforceHttps = enforceHttps;
                return this;
            }

            /**
             * Sets the value of {@link DomainEndpointOptionsProperty#getEnforceHttps}
             * @param enforceHttps True to require that all traffic to the domain arrive over HTTPS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enforceHttps(software.amazon.awscdk.IResolvable enforceHttps) {
                this.enforceHttps = enforceHttps;
                return this;
            }

            /**
             * Sets the value of {@link DomainEndpointOptionsProperty#getTlsSecurityPolicy}
             * @param tlsSecurityPolicy The minimum TLS version required for traffic to the domain. Valid values are TLS 1.3 (recommended) or 1.2:.
             *                          <ul>
             *                          <li><code>Policy-Min-TLS-1-0-2019-07</code></li>
             *                          <li><code>Policy-Min-TLS-1-2-2019-07</code></li>
             *                          </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tlsSecurityPolicy(java.lang.String tlsSecurityPolicy) {
                this.tlsSecurityPolicy = tlsSecurityPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DomainEndpointOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DomainEndpointOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DomainEndpointOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainEndpointOptionsProperty {
            private final java.lang.String customEndpoint;
            private final java.lang.String customEndpointCertificateArn;
            private final java.lang.Object customEndpointEnabled;
            private final java.lang.Object enforceHttps;
            private final java.lang.String tlsSecurityPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customEndpoint = software.amazon.jsii.Kernel.get(this, "customEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customEndpointCertificateArn = software.amazon.jsii.Kernel.get(this, "customEndpointCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customEndpointEnabled = software.amazon.jsii.Kernel.get(this, "customEndpointEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enforceHttps = software.amazon.jsii.Kernel.get(this, "enforceHttps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tlsSecurityPolicy = software.amazon.jsii.Kernel.get(this, "tlsSecurityPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customEndpoint = builder.customEndpoint;
                this.customEndpointCertificateArn = builder.customEndpointCertificateArn;
                this.customEndpointEnabled = builder.customEndpointEnabled;
                this.enforceHttps = builder.enforceHttps;
                this.tlsSecurityPolicy = builder.tlsSecurityPolicy;
            }

            @Override
            public final java.lang.String getCustomEndpoint() {
                return this.customEndpoint;
            }

            @Override
            public final java.lang.String getCustomEndpointCertificateArn() {
                return this.customEndpointCertificateArn;
            }

            @Override
            public final java.lang.Object getCustomEndpointEnabled() {
                return this.customEndpointEnabled;
            }

            @Override
            public final java.lang.Object getEnforceHttps() {
                return this.enforceHttps;
            }

            @Override
            public final java.lang.String getTlsSecurityPolicy() {
                return this.tlsSecurityPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomEndpoint() != null) {
                    data.set("customEndpoint", om.valueToTree(this.getCustomEndpoint()));
                }
                if (this.getCustomEndpointCertificateArn() != null) {
                    data.set("customEndpointCertificateArn", om.valueToTree(this.getCustomEndpointCertificateArn()));
                }
                if (this.getCustomEndpointEnabled() != null) {
                    data.set("customEndpointEnabled", om.valueToTree(this.getCustomEndpointEnabled()));
                }
                if (this.getEnforceHttps() != null) {
                    data.set("enforceHttps", om.valueToTree(this.getEnforceHttps()));
                }
                if (this.getTlsSecurityPolicy() != null) {
                    data.set("tlsSecurityPolicy", om.valueToTree(this.getTlsSecurityPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticsearch.CfnDomain.DomainEndpointOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DomainEndpointOptionsProperty.Jsii$Proxy that = (DomainEndpointOptionsProperty.Jsii$Proxy) o;

                if (this.customEndpoint != null ? !this.customEndpoint.equals(that.customEndpoint) : that.customEndpoint != null) return false;
                if (this.customEndpointCertificateArn != null ? !this.customEndpointCertificateArn.equals(that.customEndpointCertificateArn) : that.customEndpointCertificateArn != null) return false;
                if (this.customEndpointEnabled != null ? !this.customEndpointEnabled.equals(that.customEndpointEnabled) : that.customEndpointEnabled != null) return false;
                if (this.enforceHttps != null ? !this.enforceHttps.equals(that.enforceHttps) : that.enforceHttps != null) return false;
                return this.tlsSecurityPolicy != null ? this.tlsSecurityPolicy.equals(that.tlsSecurityPolicy) : that.tlsSecurityPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customEndpoint != null ? this.customEndpoint.hashCode() : 0;
                result = 31 * result + (this.customEndpointCertificateArn != null ? this.customEndpointCertificateArn.hashCode() : 0);
                result = 31 * result + (this.customEndpointEnabled != null ? this.customEndpointEnabled.hashCode() : 0);
                result = 31 * result + (this.enforceHttps != null ? this.enforceHttps.hashCode() : 0);
                result = 31 * result + (this.tlsSecurityPolicy != null ? this.tlsSecurityPolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the OpenSearch Service domain.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/limits.html#ebsresource">EBS volume size limits</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * The <code>AWS::Elasticsearch::Domain</code> resource is being replaced by the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html">AWS::OpenSearchService::Domain</a> resource. While the legacy Elasticsearch resource and options are still supported, we recommend modifying your existing Cloudformation templates to use the new OpenSearch Service resource, which supports both OpenSearch and Elasticsearch. For more information about the service rename, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/rename.html#rename-resource">New resource types</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticsearch.*;
     * EBSOptionsProperty eBSOptionsProperty = EBSOptionsProperty.builder()
     *         .ebsEnabled(false)
     *         .iops(123)
     *         .volumeSize(123)
     *         .volumeType("volumeType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticsearch.CfnDomain.EBSOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(EBSOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EBSOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether Amazon EBS volumes are attached to data nodes in the OpenSearch Service domain.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html#cfn-elasticsearch-domain-ebsoptions-ebsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html#cfn-elasticsearch-domain-ebsoptions-ebsenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbsEnabled() {
            return null;
        }

        /**
         * The number of I/O operations per second (IOPS) that the volume supports.
         * <p>
         * This property applies only to provisioned IOPS EBS volume types.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html#cfn-elasticsearch-domain-ebsoptions-iops">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html#cfn-elasticsearch-domain-ebsoptions-iops</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
            return null;
        }

        /**
         * The size (in GiB) of the EBS volume for each data node.
         * <p>
         * The minimum and maximum size of an EBS volume depends on the EBS volume type and the instance type to which it is attached. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/limits.html#ebsresource">EBS volume size limits</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html#cfn-elasticsearch-domain-ebsoptions-volumesize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html#cfn-elasticsearch-domain-ebsoptions-volumesize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVolumeSize() {
            return null;
        }

        /**
         * The EBS volume type to use with the OpenSearch Service domain, such as standard, gp2, or io1.
         * <p>
         * For more information about each type, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html#cfn-elasticsearch-domain-ebsoptions-volumetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html#cfn-elasticsearch-domain-ebsoptions-volumetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVolumeType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EBSOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EBSOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EBSOptionsProperty> {
            java.lang.Object ebsEnabled;
            java.lang.Number iops;
            java.lang.Number volumeSize;
            java.lang.String volumeType;

            /**
             * Sets the value of {@link EBSOptionsProperty#getEbsEnabled}
             * @param ebsEnabled Specifies whether Amazon EBS volumes are attached to data nodes in the OpenSearch Service domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsEnabled(java.lang.Boolean ebsEnabled) {
                this.ebsEnabled = ebsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link EBSOptionsProperty#getEbsEnabled}
             * @param ebsEnabled Specifies whether Amazon EBS volumes are attached to data nodes in the OpenSearch Service domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsEnabled(software.amazon.awscdk.IResolvable ebsEnabled) {
                this.ebsEnabled = ebsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link EBSOptionsProperty#getIops}
             * @param iops The number of I/O operations per second (IOPS) that the volume supports.
             *             This property applies only to provisioned IOPS EBS volume types.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Sets the value of {@link EBSOptionsProperty#getVolumeSize}
             * @param volumeSize The size (in GiB) of the EBS volume for each data node.
             *                   The minimum and maximum size of an EBS volume depends on the EBS volume type and the instance type to which it is attached. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/limits.html#ebsresource">EBS volume size limits</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSize(java.lang.Number volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            /**
             * Sets the value of {@link EBSOptionsProperty#getVolumeType}
             * @param volumeType The EBS volume type to use with the OpenSearch Service domain, such as standard, gp2, or io1.
             *                   For more information about each type, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeType(java.lang.String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EBSOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EBSOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EBSOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EBSOptionsProperty {
            private final java.lang.Object ebsEnabled;
            private final java.lang.Number iops;
            private final java.lang.Number volumeSize;
            private final java.lang.String volumeType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ebsEnabled = software.amazon.jsii.Kernel.get(this, "ebsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumeSize = software.amazon.jsii.Kernel.get(this, "volumeSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumeType = software.amazon.jsii.Kernel.get(this, "volumeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ebsEnabled = builder.ebsEnabled;
                this.iops = builder.iops;
                this.volumeSize = builder.volumeSize;
                this.volumeType = builder.volumeType;
            }

            @Override
            public final java.lang.Object getEbsEnabled() {
                return this.ebsEnabled;
            }

            @Override
            public final java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            public final java.lang.Number getVolumeSize() {
                return this.volumeSize;
            }

            @Override
            public final java.lang.String getVolumeType() {
                return this.volumeType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEbsEnabled() != null) {
                    data.set("ebsEnabled", om.valueToTree(this.getEbsEnabled()));
                }
                if (this.getIops() != null) {
                    data.set("iops", om.valueToTree(this.getIops()));
                }
                if (this.getVolumeSize() != null) {
                    data.set("volumeSize", om.valueToTree(this.getVolumeSize()));
                }
                if (this.getVolumeType() != null) {
                    data.set("volumeType", om.valueToTree(this.getVolumeType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticsearch.CfnDomain.EBSOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EBSOptionsProperty.Jsii$Proxy that = (EBSOptionsProperty.Jsii$Proxy) o;

                if (this.ebsEnabled != null ? !this.ebsEnabled.equals(that.ebsEnabled) : that.ebsEnabled != null) return false;
                if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
                if (this.volumeSize != null ? !this.volumeSize.equals(that.volumeSize) : that.volumeSize != null) return false;
                return this.volumeType != null ? this.volumeType.equals(that.volumeType) : that.volumeType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ebsEnabled != null ? this.ebsEnabled.hashCode() : 0;
                result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
                result = 31 * result + (this.volumeSize != null ? this.volumeSize.hashCode() : 0);
                result = 31 * result + (this.volumeType != null ? this.volumeType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The cluster configuration for the OpenSearch Service domain.
     * <p>
     * You can specify options such as the instance type and the number of instances. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html">Creating and managing Amazon OpenSearch Service domains</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * The <code>AWS::Elasticsearch::Domain</code> resource is being replaced by the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html">AWS::OpenSearchService::Domain</a> resource. While the legacy Elasticsearch resource and options are still supported, we recommend modifying your existing Cloudformation templates to use the new OpenSearch Service resource, which supports both OpenSearch and Elasticsearch. For more information about the service rename, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/rename.html#rename-resource">New resource types</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticsearch.*;
     * ElasticsearchClusterConfigProperty elasticsearchClusterConfigProperty = ElasticsearchClusterConfigProperty.builder()
     *         .coldStorageOptions(ColdStorageOptionsProperty.builder()
     *                 .enabled(false)
     *                 .build())
     *         .dedicatedMasterCount(123)
     *         .dedicatedMasterEnabled(false)
     *         .dedicatedMasterType("dedicatedMasterType")
     *         .instanceCount(123)
     *         .instanceType("instanceType")
     *         .warmCount(123)
     *         .warmEnabled(false)
     *         .warmType("warmType")
     *         .zoneAwarenessConfig(ZoneAwarenessConfigProperty.builder()
     *                 .availabilityZoneCount(123)
     *                 .build())
     *         .zoneAwarenessEnabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticsearch.CfnDomain.ElasticsearchClusterConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ElasticsearchClusterConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ElasticsearchClusterConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies cold storage options for the domain.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.elasticsearch.CfnDomain.ColdStorageOptionsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-coldstorageoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-coldstorageoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColdStorageOptions() {
            return null;
        }

        /**
         * The number of instances to use for the master node.
         * <p>
         * If you specify this property, you must specify true for the DedicatedMasterEnabled property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-dedicatedmastercount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-dedicatedmastercount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDedicatedMasterCount() {
            return null;
        }

        /**
         * Indicates whether to use a dedicated master node for the OpenSearch Service domain.
         * <p>
         * A dedicated master node is a cluster node that performs cluster management tasks, but doesn't hold data or respond to data upload requests. Dedicated master nodes offload cluster management tasks to increase the stability of your search clusters. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-dedicatedmasternodes.html">Dedicated master nodes in Amazon OpenSearch Service</a> .
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-dedicatedmasterenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-dedicatedmasterenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDedicatedMasterEnabled() {
            return null;
        }

        /**
         * The hardware configuration of the computer that hosts the dedicated master node, such as <code>m3.medium.elasticsearch</code> . If you specify this property, you must specify true for the <code>DedicatedMasterEnabled</code> property. For valid values, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html">Supported instance types in Amazon OpenSearch Service</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-dedicatedmastertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-dedicatedmastertype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDedicatedMasterType() {
            return null;
        }

        /**
         * The number of data nodes (instances) to use in the OpenSearch Service domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-instancecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-instancecount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInstanceCount() {
            return null;
        }

        /**
         * The instance type for your data nodes, such as <code>m3.medium.elasticsearch</code> . For valid values, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html">Supported instance types in Amazon OpenSearch Service</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-instancetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * The number of warm nodes in the cluster.
         * <p>
         * Required if you enable warm storage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-warmcount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-warmcount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWarmCount() {
            return null;
        }

        /**
         * Whether to enable warm storage for the cluster.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-warmenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-warmenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWarmEnabled() {
            return null;
        }

        /**
         * The instance type for the cluster's warm nodes.
         * <p>
         * Required if you enable warm storage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-warmtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-warmtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWarmType() {
            return null;
        }

        /**
         * Specifies zone awareness configuration options.
         * <p>
         * Only use if <code>ZoneAwarenessEnabled</code> is <code>true</code> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.elasticsearch.CfnDomain.ZoneAwarenessConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-zoneawarenessconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-zoneawarenessconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getZoneAwarenessConfig() {
            return null;
        }

        /**
         * Indicates whether to enable zone awareness for the OpenSearch Service domain.
         * <p>
         * When you enable zone awareness, OpenSearch Service allocates the nodes and replica index shards that belong to a cluster across two Availability Zones (AZs) in the same region to prevent data loss and minimize downtime in the event of node or data center failure. Don't enable zone awareness if your cluster has no replica index shards or is a single-node cluster. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html">Configuring a multi-AZ domain in Amazon OpenSearch Service</a> .
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-zoneawarenessenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-zoneawarenessenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getZoneAwarenessEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ElasticsearchClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElasticsearchClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ElasticsearchClusterConfigProperty> {
            java.lang.Object coldStorageOptions;
            java.lang.Number dedicatedMasterCount;
            java.lang.Object dedicatedMasterEnabled;
            java.lang.String dedicatedMasterType;
            java.lang.Number instanceCount;
            java.lang.String instanceType;
            java.lang.Number warmCount;
            java.lang.Object warmEnabled;
            java.lang.String warmType;
            java.lang.Object zoneAwarenessConfig;
            java.lang.Object zoneAwarenessEnabled;

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getColdStorageOptions}
             * @param coldStorageOptions Specifies cold storage options for the domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coldStorageOptions(software.amazon.awscdk.IResolvable coldStorageOptions) {
                this.coldStorageOptions = coldStorageOptions;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getColdStorageOptions}
             * @param coldStorageOptions Specifies cold storage options for the domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coldStorageOptions(software.amazon.awscdk.services.elasticsearch.CfnDomain.ColdStorageOptionsProperty coldStorageOptions) {
                this.coldStorageOptions = coldStorageOptions;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getDedicatedMasterCount}
             * @param dedicatedMasterCount The number of instances to use for the master node.
             *                             If you specify this property, you must specify true for the DedicatedMasterEnabled property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dedicatedMasterCount(java.lang.Number dedicatedMasterCount) {
                this.dedicatedMasterCount = dedicatedMasterCount;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getDedicatedMasterEnabled}
             * @param dedicatedMasterEnabled Indicates whether to use a dedicated master node for the OpenSearch Service domain.
             *                               A dedicated master node is a cluster node that performs cluster management tasks, but doesn't hold data or respond to data upload requests. Dedicated master nodes offload cluster management tasks to increase the stability of your search clusters. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-dedicatedmasternodes.html">Dedicated master nodes in Amazon OpenSearch Service</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dedicatedMasterEnabled(java.lang.Boolean dedicatedMasterEnabled) {
                this.dedicatedMasterEnabled = dedicatedMasterEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getDedicatedMasterEnabled}
             * @param dedicatedMasterEnabled Indicates whether to use a dedicated master node for the OpenSearch Service domain.
             *                               A dedicated master node is a cluster node that performs cluster management tasks, but doesn't hold data or respond to data upload requests. Dedicated master nodes offload cluster management tasks to increase the stability of your search clusters. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-dedicatedmasternodes.html">Dedicated master nodes in Amazon OpenSearch Service</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dedicatedMasterEnabled(software.amazon.awscdk.IResolvable dedicatedMasterEnabled) {
                this.dedicatedMasterEnabled = dedicatedMasterEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getDedicatedMasterType}
             * @param dedicatedMasterType The hardware configuration of the computer that hosts the dedicated master node, such as <code>m3.medium.elasticsearch</code> . If you specify this property, you must specify true for the <code>DedicatedMasterEnabled</code> property. For valid values, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html">Supported instance types in Amazon OpenSearch Service</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dedicatedMasterType(java.lang.String dedicatedMasterType) {
                this.dedicatedMasterType = dedicatedMasterType;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getInstanceCount}
             * @param instanceCount The number of data nodes (instances) to use in the OpenSearch Service domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceCount(java.lang.Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getInstanceType}
             * @param instanceType The instance type for your data nodes, such as <code>m3.medium.elasticsearch</code> . For valid values, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html">Supported instance types in Amazon OpenSearch Service</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getWarmCount}
             * @param warmCount The number of warm nodes in the cluster.
             *                  Required if you enable warm storage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder warmCount(java.lang.Number warmCount) {
                this.warmCount = warmCount;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getWarmEnabled}
             * @param warmEnabled Whether to enable warm storage for the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder warmEnabled(java.lang.Boolean warmEnabled) {
                this.warmEnabled = warmEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getWarmEnabled}
             * @param warmEnabled Whether to enable warm storage for the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder warmEnabled(software.amazon.awscdk.IResolvable warmEnabled) {
                this.warmEnabled = warmEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getWarmType}
             * @param warmType The instance type for the cluster's warm nodes.
             *                 Required if you enable warm storage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder warmType(java.lang.String warmType) {
                this.warmType = warmType;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getZoneAwarenessConfig}
             * @param zoneAwarenessConfig Specifies zone awareness configuration options.
             *                            Only use if <code>ZoneAwarenessEnabled</code> is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zoneAwarenessConfig(software.amazon.awscdk.IResolvable zoneAwarenessConfig) {
                this.zoneAwarenessConfig = zoneAwarenessConfig;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getZoneAwarenessConfig}
             * @param zoneAwarenessConfig Specifies zone awareness configuration options.
             *                            Only use if <code>ZoneAwarenessEnabled</code> is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zoneAwarenessConfig(software.amazon.awscdk.services.elasticsearch.CfnDomain.ZoneAwarenessConfigProperty zoneAwarenessConfig) {
                this.zoneAwarenessConfig = zoneAwarenessConfig;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getZoneAwarenessEnabled}
             * @param zoneAwarenessEnabled Indicates whether to enable zone awareness for the OpenSearch Service domain.
             *                             When you enable zone awareness, OpenSearch Service allocates the nodes and replica index shards that belong to a cluster across two Availability Zones (AZs) in the same region to prevent data loss and minimize downtime in the event of node or data center failure. Don't enable zone awareness if your cluster has no replica index shards or is a single-node cluster. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html">Configuring a multi-AZ domain in Amazon OpenSearch Service</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zoneAwarenessEnabled(java.lang.Boolean zoneAwarenessEnabled) {
                this.zoneAwarenessEnabled = zoneAwarenessEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchClusterConfigProperty#getZoneAwarenessEnabled}
             * @param zoneAwarenessEnabled Indicates whether to enable zone awareness for the OpenSearch Service domain.
             *                             When you enable zone awareness, OpenSearch Service allocates the nodes and replica index shards that belong to a cluster across two Availability Zones (AZs) in the same region to prevent data loss and minimize downtime in the event of node or data center failure. Don't enable zone awareness if your cluster has no replica index shards or is a single-node cluster. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html">Configuring a multi-AZ domain in Amazon OpenSearch Service</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zoneAwarenessEnabled(software.amazon.awscdk.IResolvable zoneAwarenessEnabled) {
                this.zoneAwarenessEnabled = zoneAwarenessEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticsearchClusterConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ElasticsearchClusterConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ElasticsearchClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticsearchClusterConfigProperty {
            private final java.lang.Object coldStorageOptions;
            private final java.lang.Number dedicatedMasterCount;
            private final java.lang.Object dedicatedMasterEnabled;
            private final java.lang.String dedicatedMasterType;
            private final java.lang.Number instanceCount;
            private final java.lang.String instanceType;
            private final java.lang.Number warmCount;
            private final java.lang.Object warmEnabled;
            private final java.lang.String warmType;
            private final java.lang.Object zoneAwarenessConfig;
            private final java.lang.Object zoneAwarenessEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.coldStorageOptions = software.amazon.jsii.Kernel.get(this, "coldStorageOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dedicatedMasterCount = software.amazon.jsii.Kernel.get(this, "dedicatedMasterCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.dedicatedMasterEnabled = software.amazon.jsii.Kernel.get(this, "dedicatedMasterEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dedicatedMasterType = software.amazon.jsii.Kernel.get(this, "dedicatedMasterType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceCount = software.amazon.jsii.Kernel.get(this, "instanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.warmCount = software.amazon.jsii.Kernel.get(this, "warmCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.warmEnabled = software.amazon.jsii.Kernel.get(this, "warmEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.warmType = software.amazon.jsii.Kernel.get(this, "warmType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.zoneAwarenessConfig = software.amazon.jsii.Kernel.get(this, "zoneAwarenessConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.zoneAwarenessEnabled = software.amazon.jsii.Kernel.get(this, "zoneAwarenessEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.coldStorageOptions = builder.coldStorageOptions;
                this.dedicatedMasterCount = builder.dedicatedMasterCount;
                this.dedicatedMasterEnabled = builder.dedicatedMasterEnabled;
                this.dedicatedMasterType = builder.dedicatedMasterType;
                this.instanceCount = builder.instanceCount;
                this.instanceType = builder.instanceType;
                this.warmCount = builder.warmCount;
                this.warmEnabled = builder.warmEnabled;
                this.warmType = builder.warmType;
                this.zoneAwarenessConfig = builder.zoneAwarenessConfig;
                this.zoneAwarenessEnabled = builder.zoneAwarenessEnabled;
            }

            @Override
            public final java.lang.Object getColdStorageOptions() {
                return this.coldStorageOptions;
            }

            @Override
            public final java.lang.Number getDedicatedMasterCount() {
                return this.dedicatedMasterCount;
            }

            @Override
            public final java.lang.Object getDedicatedMasterEnabled() {
                return this.dedicatedMasterEnabled;
            }

            @Override
            public final java.lang.String getDedicatedMasterType() {
                return this.dedicatedMasterType;
            }

            @Override
            public final java.lang.Number getInstanceCount() {
                return this.instanceCount;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.Number getWarmCount() {
                return this.warmCount;
            }

            @Override
            public final java.lang.Object getWarmEnabled() {
                return this.warmEnabled;
            }

            @Override
            public final java.lang.String getWarmType() {
                return this.warmType;
            }

            @Override
            public final java.lang.Object getZoneAwarenessConfig() {
                return this.zoneAwarenessConfig;
            }

            @Override
            public final java.lang.Object getZoneAwarenessEnabled() {
                return this.zoneAwarenessEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColdStorageOptions() != null) {
                    data.set("coldStorageOptions", om.valueToTree(this.getColdStorageOptions()));
                }
                if (this.getDedicatedMasterCount() != null) {
                    data.set("dedicatedMasterCount", om.valueToTree(this.getDedicatedMasterCount()));
                }
                if (this.getDedicatedMasterEnabled() != null) {
                    data.set("dedicatedMasterEnabled", om.valueToTree(this.getDedicatedMasterEnabled()));
                }
                if (this.getDedicatedMasterType() != null) {
                    data.set("dedicatedMasterType", om.valueToTree(this.getDedicatedMasterType()));
                }
                if (this.getInstanceCount() != null) {
                    data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
                }
                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getWarmCount() != null) {
                    data.set("warmCount", om.valueToTree(this.getWarmCount()));
                }
                if (this.getWarmEnabled() != null) {
                    data.set("warmEnabled", om.valueToTree(this.getWarmEnabled()));
                }
                if (this.getWarmType() != null) {
                    data.set("warmType", om.valueToTree(this.getWarmType()));
                }
                if (this.getZoneAwarenessConfig() != null) {
                    data.set("zoneAwarenessConfig", om.valueToTree(this.getZoneAwarenessConfig()));
                }
                if (this.getZoneAwarenessEnabled() != null) {
                    data.set("zoneAwarenessEnabled", om.valueToTree(this.getZoneAwarenessEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticsearch.CfnDomain.ElasticsearchClusterConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticsearchClusterConfigProperty.Jsii$Proxy that = (ElasticsearchClusterConfigProperty.Jsii$Proxy) o;

                if (this.coldStorageOptions != null ? !this.coldStorageOptions.equals(that.coldStorageOptions) : that.coldStorageOptions != null) return false;
                if (this.dedicatedMasterCount != null ? !this.dedicatedMasterCount.equals(that.dedicatedMasterCount) : that.dedicatedMasterCount != null) return false;
                if (this.dedicatedMasterEnabled != null ? !this.dedicatedMasterEnabled.equals(that.dedicatedMasterEnabled) : that.dedicatedMasterEnabled != null) return false;
                if (this.dedicatedMasterType != null ? !this.dedicatedMasterType.equals(that.dedicatedMasterType) : that.dedicatedMasterType != null) return false;
                if (this.instanceCount != null ? !this.instanceCount.equals(that.instanceCount) : that.instanceCount != null) return false;
                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.warmCount != null ? !this.warmCount.equals(that.warmCount) : that.warmCount != null) return false;
                if (this.warmEnabled != null ? !this.warmEnabled.equals(that.warmEnabled) : that.warmEnabled != null) return false;
                if (this.warmType != null ? !this.warmType.equals(that.warmType) : that.warmType != null) return false;
                if (this.zoneAwarenessConfig != null ? !this.zoneAwarenessConfig.equals(that.zoneAwarenessConfig) : that.zoneAwarenessConfig != null) return false;
                return this.zoneAwarenessEnabled != null ? this.zoneAwarenessEnabled.equals(that.zoneAwarenessEnabled) : that.zoneAwarenessEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.coldStorageOptions != null ? this.coldStorageOptions.hashCode() : 0;
                result = 31 * result + (this.dedicatedMasterCount != null ? this.dedicatedMasterCount.hashCode() : 0);
                result = 31 * result + (this.dedicatedMasterEnabled != null ? this.dedicatedMasterEnabled.hashCode() : 0);
                result = 31 * result + (this.dedicatedMasterType != null ? this.dedicatedMasterType.hashCode() : 0);
                result = 31 * result + (this.instanceCount != null ? this.instanceCount.hashCode() : 0);
                result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
                result = 31 * result + (this.warmCount != null ? this.warmCount.hashCode() : 0);
                result = 31 * result + (this.warmEnabled != null ? this.warmEnabled.hashCode() : 0);
                result = 31 * result + (this.warmType != null ? this.warmType.hashCode() : 0);
                result = 31 * result + (this.zoneAwarenessConfig != null ? this.zoneAwarenessConfig.hashCode() : 0);
                result = 31 * result + (this.zoneAwarenessEnabled != null ? this.zoneAwarenessEnabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Whether the domain should encrypt data at rest, and if so, the AWS Key Management Service key to use.
     * <p>
     * <blockquote>
     * <p>
     * The <code>AWS::Elasticsearch::Domain</code> resource is being replaced by the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html">AWS::OpenSearchService::Domain</a> resource. While the legacy Elasticsearch resource and options are still supported, we recommend modifying your existing Cloudformation templates to use the new OpenSearch Service resource, which supports both OpenSearch and Elasticsearch. For more information about the service rename, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/rename.html#rename-resource">New resource types</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticsearch.*;
     * EncryptionAtRestOptionsProperty encryptionAtRestOptionsProperty = EncryptionAtRestOptionsProperty.builder()
     *         .enabled(false)
     *         .kmsKeyId("kmsKeyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-encryptionatrestoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-encryptionatrestoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticsearch.CfnDomain.EncryptionAtRestOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionAtRestOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionAtRestOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specify <code>true</code> to enable encryption at rest.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-encryptionatrestoptions.html#cfn-elasticsearch-domain-encryptionatrestoptions-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-encryptionatrestoptions.html#cfn-elasticsearch-domain-encryptionatrestoptions-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The KMS key ID.
         * <p>
         * Takes the form <code>1a2a3a4-1a2a-3a4a-5a6a-1a2a3a4a5a6a</code> . Required if you enable encryption at rest.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-encryptionatrestoptions.html#cfn-elasticsearch-domain-encryptionatrestoptions-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-encryptionatrestoptions.html#cfn-elasticsearch-domain-encryptionatrestoptions-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionAtRestOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionAtRestOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionAtRestOptionsProperty> {
            java.lang.Object enabled;
            java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link EncryptionAtRestOptionsProperty#getEnabled}
             * @param enabled Specify <code>true</code> to enable encryption at rest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionAtRestOptionsProperty#getEnabled}
             * @param enabled Specify <code>true</code> to enable encryption at rest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionAtRestOptionsProperty#getKmsKeyId}
             * @param kmsKeyId The KMS key ID.
             *                 Takes the form <code>1a2a3a4-1a2a-3a4a-5a6a-1a2a3a4a5a6a</code> . Required if you enable encryption at rest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionAtRestOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionAtRestOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionAtRestOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionAtRestOptionsProperty {
            private final java.lang.Object enabled;
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.kmsKeyId = builder.kmsKeyId;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticsearch.CfnDomain.EncryptionAtRestOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionAtRestOptionsProperty.Jsii$Proxy that = (EncryptionAtRestOptionsProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <blockquote><p>The <code>AWS::Elasticsearch::Domain</code> resource is being replaced by the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html">AWS::OpenSearchService::Domain</a> resource. While the legacy Elasticsearch resource and options are still supported, we recommend modifying your existing Cloudformation templates to use the new OpenSearch Service resource, which supports both OpenSearch and Elasticsearch. For more information about the service rename, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/rename.html#rename-resource">New resource types</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .<p></blockquote>
     * <p>
     * Specifies whether the OpenSearch Service domain publishes the Elasticsearch application, search slow logs, or index slow logs to Amazon CloudWatch. Each option must be an object of name <code>SEARCH_SLOW_LOGS</code> , <code>ES_APPLICATION_LOGS</code> , <code>INDEX_SLOW_LOGS</code> , or <code>AUDIT_LOGS</code> depending on the type of logs you want to publish.
     * <p>
     * If you enable a slow log, you still have to enable the <em>collection</em> of slow logs using the Configuration API. To learn more, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createdomain-configure-slow-logs.html#createdomain-configure-slow-logs-cli">Enabling log publishing ( AWS CLI)</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticsearch.*;
     * LogPublishingOptionProperty logPublishingOptionProperty = LogPublishingOptionProperty.builder()
     *         .cloudWatchLogsLogGroupArn("cloudWatchLogsLogGroupArn")
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-logpublishingoption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-logpublishingoption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticsearch.CfnDomain.LogPublishingOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(LogPublishingOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogPublishingOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the CloudWatch log group to publish to.
         * <p>
         * Required if you enable log publishing for the domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-logpublishingoption.html#cfn-elasticsearch-domain-logpublishingoption-cloudwatchlogsloggrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-logpublishingoption.html#cfn-elasticsearch-domain-logpublishingoption-cloudwatchlogsloggrouparn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCloudWatchLogsLogGroupArn() {
            return null;
        }

        /**
         * If <code>true</code> , enables the publishing of logs to CloudWatch.
         * <p>
         * Default: <code>false</code> .
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-logpublishingoption.html#cfn-elasticsearch-domain-logpublishingoption-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-logpublishingoption.html#cfn-elasticsearch-domain-logpublishingoption-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogPublishingOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogPublishingOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogPublishingOptionProperty> {
            java.lang.String cloudWatchLogsLogGroupArn;
            java.lang.Object enabled;

            /**
             * Sets the value of {@link LogPublishingOptionProperty#getCloudWatchLogsLogGroupArn}
             * @param cloudWatchLogsLogGroupArn Specifies the CloudWatch log group to publish to.
             *                                  Required if you enable log publishing for the domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogsLogGroupArn(java.lang.String cloudWatchLogsLogGroupArn) {
                this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
                return this;
            }

            /**
             * Sets the value of {@link LogPublishingOptionProperty#getEnabled}
             * @param enabled If <code>true</code> , enables the publishing of logs to CloudWatch.
             *                Default: <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link LogPublishingOptionProperty#getEnabled}
             * @param enabled If <code>true</code> , enables the publishing of logs to CloudWatch.
             *                Default: <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogPublishingOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogPublishingOptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogPublishingOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogPublishingOptionProperty {
            private final java.lang.String cloudWatchLogsLogGroupArn;
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLogsLogGroupArn = software.amazon.jsii.Kernel.get(this, "cloudWatchLogsLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLogsLogGroupArn = builder.cloudWatchLogsLogGroupArn;
                this.enabled = builder.enabled;
            }

            @Override
            public final java.lang.String getCloudWatchLogsLogGroupArn() {
                return this.cloudWatchLogsLogGroupArn;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudWatchLogsLogGroupArn() != null) {
                    data.set("cloudWatchLogsLogGroupArn", om.valueToTree(this.getCloudWatchLogsLogGroupArn()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticsearch.CfnDomain.LogPublishingOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogPublishingOptionProperty.Jsii$Proxy that = (LogPublishingOptionProperty.Jsii$Proxy) o;

                if (this.cloudWatchLogsLogGroupArn != null ? !this.cloudWatchLogsLogGroupArn.equals(that.cloudWatchLogsLogGroupArn) : that.cloudWatchLogsLogGroupArn != null) return false;
                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchLogsLogGroupArn != null ? this.cloudWatchLogsLogGroupArn.hashCode() : 0;
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies information about the master user. Required if you enabled the internal user database.
     * <p>
     * <blockquote>
     * <p>
     * The <code>AWS::Elasticsearch::Domain</code> resource is being replaced by the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html">AWS::OpenSearchService::Domain</a> resource. While the legacy Elasticsearch resource and options are still supported, we recommend modifying your existing Cloudformation templates to use the new OpenSearch Service resource, which supports both OpenSearch and Elasticsearch. For more information about the service rename, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/rename.html#rename-resource">New resource types</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticsearch.*;
     * MasterUserOptionsProperty masterUserOptionsProperty = MasterUserOptionsProperty.builder()
     *         .masterUserArn("masterUserArn")
     *         .masterUserName("masterUserName")
     *         .masterUserPassword("masterUserPassword")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-masteruseroptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-masteruseroptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticsearch.CfnDomain.MasterUserOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(MasterUserOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MasterUserOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * ARN for the master user.
         * <p>
         * Only specify if <code>InternalUserDatabaseEnabled</code> is false in <code>AdvancedSecurityOptions</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-masteruseroptions.html#cfn-elasticsearch-domain-masteruseroptions-masteruserarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-masteruseroptions.html#cfn-elasticsearch-domain-masteruseroptions-masteruserarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMasterUserArn() {
            return null;
        }

        /**
         * Username for the master user.
         * <p>
         * Only specify if <code>InternalUserDatabaseEnabled</code> is true in <code>AdvancedSecurityOptions</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-masteruseroptions.html#cfn-elasticsearch-domain-masteruseroptions-masterusername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-masteruseroptions.html#cfn-elasticsearch-domain-masteruseroptions-masterusername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMasterUserName() {
            return null;
        }

        /**
         * Password for the master user.
         * <p>
         * Only specify if <code>InternalUserDatabaseEnabled</code> is true in <code>AdvancedSecurityOptions</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-masteruseroptions.html#cfn-elasticsearch-domain-masteruseroptions-masteruserpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-masteruseroptions.html#cfn-elasticsearch-domain-masteruseroptions-masteruserpassword</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMasterUserPassword() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MasterUserOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MasterUserOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MasterUserOptionsProperty> {
            java.lang.String masterUserArn;
            java.lang.String masterUserName;
            java.lang.String masterUserPassword;

            /**
             * Sets the value of {@link MasterUserOptionsProperty#getMasterUserArn}
             * @param masterUserArn ARN for the master user.
             *                      Only specify if <code>InternalUserDatabaseEnabled</code> is false in <code>AdvancedSecurityOptions</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder masterUserArn(java.lang.String masterUserArn) {
                this.masterUserArn = masterUserArn;
                return this;
            }

            /**
             * Sets the value of {@link MasterUserOptionsProperty#getMasterUserName}
             * @param masterUserName Username for the master user.
             *                       Only specify if <code>InternalUserDatabaseEnabled</code> is true in <code>AdvancedSecurityOptions</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder masterUserName(java.lang.String masterUserName) {
                this.masterUserName = masterUserName;
                return this;
            }

            /**
             * Sets the value of {@link MasterUserOptionsProperty#getMasterUserPassword}
             * @param masterUserPassword Password for the master user.
             *                           Only specify if <code>InternalUserDatabaseEnabled</code> is true in <code>AdvancedSecurityOptions</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder masterUserPassword(java.lang.String masterUserPassword) {
                this.masterUserPassword = masterUserPassword;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MasterUserOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MasterUserOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MasterUserOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MasterUserOptionsProperty {
            private final java.lang.String masterUserArn;
            private final java.lang.String masterUserName;
            private final java.lang.String masterUserPassword;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.masterUserArn = software.amazon.jsii.Kernel.get(this, "masterUserArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.masterUserName = software.amazon.jsii.Kernel.get(this, "masterUserName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.masterUserPassword = software.amazon.jsii.Kernel.get(this, "masterUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.masterUserArn = builder.masterUserArn;
                this.masterUserName = builder.masterUserName;
                this.masterUserPassword = builder.masterUserPassword;
            }

            @Override
            public final java.lang.String getMasterUserArn() {
                return this.masterUserArn;
            }

            @Override
            public final java.lang.String getMasterUserName() {
                return this.masterUserName;
            }

            @Override
            public final java.lang.String getMasterUserPassword() {
                return this.masterUserPassword;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMasterUserArn() != null) {
                    data.set("masterUserArn", om.valueToTree(this.getMasterUserArn()));
                }
                if (this.getMasterUserName() != null) {
                    data.set("masterUserName", om.valueToTree(this.getMasterUserName()));
                }
                if (this.getMasterUserPassword() != null) {
                    data.set("masterUserPassword", om.valueToTree(this.getMasterUserPassword()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticsearch.CfnDomain.MasterUserOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MasterUserOptionsProperty.Jsii$Proxy that = (MasterUserOptionsProperty.Jsii$Proxy) o;

                if (this.masterUserArn != null ? !this.masterUserArn.equals(that.masterUserArn) : that.masterUserArn != null) return false;
                if (this.masterUserName != null ? !this.masterUserName.equals(that.masterUserName) : that.masterUserName != null) return false;
                return this.masterUserPassword != null ? this.masterUserPassword.equals(that.masterUserPassword) : that.masterUserPassword == null;
            }

            @Override
            public final int hashCode() {
                int result = this.masterUserArn != null ? this.masterUserArn.hashCode() : 0;
                result = 31 * result + (this.masterUserName != null ? this.masterUserName.hashCode() : 0);
                result = 31 * result + (this.masterUserPassword != null ? this.masterUserPassword.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies whether node-to-node encryption is enabled.
     * <p>
     * <blockquote>
     * <p>
     * The <code>AWS::Elasticsearch::Domain</code> resource is being replaced by the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html">AWS::OpenSearchService::Domain</a> resource. While the legacy Elasticsearch resource and options are still supported, we recommend modifying your existing Cloudformation templates to use the new OpenSearch Service resource, which supports both OpenSearch and Elasticsearch. For more information about the service rename, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/rename.html#rename-resource">New resource types</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticsearch.*;
     * NodeToNodeEncryptionOptionsProperty nodeToNodeEncryptionOptionsProperty = NodeToNodeEncryptionOptionsProperty.builder()
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-nodetonodeencryptionoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-nodetonodeencryptionoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticsearch.CfnDomain.NodeToNodeEncryptionOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(NodeToNodeEncryptionOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NodeToNodeEncryptionOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether node-to-node encryption is enabled, as a Boolean.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-nodetonodeencryptionoptions.html#cfn-elasticsearch-domain-nodetonodeencryptionoptions-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-nodetonodeencryptionoptions.html#cfn-elasticsearch-domain-nodetonodeencryptionoptions-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NodeToNodeEncryptionOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NodeToNodeEncryptionOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NodeToNodeEncryptionOptionsProperty> {
            java.lang.Object enabled;

            /**
             * Sets the value of {@link NodeToNodeEncryptionOptionsProperty#getEnabled}
             * @param enabled Specifies whether node-to-node encryption is enabled, as a Boolean.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link NodeToNodeEncryptionOptionsProperty#getEnabled}
             * @param enabled Specifies whether node-to-node encryption is enabled, as a Boolean.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NodeToNodeEncryptionOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NodeToNodeEncryptionOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NodeToNodeEncryptionOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NodeToNodeEncryptionOptionsProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticsearch.CfnDomain.NodeToNodeEncryptionOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NodeToNodeEncryptionOptionsProperty.Jsii$Proxy that = (NodeToNodeEncryptionOptionsProperty.Jsii$Proxy) o;

                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * <blockquote><p>The <code>AWS::Elasticsearch::Domain</code> resource is being replaced by the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html">AWS::OpenSearchService::Domain</a> resource. While the legacy Elasticsearch resource and options are still supported, we recommend modifying your existing Cloudformation templates to use the new OpenSearch Service resource, which supports both OpenSearch and Elasticsearch. For more information about the service rename, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/rename.html#rename-resource">New resource types</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .<p></blockquote>
     * <p>
     * <em>DEPRECATED</em> . For domains running Elasticsearch 5.3 and later, OpenSearch Service takes hourly automated snapshots, making this setting irrelevant. For domains running earlier versions of Elasticsearch, OpenSearch Service takes daily automated snapshots.
     * <p>
     * The automated snapshot configuration for the OpenSearch Service domain indices.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticsearch.*;
     * SnapshotOptionsProperty snapshotOptionsProperty = SnapshotOptionsProperty.builder()
     *         .automatedSnapshotStartHour(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-snapshotoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-snapshotoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticsearch.CfnDomain.SnapshotOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(SnapshotOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnapshotOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The hour in UTC during which the service takes an automated daily snapshot of the indices in the OpenSearch Service domain.
         * <p>
         * For example, if you specify 0, OpenSearch Service takes an automated snapshot everyday between midnight and 1 am. You can specify a value between 0 and 23.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-snapshotoptions.html#cfn-elasticsearch-domain-snapshotoptions-automatedsnapshotstarthour">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-snapshotoptions.html#cfn-elasticsearch-domain-snapshotoptions-automatedsnapshotstarthour</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAutomatedSnapshotStartHour() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SnapshotOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnapshotOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnapshotOptionsProperty> {
            java.lang.Number automatedSnapshotStartHour;

            /**
             * Sets the value of {@link SnapshotOptionsProperty#getAutomatedSnapshotStartHour}
             * @param automatedSnapshotStartHour The hour in UTC during which the service takes an automated daily snapshot of the indices in the OpenSearch Service domain.
             *                                   For example, if you specify 0, OpenSearch Service takes an automated snapshot everyday between midnight and 1 am. You can specify a value between 0 and 23.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automatedSnapshotStartHour(java.lang.Number automatedSnapshotStartHour) {
                this.automatedSnapshotStartHour = automatedSnapshotStartHour;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnapshotOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnapshotOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnapshotOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnapshotOptionsProperty {
            private final java.lang.Number automatedSnapshotStartHour;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.automatedSnapshotStartHour = software.amazon.jsii.Kernel.get(this, "automatedSnapshotStartHour", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.automatedSnapshotStartHour = builder.automatedSnapshotStartHour;
            }

            @Override
            public final java.lang.Number getAutomatedSnapshotStartHour() {
                return this.automatedSnapshotStartHour;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutomatedSnapshotStartHour() != null) {
                    data.set("automatedSnapshotStartHour", om.valueToTree(this.getAutomatedSnapshotStartHour()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticsearch.CfnDomain.SnapshotOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnapshotOptionsProperty.Jsii$Proxy that = (SnapshotOptionsProperty.Jsii$Proxy) o;

                return this.automatedSnapshotStartHour != null ? this.automatedSnapshotStartHour.equals(that.automatedSnapshotStartHour) : that.automatedSnapshotStartHour == null;
            }

            @Override
            public final int hashCode() {
                int result = this.automatedSnapshotStartHour != null ? this.automatedSnapshotStartHour.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The virtual private cloud (VPC) configuration for the OpenSearch Service domain.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html">Launching your Amazon OpenSearch Service domains using a VPC</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * The <code>AWS::Elasticsearch::Domain</code> resource is being replaced by the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html">AWS::OpenSearchService::Domain</a> resource. While the legacy Elasticsearch resource and options are still supported, we recommend modifying your existing Cloudformation templates to use the new OpenSearch Service resource, which supports both OpenSearch and Elasticsearch. For more information about the service rename, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/rename.html#rename-resource">New resource types</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticsearch.*;
     * VPCOptionsProperty vPCOptionsProperty = VPCOptionsProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnetIds(List.of("subnetIds"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-vpcoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-vpcoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticsearch.CfnDomain.VPCOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(VPCOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VPCOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of security group IDs that are associated with the VPC endpoints for the domain.
         * <p>
         * If you don't provide a security group ID, OpenSearch Service uses the default security group for the VPC. To learn more, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">Security groups for your VPC</a> in the <em>Amazon VPC User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-vpcoptions.html#cfn-elasticsearch-domain-vpcoptions-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-vpcoptions.html#cfn-elasticsearch-domain-vpcoptions-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
            return null;
        }

        /**
         * Provide one subnet ID for each Availability Zone that your domain uses.
         * <p>
         * For example, you must specify three subnet IDs for a three Availability Zone domain. To learn more, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and subnets</a> in the <em>Amazon VPC User Guide</em> .
         * <p>
         * Required if you're creating your domain inside a VPC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-vpcoptions.html#cfn-elasticsearch-domain-vpcoptions-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-vpcoptions.html#cfn-elasticsearch-domain-vpcoptions-subnetids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VPCOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VPCOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VPCOptionsProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnetIds;

            /**
             * Sets the value of {@link VPCOptionsProperty#getSecurityGroupIds}
             * @param securityGroupIds The list of security group IDs that are associated with the VPC endpoints for the domain.
             *                         If you don't provide a security group ID, OpenSearch Service uses the default security group for the VPC. To learn more, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">Security groups for your VPC</a> in the <em>Amazon VPC User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VPCOptionsProperty#getSubnetIds}
             * @param subnetIds Provide one subnet ID for each Availability Zone that your domain uses.
             *                  For example, you must specify three subnet IDs for a three Availability Zone domain. To learn more, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and subnets</a> in the <em>Amazon VPC User Guide</em> .
             *                  <p>
             *                  Required if you're creating your domain inside a VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VPCOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VPCOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VPCOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VPCOptionsProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnetIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = builder.securityGroupIds;
                this.subnetIds = builder.subnetIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnetIds() {
                return this.subnetIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecurityGroupIds() != null) {
                    data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                }
                if (this.getSubnetIds() != null) {
                    data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticsearch.CfnDomain.VPCOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VPCOptionsProperty.Jsii$Proxy that = (VPCOptionsProperty.Jsii$Proxy) o;

                if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
                return this.subnetIds != null ? this.subnetIds.equals(that.subnetIds) : that.subnetIds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0;
                result = 31 * result + (this.subnetIds != null ? this.subnetIds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies zone awareness configuration options. Only use if <code>ZoneAwarenessEnabled</code> is <code>true</code> .
     * <p>
     * <blockquote>
     * <p>
     * The <code>AWS::Elasticsearch::Domain</code> resource is being replaced by the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html">AWS::OpenSearchService::Domain</a> resource. While the legacy Elasticsearch resource and options are still supported, we recommend modifying your existing Cloudformation templates to use the new OpenSearch Service resource, which supports both OpenSearch and Elasticsearch. For more information about the service rename, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/rename.html#rename-resource">New resource types</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticsearch.*;
     * ZoneAwarenessConfigProperty zoneAwarenessConfigProperty = ZoneAwarenessConfigProperty.builder()
     *         .availabilityZoneCount(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-zoneawarenessconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-zoneawarenessconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticsearch.CfnDomain.ZoneAwarenessConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ZoneAwarenessConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ZoneAwarenessConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If you enabled multiple Availability Zones (AZs), the number of AZs that you want the domain to use.
         * <p>
         * Valid values are <code>2</code> and <code>3</code> . Default is 2.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-zoneawarenessconfig.html#cfn-elasticsearch-domain-zoneawarenessconfig-availabilityzonecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-zoneawarenessconfig.html#cfn-elasticsearch-domain-zoneawarenessconfig-availabilityzonecount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAvailabilityZoneCount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ZoneAwarenessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ZoneAwarenessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ZoneAwarenessConfigProperty> {
            java.lang.Number availabilityZoneCount;

            /**
             * Sets the value of {@link ZoneAwarenessConfigProperty#getAvailabilityZoneCount}
             * @param availabilityZoneCount If you enabled multiple Availability Zones (AZs), the number of AZs that you want the domain to use.
             *                              Valid values are <code>2</code> and <code>3</code> . Default is 2.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZoneCount(java.lang.Number availabilityZoneCount) {
                this.availabilityZoneCount = availabilityZoneCount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ZoneAwarenessConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ZoneAwarenessConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ZoneAwarenessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ZoneAwarenessConfigProperty {
            private final java.lang.Number availabilityZoneCount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZoneCount = software.amazon.jsii.Kernel.get(this, "availabilityZoneCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZoneCount = builder.availabilityZoneCount;
            }

            @Override
            public final java.lang.Number getAvailabilityZoneCount() {
                return this.availabilityZoneCount;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityZoneCount() != null) {
                    data.set("availabilityZoneCount", om.valueToTree(this.getAvailabilityZoneCount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticsearch.CfnDomain.ZoneAwarenessConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ZoneAwarenessConfigProperty.Jsii$Proxy that = (ZoneAwarenessConfigProperty.Jsii$Proxy) o;

                return this.availabilityZoneCount != null ? this.availabilityZoneCount.equals(that.availabilityZoneCount) : that.availabilityZoneCount == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availabilityZoneCount != null ? this.availabilityZoneCount.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticsearch.CfnDomain}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticsearch.CfnDomain> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.elasticsearch.CfnDomainProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * An AWS Identity and Access Management ( IAM ) policy document that specifies who can access the OpenSearch Service domain and their permissions.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html#ac-creating">Configuring access policies</a> in the <em>Amazon OpenSearch Service Developer Guid</em> e.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-accesspolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-accesspolicies</a>
         * @param accessPolicies An AWS Identity and Access Management ( IAM ) policy document that specifies who can access the OpenSearch Service domain and their permissions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPolicies(final java.lang.Object accessPolicies) {
            this.props().accessPolicies(accessPolicies);
            return this;
        }

        /**
         * Additional options to specify for the OpenSearch Service domain.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options">Advanced cluster parameters</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-advancedoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-advancedoptions</a>
         * @param advancedOptions Additional options to specify for the OpenSearch Service domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedOptions(final java.util.Map<java.lang.String, java.lang.String> advancedOptions) {
            this.props().advancedOptions(advancedOptions);
            return this;
        }
        /**
         * Additional options to specify for the OpenSearch Service domain.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options">Advanced cluster parameters</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-advancedoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-advancedoptions</a>
         * @param advancedOptions Additional options to specify for the OpenSearch Service domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedOptions(final software.amazon.awscdk.IResolvable advancedOptions) {
            this.props().advancedOptions(advancedOptions);
            return this;
        }

        /**
         * Specifies options for fine-grained access control.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-advancedsecurityoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-advancedsecurityoptions</a>
         * @param advancedSecurityOptions Specifies options for fine-grained access control. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedSecurityOptions(final software.amazon.awscdk.IResolvable advancedSecurityOptions) {
            this.props().advancedSecurityOptions(advancedSecurityOptions);
            return this;
        }
        /**
         * Specifies options for fine-grained access control.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-advancedsecurityoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-advancedsecurityoptions</a>
         * @param advancedSecurityOptions Specifies options for fine-grained access control. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedSecurityOptions(final software.amazon.awscdk.services.elasticsearch.CfnDomain.AdvancedSecurityOptionsInputProperty advancedSecurityOptions) {
            this.props().advancedSecurityOptions(advancedSecurityOptions);
            return this;
        }

        /**
         * Configures OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-cognitooptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-cognitooptions</a>
         * @param cognitoOptions Configures OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoOptions(final software.amazon.awscdk.IResolvable cognitoOptions) {
            this.props().cognitoOptions(cognitoOptions);
            return this;
        }
        /**
         * Configures OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-cognitooptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-cognitooptions</a>
         * @param cognitoOptions Configures OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoOptions(final software.amazon.awscdk.services.elasticsearch.CfnDomain.CognitoOptionsProperty cognitoOptions) {
            this.props().cognitoOptions(cognitoOptions);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-domainarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-domainarn</a>
         * @param domainArn This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainArn(final java.lang.String domainArn) {
            this.props().domainArn(domainArn);
            return this;
        }

        /**
         * Specifies additional options for the domain endpoint, such as whether to require HTTPS for all traffic or whether to use a custom endpoint rather than the default endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-domainendpointoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-domainendpointoptions</a>
         * @param domainEndpointOptions Specifies additional options for the domain endpoint, such as whether to require HTTPS for all traffic or whether to use a custom endpoint rather than the default endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainEndpointOptions(final software.amazon.awscdk.IResolvable domainEndpointOptions) {
            this.props().domainEndpointOptions(domainEndpointOptions);
            return this;
        }
        /**
         * Specifies additional options for the domain endpoint, such as whether to require HTTPS for all traffic or whether to use a custom endpoint rather than the default endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-domainendpointoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-domainendpointoptions</a>
         * @param domainEndpointOptions Specifies additional options for the domain endpoint, such as whether to require HTTPS for all traffic or whether to use a custom endpoint rather than the default endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainEndpointOptions(final software.amazon.awscdk.services.elasticsearch.CfnDomain.DomainEndpointOptionsProperty domainEndpointOptions) {
            this.props().domainEndpointOptions(domainEndpointOptions);
            return this;
        }

        /**
         * A name for the OpenSearch Service domain.
         * <p>
         * For valid values, see the <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-datatypes-domainname">DomainName</a> data type in the <em>Amazon OpenSearch Service Developer Guide</em> . If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the domain name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         * <p>
         * <blockquote>
         * <p>
         * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-domainname</a>
         * @param domainName A name for the OpenSearch Service domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props().domainName(domainName);
            return this;
        }

        /**
         * The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the OpenSearch Service domain.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/limits.html#ebsresource">EBS volume size limits</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-ebsoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-ebsoptions</a>
         * @param ebsOptions The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the OpenSearch Service domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptions(final software.amazon.awscdk.IResolvable ebsOptions) {
            this.props().ebsOptions(ebsOptions);
            return this;
        }
        /**
         * The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the OpenSearch Service domain.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/limits.html#ebsresource">EBS volume size limits</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-ebsoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-ebsoptions</a>
         * @param ebsOptions The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the OpenSearch Service domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptions(final software.amazon.awscdk.services.elasticsearch.CfnDomain.EBSOptionsProperty ebsOptions) {
            this.props().ebsOptions(ebsOptions);
            return this;
        }

        /**
         * ElasticsearchClusterConfig is a property of the AWS::Elasticsearch::Domain resource that configures the cluster of an Amazon OpenSearch Service domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-elasticsearchclusterconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-elasticsearchclusterconfig</a>
         * @param elasticsearchClusterConfig ElasticsearchClusterConfig is a property of the AWS::Elasticsearch::Domain resource that configures the cluster of an Amazon OpenSearch Service domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticsearchClusterConfig(final software.amazon.awscdk.IResolvable elasticsearchClusterConfig) {
            this.props().elasticsearchClusterConfig(elasticsearchClusterConfig);
            return this;
        }
        /**
         * ElasticsearchClusterConfig is a property of the AWS::Elasticsearch::Domain resource that configures the cluster of an Amazon OpenSearch Service domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-elasticsearchclusterconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-elasticsearchclusterconfig</a>
         * @param elasticsearchClusterConfig ElasticsearchClusterConfig is a property of the AWS::Elasticsearch::Domain resource that configures the cluster of an Amazon OpenSearch Service domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticsearchClusterConfig(final software.amazon.awscdk.services.elasticsearch.CfnDomain.ElasticsearchClusterConfigProperty elasticsearchClusterConfig) {
            this.props().elasticsearchClusterConfig(elasticsearchClusterConfig);
            return this;
        }

        /**
         * The version of Elasticsearch to use, such as 2.3. If not specified, 1.5 is used as the default. For information about the versions that OpenSearch Service supports, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/what-is.html#choosing-version">Supported versions of OpenSearch and Elasticsearch</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * <p>
         * If you set the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-upgradeopensearchdomain">EnableVersionUpgrade</a> update policy to <code>true</code> , you can update <code>ElasticsearchVersion</code> without interruption. When <code>EnableVersionUpgrade</code> is set to <code>false</code> , or is not specified, updating <code>ElasticsearchVersion</code> results in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-elasticsearchversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-elasticsearchversion</a>
         * @param elasticsearchVersion The version of Elasticsearch to use, such as 2.3. If not specified, 1.5 is used as the default. For information about the versions that OpenSearch Service supports, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/what-is.html#choosing-version">Supported versions of OpenSearch and Elasticsearch</a> in the <em>Amazon OpenSearch Service Developer Guide</em> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticsearchVersion(final java.lang.String elasticsearchVersion) {
            this.props().elasticsearchVersion(elasticsearchVersion);
            return this;
        }

        /**
         * Whether the domain should encrypt data at rest, and if so, the AWS Key Management Service key to use.
         * <p>
         * See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/encryption-at-rest.html">Encryption of data at rest for Amazon OpenSearch Service</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-encryptionatrestoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-encryptionatrestoptions</a>
         * @param encryptionAtRestOptions Whether the domain should encrypt data at rest, and if so, the AWS Key Management Service key to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionAtRestOptions(final software.amazon.awscdk.IResolvable encryptionAtRestOptions) {
            this.props().encryptionAtRestOptions(encryptionAtRestOptions);
            return this;
        }
        /**
         * Whether the domain should encrypt data at rest, and if so, the AWS Key Management Service key to use.
         * <p>
         * See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/encryption-at-rest.html">Encryption of data at rest for Amazon OpenSearch Service</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-encryptionatrestoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-encryptionatrestoptions</a>
         * @param encryptionAtRestOptions Whether the domain should encrypt data at rest, and if so, the AWS Key Management Service key to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionAtRestOptions(final software.amazon.awscdk.services.elasticsearch.CfnDomain.EncryptionAtRestOptionsProperty encryptionAtRestOptions) {
            this.props().encryptionAtRestOptions(encryptionAtRestOptions);
            return this;
        }

        /**
         * An object with one or more of the following keys: <code>SEARCH_SLOW_LOGS</code> , <code>ES_APPLICATION_LOGS</code> , <code>INDEX_SLOW_LOGS</code> , <code>AUDIT_LOGS</code> , depending on the types of logs you want to publish.
         * <p>
         * Each key needs a valid <code>LogPublishingOption</code> value.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-logpublishingoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-logpublishingoptions</a>
         * @param logPublishingOptions An object with one or more of the following keys: <code>SEARCH_SLOW_LOGS</code> , <code>ES_APPLICATION_LOGS</code> , <code>INDEX_SLOW_LOGS</code> , <code>AUDIT_LOGS</code> , depending on the types of logs you want to publish. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logPublishingOptions(final software.amazon.awscdk.IResolvable logPublishingOptions) {
            this.props().logPublishingOptions(logPublishingOptions);
            return this;
        }
        /**
         * An object with one or more of the following keys: <code>SEARCH_SLOW_LOGS</code> , <code>ES_APPLICATION_LOGS</code> , <code>INDEX_SLOW_LOGS</code> , <code>AUDIT_LOGS</code> , depending on the types of logs you want to publish.
         * <p>
         * Each key needs a valid <code>LogPublishingOption</code> value.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-logpublishingoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-logpublishingoptions</a>
         * @param logPublishingOptions An object with one or more of the following keys: <code>SEARCH_SLOW_LOGS</code> , <code>ES_APPLICATION_LOGS</code> , <code>INDEX_SLOW_LOGS</code> , <code>AUDIT_LOGS</code> , depending on the types of logs you want to publish. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logPublishingOptions(final java.util.Map<java.lang.String, ? extends java.lang.Object> logPublishingOptions) {
            this.props().logPublishingOptions(logPublishingOptions);
            return this;
        }

        /**
         * Specifies whether node-to-node encryption is enabled.
         * <p>
         * See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ntn.html">Node-to-node encryption for Amazon OpenSearch Service</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-nodetonodeencryptionoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-nodetonodeencryptionoptions</a>
         * @param nodeToNodeEncryptionOptions Specifies whether node-to-node encryption is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeToNodeEncryptionOptions(final software.amazon.awscdk.IResolvable nodeToNodeEncryptionOptions) {
            this.props().nodeToNodeEncryptionOptions(nodeToNodeEncryptionOptions);
            return this;
        }
        /**
         * Specifies whether node-to-node encryption is enabled.
         * <p>
         * See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ntn.html">Node-to-node encryption for Amazon OpenSearch Service</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-nodetonodeencryptionoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-nodetonodeencryptionoptions</a>
         * @param nodeToNodeEncryptionOptions Specifies whether node-to-node encryption is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeToNodeEncryptionOptions(final software.amazon.awscdk.services.elasticsearch.CfnDomain.NodeToNodeEncryptionOptionsProperty nodeToNodeEncryptionOptions) {
            this.props().nodeToNodeEncryptionOptions(nodeToNodeEncryptionOptions);
            return this;
        }

        /**
         * <em>DEPRECATED</em> .
         * <p>
         * The automated snapshot configuration for the OpenSearch Service domain indices.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-snapshotoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-snapshotoptions</a>
         * @param snapshotOptions <em>DEPRECATED</em> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotOptions(final software.amazon.awscdk.IResolvable snapshotOptions) {
            this.props().snapshotOptions(snapshotOptions);
            return this;
        }
        /**
         * <em>DEPRECATED</em> .
         * <p>
         * The automated snapshot configuration for the OpenSearch Service domain indices.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-snapshotoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-snapshotoptions</a>
         * @param snapshotOptions <em>DEPRECATED</em> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotOptions(final software.amazon.awscdk.services.elasticsearch.CfnDomain.SnapshotOptionsProperty snapshotOptions) {
            this.props().snapshotOptions(snapshotOptions);
            return this;
        }

        /**
         * An arbitrary set of tags (key–value pairs) to associate with the OpenSearch Service domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-tags</a>
         * @param tags An arbitrary set of tags (key–value pairs) to associate with the OpenSearch Service domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The virtual private cloud (VPC) configuration for the OpenSearch Service domain.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html">Launching your Amazon OpenSearch Service domains within a VPC</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-vpcoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-vpcoptions</a>
         * @param vpcOptions The virtual private cloud (VPC) configuration for the OpenSearch Service domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcOptions(final software.amazon.awscdk.IResolvable vpcOptions) {
            this.props().vpcOptions(vpcOptions);
            return this;
        }
        /**
         * The virtual private cloud (VPC) configuration for the OpenSearch Service domain.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html">Launching your Amazon OpenSearch Service domains within a VPC</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-vpcoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-vpcoptions</a>
         * @param vpcOptions The virtual private cloud (VPC) configuration for the OpenSearch Service domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcOptions(final software.amazon.awscdk.services.elasticsearch.CfnDomain.VPCOptionsProperty vpcOptions) {
            this.props().vpcOptions(vpcOptions);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.elasticsearch.CfnDomain}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticsearch.CfnDomain build() {
            return new software.amazon.awscdk.services.elasticsearch.CfnDomain(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.elasticsearch.CfnDomainProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.elasticsearch.CfnDomainProps.Builder();
            }
            return this.props;
        }
    }
}
