package software.amazon.awscdk.services.events;

/**
 * Whether EventBridge include detailed event information in the records it generates.
 * <p>
 * Detailed data can be useful for troubleshooting and debugging.
 * This information includes details of the event itself, as well as target details.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.events.EventBus;
 * import software.amazon.awscdk.services.events.IncludeDetail;
 * import software.amazon.awscdk.services.events.Level;
 * EventBus bus = EventBus.Builder.create(this, "Bus")
 *         .logConfig(LogConfig.builder()
 *                 .includeDetail(IncludeDetail.FULL)
 *                 .level(Level.TRACE)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:52.662Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.IncludeDetail")
public enum IncludeDetail {
    /**
     * FULL: Include all details related to event itself and the request EventBridge sends to the target.
     * <p>
     * Detailed data can be useful for troubleshooting and debugging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FULL,
    /**
     * NONE: Does not include any details.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NONE,
}
