package software.amazon.awscdk.services.events;

/**
 * The level of logging detail to include.
 * <p>
 * This applies to all log destinations for the event bus.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.events.EventBus;
 * import software.amazon.awscdk.services.events.IncludeDetail;
 * import software.amazon.awscdk.services.events.Level;
 * EventBus bus = EventBus.Builder.create(this, "Bus")
 *         .logConfig(LogConfig.builder()
 *                 .includeDetail(IncludeDetail.FULL)
 *                 .level(Level.TRACE)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:52.662Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.Level")
public enum Level {
    /**
     * INFO: EventBridge sends any logs related to errors, as well as major steps performed during event processing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INFO,
    /**
     * ERROR: EventBridge sends any logs related to errors generated during event processing and target delivery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ERROR,
    /**
     * TRACE: EventBridge sends any logs generated during all steps in the event processing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TRACE,
    /**
     * OFF: EventBridge does not send any logs.
     * <p>
     * This is the default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OFF,
}
