package software.amazon.awscdk.services.events;

/**
 * Interface for Logging Configuration of the Event Bus.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.events.EventBus;
 * import software.amazon.awscdk.services.events.IncludeDetail;
 * import software.amazon.awscdk.services.events.Level;
 * EventBus bus = EventBus.Builder.create(this, "Bus")
 *         .logConfig(LogConfig.builder()
 *                 .includeDetail(IncludeDetail.FULL)
 *                 .level(Level.TRACE)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:52.662Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.LogConfig")
@software.amazon.jsii.Jsii.Proxy(LogConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LogConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether EventBridge include detailed event information in the records it generates.
     * <p>
     * Default: no details
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.IncludeDetail getIncludeDetail() {
        return null;
    }

    /**
     * Logging level.
     * <p>
     * Default: OFF
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.Level getLevel() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LogConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LogConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LogConfig> {
        software.amazon.awscdk.services.events.IncludeDetail includeDetail;
        software.amazon.awscdk.services.events.Level level;

        /**
         * Sets the value of {@link LogConfig#getIncludeDetail}
         * @param includeDetail Whether EventBridge include detailed event information in the records it generates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeDetail(software.amazon.awscdk.services.events.IncludeDetail includeDetail) {
            this.includeDetail = includeDetail;
            return this;
        }

        /**
         * Sets the value of {@link LogConfig#getLevel}
         * @param level Logging level.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder level(software.amazon.awscdk.services.events.Level level) {
            this.level = level;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LogConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LogConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LogConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogConfig {
        private final software.amazon.awscdk.services.events.IncludeDetail includeDetail;
        private final software.amazon.awscdk.services.events.Level level;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.includeDetail = software.amazon.jsii.Kernel.get(this, "includeDetail", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.IncludeDetail.class));
            this.level = software.amazon.jsii.Kernel.get(this, "level", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Level.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.includeDetail = builder.includeDetail;
            this.level = builder.level;
        }

        @Override
        public final software.amazon.awscdk.services.events.IncludeDetail getIncludeDetail() {
            return this.includeDetail;
        }

        @Override
        public final software.amazon.awscdk.services.events.Level getLevel() {
            return this.level;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getIncludeDetail() != null) {
                data.set("includeDetail", om.valueToTree(this.getIncludeDetail()));
            }
            if (this.getLevel() != null) {
                data.set("level", om.valueToTree(this.getLevel()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.LogConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LogConfig.Jsii$Proxy that = (LogConfig.Jsii$Proxy) o;

            if (this.includeDetail != null ? !this.includeDetail.equals(that.includeDetail) : that.includeDetail != null) return false;
            return this.level != null ? this.level.equals(that.level) : that.level == null;
        }

        @Override
        public final int hashCode() {
            int result = this.includeDetail != null ? this.includeDetail.hashCode() : 0;
            result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
            return result;
        }
    }
}
