package software.amazon.awscdk.services.evs;

/**
 * Properties for defining a <code>CfnEnvironment</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.evs.*;
 * CfnEnvironmentProps cfnEnvironmentProps = CfnEnvironmentProps.builder()
 *         .connectivityInfo(ConnectivityInfoProperty.builder()
 *                 .privateRouteServerPeerings(List.of("privateRouteServerPeerings"))
 *                 .build())
 *         .licenseInfo(LicenseInfoProperty.builder()
 *                 .solutionKey("solutionKey")
 *                 .vsanKey("vsanKey")
 *                 .build())
 *         .serviceAccessSubnetId("serviceAccessSubnetId")
 *         .siteId("siteId")
 *         .termsAccepted(false)
 *         .vcfHostnames(VcfHostnamesProperty.builder()
 *                 .cloudBuilder("cloudBuilder")
 *                 .nsx("nsx")
 *                 .nsxEdge1("nsxEdge1")
 *                 .nsxEdge2("nsxEdge2")
 *                 .nsxManager1("nsxManager1")
 *                 .nsxManager2("nsxManager2")
 *                 .nsxManager3("nsxManager3")
 *                 .sddcManager("sddcManager")
 *                 .vCenter("vCenter")
 *                 .build())
 *         .vcfVersion("vcfVersion")
 *         .vpcId("vpcId")
 *         // the properties below are optional
 *         .environmentName("environmentName")
 *         .hosts(List.of(HostInfoForCreateProperty.builder()
 *                 .hostName("hostName")
 *                 .instanceType("instanceType")
 *                 .keyName("keyName")
 *                 // the properties below are optional
 *                 .dedicatedHostId("dedicatedHostId")
 *                 .placementGroupId("placementGroupId")
 *                 .build()))
 *         .initialVlans(InitialVlansProperty.builder()
 *                 .edgeVTep(InitialVlanInfoProperty.builder()
 *                         .cidr("cidr")
 *                         .build())
 *                 .expansionVlan1(InitialVlanInfoProperty.builder()
 *                         .cidr("cidr")
 *                         .build())
 *                 .expansionVlan2(InitialVlanInfoProperty.builder()
 *                         .cidr("cidr")
 *                         .build())
 *                 .hcx(InitialVlanInfoProperty.builder()
 *                         .cidr("cidr")
 *                         .build())
 *                 .nsxUpLink(InitialVlanInfoProperty.builder()
 *                         .cidr("cidr")
 *                         .build())
 *                 .vmkManagement(InitialVlanInfoProperty.builder()
 *                         .cidr("cidr")
 *                         .build())
 *                 .vmManagement(InitialVlanInfoProperty.builder()
 *                         .cidr("cidr")
 *                         .build())
 *                 .vMotion(InitialVlanInfoProperty.builder()
 *                         .cidr("cidr")
 *                         .build())
 *                 .vSan(InitialVlanInfoProperty.builder()
 *                         .cidr("cidr")
 *                         .build())
 *                 .vTep(InitialVlanInfoProperty.builder()
 *                         .cidr("cidr")
 *                         .build())
 *                 // the properties below are optional
 *                 .hcxNetworkAclId("hcxNetworkAclId")
 *                 .isHcxPublic(false)
 *                 .build())
 *         .kmsKeyId("kmsKeyId")
 *         .serviceAccessSecurityGroups(ServiceAccessSecurityGroupsProperty.builder()
 *                 .securityGroups(List.of("securityGroups"))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:52.800Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evs.CfnEnvironmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnEnvironmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEnvironmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The connectivity configuration for the environment.
     * <p>
     * Amazon EVS requires that you specify two route server peer IDs. During environment creation, the route server endpoints peer with the NSX uplink VLAN for connectivity to the NSX overlay network.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.evs.CfnEnvironment.ConnectivityInfoProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-connectivityinfo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-connectivityinfo</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getConnectivityInfo();

    /**
     * The license information that Amazon EVS requires to create an environment.
     * <p>
     * Amazon EVS requires two license keys: a VCF solution key and a vSAN license key. The VCF solution key must cover a minimum of 256 cores. The vSAN license key must provide at least 110 TiB of vSAN capacity.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.evs.CfnEnvironment.LicenseInfoProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-licenseinfo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-licenseinfo</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getLicenseInfo();

    /**
     * The subnet that is used to establish connectivity between the Amazon EVS control plane and VPC.
     * <p>
     * Amazon EVS uses this subnet to perform validations and create the environment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-serviceaccesssubnetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-serviceaccesssubnetid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceAccessSubnetId();

    /**
     * The Broadcom Site ID that is associated with your Amazon EVS environment.
     * <p>
     * Amazon EVS uses the Broadcom Site ID that you provide to meet Broadcom VCF license usage reporting requirements for Amazon EVS.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-siteid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-siteid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSiteId();

    /**
     * Customer confirmation that the customer has purchased and will continue to maintain the required number of VCF software licenses to cover all physical processor cores in the Amazon EVS environment.
     * <p>
     * Information about your VCF software in Amazon EVS will be shared with Broadcom to verify license compliance. Amazon EVS does not validate license keys. To validate license keys, visit the Broadcom support portal.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-termsaccepted">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-termsaccepted</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTermsAccepted();

    /**
     * The DNS hostnames to be used by the VCF management appliances in your environment.
     * <p>
     * For environment creation to be successful, each hostname entry must resolve to a domain name that you've registered in your DNS service of choice and configured in the DHCP option set of your VPC. DNS hostnames cannot be changed after environment creation has started.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.evs.CfnEnvironment.VcfHostnamesProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-vcfhostnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-vcfhostnames</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getVcfHostnames();

    /**
     * The VCF version of the environment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-vcfversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-vcfversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVcfVersion();

    /**
     * The VPC associated with the environment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-vpcid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-vpcid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpcId();

    /**
     * The name of the environment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-environmentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-environmentname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnvironmentName() {
        return null;
    }

    /**
     * Required for environment resource creation.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.evs.CfnEnvironment.HostInfoForCreateProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-hosts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-hosts</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHosts() {
        return null;
    }

    /**
     * <blockquote><p>Amazon EVS is in public preview release and is subject to change.<p></blockquote>
     * <p>
     * The initial VLAN subnets for the environment. Amazon EVS VLAN subnets have a minimum CIDR block size of /28 and a maximum size of /24. Amazon EVS VLAN subnet CIDR blocks must not overlap with other subnets in the VPC.
     * <p>
     * Required for environment resource creation.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.evs.CfnEnvironment.InitialVlansProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-initialvlans">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-initialvlans</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInitialVlans() {
        return null;
    }

    /**
     * The AWS KMS key ID that AWS Secrets Manager uses to encrypt secrets that are associated with the environment.
     * <p>
     * These secrets contain the VCF credentials that are needed to install vCenter Server, NSX, and SDDC Manager.
     * <p>
     * By default, Amazon EVS use the AWS Secrets Manager managed key <code>aws/secretsmanager</code> . You can also specify a customer managed key.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * The security groups that allow traffic between the Amazon EVS control plane and your VPC for service access.
     * <p>
     * If a security group is not specified, Amazon EVS uses the default security group in your account for service access.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.evs.CfnEnvironment.ServiceAccessSecurityGroupsProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-serviceaccesssecuritygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-serviceaccesssecuritygroups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getServiceAccessSecurityGroups() {
        return null;
    }

    /**
     * Metadata that assists with categorization and organization.
     * <p>
     * Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or AWS resources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evs-environment.html#cfn-evs-environment-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEnvironmentProps> {
        java.lang.Object connectivityInfo;
        java.lang.Object licenseInfo;
        java.lang.String serviceAccessSubnetId;
        java.lang.String siteId;
        java.lang.Object termsAccepted;
        java.lang.Object vcfHostnames;
        java.lang.String vcfVersion;
        java.lang.String vpcId;
        java.lang.String environmentName;
        java.lang.Object hosts;
        java.lang.Object initialVlans;
        java.lang.String kmsKeyId;
        java.lang.Object serviceAccessSecurityGroups;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnEnvironmentProps#getConnectivityInfo}
         * @param connectivityInfo The connectivity configuration for the environment. This parameter is required.
         *                         Amazon EVS requires that you specify two route server peer IDs. During environment creation, the route server endpoints peer with the NSX uplink VLAN for connectivity to the NSX overlay network.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectivityInfo(software.amazon.awscdk.IResolvable connectivityInfo) {
            this.connectivityInfo = connectivityInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getConnectivityInfo}
         * @param connectivityInfo The connectivity configuration for the environment. This parameter is required.
         *                         Amazon EVS requires that you specify two route server peer IDs. During environment creation, the route server endpoints peer with the NSX uplink VLAN for connectivity to the NSX overlay network.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectivityInfo(software.amazon.awscdk.services.evs.CfnEnvironment.ConnectivityInfoProperty connectivityInfo) {
            this.connectivityInfo = connectivityInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getLicenseInfo}
         * @param licenseInfo The license information that Amazon EVS requires to create an environment. This parameter is required.
         *                    Amazon EVS requires two license keys: a VCF solution key and a vSAN license key. The VCF solution key must cover a minimum of 256 cores. The vSAN license key must provide at least 110 TiB of vSAN capacity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder licenseInfo(software.amazon.awscdk.IResolvable licenseInfo) {
            this.licenseInfo = licenseInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getLicenseInfo}
         * @param licenseInfo The license information that Amazon EVS requires to create an environment. This parameter is required.
         *                    Amazon EVS requires two license keys: a VCF solution key and a vSAN license key. The VCF solution key must cover a minimum of 256 cores. The vSAN license key must provide at least 110 TiB of vSAN capacity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder licenseInfo(software.amazon.awscdk.services.evs.CfnEnvironment.LicenseInfoProperty licenseInfo) {
            this.licenseInfo = licenseInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getServiceAccessSubnetId}
         * @param serviceAccessSubnetId The subnet that is used to establish connectivity between the Amazon EVS control plane and VPC. This parameter is required.
         *                              Amazon EVS uses this subnet to perform validations and create the environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccessSubnetId(java.lang.String serviceAccessSubnetId) {
            this.serviceAccessSubnetId = serviceAccessSubnetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getSiteId}
         * @param siteId The Broadcom Site ID that is associated with your Amazon EVS environment. This parameter is required.
         *               Amazon EVS uses the Broadcom Site ID that you provide to meet Broadcom VCF license usage reporting requirements for Amazon EVS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder siteId(java.lang.String siteId) {
            this.siteId = siteId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getTermsAccepted}
         * @param termsAccepted Customer confirmation that the customer has purchased and will continue to maintain the required number of VCF software licenses to cover all physical processor cores in the Amazon EVS environment. This parameter is required.
         *                      Information about your VCF software in Amazon EVS will be shared with Broadcom to verify license compliance. Amazon EVS does not validate license keys. To validate license keys, visit the Broadcom support portal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder termsAccepted(java.lang.Boolean termsAccepted) {
            this.termsAccepted = termsAccepted;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getTermsAccepted}
         * @param termsAccepted Customer confirmation that the customer has purchased and will continue to maintain the required number of VCF software licenses to cover all physical processor cores in the Amazon EVS environment. This parameter is required.
         *                      Information about your VCF software in Amazon EVS will be shared with Broadcom to verify license compliance. Amazon EVS does not validate license keys. To validate license keys, visit the Broadcom support portal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder termsAccepted(software.amazon.awscdk.IResolvable termsAccepted) {
            this.termsAccepted = termsAccepted;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getVcfHostnames}
         * @param vcfHostnames The DNS hostnames to be used by the VCF management appliances in your environment. This parameter is required.
         *                     For environment creation to be successful, each hostname entry must resolve to a domain name that you've registered in your DNS service of choice and configured in the DHCP option set of your VPC. DNS hostnames cannot be changed after environment creation has started.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vcfHostnames(software.amazon.awscdk.IResolvable vcfHostnames) {
            this.vcfHostnames = vcfHostnames;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getVcfHostnames}
         * @param vcfHostnames The DNS hostnames to be used by the VCF management appliances in your environment. This parameter is required.
         *                     For environment creation to be successful, each hostname entry must resolve to a domain name that you've registered in your DNS service of choice and configured in the DHCP option set of your VPC. DNS hostnames cannot be changed after environment creation has started.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vcfHostnames(software.amazon.awscdk.services.evs.CfnEnvironment.VcfHostnamesProperty vcfHostnames) {
            this.vcfHostnames = vcfHostnames;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getVcfVersion}
         * @param vcfVersion The VCF version of the environment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vcfVersion(java.lang.String vcfVersion) {
            this.vcfVersion = vcfVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getVpcId}
         * @param vpcId The VPC associated with the environment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getEnvironmentName}
         * @param environmentName The name of the environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentName(java.lang.String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getHosts}
         * @param hosts Required for environment resource creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hosts(software.amazon.awscdk.IResolvable hosts) {
            this.hosts = hosts;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getHosts}
         * @param hosts Required for environment resource creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hosts(java.util.List<? extends java.lang.Object> hosts) {
            this.hosts = hosts;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getInitialVlans}
         * @param initialVlans <blockquote><p>Amazon EVS is in public preview release and is subject to change.<p></blockquote>
         *                     The initial VLAN subnets for the environment. Amazon EVS VLAN subnets have a minimum CIDR block size of /28 and a maximum size of /24. Amazon EVS VLAN subnet CIDR blocks must not overlap with other subnets in the VPC.
         *                     <p>
         *                     Required for environment resource creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialVlans(software.amazon.awscdk.IResolvable initialVlans) {
            this.initialVlans = initialVlans;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getInitialVlans}
         * @param initialVlans <blockquote><p>Amazon EVS is in public preview release and is subject to change.<p></blockquote>
         *                     The initial VLAN subnets for the environment. Amazon EVS VLAN subnets have a minimum CIDR block size of /28 and a maximum size of /24. Amazon EVS VLAN subnet CIDR blocks must not overlap with other subnets in the VPC.
         *                     <p>
         *                     Required for environment resource creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialVlans(software.amazon.awscdk.services.evs.CfnEnvironment.InitialVlansProperty initialVlans) {
            this.initialVlans = initialVlans;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getKmsKeyId}
         * @param kmsKeyId The AWS KMS key ID that AWS Secrets Manager uses to encrypt secrets that are associated with the environment.
         *                 These secrets contain the VCF credentials that are needed to install vCenter Server, NSX, and SDDC Manager.
         *                 <p>
         *                 By default, Amazon EVS use the AWS Secrets Manager managed key <code>aws/secretsmanager</code> . You can also specify a customer managed key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getServiceAccessSecurityGroups}
         * @param serviceAccessSecurityGroups The security groups that allow traffic between the Amazon EVS control plane and your VPC for service access.
         *                                    If a security group is not specified, Amazon EVS uses the default security group in your account for service access.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccessSecurityGroups(software.amazon.awscdk.IResolvable serviceAccessSecurityGroups) {
            this.serviceAccessSecurityGroups = serviceAccessSecurityGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getServiceAccessSecurityGroups}
         * @param serviceAccessSecurityGroups The security groups that allow traffic between the Amazon EVS control plane and your VPC for service access.
         *                                    If a security group is not specified, Amazon EVS uses the default security group in your account for service access.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccessSecurityGroups(software.amazon.awscdk.services.evs.CfnEnvironment.ServiceAccessSecurityGroupsProperty serviceAccessSecurityGroups) {
            this.serviceAccessSecurityGroups = serviceAccessSecurityGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getTags}
         * @param tags Metadata that assists with categorization and organization.
         *             Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or AWS resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEnvironmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEnvironmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEnvironmentProps {
        private final java.lang.Object connectivityInfo;
        private final java.lang.Object licenseInfo;
        private final java.lang.String serviceAccessSubnetId;
        private final java.lang.String siteId;
        private final java.lang.Object termsAccepted;
        private final java.lang.Object vcfHostnames;
        private final java.lang.String vcfVersion;
        private final java.lang.String vpcId;
        private final java.lang.String environmentName;
        private final java.lang.Object hosts;
        private final java.lang.Object initialVlans;
        private final java.lang.String kmsKeyId;
        private final java.lang.Object serviceAccessSecurityGroups;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.connectivityInfo = software.amazon.jsii.Kernel.get(this, "connectivityInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.licenseInfo = software.amazon.jsii.Kernel.get(this, "licenseInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.serviceAccessSubnetId = software.amazon.jsii.Kernel.get(this, "serviceAccessSubnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.siteId = software.amazon.jsii.Kernel.get(this, "siteId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.termsAccepted = software.amazon.jsii.Kernel.get(this, "termsAccepted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vcfHostnames = software.amazon.jsii.Kernel.get(this, "vcfHostnames", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vcfVersion = software.amazon.jsii.Kernel.get(this, "vcfVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentName = software.amazon.jsii.Kernel.get(this, "environmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hosts = software.amazon.jsii.Kernel.get(this, "hosts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.initialVlans = software.amazon.jsii.Kernel.get(this, "initialVlans", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceAccessSecurityGroups = software.amazon.jsii.Kernel.get(this, "serviceAccessSecurityGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connectivityInfo = java.util.Objects.requireNonNull(builder.connectivityInfo, "connectivityInfo is required");
            this.licenseInfo = java.util.Objects.requireNonNull(builder.licenseInfo, "licenseInfo is required");
            this.serviceAccessSubnetId = java.util.Objects.requireNonNull(builder.serviceAccessSubnetId, "serviceAccessSubnetId is required");
            this.siteId = java.util.Objects.requireNonNull(builder.siteId, "siteId is required");
            this.termsAccepted = java.util.Objects.requireNonNull(builder.termsAccepted, "termsAccepted is required");
            this.vcfHostnames = java.util.Objects.requireNonNull(builder.vcfHostnames, "vcfHostnames is required");
            this.vcfVersion = java.util.Objects.requireNonNull(builder.vcfVersion, "vcfVersion is required");
            this.vpcId = java.util.Objects.requireNonNull(builder.vpcId, "vpcId is required");
            this.environmentName = builder.environmentName;
            this.hosts = builder.hosts;
            this.initialVlans = builder.initialVlans;
            this.kmsKeyId = builder.kmsKeyId;
            this.serviceAccessSecurityGroups = builder.serviceAccessSecurityGroups;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getConnectivityInfo() {
            return this.connectivityInfo;
        }

        @Override
        public final java.lang.Object getLicenseInfo() {
            return this.licenseInfo;
        }

        @Override
        public final java.lang.String getServiceAccessSubnetId() {
            return this.serviceAccessSubnetId;
        }

        @Override
        public final java.lang.String getSiteId() {
            return this.siteId;
        }

        @Override
        public final java.lang.Object getTermsAccepted() {
            return this.termsAccepted;
        }

        @Override
        public final java.lang.Object getVcfHostnames() {
            return this.vcfHostnames;
        }

        @Override
        public final java.lang.String getVcfVersion() {
            return this.vcfVersion;
        }

        @Override
        public final java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final java.lang.String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final java.lang.Object getHosts() {
            return this.hosts;
        }

        @Override
        public final java.lang.Object getInitialVlans() {
            return this.initialVlans;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.Object getServiceAccessSecurityGroups() {
            return this.serviceAccessSecurityGroups;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("connectivityInfo", om.valueToTree(this.getConnectivityInfo()));
            data.set("licenseInfo", om.valueToTree(this.getLicenseInfo()));
            data.set("serviceAccessSubnetId", om.valueToTree(this.getServiceAccessSubnetId()));
            data.set("siteId", om.valueToTree(this.getSiteId()));
            data.set("termsAccepted", om.valueToTree(this.getTermsAccepted()));
            data.set("vcfHostnames", om.valueToTree(this.getVcfHostnames()));
            data.set("vcfVersion", om.valueToTree(this.getVcfVersion()));
            data.set("vpcId", om.valueToTree(this.getVpcId()));
            if (this.getEnvironmentName() != null) {
                data.set("environmentName", om.valueToTree(this.getEnvironmentName()));
            }
            if (this.getHosts() != null) {
                data.set("hosts", om.valueToTree(this.getHosts()));
            }
            if (this.getInitialVlans() != null) {
                data.set("initialVlans", om.valueToTree(this.getInitialVlans()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getServiceAccessSecurityGroups() != null) {
                data.set("serviceAccessSecurityGroups", om.valueToTree(this.getServiceAccessSecurityGroups()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evs.CfnEnvironmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEnvironmentProps.Jsii$Proxy that = (CfnEnvironmentProps.Jsii$Proxy) o;

            if (!connectivityInfo.equals(that.connectivityInfo)) return false;
            if (!licenseInfo.equals(that.licenseInfo)) return false;
            if (!serviceAccessSubnetId.equals(that.serviceAccessSubnetId)) return false;
            if (!siteId.equals(that.siteId)) return false;
            if (!termsAccepted.equals(that.termsAccepted)) return false;
            if (!vcfHostnames.equals(that.vcfHostnames)) return false;
            if (!vcfVersion.equals(that.vcfVersion)) return false;
            if (!vpcId.equals(that.vpcId)) return false;
            if (this.environmentName != null ? !this.environmentName.equals(that.environmentName) : that.environmentName != null) return false;
            if (this.hosts != null ? !this.hosts.equals(that.hosts) : that.hosts != null) return false;
            if (this.initialVlans != null ? !this.initialVlans.equals(that.initialVlans) : that.initialVlans != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.serviceAccessSecurityGroups != null ? !this.serviceAccessSecurityGroups.equals(that.serviceAccessSecurityGroups) : that.serviceAccessSecurityGroups != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.connectivityInfo.hashCode();
            result = 31 * result + (this.licenseInfo.hashCode());
            result = 31 * result + (this.serviceAccessSubnetId.hashCode());
            result = 31 * result + (this.siteId.hashCode());
            result = 31 * result + (this.termsAccepted.hashCode());
            result = 31 * result + (this.vcfHostnames.hashCode());
            result = 31 * result + (this.vcfVersion.hashCode());
            result = 31 * result + (this.vpcId.hashCode());
            result = 31 * result + (this.environmentName != null ? this.environmentName.hashCode() : 0);
            result = 31 * result + (this.hosts != null ? this.hosts.hashCode() : 0);
            result = 31 * result + (this.initialVlans != null ? this.initialVlans.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.serviceAccessSecurityGroups != null ? this.serviceAccessSecurityGroups.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
