package software.amazon.awscdk.services.gamelift;

/**
 * Describes an Amazon GameLift Servers managed container fleet.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.gamelift.*;
 * CfnContainerFleet cfnContainerFleet = CfnContainerFleet.Builder.create(this, "MyCfnContainerFleet")
 *         .fleetRoleArn("fleetRoleArn")
 *         // the properties below are optional
 *         .billingType("billingType")
 *         .deploymentConfiguration(DeploymentConfigurationProperty.builder()
 *                 .impairmentStrategy("impairmentStrategy")
 *                 .minimumHealthyPercentage(123)
 *                 .protectionStrategy("protectionStrategy")
 *                 .build())
 *         .description("description")
 *         .gameServerContainerGroupDefinitionName("gameServerContainerGroupDefinitionName")
 *         .gameServerContainerGroupsPerInstance(123)
 *         .gameSessionCreationLimitPolicy(GameSessionCreationLimitPolicyProperty.builder()
 *                 .newGameSessionsPerCreator(123)
 *                 .policyPeriodInMinutes(123)
 *                 .build())
 *         .instanceConnectionPortRange(ConnectionPortRangeProperty.builder()
 *                 .fromPort(123)
 *                 .toPort(123)
 *                 .build())
 *         .instanceInboundPermissions(List.of(IpPermissionProperty.builder()
 *                 .fromPort(123)
 *                 .ipRange("ipRange")
 *                 .protocol("protocol")
 *                 .toPort(123)
 *                 .build()))
 *         .instanceType("instanceType")
 *         .locations(List.of(LocationConfigurationProperty.builder()
 *                 .location("location")
 *                 // the properties below are optional
 *                 .locationCapacity(LocationCapacityProperty.builder()
 *                         .maxSize(123)
 *                         .minSize(123)
 *                         // the properties below are optional
 *                         .desiredEc2Instances(123)
 *                         .build())
 *                 .stoppedActions(List.of("stoppedActions"))
 *                 .build()))
 *         .logConfiguration(LogConfigurationProperty.builder()
 *                 .logDestination("logDestination")
 *                 .logGroupArn("logGroupArn")
 *                 .s3BucketName("s3BucketName")
 *                 .build())
 *         .metricGroups(List.of("metricGroups"))
 *         .newGameSessionProtectionPolicy("newGameSessionProtectionPolicy")
 *         .perInstanceContainerGroupDefinitionName("perInstanceContainerGroupDefinitionName")
 *         .scalingPolicies(List.of(ScalingPolicyProperty.builder()
 *                 .metricName("metricName")
 *                 .name("name")
 *                 // the properties below are optional
 *                 .comparisonOperator("comparisonOperator")
 *                 .evaluationPeriods(123)
 *                 .policyType("policyType")
 *                 .scalingAdjustment(123)
 *                 .scalingAdjustmentType("scalingAdjustmentType")
 *                 .targetConfiguration(TargetConfigurationProperty.builder()
 *                         .targetValue(123)
 *                         .build())
 *                 .threshold(123)
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:53.002Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerFleet")
public class CfnContainerFleet extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.gamelift.IContainerFleetRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnContainerFleet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnContainerFleet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.gamelift.CfnContainerFleet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::GameLift::ContainerFleet</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnContainerFleet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.gamelift.CfnContainerFleetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new IContainerFleetRef from a fleetId.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param fleetId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.gamelift.IContainerFleetRef fromFleetId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String fleetId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.gamelift.CfnContainerFleet.class, "fromFleetId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.gamelift.IContainerFleetRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(fleetId, "fleetId is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * A time stamp indicating when this data object was created.
     * <p>
     * Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Provides information about the last deployment ID and its status.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrDeploymentDetails() {
        return software.amazon.jsii.Kernel.get(this, "attrDeploymentDetails", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The Amazon Resource Name ( <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a> ) that is assigned to a Amazon GameLift Servers fleet resource and uniquely identifies it. ARNs are unique across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code> . In a GameLift fleet ARN, the resource ID matches the <code>FleetId</code> value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFleetArn() {
        return software.amazon.jsii.Kernel.get(this, "attrFleetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A unique identifier for the container fleet to retrieve.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFleetId() {
        return software.amazon.jsii.Kernel.get(this, "attrFleetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name ( <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a> ) that is assigned to the fleet's game server container group. The ARN value also identifies the specific container group definition version in use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrGameServerContainerGroupDefinitionArn() {
        return software.amazon.jsii.Kernel.get(this, "attrGameServerContainerGroupDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The calculated maximum number of game server container group that can be deployed on each fleet instance.
     * <p>
     * The calculation depends on the resource needs of the container group and the CPU and memory resources of the fleet's instance type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrMaximumGameServerContainerGroupsPerInstance() {
        return software.amazon.jsii.Kernel.get(this, "attrMaximumGameServerContainerGroupsPerInstance", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The Amazon Resource Name ( <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a> ) that is assigned to the fleet's per-instance container group. The ARN value also identifies the specific container group definition version in use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPerInstanceContainerGroupDefinitionArn() {
        return software.amazon.jsii.Kernel.get(this, "attrPerInstanceContainerGroupDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The current status of the container fleet.
     * <p>
     * <ul>
     * <li><code>PENDING</code> -- A new container fleet has been requested.</li>
     * <li><code>CREATING</code> -- A new container fleet resource is being created.</li>
     * <li><code>CREATED</code> -- A new container fleet resource has been created. No fleet instances have been deployed.</li>
     * <li><code>ACTIVATING</code> -- New container fleet instances are being deployed.</li>
     * <li><code>ACTIVE</code> -- The container fleet has been deployed and is ready to host game sessions.</li>
     * <li><code>UPDATING</code> -- Updates to the container fleet is being updated. A deployment is in progress.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a ContainerFleet resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.gamelift.ContainerFleetReference getContainerFleetRef() {
        return software.amazon.jsii.Kernel.get(this, "containerFleetRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.gamelift.ContainerFleetReference.class));
    }

    /**
     * The unique identifier for an AWS Identity and Access Management (IAM) role with permissions to run your containers on resources that are managed by Amazon GameLift Servers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFleetRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "fleetRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier for an AWS Identity and Access Management (IAM) role with permissions to run your containers on resources that are managed by Amazon GameLift Servers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFleetRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "fleetRoleArn", java.util.Objects.requireNonNull(value, "fleetRoleArn is required"));
    }

    /**
     * Indicates whether the fleet uses On-Demand or Spot instances for this fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBillingType() {
        return software.amazon.jsii.Kernel.get(this, "billingType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates whether the fleet uses On-Demand or Spot instances for this fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBillingType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "billingType", value);
    }

    /**
     * Set of rules for processing a deployment for a container fleet update.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.gamelift.CfnContainerFleet.DeploymentConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "deploymentConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Set of rules for processing a deployment for a container fleet update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deploymentConfiguration", value);
    }

    /**
     * Set of rules for processing a deployment for a container fleet update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.gamelift.CfnContainerFleet.DeploymentConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "deploymentConfiguration", value);
    }

    /**
     * A meaningful description of the container fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A meaningful description of the container fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The name of the fleet's game server container group definition, which describes how to deploy containers with your game server build and support software onto each fleet instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getGameServerContainerGroupDefinitionName() {
        return software.amazon.jsii.Kernel.get(this, "gameServerContainerGroupDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the fleet's game server container group definition, which describes how to deploy containers with your game server build and support software onto each fleet instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGameServerContainerGroupDefinitionName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "gameServerContainerGroupDefinitionName", value);
    }

    /**
     * The number of times to replicate the game server container group on each fleet instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getGameServerContainerGroupsPerInstance() {
        return software.amazon.jsii.Kernel.get(this, "gameServerContainerGroupsPerInstance", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of times to replicate the game server container group on each fleet instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGameServerContainerGroupsPerInstance(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "gameServerContainerGroupsPerInstance", value);
    }

    /**
     * A policy that limits the number of game sessions that each individual player can create on instances in this fleet.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.gamelift.CfnContainerFleet.GameSessionCreationLimitPolicyProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGameSessionCreationLimitPolicy() {
        return software.amazon.jsii.Kernel.get(this, "gameSessionCreationLimitPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A policy that limits the number of game sessions that each individual player can create on instances in this fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGameSessionCreationLimitPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "gameSessionCreationLimitPolicy", value);
    }

    /**
     * A policy that limits the number of game sessions that each individual player can create on instances in this fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGameSessionCreationLimitPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.gamelift.CfnContainerFleet.GameSessionCreationLimitPolicyProperty value) {
        software.amazon.jsii.Kernel.set(this, "gameSessionCreationLimitPolicy", value);
    }

    /**
     * The set of port numbers to open on each instance in a container fleet.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.gamelift.CfnContainerFleet.ConnectionPortRangeProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInstanceConnectionPortRange() {
        return software.amazon.jsii.Kernel.get(this, "instanceConnectionPortRange", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The set of port numbers to open on each instance in a container fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceConnectionPortRange(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "instanceConnectionPortRange", value);
    }

    /**
     * The set of port numbers to open on each instance in a container fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceConnectionPortRange(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.gamelift.CfnContainerFleet.ConnectionPortRangeProperty value) {
        software.amazon.jsii.Kernel.set(this, "instanceConnectionPortRange", value);
    }

    /**
     * The IP address ranges and port settings that allow inbound traffic to access game server processes and other processes on this fleet.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.gamelift.CfnContainerFleet.IpPermissionProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInstanceInboundPermissions() {
        return software.amazon.jsii.Kernel.get(this, "instanceInboundPermissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The IP address ranges and port settings that allow inbound traffic to access game server processes and other processes on this fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceInboundPermissions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "instanceInboundPermissions", value);
    }

    /**
     * The IP address ranges and port settings that allow inbound traffic to access game server processes and other processes on this fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceInboundPermissions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.gamelift.CfnContainerFleet.IpPermissionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.gamelift.CfnContainerFleet.IpPermissionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "instanceInboundPermissions", value);
    }

    /**
     * The Amazon EC2 instance type to use for all instances in the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
        return software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon EC2 instance type to use for all instances in the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceType", value);
    }

    /**
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.gamelift.CfnContainerFleet.LocationConfigurationProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLocations() {
        return software.amazon.jsii.Kernel.get(this, "locations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLocations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "locations", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLocations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.gamelift.CfnContainerFleet.LocationConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.gamelift.CfnContainerFleet.LocationConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "locations", value);
    }

    /**
     * The method that is used to collect container logs for the fleet.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.gamelift.CfnContainerFleet.LogConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "logConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The method that is used to collect container logs for the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "logConfiguration", value);
    }

    /**
     * The method that is used to collect container logs for the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.gamelift.CfnContainerFleet.LogConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "logConfiguration", value);
    }

    /**
     * The name of an AWS CloudWatch metric group to add this fleet to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMetricGroups() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "metricGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The name of an AWS CloudWatch metric group to add this fleet to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricGroups(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "metricGroups", value);
    }

    /**
     * Determines whether Amazon GameLift Servers can shut down game sessions on the fleet that are actively running and hosting players.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNewGameSessionProtectionPolicy() {
        return software.amazon.jsii.Kernel.get(this, "newGameSessionProtectionPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Determines whether Amazon GameLift Servers can shut down game sessions on the fleet that are actively running and hosting players.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNewGameSessionProtectionPolicy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "newGameSessionProtectionPolicy", value);
    }

    /**
     * The name of the fleet's per-instance container group definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPerInstanceContainerGroupDefinitionName() {
        return software.amazon.jsii.Kernel.get(this, "perInstanceContainerGroupDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the fleet's per-instance container group definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPerInstanceContainerGroupDefinitionName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "perInstanceContainerGroupDefinitionName", value);
    }

    /**
     * A list of rules that control how a fleet is scaled.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.gamelift.CfnContainerFleet.ScalingPolicyProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getScalingPolicies() {
        return software.amazon.jsii.Kernel.get(this, "scalingPolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of rules that control how a fleet is scaled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScalingPolicies(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "scalingPolicies", value);
    }

    /**
     * A list of rules that control how a fleet is scaled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScalingPolicies(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.gamelift.CfnContainerFleet.ScalingPolicyProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.gamelift.CfnContainerFleet.ScalingPolicyProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "scalingPolicies", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * The set of port numbers to open on each instance in a container fleet.
     * <p>
     * Connection ports are used by inbound traffic to connect with processes that are running in containers on the fleet.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * ConnectionPortRangeProperty connectionPortRangeProperty = ConnectionPortRangeProperty.builder()
     *         .fromPort(123)
     *         .toPort(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-connectionportrange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-connectionportrange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerFleet.ConnectionPortRangeProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectionPortRangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectionPortRangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Starting value for the port range.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-connectionportrange.html#cfn-gamelift-containerfleet-connectionportrange-fromport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-connectionportrange.html#cfn-gamelift-containerfleet-connectionportrange-fromport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getFromPort();

        /**
         * Ending value for the port.
         * <p>
         * Port numbers are end-inclusive. This value must be equal to or greater than <code>FromPort</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-connectionportrange.html#cfn-gamelift-containerfleet-connectionportrange-toport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-connectionportrange.html#cfn-gamelift-containerfleet-connectionportrange-toport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getToPort();

        /**
         * @return a {@link Builder} of {@link ConnectionPortRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectionPortRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectionPortRangeProperty> {
            java.lang.Number fromPort;
            java.lang.Number toPort;

            /**
             * Sets the value of {@link ConnectionPortRangeProperty#getFromPort}
             * @param fromPort Starting value for the port range. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fromPort(java.lang.Number fromPort) {
                this.fromPort = fromPort;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionPortRangeProperty#getToPort}
             * @param toPort Ending value for the port. This parameter is required.
             *               Port numbers are end-inclusive. This value must be equal to or greater than <code>FromPort</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder toPort(java.lang.Number toPort) {
                this.toPort = toPort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectionPortRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectionPortRangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectionPortRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectionPortRangeProperty {
            private final java.lang.Number fromPort;
            private final java.lang.Number toPort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fromPort = software.amazon.jsii.Kernel.get(this, "fromPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.toPort = software.amazon.jsii.Kernel.get(this, "toPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fromPort = java.util.Objects.requireNonNull(builder.fromPort, "fromPort is required");
                this.toPort = java.util.Objects.requireNonNull(builder.toPort, "toPort is required");
            }

            @Override
            public final java.lang.Number getFromPort() {
                return this.fromPort;
            }

            @Override
            public final java.lang.Number getToPort() {
                return this.toPort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fromPort", om.valueToTree(this.getFromPort()));
                data.set("toPort", om.valueToTree(this.getToPort()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerFleet.ConnectionPortRangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectionPortRangeProperty.Jsii$Proxy that = (ConnectionPortRangeProperty.Jsii$Proxy) o;

                if (!fromPort.equals(that.fromPort)) return false;
                return this.toPort.equals(that.toPort);
            }

            @Override
            public final int hashCode() {
                int result = this.fromPort.hashCode();
                result = 31 * result + (this.toPort.hashCode());
                return result;
            }
        }
    }
    /**
     * Set of rules for processing a deployment for a container fleet update.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * DeploymentConfigurationProperty deploymentConfigurationProperty = DeploymentConfigurationProperty.builder()
     *         .impairmentStrategy("impairmentStrategy")
     *         .minimumHealthyPercentage(123)
     *         .protectionStrategy("protectionStrategy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-deploymentconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-deploymentconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerFleet.DeploymentConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines what actions to take if a deployment fails.
         * <p>
         * If the fleet is multi-location, this strategy applies across all fleet locations. With a rollback strategy, updated fleet instances are rolled back to the last successful deployment. Alternatively, you can maintain a few impaired containers for the purpose of debugging, while all other tasks return to the last successful deployment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-deploymentconfiguration.html#cfn-gamelift-containerfleet-deploymentconfiguration-impairmentstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-deploymentconfiguration.html#cfn-gamelift-containerfleet-deploymentconfiguration-impairmentstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImpairmentStrategy() {
            return null;
        }

        /**
         * Sets a minimum level of healthy tasks to maintain during deployment activity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-deploymentconfiguration.html#cfn-gamelift-containerfleet-deploymentconfiguration-minimumhealthypercentage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-deploymentconfiguration.html#cfn-gamelift-containerfleet-deploymentconfiguration-minimumhealthypercentage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinimumHealthyPercentage() {
            return null;
        }

        /**
         * Determines how fleet deployment activity affects active game sessions on the fleet.
         * <p>
         * With protection, a deployment honors game session protection, and delays actions that would interrupt a protected active game session until the game session ends. Without protection, deployment activity can shut down all running tasks, including active game sessions, regardless of game session protection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-deploymentconfiguration.html#cfn-gamelift-containerfleet-deploymentconfiguration-protectionstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-deploymentconfiguration.html#cfn-gamelift-containerfleet-deploymentconfiguration-protectionstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtectionStrategy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeploymentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentConfigurationProperty> {
            java.lang.String impairmentStrategy;
            java.lang.Number minimumHealthyPercentage;
            java.lang.String protectionStrategy;

            /**
             * Sets the value of {@link DeploymentConfigurationProperty#getImpairmentStrategy}
             * @param impairmentStrategy Determines what actions to take if a deployment fails.
             *                           If the fleet is multi-location, this strategy applies across all fleet locations. With a rollback strategy, updated fleet instances are rolled back to the last successful deployment. Alternatively, you can maintain a few impaired containers for the purpose of debugging, while all other tasks return to the last successful deployment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder impairmentStrategy(java.lang.String impairmentStrategy) {
                this.impairmentStrategy = impairmentStrategy;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentConfigurationProperty#getMinimumHealthyPercentage}
             * @param minimumHealthyPercentage Sets a minimum level of healthy tasks to maintain during deployment activity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumHealthyPercentage(java.lang.Number minimumHealthyPercentage) {
                this.minimumHealthyPercentage = minimumHealthyPercentage;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentConfigurationProperty#getProtectionStrategy}
             * @param protectionStrategy Determines how fleet deployment activity affects active game sessions on the fleet.
             *                           With protection, a deployment honors game session protection, and delays actions that would interrupt a protected active game session until the game session ends. Without protection, deployment activity can shut down all running tasks, including active game sessions, regardless of game session protection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protectionStrategy(java.lang.String protectionStrategy) {
                this.protectionStrategy = protectionStrategy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeploymentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentConfigurationProperty {
            private final java.lang.String impairmentStrategy;
            private final java.lang.Number minimumHealthyPercentage;
            private final java.lang.String protectionStrategy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.impairmentStrategy = software.amazon.jsii.Kernel.get(this, "impairmentStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.minimumHealthyPercentage = software.amazon.jsii.Kernel.get(this, "minimumHealthyPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.protectionStrategy = software.amazon.jsii.Kernel.get(this, "protectionStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.impairmentStrategy = builder.impairmentStrategy;
                this.minimumHealthyPercentage = builder.minimumHealthyPercentage;
                this.protectionStrategy = builder.protectionStrategy;
            }

            @Override
            public final java.lang.String getImpairmentStrategy() {
                return this.impairmentStrategy;
            }

            @Override
            public final java.lang.Number getMinimumHealthyPercentage() {
                return this.minimumHealthyPercentage;
            }

            @Override
            public final java.lang.String getProtectionStrategy() {
                return this.protectionStrategy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getImpairmentStrategy() != null) {
                    data.set("impairmentStrategy", om.valueToTree(this.getImpairmentStrategy()));
                }
                if (this.getMinimumHealthyPercentage() != null) {
                    data.set("minimumHealthyPercentage", om.valueToTree(this.getMinimumHealthyPercentage()));
                }
                if (this.getProtectionStrategy() != null) {
                    data.set("protectionStrategy", om.valueToTree(this.getProtectionStrategy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerFleet.DeploymentConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentConfigurationProperty.Jsii$Proxy that = (DeploymentConfigurationProperty.Jsii$Proxy) o;

                if (this.impairmentStrategy != null ? !this.impairmentStrategy.equals(that.impairmentStrategy) : that.impairmentStrategy != null) return false;
                if (this.minimumHealthyPercentage != null ? !this.minimumHealthyPercentage.equals(that.minimumHealthyPercentage) : that.minimumHealthyPercentage != null) return false;
                return this.protectionStrategy != null ? this.protectionStrategy.equals(that.protectionStrategy) : that.protectionStrategy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.impairmentStrategy != null ? this.impairmentStrategy.hashCode() : 0;
                result = 31 * result + (this.minimumHealthyPercentage != null ? this.minimumHealthyPercentage.hashCode() : 0);
                result = 31 * result + (this.protectionStrategy != null ? this.protectionStrategy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the most recent deployment for the container fleet.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * DeploymentDetailsProperty deploymentDetailsProperty = DeploymentDetailsProperty.builder()
     *         .latestDeploymentId("latestDeploymentId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-deploymentdetails.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-deploymentdetails.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerFleet.DeploymentDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A unique identifier for a fleet deployment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-deploymentdetails.html#cfn-gamelift-containerfleet-deploymentdetails-latestdeploymentid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-deploymentdetails.html#cfn-gamelift-containerfleet-deploymentdetails-latestdeploymentid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLatestDeploymentId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeploymentDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentDetailsProperty> {
            java.lang.String latestDeploymentId;

            /**
             * Sets the value of {@link DeploymentDetailsProperty#getLatestDeploymentId}
             * @param latestDeploymentId A unique identifier for a fleet deployment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder latestDeploymentId(java.lang.String latestDeploymentId) {
                this.latestDeploymentId = latestDeploymentId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeploymentDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentDetailsProperty {
            private final java.lang.String latestDeploymentId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.latestDeploymentId = software.amazon.jsii.Kernel.get(this, "latestDeploymentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.latestDeploymentId = builder.latestDeploymentId;
            }

            @Override
            public final java.lang.String getLatestDeploymentId() {
                return this.latestDeploymentId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLatestDeploymentId() != null) {
                    data.set("latestDeploymentId", om.valueToTree(this.getLatestDeploymentId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerFleet.DeploymentDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentDetailsProperty.Jsii$Proxy that = (DeploymentDetailsProperty.Jsii$Proxy) o;

                return this.latestDeploymentId != null ? this.latestDeploymentId.equals(that.latestDeploymentId) : that.latestDeploymentId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.latestDeploymentId != null ? this.latestDeploymentId.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A policy that puts limits on the number of game sessions that a player can create within a specified span of time.
     * <p>
     * With this policy, you can control players' ability to consume available resources.
     * <p>
     * The policy is evaluated when a player tries to create a new game session. On receiving a <code>CreateGameSession</code> request, Amazon GameLift Servers checks that the player (identified by <code>CreatorId</code> ) has created fewer than game session limit in the specified time period.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * GameSessionCreationLimitPolicyProperty gameSessionCreationLimitPolicyProperty = GameSessionCreationLimitPolicyProperty.builder()
     *         .newGameSessionsPerCreator(123)
     *         .policyPeriodInMinutes(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-gamesessioncreationlimitpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-gamesessioncreationlimitpolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerFleet.GameSessionCreationLimitPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(GameSessionCreationLimitPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GameSessionCreationLimitPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A policy that puts limits on the number of game sessions that a player can create within a specified span of time.
         * <p>
         * With this policy, you can control players' ability to consume available resources.
         * <p>
         * The policy evaluates when a player tries to create a new game session. On receiving a <code>CreateGameSession</code> request, Amazon GameLift Servers checks that the player (identified by <code>CreatorId</code> ) has created fewer than game session limit in the specified time period.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-gamesessioncreationlimitpolicy.html#cfn-gamelift-containerfleet-gamesessioncreationlimitpolicy-newgamesessionspercreator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-gamesessioncreationlimitpolicy.html#cfn-gamelift-containerfleet-gamesessioncreationlimitpolicy-newgamesessionspercreator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNewGameSessionsPerCreator() {
            return null;
        }

        /**
         * The time span used in evaluating the resource creation limit policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-gamesessioncreationlimitpolicy.html#cfn-gamelift-containerfleet-gamesessioncreationlimitpolicy-policyperiodinminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-gamesessioncreationlimitpolicy.html#cfn-gamelift-containerfleet-gamesessioncreationlimitpolicy-policyperiodinminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPolicyPeriodInMinutes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GameSessionCreationLimitPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GameSessionCreationLimitPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GameSessionCreationLimitPolicyProperty> {
            java.lang.Number newGameSessionsPerCreator;
            java.lang.Number policyPeriodInMinutes;

            /**
             * Sets the value of {@link GameSessionCreationLimitPolicyProperty#getNewGameSessionsPerCreator}
             * @param newGameSessionsPerCreator A policy that puts limits on the number of game sessions that a player can create within a specified span of time.
             *                                  With this policy, you can control players' ability to consume available resources.
             *                                  <p>
             *                                  The policy evaluates when a player tries to create a new game session. On receiving a <code>CreateGameSession</code> request, Amazon GameLift Servers checks that the player (identified by <code>CreatorId</code> ) has created fewer than game session limit in the specified time period.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder newGameSessionsPerCreator(java.lang.Number newGameSessionsPerCreator) {
                this.newGameSessionsPerCreator = newGameSessionsPerCreator;
                return this;
            }

            /**
             * Sets the value of {@link GameSessionCreationLimitPolicyProperty#getPolicyPeriodInMinutes}
             * @param policyPeriodInMinutes The time span used in evaluating the resource creation limit policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyPeriodInMinutes(java.lang.Number policyPeriodInMinutes) {
                this.policyPeriodInMinutes = policyPeriodInMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GameSessionCreationLimitPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GameSessionCreationLimitPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GameSessionCreationLimitPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GameSessionCreationLimitPolicyProperty {
            private final java.lang.Number newGameSessionsPerCreator;
            private final java.lang.Number policyPeriodInMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.newGameSessionsPerCreator = software.amazon.jsii.Kernel.get(this, "newGameSessionsPerCreator", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.policyPeriodInMinutes = software.amazon.jsii.Kernel.get(this, "policyPeriodInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.newGameSessionsPerCreator = builder.newGameSessionsPerCreator;
                this.policyPeriodInMinutes = builder.policyPeriodInMinutes;
            }

            @Override
            public final java.lang.Number getNewGameSessionsPerCreator() {
                return this.newGameSessionsPerCreator;
            }

            @Override
            public final java.lang.Number getPolicyPeriodInMinutes() {
                return this.policyPeriodInMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNewGameSessionsPerCreator() != null) {
                    data.set("newGameSessionsPerCreator", om.valueToTree(this.getNewGameSessionsPerCreator()));
                }
                if (this.getPolicyPeriodInMinutes() != null) {
                    data.set("policyPeriodInMinutes", om.valueToTree(this.getPolicyPeriodInMinutes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerFleet.GameSessionCreationLimitPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GameSessionCreationLimitPolicyProperty.Jsii$Proxy that = (GameSessionCreationLimitPolicyProperty.Jsii$Proxy) o;

                if (this.newGameSessionsPerCreator != null ? !this.newGameSessionsPerCreator.equals(that.newGameSessionsPerCreator) : that.newGameSessionsPerCreator != null) return false;
                return this.policyPeriodInMinutes != null ? this.policyPeriodInMinutes.equals(that.policyPeriodInMinutes) : that.policyPeriodInMinutes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.newGameSessionsPerCreator != null ? this.newGameSessionsPerCreator.hashCode() : 0;
                result = 31 * result + (this.policyPeriodInMinutes != null ? this.policyPeriodInMinutes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A range of IP addresses and port settings that allow inbound traffic to connect to processes on an instance in a fleet.
     * <p>
     * Processes are assigned an IP address/port number combination, which must fall into the fleet's allowed ranges.
     * <p>
     * For Amazon GameLift Servers Realtime fleets, Amazon GameLift Servers automatically opens two port ranges, one for TCP messaging and one for UDP.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * IpPermissionProperty ipPermissionProperty = IpPermissionProperty.builder()
     *         .fromPort(123)
     *         .ipRange("ipRange")
     *         .protocol("protocol")
     *         .toPort(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-ippermission.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-ippermission.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerFleet.IpPermissionProperty")
    @software.amazon.jsii.Jsii.Proxy(IpPermissionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IpPermissionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A starting value for a range of allowed port numbers.
         * <p>
         * For fleets using Linux builds, only ports <code>22</code> and <code>1026-60000</code> are valid.
         * <p>
         * For fleets using Windows builds, only ports <code>1026-60000</code> are valid.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-ippermission.html#cfn-gamelift-containerfleet-ippermission-fromport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-ippermission.html#cfn-gamelift-containerfleet-ippermission-fromport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getFromPort();

        /**
         * A range of allowed IP addresses.
         * <p>
         * This value must be expressed in CIDR notation. Example: " <code>000.000.000.000/[subnet mask]</code> " or optionally the shortened version " <code>0.0.0.0/[subnet mask]</code> ".
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-ippermission.html#cfn-gamelift-containerfleet-ippermission-iprange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-ippermission.html#cfn-gamelift-containerfleet-ippermission-iprange</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIpRange();

        /**
         * The network communication protocol used by the fleet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-ippermission.html#cfn-gamelift-containerfleet-ippermission-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-ippermission.html#cfn-gamelift-containerfleet-ippermission-protocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProtocol();

        /**
         * An ending value for a range of allowed port numbers.
         * <p>
         * Port numbers are end-inclusive. This value must be equal to or greater than <code>FromPort</code> .
         * <p>
         * For fleets using Linux builds, only ports <code>22</code> and <code>1026-60000</code> are valid.
         * <p>
         * For fleets using Windows builds, only ports <code>1026-60000</code> are valid.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-ippermission.html#cfn-gamelift-containerfleet-ippermission-toport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-ippermission.html#cfn-gamelift-containerfleet-ippermission-toport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getToPort();

        /**
         * @return a {@link Builder} of {@link IpPermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IpPermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IpPermissionProperty> {
            java.lang.Number fromPort;
            java.lang.String ipRange;
            java.lang.String protocol;
            java.lang.Number toPort;

            /**
             * Sets the value of {@link IpPermissionProperty#getFromPort}
             * @param fromPort A starting value for a range of allowed port numbers. This parameter is required.
             *                 For fleets using Linux builds, only ports <code>22</code> and <code>1026-60000</code> are valid.
             *                 <p>
             *                 For fleets using Windows builds, only ports <code>1026-60000</code> are valid.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fromPort(java.lang.Number fromPort) {
                this.fromPort = fromPort;
                return this;
            }

            /**
             * Sets the value of {@link IpPermissionProperty#getIpRange}
             * @param ipRange A range of allowed IP addresses. This parameter is required.
             *                This value must be expressed in CIDR notation. Example: " <code>000.000.000.000/[subnet mask]</code> " or optionally the shortened version " <code>0.0.0.0/[subnet mask]</code> ".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipRange(java.lang.String ipRange) {
                this.ipRange = ipRange;
                return this;
            }

            /**
             * Sets the value of {@link IpPermissionProperty#getProtocol}
             * @param protocol The network communication protocol used by the fleet. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link IpPermissionProperty#getToPort}
             * @param toPort An ending value for a range of allowed port numbers. This parameter is required.
             *               Port numbers are end-inclusive. This value must be equal to or greater than <code>FromPort</code> .
             *               <p>
             *               For fleets using Linux builds, only ports <code>22</code> and <code>1026-60000</code> are valid.
             *               <p>
             *               For fleets using Windows builds, only ports <code>1026-60000</code> are valid.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder toPort(java.lang.Number toPort) {
                this.toPort = toPort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IpPermissionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IpPermissionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IpPermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IpPermissionProperty {
            private final java.lang.Number fromPort;
            private final java.lang.String ipRange;
            private final java.lang.String protocol;
            private final java.lang.Number toPort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fromPort = software.amazon.jsii.Kernel.get(this, "fromPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ipRange = software.amazon.jsii.Kernel.get(this, "ipRange", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.toPort = software.amazon.jsii.Kernel.get(this, "toPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fromPort = java.util.Objects.requireNonNull(builder.fromPort, "fromPort is required");
                this.ipRange = java.util.Objects.requireNonNull(builder.ipRange, "ipRange is required");
                this.protocol = java.util.Objects.requireNonNull(builder.protocol, "protocol is required");
                this.toPort = java.util.Objects.requireNonNull(builder.toPort, "toPort is required");
            }

            @Override
            public final java.lang.Number getFromPort() {
                return this.fromPort;
            }

            @Override
            public final java.lang.String getIpRange() {
                return this.ipRange;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public final java.lang.Number getToPort() {
                return this.toPort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fromPort", om.valueToTree(this.getFromPort()));
                data.set("ipRange", om.valueToTree(this.getIpRange()));
                data.set("protocol", om.valueToTree(this.getProtocol()));
                data.set("toPort", om.valueToTree(this.getToPort()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerFleet.IpPermissionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IpPermissionProperty.Jsii$Proxy that = (IpPermissionProperty.Jsii$Proxy) o;

                if (!fromPort.equals(that.fromPort)) return false;
                if (!ipRange.equals(that.ipRange)) return false;
                if (!protocol.equals(that.protocol)) return false;
                return this.toPort.equals(that.toPort);
            }

            @Override
            public final int hashCode() {
                int result = this.fromPort.hashCode();
                result = 31 * result + (this.ipRange.hashCode());
                result = 31 * result + (this.protocol.hashCode());
                result = 31 * result + (this.toPort.hashCode());
                return result;
            }
        }
    }
    /**
     * Current resource capacity settings in a specified fleet or location.
     * <p>
     * The location value might refer to a fleet's remote location or its home Region.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * LocationCapacityProperty locationCapacityProperty = LocationCapacityProperty.builder()
     *         .maxSize(123)
     *         .minSize(123)
     *         // the properties below are optional
     *         .desiredEc2Instances(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-locationcapacity.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-locationcapacity.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerFleet.LocationCapacityProperty")
    @software.amazon.jsii.Jsii.Proxy(LocationCapacityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LocationCapacityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum value that is allowed for the fleet's instance count for a location.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-locationcapacity.html#cfn-gamelift-containerfleet-locationcapacity-maxsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-locationcapacity.html#cfn-gamelift-containerfleet-locationcapacity-maxsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxSize();

        /**
         * The minimum value allowed for the fleet's instance count for a location.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-locationcapacity.html#cfn-gamelift-containerfleet-locationcapacity-minsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-locationcapacity.html#cfn-gamelift-containerfleet-locationcapacity-minsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinSize();

        /**
         * Defaults to MinSize if not defined.
         * <p>
         * The number of EC2 instances you want to maintain in the specified fleet location. This value must fall between the minimum and maximum size limits. If any auto-scaling policy is defined for the container fleet, the desired instance will only be applied once during fleet creation and will be ignored in updates to avoid conflicts with auto-scaling. During updates with any auto-scaling policy defined, if current desired instance is lower than the new MinSize, it will be increased to the new MinSize; if current desired instance is larger than the new MaxSize, it will be decreased to the new MaxSize.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-locationcapacity.html#cfn-gamelift-containerfleet-locationcapacity-desiredec2instances">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-locationcapacity.html#cfn-gamelift-containerfleet-locationcapacity-desiredec2instances</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDesiredEc2Instances() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LocationCapacityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LocationCapacityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LocationCapacityProperty> {
            java.lang.Number maxSize;
            java.lang.Number minSize;
            java.lang.Number desiredEc2Instances;

            /**
             * Sets the value of {@link LocationCapacityProperty#getMaxSize}
             * @param maxSize The maximum value that is allowed for the fleet's instance count for a location. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxSize(java.lang.Number maxSize) {
                this.maxSize = maxSize;
                return this;
            }

            /**
             * Sets the value of {@link LocationCapacityProperty#getMinSize}
             * @param minSize The minimum value allowed for the fleet's instance count for a location. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minSize(java.lang.Number minSize) {
                this.minSize = minSize;
                return this;
            }

            /**
             * Sets the value of {@link LocationCapacityProperty#getDesiredEc2Instances}
             * @param desiredEc2Instances Defaults to MinSize if not defined.
             *                            The number of EC2 instances you want to maintain in the specified fleet location. This value must fall between the minimum and maximum size limits. If any auto-scaling policy is defined for the container fleet, the desired instance will only be applied once during fleet creation and will be ignored in updates to avoid conflicts with auto-scaling. During updates with any auto-scaling policy defined, if current desired instance is lower than the new MinSize, it will be increased to the new MinSize; if current desired instance is larger than the new MaxSize, it will be decreased to the new MaxSize.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder desiredEc2Instances(java.lang.Number desiredEc2Instances) {
                this.desiredEc2Instances = desiredEc2Instances;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LocationCapacityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LocationCapacityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LocationCapacityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LocationCapacityProperty {
            private final java.lang.Number maxSize;
            private final java.lang.Number minSize;
            private final java.lang.Number desiredEc2Instances;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxSize = software.amazon.jsii.Kernel.get(this, "maxSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minSize = software.amazon.jsii.Kernel.get(this, "minSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.desiredEc2Instances = software.amazon.jsii.Kernel.get(this, "desiredEc2Instances", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxSize = java.util.Objects.requireNonNull(builder.maxSize, "maxSize is required");
                this.minSize = java.util.Objects.requireNonNull(builder.minSize, "minSize is required");
                this.desiredEc2Instances = builder.desiredEc2Instances;
            }

            @Override
            public final java.lang.Number getMaxSize() {
                return this.maxSize;
            }

            @Override
            public final java.lang.Number getMinSize() {
                return this.minSize;
            }

            @Override
            public final java.lang.Number getDesiredEc2Instances() {
                return this.desiredEc2Instances;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxSize", om.valueToTree(this.getMaxSize()));
                data.set("minSize", om.valueToTree(this.getMinSize()));
                if (this.getDesiredEc2Instances() != null) {
                    data.set("desiredEc2Instances", om.valueToTree(this.getDesiredEc2Instances()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerFleet.LocationCapacityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LocationCapacityProperty.Jsii$Proxy that = (LocationCapacityProperty.Jsii$Proxy) o;

                if (!maxSize.equals(that.maxSize)) return false;
                if (!minSize.equals(that.minSize)) return false;
                return this.desiredEc2Instances != null ? this.desiredEc2Instances.equals(that.desiredEc2Instances) : that.desiredEc2Instances == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxSize.hashCode();
                result = 31 * result + (this.minSize.hashCode());
                result = 31 * result + (this.desiredEc2Instances != null ? this.desiredEc2Instances.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A remote location where a multi-location fleet can deploy game servers for game hosting.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * LocationConfigurationProperty locationConfigurationProperty = LocationConfigurationProperty.builder()
     *         .location("location")
     *         // the properties below are optional
     *         .locationCapacity(LocationCapacityProperty.builder()
     *                 .maxSize(123)
     *                 .minSize(123)
     *                 // the properties below are optional
     *                 .desiredEc2Instances(123)
     *                 .build())
     *         .stoppedActions(List.of("stoppedActions"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-locationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-locationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerFleet.LocationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LocationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LocationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An AWS Region code, such as <code>us-west-2</code> .
         * <p>
         * For a list of supported Regions and Local Zones, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html">Amazon GameLift Servers service locations</a> for managed hosting.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-locationconfiguration.html#cfn-gamelift-containerfleet-locationconfiguration-location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-locationconfiguration.html#cfn-gamelift-containerfleet-locationconfiguration-location</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocation();

        /**
         * Current resource capacity settings in a specified fleet or location.
         * <p>
         * The location value might refer to a fleet's remote location or its home Region.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.gamelift.CfnContainerFleet.LocationCapacityProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-locationconfiguration.html#cfn-gamelift-containerfleet-locationconfiguration-locationcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-locationconfiguration.html#cfn-gamelift-containerfleet-locationconfiguration-locationcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLocationCapacity() {
            return null;
        }

        /**
         * A list of fleet actions that have been suspended in the fleet location.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-locationconfiguration.html#cfn-gamelift-containerfleet-locationconfiguration-stoppedactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-locationconfiguration.html#cfn-gamelift-containerfleet-locationconfiguration-stoppedactions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStoppedActions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LocationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LocationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LocationConfigurationProperty> {
            java.lang.String location;
            java.lang.Object locationCapacity;
            java.util.List<java.lang.String> stoppedActions;

            /**
             * Sets the value of {@link LocationConfigurationProperty#getLocation}
             * @param location An AWS Region code, such as <code>us-west-2</code> . This parameter is required.
             *                 For a list of supported Regions and Local Zones, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html">Amazon GameLift Servers service locations</a> for managed hosting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(java.lang.String location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link LocationConfigurationProperty#getLocationCapacity}
             * @param locationCapacity Current resource capacity settings in a specified fleet or location.
             *                         The location value might refer to a fleet's remote location or its home Region.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder locationCapacity(software.amazon.awscdk.IResolvable locationCapacity) {
                this.locationCapacity = locationCapacity;
                return this;
            }

            /**
             * Sets the value of {@link LocationConfigurationProperty#getLocationCapacity}
             * @param locationCapacity Current resource capacity settings in a specified fleet or location.
             *                         The location value might refer to a fleet's remote location or its home Region.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder locationCapacity(software.amazon.awscdk.services.gamelift.CfnContainerFleet.LocationCapacityProperty locationCapacity) {
                this.locationCapacity = locationCapacity;
                return this;
            }

            /**
             * Sets the value of {@link LocationConfigurationProperty#getStoppedActions}
             * @param stoppedActions A list of fleet actions that have been suspended in the fleet location.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stoppedActions(java.util.List<java.lang.String> stoppedActions) {
                this.stoppedActions = stoppedActions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LocationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LocationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LocationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LocationConfigurationProperty {
            private final java.lang.String location;
            private final java.lang.Object locationCapacity;
            private final java.util.List<java.lang.String> stoppedActions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.locationCapacity = software.amazon.jsii.Kernel.get(this, "locationCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stoppedActions = software.amazon.jsii.Kernel.get(this, "stoppedActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.location = java.util.Objects.requireNonNull(builder.location, "location is required");
                this.locationCapacity = builder.locationCapacity;
                this.stoppedActions = builder.stoppedActions;
            }

            @Override
            public final java.lang.String getLocation() {
                return this.location;
            }

            @Override
            public final java.lang.Object getLocationCapacity() {
                return this.locationCapacity;
            }

            @Override
            public final java.util.List<java.lang.String> getStoppedActions() {
                return this.stoppedActions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("location", om.valueToTree(this.getLocation()));
                if (this.getLocationCapacity() != null) {
                    data.set("locationCapacity", om.valueToTree(this.getLocationCapacity()));
                }
                if (this.getStoppedActions() != null) {
                    data.set("stoppedActions", om.valueToTree(this.getStoppedActions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerFleet.LocationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LocationConfigurationProperty.Jsii$Proxy that = (LocationConfigurationProperty.Jsii$Proxy) o;

                if (!location.equals(that.location)) return false;
                if (this.locationCapacity != null ? !this.locationCapacity.equals(that.locationCapacity) : that.locationCapacity != null) return false;
                return this.stoppedActions != null ? this.stoppedActions.equals(that.stoppedActions) : that.stoppedActions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.location.hashCode();
                result = 31 * result + (this.locationCapacity != null ? this.locationCapacity.hashCode() : 0);
                result = 31 * result + (this.stoppedActions != null ? this.stoppedActions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A method for collecting container logs for the fleet.
     * <p>
     * Amazon GameLift Servers saves all standard output for each container in logs, including game session logs. You can select from the following methods:
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * LogConfigurationProperty logConfigurationProperty = LogConfigurationProperty.builder()
     *         .logDestination("logDestination")
     *         .logGroupArn("logGroupArn")
     *         .s3BucketName("s3BucketName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-logconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-logconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerFleet.LogConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LogConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of log collection to use for a fleet.
         * <p>
         * <ul>
         * <li><code>CLOUDWATCH</code> -- (default value) Send logs to an Amazon CloudWatch log group that you define. Each container emits a log stream, which is organized in the log group.</li>
         * <li><code>S3</code> -- Store logs in an Amazon S3 bucket that you define. This bucket must reside in the fleet's home AWS Region.</li>
         * <li><code>NONE</code> -- Don't collect container logs.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-logconfiguration.html#cfn-gamelift-containerfleet-logconfiguration-logdestination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-logconfiguration.html#cfn-gamelift-containerfleet-logconfiguration-logdestination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogDestination() {
            return null;
        }

        /**
         * If log destination is <code>CLOUDWATCH</code> , logs are sent to the specified log group in Amazon CloudWatch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-logconfiguration.html#cfn-gamelift-containerfleet-logconfiguration-loggrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-logconfiguration.html#cfn-gamelift-containerfleet-logconfiguration-loggrouparn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogGroupArn() {
            return null;
        }

        /**
         * If log destination is <code>S3</code> , logs are sent to the specified Amazon S3 bucket name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-logconfiguration.html#cfn-gamelift-containerfleet-logconfiguration-s3bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-logconfiguration.html#cfn-gamelift-containerfleet-logconfiguration-s3bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BucketName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogConfigurationProperty> {
            java.lang.String logDestination;
            java.lang.String logGroupArn;
            java.lang.String s3BucketName;

            /**
             * Sets the value of {@link LogConfigurationProperty#getLogDestination}
             * @param logDestination The type of log collection to use for a fleet.
             *                       <ul>
             *                       <li><code>CLOUDWATCH</code> -- (default value) Send logs to an Amazon CloudWatch log group that you define. Each container emits a log stream, which is organized in the log group.</li>
             *                       <li><code>S3</code> -- Store logs in an Amazon S3 bucket that you define. This bucket must reside in the fleet's home AWS Region.</li>
             *                       <li><code>NONE</code> -- Don't collect container logs.</li>
             *                       </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logDestination(java.lang.String logDestination) {
                this.logDestination = logDestination;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigurationProperty#getLogGroupArn}
             * @param logGroupArn If log destination is <code>CLOUDWATCH</code> , logs are sent to the specified log group in Amazon CloudWatch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroupArn(java.lang.String logGroupArn) {
                this.logGroupArn = logGroupArn;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigurationProperty#getS3BucketName}
             * @param s3BucketName If log destination is <code>S3</code> , logs are sent to the specified Amazon S3 bucket name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketName(java.lang.String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogConfigurationProperty {
            private final java.lang.String logDestination;
            private final java.lang.String logGroupArn;
            private final java.lang.String s3BucketName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logDestination = software.amazon.jsii.Kernel.get(this, "logDestination", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logGroupArn = software.amazon.jsii.Kernel.get(this, "logGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3BucketName = software.amazon.jsii.Kernel.get(this, "s3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logDestination = builder.logDestination;
                this.logGroupArn = builder.logGroupArn;
                this.s3BucketName = builder.s3BucketName;
            }

            @Override
            public final java.lang.String getLogDestination() {
                return this.logDestination;
            }

            @Override
            public final java.lang.String getLogGroupArn() {
                return this.logGroupArn;
            }

            @Override
            public final java.lang.String getS3BucketName() {
                return this.s3BucketName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLogDestination() != null) {
                    data.set("logDestination", om.valueToTree(this.getLogDestination()));
                }
                if (this.getLogGroupArn() != null) {
                    data.set("logGroupArn", om.valueToTree(this.getLogGroupArn()));
                }
                if (this.getS3BucketName() != null) {
                    data.set("s3BucketName", om.valueToTree(this.getS3BucketName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerFleet.LogConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogConfigurationProperty.Jsii$Proxy that = (LogConfigurationProperty.Jsii$Proxy) o;

                if (this.logDestination != null ? !this.logDestination.equals(that.logDestination) : that.logDestination != null) return false;
                if (this.logGroupArn != null ? !this.logGroupArn.equals(that.logGroupArn) : that.logGroupArn != null) return false;
                return this.s3BucketName != null ? this.s3BucketName.equals(that.s3BucketName) : that.s3BucketName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.logDestination != null ? this.logDestination.hashCode() : 0;
                result = 31 * result + (this.logGroupArn != null ? this.logGroupArn.hashCode() : 0);
                result = 31 * result + (this.s3BucketName != null ? this.s3BucketName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Rule that controls how a fleet is scaled.
     * <p>
     * Scaling policies are uniquely identified by the combination of name and fleet ID.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * ScalingPolicyProperty scalingPolicyProperty = ScalingPolicyProperty.builder()
     *         .metricName("metricName")
     *         .name("name")
     *         // the properties below are optional
     *         .comparisonOperator("comparisonOperator")
     *         .evaluationPeriods(123)
     *         .policyType("policyType")
     *         .scalingAdjustment(123)
     *         .scalingAdjustmentType("scalingAdjustmentType")
     *         .targetConfiguration(TargetConfigurationProperty.builder()
     *                 .targetValue(123)
     *                 .build())
     *         .threshold(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-scalingpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-scalingpolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerFleet.ScalingPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScalingPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Name of the Amazon GameLift Servers-defined metric that is used to trigger a scaling adjustment.
         * <p>
         * For detailed descriptions of fleet metrics, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html">Monitor Amazon GameLift Servers with Amazon CloudWatch</a> .
         * <p>
         * <ul>
         * <li><em>ActivatingGameSessions</em> -- Game sessions in the process of being created.</li>
         * <li><em>ActiveGameSessions</em> -- Game sessions that are currently running.</li>
         * <li><em>ActiveInstances</em> -- Fleet instances that are currently running at least one game session.</li>
         * <li><em>AvailableGameSessions</em> -- Additional game sessions that fleet could host simultaneously, given current capacity.</li>
         * <li><em>AvailablePlayerSessions</em> -- Empty player slots in currently active game sessions. This includes game sessions that are not currently accepting players. Reserved player slots are not included.</li>
         * <li><em>CurrentPlayerSessions</em> -- Player slots in active game sessions that are being used by a player or are reserved for a player.</li>
         * <li><em>IdleInstances</em> -- Active instances that are currently hosting zero game sessions.</li>
         * <li><em>PercentAvailableGameSessions</em> -- Unused percentage of the total number of game sessions that a fleet could host simultaneously, given current capacity. Use this metric for a target-based scaling policy.</li>
         * <li><em>PercentIdleInstances</em> -- Percentage of the total number of active instances that are hosting zero game sessions.</li>
         * <li><em>QueueDepth</em> -- Pending game session placement requests, in any queue, where the current fleet is the top-priority destination.</li>
         * <li><em>WaitTime</em> -- Current wait time for pending game session placement requests, in any queue, where the current fleet is the top-priority destination.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-scalingpolicy.html#cfn-gamelift-containerfleet-scalingpolicy-metricname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-scalingpolicy.html#cfn-gamelift-containerfleet-scalingpolicy-metricname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

        /**
         * A descriptive label that is associated with a fleet's scaling policy.
         * <p>
         * Policy names do not need to be unique.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-scalingpolicy.html#cfn-gamelift-containerfleet-scalingpolicy-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-scalingpolicy.html#cfn-gamelift-containerfleet-scalingpolicy-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Comparison operator to use when measuring a metric against the threshold value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-scalingpolicy.html#cfn-gamelift-containerfleet-scalingpolicy-comparisonoperator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-scalingpolicy.html#cfn-gamelift-containerfleet-scalingpolicy-comparisonoperator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComparisonOperator() {
            return null;
        }

        /**
         * Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-scalingpolicy.html#cfn-gamelift-containerfleet-scalingpolicy-evaluationperiods">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-scalingpolicy.html#cfn-gamelift-containerfleet-scalingpolicy-evaluationperiods</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEvaluationPeriods() {
            return null;
        }

        /**
         * The type of scaling policy to create.
         * <p>
         * For a target-based policy, set the parameter <em>MetricName</em> to 'PercentAvailableGameSessions' and specify a <em>TargetConfiguration</em> . For a rule-based policy set the following parameters: <em>MetricName</em> , <em>ComparisonOperator</em> , <em>Threshold</em> , <em>EvaluationPeriods</em> , <em>ScalingAdjustmentType</em> , and <em>ScalingAdjustment</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-scalingpolicy.html#cfn-gamelift-containerfleet-scalingpolicy-policytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-scalingpolicy.html#cfn-gamelift-containerfleet-scalingpolicy-policytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPolicyType() {
            return null;
        }

        /**
         * Amount of adjustment to make, based on the scaling adjustment type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-scalingpolicy.html#cfn-gamelift-containerfleet-scalingpolicy-scalingadjustment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-scalingpolicy.html#cfn-gamelift-containerfleet-scalingpolicy-scalingadjustment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScalingAdjustment() {
            return null;
        }

        /**
         * The type of adjustment to make to a fleet's instance count.
         * <p>
         * <ul>
         * <li><em>ChangeInCapacity</em> -- add (or subtract) the scaling adjustment value from the current instance count. Positive values scale up while negative values scale down.</li>
         * <li><em>ExactCapacity</em> -- set the instance count to the scaling adjustment value.</li>
         * <li><em>PercentChangeInCapacity</em> -- increase or reduce the current instance count by the scaling adjustment, read as a percentage. Positive values scale up while negative values scale down.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-scalingpolicy.html#cfn-gamelift-containerfleet-scalingpolicy-scalingadjustmenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-scalingpolicy.html#cfn-gamelift-containerfleet-scalingpolicy-scalingadjustmenttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScalingAdjustmentType() {
            return null;
        }

        /**
         * An object that contains settings for a target-based scaling policy.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.gamelift.CfnContainerFleet.TargetConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-scalingpolicy.html#cfn-gamelift-containerfleet-scalingpolicy-targetconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-scalingpolicy.html#cfn-gamelift-containerfleet-scalingpolicy-targetconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetConfiguration() {
            return null;
        }

        /**
         * Metric value used to trigger a scaling event.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-scalingpolicy.html#cfn-gamelift-containerfleet-scalingpolicy-threshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-scalingpolicy.html#cfn-gamelift-containerfleet-scalingpolicy-threshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThreshold() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingPolicyProperty> {
            java.lang.String metricName;
            java.lang.String name;
            java.lang.String comparisonOperator;
            java.lang.Number evaluationPeriods;
            java.lang.String policyType;
            java.lang.Number scalingAdjustment;
            java.lang.String scalingAdjustmentType;
            java.lang.Object targetConfiguration;
            java.lang.Number threshold;

            /**
             * Sets the value of {@link ScalingPolicyProperty#getMetricName}
             * @param metricName Name of the Amazon GameLift Servers-defined metric that is used to trigger a scaling adjustment. This parameter is required.
             *                   For detailed descriptions of fleet metrics, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html">Monitor Amazon GameLift Servers with Amazon CloudWatch</a> .
             *                   <p>
             *                   <ul>
             *                   <li><em>ActivatingGameSessions</em> -- Game sessions in the process of being created.</li>
             *                   <li><em>ActiveGameSessions</em> -- Game sessions that are currently running.</li>
             *                   <li><em>ActiveInstances</em> -- Fleet instances that are currently running at least one game session.</li>
             *                   <li><em>AvailableGameSessions</em> -- Additional game sessions that fleet could host simultaneously, given current capacity.</li>
             *                   <li><em>AvailablePlayerSessions</em> -- Empty player slots in currently active game sessions. This includes game sessions that are not currently accepting players. Reserved player slots are not included.</li>
             *                   <li><em>CurrentPlayerSessions</em> -- Player slots in active game sessions that are being used by a player or are reserved for a player.</li>
             *                   <li><em>IdleInstances</em> -- Active instances that are currently hosting zero game sessions.</li>
             *                   <li><em>PercentAvailableGameSessions</em> -- Unused percentage of the total number of game sessions that a fleet could host simultaneously, given current capacity. Use this metric for a target-based scaling policy.</li>
             *                   <li><em>PercentIdleInstances</em> -- Percentage of the total number of active instances that are hosting zero game sessions.</li>
             *                   <li><em>QueueDepth</em> -- Pending game session placement requests, in any queue, where the current fleet is the top-priority destination.</li>
             *                   <li><em>WaitTime</em> -- Current wait time for pending game session placement requests, in any queue, where the current fleet is the top-priority destination.</li>
             *                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link ScalingPolicyProperty#getName}
             * @param name A descriptive label that is associated with a fleet's scaling policy. This parameter is required.
             *             Policy names do not need to be unique.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ScalingPolicyProperty#getComparisonOperator}
             * @param comparisonOperator Comparison operator to use when measuring a metric against the threshold value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparisonOperator(java.lang.String comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            /**
             * Sets the value of {@link ScalingPolicyProperty#getEvaluationPeriods}
             * @param evaluationPeriods Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluationPeriods(java.lang.Number evaluationPeriods) {
                this.evaluationPeriods = evaluationPeriods;
                return this;
            }

            /**
             * Sets the value of {@link ScalingPolicyProperty#getPolicyType}
             * @param policyType The type of scaling policy to create.
             *                   For a target-based policy, set the parameter <em>MetricName</em> to 'PercentAvailableGameSessions' and specify a <em>TargetConfiguration</em> . For a rule-based policy set the following parameters: <em>MetricName</em> , <em>ComparisonOperator</em> , <em>Threshold</em> , <em>EvaluationPeriods</em> , <em>ScalingAdjustmentType</em> , and <em>ScalingAdjustment</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyType(java.lang.String policyType) {
                this.policyType = policyType;
                return this;
            }

            /**
             * Sets the value of {@link ScalingPolicyProperty#getScalingAdjustment}
             * @param scalingAdjustment Amount of adjustment to make, based on the scaling adjustment type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalingAdjustment(java.lang.Number scalingAdjustment) {
                this.scalingAdjustment = scalingAdjustment;
                return this;
            }

            /**
             * Sets the value of {@link ScalingPolicyProperty#getScalingAdjustmentType}
             * @param scalingAdjustmentType The type of adjustment to make to a fleet's instance count.
             *                              <ul>
             *                              <li><em>ChangeInCapacity</em> -- add (or subtract) the scaling adjustment value from the current instance count. Positive values scale up while negative values scale down.</li>
             *                              <li><em>ExactCapacity</em> -- set the instance count to the scaling adjustment value.</li>
             *                              <li><em>PercentChangeInCapacity</em> -- increase or reduce the current instance count by the scaling adjustment, read as a percentage. Positive values scale up while negative values scale down.</li>
             *                              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalingAdjustmentType(java.lang.String scalingAdjustmentType) {
                this.scalingAdjustmentType = scalingAdjustmentType;
                return this;
            }

            /**
             * Sets the value of {@link ScalingPolicyProperty#getTargetConfiguration}
             * @param targetConfiguration An object that contains settings for a target-based scaling policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetConfiguration(software.amazon.awscdk.IResolvable targetConfiguration) {
                this.targetConfiguration = targetConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ScalingPolicyProperty#getTargetConfiguration}
             * @param targetConfiguration An object that contains settings for a target-based scaling policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetConfiguration(software.amazon.awscdk.services.gamelift.CfnContainerFleet.TargetConfigurationProperty targetConfiguration) {
                this.targetConfiguration = targetConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ScalingPolicyProperty#getThreshold}
             * @param threshold Metric value used to trigger a scaling event.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threshold(java.lang.Number threshold) {
                this.threshold = threshold;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScalingPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingPolicyProperty {
            private final java.lang.String metricName;
            private final java.lang.String name;
            private final java.lang.String comparisonOperator;
            private final java.lang.Number evaluationPeriods;
            private final java.lang.String policyType;
            private final java.lang.Number scalingAdjustment;
            private final java.lang.String scalingAdjustmentType;
            private final java.lang.Object targetConfiguration;
            private final java.lang.Number threshold;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.comparisonOperator = software.amazon.jsii.Kernel.get(this, "comparisonOperator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.evaluationPeriods = software.amazon.jsii.Kernel.get(this, "evaluationPeriods", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.policyType = software.amazon.jsii.Kernel.get(this, "policyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scalingAdjustment = software.amazon.jsii.Kernel.get(this, "scalingAdjustment", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.scalingAdjustmentType = software.amazon.jsii.Kernel.get(this, "scalingAdjustmentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetConfiguration = software.amazon.jsii.Kernel.get(this, "targetConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.threshold = software.amazon.jsii.Kernel.get(this, "threshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.comparisonOperator = builder.comparisonOperator;
                this.evaluationPeriods = builder.evaluationPeriods;
                this.policyType = builder.policyType;
                this.scalingAdjustment = builder.scalingAdjustment;
                this.scalingAdjustmentType = builder.scalingAdjustmentType;
                this.targetConfiguration = builder.targetConfiguration;
                this.threshold = builder.threshold;
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getComparisonOperator() {
                return this.comparisonOperator;
            }

            @Override
            public final java.lang.Number getEvaluationPeriods() {
                return this.evaluationPeriods;
            }

            @Override
            public final java.lang.String getPolicyType() {
                return this.policyType;
            }

            @Override
            public final java.lang.Number getScalingAdjustment() {
                return this.scalingAdjustment;
            }

            @Override
            public final java.lang.String getScalingAdjustmentType() {
                return this.scalingAdjustmentType;
            }

            @Override
            public final java.lang.Object getTargetConfiguration() {
                return this.targetConfiguration;
            }

            @Override
            public final java.lang.Number getThreshold() {
                return this.threshold;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metricName", om.valueToTree(this.getMetricName()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getComparisonOperator() != null) {
                    data.set("comparisonOperator", om.valueToTree(this.getComparisonOperator()));
                }
                if (this.getEvaluationPeriods() != null) {
                    data.set("evaluationPeriods", om.valueToTree(this.getEvaluationPeriods()));
                }
                if (this.getPolicyType() != null) {
                    data.set("policyType", om.valueToTree(this.getPolicyType()));
                }
                if (this.getScalingAdjustment() != null) {
                    data.set("scalingAdjustment", om.valueToTree(this.getScalingAdjustment()));
                }
                if (this.getScalingAdjustmentType() != null) {
                    data.set("scalingAdjustmentType", om.valueToTree(this.getScalingAdjustmentType()));
                }
                if (this.getTargetConfiguration() != null) {
                    data.set("targetConfiguration", om.valueToTree(this.getTargetConfiguration()));
                }
                if (this.getThreshold() != null) {
                    data.set("threshold", om.valueToTree(this.getThreshold()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerFleet.ScalingPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingPolicyProperty.Jsii$Proxy that = (ScalingPolicyProperty.Jsii$Proxy) o;

                if (!metricName.equals(that.metricName)) return false;
                if (!name.equals(that.name)) return false;
                if (this.comparisonOperator != null ? !this.comparisonOperator.equals(that.comparisonOperator) : that.comparisonOperator != null) return false;
                if (this.evaluationPeriods != null ? !this.evaluationPeriods.equals(that.evaluationPeriods) : that.evaluationPeriods != null) return false;
                if (this.policyType != null ? !this.policyType.equals(that.policyType) : that.policyType != null) return false;
                if (this.scalingAdjustment != null ? !this.scalingAdjustment.equals(that.scalingAdjustment) : that.scalingAdjustment != null) return false;
                if (this.scalingAdjustmentType != null ? !this.scalingAdjustmentType.equals(that.scalingAdjustmentType) : that.scalingAdjustmentType != null) return false;
                if (this.targetConfiguration != null ? !this.targetConfiguration.equals(that.targetConfiguration) : that.targetConfiguration != null) return false;
                return this.threshold != null ? this.threshold.equals(that.threshold) : that.threshold == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metricName.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.comparisonOperator != null ? this.comparisonOperator.hashCode() : 0);
                result = 31 * result + (this.evaluationPeriods != null ? this.evaluationPeriods.hashCode() : 0);
                result = 31 * result + (this.policyType != null ? this.policyType.hashCode() : 0);
                result = 31 * result + (this.scalingAdjustment != null ? this.scalingAdjustment.hashCode() : 0);
                result = 31 * result + (this.scalingAdjustmentType != null ? this.scalingAdjustmentType.hashCode() : 0);
                result = 31 * result + (this.targetConfiguration != null ? this.targetConfiguration.hashCode() : 0);
                result = 31 * result + (this.threshold != null ? this.threshold.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings for a target-based scaling policy.
     * <p>
     * A target-based policy tracks a particular fleet metric specifies a target value for the metric. As player usage changes, the policy triggers Amazon GameLift Servers to adjust capacity so that the metric returns to the target value. The target configuration specifies settings as needed for the target based policy, including the target value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * TargetConfigurationProperty targetConfigurationProperty = TargetConfigurationProperty.builder()
     *         .targetValue(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-targetconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-targetconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerFleet.TargetConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Desired value to use with a target-based scaling policy.
         * <p>
         * The value must be relevant for whatever metric the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and ready for new game sessions).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-targetconfiguration.html#cfn-gamelift-containerfleet-targetconfiguration-targetvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containerfleet-targetconfiguration.html#cfn-gamelift-containerfleet-targetconfiguration-targetvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTargetValue();

        /**
         * @return a {@link Builder} of {@link TargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetConfigurationProperty> {
            java.lang.Number targetValue;

            /**
             * Sets the value of {@link TargetConfigurationProperty#getTargetValue}
             * @param targetValue Desired value to use with a target-based scaling policy. This parameter is required.
             *                    The value must be relevant for whatever metric the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and ready for new game sessions).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetValue(java.lang.Number targetValue) {
                this.targetValue = targetValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetConfigurationProperty {
            private final java.lang.Number targetValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetValue = software.amazon.jsii.Kernel.get(this, "targetValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetValue = java.util.Objects.requireNonNull(builder.targetValue, "targetValue is required");
            }

            @Override
            public final java.lang.Number getTargetValue() {
                return this.targetValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetValue", om.valueToTree(this.getTargetValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerFleet.TargetConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetConfigurationProperty.Jsii$Proxy that = (TargetConfigurationProperty.Jsii$Proxy) o;

                return this.targetValue.equals(that.targetValue);
            }

            @Override
            public final int hashCode() {
                int result = this.targetValue.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.gamelift.CfnContainerFleet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.gamelift.CfnContainerFleet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.gamelift.CfnContainerFleetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.gamelift.CfnContainerFleetProps.Builder();
        }

        /**
         * The unique identifier for an AWS Identity and Access Management (IAM) role with permissions to run your containers on resources that are managed by Amazon GameLift Servers.
         * <p>
         * See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/setting-up-role.html">Set up an IAM service role</a> . This fleet property can't be changed.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-fleetrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-fleetrolearn</a>
         * @param fleetRoleArn The unique identifier for an AWS Identity and Access Management (IAM) role with permissions to run your containers on resources that are managed by Amazon GameLift Servers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fleetRoleArn(final java.lang.String fleetRoleArn) {
            this.props.fleetRoleArn(fleetRoleArn);
            return this;
        }

        /**
         * Indicates whether the fleet uses On-Demand or Spot instances for this fleet.
         * <p>
         * Learn more about when to use <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot">On-Demand versus Spot Instances</a> . You can't update this fleet property.
         * <p>
         * By default, this property is set to <code>ON_DEMAND</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-billingtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-billingtype</a>
         * @param billingType Indicates whether the fleet uses On-Demand or Spot instances for this fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingType(final java.lang.String billingType) {
            this.props.billingType(billingType);
            return this;
        }

        /**
         * Set of rules for processing a deployment for a container fleet update.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-deploymentconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-deploymentconfiguration</a>
         * @param deploymentConfiguration Set of rules for processing a deployment for a container fleet update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfiguration(final software.amazon.awscdk.IResolvable deploymentConfiguration) {
            this.props.deploymentConfiguration(deploymentConfiguration);
            return this;
        }
        /**
         * Set of rules for processing a deployment for a container fleet update.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-deploymentconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-deploymentconfiguration</a>
         * @param deploymentConfiguration Set of rules for processing a deployment for a container fleet update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfiguration(final software.amazon.awscdk.services.gamelift.CfnContainerFleet.DeploymentConfigurationProperty deploymentConfiguration) {
            this.props.deploymentConfiguration(deploymentConfiguration);
            return this;
        }

        /**
         * A meaningful description of the container fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-description</a>
         * @param description A meaningful description of the container fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the fleet's game server container group definition, which describes how to deploy containers with your game server build and support software onto each fleet instance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-gameservercontainergroupdefinitionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-gameservercontainergroupdefinitionname</a>
         * @param gameServerContainerGroupDefinitionName The name of the fleet's game server container group definition, which describes how to deploy containers with your game server build and support software onto each fleet instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameServerContainerGroupDefinitionName(final java.lang.String gameServerContainerGroupDefinitionName) {
            this.props.gameServerContainerGroupDefinitionName(gameServerContainerGroupDefinitionName);
            return this;
        }

        /**
         * The number of times to replicate the game server container group on each fleet instance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-gameservercontainergroupsperinstance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-gameservercontainergroupsperinstance</a>
         * @param gameServerContainerGroupsPerInstance The number of times to replicate the game server container group on each fleet instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameServerContainerGroupsPerInstance(final java.lang.Number gameServerContainerGroupsPerInstance) {
            this.props.gameServerContainerGroupsPerInstance(gameServerContainerGroupsPerInstance);
            return this;
        }

        /**
         * A policy that limits the number of game sessions that each individual player can create on instances in this fleet.
         * <p>
         * The limit applies for a specified span of time.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-gamesessioncreationlimitpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-gamesessioncreationlimitpolicy</a>
         * @param gameSessionCreationLimitPolicy A policy that limits the number of game sessions that each individual player can create on instances in this fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameSessionCreationLimitPolicy(final software.amazon.awscdk.IResolvable gameSessionCreationLimitPolicy) {
            this.props.gameSessionCreationLimitPolicy(gameSessionCreationLimitPolicy);
            return this;
        }
        /**
         * A policy that limits the number of game sessions that each individual player can create on instances in this fleet.
         * <p>
         * The limit applies for a specified span of time.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-gamesessioncreationlimitpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-gamesessioncreationlimitpolicy</a>
         * @param gameSessionCreationLimitPolicy A policy that limits the number of game sessions that each individual player can create on instances in this fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameSessionCreationLimitPolicy(final software.amazon.awscdk.services.gamelift.CfnContainerFleet.GameSessionCreationLimitPolicyProperty gameSessionCreationLimitPolicy) {
            this.props.gameSessionCreationLimitPolicy(gameSessionCreationLimitPolicy);
            return this;
        }

        /**
         * The set of port numbers to open on each instance in a container fleet.
         * <p>
         * Connection ports are used by inbound traffic to connect with processes that are running in containers on the fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-instanceconnectionportrange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-instanceconnectionportrange</a>
         * @param instanceConnectionPortRange The set of port numbers to open on each instance in a container fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceConnectionPortRange(final software.amazon.awscdk.IResolvable instanceConnectionPortRange) {
            this.props.instanceConnectionPortRange(instanceConnectionPortRange);
            return this;
        }
        /**
         * The set of port numbers to open on each instance in a container fleet.
         * <p>
         * Connection ports are used by inbound traffic to connect with processes that are running in containers on the fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-instanceconnectionportrange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-instanceconnectionportrange</a>
         * @param instanceConnectionPortRange The set of port numbers to open on each instance in a container fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceConnectionPortRange(final software.amazon.awscdk.services.gamelift.CfnContainerFleet.ConnectionPortRangeProperty instanceConnectionPortRange) {
            this.props.instanceConnectionPortRange(instanceConnectionPortRange);
            return this;
        }

        /**
         * The IP address ranges and port settings that allow inbound traffic to access game server processes and other processes on this fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-instanceinboundpermissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-instanceinboundpermissions</a>
         * @param instanceInboundPermissions The IP address ranges and port settings that allow inbound traffic to access game server processes and other processes on this fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceInboundPermissions(final software.amazon.awscdk.IResolvable instanceInboundPermissions) {
            this.props.instanceInboundPermissions(instanceInboundPermissions);
            return this;
        }
        /**
         * The IP address ranges and port settings that allow inbound traffic to access game server processes and other processes on this fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-instanceinboundpermissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-instanceinboundpermissions</a>
         * @param instanceInboundPermissions The IP address ranges and port settings that allow inbound traffic to access game server processes and other processes on this fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceInboundPermissions(final java.util.List<? extends java.lang.Object> instanceInboundPermissions) {
            this.props.instanceInboundPermissions(instanceInboundPermissions);
            return this;
        }

        /**
         * The Amazon EC2 instance type to use for all instances in the fleet.
         * <p>
         * Instance type determines the computing resources and processing power that's available to host your game servers. This includes including CPU, memory, storage, and networking capacity. You can't update this fleet property.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-instancetype</a>
         * @param instanceType The Amazon EC2 instance type to use for all instances in the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(final java.lang.String instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-locations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-locations</a>
         * @param locations This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locations(final software.amazon.awscdk.IResolvable locations) {
            this.props.locations(locations);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-locations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-locations</a>
         * @param locations This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locations(final java.util.List<? extends java.lang.Object> locations) {
            this.props.locations(locations);
            return this;
        }

        /**
         * The method that is used to collect container logs for the fleet.
         * <p>
         * Amazon GameLift Servers saves all standard output for each container in logs, including game session logs.
         * <p>
         * <ul>
         * <li><code>CLOUDWATCH</code> -- Send logs to an Amazon CloudWatch log group that you define. Each container emits a log stream, which is organized in the log group.</li>
         * <li><code>S3</code> -- Store logs in an Amazon S3 bucket that you define.</li>
         * <li><code>NONE</code> -- Don't collect container logs.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-logconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-logconfiguration</a>
         * @param logConfiguration The method that is used to collect container logs for the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfiguration(final software.amazon.awscdk.IResolvable logConfiguration) {
            this.props.logConfiguration(logConfiguration);
            return this;
        }
        /**
         * The method that is used to collect container logs for the fleet.
         * <p>
         * Amazon GameLift Servers saves all standard output for each container in logs, including game session logs.
         * <p>
         * <ul>
         * <li><code>CLOUDWATCH</code> -- Send logs to an Amazon CloudWatch log group that you define. Each container emits a log stream, which is organized in the log group.</li>
         * <li><code>S3</code> -- Store logs in an Amazon S3 bucket that you define.</li>
         * <li><code>NONE</code> -- Don't collect container logs.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-logconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-logconfiguration</a>
         * @param logConfiguration The method that is used to collect container logs for the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfiguration(final software.amazon.awscdk.services.gamelift.CfnContainerFleet.LogConfigurationProperty logConfiguration) {
            this.props.logConfiguration(logConfiguration);
            return this;
        }

        /**
         * The name of an AWS CloudWatch metric group to add this fleet to.
         * <p>
         * Metric groups aggregate metrics for multiple fleets.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-metricgroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-metricgroups</a>
         * @param metricGroups The name of an AWS CloudWatch metric group to add this fleet to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricGroups(final java.util.List<java.lang.String> metricGroups) {
            this.props.metricGroups(metricGroups);
            return this;
        }

        /**
         * Determines whether Amazon GameLift Servers can shut down game sessions on the fleet that are actively running and hosting players.
         * <p>
         * Amazon GameLift Servers might prompt an instance shutdown when scaling down fleet capacity or when retiring unhealthy instances. You can also set game session protection for individual game sessions using <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a> .
         * <p>
         * <ul>
         * <li><em>NoProtection</em> -- Game sessions can be shut down during active gameplay.</li>
         * <li><em>FullProtection</em> -- Game sessions in <code>ACTIVE</code> status can't be shut down.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-newgamesessionprotectionpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-newgamesessionprotectionpolicy</a>
         * @param newGameSessionProtectionPolicy Determines whether Amazon GameLift Servers can shut down game sessions on the fleet that are actively running and hosting players. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder newGameSessionProtectionPolicy(final java.lang.String newGameSessionProtectionPolicy) {
            this.props.newGameSessionProtectionPolicy(newGameSessionProtectionPolicy);
            return this;
        }

        /**
         * The name of the fleet's per-instance container group definition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-perinstancecontainergroupdefinitionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-perinstancecontainergroupdefinitionname</a>
         * @param perInstanceContainerGroupDefinitionName The name of the fleet's per-instance container group definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder perInstanceContainerGroupDefinitionName(final java.lang.String perInstanceContainerGroupDefinitionName) {
            this.props.perInstanceContainerGroupDefinitionName(perInstanceContainerGroupDefinitionName);
            return this;
        }

        /**
         * A list of rules that control how a fleet is scaled.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-scalingpolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-scalingpolicies</a>
         * @param scalingPolicies A list of rules that control how a fleet is scaled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingPolicies(final software.amazon.awscdk.IResolvable scalingPolicies) {
            this.props.scalingPolicies(scalingPolicies);
            return this;
        }
        /**
         * A list of rules that control how a fleet is scaled.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-scalingpolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-scalingpolicies</a>
         * @param scalingPolicies A list of rules that control how a fleet is scaled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingPolicies(final java.util.List<? extends java.lang.Object> scalingPolicies) {
            this.props.scalingPolicies(scalingPolicies);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.gamelift.CfnContainerFleet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.gamelift.CfnContainerFleet build() {
            return new software.amazon.awscdk.services.gamelift.CfnContainerFleet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
