package software.amazon.awscdk.services.globalaccelerator;

/**
 * Attributes required to import an existing accelerator to the stack.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.globalaccelerator.*;
 * AcceleratorAttributes acceleratorAttributes = AcceleratorAttributes.builder()
 *         .acceleratorArn("acceleratorArn")
 *         .dnsName("dnsName")
 *         // the properties below are optional
 *         .dualStackDnsName("dualStackDnsName")
 *         .ipv4Addresses(List.of("ipv4Addresses"))
 *         .ipv6Addresses(List.of("ipv6Addresses"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:53.113Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_globalaccelerator.AcceleratorAttributes")
@software.amazon.jsii.Jsii.Proxy(AcceleratorAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AcceleratorAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the accelerator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAcceleratorArn();

    /**
     * The DNS name of the accelerator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDnsName();

    /**
     * The DNS name that points to the dual-stack accelerator's four static IP addresses: two IPv4 addresses and two IPv6 addresses.
     * <p>
     * Default: - undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDualStackDnsName() {
        return null;
    }

    /**
     * The array of IPv4 addresses in the IP address set.
     * <p>
     * Default: - undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIpv4Addresses() {
        return null;
    }

    /**
     * The array of IPv6 addresses in the IP address set.
     * <p>
     * Default: - undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIpv6Addresses() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AcceleratorAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AcceleratorAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AcceleratorAttributes> {
        java.lang.String acceleratorArn;
        java.lang.String dnsName;
        java.lang.String dualStackDnsName;
        java.util.List<java.lang.String> ipv4Addresses;
        java.util.List<java.lang.String> ipv6Addresses;

        /**
         * Sets the value of {@link AcceleratorAttributes#getAcceleratorArn}
         * @param acceleratorArn The ARN of the accelerator. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceleratorArn(java.lang.String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
            return this;
        }

        /**
         * Sets the value of {@link AcceleratorAttributes#getDnsName}
         * @param dnsName The DNS name of the accelerator. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsName(java.lang.String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        /**
         * Sets the value of {@link AcceleratorAttributes#getDualStackDnsName}
         * @param dualStackDnsName The DNS name that points to the dual-stack accelerator's four static IP addresses: two IPv4 addresses and two IPv6 addresses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dualStackDnsName(java.lang.String dualStackDnsName) {
            this.dualStackDnsName = dualStackDnsName;
            return this;
        }

        /**
         * Sets the value of {@link AcceleratorAttributes#getIpv4Addresses}
         * @param ipv4Addresses The array of IPv4 addresses in the IP address set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv4Addresses(java.util.List<java.lang.String> ipv4Addresses) {
            this.ipv4Addresses = ipv4Addresses;
            return this;
        }

        /**
         * Sets the value of {@link AcceleratorAttributes#getIpv6Addresses}
         * @param ipv6Addresses The array of IPv6 addresses in the IP address set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6Addresses(java.util.List<java.lang.String> ipv6Addresses) {
            this.ipv6Addresses = ipv6Addresses;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AcceleratorAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AcceleratorAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AcceleratorAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AcceleratorAttributes {
        private final java.lang.String acceleratorArn;
        private final java.lang.String dnsName;
        private final java.lang.String dualStackDnsName;
        private final java.util.List<java.lang.String> ipv4Addresses;
        private final java.util.List<java.lang.String> ipv6Addresses;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.acceleratorArn = software.amazon.jsii.Kernel.get(this, "acceleratorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dnsName = software.amazon.jsii.Kernel.get(this, "dnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dualStackDnsName = software.amazon.jsii.Kernel.get(this, "dualStackDnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipv4Addresses = software.amazon.jsii.Kernel.get(this, "ipv4Addresses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.ipv6Addresses = software.amazon.jsii.Kernel.get(this, "ipv6Addresses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.acceleratorArn = java.util.Objects.requireNonNull(builder.acceleratorArn, "acceleratorArn is required");
            this.dnsName = java.util.Objects.requireNonNull(builder.dnsName, "dnsName is required");
            this.dualStackDnsName = builder.dualStackDnsName;
            this.ipv4Addresses = builder.ipv4Addresses;
            this.ipv6Addresses = builder.ipv6Addresses;
        }

        @Override
        public final java.lang.String getAcceleratorArn() {
            return this.acceleratorArn;
        }

        @Override
        public final java.lang.String getDnsName() {
            return this.dnsName;
        }

        @Override
        public final java.lang.String getDualStackDnsName() {
            return this.dualStackDnsName;
        }

        @Override
        public final java.util.List<java.lang.String> getIpv4Addresses() {
            return this.ipv4Addresses;
        }

        @Override
        public final java.util.List<java.lang.String> getIpv6Addresses() {
            return this.ipv6Addresses;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("acceleratorArn", om.valueToTree(this.getAcceleratorArn()));
            data.set("dnsName", om.valueToTree(this.getDnsName()));
            if (this.getDualStackDnsName() != null) {
                data.set("dualStackDnsName", om.valueToTree(this.getDualStackDnsName()));
            }
            if (this.getIpv4Addresses() != null) {
                data.set("ipv4Addresses", om.valueToTree(this.getIpv4Addresses()));
            }
            if (this.getIpv6Addresses() != null) {
                data.set("ipv6Addresses", om.valueToTree(this.getIpv6Addresses()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_globalaccelerator.AcceleratorAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AcceleratorAttributes.Jsii$Proxy that = (AcceleratorAttributes.Jsii$Proxy) o;

            if (!acceleratorArn.equals(that.acceleratorArn)) return false;
            if (!dnsName.equals(that.dnsName)) return false;
            if (this.dualStackDnsName != null ? !this.dualStackDnsName.equals(that.dualStackDnsName) : that.dualStackDnsName != null) return false;
            if (this.ipv4Addresses != null ? !this.ipv4Addresses.equals(that.ipv4Addresses) : that.ipv4Addresses != null) return false;
            return this.ipv6Addresses != null ? this.ipv6Addresses.equals(that.ipv6Addresses) : that.ipv6Addresses == null;
        }

        @Override
        public final int hashCode() {
            int result = this.acceleratorArn.hashCode();
            result = 31 * result + (this.dnsName.hashCode());
            result = 31 * result + (this.dualStackDnsName != null ? this.dualStackDnsName.hashCode() : 0);
            result = 31 * result + (this.ipv4Addresses != null ? this.ipv4Addresses.hashCode() : 0);
            result = 31 * result + (this.ipv6Addresses != null ? this.ipv6Addresses.hashCode() : 0);
            return result;
        }
    }
}
