package software.amazon.awscdk.services.glue;

/**
 * Properties for defining a <code>CfnMLTransform</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * Object tags;
 * CfnMLTransformProps cfnMLTransformProps = CfnMLTransformProps.builder()
 *         .inputRecordTables(InputRecordTablesProperty.builder()
 *                 .glueTables(List.of(GlueTablesProperty.builder()
 *                         .databaseName("databaseName")
 *                         .tableName("tableName")
 *                         // the properties below are optional
 *                         .catalogId("catalogId")
 *                         .connectionName("connectionName")
 *                         .build()))
 *                 .build())
 *         .role("role")
 *         .transformParameters(TransformParametersProperty.builder()
 *                 .transformType("transformType")
 *                 // the properties below are optional
 *                 .findMatchesParameters(FindMatchesParametersProperty.builder()
 *                         .primaryKeyColumnName("primaryKeyColumnName")
 *                         // the properties below are optional
 *                         .accuracyCostTradeoff(123)
 *                         .enforceProvidedLabels(false)
 *                         .precisionRecallTradeoff(123)
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .description("description")
 *         .glueVersion("glueVersion")
 *         .maxCapacity(123)
 *         .maxRetries(123)
 *         .name("name")
 *         .numberOfWorkers(123)
 *         .tags(tags)
 *         .timeout(123)
 *         .transformEncryption(TransformEncryptionProperty.builder()
 *                 .mlUserDataEncryption(MLUserDataEncryptionProperty.builder()
 *                         .mlUserDataEncryptionMode("mlUserDataEncryptionMode")
 *                         // the properties below are optional
 *                         .kmsKeyId("kmsKeyId")
 *                         .build())
 *                 .taskRunSecurityConfigurationName("taskRunSecurityConfigurationName")
 *                 .build())
 *         .workerType("workerType")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:53.226Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnMLTransformProps")
@software.amazon.jsii.Jsii.Proxy(CfnMLTransformProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMLTransformProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of AWS Glue table definitions used by the transform.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.glue.CfnMLTransform.InputRecordTablesProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-inputrecordtables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-inputrecordtables</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getInputRecordTables();

    /**
     * The name or Amazon Resource Name (ARN) of the IAM role with the required permissions.
     * <p>
     * The required permissions include both AWS Glue service role permissions to AWS Glue resources, and Amazon S3 permissions required by the transform.
     * <p>
     * <ul>
     * <li>This role needs AWS Glue service role permissions to allow access to resources in AWS Glue . See <a href="https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html">Attach a Policy to IAM Users That Access AWS Glue</a> .</li>
     * <li>This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets, temporary directory, scripts, and any libraries used by the task run for this transform.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-role">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-role</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRole();

    /**
     * The algorithm-specific parameters that are associated with the machine learning transform.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.glue.CfnMLTransform.TransformParametersProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-transformparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-transformparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTransformParameters();

    /**
     * A user-defined, long-form description text for the machine learning transform.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * This value determines which version of AWS Glue this machine learning transform is compatible with.
     * <p>
     * Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue Versions</a> in the developer guide.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-glueversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-glueversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGlueVersion() {
        return null;
    }

    /**
     * The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform.
     * <p>
     * You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a href="https://docs.aws.amazon.com/glue/pricing/">AWS Glue pricing page</a> .
     * <p>
     * <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code> .
     * <p>
     * <ul>
     * <li>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</li>
     * <li>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</li>
     * <li>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</li>
     * <li><code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</li>
     * </ul>
     * <p>
     * When the <code>WorkerType</code> field is set to a value other than <code>Standard</code> , the <code>MaxCapacity</code> field is set automatically and becomes read-only.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-maxcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-maxcapacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxCapacity() {
        return null;
    }

    /**
     * The maximum number of times to retry after an <code>MLTaskRun</code> of the machine learning transform fails.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-maxretries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-maxretries</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxRetries() {
        return null;
    }

    /**
     * A user-defined name for the machine learning transform. Names are required to be unique. <code>Name</code> is optional:.
     * <p>
     * <ul>
     * <li>If you supply <code>Name</code> , the stack cannot be repeatedly created.</li>
     * <li>If <code>Name</code> is not provided, a randomly generated name will be used instead.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The number of workers of a defined <code>workerType</code> that are allocated when a task of the transform runs.
     * <p>
     * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-numberofworkers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-numberofworkers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfWorkers() {
        return null;
    }

    /**
     * The tags to use with this machine learning transform.
     * <p>
     * You may use tags to limit access to the machine learning transform. For more information about tags in AWS Glue , see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in AWS Glue</a> in the developer guide.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
        return null;
    }

    /**
     * The timeout in minutes of the machine learning transform.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-timeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-timeout</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTimeout() {
        return null;
    }

    /**
     * The encryption-at-rest settings of the transform that apply to accessing user data.
     * <p>
     * Machine learning
     * transforms can access user data encrypted in Amazon S3 using KMS.
     * <p>
     * Additionally, imported labels and trained transforms can now be encrypted using a customer provided
     * KMS key.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.glue.CfnMLTransform.TransformEncryptionProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-transformencryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-transformencryption</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTransformEncryption() {
        return null;
    }

    /**
     * The type of predefined worker that is allocated when a task of this transform runs.
     * <p>
     * Accepts a value of Standard, G.1X, or G.2X.
     * <p>
     * <ul>
     * <li>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</li>
     * <li>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</li>
     * <li>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</li>
     * </ul>
     * <p>
     * <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code> .
     * <p>
     * <ul>
     * <li>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</li>
     * <li>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</li>
     * <li>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</li>
     * <li><code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-workertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-mltransform.html#cfn-glue-mltransform-workertype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWorkerType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMLTransformProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMLTransformProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMLTransformProps> {
        java.lang.Object inputRecordTables;
        java.lang.String role;
        java.lang.Object transformParameters;
        java.lang.String description;
        java.lang.String glueVersion;
        java.lang.Number maxCapacity;
        java.lang.Number maxRetries;
        java.lang.String name;
        java.lang.Number numberOfWorkers;
        java.lang.Object tags;
        java.lang.Number timeout;
        java.lang.Object transformEncryption;
        java.lang.String workerType;

        /**
         * Sets the value of {@link CfnMLTransformProps#getInputRecordTables}
         * @param inputRecordTables A list of AWS Glue table definitions used by the transform. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputRecordTables(software.amazon.awscdk.IResolvable inputRecordTables) {
            this.inputRecordTables = inputRecordTables;
            return this;
        }

        /**
         * Sets the value of {@link CfnMLTransformProps#getInputRecordTables}
         * @param inputRecordTables A list of AWS Glue table definitions used by the transform. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputRecordTables(software.amazon.awscdk.services.glue.CfnMLTransform.InputRecordTablesProperty inputRecordTables) {
            this.inputRecordTables = inputRecordTables;
            return this;
        }

        /**
         * Sets the value of {@link CfnMLTransformProps#getRole}
         * @param role The name or Amazon Resource Name (ARN) of the IAM role with the required permissions. This parameter is required.
         *             The required permissions include both AWS Glue service role permissions to AWS Glue resources, and Amazon S3 permissions required by the transform.
         *             <p>
         *             <ul>
         *             <li>This role needs AWS Glue service role permissions to allow access to resources in AWS Glue . See <a href="https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html">Attach a Policy to IAM Users That Access AWS Glue</a> .</li>
         *             <li>This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets, temporary directory, scripts, and any libraries used by the task run for this transform.</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(java.lang.String role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link CfnMLTransformProps#getTransformParameters}
         * @param transformParameters The algorithm-specific parameters that are associated with the machine learning transform. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformParameters(software.amazon.awscdk.IResolvable transformParameters) {
            this.transformParameters = transformParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnMLTransformProps#getTransformParameters}
         * @param transformParameters The algorithm-specific parameters that are associated with the machine learning transform. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformParameters(software.amazon.awscdk.services.glue.CfnMLTransform.TransformParametersProperty transformParameters) {
            this.transformParameters = transformParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnMLTransformProps#getDescription}
         * @param description A user-defined, long-form description text for the machine learning transform.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnMLTransformProps#getGlueVersion}
         * @param glueVersion This value determines which version of AWS Glue this machine learning transform is compatible with.
         *                    Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue Versions</a> in the developer guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder glueVersion(java.lang.String glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnMLTransformProps#getMaxCapacity}
         * @param maxCapacity The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform.
         *                    You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a href="https://docs.aws.amazon.com/glue/pricing/">AWS Glue pricing page</a> .
         *                    <p>
         *                    <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code> .
         *                    <p>
         *                    <ul>
         *                    <li>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</li>
         *                    <li>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</li>
         *                    <li>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</li>
         *                    <li><code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</li>
         *                    </ul>
         *                    <p>
         *                    When the <code>WorkerType</code> field is set to a value other than <code>Standard</code> , the <code>MaxCapacity</code> field is set automatically and becomes read-only.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCapacity(java.lang.Number maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnMLTransformProps#getMaxRetries}
         * @param maxRetries The maximum number of times to retry after an <code>MLTaskRun</code> of the machine learning transform fails.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRetries(java.lang.Number maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        /**
         * Sets the value of {@link CfnMLTransformProps#getName}
         * @param name A user-defined name for the machine learning transform. Names are required to be unique. <code>Name</code> is optional:.
         *             <ul>
         *             <li>If you supply <code>Name</code> , the stack cannot be repeatedly created.</li>
         *             <li>If <code>Name</code> is not provided, a randomly generated name will be used instead.</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnMLTransformProps#getNumberOfWorkers}
         * @param numberOfWorkers The number of workers of a defined <code>workerType</code> that are allocated when a task of the transform runs.
         *                        If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numberOfWorkers(java.lang.Number numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        /**
         * Sets the value of {@link CfnMLTransformProps#getTags}
         * @param tags The tags to use with this machine learning transform.
         *             You may use tags to limit access to the machine learning transform. For more information about tags in AWS Glue , see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in AWS Glue</a> in the developer guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnMLTransformProps#getTimeout}
         * @param timeout The timeout in minutes of the machine learning transform.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(java.lang.Number timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link CfnMLTransformProps#getTransformEncryption}
         * @param transformEncryption The encryption-at-rest settings of the transform that apply to accessing user data.
         *                            Machine learning
         *                            transforms can access user data encrypted in Amazon S3 using KMS.
         *                            <p>
         *                            Additionally, imported labels and trained transforms can now be encrypted using a customer provided
         *                            KMS key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformEncryption(software.amazon.awscdk.IResolvable transformEncryption) {
            this.transformEncryption = transformEncryption;
            return this;
        }

        /**
         * Sets the value of {@link CfnMLTransformProps#getTransformEncryption}
         * @param transformEncryption The encryption-at-rest settings of the transform that apply to accessing user data.
         *                            Machine learning
         *                            transforms can access user data encrypted in Amazon S3 using KMS.
         *                            <p>
         *                            Additionally, imported labels and trained transforms can now be encrypted using a customer provided
         *                            KMS key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformEncryption(software.amazon.awscdk.services.glue.CfnMLTransform.TransformEncryptionProperty transformEncryption) {
            this.transformEncryption = transformEncryption;
            return this;
        }

        /**
         * Sets the value of {@link CfnMLTransformProps#getWorkerType}
         * @param workerType The type of predefined worker that is allocated when a task of this transform runs.
         *                   Accepts a value of Standard, G.1X, or G.2X.
         *                   <p>
         *                   <ul>
         *                   <li>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</li>
         *                   <li>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</li>
         *                   <li>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</li>
         *                   </ul>
         *                   <p>
         *                   <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code> .
         *                   <p>
         *                   <ul>
         *                   <li>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</li>
         *                   <li>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</li>
         *                   <li>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</li>
         *                   <li><code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</li>
         *                   </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workerType(java.lang.String workerType) {
            this.workerType = workerType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMLTransformProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMLTransformProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMLTransformProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMLTransformProps {
        private final java.lang.Object inputRecordTables;
        private final java.lang.String role;
        private final java.lang.Object transformParameters;
        private final java.lang.String description;
        private final java.lang.String glueVersion;
        private final java.lang.Number maxCapacity;
        private final java.lang.Number maxRetries;
        private final java.lang.String name;
        private final java.lang.Number numberOfWorkers;
        private final java.lang.Object tags;
        private final java.lang.Number timeout;
        private final java.lang.Object transformEncryption;
        private final java.lang.String workerType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.inputRecordTables = software.amazon.jsii.Kernel.get(this, "inputRecordTables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.transformParameters = software.amazon.jsii.Kernel.get(this, "transformParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.glueVersion = software.amazon.jsii.Kernel.get(this, "glueVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxRetries = software.amazon.jsii.Kernel.get(this, "maxRetries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.numberOfWorkers = software.amazon.jsii.Kernel.get(this, "numberOfWorkers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.transformEncryption = software.amazon.jsii.Kernel.get(this, "transformEncryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.workerType = software.amazon.jsii.Kernel.get(this, "workerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.inputRecordTables = java.util.Objects.requireNonNull(builder.inputRecordTables, "inputRecordTables is required");
            this.role = java.util.Objects.requireNonNull(builder.role, "role is required");
            this.transformParameters = java.util.Objects.requireNonNull(builder.transformParameters, "transformParameters is required");
            this.description = builder.description;
            this.glueVersion = builder.glueVersion;
            this.maxCapacity = builder.maxCapacity;
            this.maxRetries = builder.maxRetries;
            this.name = builder.name;
            this.numberOfWorkers = builder.numberOfWorkers;
            this.tags = builder.tags;
            this.timeout = builder.timeout;
            this.transformEncryption = builder.transformEncryption;
            this.workerType = builder.workerType;
        }

        @Override
        public final java.lang.Object getInputRecordTables() {
            return this.inputRecordTables;
        }

        @Override
        public final java.lang.String getRole() {
            return this.role;
        }

        @Override
        public final java.lang.Object getTransformParameters() {
            return this.transformParameters;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getGlueVersion() {
            return this.glueVersion;
        }

        @Override
        public final java.lang.Number getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final java.lang.Number getMaxRetries() {
            return this.maxRetries;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Number getNumberOfWorkers() {
            return this.numberOfWorkers;
        }

        @Override
        public final java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Number getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.lang.Object getTransformEncryption() {
            return this.transformEncryption;
        }

        @Override
        public final java.lang.String getWorkerType() {
            return this.workerType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("inputRecordTables", om.valueToTree(this.getInputRecordTables()));
            data.set("role", om.valueToTree(this.getRole()));
            data.set("transformParameters", om.valueToTree(this.getTransformParameters()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getGlueVersion() != null) {
                data.set("glueVersion", om.valueToTree(this.getGlueVersion()));
            }
            if (this.getMaxCapacity() != null) {
                data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
            }
            if (this.getMaxRetries() != null) {
                data.set("maxRetries", om.valueToTree(this.getMaxRetries()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getNumberOfWorkers() != null) {
                data.set("numberOfWorkers", om.valueToTree(this.getNumberOfWorkers()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getTransformEncryption() != null) {
                data.set("transformEncryption", om.valueToTree(this.getTransformEncryption()));
            }
            if (this.getWorkerType() != null) {
                data.set("workerType", om.valueToTree(this.getWorkerType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnMLTransformProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMLTransformProps.Jsii$Proxy that = (CfnMLTransformProps.Jsii$Proxy) o;

            if (!inputRecordTables.equals(that.inputRecordTables)) return false;
            if (!role.equals(that.role)) return false;
            if (!transformParameters.equals(that.transformParameters)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.glueVersion != null ? !this.glueVersion.equals(that.glueVersion) : that.glueVersion != null) return false;
            if (this.maxCapacity != null ? !this.maxCapacity.equals(that.maxCapacity) : that.maxCapacity != null) return false;
            if (this.maxRetries != null ? !this.maxRetries.equals(that.maxRetries) : that.maxRetries != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.numberOfWorkers != null ? !this.numberOfWorkers.equals(that.numberOfWorkers) : that.numberOfWorkers != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.transformEncryption != null ? !this.transformEncryption.equals(that.transformEncryption) : that.transformEncryption != null) return false;
            return this.workerType != null ? this.workerType.equals(that.workerType) : that.workerType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.inputRecordTables.hashCode();
            result = 31 * result + (this.role.hashCode());
            result = 31 * result + (this.transformParameters.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.glueVersion != null ? this.glueVersion.hashCode() : 0);
            result = 31 * result + (this.maxCapacity != null ? this.maxCapacity.hashCode() : 0);
            result = 31 * result + (this.maxRetries != null ? this.maxRetries.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.numberOfWorkers != null ? this.numberOfWorkers.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.transformEncryption != null ? this.transformEncryption.hashCode() : 0);
            result = 31 * result + (this.workerType != null ? this.workerType.hashCode() : 0);
            return result;
        }
    }
}
