package software.amazon.awscdk.services.iam;

/**
 * Properties of an Instance Profile.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Role role = Role.Builder.create(this, "Role")
 *         .assumedBy(new ServicePrincipal("ec2.amazonaws.com"))
 *         .build();
 * InstanceProfile instanceProfile = InstanceProfile.Builder.create(this, "InstanceProfile")
 *         .role(role)
 *         .build();
 * LaunchTemplate template = LaunchTemplate.Builder.create(this, "LaunchTemplate")
 *         .launchTemplateName("MyTemplateV1")
 *         .versionDescription("This is my v1 template")
 *         .machineImage(MachineImage.latestAmazonLinux2023())
 *         .securityGroup(SecurityGroup.Builder.create(this, "LaunchTemplateSG")
 *                 .vpc(vpc)
 *                 .build())
 *         .instanceProfile(instanceProfile)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:53.598Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.InstanceProfileProps")
@software.amazon.jsii.Jsii.Proxy(InstanceProfileProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InstanceProfileProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the InstanceProfile to create.
     * <p>
     * Default: - generated by CloudFormation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceProfileName() {
        return null;
    }

    /**
     * The path to the InstanceProfile.
     * <p>
     * Default: /
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
        return null;
    }

    /**
     * An IAM role to associate with the instance profile that is used by EC2 instances.
     * <p>
     * The role must be assumable by the service principal <code>ec2.amazonaws.com</code>:
     * <p>
     * Default: - a role will be automatically created, it can be accessed via the `role` property
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * Role role = Role.Builder.create(this, "MyRole")
     *         .assumedBy(new ServicePrincipal("ec2.amazonaws.com"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link InstanceProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InstanceProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InstanceProfileProps> {
        java.lang.String instanceProfileName;
        java.lang.String path;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link InstanceProfileProps#getInstanceProfileName}
         * @param instanceProfileName The name of the InstanceProfile to create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceProfileName(java.lang.String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProfileProps#getPath}
         * @param path The path to the InstanceProfile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProfileProps#getRole}
         * @param role An IAM role to associate with the instance profile that is used by EC2 instances.
         *             The role must be assumable by the service principal <code>ec2.amazonaws.com</code>:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InstanceProfileProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InstanceProfileProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InstanceProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceProfileProps {
        private final java.lang.String instanceProfileName;
        private final java.lang.String path;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceProfileName = software.amazon.jsii.Kernel.get(this, "instanceProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceProfileName = builder.instanceProfileName;
            this.path = builder.path;
            this.role = builder.role;
        }

        @Override
        public final java.lang.String getInstanceProfileName() {
            return this.instanceProfileName;
        }

        @Override
        public final java.lang.String getPath() {
            return this.path;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getInstanceProfileName() != null) {
                data.set("instanceProfileName", om.valueToTree(this.getInstanceProfileName()));
            }
            if (this.getPath() != null) {
                data.set("path", om.valueToTree(this.getPath()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iam.InstanceProfileProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InstanceProfileProps.Jsii$Proxy that = (InstanceProfileProps.Jsii$Proxy) o;

            if (this.instanceProfileName != null ? !this.instanceProfileName.equals(that.instanceProfileName) : that.instanceProfileName != null) return false;
            if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceProfileName != null ? this.instanceProfileName.hashCode() : 0;
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
