package software.amazon.awscdk.services.iam;

/**
 * An IAM principal with additional conditions specifying when the policy is in effect.
 * <p>
 * For more information about conditions, see:
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * Object conditions;
 * IPrincipal principal;
 * PrincipalWithConditions principalWithConditions = new PrincipalWithConditions(principal, Map.of(
 *         "conditionsKey", conditions));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:53.623Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.PrincipalWithConditions")
public class PrincipalWithConditions extends software.amazon.awscdk.services.iam.PrincipalBase {

    protected PrincipalWithConditions(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PrincipalWithConditions(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param principal This parameter is required.
     * @param conditions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PrincipalWithConditions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal principal, final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> conditions) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(principal, "principal is required"), java.util.Objects.requireNonNull(conditions, "conditions is required") });
    }

    /**
     * Add a condition to the principal.
     * <p>
     * @param key This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addCondition(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.call(this, "addCondition", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), value });
    }

    /**
     * Adds multiple conditions to the principal.
     * <p>
     * Values from the conditions parameter will overwrite existing values with the same operator
     * and key.
     * <p>
     * @param conditions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addConditions(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> conditions) {
        software.amazon.jsii.Kernel.call(this, "addConditions", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(conditions, "conditions is required") });
    }

    /**
     * Add the principal to the AssumeRolePolicyDocument.
     * <p>
     * Add the statements to the AssumeRolePolicyDocument necessary to give this principal
     * permissions to assume the given role.
     * <p>
     * @param doc This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addToAssumeRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyDocument doc) {
        software.amazon.jsii.Kernel.call(this, "addToAssumeRolePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(doc, "doc is required") });
    }

    /**
     * Add to the policy of this principal.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Boolean addToPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return software.amazon.jsii.Kernel.call(this, "addToPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Add to the policy of this principal.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult addToPrincipalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return software.amazon.jsii.Kernel.call(this, "addToPrincipalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Append the given string to the wrapped principal's dedupe string (if available).
     * <p>
     * @param append This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.String appendDedupe(final @org.jetbrains.annotations.NotNull java.lang.String append) {
        return software.amazon.jsii.Kernel.call(this, "appendDedupe", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(append, "append is required") });
    }

    /**
     * Return whether or not this principal is equal to the given principal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.Nullable java.lang.String dedupeString() {
        return software.amazon.jsii.Kernel.call(this, "dedupeString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * JSON-ify the principal.
     * <p>
     * Used when JSON.stringify() is called
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.util.List<java.lang.String>> toJSON() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "toJSON", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)))));
    }

    /**
     * Returns a string representation of an object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * When this Principal is used in an AssumeRole policy, the action to use.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssumeRoleAction() {
        return software.amazon.jsii.Kernel.get(this, "assumeRoleAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The conditions under which the policy is in effect.
     * <p>
     * See <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html">the IAM documentation</a>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getConditions() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Return the policy fragment that identifies this principal in a Policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
        return software.amazon.jsii.Kernel.get(this, "policyFragment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class));
    }

    /**
     * The AWS account ID of this principal.
     * <p>
     * Can be undefined when the account is not known
     * (for example, for service principals).
     * Can be a Token - in that case,
     * it's assumed to be AWS::AccountId.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPrincipalAccount() {
        return software.amazon.jsii.Kernel.get(this, "principalAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
