package software.amazon.awscdk.services.iam;

/**
 * A SAML provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SamlProvider provider = SamlProvider.Builder.create(this, "Provider")
 *         .metadataDocument(SamlMetadataDocument.fromFile("/path/to/saml-metadata-document.xml"))
 *         .build();
 * Role.Builder.create(this, "Role")
 *         .assumedBy(new SamlConsolePrincipal(provider))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:53.629Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.SamlProvider")
public class SamlProvider extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.iam.ISamlProvider {

    protected SamlProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SamlProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iam.SamlProvider.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SamlProvider(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.SamlProviderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing provider.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param samlProviderArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.ISamlProvider fromSamlProviderArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String samlProviderArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.SamlProvider.class, "fromSamlProviderArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.ISamlProvider.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(samlProviderArn, "samlProviderArn is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The Amazon Resource Name (ARN) of the provider.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSamlProviderArn() {
        return software.amazon.jsii.Kernel.get(this, "samlProviderArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A reference to a SAMLProvider resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.iam.SAMLProviderReference getSamlProviderRef() {
        return software.amazon.jsii.Kernel.get(this, "samlProviderRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.iam.SAMLProviderReference.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iam.SamlProvider}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iam.SamlProvider> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iam.SamlProviderProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iam.SamlProviderProps.Builder();
        }

        /**
         * An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the issuer's name, expiration information, and keys that can be used to validate the SAML authentication response (assertions) that are received from the IdP. You must generate the metadata document using the identity management software that is used as your organization's IdP.
         * <p>
         * @return {@code this}
         * @param metadataDocument An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the issuer's name, expiration information, and keys that can be used to validate the SAML authentication response (assertions) that are received from the IdP. You must generate the metadata document using the identity management software that is used as your organization's IdP. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadataDocument(final software.amazon.awscdk.services.iam.SamlMetadataDocument metadataDocument) {
            this.props.metadataDocument(metadataDocument);
            return this;
        }

        /**
         * The name of the provider to create.
         * <p>
         * This parameter allows a string of characters consisting of upper and
         * lowercase alphanumeric characters with no spaces. You can also include
         * any of the following characters: _+=,.&#64;-
         * <p>
         * Length must be between 1 and 128 characters.
         * <p>
         * Default: - a CloudFormation generated name
         * <p>
         * @return {@code this}
         * @param name The name of the provider to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iam.SamlProvider}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iam.SamlProvider build() {
            return new software.amazon.awscdk.services.iam.SamlProvider(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
