package software.amazon.awscdk.services.imagebuilder;

/**
 * Properties for defining a <code>CfnLifecyclePolicy</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.imagebuilder.*;
 * CfnLifecyclePolicyProps cfnLifecyclePolicyProps = CfnLifecyclePolicyProps.builder()
 *         .executionRole("executionRole")
 *         .name("name")
 *         .policyDetails(List.of(PolicyDetailProperty.builder()
 *                 .action(ActionProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .includeResources(IncludeResourcesProperty.builder()
 *                                 .amis(false)
 *                                 .containers(false)
 *                                 .snapshots(false)
 *                                 .build())
 *                         .build())
 *                 .filter(FilterProperty.builder()
 *                         .type("type")
 *                         .value(123)
 *                         // the properties below are optional
 *                         .retainAtLeast(123)
 *                         .unit("unit")
 *                         .build())
 *                 // the properties below are optional
 *                 .exclusionRules(ExclusionRulesProperty.builder()
 *                         .amis(AmiExclusionRulesProperty.builder()
 *                                 .isPublic(false)
 *                                 .lastLaunched(LastLaunchedProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .regions(List.of("regions"))
 *                                 .sharedAccounts(List.of("sharedAccounts"))
 *                                 .tagMap(Map.of(
 *                                         "tagMapKey", "tagMap"))
 *                                 .build())
 *                         .tagMap(Map.of(
 *                                 "tagMapKey", "tagMap"))
 *                         .build())
 *                 .build()))
 *         .resourceSelection(ResourceSelectionProperty.builder()
 *                 .recipes(List.of(RecipeSelectionProperty.builder()
 *                         .name("name")
 *                         .semanticVersion("semanticVersion")
 *                         .build()))
 *                 .tagMap(Map.of(
 *                         "tagMapKey", "tagMap"))
 *                 .build())
 *         .resourceType("resourceType")
 *         // the properties below are optional
 *         .description("description")
 *         .status("status")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:53.711Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnLifecyclePolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnLifecyclePolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLifecyclePolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to run lifecycle actions.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-executionrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-executionrole</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExecutionRole();

    /**
     * The name of the lifecycle policy to create.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Configuration details for the lifecycle policy rules.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.imagebuilder.CfnLifecyclePolicy.PolicyDetailProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-policydetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-policydetails</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getPolicyDetails();

    /**
     * Selection criteria for the resources that the lifecycle policy applies to.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.imagebuilder.CfnLifecyclePolicy.ResourceSelectionProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-resourceselection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-resourceselection</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getResourceSelection();

    /**
     * The type of Image Builder resource that the lifecycle policy applies to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-resourcetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-resourcetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceType();

    /**
     * Optional description for the lifecycle policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Indicates whether the lifecycle policy resource is enabled.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-status</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
        return null;
    }

    /**
     * Tags to apply to the lifecycle policy resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLifecyclePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLifecyclePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLifecyclePolicyProps> {
        java.lang.String executionRole;
        java.lang.String name;
        java.lang.Object policyDetails;
        java.lang.Object resourceSelection;
        java.lang.String resourceType;
        java.lang.String description;
        java.lang.String status;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getExecutionRole}
         * @param executionRole The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to run lifecycle actions. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(java.lang.String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getName}
         * @param name The name of the lifecycle policy to create. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getPolicyDetails}
         * @param policyDetails Configuration details for the lifecycle policy rules. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDetails(software.amazon.awscdk.IResolvable policyDetails) {
            this.policyDetails = policyDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getPolicyDetails}
         * @param policyDetails Configuration details for the lifecycle policy rules. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDetails(java.util.List<? extends java.lang.Object> policyDetails) {
            this.policyDetails = policyDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getResourceSelection}
         * @param resourceSelection Selection criteria for the resources that the lifecycle policy applies to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceSelection(software.amazon.awscdk.IResolvable resourceSelection) {
            this.resourceSelection = resourceSelection;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getResourceSelection}
         * @param resourceSelection Selection criteria for the resources that the lifecycle policy applies to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceSelection(software.amazon.awscdk.services.imagebuilder.CfnLifecyclePolicy.ResourceSelectionProperty resourceSelection) {
            this.resourceSelection = resourceSelection;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getResourceType}
         * @param resourceType The type of Image Builder resource that the lifecycle policy applies to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getDescription}
         * @param description Optional description for the lifecycle policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getStatus}
         * @param status Indicates whether the lifecycle policy resource is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getTags}
         * @param tags Tags to apply to the lifecycle policy resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLifecyclePolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLifecyclePolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLifecyclePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLifecyclePolicyProps {
        private final java.lang.String executionRole;
        private final java.lang.String name;
        private final java.lang.Object policyDetails;
        private final java.lang.Object resourceSelection;
        private final java.lang.String resourceType;
        private final java.lang.String description;
        private final java.lang.String status;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policyDetails = software.amazon.jsii.Kernel.get(this, "policyDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resourceSelection = software.amazon.jsii.Kernel.get(this, "resourceSelection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.executionRole = java.util.Objects.requireNonNull(builder.executionRole, "executionRole is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.policyDetails = java.util.Objects.requireNonNull(builder.policyDetails, "policyDetails is required");
            this.resourceSelection = java.util.Objects.requireNonNull(builder.resourceSelection, "resourceSelection is required");
            this.resourceType = java.util.Objects.requireNonNull(builder.resourceType, "resourceType is required");
            this.description = builder.description;
            this.status = builder.status;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getExecutionRole() {
            return this.executionRole;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getPolicyDetails() {
            return this.policyDetails;
        }

        @Override
        public final java.lang.Object getResourceSelection() {
            return this.resourceSelection;
        }

        @Override
        public final java.lang.String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getStatus() {
            return this.status;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("executionRole", om.valueToTree(this.getExecutionRole()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("policyDetails", om.valueToTree(this.getPolicyDetails()));
            data.set("resourceSelection", om.valueToTree(this.getResourceSelection()));
            data.set("resourceType", om.valueToTree(this.getResourceType()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getStatus() != null) {
                data.set("status", om.valueToTree(this.getStatus()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnLifecyclePolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLifecyclePolicyProps.Jsii$Proxy that = (CfnLifecyclePolicyProps.Jsii$Proxy) o;

            if (!executionRole.equals(that.executionRole)) return false;
            if (!name.equals(that.name)) return false;
            if (!policyDetails.equals(that.policyDetails)) return false;
            if (!resourceSelection.equals(that.resourceSelection)) return false;
            if (!resourceType.equals(that.resourceType)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.executionRole.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.policyDetails.hashCode());
            result = 31 * result + (this.resourceSelection.hashCode());
            result = 31 * result + (this.resourceType.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
