package software.amazon.awscdk.services.iot;

/**
 * Properties for defining a <code>CfnThingPrincipalAttachment</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnThingPrincipalAttachmentProps cfnThingPrincipalAttachmentProps = CfnThingPrincipalAttachmentProps.builder()
 *         .principal("principal")
 *         .thingName("thingName")
 *         // the properties below are optional
 *         .thingPrincipalType("thingPrincipalType")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:53.874Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnThingPrincipalAttachmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnThingPrincipalAttachmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnThingPrincipalAttachmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The principal, which can be a certificate ARN (as returned from the <code>CreateCertificate</code> operation) or an Amazon Cognito ID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html#cfn-iot-thingprincipalattachment-principal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html#cfn-iot-thingprincipalattachment-principal</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrincipal();

    /**
     * The name of the AWS IoT thing.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html#cfn-iot-thingprincipalattachment-thingname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html#cfn-iot-thingprincipalattachment-thingname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getThingName();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html#cfn-iot-thingprincipalattachment-thingprincipaltype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html#cfn-iot-thingprincipalattachment-thingprincipaltype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getThingPrincipalType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnThingPrincipalAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnThingPrincipalAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnThingPrincipalAttachmentProps> {
        java.lang.String principal;
        java.lang.String thingName;
        java.lang.String thingPrincipalType;

        /**
         * Sets the value of {@link CfnThingPrincipalAttachmentProps#getPrincipal}
         * @param principal The principal, which can be a certificate ARN (as returned from the <code>CreateCertificate</code> operation) or an Amazon Cognito ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principal(java.lang.String principal) {
            this.principal = principal;
            return this;
        }

        /**
         * Sets the value of {@link CfnThingPrincipalAttachmentProps#getThingName}
         * @param thingName The name of the AWS IoT thing. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingName(java.lang.String thingName) {
            this.thingName = thingName;
            return this;
        }

        /**
         * Sets the value of {@link CfnThingPrincipalAttachmentProps#getThingPrincipalType}
         * @param thingPrincipalType the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingPrincipalType(java.lang.String thingPrincipalType) {
            this.thingPrincipalType = thingPrincipalType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnThingPrincipalAttachmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnThingPrincipalAttachmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnThingPrincipalAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnThingPrincipalAttachmentProps {
        private final java.lang.String principal;
        private final java.lang.String thingName;
        private final java.lang.String thingPrincipalType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.principal = software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.thingName = software.amazon.jsii.Kernel.get(this, "thingName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.thingPrincipalType = software.amazon.jsii.Kernel.get(this, "thingPrincipalType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.principal = java.util.Objects.requireNonNull(builder.principal, "principal is required");
            this.thingName = java.util.Objects.requireNonNull(builder.thingName, "thingName is required");
            this.thingPrincipalType = builder.thingPrincipalType;
        }

        @Override
        public final java.lang.String getPrincipal() {
            return this.principal;
        }

        @Override
        public final java.lang.String getThingName() {
            return this.thingName;
        }

        @Override
        public final java.lang.String getThingPrincipalType() {
            return this.thingPrincipalType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("principal", om.valueToTree(this.getPrincipal()));
            data.set("thingName", om.valueToTree(this.getThingName()));
            if (this.getThingPrincipalType() != null) {
                data.set("thingPrincipalType", om.valueToTree(this.getThingPrincipalType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnThingPrincipalAttachmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnThingPrincipalAttachmentProps.Jsii$Proxy that = (CfnThingPrincipalAttachmentProps.Jsii$Proxy) o;

            if (!principal.equals(that.principal)) return false;
            if (!thingName.equals(that.thingName)) return false;
            return this.thingPrincipalType != null ? this.thingPrincipalType.equals(that.thingPrincipalType) : that.thingPrincipalType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.principal.hashCode();
            result = 31 * result + (this.thingName.hashCode());
            result = 31 * result + (this.thingPrincipalType != null ? this.thingPrincipalType.hashCode() : 0);
            return result;
        }
    }
}
