package software.amazon.awscdk.services.ivs;

/**
 * The <code>AWS::IVS::Stage</code> resource specifies an  stage.
 * <p>
 * A stage is a virtual space where participants can exchange video in real time. For more information, see <a href="https://docs.aws.amazon.com/ivs/latest/RealTimeAPIReference/API_CreateStage.html">CreateStage</a> in the <em>Amazon IVS Real-Time Streaming API Reference</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ivs.*;
 * CfnStage cfnStage = CfnStage.Builder.create(this, "MyCfnStage")
 *         .autoParticipantRecordingConfiguration(AutoParticipantRecordingConfigurationProperty.builder()
 *                 .storageConfigurationArn("storageConfigurationArn")
 *                 // the properties below are optional
 *                 .hlsConfiguration(HlsConfigurationProperty.builder()
 *                         .participantRecordingHlsConfiguration(ParticipantRecordingHlsConfigurationProperty.builder()
 *                                 .targetSegmentDurationSeconds(123)
 *                                 .build())
 *                         .build())
 *                 .mediaTypes(List.of("mediaTypes"))
 *                 .recordingReconnectWindowSeconds(123)
 *                 .thumbnailConfiguration(ThumbnailConfigurationProperty.builder()
 *                         .participantThumbnailConfiguration(ParticipantThumbnailConfigurationProperty.builder()
 *                                 .recordingMode("recordingMode")
 *                                 .storage(List.of("storage"))
 *                                 .targetIntervalSeconds(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-stage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-stage.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:54.269Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ivs.CfnStage")
public class CfnStage extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.ivs.IStageRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnStage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ivs.CfnStage.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::IVS::Stage</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStage(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ivs.CfnStageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new <code>AWS::IVS::Stage</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStage(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * ID of the active session within the stage.
     * <p>
     * For example: <code>st-a1b2c3d4e5f6g</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrActiveSessionId() {
        return software.amazon.jsii.Kernel.get(this, "attrActiveSessionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The stage ARN.
     * <p>
     * For example: <code>arn:aws:ivs:us-west-2:123456789012:stage/abcdABCDefgh</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a Stage resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.ivs.StageReference getStageRef() {
        return software.amazon.jsii.Kernel.get(this, "stageRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.ivs.StageReference.class));
    }

    /**
     * Configuration object for individual participant recording.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ivs.CfnStage.AutoParticipantRecordingConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoParticipantRecordingConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "autoParticipantRecordingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration object for individual participant recording.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoParticipantRecordingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoParticipantRecordingConfiguration", value);
    }

    /**
     * Configuration object for individual participant recording.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoParticipantRecordingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ivs.CfnStage.AutoParticipantRecordingConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "autoParticipantRecordingConfiguration", value);
    }

    /**
     * Stage name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Stage name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * The <code>AWS::IVS::AutoParticipantRecordingConfiguration</code> property type describes a configuration for individual participant recording.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ivs.*;
     * AutoParticipantRecordingConfigurationProperty autoParticipantRecordingConfigurationProperty = AutoParticipantRecordingConfigurationProperty.builder()
     *         .storageConfigurationArn("storageConfigurationArn")
     *         // the properties below are optional
     *         .hlsConfiguration(HlsConfigurationProperty.builder()
     *                 .participantRecordingHlsConfiguration(ParticipantRecordingHlsConfigurationProperty.builder()
     *                         .targetSegmentDurationSeconds(123)
     *                         .build())
     *                 .build())
     *         .mediaTypes(List.of("mediaTypes"))
     *         .recordingReconnectWindowSeconds(123)
     *         .thumbnailConfiguration(ThumbnailConfigurationProperty.builder()
     *                 .participantThumbnailConfiguration(ParticipantThumbnailConfigurationProperty.builder()
     *                         .recordingMode("recordingMode")
     *                         .storage(List.of("storage"))
     *                         .targetIntervalSeconds(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-autoparticipantrecordingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-autoparticipantrecordingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ivs.CfnStage.AutoParticipantRecordingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoParticipantRecordingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoParticipantRecordingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * ARN of the StorageConfiguration resource to use for individual participant recording.
         * <p>
         * Default: "" (empty string, no storage configuration is specified). Individual participant recording cannot be started unless a storage configuration is specified, when a Stage is created or updated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-autoparticipantrecordingconfiguration.html#cfn-ivs-stage-autoparticipantrecordingconfiguration-storageconfigurationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-autoparticipantrecordingconfiguration.html#cfn-ivs-stage-autoparticipantrecordingconfiguration-storageconfigurationarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStorageConfigurationArn();

        /**
         * HLS configuration object for individual participant recording.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ivs.CfnStage.HlsConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-autoparticipantrecordingconfiguration.html#cfn-ivs-stage-autoparticipantrecordingconfiguration-hlsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-autoparticipantrecordingconfiguration.html#cfn-ivs-stage-autoparticipantrecordingconfiguration-hlsconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHlsConfiguration() {
            return null;
        }

        /**
         * Types of media to be recorded.
         * <p>
         * Default: <code>AUDIO_VIDEO</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-autoparticipantrecordingconfiguration.html#cfn-ivs-stage-autoparticipantrecordingconfiguration-mediatypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-autoparticipantrecordingconfiguration.html#cfn-ivs-stage-autoparticipantrecordingconfiguration-mediatypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMediaTypes() {
            return null;
        }

        /**
         * If a stage publisher disconnects and then reconnects within the specified interval, the multiple recordings will be considered a single recording and merged together.
         * <p>
         * The default value is 0, which disables merging.
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-autoparticipantrecordingconfiguration.html#cfn-ivs-stage-autoparticipantrecordingconfiguration-recordingreconnectwindowseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-autoparticipantrecordingconfiguration.html#cfn-ivs-stage-autoparticipantrecordingconfiguration-recordingreconnectwindowseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRecordingReconnectWindowSeconds() {
            return null;
        }

        /**
         * A complex type that allows you to enable/disable the recording of thumbnails for individual participant recording and modify the interval at which thumbnails are generated for the live session.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ivs.CfnStage.ThumbnailConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-autoparticipantrecordingconfiguration.html#cfn-ivs-stage-autoparticipantrecordingconfiguration-thumbnailconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-autoparticipantrecordingconfiguration.html#cfn-ivs-stage-autoparticipantrecordingconfiguration-thumbnailconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getThumbnailConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutoParticipantRecordingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoParticipantRecordingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoParticipantRecordingConfigurationProperty> {
            java.lang.String storageConfigurationArn;
            java.lang.Object hlsConfiguration;
            java.util.List<java.lang.String> mediaTypes;
            java.lang.Number recordingReconnectWindowSeconds;
            java.lang.Object thumbnailConfiguration;

            /**
             * Sets the value of {@link AutoParticipantRecordingConfigurationProperty#getStorageConfigurationArn}
             * @param storageConfigurationArn ARN of the StorageConfiguration resource to use for individual participant recording. This parameter is required.
             *                                Default: "" (empty string, no storage configuration is specified). Individual participant recording cannot be started unless a storage configuration is specified, when a Stage is created or updated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageConfigurationArn(java.lang.String storageConfigurationArn) {
                this.storageConfigurationArn = storageConfigurationArn;
                return this;
            }

            /**
             * Sets the value of {@link AutoParticipantRecordingConfigurationProperty#getHlsConfiguration}
             * @param hlsConfiguration HLS configuration object for individual participant recording.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hlsConfiguration(software.amazon.awscdk.IResolvable hlsConfiguration) {
                this.hlsConfiguration = hlsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AutoParticipantRecordingConfigurationProperty#getHlsConfiguration}
             * @param hlsConfiguration HLS configuration object for individual participant recording.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hlsConfiguration(software.amazon.awscdk.services.ivs.CfnStage.HlsConfigurationProperty hlsConfiguration) {
                this.hlsConfiguration = hlsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AutoParticipantRecordingConfigurationProperty#getMediaTypes}
             * @param mediaTypes Types of media to be recorded.
             *                   Default: <code>AUDIO_VIDEO</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mediaTypes(java.util.List<java.lang.String> mediaTypes) {
                this.mediaTypes = mediaTypes;
                return this;
            }

            /**
             * Sets the value of {@link AutoParticipantRecordingConfigurationProperty#getRecordingReconnectWindowSeconds}
             * @param recordingReconnectWindowSeconds If a stage publisher disconnects and then reconnects within the specified interval, the multiple recordings will be considered a single recording and merged together.
             *                                        The default value is 0, which disables merging.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordingReconnectWindowSeconds(java.lang.Number recordingReconnectWindowSeconds) {
                this.recordingReconnectWindowSeconds = recordingReconnectWindowSeconds;
                return this;
            }

            /**
             * Sets the value of {@link AutoParticipantRecordingConfigurationProperty#getThumbnailConfiguration}
             * @param thumbnailConfiguration A complex type that allows you to enable/disable the recording of thumbnails for individual participant recording and modify the interval at which thumbnails are generated for the live session.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thumbnailConfiguration(software.amazon.awscdk.IResolvable thumbnailConfiguration) {
                this.thumbnailConfiguration = thumbnailConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AutoParticipantRecordingConfigurationProperty#getThumbnailConfiguration}
             * @param thumbnailConfiguration A complex type that allows you to enable/disable the recording of thumbnails for individual participant recording and modify the interval at which thumbnails are generated for the live session.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thumbnailConfiguration(software.amazon.awscdk.services.ivs.CfnStage.ThumbnailConfigurationProperty thumbnailConfiguration) {
                this.thumbnailConfiguration = thumbnailConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoParticipantRecordingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoParticipantRecordingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoParticipantRecordingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoParticipantRecordingConfigurationProperty {
            private final java.lang.String storageConfigurationArn;
            private final java.lang.Object hlsConfiguration;
            private final java.util.List<java.lang.String> mediaTypes;
            private final java.lang.Number recordingReconnectWindowSeconds;
            private final java.lang.Object thumbnailConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.storageConfigurationArn = software.amazon.jsii.Kernel.get(this, "storageConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hlsConfiguration = software.amazon.jsii.Kernel.get(this, "hlsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mediaTypes = software.amazon.jsii.Kernel.get(this, "mediaTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.recordingReconnectWindowSeconds = software.amazon.jsii.Kernel.get(this, "recordingReconnectWindowSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.thumbnailConfiguration = software.amazon.jsii.Kernel.get(this, "thumbnailConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.storageConfigurationArn = java.util.Objects.requireNonNull(builder.storageConfigurationArn, "storageConfigurationArn is required");
                this.hlsConfiguration = builder.hlsConfiguration;
                this.mediaTypes = builder.mediaTypes;
                this.recordingReconnectWindowSeconds = builder.recordingReconnectWindowSeconds;
                this.thumbnailConfiguration = builder.thumbnailConfiguration;
            }

            @Override
            public final java.lang.String getStorageConfigurationArn() {
                return this.storageConfigurationArn;
            }

            @Override
            public final java.lang.Object getHlsConfiguration() {
                return this.hlsConfiguration;
            }

            @Override
            public final java.util.List<java.lang.String> getMediaTypes() {
                return this.mediaTypes;
            }

            @Override
            public final java.lang.Number getRecordingReconnectWindowSeconds() {
                return this.recordingReconnectWindowSeconds;
            }

            @Override
            public final java.lang.Object getThumbnailConfiguration() {
                return this.thumbnailConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("storageConfigurationArn", om.valueToTree(this.getStorageConfigurationArn()));
                if (this.getHlsConfiguration() != null) {
                    data.set("hlsConfiguration", om.valueToTree(this.getHlsConfiguration()));
                }
                if (this.getMediaTypes() != null) {
                    data.set("mediaTypes", om.valueToTree(this.getMediaTypes()));
                }
                if (this.getRecordingReconnectWindowSeconds() != null) {
                    data.set("recordingReconnectWindowSeconds", om.valueToTree(this.getRecordingReconnectWindowSeconds()));
                }
                if (this.getThumbnailConfiguration() != null) {
                    data.set("thumbnailConfiguration", om.valueToTree(this.getThumbnailConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ivs.CfnStage.AutoParticipantRecordingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoParticipantRecordingConfigurationProperty.Jsii$Proxy that = (AutoParticipantRecordingConfigurationProperty.Jsii$Proxy) o;

                if (!storageConfigurationArn.equals(that.storageConfigurationArn)) return false;
                if (this.hlsConfiguration != null ? !this.hlsConfiguration.equals(that.hlsConfiguration) : that.hlsConfiguration != null) return false;
                if (this.mediaTypes != null ? !this.mediaTypes.equals(that.mediaTypes) : that.mediaTypes != null) return false;
                if (this.recordingReconnectWindowSeconds != null ? !this.recordingReconnectWindowSeconds.equals(that.recordingReconnectWindowSeconds) : that.recordingReconnectWindowSeconds != null) return false;
                return this.thumbnailConfiguration != null ? this.thumbnailConfiguration.equals(that.thumbnailConfiguration) : that.thumbnailConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.storageConfigurationArn.hashCode();
                result = 31 * result + (this.hlsConfiguration != null ? this.hlsConfiguration.hashCode() : 0);
                result = 31 * result + (this.mediaTypes != null ? this.mediaTypes.hashCode() : 0);
                result = 31 * result + (this.recordingReconnectWindowSeconds != null ? this.recordingReconnectWindowSeconds.hashCode() : 0);
                result = 31 * result + (this.thumbnailConfiguration != null ? this.thumbnailConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Object specifying an HLS configuration for individual participant recording.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ivs.*;
     * HlsConfigurationProperty hlsConfigurationProperty = HlsConfigurationProperty.builder()
     *         .participantRecordingHlsConfiguration(ParticipantRecordingHlsConfigurationProperty.builder()
     *                 .targetSegmentDurationSeconds(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-hlsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-hlsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ivs.CfnStage.HlsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(HlsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HlsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Object specifying a configuration of participant HLS recordings for individual participant recording.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ivs.CfnStage.ParticipantRecordingHlsConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-hlsconfiguration.html#cfn-ivs-stage-hlsconfiguration-participantrecordinghlsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-hlsconfiguration.html#cfn-ivs-stage-hlsconfiguration-participantrecordinghlsconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParticipantRecordingHlsConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HlsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HlsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HlsConfigurationProperty> {
            java.lang.Object participantRecordingHlsConfiguration;

            /**
             * Sets the value of {@link HlsConfigurationProperty#getParticipantRecordingHlsConfiguration}
             * @param participantRecordingHlsConfiguration Object specifying a configuration of participant HLS recordings for individual participant recording.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder participantRecordingHlsConfiguration(software.amazon.awscdk.IResolvable participantRecordingHlsConfiguration) {
                this.participantRecordingHlsConfiguration = participantRecordingHlsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link HlsConfigurationProperty#getParticipantRecordingHlsConfiguration}
             * @param participantRecordingHlsConfiguration Object specifying a configuration of participant HLS recordings for individual participant recording.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder participantRecordingHlsConfiguration(software.amazon.awscdk.services.ivs.CfnStage.ParticipantRecordingHlsConfigurationProperty participantRecordingHlsConfiguration) {
                this.participantRecordingHlsConfiguration = participantRecordingHlsConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HlsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HlsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HlsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HlsConfigurationProperty {
            private final java.lang.Object participantRecordingHlsConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.participantRecordingHlsConfiguration = software.amazon.jsii.Kernel.get(this, "participantRecordingHlsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.participantRecordingHlsConfiguration = builder.participantRecordingHlsConfiguration;
            }

            @Override
            public final java.lang.Object getParticipantRecordingHlsConfiguration() {
                return this.participantRecordingHlsConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getParticipantRecordingHlsConfiguration() != null) {
                    data.set("participantRecordingHlsConfiguration", om.valueToTree(this.getParticipantRecordingHlsConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ivs.CfnStage.HlsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HlsConfigurationProperty.Jsii$Proxy that = (HlsConfigurationProperty.Jsii$Proxy) o;

                return this.participantRecordingHlsConfiguration != null ? this.participantRecordingHlsConfiguration.equals(that.participantRecordingHlsConfiguration) : that.participantRecordingHlsConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.participantRecordingHlsConfiguration != null ? this.participantRecordingHlsConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Object specifying a configuration of participant HLS recordings for individual participant recording.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ivs.*;
     * ParticipantRecordingHlsConfigurationProperty participantRecordingHlsConfigurationProperty = ParticipantRecordingHlsConfigurationProperty.builder()
     *         .targetSegmentDurationSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-participantrecordinghlsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-participantrecordinghlsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ivs.CfnStage.ParticipantRecordingHlsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ParticipantRecordingHlsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParticipantRecordingHlsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the target duration for recorded segments generated when recording a stage participant.
         * <p>
         * Segments may have durations longer than the specified value when needed to ensure each segment begins with a keyframe. Default: 6.
         * <p>
         * Default: - 6
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-participantrecordinghlsconfiguration.html#cfn-ivs-stage-participantrecordinghlsconfiguration-targetsegmentdurationseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-participantrecordinghlsconfiguration.html#cfn-ivs-stage-participantrecordinghlsconfiguration-targetsegmentdurationseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTargetSegmentDurationSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParticipantRecordingHlsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParticipantRecordingHlsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParticipantRecordingHlsConfigurationProperty> {
            java.lang.Number targetSegmentDurationSeconds;

            /**
             * Sets the value of {@link ParticipantRecordingHlsConfigurationProperty#getTargetSegmentDurationSeconds}
             * @param targetSegmentDurationSeconds Defines the target duration for recorded segments generated when recording a stage participant.
             *                                     Segments may have durations longer than the specified value when needed to ensure each segment begins with a keyframe. Default: 6.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetSegmentDurationSeconds(java.lang.Number targetSegmentDurationSeconds) {
                this.targetSegmentDurationSeconds = targetSegmentDurationSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParticipantRecordingHlsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParticipantRecordingHlsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParticipantRecordingHlsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParticipantRecordingHlsConfigurationProperty {
            private final java.lang.Number targetSegmentDurationSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetSegmentDurationSeconds = software.amazon.jsii.Kernel.get(this, "targetSegmentDurationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetSegmentDurationSeconds = builder.targetSegmentDurationSeconds;
            }

            @Override
            public final java.lang.Number getTargetSegmentDurationSeconds() {
                return this.targetSegmentDurationSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTargetSegmentDurationSeconds() != null) {
                    data.set("targetSegmentDurationSeconds", om.valueToTree(this.getTargetSegmentDurationSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ivs.CfnStage.ParticipantRecordingHlsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParticipantRecordingHlsConfigurationProperty.Jsii$Proxy that = (ParticipantRecordingHlsConfigurationProperty.Jsii$Proxy) o;

                return this.targetSegmentDurationSeconds != null ? this.targetSegmentDurationSeconds.equals(that.targetSegmentDurationSeconds) : that.targetSegmentDurationSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetSegmentDurationSeconds != null ? this.targetSegmentDurationSeconds.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Object specifying a configuration of thumbnails for recorded video from an individual participant.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ivs.*;
     * ParticipantThumbnailConfigurationProperty participantThumbnailConfigurationProperty = ParticipantThumbnailConfigurationProperty.builder()
     *         .recordingMode("recordingMode")
     *         .storage(List.of("storage"))
     *         .targetIntervalSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-participantthumbnailconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-participantthumbnailconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ivs.CfnStage.ParticipantThumbnailConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ParticipantThumbnailConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParticipantThumbnailConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Thumbnail recording mode.
         * <p>
         * Default: <code>DISABLED</code> .
         * <p>
         * Default: - "DISABLED"
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-participantthumbnailconfiguration.html#cfn-ivs-stage-participantthumbnailconfiguration-recordingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-participantthumbnailconfiguration.html#cfn-ivs-stage-participantthumbnailconfiguration-recordingmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRecordingMode() {
            return null;
        }

        /**
         * Indicates the format in which thumbnails are recorded.
         * <p>
         * <code>SEQUENTIAL</code> records all generated thumbnails in a serial manner, to the media/thumbnails/high directory. <code>LATEST</code> saves the latest thumbnail in media/latest_thumbnail/high/thumb.jpg and overwrites it at the interval specified by <code>targetIntervalSeconds</code> . You can enable both <code>SEQUENTIAL</code> and <code>LATEST</code> . Default: <code>SEQUENTIAL</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-participantthumbnailconfiguration.html#cfn-ivs-stage-participantthumbnailconfiguration-storage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-participantthumbnailconfiguration.html#cfn-ivs-stage-participantthumbnailconfiguration-storage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStorage() {
            return null;
        }

        /**
         * The targeted thumbnail-generation interval in seconds.
         * <p>
         * This is configurable only if <code>recordingMode</code> is <code>INTERVAL</code> . Default: 60.
         * <p>
         * Default: - 60
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-participantthumbnailconfiguration.html#cfn-ivs-stage-participantthumbnailconfiguration-targetintervalseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-participantthumbnailconfiguration.html#cfn-ivs-stage-participantthumbnailconfiguration-targetintervalseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTargetIntervalSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParticipantThumbnailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParticipantThumbnailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParticipantThumbnailConfigurationProperty> {
            java.lang.String recordingMode;
            java.util.List<java.lang.String> storage;
            java.lang.Number targetIntervalSeconds;

            /**
             * Sets the value of {@link ParticipantThumbnailConfigurationProperty#getRecordingMode}
             * @param recordingMode Thumbnail recording mode.
             *                      Default: <code>DISABLED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordingMode(java.lang.String recordingMode) {
                this.recordingMode = recordingMode;
                return this;
            }

            /**
             * Sets the value of {@link ParticipantThumbnailConfigurationProperty#getStorage}
             * @param storage Indicates the format in which thumbnails are recorded.
             *                <code>SEQUENTIAL</code> records all generated thumbnails in a serial manner, to the media/thumbnails/high directory. <code>LATEST</code> saves the latest thumbnail in media/latest_thumbnail/high/thumb.jpg and overwrites it at the interval specified by <code>targetIntervalSeconds</code> . You can enable both <code>SEQUENTIAL</code> and <code>LATEST</code> . Default: <code>SEQUENTIAL</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storage(java.util.List<java.lang.String> storage) {
                this.storage = storage;
                return this;
            }

            /**
             * Sets the value of {@link ParticipantThumbnailConfigurationProperty#getTargetIntervalSeconds}
             * @param targetIntervalSeconds The targeted thumbnail-generation interval in seconds.
             *                              This is configurable only if <code>recordingMode</code> is <code>INTERVAL</code> . Default: 60.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetIntervalSeconds(java.lang.Number targetIntervalSeconds) {
                this.targetIntervalSeconds = targetIntervalSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParticipantThumbnailConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParticipantThumbnailConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParticipantThumbnailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParticipantThumbnailConfigurationProperty {
            private final java.lang.String recordingMode;
            private final java.util.List<java.lang.String> storage;
            private final java.lang.Number targetIntervalSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recordingMode = software.amazon.jsii.Kernel.get(this, "recordingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.storage = software.amazon.jsii.Kernel.get(this, "storage", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.targetIntervalSeconds = software.amazon.jsii.Kernel.get(this, "targetIntervalSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recordingMode = builder.recordingMode;
                this.storage = builder.storage;
                this.targetIntervalSeconds = builder.targetIntervalSeconds;
            }

            @Override
            public final java.lang.String getRecordingMode() {
                return this.recordingMode;
            }

            @Override
            public final java.util.List<java.lang.String> getStorage() {
                return this.storage;
            }

            @Override
            public final java.lang.Number getTargetIntervalSeconds() {
                return this.targetIntervalSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRecordingMode() != null) {
                    data.set("recordingMode", om.valueToTree(this.getRecordingMode()));
                }
                if (this.getStorage() != null) {
                    data.set("storage", om.valueToTree(this.getStorage()));
                }
                if (this.getTargetIntervalSeconds() != null) {
                    data.set("targetIntervalSeconds", om.valueToTree(this.getTargetIntervalSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ivs.CfnStage.ParticipantThumbnailConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParticipantThumbnailConfigurationProperty.Jsii$Proxy that = (ParticipantThumbnailConfigurationProperty.Jsii$Proxy) o;

                if (this.recordingMode != null ? !this.recordingMode.equals(that.recordingMode) : that.recordingMode != null) return false;
                if (this.storage != null ? !this.storage.equals(that.storage) : that.storage != null) return false;
                return this.targetIntervalSeconds != null ? this.targetIntervalSeconds.equals(that.targetIntervalSeconds) : that.targetIntervalSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.recordingMode != null ? this.recordingMode.hashCode() : 0;
                result = 31 * result + (this.storage != null ? this.storage.hashCode() : 0);
                result = 31 * result + (this.targetIntervalSeconds != null ? this.targetIntervalSeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object representing a configuration of thumbnails for recorded video.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ivs.*;
     * ThumbnailConfigurationProperty thumbnailConfigurationProperty = ThumbnailConfigurationProperty.builder()
     *         .participantThumbnailConfiguration(ParticipantThumbnailConfigurationProperty.builder()
     *                 .recordingMode("recordingMode")
     *                 .storage(List.of("storage"))
     *                 .targetIntervalSeconds(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-thumbnailconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-thumbnailconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ivs.CfnStage.ThumbnailConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ThumbnailConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ThumbnailConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Object specifying a configuration of thumbnails for recorded video from an individual participant.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ivs.CfnStage.ParticipantThumbnailConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-thumbnailconfiguration.html#cfn-ivs-stage-thumbnailconfiguration-participantthumbnailconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-thumbnailconfiguration.html#cfn-ivs-stage-thumbnailconfiguration-participantthumbnailconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParticipantThumbnailConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ThumbnailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ThumbnailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ThumbnailConfigurationProperty> {
            java.lang.Object participantThumbnailConfiguration;

            /**
             * Sets the value of {@link ThumbnailConfigurationProperty#getParticipantThumbnailConfiguration}
             * @param participantThumbnailConfiguration Object specifying a configuration of thumbnails for recorded video from an individual participant.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder participantThumbnailConfiguration(software.amazon.awscdk.IResolvable participantThumbnailConfiguration) {
                this.participantThumbnailConfiguration = participantThumbnailConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ThumbnailConfigurationProperty#getParticipantThumbnailConfiguration}
             * @param participantThumbnailConfiguration Object specifying a configuration of thumbnails for recorded video from an individual participant.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder participantThumbnailConfiguration(software.amazon.awscdk.services.ivs.CfnStage.ParticipantThumbnailConfigurationProperty participantThumbnailConfiguration) {
                this.participantThumbnailConfiguration = participantThumbnailConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ThumbnailConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ThumbnailConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ThumbnailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ThumbnailConfigurationProperty {
            private final java.lang.Object participantThumbnailConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.participantThumbnailConfiguration = software.amazon.jsii.Kernel.get(this, "participantThumbnailConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.participantThumbnailConfiguration = builder.participantThumbnailConfiguration;
            }

            @Override
            public final java.lang.Object getParticipantThumbnailConfiguration() {
                return this.participantThumbnailConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getParticipantThumbnailConfiguration() != null) {
                    data.set("participantThumbnailConfiguration", om.valueToTree(this.getParticipantThumbnailConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ivs.CfnStage.ThumbnailConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ThumbnailConfigurationProperty.Jsii$Proxy that = (ThumbnailConfigurationProperty.Jsii$Proxy) o;

                return this.participantThumbnailConfiguration != null ? this.participantThumbnailConfiguration.equals(that.participantThumbnailConfiguration) : that.participantThumbnailConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.participantThumbnailConfiguration != null ? this.participantThumbnailConfiguration.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ivs.CfnStage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ivs.CfnStage> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ivs.CfnStageProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Configuration object for individual participant recording.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-stage.html#cfn-ivs-stage-autoparticipantrecordingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-stage.html#cfn-ivs-stage-autoparticipantrecordingconfiguration</a>
         * @param autoParticipantRecordingConfiguration Configuration object for individual participant recording. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoParticipantRecordingConfiguration(final software.amazon.awscdk.IResolvable autoParticipantRecordingConfiguration) {
            this.props().autoParticipantRecordingConfiguration(autoParticipantRecordingConfiguration);
            return this;
        }
        /**
         * Configuration object for individual participant recording.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-stage.html#cfn-ivs-stage-autoparticipantrecordingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-stage.html#cfn-ivs-stage-autoparticipantrecordingconfiguration</a>
         * @param autoParticipantRecordingConfiguration Configuration object for individual participant recording. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoParticipantRecordingConfiguration(final software.amazon.awscdk.services.ivs.CfnStage.AutoParticipantRecordingConfigurationProperty autoParticipantRecordingConfiguration) {
            this.props().autoParticipantRecordingConfiguration(autoParticipantRecordingConfiguration);
            return this;
        }

        /**
         * Stage name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-stage.html#cfn-ivs-stage-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-stage.html#cfn-ivs-stage-name</a>
         * @param name Stage name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-stage-tag.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-stage.html#cfn-ivs-stage-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-stage.html#cfn-ivs-stage-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ivs.CfnStage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ivs.CfnStage build() {
            return new software.amazon.awscdk.services.ivs.CfnStage(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ivs.CfnStageProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ivs.CfnStageProps.Builder();
            }
            return this.props;
        }
    }
}
