package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Options for CloudWatchLogProcessor.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * S3Bucket s3Destination = S3Bucket.Builder.create(bucket)
 *         .processors(List.of(
 *             new DecompressionProcessor(),
 *             CloudWatchLogProcessor.Builder.create().dataMessageExtraction(true).build()))
 *         .build();
 * DeliveryStream.Builder.create(this, "Delivery Stream")
 *         .destination(s3Destination)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:54.636Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CloudWatchLogProcessorOptions")
@software.amazon.jsii.Jsii.Proxy(CloudWatchLogProcessorOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CloudWatchLogProcessorOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Extract message from CloudWatch logs.
     * <p>
     * This must be true.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getDataMessageExtraction();

    /**
     * @return a {@link Builder} of {@link CloudWatchLogProcessorOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CloudWatchLogProcessorOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CloudWatchLogProcessorOptions> {
        java.lang.Boolean dataMessageExtraction;

        /**
         * Sets the value of {@link CloudWatchLogProcessorOptions#getDataMessageExtraction}
         * @param dataMessageExtraction Extract message from CloudWatch logs. This parameter is required.
         *                              This must be true.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataMessageExtraction(java.lang.Boolean dataMessageExtraction) {
            this.dataMessageExtraction = dataMessageExtraction;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CloudWatchLogProcessorOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CloudWatchLogProcessorOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CloudWatchLogProcessorOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchLogProcessorOptions {
        private final java.lang.Boolean dataMessageExtraction;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataMessageExtraction = software.amazon.jsii.Kernel.get(this, "dataMessageExtraction", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataMessageExtraction = java.util.Objects.requireNonNull(builder.dataMessageExtraction, "dataMessageExtraction is required");
        }

        @Override
        public final java.lang.Boolean getDataMessageExtraction() {
            return this.dataMessageExtraction;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dataMessageExtraction", om.valueToTree(this.getDataMessageExtraction()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CloudWatchLogProcessorOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CloudWatchLogProcessorOptions.Jsii$Proxy that = (CloudWatchLogProcessorOptions.Jsii$Proxy) o;

            return this.dataMessageExtraction.equals(that.dataMessageExtraction);
        }

        @Override
        public final int hashCode() {
            int result = this.dataMessageExtraction.hashCode();
            return result;
        }
    }
}
