package software.amazon.awscdk.services.kinesisfirehose;

/**
 * This class specifies properties for Hive JSON input format for record format conversion.
 * <p>
 * You should only need to specify an instance of this class if the default configuration does not suit your needs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * HiveJsonInputFormat inputFormat = HiveJsonInputFormat.Builder.create()
 *         .timestampParsers(List.of(TimestampParser.fromFormatString("yyyy-MM-dd"), TimestampParser.EPOCH_MILLIS))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:54.646Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.HiveJsonInputFormat")
public class HiveJsonInputFormat extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisfirehose.IInputFormat {

    protected HiveJsonInputFormat(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HiveJsonInputFormat(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HiveJsonInputFormat(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.HiveJsonInputFormatProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HiveJsonInputFormat() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Renders the cloudformation properties for the input format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.InputFormatConfigurationProperty createInputFormatConfig() {
        return software.amazon.jsii.Kernel.call(this, "createInputFormatConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.InputFormatConfigurationProperty.class));
    }

    /**
     * Properties for Hive JSON input format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.HiveJsonInputFormatProps getProps() {
        return software.amazon.jsii.Kernel.get(this, "props", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.HiveJsonInputFormatProps.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kinesisfirehose.HiveJsonInputFormat}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kinesisfirehose.HiveJsonInputFormat> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.kinesisfirehose.HiveJsonInputFormatProps.Builder props;

        private Builder() {
        }

        /**
         * List of TimestampParsers.
         * <p>
         * These are used to parse custom timestamp strings from input JSON into dates.
         * <p>
         * Note: Specifying a parser will override the default timestamp parser. If the default timestamp parser is required,
         * include <code>TimestampParser.DEFAULT</code> in the list of parsers along with the custom parser.
         * <p>
         * Default: the default timestamp parser is used
         * <p>
         * @return {@code this}
         * @param timestampParsers List of TimestampParsers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timestampParsers(final java.util.List<? extends software.amazon.awscdk.services.kinesisfirehose.TimestampParser> timestampParsers) {
            this.props().timestampParsers(timestampParsers);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.kinesisfirehose.HiveJsonInputFormat}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kinesisfirehose.HiveJsonInputFormat build() {
            return new software.amazon.awscdk.services.kinesisfirehose.HiveJsonInputFormat(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.kinesisfirehose.HiveJsonInputFormatProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.kinesisfirehose.HiveJsonInputFormatProps.Builder();
            }
            return this.props;
        }
    }
}
