package software.amazon.awscdk.services.kinesisfirehose;

/**
 * This class specifies properties for OpenX JSON input format for record format conversion.
 * <p>
 * You should only need to specify an instance of this class if the default configuration does not suit your needs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * OpenXJsonInputFormat inputFormat = OpenXJsonInputFormat.Builder.create()
 *         .lowercaseColumnNames(false)
 *         .columnToJsonKeyMappings(Map.of("ts", "timestamp"))
 *         .convertDotsInJsonKeysToUnderscores(true)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:54.651Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.OpenXJsonInputFormat")
public class OpenXJsonInputFormat extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisfirehose.IInputFormat {

    protected OpenXJsonInputFormat(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected OpenXJsonInputFormat(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public OpenXJsonInputFormat(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.OpenXJsonInputFormatProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public OpenXJsonInputFormat() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Renders the cloudformation properties for the input format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.InputFormatConfigurationProperty createInputFormatConfig() {
        return software.amazon.jsii.Kernel.call(this, "createInputFormatConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.InputFormatConfigurationProperty.class));
    }

    /**
     * Properties for OpenX JSON input format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.OpenXJsonInputFormatProps getProps() {
        return software.amazon.jsii.Kernel.get(this, "props", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.OpenXJsonInputFormatProps.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kinesisfirehose.OpenXJsonInputFormat}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kinesisfirehose.OpenXJsonInputFormat> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.kinesisfirehose.OpenXJsonInputFormatProps.Builder props;

        private Builder() {
        }

        /**
         * Maps column names to JSON keys that aren't identical to the column names.
         * <p>
         * This is useful when the JSON contains keys that are Hive keywords.
         * For example, <code>timestamp</code> is a Hive keyword. If you have a JSON key named <code>timestamp</code>, set this parameter to <code>{"ts": "timestamp"}</code> to map this key to a column named <code>ts</code>
         * <p>
         * Default: JSON keys are not renamed
         * <p>
         * @return {@code this}
         * @param columnToJsonKeyMappings Maps column names to JSON keys that aren't identical to the column names. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder columnToJsonKeyMappings(final java.util.Map<java.lang.String, java.lang.String> columnToJsonKeyMappings) {
            this.props().columnToJsonKeyMappings(columnToJsonKeyMappings);
            return this;
        }

        /**
         * When set to <code>true</code>, specifies that the names of the keys include dots and that you want Firehose to replace them with underscores.
         * <p>
         * This is useful because Apache Hive does not allow dots in column names.
         * For example, if the JSON contains a key whose name is "a.b", you can define the column name to be "a_b" when using this option.
         * <p>
         * Default: `false`
         * <p>
         * @return {@code this}
         * @param convertDotsInJsonKeysToUnderscores When set to <code>true</code>, specifies that the names of the keys include dots and that you want Firehose to replace them with underscores. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder convertDotsInJsonKeysToUnderscores(final java.lang.Boolean convertDotsInJsonKeysToUnderscores) {
            this.props().convertDotsInJsonKeysToUnderscores(convertDotsInJsonKeysToUnderscores);
            return this;
        }

        /**
         * Whether the JSON keys should be lowercased when written as column names.
         * <p>
         * Default: `true`
         * <p>
         * @return {@code this}
         * @param lowercaseColumnNames Whether the JSON keys should be lowercased when written as column names. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lowercaseColumnNames(final java.lang.Boolean lowercaseColumnNames) {
            this.props().lowercaseColumnNames(lowercaseColumnNames);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.kinesisfirehose.OpenXJsonInputFormat}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kinesisfirehose.OpenXJsonInputFormat build() {
            return new software.amazon.awscdk.services.kinesisfirehose.OpenXJsonInputFormat(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.kinesisfirehose.OpenXJsonInputFormatProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.kinesisfirehose.OpenXJsonInputFormatProps.Builder();
            }
            return this.props;
        }
    }
}
