package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Possible compression options available for ORC OutputFormat.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * OrcOutputFormat outputFormat = OrcOutputFormat.Builder.create()
 *         .formatVersion(OrcFormatVersion.V0_11)
 *         .blockSize(Size.mebibytes(256))
 *         .compression(OrcCompression.NONE)
 *         .bloomFilterColumns(List.of("columnA"))
 *         .bloomFilterFalsePositiveProbability(0.1)
 *         .dictionaryKeyThreshold(0.7)
 *         .enablePadding(true)
 *         .paddingTolerance(0.2)
 *         .rowIndexStride(9000)
 *         .stripeSize(Size.mebibytes(32))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-compression">https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-compression</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:54.652Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.OrcCompression")
public class OrcCompression extends software.amazon.jsii.JsiiObject {

    protected OrcCompression(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected OrcCompression(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        NONE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisfirehose.OrcCompression.class, "NONE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.OrcCompression.class));
        SNAPPY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisfirehose.OrcCompression.class, "SNAPPY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.OrcCompression.class));
        ZLIB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisfirehose.OrcCompression.class, "ZLIB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.OrcCompression.class));
    }

    /**
     * Creates a new OrcCompression instance with a custom value.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.OrcCompression of(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesisfirehose.OrcCompression.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.OrcCompression.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Uncompressed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.kinesisfirehose.OrcCompression NONE;

    /**
     * Snappy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.kinesisfirehose.OrcCompression SNAPPY;

    /**
     * Gzip.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.kinesisfirehose.OrcCompression ZLIB;

    /**
     * the string value of the Serde Compression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
