package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Represents possible output formats when performing record data conversion.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * CfnTable schemaGlueTable;
 * S3Bucket s3Destination = S3Bucket.Builder.create(bucket)
 *         .dataFormatConversion(DataFormatConversionProps.builder()
 *                 .schemaConfiguration(SchemaConfiguration.fromCfnTable(schemaGlueTable))
 *                 .inputFormat(InputFormat.OPENX_JSON)
 *                 .outputFormat(OutputFormat.PARQUET)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:54.669Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.OutputFormat")
public class OutputFormat extends software.amazon.jsii.JsiiObject {

    protected OutputFormat(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected OutputFormat(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ORC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisfirehose.OutputFormat.class, "ORC", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.OrcOutputFormat.class));
        PARQUET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisfirehose.OutputFormat.class, "PARQUET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.ParquetOutputFormat.class));
    }

    /**
     * Write output files in ORC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.kinesisfirehose.OrcOutputFormat ORC;

    /**
     * Write output files in Parquet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.kinesisfirehose.ParquetOutputFormat PARQUET;
}
