package software.amazon.awscdk.services.kinesisfirehose;

/**
 * An S3 bucket destination for data from an Amazon Data Firehose delivery stream.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * Bucket bucket = new Bucket(this, "MyBucket");
 * DeliveryStream stream = DeliveryStream.Builder.create(this, "MyStream")
 *         .destination(new S3Bucket(bucket))
 *         .build();
 * TopicRule topicRule = TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT * FROM 'device/+/data'"))
 *         .actions(List.of(
 *             FirehosePutRecordAction.Builder.create(stream)
 *                     .batchMode(true)
 *                     .recordSeparator(FirehoseRecordSeparator.NEWLINE)
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:54.671Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.S3Bucket")
public class S3Bucket extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisfirehose.IDestination {

    protected S3Bucket(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3Bucket(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param bucket This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public S3Bucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.S3BucketProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), props });
    }

    /**
     * @param bucket This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public S3Bucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required") });
    }

    /**
     * Binds this destination to the Amazon Data Firehose delivery stream.
     * <p>
     * Implementers should use this method to bind resources to the stack and initialize values using the provided stream.
     * <p>
     * @param scope This parameter is required.
     * @param _options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.DestinationConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.DestinationBindOptions _options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.DestinationConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(_options, "_options is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kinesisfirehose.S3Bucket}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kinesisfirehose.S3Bucket> {
        /**
         * @return a new instance of {@link Builder}.
         * @param bucket This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.s3.IBucket bucket) {
            return new Builder(bucket);
        }

        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private software.amazon.awscdk.services.kinesisfirehose.S3BucketProps.Builder props;

        private Builder(final software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
        }

        /**
         * The length of time that Firehose buffers incoming data before delivering it to the S3 bucket.
         * <p>
         * Minimum: Duration.seconds(0)
         * Maximum: Duration.seconds(900)
         * <p>
         * Default: Duration.seconds(300)
         * <p>
         * @return {@code this}
         * @param bufferingInterval The length of time that Firehose buffers incoming data before delivering it to the S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bufferingInterval(final software.amazon.awscdk.Duration bufferingInterval) {
            this.props().bufferingInterval(bufferingInterval);
            return this;
        }

        /**
         * The size of the buffer that Amazon Data Firehose uses for incoming data before delivering it to the S3 bucket.
         * <p>
         * Minimum: Size.mebibytes(1) when record data format conversion is disabled, Size.mebibytes(64) when it is enabled
         * Maximum: Size.mebibytes(128)
         * <p>
         * Default: Size.mebibytes(5) when record data format conversion is disabled, Size.mebibytes(128) when it is enabled
         * <p>
         * @return {@code this}
         * @param bufferingSize The size of the buffer that Amazon Data Firehose uses for incoming data before delivering it to the S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bufferingSize(final software.amazon.awscdk.Size bufferingSize) {
            this.props().bufferingSize(bufferingSize);
            return this;
        }

        /**
         * The type of compression that Amazon Data Firehose uses to compress the data that it delivers to the Amazon S3 bucket.
         * <p>
         * The compression formats SNAPPY or ZIP cannot be specified for Amazon Redshift
         * destinations because they are not supported by the Amazon Redshift COPY operation
         * that reads from the S3 bucket.
         * <p>
         * Default: - UNCOMPRESSED
         * <p>
         * @return {@code this}
         * @param compression The type of compression that Amazon Data Firehose uses to compress the data that it delivers to the Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compression(final software.amazon.awscdk.services.kinesisfirehose.Compression compression) {
            this.props().compression(compression);
            return this;
        }

        /**
         * A prefix that Amazon Data Firehose evaluates and adds to records before writing them to S3.
         * <p>
         * This prefix appears immediately following the bucket name.
         * <p>
         * Default: "YYYY/MM/DD/HH"
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html</a>
         * @param dataOutputPrefix A prefix that Amazon Data Firehose evaluates and adds to records before writing them to S3. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataOutputPrefix(final java.lang.String dataOutputPrefix) {
            this.props().dataOutputPrefix(dataOutputPrefix);
            return this;
        }

        /**
         * The AWS KMS key used to encrypt the data that it delivers to your Amazon S3 bucket.
         * <p>
         * Default: - Data is not encrypted.
         * <p>
         * @return {@code this}
         * @param encryptionKey The AWS KMS key used to encrypt the data that it delivers to your Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        /**
         * A prefix that Amazon Data Firehose evaluates and adds to failed records before writing them to S3.
         * <p>
         * This prefix appears immediately following the bucket name.
         * <p>
         * Default: "YYYY/MM/DD/HH"
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html</a>
         * @param errorOutputPrefix A prefix that Amazon Data Firehose evaluates and adds to failed records before writing them to S3. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder errorOutputPrefix(final java.lang.String errorOutputPrefix) {
            this.props().errorOutputPrefix(errorOutputPrefix);
            return this;
        }

        /**
         * Configuration that determines whether to log errors during data transformation or delivery failures, and specifies the CloudWatch log group for storing error logs.
         * <p>
         * Default: - errors will be logged and a log group will be created for you.
         * <p>
         * @return {@code this}
         * @param loggingConfig Configuration that determines whether to log errors during data transformation or delivery failures, and specifies the CloudWatch log group for storing error logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfig(final software.amazon.awscdk.services.kinesisfirehose.ILoggingConfig loggingConfig) {
            this.props().loggingConfig(loggingConfig);
            return this;
        }

        /**
         * (deprecated) The data transformation that should be performed on the data before writing to the destination.
         * <p>
         * Default: - no data transformation will occur.
         * <p>
         * @return {@code this}
         * @deprecated Use <code>processors</code> instead.
         * @param processor The data transformation that should be performed on the data before writing to the destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder processor(final software.amazon.awscdk.services.kinesisfirehose.IDataProcessor processor) {
            this.props().processor(processor);
            return this;
        }

        /**
         * The data transformation that should be performed on the data before writing to the destination.
         * <p>
         * Default: - no data transformation will occur.
         * <p>
         * @return {@code this}
         * @param processors The data transformation that should be performed on the data before writing to the destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processors(final java.util.List<? extends software.amazon.awscdk.services.kinesisfirehose.IDataProcessor> processors) {
            this.props().processors(processors);
            return this;
        }

        /**
         * The IAM role associated with this destination.
         * <p>
         * Assumed by Amazon Data Firehose to invoke processors and write to destinations
         * <p>
         * Default: - a role will be created with default permissions.
         * <p>
         * @return {@code this}
         * @param role The IAM role associated with this destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props().role(role);
            return this;
        }

        /**
         * The configuration for backing up source records to S3.
         * <p>
         * Default: - source records will not be backed up to S3.
         * <p>
         * @return {@code this}
         * @param s3Backup The configuration for backing up source records to S3. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Backup(final software.amazon.awscdk.services.kinesisfirehose.DestinationS3BackupProps s3Backup) {
            this.props().s3Backup(s3Backup);
            return this;
        }

        /**
         * The input format, output format, and schema config for converting data from the JSON format to the Parquet or ORC format before writing to Amazon S3.
         * <p>
         * Default: no data format conversion is done
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-dataformatconversionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-dataformatconversionconfiguration</a>
         * @param dataFormatConversion The input format, output format, and schema config for converting data from the JSON format to the Parquet or ORC format before writing to Amazon S3. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataFormatConversion(final software.amazon.awscdk.services.kinesisfirehose.DataFormatConversionProps dataFormatConversion) {
            this.props().dataFormatConversion(dataFormatConversion);
            return this;
        }

        /**
         * Specify a file extension.
         * <p>
         * It will override the default file extension appended by Data Format Conversion or S3 compression features such as <code>.parquet</code> or <code>.gz</code>.
         * <p>
         * File extension must start with a period (<code>.</code>) and can contain allowed characters: <code>0-9a-z!-_.*'()</code>.
         * <p>
         * Default: - The default file extension appended by Data Format Conversion or S3 compression features
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/firehose/latest/dev/create-destination.html#create-destination-s3">https://docs.aws.amazon.com/firehose/latest/dev/create-destination.html#create-destination-s3</a>
         * @param fileExtension Specify a file extension. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileExtension(final java.lang.String fileExtension) {
            this.props().fileExtension(fileExtension);
            return this;
        }

        /**
         * The time zone you prefer.
         * <p>
         * Default: - UTC
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html#timestamp-namespace">https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html#timestamp-namespace</a>
         * @param timeZone The time zone you prefer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeZone(final software.amazon.awscdk.TimeZone timeZone) {
            this.props().timeZone(timeZone);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.kinesisfirehose.S3Bucket}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kinesisfirehose.S3Bucket build() {
            return new software.amazon.awscdk.services.kinesisfirehose.S3Bucket(
                this.bucket,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.kinesisfirehose.S3BucketProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.kinesisfirehose.S3BucketProps.Builder();
            }
            return this.props;
        }
    }
}
