package software.amazon.awscdk.services.lambda;

/**
 * Properties for defining a <code>CfnPermission</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * CfnPermissionProps cfnPermissionProps = CfnPermissionProps.builder()
 *         .action("action")
 *         .functionName("functionName")
 *         .principal("principal")
 *         // the properties below are optional
 *         .eventSourceToken("eventSourceToken")
 *         .functionUrlAuthType("functionUrlAuthType")
 *         .invokedViaFunctionUrl(false)
 *         .principalOrgId("principalOrgId")
 *         .sourceAccount("sourceAccount")
 *         .sourceArn("sourceArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:54.868Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CfnPermissionProps")
@software.amazon.jsii.Jsii.Proxy(CfnPermissionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPermissionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The action that the principal can use on the function.
     * <p>
     * For example, <code>lambda:InvokeFunction</code> or <code>lambda:GetFunction</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-action</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAction();

    /**
     * The name or ARN of the Lambda function, version, or alias.
     * <p>
     * <strong>Name formats</strong> - <em>Function name</em> – <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).
     * <p>
     * <ul>
     * <li><em>Function ARN</em> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code> .</li>
     * <li><em>Partial ARN</em> – <code>123456789012:function:my-function</code> .</li>
     * </ul>
     * <p>
     * You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-functionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-functionname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFunctionName();

    /**
     * The AWS service , AWS account , IAM user, or IAM role that invokes the function.
     * <p>
     * If you specify a service, use <code>SourceArn</code> or <code>SourceAccount</code> to limit who can invoke the function through that service.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-principal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-principal</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrincipal();

    /**
     * For Alexa Smart Home functions, a token that the invoker must supply.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-eventsourcetoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-eventsourcetoken</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEventSourceToken() {
        return null;
    }

    /**
     * The type of authentication that your function URL uses.
     * <p>
     * Set to <code>AWS_IAM</code> if you want to restrict access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Control access to Lambda function URLs</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-functionurlauthtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-functionurlauthtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFunctionUrlAuthType() {
        return null;
    }

    /**
     * Restricts the <code>lambda:InvokeFunction</code> action to function URL calls.
     * <p>
     * When specified, this option prevents the principal from invoking the function by any means other than the function URL. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Control access to Lambda function URLs</a> .
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-invokedviafunctionurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-invokedviafunctionurl</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInvokedViaFunctionUrl() {
        return null;
    }

    /**
     * The identifier for your organization in AWS Organizations .
     * <p>
     * Use this to grant permissions to all the AWS accounts under this organization.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-principalorgid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-principalorgid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrincipalOrgId() {
        return null;
    }

    /**
     * For AWS service , the ID of the AWS account that owns the resource.
     * <p>
     * Use this together with <code>SourceArn</code> to ensure that the specified account owns the resource. It is possible for an Amazon S3 bucket to be deleted by its owner and recreated by another account.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-sourceaccount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-sourceaccount</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceAccount() {
        return null;
    }

    /**
     * For AWS services , the ARN of the AWS resource that invokes the function.
     * <p>
     * For example, an Amazon S3 bucket or Amazon SNS topic.
     * <p>
     * Note that Lambda configures the comparison using the <code>StringLike</code> operator.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-sourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-sourcearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPermissionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPermissionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPermissionProps> {
        java.lang.String action;
        java.lang.String functionName;
        java.lang.String principal;
        java.lang.String eventSourceToken;
        java.lang.String functionUrlAuthType;
        java.lang.Object invokedViaFunctionUrl;
        java.lang.String principalOrgId;
        java.lang.String sourceAccount;
        java.lang.String sourceArn;

        /**
         * Sets the value of {@link CfnPermissionProps#getAction}
         * @param action The action that the principal can use on the function. This parameter is required.
         *               For example, <code>lambda:InvokeFunction</code> or <code>lambda:GetFunction</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(java.lang.String action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionProps#getFunctionName}
         * @param functionName The name or ARN of the Lambda function, version, or alias. This parameter is required.
         *                     <strong>Name formats</strong> - <em>Function name</em> – <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).
         *                     <p>
         *                     <ul>
         *                     <li><em>Function ARN</em> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code> .</li>
         *                     <li><em>Partial ARN</em> – <code>123456789012:function:my-function</code> .</li>
         *                     </ul>
         *                     <p>
         *                     You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(java.lang.String functionName) {
            this.functionName = functionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionProps#getPrincipal}
         * @param principal The AWS service , AWS account , IAM user, or IAM role that invokes the function. This parameter is required.
         *                  If you specify a service, use <code>SourceArn</code> or <code>SourceAccount</code> to limit who can invoke the function through that service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principal(java.lang.String principal) {
            this.principal = principal;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionProps#getEventSourceToken}
         * @param eventSourceToken For Alexa Smart Home functions, a token that the invoker must supply.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSourceToken(java.lang.String eventSourceToken) {
            this.eventSourceToken = eventSourceToken;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionProps#getFunctionUrlAuthType}
         * @param functionUrlAuthType The type of authentication that your function URL uses.
         *                            Set to <code>AWS_IAM</code> if you want to restrict access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Control access to Lambda function URLs</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionUrlAuthType(java.lang.String functionUrlAuthType) {
            this.functionUrlAuthType = functionUrlAuthType;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionProps#getInvokedViaFunctionUrl}
         * @param invokedViaFunctionUrl Restricts the <code>lambda:InvokeFunction</code> action to function URL calls.
         *                              When specified, this option prevents the principal from invoking the function by any means other than the function URL. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Control access to Lambda function URLs</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invokedViaFunctionUrl(java.lang.Boolean invokedViaFunctionUrl) {
            this.invokedViaFunctionUrl = invokedViaFunctionUrl;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionProps#getInvokedViaFunctionUrl}
         * @param invokedViaFunctionUrl Restricts the <code>lambda:InvokeFunction</code> action to function URL calls.
         *                              When specified, this option prevents the principal from invoking the function by any means other than the function URL. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Control access to Lambda function URLs</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invokedViaFunctionUrl(software.amazon.awscdk.IResolvable invokedViaFunctionUrl) {
            this.invokedViaFunctionUrl = invokedViaFunctionUrl;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionProps#getPrincipalOrgId}
         * @param principalOrgId The identifier for your organization in AWS Organizations .
         *                       Use this to grant permissions to all the AWS accounts under this organization.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principalOrgId(java.lang.String principalOrgId) {
            this.principalOrgId = principalOrgId;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionProps#getSourceAccount}
         * @param sourceAccount For AWS service , the ID of the AWS account that owns the resource.
         *                      Use this together with <code>SourceArn</code> to ensure that the specified account owns the resource. It is possible for an Amazon S3 bucket to be deleted by its owner and recreated by another account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceAccount(java.lang.String sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionProps#getSourceArn}
         * @param sourceArn For AWS services , the ARN of the AWS resource that invokes the function.
         *                  For example, an Amazon S3 bucket or Amazon SNS topic.
         *                  <p>
         *                  Note that Lambda configures the comparison using the <code>StringLike</code> operator.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceArn(java.lang.String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPermissionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPermissionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPermissionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPermissionProps {
        private final java.lang.String action;
        private final java.lang.String functionName;
        private final java.lang.String principal;
        private final java.lang.String eventSourceToken;
        private final java.lang.String functionUrlAuthType;
        private final java.lang.Object invokedViaFunctionUrl;
        private final java.lang.String principalOrgId;
        private final java.lang.String sourceAccount;
        private final java.lang.String sourceArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.functionName = software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.principal = software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventSourceToken = software.amazon.jsii.Kernel.get(this, "eventSourceToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.functionUrlAuthType = software.amazon.jsii.Kernel.get(this, "functionUrlAuthType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.invokedViaFunctionUrl = software.amazon.jsii.Kernel.get(this, "invokedViaFunctionUrl", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.principalOrgId = software.amazon.jsii.Kernel.get(this, "principalOrgId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceAccount = software.amazon.jsii.Kernel.get(this, "sourceAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceArn = software.amazon.jsii.Kernel.get(this, "sourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
            this.functionName = java.util.Objects.requireNonNull(builder.functionName, "functionName is required");
            this.principal = java.util.Objects.requireNonNull(builder.principal, "principal is required");
            this.eventSourceToken = builder.eventSourceToken;
            this.functionUrlAuthType = builder.functionUrlAuthType;
            this.invokedViaFunctionUrl = builder.invokedViaFunctionUrl;
            this.principalOrgId = builder.principalOrgId;
            this.sourceAccount = builder.sourceAccount;
            this.sourceArn = builder.sourceArn;
        }

        @Override
        public final java.lang.String getAction() {
            return this.action;
        }

        @Override
        public final java.lang.String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final java.lang.String getPrincipal() {
            return this.principal;
        }

        @Override
        public final java.lang.String getEventSourceToken() {
            return this.eventSourceToken;
        }

        @Override
        public final java.lang.String getFunctionUrlAuthType() {
            return this.functionUrlAuthType;
        }

        @Override
        public final java.lang.Object getInvokedViaFunctionUrl() {
            return this.invokedViaFunctionUrl;
        }

        @Override
        public final java.lang.String getPrincipalOrgId() {
            return this.principalOrgId;
        }

        @Override
        public final java.lang.String getSourceAccount() {
            return this.sourceAccount;
        }

        @Override
        public final java.lang.String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("action", om.valueToTree(this.getAction()));
            data.set("functionName", om.valueToTree(this.getFunctionName()));
            data.set("principal", om.valueToTree(this.getPrincipal()));
            if (this.getEventSourceToken() != null) {
                data.set("eventSourceToken", om.valueToTree(this.getEventSourceToken()));
            }
            if (this.getFunctionUrlAuthType() != null) {
                data.set("functionUrlAuthType", om.valueToTree(this.getFunctionUrlAuthType()));
            }
            if (this.getInvokedViaFunctionUrl() != null) {
                data.set("invokedViaFunctionUrl", om.valueToTree(this.getInvokedViaFunctionUrl()));
            }
            if (this.getPrincipalOrgId() != null) {
                data.set("principalOrgId", om.valueToTree(this.getPrincipalOrgId()));
            }
            if (this.getSourceAccount() != null) {
                data.set("sourceAccount", om.valueToTree(this.getSourceAccount()));
            }
            if (this.getSourceArn() != null) {
                data.set("sourceArn", om.valueToTree(this.getSourceArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.CfnPermissionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPermissionProps.Jsii$Proxy that = (CfnPermissionProps.Jsii$Proxy) o;

            if (!action.equals(that.action)) return false;
            if (!functionName.equals(that.functionName)) return false;
            if (!principal.equals(that.principal)) return false;
            if (this.eventSourceToken != null ? !this.eventSourceToken.equals(that.eventSourceToken) : that.eventSourceToken != null) return false;
            if (this.functionUrlAuthType != null ? !this.functionUrlAuthType.equals(that.functionUrlAuthType) : that.functionUrlAuthType != null) return false;
            if (this.invokedViaFunctionUrl != null ? !this.invokedViaFunctionUrl.equals(that.invokedViaFunctionUrl) : that.invokedViaFunctionUrl != null) return false;
            if (this.principalOrgId != null ? !this.principalOrgId.equals(that.principalOrgId) : that.principalOrgId != null) return false;
            if (this.sourceAccount != null ? !this.sourceAccount.equals(that.sourceAccount) : that.sourceAccount != null) return false;
            return this.sourceArn != null ? this.sourceArn.equals(that.sourceArn) : that.sourceArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.action.hashCode();
            result = 31 * result + (this.functionName.hashCode());
            result = 31 * result + (this.principal.hashCode());
            result = 31 * result + (this.eventSourceToken != null ? this.eventSourceToken.hashCode() : 0);
            result = 31 * result + (this.functionUrlAuthType != null ? this.functionUrlAuthType.hashCode() : 0);
            result = 31 * result + (this.invokedViaFunctionUrl != null ? this.invokedViaFunctionUrl.hashCode() : 0);
            result = 31 * result + (this.principalOrgId != null ? this.principalOrgId.hashCode() : 0);
            result = 31 * result + (this.sourceAccount != null ? this.sourceAccount.hashCode() : 0);
            result = 31 * result + (this.sourceArn != null ? this.sourceArn.hashCode() : 0);
            return result;
        }
    }
}
