package software.amazon.awscdk.services.lambda;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:54.942Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.IFunction")
@software.amazon.jsii.Jsii.Proxy(IFunction.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IFunction extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.IResource, software.amazon.awscdk.services.ec2.IConnectable, software.amazon.awscdk.services.iam.IGrantable, software.amazon.awscdk.interfaces.lambda.IFunctionRef {

    /**
     * The system architectures compatible with this lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Architecture getArchitecture();

    /**
     * The ARN of the function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFunctionArn();

    /**
     * The name of the function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFunctionName();

    /**
     * Whether or not this Lambda function was bound to a VPC.
     * <p>
     * If this is is <code>false</code>, trying to access the <code>connections</code> object will fail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getIsBoundToVpc();

    /**
     * The <code>$LATEST</code> version of this function.
     * <p>
     * Note that this is reference to a non-specific AWS Lambda version, which
     * means the function this version refers to can return different results in
     * different invocations.
     * <p>
     * To obtain a reference to an explicit version which references the current
     * function configuration, use <code>lambdaFunction.currentVersion</code> instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IVersion getLatestVersion();

    /**
     * The construct node where permissions are attached.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.constructs.Node getPermissionsNode();

    /**
     * The ARN(s) to put into the resource field of the generated IAM policy for grantInvoke().
     * <p>
     * This property is for cdk modules to consume only. You should not need to use this property.
     * Instead, use grantInvoke() directly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getResourceArnsForGrantInvoke();

    /**
     * The IAM role associated with this function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * Adds an event source to this function.
     * <p>
     * Event sources are implemented in the aws-cdk-lib/aws-lambda-event-sources module.
     * <p>
     * The following example adds an SQS Queue as an event source:
     * <p>
     * <blockquote><pre>
     * import { SqsEventSource } from 'aws-cdk-lib/aws-lambda-event-sources';
     * myFunction.addEventSource(new SqsEventSource(myQueue));
     * </pre></blockquote>
     * <p>
     * @param source This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addEventSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IEventSource source);

    /**
     * Adds an event source that maps to this AWS Lambda function.
     * <p>
     * @param id construct ID. This parameter is required.
     * @param options mapping options. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.EventSourceMapping addEventSourceMapping(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.EventSourceMappingOptions options);

    /**
     * Adds a url to this lambda function.
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.FunctionUrl addFunctionUrl(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.FunctionUrlOptions options);

    /**
     * Adds a url to this lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.FunctionUrl addFunctionUrl();

    /**
     * Adds a permission to the Lambda resource policy.
     * <p>
     * @see <a href="Permission for details.">Permission for details.</a>
     * @param id The id for the permission construct. This parameter is required.
     * @param permission The permission to grant to this Lambda function. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addPermission(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Permission permission);

    /**
     * Adds a statement to the IAM role assumed by the instance.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addToRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement);

    /**
     * Configures options for asynchronous invocation.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void configureAsyncInvoke(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.EventInvokeConfigOptions options);

    /**
     * Grant the given identity permissions to invoke this Lambda.
     * <p>
     * @param identity This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantInvoke(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity);

    /**
     * Grant multiple principals the ability to invoke this Lambda via CompositePrincipal.
     * <p>
     * @param compositePrincipal This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.iam.Grant> grantInvokeCompositePrincipal(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.CompositePrincipal compositePrincipal);

    /**
     * Grant the given identity permissions to invoke the $LATEST version or unqualified version of this Lambda.
     * <p>
     * @param identity This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantInvokeLatestVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity);

    /**
     * Grant the given identity permissions to invoke this Lambda Function URL.
     * <p>
     * @param identity This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantInvokeUrl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity);

    /**
     * Grant the given identity permissions to invoke the given version of this Lambda.
     * <p>
     * @param identity This parameter is required.
     * @param version This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantInvokeVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IVersion version);

    /**
     * Return the given named metric for this Lambda Return the given named metric for this Function.
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * Return the given named metric for this Lambda Return the given named metric for this Function.
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName);

    /**
     * Metric for the Duration of this Lambda How long execution of this Lambda takes.
     * <p>
     * Average over 5 minutes
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDuration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * Metric for the Duration of this Lambda How long execution of this Lambda takes.
     * <p>
     * Average over 5 minutes
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDuration();

    /**
     * How many invocations of this Lambda fail.
     * <p>
     * Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricErrors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * How many invocations of this Lambda fail.
     * <p>
     * Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricErrors();

    /**
     * Metric for the number of invocations of this Lambda How often this Lambda is invoked.
     * <p>
     * Sum over 5 minutes
     * <p>
     * Default: sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricInvocations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * Metric for the number of invocations of this Lambda How often this Lambda is invoked.
     * <p>
     * Sum over 5 minutes
     * <p>
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricInvocations();

    /**
     * Metric for the number of throttled invocations of this Lambda How often this Lambda is throttled.
     * <p>
     * Sum over 5 minutes
     * <p>
     * Default: sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricThrottles(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * Metric for the number of throttled invocations of this Lambda How often this Lambda is throttled.
     * <p>
     * Sum over 5 minutes
     * <p>
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricThrottles();

    /**
     * The tree node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.constructs.Node getNode();

    /**
     * The environment this resource belongs to.
     * <p>
     * For resources that are created and managed in a Stack (those created by
     * creating new class instances like <code>new Role()</code>, <code>new Bucket()</code>, etc.), this
     * is always the same as the environment of the stack they belong to.
     * <p>
     * For referenced resources (those obtained from referencing methods like
     * <code>Role.fromRoleArn()</code>, <code>Bucket.fromBucketName()</code>, etc.), they might be
     * different than the stack they were imported into.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.ResourceEnvironment getEnv();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.IFunction.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed in a Stack (those created by
         * creating new class instances like <code>new Role()</code>, <code>new Bucket()</code>, etc.), this
         * is always the same as the environment of the stack they belong to.
         * <p>
         * For referenced resources (those obtained from referencing methods like
         * <code>Role.fromRoleArn()</code>, <code>Bucket.fromBucketName()</code>, etc.), they might be
         * different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * The network connections associated with this resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
            return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
        }

        /**
         * The principal to grant permissions to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
            return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
        }

        /**
         * (experimental) A reference to a Function resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.lambda.FunctionReference getFunctionRef() {
            return software.amazon.jsii.Kernel.get(this, "functionRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.lambda.FunctionReference.class));
        }

        /**
         * The system architectures compatible with this lambda function.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Architecture getArchitecture() {
            return software.amazon.jsii.Kernel.get(this, "architecture", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Architecture.class));
        }

        /**
         * The ARN of the function.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getFunctionArn() {
            return software.amazon.jsii.Kernel.get(this, "functionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The name of the function.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getFunctionName() {
            return software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Whether or not this Lambda function was bound to a VPC.
         * <p>
         * If this is is <code>false</code>, trying to access the <code>connections</code> object will fail.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.Boolean getIsBoundToVpc() {
            return software.amazon.jsii.Kernel.get(this, "isBoundToVpc", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * The <code>$LATEST</code> version of this function.
         * <p>
         * Note that this is reference to a non-specific AWS Lambda version, which
         * means the function this version refers to can return different results in
         * different invocations.
         * <p>
         * To obtain a reference to an explicit version which references the current
         * function configuration, use <code>lambdaFunction.currentVersion</code> instead.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IVersion getLatestVersion() {
            return software.amazon.jsii.Kernel.get(this, "latestVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IVersion.class));
        }

        /**
         * The construct node where permissions are attached.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.constructs.Node getPermissionsNode() {
            return software.amazon.jsii.Kernel.get(this, "permissionsNode", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The ARN(s) to put into the resource field of the generated IAM policy for grantInvoke().
         * <p>
         * This property is for cdk modules to consume only. You should not need to use this property.
         * Instead, use grantInvoke() directly.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getResourceArnsForGrantInvoke() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "resourceArnsForGrantInvoke", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
        }

        /**
         * The IAM role associated with this function.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
            return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Adds an event source to this function.
         * <p>
         * Event sources are implemented in the aws-cdk-lib/aws-lambda-event-sources module.
         * <p>
         * The following example adds an SQS Queue as an event source:
         * <p>
         * <blockquote><pre>
         * import { SqsEventSource } from 'aws-cdk-lib/aws-lambda-event-sources';
         * myFunction.addEventSource(new SqsEventSource(myQueue));
         * </pre></blockquote>
         * <p>
         * @param source This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addEventSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IEventSource source) {
            software.amazon.jsii.Kernel.call(this, "addEventSource", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(source, "source is required") });
        }

        /**
         * Adds an event source that maps to this AWS Lambda function.
         * <p>
         * @param id construct ID. This parameter is required.
         * @param options mapping options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.EventSourceMapping addEventSourceMapping(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.EventSourceMappingOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addEventSourceMapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.EventSourceMapping.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
        }

        /**
         * Adds a url to this lambda function.
         * <p>
         * @param options
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.FunctionUrl addFunctionUrl(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.FunctionUrlOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addFunctionUrl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.FunctionUrl.class), new Object[] { options });
        }

        /**
         * Adds a url to this lambda function.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.FunctionUrl addFunctionUrl() {
            return software.amazon.jsii.Kernel.call(this, "addFunctionUrl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.FunctionUrl.class));
        }

        /**
         * Adds a permission to the Lambda resource policy.
         * <p>
         * @see <a href="Permission for details.">Permission for details.</a>
         * @param id The id for the permission construct. This parameter is required.
         * @param permission The permission to grant to this Lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addPermission(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Permission permission) {
            software.amazon.jsii.Kernel.call(this, "addPermission", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(permission, "permission is required") });
        }

        /**
         * Adds a statement to the IAM role assumed by the instance.
         * <p>
         * @param statement This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addToRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
            software.amazon.jsii.Kernel.call(this, "addToRolePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
        }

        /**
         * Configures options for asynchronous invocation.
         * <p>
         * @param options This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void configureAsyncInvoke(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.EventInvokeConfigOptions options) {
            software.amazon.jsii.Kernel.call(this, "configureAsyncInvoke", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
        }

        /**
         * Grant the given identity permissions to invoke this Lambda.
         * <p>
         * @param identity This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantInvoke(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantInvoke", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * Grant multiple principals the ability to invoke this Lambda via CompositePrincipal.
         * <p>
         * @param compositePrincipal This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.iam.Grant> grantInvokeCompositePrincipal(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.CompositePrincipal compositePrincipal) {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "grantInvokeCompositePrincipal", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class)), new Object[] { java.util.Objects.requireNonNull(compositePrincipal, "compositePrincipal is required") }));
        }

        /**
         * Grant the given identity permissions to invoke the $LATEST version or unqualified version of this Lambda.
         * <p>
         * @param identity This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantInvokeLatestVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantInvokeLatestVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * Grant the given identity permissions to invoke this Lambda Function URL.
         * <p>
         * @param identity This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantInvokeUrl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantInvokeUrl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * Grant the given identity permissions to invoke the given version of this Lambda.
         * <p>
         * @param identity This parameter is required.
         * @param version This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantInvokeVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IVersion version) {
            return software.amazon.jsii.Kernel.call(this, "grantInvokeVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), java.util.Objects.requireNonNull(version, "version is required") });
        }

        /**
         * Return the given named metric for this Lambda Return the given named metric for this Function.
         * <p>
         * @param metricName This parameter is required.
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
        }

        /**
         * Return the given named metric for this Lambda Return the given named metric for this Function.
         * <p>
         * @param metricName This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
            return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
        }

        /**
         * Metric for the Duration of this Lambda How long execution of this Lambda takes.
         * <p>
         * Average over 5 minutes
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDuration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * Metric for the Duration of this Lambda How long execution of this Lambda takes.
         * <p>
         * Average over 5 minutes
         * <p>
         * Default: average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDuration() {
            return software.amazon.jsii.Kernel.call(this, "metricDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * How many invocations of this Lambda fail.
         * <p>
         * Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricErrors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricErrors", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * How many invocations of this Lambda fail.
         * <p>
         * Sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricErrors() {
            return software.amazon.jsii.Kernel.call(this, "metricErrors", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * Metric for the number of invocations of this Lambda How often this Lambda is invoked.
         * <p>
         * Sum over 5 minutes
         * <p>
         * Default: sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricInvocations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricInvocations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * Metric for the number of invocations of this Lambda How often this Lambda is invoked.
         * <p>
         * Sum over 5 minutes
         * <p>
         * Default: sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricInvocations() {
            return software.amazon.jsii.Kernel.call(this, "metricInvocations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * Metric for the number of throttled invocations of this Lambda How often this Lambda is throttled.
         * <p>
         * Sum over 5 minutes
         * <p>
         * Default: sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricThrottles(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricThrottles", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * Metric for the number of throttled invocations of this Lambda How often this Lambda is throttled.
         * <p>
         * Sum over 5 minutes
         * <p>
         * Default: sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricThrottles() {
            return software.amazon.jsii.Kernel.call(this, "metricThrottles", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }
    }

    /**
     * Internal default implementation for {@link IFunction}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IFunction, software.amazon.awscdk.IResource.Jsii$Default, software.amazon.awscdk.interfaces.lambda.IFunctionRef.Jsii$Default, software.amazon.awscdk.services.ec2.IConnectable.Jsii$Default, software.amazon.awscdk.services.iam.IGrantable.Jsii$Default {

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed in a Stack (those created by
         * creating new class instances like <code>new Role()</code>, <code>new Bucket()</code>, etc.), this
         * is always the same as the environment of the stack they belong to.
         * <p>
         * For referenced resources (those obtained from referencing methods like
         * <code>Role.fromRoleArn()</code>, <code>Bucket.fromBucketName()</code>, etc.), they might be
         * different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * The network connections associated with this resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
            return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
        }

        /**
         * The principal to grant permissions to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
            return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
        }

        /**
         * (experimental) A reference to a Function resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.lambda.FunctionReference getFunctionRef() {
            return software.amazon.jsii.Kernel.get(this, "functionRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.lambda.FunctionReference.class));
        }

        /**
         * The system architectures compatible with this lambda function.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Architecture getArchitecture() {
            return software.amazon.jsii.Kernel.get(this, "architecture", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Architecture.class));
        }

        /**
         * The ARN of the function.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getFunctionArn() {
            return software.amazon.jsii.Kernel.get(this, "functionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The name of the function.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getFunctionName() {
            return software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Whether or not this Lambda function was bound to a VPC.
         * <p>
         * If this is is <code>false</code>, trying to access the <code>connections</code> object will fail.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.Boolean getIsBoundToVpc() {
            return software.amazon.jsii.Kernel.get(this, "isBoundToVpc", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * The <code>$LATEST</code> version of this function.
         * <p>
         * Note that this is reference to a non-specific AWS Lambda version, which
         * means the function this version refers to can return different results in
         * different invocations.
         * <p>
         * To obtain a reference to an explicit version which references the current
         * function configuration, use <code>lambdaFunction.currentVersion</code> instead.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IVersion getLatestVersion() {
            return software.amazon.jsii.Kernel.get(this, "latestVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IVersion.class));
        }

        /**
         * The construct node where permissions are attached.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.constructs.Node getPermissionsNode() {
            return software.amazon.jsii.Kernel.get(this, "permissionsNode", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The ARN(s) to put into the resource field of the generated IAM policy for grantInvoke().
         * <p>
         * This property is for cdk modules to consume only. You should not need to use this property.
         * Instead, use grantInvoke() directly.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getResourceArnsForGrantInvoke() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "resourceArnsForGrantInvoke", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
        }

        /**
         * The IAM role associated with this function.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
            return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Adds an event source to this function.
         * <p>
         * Event sources are implemented in the aws-cdk-lib/aws-lambda-event-sources module.
         * <p>
         * The following example adds an SQS Queue as an event source:
         * <p>
         * <blockquote><pre>
         * import { SqsEventSource } from 'aws-cdk-lib/aws-lambda-event-sources';
         * myFunction.addEventSource(new SqsEventSource(myQueue));
         * </pre></blockquote>
         * <p>
         * @param source This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addEventSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IEventSource source) {
            software.amazon.jsii.Kernel.call(this, "addEventSource", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(source, "source is required") });
        }

        /**
         * Adds an event source that maps to this AWS Lambda function.
         * <p>
         * @param id construct ID. This parameter is required.
         * @param options mapping options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.EventSourceMapping addEventSourceMapping(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.EventSourceMappingOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addEventSourceMapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.EventSourceMapping.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
        }

        /**
         * Adds a url to this lambda function.
         * <p>
         * @param options
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.FunctionUrl addFunctionUrl(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.FunctionUrlOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addFunctionUrl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.FunctionUrl.class), new Object[] { options });
        }

        /**
         * Adds a permission to the Lambda resource policy.
         * <p>
         * @see <a href="Permission for details.">Permission for details.</a>
         * @param id The id for the permission construct. This parameter is required.
         * @param permission The permission to grant to this Lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addPermission(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Permission permission) {
            software.amazon.jsii.Kernel.call(this, "addPermission", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(permission, "permission is required") });
        }

        /**
         * Adds a statement to the IAM role assumed by the instance.
         * <p>
         * @param statement This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addToRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
            software.amazon.jsii.Kernel.call(this, "addToRolePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
        }

        /**
         * Configures options for asynchronous invocation.
         * <p>
         * @param options This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void configureAsyncInvoke(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.EventInvokeConfigOptions options) {
            software.amazon.jsii.Kernel.call(this, "configureAsyncInvoke", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
        }

        /**
         * Grant the given identity permissions to invoke this Lambda.
         * <p>
         * @param identity This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantInvoke(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantInvoke", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * Grant multiple principals the ability to invoke this Lambda via CompositePrincipal.
         * <p>
         * @param compositePrincipal This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.iam.Grant> grantInvokeCompositePrincipal(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.CompositePrincipal compositePrincipal) {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "grantInvokeCompositePrincipal", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class)), new Object[] { java.util.Objects.requireNonNull(compositePrincipal, "compositePrincipal is required") }));
        }

        /**
         * Grant the given identity permissions to invoke the $LATEST version or unqualified version of this Lambda.
         * <p>
         * @param identity This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantInvokeLatestVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantInvokeLatestVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * Grant the given identity permissions to invoke this Lambda Function URL.
         * <p>
         * @param identity This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantInvokeUrl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
            return software.amazon.jsii.Kernel.call(this, "grantInvokeUrl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
        }

        /**
         * Grant the given identity permissions to invoke the given version of this Lambda.
         * <p>
         * @param identity This parameter is required.
         * @param version This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantInvokeVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IVersion version) {
            return software.amazon.jsii.Kernel.call(this, "grantInvokeVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), java.util.Objects.requireNonNull(version, "version is required") });
        }

        /**
         * Return the given named metric for this Lambda Return the given named metric for this Function.
         * <p>
         * @param metricName This parameter is required.
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
        }

        /**
         * Metric for the Duration of this Lambda How long execution of this Lambda takes.
         * <p>
         * Average over 5 minutes
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDuration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * How many invocations of this Lambda fail.
         * <p>
         * Sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricErrors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricErrors", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * Metric for the number of invocations of this Lambda How often this Lambda is invoked.
         * <p>
         * Sum over 5 minutes
         * <p>
         * Default: sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricInvocations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricInvocations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * Metric for the number of throttled invocations of this Lambda How often this Lambda is throttled.
         * <p>
         * Sum over 5 minutes
         * <p>
         * Default: sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricThrottles(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricThrottles", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }
    }
}
