package software.amazon.awscdk.services.lambda;

/**
 * Lambda code from an inline string.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * LayerVersion layer = LayerVersion.Builder.create(stack, "MyLayer")
 *         .code(Code.fromAsset(join(__dirname, "layer-code")))
 *         .compatibleRuntimes(List.of(Runtime.NODEJS_LATEST))
 *         .license("Apache-2.0")
 *         .description("A layer to test the L2 construct")
 *         .build();
 * // To grant usage by other AWS accounts
 * layer.addPermission("remote-account-grant", LayerVersionPermission.builder().accountId(awsAccountId).build());
 * // To grant usage to all accounts in some AWS Ogranization
 * // layer.grantUsage({ accountId: '*', organizationId });
 * // To grant usage to all accounts in some AWS Ogranization
 * // layer.grantUsage({ accountId: '*', organizationId });
 * Function.Builder.create(stack, "MyLayeredLambda")
 *         .code(new InlineCode("foo"))
 *         .handler("index.handler")
 *         .runtime(Runtime.NODEJS_LATEST)
 *         .layers(List.of(layer))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:54.962Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.InlineCode")
public class InlineCode extends software.amazon.awscdk.services.lambda.Code {

    protected InlineCode(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InlineCode(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param code This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InlineCode(final @org.jetbrains.annotations.NotNull java.lang.String code) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(code, "code is required") });
    }

    /**
     * Called when the lambda or layer is initialized to allow this object to bind to the stack, add resources and have fun.
     * <p>
     * @param _scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.CodeConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.CodeConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required") });
    }

    /**
     * Determines whether this Code is inline code or not.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsInline() {
        return software.amazon.jsii.Kernel.get(this, "isInline", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }
}
