package software.amazon.awscdk.services.lambda;

/**
 * Parameters and Secrets Extension configuration options.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.secretsmanager.*;
 * import software.amazon.awscdk.services.ssm.*;
 * Secret secret = new Secret(this, "Secret");
 * StringParameter parameter = StringParameter.Builder.create(this, "Parameter")
 *         .parameterName("mySsmParameterName")
 *         .stringValue("mySsmParameterValue")
 *         .build();
 * ParamsAndSecretsLayerVersion paramsAndSecrets = ParamsAndSecretsLayerVersion.fromVersion(ParamsAndSecretsVersions.V1_0_103, ParamsAndSecretsOptions.builder()
 *         .cacheSize(500)
 *         .logLevel(ParamsAndSecretsLogLevel.DEBUG)
 *         .build());
 * Function lambdaFunction = Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.NODEJS_18_X)
 *         .handler("index.handler")
 *         .architecture(Architecture.ARM_64)
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .paramsAndSecrets(paramsAndSecrets)
 *         .build();
 * secret.grantRead(lambdaFunction);
 * parameter.grantRead(lambdaFunction);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:54.971Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.ParamsAndSecretsOptions")
@software.amazon.jsii.Jsii.Proxy(ParamsAndSecretsOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ParamsAndSecretsOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether the Parameters and Secrets Extension will cache parameters and secrets.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCacheEnabled() {
        return null;
    }

    /**
     * The maximum number of secrets and parameters to cache.
     * <p>
     * Must be a value
     * from 0 to 1000. A value of 0 means there is no caching.
     * <p>
     * Note: This variable is ignored if parameterStoreTtl and secretsManagerTtl
     * are 0.
     * <p>
     * Default: 1000
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCacheSize() {
        return null;
    }

    /**
     * The port for the local HTTP server.
     * <p>
     * Valid port numbers are 1 - 65535.
     * <p>
     * Default: 2773
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getHttpPort() {
        return null;
    }

    /**
     * The level of logging provided by the Parameters and Secrets Extension.
     * <p>
     * Note: Set to debug to see the cache configuration.
     * <p>
     * Default: - Logging level will be `info`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.ParamsAndSecretsLogLevel getLogLevel() {
        return null;
    }

    /**
     * The maximum number of connection for HTTP clients that the Parameters and Secrets Extension uses to make requests to Parameter Store or Secrets Manager.
     * <p>
     * There is no maximum limit. Minimum is 1.
     * <p>
     * Note: Every running copy of this Lambda function may open the number of
     * connections specified by this property. Thus, the total number of connections
     * may exceed this number.
     * <p>
     * Default: 3
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxConnections() {
        return null;
    }

    /**
     * The timeout for requests to Parameter Store.
     * <p>
     * A value of 0 means that there is no
     * timeout.
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getParameterStoreTimeout() {
        return null;
    }

    /**
     * The time-to-live of a parameter in the cache.
     * <p>
     * A value of 0 means there is no caching.
     * The maximum time-to-live is 300 seconds.
     * <p>
     * Note: This variable is ignored if cacheSize is 0.
     * <p>
     * Default: 300 seconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getParameterStoreTtl() {
        return null;
    }

    /**
     * The timeout for requests to Secrets Manager.
     * <p>
     * A value of 0 means that there is
     * no timeout.
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getSecretsManagerTimeout() {
        return null;
    }

    /**
     * The time-to-live of a secret in the cache.
     * <p>
     * A value of 0 means there is no caching.
     * The maximum time-to-live is 300 seconds.
     * <p>
     * Note: This variable is ignored if cacheSize is 0.
     * <p>
     * Default: 300 seconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getSecretsManagerTtl() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ParamsAndSecretsOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ParamsAndSecretsOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ParamsAndSecretsOptions> {
        java.lang.Boolean cacheEnabled;
        java.lang.Number cacheSize;
        java.lang.Number httpPort;
        software.amazon.awscdk.services.lambda.ParamsAndSecretsLogLevel logLevel;
        java.lang.Number maxConnections;
        software.amazon.awscdk.Duration parameterStoreTimeout;
        software.amazon.awscdk.Duration parameterStoreTtl;
        software.amazon.awscdk.Duration secretsManagerTimeout;
        software.amazon.awscdk.Duration secretsManagerTtl;

        /**
         * Sets the value of {@link ParamsAndSecretsOptions#getCacheEnabled}
         * @param cacheEnabled Whether the Parameters and Secrets Extension will cache parameters and secrets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheEnabled(java.lang.Boolean cacheEnabled) {
            this.cacheEnabled = cacheEnabled;
            return this;
        }

        /**
         * Sets the value of {@link ParamsAndSecretsOptions#getCacheSize}
         * @param cacheSize The maximum number of secrets and parameters to cache.
         *                  Must be a value
         *                  from 0 to 1000. A value of 0 means there is no caching.
         *                  <p>
         *                  Note: This variable is ignored if parameterStoreTtl and secretsManagerTtl
         *                  are 0.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheSize(java.lang.Number cacheSize) {
            this.cacheSize = cacheSize;
            return this;
        }

        /**
         * Sets the value of {@link ParamsAndSecretsOptions#getHttpPort}
         * @param httpPort The port for the local HTTP server.
         *                 Valid port numbers are 1 - 65535.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpPort(java.lang.Number httpPort) {
            this.httpPort = httpPort;
            return this;
        }

        /**
         * Sets the value of {@link ParamsAndSecretsOptions#getLogLevel}
         * @param logLevel The level of logging provided by the Parameters and Secrets Extension.
         *                 Note: Set to debug to see the cache configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logLevel(software.amazon.awscdk.services.lambda.ParamsAndSecretsLogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        /**
         * Sets the value of {@link ParamsAndSecretsOptions#getMaxConnections}
         * @param maxConnections The maximum number of connection for HTTP clients that the Parameters and Secrets Extension uses to make requests to Parameter Store or Secrets Manager.
         *                       There is no maximum limit. Minimum is 1.
         *                       <p>
         *                       Note: Every running copy of this Lambda function may open the number of
         *                       connections specified by this property. Thus, the total number of connections
         *                       may exceed this number.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConnections(java.lang.Number maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        /**
         * Sets the value of {@link ParamsAndSecretsOptions#getParameterStoreTimeout}
         * @param parameterStoreTimeout The timeout for requests to Parameter Store.
         *                              A value of 0 means that there is no
         *                              timeout.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterStoreTimeout(software.amazon.awscdk.Duration parameterStoreTimeout) {
            this.parameterStoreTimeout = parameterStoreTimeout;
            return this;
        }

        /**
         * Sets the value of {@link ParamsAndSecretsOptions#getParameterStoreTtl}
         * @param parameterStoreTtl The time-to-live of a parameter in the cache.
         *                          A value of 0 means there is no caching.
         *                          The maximum time-to-live is 300 seconds.
         *                          <p>
         *                          Note: This variable is ignored if cacheSize is 0.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterStoreTtl(software.amazon.awscdk.Duration parameterStoreTtl) {
            this.parameterStoreTtl = parameterStoreTtl;
            return this;
        }

        /**
         * Sets the value of {@link ParamsAndSecretsOptions#getSecretsManagerTimeout}
         * @param secretsManagerTimeout The timeout for requests to Secrets Manager.
         *                              A value of 0 means that there is
         *                              no timeout.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretsManagerTimeout(software.amazon.awscdk.Duration secretsManagerTimeout) {
            this.secretsManagerTimeout = secretsManagerTimeout;
            return this;
        }

        /**
         * Sets the value of {@link ParamsAndSecretsOptions#getSecretsManagerTtl}
         * @param secretsManagerTtl The time-to-live of a secret in the cache.
         *                          A value of 0 means there is no caching.
         *                          The maximum time-to-live is 300 seconds.
         *                          <p>
         *                          Note: This variable is ignored if cacheSize is 0.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretsManagerTtl(software.amazon.awscdk.Duration secretsManagerTtl) {
            this.secretsManagerTtl = secretsManagerTtl;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ParamsAndSecretsOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ParamsAndSecretsOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ParamsAndSecretsOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParamsAndSecretsOptions {
        private final java.lang.Boolean cacheEnabled;
        private final java.lang.Number cacheSize;
        private final java.lang.Number httpPort;
        private final software.amazon.awscdk.services.lambda.ParamsAndSecretsLogLevel logLevel;
        private final java.lang.Number maxConnections;
        private final software.amazon.awscdk.Duration parameterStoreTimeout;
        private final software.amazon.awscdk.Duration parameterStoreTtl;
        private final software.amazon.awscdk.Duration secretsManagerTimeout;
        private final software.amazon.awscdk.Duration secretsManagerTtl;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cacheEnabled = software.amazon.jsii.Kernel.get(this, "cacheEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.cacheSize = software.amazon.jsii.Kernel.get(this, "cacheSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.httpPort = software.amazon.jsii.Kernel.get(this, "httpPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.logLevel = software.amazon.jsii.Kernel.get(this, "logLevel", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ParamsAndSecretsLogLevel.class));
            this.maxConnections = software.amazon.jsii.Kernel.get(this, "maxConnections", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.parameterStoreTimeout = software.amazon.jsii.Kernel.get(this, "parameterStoreTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.parameterStoreTtl = software.amazon.jsii.Kernel.get(this, "parameterStoreTtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.secretsManagerTimeout = software.amazon.jsii.Kernel.get(this, "secretsManagerTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.secretsManagerTtl = software.amazon.jsii.Kernel.get(this, "secretsManagerTtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cacheEnabled = builder.cacheEnabled;
            this.cacheSize = builder.cacheSize;
            this.httpPort = builder.httpPort;
            this.logLevel = builder.logLevel;
            this.maxConnections = builder.maxConnections;
            this.parameterStoreTimeout = builder.parameterStoreTimeout;
            this.parameterStoreTtl = builder.parameterStoreTtl;
            this.secretsManagerTimeout = builder.secretsManagerTimeout;
            this.secretsManagerTtl = builder.secretsManagerTtl;
        }

        @Override
        public final java.lang.Boolean getCacheEnabled() {
            return this.cacheEnabled;
        }

        @Override
        public final java.lang.Number getCacheSize() {
            return this.cacheSize;
        }

        @Override
        public final java.lang.Number getHttpPort() {
            return this.httpPort;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.ParamsAndSecretsLogLevel getLogLevel() {
            return this.logLevel;
        }

        @Override
        public final java.lang.Number getMaxConnections() {
            return this.maxConnections;
        }

        @Override
        public final software.amazon.awscdk.Duration getParameterStoreTimeout() {
            return this.parameterStoreTimeout;
        }

        @Override
        public final software.amazon.awscdk.Duration getParameterStoreTtl() {
            return this.parameterStoreTtl;
        }

        @Override
        public final software.amazon.awscdk.Duration getSecretsManagerTimeout() {
            return this.secretsManagerTimeout;
        }

        @Override
        public final software.amazon.awscdk.Duration getSecretsManagerTtl() {
            return this.secretsManagerTtl;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCacheEnabled() != null) {
                data.set("cacheEnabled", om.valueToTree(this.getCacheEnabled()));
            }
            if (this.getCacheSize() != null) {
                data.set("cacheSize", om.valueToTree(this.getCacheSize()));
            }
            if (this.getHttpPort() != null) {
                data.set("httpPort", om.valueToTree(this.getHttpPort()));
            }
            if (this.getLogLevel() != null) {
                data.set("logLevel", om.valueToTree(this.getLogLevel()));
            }
            if (this.getMaxConnections() != null) {
                data.set("maxConnections", om.valueToTree(this.getMaxConnections()));
            }
            if (this.getParameterStoreTimeout() != null) {
                data.set("parameterStoreTimeout", om.valueToTree(this.getParameterStoreTimeout()));
            }
            if (this.getParameterStoreTtl() != null) {
                data.set("parameterStoreTtl", om.valueToTree(this.getParameterStoreTtl()));
            }
            if (this.getSecretsManagerTimeout() != null) {
                data.set("secretsManagerTimeout", om.valueToTree(this.getSecretsManagerTimeout()));
            }
            if (this.getSecretsManagerTtl() != null) {
                data.set("secretsManagerTtl", om.valueToTree(this.getSecretsManagerTtl()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.ParamsAndSecretsOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ParamsAndSecretsOptions.Jsii$Proxy that = (ParamsAndSecretsOptions.Jsii$Proxy) o;

            if (this.cacheEnabled != null ? !this.cacheEnabled.equals(that.cacheEnabled) : that.cacheEnabled != null) return false;
            if (this.cacheSize != null ? !this.cacheSize.equals(that.cacheSize) : that.cacheSize != null) return false;
            if (this.httpPort != null ? !this.httpPort.equals(that.httpPort) : that.httpPort != null) return false;
            if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) return false;
            if (this.maxConnections != null ? !this.maxConnections.equals(that.maxConnections) : that.maxConnections != null) return false;
            if (this.parameterStoreTimeout != null ? !this.parameterStoreTimeout.equals(that.parameterStoreTimeout) : that.parameterStoreTimeout != null) return false;
            if (this.parameterStoreTtl != null ? !this.parameterStoreTtl.equals(that.parameterStoreTtl) : that.parameterStoreTtl != null) return false;
            if (this.secretsManagerTimeout != null ? !this.secretsManagerTimeout.equals(that.secretsManagerTimeout) : that.secretsManagerTimeout != null) return false;
            return this.secretsManagerTtl != null ? this.secretsManagerTtl.equals(that.secretsManagerTtl) : that.secretsManagerTtl == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cacheEnabled != null ? this.cacheEnabled.hashCode() : 0;
            result = 31 * result + (this.cacheSize != null ? this.cacheSize.hashCode() : 0);
            result = 31 * result + (this.httpPort != null ? this.httpPort.hashCode() : 0);
            result = 31 * result + (this.logLevel != null ? this.logLevel.hashCode() : 0);
            result = 31 * result + (this.maxConnections != null ? this.maxConnections.hashCode() : 0);
            result = 31 * result + (this.parameterStoreTimeout != null ? this.parameterStoreTimeout.hashCode() : 0);
            result = 31 * result + (this.parameterStoreTtl != null ? this.parameterStoreTtl.hashCode() : 0);
            result = 31 * result + (this.secretsManagerTimeout != null ? this.secretsManagerTimeout.hashCode() : 0);
            result = 31 * result + (this.secretsManagerTtl != null ? this.secretsManagerTtl.hashCode() : 0);
            return result;
        }
    }
}
