package software.amazon.awscdk.services.logs;

/**
 * This object defines one key that will be added with the addKeys processor.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * AddKeyEntryProperty addKeyEntryProperty = AddKeyEntryProperty.builder()
 *         .key("key")
 *         .value("value")
 *         // the properties below are optional
 *         .overwriteIfExists(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:55.323Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.AddKeyEntryProperty")
@software.amazon.jsii.Jsii.Proxy(AddKeyEntryProperty.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AddKeyEntryProperty extends software.amazon.jsii.JsiiSerializable {

    /**
     * The key of the new entry to be added to the log event.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKey();

    /**
     * The value of the new entry to be added to the log event.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getValue();

    /**
     * Specifies whether to overwrite the value if the key already exists.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getOverwriteIfExists() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AddKeyEntryProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AddKeyEntryProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AddKeyEntryProperty> {
        java.lang.String key;
        java.lang.String value;
        java.lang.Boolean overwriteIfExists;

        /**
         * Sets the value of {@link AddKeyEntryProperty#getKey}
         * @param key The key of the new entry to be added to the log event. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder key(java.lang.String key) {
            this.key = key;
            return this;
        }

        /**
         * Sets the value of {@link AddKeyEntryProperty#getValue}
         * @param value The value of the new entry to be added to the log event. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder value(java.lang.String value) {
            this.value = value;
            return this;
        }

        /**
         * Sets the value of {@link AddKeyEntryProperty#getOverwriteIfExists}
         * @param overwriteIfExists Specifies whether to overwrite the value if the key already exists.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder overwriteIfExists(java.lang.Boolean overwriteIfExists) {
            this.overwriteIfExists = overwriteIfExists;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddKeyEntryProperty}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AddKeyEntryProperty build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AddKeyEntryProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddKeyEntryProperty {
        private final java.lang.String key;
        private final java.lang.String value;
        private final java.lang.Boolean overwriteIfExists;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.overwriteIfExists = software.amazon.jsii.Kernel.get(this, "overwriteIfExists", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
            this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            this.overwriteIfExists = builder.overwriteIfExists;
        }

        @Override
        public final java.lang.String getKey() {
            return this.key;
        }

        @Override
        public final java.lang.String getValue() {
            return this.value;
        }

        @Override
        public final java.lang.Boolean getOverwriteIfExists() {
            return this.overwriteIfExists;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("key", om.valueToTree(this.getKey()));
            data.set("value", om.valueToTree(this.getValue()));
            if (this.getOverwriteIfExists() != null) {
                data.set("overwriteIfExists", om.valueToTree(this.getOverwriteIfExists()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.AddKeyEntryProperty"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddKeyEntryProperty.Jsii$Proxy that = (AddKeyEntryProperty.Jsii$Proxy) o;

            if (!key.equals(that.key)) return false;
            if (!value.equals(that.value)) return false;
            return this.overwriteIfExists != null ? this.overwriteIfExists.equals(that.overwriteIfExists) : that.overwriteIfExists == null;
        }

        @Override
        public final int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + (this.value.hashCode());
            result = 31 * result + (this.overwriteIfExists != null ? this.overwriteIfExists.hashCode() : 0);
            return result;
        }
    }
}
