package software.amazon.awscdk.services.logs;

/**
 * Properties for defining a <code>CfnAccountPolicy</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * CfnAccountPolicyProps cfnAccountPolicyProps = CfnAccountPolicyProps.builder()
 *         .policyDocument("policyDocument")
 *         .policyName("policyName")
 *         .policyType("policyType")
 *         // the properties below are optional
 *         .scope("scope")
 *         .selectionCriteria("selectionCriteria")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-accountpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-accountpolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:55.327Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnAccountPolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnAccountPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAccountPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specify the policy, in JSON.
     * <p>
     * <em>Data protection policy</em>
     * <p>
     * A data protection policy must include two JSON blocks:
     * <p>
     * <ul>
     * <li>The first block must include both a <code>DataIdentifer</code> array and an <code>Operation</code> property with an <code>Audit</code> action. The <code>DataIdentifer</code> array lists the types of sensitive data that you want to mask. For more information about the available options, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data-types.html">Types of data that you can mask</a> .</li>
     * </ul>
     * <p>
     * The <code>Operation</code> property with an <code>Audit</code> action is required to find the sensitive data terms. This <code>Audit</code> action must contain a <code>FindingsDestination</code> object. You can optionally use that <code>FindingsDestination</code> object to list one or more destinations to send audit findings to. If you specify destinations such as log groups, Firehose streams, and S3 buckets, they must already exist.
     * <p>
     * <ul>
     * <li>The second block must include both a <code>DataIdentifer</code> array and an <code>Operation</code> property with an <code>Deidentify</code> action. The <code>DataIdentifer</code> array must exactly match the <code>DataIdentifer</code> array in the first block of the policy.</li>
     * </ul>
     * <p>
     * The <code>Operation</code> property with the <code>Deidentify</code> action is what actually masks the data, and it must contain the <code>"MaskConfig": {}</code> object. The <code>"MaskConfig": {}</code> object must be empty.
     * <p>
     * <blockquote>
     * <p>
     * The contents of the two <code>DataIdentifer</code> arrays must match exactly.
     * <p>
     * </blockquote>
     * <p>
     * In addition to the two JSON blocks, the <code>policyDocument</code> can also include <code>Name</code> , <code>Description</code> , and <code>Version</code> fields. The <code>Name</code> is different than the operation's <code>policyName</code> parameter, and is used as a dimension when CloudWatch Logs reports audit findings metrics to CloudWatch .
     * <p>
     * The JSON specified in <code>policyDocument</code> can be up to 30,720 characters long.
     * <p>
     * <em>Subscription filter policy</em>
     * <p>
     * A subscription filter policy can include the following attributes in a JSON block:
     * <p>
     * <ul>
     * <li><em>DestinationArn</em> The ARN of the destination to deliver log events to. Supported destinations are:</li>
     * <li>An Kinesis Data Streams data stream in the same account as the subscription policy, for same-account delivery.</li>
     * <li>An Firehose data stream in the same account as the subscription policy, for same-account delivery.</li>
     * <li>A Lambda function in the same account as the subscription policy, for same-account delivery.</li>
     * <li>A logical destination in a different account created with <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestination.html">PutDestination</a> , for cross-account delivery. Kinesis Data Streams and Firehose are supported as logical destinations.</li>
     * <li><em>RoleArn</em> The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the destination stream. You don't need to provide the ARN when you are working with a logical destination for cross-account delivery.</li>
     * <li><em>FilterPattern</em> A filter pattern for subscribing to a filtered stream of log events.</li>
     * <li><em>Distribution</em> The method used to distribute log data to the destination. By default, log data is grouped by log stream, but the grouping can be set to <code>Random</code> for a more even distribution. This property is only applicable when the destination is an Kinesis Data Streams data stream.</li>
     * </ul>
     * <p>
     * <em>Field index policy</em>
     * <p>
     * A field index filter policy can include the following attribute in a JSON block:
     * <p>
     * <ul>
     * <li><em>Fields</em> The array of field indexes to create.</li>
     * </ul>
     * <p>
     * The following is an example of an index policy document that creates two indexes, <code>RequestId</code> and <code>TransactionId</code> .
     * <p>
     * <code>"policyDocument": "{ \"Fields\": [ \"RequestId\", \"TransactionId\" ] }"</code>
     * <p>
     * <em>Transformer policy</em>
     * <p>
     * A transformer policy must include one JSON block with the array of processors and their configurations. For more information about available processors, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-Processors">Processors that you can use</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-accountpolicy.html#cfn-logs-accountpolicy-policydocument">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-accountpolicy.html#cfn-logs-accountpolicy-policydocument</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPolicyDocument();

    /**
     * A name for the policy.
     * <p>
     * This must be unique within the account.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-accountpolicy.html#cfn-logs-accountpolicy-policyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-accountpolicy.html#cfn-logs-accountpolicy-policyname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPolicyName();

    /**
     * The type of policy that you're creating or updating.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-accountpolicy.html#cfn-logs-accountpolicy-policytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-accountpolicy.html#cfn-logs-accountpolicy-policytype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPolicyType();

    /**
     * Currently the only valid value for this parameter is <code>ALL</code> , which specifies that the policy applies to all log groups in the account.
     * <p>
     * If you omit this parameter, the default of <code>ALL</code> is used. To scope down a subscription filter policy to a subset of log groups, use the <code>SelectionCriteria</code> parameter.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-accountpolicy.html#cfn-logs-accountpolicy-scope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-accountpolicy.html#cfn-logs-accountpolicy-scope</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getScope() {
        return null;
    }

    /**
     * Use this parameter to apply the new policy to a subset of log groups in the account.
     * <p>
     * You need to specify <code>SelectionCriteria</code> only when you specify <code>SUBSCRIPTION_FILTER_POLICY</code> , <code>FIELD_INDEX_POLICY</code> or <code>TRANSFORMER_POLICY</code> for <code>PolicyType</code> .
     * <p>
     * If <code>PolicyType</code> is <code>SUBSCRIPTION_FILTER_POLICY</code> , the only supported <code>SelectionCriteria</code> filter is <code>LogGroupName NOT IN []</code>
     * <p>
     * If <code>PolicyType</code> is <code>FIELD_INDEX_POLICY</code> or <code>TRANSFORMER_POLICY</code> , the only supported <code>SelectionCriteria</code> filter is <code>LogGroupNamePrefix</code>
     * <p>
     * The <code>SelectionCriteria</code> string can be up to 25KB in length. The length is determined by using its UTF-8 bytes.
     * <p>
     * Using the <code>SelectionCriteria</code> parameter with <code>SUBSCRIPTION_FILTER_POLICY</code> is useful to help prevent infinite loops. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Subscriptions-recursion-prevention.html">Log recursion prevention</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-accountpolicy.html#cfn-logs-accountpolicy-selectioncriteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-accountpolicy.html#cfn-logs-accountpolicy-selectioncriteria</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSelectionCriteria() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAccountPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAccountPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAccountPolicyProps> {
        java.lang.String policyDocument;
        java.lang.String policyName;
        java.lang.String policyType;
        java.lang.String scope;
        java.lang.String selectionCriteria;

        /**
         * Sets the value of {@link CfnAccountPolicyProps#getPolicyDocument}
         * @param policyDocument Specify the policy, in JSON. This parameter is required.
         *                       <em>Data protection policy</em>
         *                       <p>
         *                       A data protection policy must include two JSON blocks:
         *                       <p>
         *                       <ul>
         *                       <li>The first block must include both a <code>DataIdentifer</code> array and an <code>Operation</code> property with an <code>Audit</code> action. The <code>DataIdentifer</code> array lists the types of sensitive data that you want to mask. For more information about the available options, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data-types.html">Types of data that you can mask</a> .</li>
         *                       </ul>
         *                       <p>
         *                       The <code>Operation</code> property with an <code>Audit</code> action is required to find the sensitive data terms. This <code>Audit</code> action must contain a <code>FindingsDestination</code> object. You can optionally use that <code>FindingsDestination</code> object to list one or more destinations to send audit findings to. If you specify destinations such as log groups, Firehose streams, and S3 buckets, they must already exist.
         *                       <p>
         *                       <ul>
         *                       <li>The second block must include both a <code>DataIdentifer</code> array and an <code>Operation</code> property with an <code>Deidentify</code> action. The <code>DataIdentifer</code> array must exactly match the <code>DataIdentifer</code> array in the first block of the policy.</li>
         *                       </ul>
         *                       <p>
         *                       The <code>Operation</code> property with the <code>Deidentify</code> action is what actually masks the data, and it must contain the <code>"MaskConfig": {}</code> object. The <code>"MaskConfig": {}</code> object must be empty.
         *                       <p>
         *                       <blockquote>
         *                       <p>
         *                       The contents of the two <code>DataIdentifer</code> arrays must match exactly.
         *                       <p>
         *                       </blockquote>
         *                       <p>
         *                       In addition to the two JSON blocks, the <code>policyDocument</code> can also include <code>Name</code> , <code>Description</code> , and <code>Version</code> fields. The <code>Name</code> is different than the operation's <code>policyName</code> parameter, and is used as a dimension when CloudWatch Logs reports audit findings metrics to CloudWatch .
         *                       <p>
         *                       The JSON specified in <code>policyDocument</code> can be up to 30,720 characters long.
         *                       <p>
         *                       <em>Subscription filter policy</em>
         *                       <p>
         *                       A subscription filter policy can include the following attributes in a JSON block:
         *                       <p>
         *                       <ul>
         *                       <li><em>DestinationArn</em> The ARN of the destination to deliver log events to. Supported destinations are:</li>
         *                       <li>An Kinesis Data Streams data stream in the same account as the subscription policy, for same-account delivery.</li>
         *                       <li>An Firehose data stream in the same account as the subscription policy, for same-account delivery.</li>
         *                       <li>A Lambda function in the same account as the subscription policy, for same-account delivery.</li>
         *                       <li>A logical destination in a different account created with <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestination.html">PutDestination</a> , for cross-account delivery. Kinesis Data Streams and Firehose are supported as logical destinations.</li>
         *                       <li><em>RoleArn</em> The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the destination stream. You don't need to provide the ARN when you are working with a logical destination for cross-account delivery.</li>
         *                       <li><em>FilterPattern</em> A filter pattern for subscribing to a filtered stream of log events.</li>
         *                       <li><em>Distribution</em> The method used to distribute log data to the destination. By default, log data is grouped by log stream, but the grouping can be set to <code>Random</code> for a more even distribution. This property is only applicable when the destination is an Kinesis Data Streams data stream.</li>
         *                       </ul>
         *                       <p>
         *                       <em>Field index policy</em>
         *                       <p>
         *                       A field index filter policy can include the following attribute in a JSON block:
         *                       <p>
         *                       <ul>
         *                       <li><em>Fields</em> The array of field indexes to create.</li>
         *                       </ul>
         *                       <p>
         *                       The following is an example of an index policy document that creates two indexes, <code>RequestId</code> and <code>TransactionId</code> .
         *                       <p>
         *                       <code>"policyDocument": "{ \"Fields\": [ \"RequestId\", \"TransactionId\" ] }"</code>
         *                       <p>
         *                       <em>Transformer policy</em>
         *                       <p>
         *                       A transformer policy must include one JSON block with the array of processors and their configurations. For more information about available processors, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-Processors">Processors that you can use</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDocument(java.lang.String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccountPolicyProps#getPolicyName}
         * @param policyName A name for the policy. This parameter is required.
         *                   This must be unique within the account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyName(java.lang.String policyName) {
            this.policyName = policyName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccountPolicyProps#getPolicyType}
         * @param policyType The type of policy that you're creating or updating. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyType(java.lang.String policyType) {
            this.policyType = policyType;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccountPolicyProps#getScope}
         * @param scope Currently the only valid value for this parameter is <code>ALL</code> , which specifies that the policy applies to all log groups in the account.
         *              If you omit this parameter, the default of <code>ALL</code> is used. To scope down a subscription filter policy to a subset of log groups, use the <code>SelectionCriteria</code> parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(java.lang.String scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccountPolicyProps#getSelectionCriteria}
         * @param selectionCriteria Use this parameter to apply the new policy to a subset of log groups in the account.
         *                          You need to specify <code>SelectionCriteria</code> only when you specify <code>SUBSCRIPTION_FILTER_POLICY</code> , <code>FIELD_INDEX_POLICY</code> or <code>TRANSFORMER_POLICY</code> for <code>PolicyType</code> .
         *                          <p>
         *                          If <code>PolicyType</code> is <code>SUBSCRIPTION_FILTER_POLICY</code> , the only supported <code>SelectionCriteria</code> filter is <code>LogGroupName NOT IN []</code>
         *                          <p>
         *                          If <code>PolicyType</code> is <code>FIELD_INDEX_POLICY</code> or <code>TRANSFORMER_POLICY</code> , the only supported <code>SelectionCriteria</code> filter is <code>LogGroupNamePrefix</code>
         *                          <p>
         *                          The <code>SelectionCriteria</code> string can be up to 25KB in length. The length is determined by using its UTF-8 bytes.
         *                          <p>
         *                          Using the <code>SelectionCriteria</code> parameter with <code>SUBSCRIPTION_FILTER_POLICY</code> is useful to help prevent infinite loops. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Subscriptions-recursion-prevention.html">Log recursion prevention</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selectionCriteria(java.lang.String selectionCriteria) {
            this.selectionCriteria = selectionCriteria;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAccountPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAccountPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAccountPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAccountPolicyProps {
        private final java.lang.String policyDocument;
        private final java.lang.String policyName;
        private final java.lang.String policyType;
        private final java.lang.String scope;
        private final java.lang.String selectionCriteria;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.policyDocument = software.amazon.jsii.Kernel.get(this, "policyDocument", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policyName = software.amazon.jsii.Kernel.get(this, "policyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policyType = software.amazon.jsii.Kernel.get(this, "policyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.selectionCriteria = software.amazon.jsii.Kernel.get(this, "selectionCriteria", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.policyDocument = java.util.Objects.requireNonNull(builder.policyDocument, "policyDocument is required");
            this.policyName = java.util.Objects.requireNonNull(builder.policyName, "policyName is required");
            this.policyType = java.util.Objects.requireNonNull(builder.policyType, "policyType is required");
            this.scope = builder.scope;
            this.selectionCriteria = builder.selectionCriteria;
        }

        @Override
        public final java.lang.String getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public final java.lang.String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final java.lang.String getPolicyType() {
            return this.policyType;
        }

        @Override
        public final java.lang.String getScope() {
            return this.scope;
        }

        @Override
        public final java.lang.String getSelectionCriteria() {
            return this.selectionCriteria;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("policyDocument", om.valueToTree(this.getPolicyDocument()));
            data.set("policyName", om.valueToTree(this.getPolicyName()));
            data.set("policyType", om.valueToTree(this.getPolicyType()));
            if (this.getScope() != null) {
                data.set("scope", om.valueToTree(this.getScope()));
            }
            if (this.getSelectionCriteria() != null) {
                data.set("selectionCriteria", om.valueToTree(this.getSelectionCriteria()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnAccountPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAccountPolicyProps.Jsii$Proxy that = (CfnAccountPolicyProps.Jsii$Proxy) o;

            if (!policyDocument.equals(that.policyDocument)) return false;
            if (!policyName.equals(that.policyName)) return false;
            if (!policyType.equals(that.policyType)) return false;
            if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) return false;
            return this.selectionCriteria != null ? this.selectionCriteria.equals(that.selectionCriteria) : that.selectionCriteria == null;
        }

        @Override
        public final int hashCode() {
            int result = this.policyDocument.hashCode();
            result = 31 * result + (this.policyName.hashCode());
            result = 31 * result + (this.policyType.hashCode());
            result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
            result = 31 * result + (this.selectionCriteria != null ? this.selectionCriteria.hashCode() : 0);
            return result;
        }
    }
}
