package software.amazon.awscdk.services.logs;

/**
 * Properties for defining a <code>CfnMetricFilter</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * CfnMetricFilterProps cfnMetricFilterProps = CfnMetricFilterProps.builder()
 *         .filterPattern("filterPattern")
 *         .logGroupName("logGroupName")
 *         .metricTransformations(List.of(MetricTransformationProperty.builder()
 *                 .metricName("metricName")
 *                 .metricNamespace("metricNamespace")
 *                 .metricValue("metricValue")
 *                 // the properties below are optional
 *                 .defaultValue(123)
 *                 .dimensions(List.of(DimensionProperty.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .unit("unit")
 *                 .build()))
 *         // the properties below are optional
 *         .applyOnTransformedLogs(false)
 *         .emitSystemFieldDimensions(List.of("emitSystemFieldDimensions"))
 *         .fieldSelectionCriteria("fieldSelectionCriteria")
 *         .filterName("filterName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-metricfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-metricfilter.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:55.358Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnMetricFilterProps")
@software.amazon.jsii.Jsii.Proxy(CfnMetricFilterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMetricFilterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A filter pattern for extracting metric data out of ingested log events.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and Pattern Syntax</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-metricfilter.html#cfn-logs-metricfilter-filterpattern">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-metricfilter.html#cfn-logs-metricfilter-filterpattern</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFilterPattern();

    /**
     * The name of an existing log group that you want to associate with this metric filter.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-metricfilter.html#cfn-logs-metricfilter-loggroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-metricfilter.html#cfn-logs-metricfilter-loggroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLogGroupName();

    /**
     * The metric transformations.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.logs.CfnMetricFilter.MetricTransformationProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-metricfilter.html#cfn-logs-metricfilter-metrictransformations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-metricfilter.html#cfn-logs-metricfilter-metrictransformations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getMetricTransformations();

    /**
     * This parameter is valid only for log groups that have an active log transformer.
     * <p>
     * For more information about log transformers, see <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html">PutTransformer</a> .
     * <p>
     * If this value is <code>true</code> , the metric filter is applied on the transformed version of the log events instead of the original ingested log events.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-metricfilter.html#cfn-logs-metricfilter-applyontransformedlogs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-metricfilter.html#cfn-logs-metricfilter-applyontransformedlogs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getApplyOnTransformedLogs() {
        return null;
    }

    /**
     * The list of system fields that are emitted as additional dimensions in the generated metrics.
     * <p>
     * Returns the <code>emitSystemFieldDimensions</code> value if it was specified when the metric filter was created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-metricfilter.html#cfn-logs-metricfilter-emitsystemfielddimensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-metricfilter.html#cfn-logs-metricfilter-emitsystemfielddimensions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEmitSystemFieldDimensions() {
        return null;
    }

    /**
     * The filter expression that specifies which log events are processed by this metric filter based on system fields.
     * <p>
     * Returns the <code>fieldSelectionCriteria</code> value if it was specified when the metric filter was created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-metricfilter.html#cfn-logs-metricfilter-fieldselectioncriteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-metricfilter.html#cfn-logs-metricfilter-fieldselectioncriteria</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFieldSelectionCriteria() {
        return null;
    }

    /**
     * The name of the metric filter.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-metricfilter.html#cfn-logs-metricfilter-filtername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-metricfilter.html#cfn-logs-metricfilter-filtername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFilterName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMetricFilterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMetricFilterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMetricFilterProps> {
        java.lang.String filterPattern;
        java.lang.String logGroupName;
        java.lang.Object metricTransformations;
        java.lang.Object applyOnTransformedLogs;
        java.util.List<java.lang.String> emitSystemFieldDimensions;
        java.lang.String fieldSelectionCriteria;
        java.lang.String filterName;

        /**
         * Sets the value of {@link CfnMetricFilterProps#getFilterPattern}
         * @param filterPattern A filter pattern for extracting metric data out of ingested log events. This parameter is required.
         *                      For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and Pattern Syntax</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPattern(java.lang.String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        /**
         * Sets the value of {@link CfnMetricFilterProps#getLogGroupName}
         * @param logGroupName The name of an existing log group that you want to associate with this metric filter. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupName(java.lang.String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnMetricFilterProps#getMetricTransformations}
         * @param metricTransformations The metric transformations. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricTransformations(software.amazon.awscdk.IResolvable metricTransformations) {
            this.metricTransformations = metricTransformations;
            return this;
        }

        /**
         * Sets the value of {@link CfnMetricFilterProps#getMetricTransformations}
         * @param metricTransformations The metric transformations. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricTransformations(java.util.List<? extends java.lang.Object> metricTransformations) {
            this.metricTransformations = metricTransformations;
            return this;
        }

        /**
         * Sets the value of {@link CfnMetricFilterProps#getApplyOnTransformedLogs}
         * @param applyOnTransformedLogs This parameter is valid only for log groups that have an active log transformer.
         *                               For more information about log transformers, see <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html">PutTransformer</a> .
         *                               <p>
         *                               If this value is <code>true</code> , the metric filter is applied on the transformed version of the log events instead of the original ingested log events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applyOnTransformedLogs(java.lang.Boolean applyOnTransformedLogs) {
            this.applyOnTransformedLogs = applyOnTransformedLogs;
            return this;
        }

        /**
         * Sets the value of {@link CfnMetricFilterProps#getApplyOnTransformedLogs}
         * @param applyOnTransformedLogs This parameter is valid only for log groups that have an active log transformer.
         *                               For more information about log transformers, see <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html">PutTransformer</a> .
         *                               <p>
         *                               If this value is <code>true</code> , the metric filter is applied on the transformed version of the log events instead of the original ingested log events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applyOnTransformedLogs(software.amazon.awscdk.IResolvable applyOnTransformedLogs) {
            this.applyOnTransformedLogs = applyOnTransformedLogs;
            return this;
        }

        /**
         * Sets the value of {@link CfnMetricFilterProps#getEmitSystemFieldDimensions}
         * @param emitSystemFieldDimensions The list of system fields that are emitted as additional dimensions in the generated metrics.
         *                                  Returns the <code>emitSystemFieldDimensions</code> value if it was specified when the metric filter was created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emitSystemFieldDimensions(java.util.List<java.lang.String> emitSystemFieldDimensions) {
            this.emitSystemFieldDimensions = emitSystemFieldDimensions;
            return this;
        }

        /**
         * Sets the value of {@link CfnMetricFilterProps#getFieldSelectionCriteria}
         * @param fieldSelectionCriteria The filter expression that specifies which log events are processed by this metric filter based on system fields.
         *                               Returns the <code>fieldSelectionCriteria</code> value if it was specified when the metric filter was created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fieldSelectionCriteria(java.lang.String fieldSelectionCriteria) {
            this.fieldSelectionCriteria = fieldSelectionCriteria;
            return this;
        }

        /**
         * Sets the value of {@link CfnMetricFilterProps#getFilterName}
         * @param filterName The name of the metric filter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterName(java.lang.String filterName) {
            this.filterName = filterName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMetricFilterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMetricFilterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMetricFilterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMetricFilterProps {
        private final java.lang.String filterPattern;
        private final java.lang.String logGroupName;
        private final java.lang.Object metricTransformations;
        private final java.lang.Object applyOnTransformedLogs;
        private final java.util.List<java.lang.String> emitSystemFieldDimensions;
        private final java.lang.String fieldSelectionCriteria;
        private final java.lang.String filterName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.filterPattern = software.amazon.jsii.Kernel.get(this, "filterPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logGroupName = software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.metricTransformations = software.amazon.jsii.Kernel.get(this, "metricTransformations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.applyOnTransformedLogs = software.amazon.jsii.Kernel.get(this, "applyOnTransformedLogs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.emitSystemFieldDimensions = software.amazon.jsii.Kernel.get(this, "emitSystemFieldDimensions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.fieldSelectionCriteria = software.amazon.jsii.Kernel.get(this, "fieldSelectionCriteria", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.filterName = software.amazon.jsii.Kernel.get(this, "filterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.filterPattern = java.util.Objects.requireNonNull(builder.filterPattern, "filterPattern is required");
            this.logGroupName = java.util.Objects.requireNonNull(builder.logGroupName, "logGroupName is required");
            this.metricTransformations = java.util.Objects.requireNonNull(builder.metricTransformations, "metricTransformations is required");
            this.applyOnTransformedLogs = builder.applyOnTransformedLogs;
            this.emitSystemFieldDimensions = builder.emitSystemFieldDimensions;
            this.fieldSelectionCriteria = builder.fieldSelectionCriteria;
            this.filterName = builder.filterName;
        }

        @Override
        public final java.lang.String getFilterPattern() {
            return this.filterPattern;
        }

        @Override
        public final java.lang.String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final java.lang.Object getMetricTransformations() {
            return this.metricTransformations;
        }

        @Override
        public final java.lang.Object getApplyOnTransformedLogs() {
            return this.applyOnTransformedLogs;
        }

        @Override
        public final java.util.List<java.lang.String> getEmitSystemFieldDimensions() {
            return this.emitSystemFieldDimensions;
        }

        @Override
        public final java.lang.String getFieldSelectionCriteria() {
            return this.fieldSelectionCriteria;
        }

        @Override
        public final java.lang.String getFilterName() {
            return this.filterName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("filterPattern", om.valueToTree(this.getFilterPattern()));
            data.set("logGroupName", om.valueToTree(this.getLogGroupName()));
            data.set("metricTransformations", om.valueToTree(this.getMetricTransformations()));
            if (this.getApplyOnTransformedLogs() != null) {
                data.set("applyOnTransformedLogs", om.valueToTree(this.getApplyOnTransformedLogs()));
            }
            if (this.getEmitSystemFieldDimensions() != null) {
                data.set("emitSystemFieldDimensions", om.valueToTree(this.getEmitSystemFieldDimensions()));
            }
            if (this.getFieldSelectionCriteria() != null) {
                data.set("fieldSelectionCriteria", om.valueToTree(this.getFieldSelectionCriteria()));
            }
            if (this.getFilterName() != null) {
                data.set("filterName", om.valueToTree(this.getFilterName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnMetricFilterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMetricFilterProps.Jsii$Proxy that = (CfnMetricFilterProps.Jsii$Proxy) o;

            if (!filterPattern.equals(that.filterPattern)) return false;
            if (!logGroupName.equals(that.logGroupName)) return false;
            if (!metricTransformations.equals(that.metricTransformations)) return false;
            if (this.applyOnTransformedLogs != null ? !this.applyOnTransformedLogs.equals(that.applyOnTransformedLogs) : that.applyOnTransformedLogs != null) return false;
            if (this.emitSystemFieldDimensions != null ? !this.emitSystemFieldDimensions.equals(that.emitSystemFieldDimensions) : that.emitSystemFieldDimensions != null) return false;
            if (this.fieldSelectionCriteria != null ? !this.fieldSelectionCriteria.equals(that.fieldSelectionCriteria) : that.fieldSelectionCriteria != null) return false;
            return this.filterName != null ? this.filterName.equals(that.filterName) : that.filterName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.filterPattern.hashCode();
            result = 31 * result + (this.logGroupName.hashCode());
            result = 31 * result + (this.metricTransformations.hashCode());
            result = 31 * result + (this.applyOnTransformedLogs != null ? this.applyOnTransformedLogs.hashCode() : 0);
            result = 31 * result + (this.emitSystemFieldDimensions != null ? this.emitSystemFieldDimensions.hashCode() : 0);
            result = 31 * result + (this.fieldSelectionCriteria != null ? this.fieldSelectionCriteria.hashCode() : 0);
            result = 31 * result + (this.filterName != null ? this.filterName.hashCode() : 0);
            return result;
        }
    }
}
