package software.amazon.awscdk.services.logs;

/**
 * Properties for creating a data protection policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * LogGroup logGroupDestination = LogGroup.Builder.create(this, "LogGroupLambdaAudit")
 *         .logGroupName("auditDestinationForCDK")
 *         .build();
 * Bucket bucket = new Bucket(this, "audit-bucket");
 * S3Bucket s3Destination = new S3Bucket(bucket);
 * DeliveryStream deliveryStream = DeliveryStream.Builder.create(this, "Delivery Stream")
 *         .destination(s3Destination)
 *         .build();
 * DataProtectionPolicy dataProtectionPolicy = DataProtectionPolicy.Builder.create()
 *         .name("data protection policy")
 *         .description("policy description")
 *         .identifiers(List.of(DataIdentifier.DRIVERSLICENSE_US,  // managed data identifier
 *             new DataIdentifier("EmailAddress"),  // forward compatibility for new managed data identifiers
 *             new CustomDataIdentifier("EmployeeId", "EmployeeId-\\d{9}"))) // custom data identifier
 *         .logGroupAuditDestination(logGroupDestination)
 *         .s3BucketAuditDestination(bucket)
 *         .deliveryStreamNameAuditDestination(deliveryStream.getDeliveryStreamName())
 *         .build();
 * LogGroup.Builder.create(this, "LogGroupLambda")
 *         .logGroupName("cdkIntegLogGroup")
 *         .dataProtectionPolicy(dataProtectionPolicy)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:55.401Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.DataProtectionPolicyProps")
@software.amazon.jsii.Jsii.Proxy(DataProtectionPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DataProtectionPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * List of data protection identifiers.
     * <p>
     * Managed data identifiers must be in the following list: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL-managed-data-identifiers.html
     * Custom data identifiers must have a valid regex defined: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL-custom-data-identifiers.html#custom-data-identifiers-constraints
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.logs.DataIdentifier> getIdentifiers();

    /**
     * Amazon Data Firehose delivery stream to send audit findings to.
     * <p>
     * The delivery stream must already exist.
     * <p>
     * Default: - no firehose delivery stream audit destination
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeliveryStreamNameAuditDestination() {
        return null;
    }

    /**
     * Description of the data protection policy.
     * <p>
     * Default: - 'cdk generated data protection policy'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * CloudWatch Logs log group to send audit findings to.
     * <p>
     * The log group must already exist prior to creating the data protection policy.
     * <p>
     * Default: - no CloudWatch Logs audit destination
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getLogGroupAuditDestination() {
        return null;
    }

    /**
     * Name of the data protection policy.
     * <p>
     * Default: - 'data-protection-policy-cdk'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * S3 bucket to send audit findings to.
     * <p>
     * The bucket must already exist.
     * <p>
     * Default: - no S3 bucket audit destination
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.interfaces.s3.IBucketRef getS3BucketAuditDestination() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DataProtectionPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DataProtectionPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DataProtectionPolicyProps> {
        java.util.List<software.amazon.awscdk.services.logs.DataIdentifier> identifiers;
        java.lang.String deliveryStreamNameAuditDestination;
        java.lang.String description;
        software.amazon.awscdk.services.logs.ILogGroup logGroupAuditDestination;
        java.lang.String name;
        software.amazon.awscdk.interfaces.s3.IBucketRef s3BucketAuditDestination;

        /**
         * Sets the value of {@link DataProtectionPolicyProps#getIdentifiers}
         * @param identifiers List of data protection identifiers. This parameter is required.
         *                    Managed data identifiers must be in the following list: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL-managed-data-identifiers.html
         *                    Custom data identifiers must have a valid regex defined: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL-custom-data-identifiers.html#custom-data-identifiers-constraints
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder identifiers(java.util.List<? extends software.amazon.awscdk.services.logs.DataIdentifier> identifiers) {
            this.identifiers = (java.util.List<software.amazon.awscdk.services.logs.DataIdentifier>)identifiers;
            return this;
        }

        /**
         * Sets the value of {@link DataProtectionPolicyProps#getDeliveryStreamNameAuditDestination}
         * @param deliveryStreamNameAuditDestination Amazon Data Firehose delivery stream to send audit findings to.
         *                                           The delivery stream must already exist.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStreamNameAuditDestination(java.lang.String deliveryStreamNameAuditDestination) {
            this.deliveryStreamNameAuditDestination = deliveryStreamNameAuditDestination;
            return this;
        }

        /**
         * Sets the value of {@link DataProtectionPolicyProps#getDescription}
         * @param description Description of the data protection policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link DataProtectionPolicyProps#getLogGroupAuditDestination}
         * @param logGroupAuditDestination CloudWatch Logs log group to send audit findings to.
         *                                 The log group must already exist prior to creating the data protection policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupAuditDestination(software.amazon.awscdk.services.logs.ILogGroup logGroupAuditDestination) {
            this.logGroupAuditDestination = logGroupAuditDestination;
            return this;
        }

        /**
         * Sets the value of {@link DataProtectionPolicyProps#getName}
         * @param name Name of the data protection policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link DataProtectionPolicyProps#getS3BucketAuditDestination}
         * @param s3BucketAuditDestination S3 bucket to send audit findings to.
         *                                 The bucket must already exist.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3BucketAuditDestination(software.amazon.awscdk.interfaces.s3.IBucketRef s3BucketAuditDestination) {
            this.s3BucketAuditDestination = s3BucketAuditDestination;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DataProtectionPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DataProtectionPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DataProtectionPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataProtectionPolicyProps {
        private final java.util.List<software.amazon.awscdk.services.logs.DataIdentifier> identifiers;
        private final java.lang.String deliveryStreamNameAuditDestination;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.logs.ILogGroup logGroupAuditDestination;
        private final java.lang.String name;
        private final software.amazon.awscdk.interfaces.s3.IBucketRef s3BucketAuditDestination;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.identifiers = software.amazon.jsii.Kernel.get(this, "identifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class)));
            this.deliveryStreamNameAuditDestination = software.amazon.jsii.Kernel.get(this, "deliveryStreamNameAuditDestination", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logGroupAuditDestination = software.amazon.jsii.Kernel.get(this, "logGroupAuditDestination", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.s3BucketAuditDestination = software.amazon.jsii.Kernel.get(this, "s3BucketAuditDestination", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.s3.IBucketRef.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.identifiers = (java.util.List<software.amazon.awscdk.services.logs.DataIdentifier>)java.util.Objects.requireNonNull(builder.identifiers, "identifiers is required");
            this.deliveryStreamNameAuditDestination = builder.deliveryStreamNameAuditDestination;
            this.description = builder.description;
            this.logGroupAuditDestination = builder.logGroupAuditDestination;
            this.name = builder.name;
            this.s3BucketAuditDestination = builder.s3BucketAuditDestination;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.logs.DataIdentifier> getIdentifiers() {
            return this.identifiers;
        }

        @Override
        public final java.lang.String getDeliveryStreamNameAuditDestination() {
            return this.deliveryStreamNameAuditDestination;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogGroup getLogGroupAuditDestination() {
            return this.logGroupAuditDestination;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final software.amazon.awscdk.interfaces.s3.IBucketRef getS3BucketAuditDestination() {
            return this.s3BucketAuditDestination;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("identifiers", om.valueToTree(this.getIdentifiers()));
            if (this.getDeliveryStreamNameAuditDestination() != null) {
                data.set("deliveryStreamNameAuditDestination", om.valueToTree(this.getDeliveryStreamNameAuditDestination()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getLogGroupAuditDestination() != null) {
                data.set("logGroupAuditDestination", om.valueToTree(this.getLogGroupAuditDestination()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getS3BucketAuditDestination() != null) {
                data.set("s3BucketAuditDestination", om.valueToTree(this.getS3BucketAuditDestination()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.DataProtectionPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DataProtectionPolicyProps.Jsii$Proxy that = (DataProtectionPolicyProps.Jsii$Proxy) o;

            if (!identifiers.equals(that.identifiers)) return false;
            if (this.deliveryStreamNameAuditDestination != null ? !this.deliveryStreamNameAuditDestination.equals(that.deliveryStreamNameAuditDestination) : that.deliveryStreamNameAuditDestination != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.logGroupAuditDestination != null ? !this.logGroupAuditDestination.equals(that.logGroupAuditDestination) : that.logGroupAuditDestination != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            return this.s3BucketAuditDestination != null ? this.s3BucketAuditDestination.equals(that.s3BucketAuditDestination) : that.s3BucketAuditDestination == null;
        }

        @Override
        public final int hashCode() {
            int result = this.identifiers.hashCode();
            result = 31 * result + (this.deliveryStreamNameAuditDestination != null ? this.deliveryStreamNameAuditDestination.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.logGroupAuditDestination != null ? this.logGroupAuditDestination.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.s3BucketAuditDestination != null ? this.s3BucketAuditDestination.hashCode() : 0);
            return result;
        }
    }
}
