package software.amazon.awscdk.services.logs;

/**
 * Define a CloudWatch Log Group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.*;
 * LogGroup logGroup = new LogGroup(this, "Log Group");
 * Bucket logBucket = new Bucket(this, "S3 Bucket");
 * EmrContainersStartJobRun.Builder.create(this, "EMR Containers Start Job Run")
 *         .virtualCluster(VirtualClusterInput.fromVirtualClusterId("de92jdei2910fwedz"))
 *         .releaseLabel(ReleaseLabel.EMR_6_2_0)
 *         .jobDriver(JobDriver.builder()
 *                 .sparkSubmitJobDriver(SparkSubmitJobDriver.builder()
 *                         .entryPoint(TaskInput.fromText("local:///usr/lib/spark/examples/src/main/python/pi.py"))
 *                         .sparkSubmitParameters("--conf spark.executor.instances=2 --conf spark.executor.memory=2G --conf spark.executor.cores=2 --conf spark.driver.cores=1")
 *                         .build())
 *                 .build())
 *         .monitoring(Monitoring.builder()
 *                 .logGroup(logGroup)
 *                 .logBucket(logBucket)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:55.410Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.LogGroup")
public class LogGroup extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.logs.ILogGroup {

    protected LogGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LogGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.LogGroup.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LogGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.LogGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LogGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing LogGroup given its ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param logGroupArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogGroup fromLogGroupArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String logGroupArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.logs.LogGroup.class, "fromLogGroupArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(logGroupArn, "logGroupArn is required") });
    }

    /**
     * Import an existing LogGroup given its name.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param logGroupName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogGroup fromLogGroupName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String logGroupName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.logs.LogGroup.class, "fromLogGroupName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(logGroupName, "logGroupName is required") });
    }

    /**
     * Create a new Metric Filter on this Log Group.
     * <p>
     * @param id Unique identifier for the construct in its parent. This parameter is required.
     * @param props Properties for creating the MetricFilter. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.MetricFilter addMetricFilter(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.MetricFilterOptions props) {
        return software.amazon.jsii.Kernel.call(this, "addMetricFilter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.MetricFilter.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Create a new Log Stream for this Log Group.
     * <p>
     * @param id Unique identifier for the construct in its parent. This parameter is required.
     * @param props Properties for creating the LogStream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.LogStream addStream(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.StreamOptions props) {
        return software.amazon.jsii.Kernel.call(this, "addStream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.LogStream.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new Log Stream for this Log Group.
     * <p>
     * @param id Unique identifier for the construct in its parent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.LogStream addStream(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "addStream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.LogStream.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Create a new Subscription Filter on this Log Group.
     * <p>
     * @param id Unique identifier for the construct in its parent. This parameter is required.
     * @param props Properties for creating the SubscriptionFilter. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.SubscriptionFilter addSubscriptionFilter(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.SubscriptionFilterOptions props) {
        return software.amazon.jsii.Kernel.call(this, "addSubscriptionFilter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.SubscriptionFilter.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds a statement to the resource policy associated with this log group.
     * <p>
     * A resource policy will be automatically created upon the first call to <code>addToResourcePolicy</code>.
     * <p>
     * Any ARN Principals inside of the statement will be converted into AWS Account ID strings
     * because CloudWatch Logs Resource Policies do not accept ARN principals.
     * <p>
     * @param statement The policy statement to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return software.amazon.jsii.Kernel.call(this, "addToResourcePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToResourcePolicyResult.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Create a new Transformer on this Log Group.
     * <p>
     * @param id Unique identifier for the construct in its parent. This parameter is required.
     * @param props Properties for creating the Transformer. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.Transformer addTransformer(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.TransformerOptions props) {
        return software.amazon.jsii.Kernel.call(this, "addTransformer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.Transformer.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Extract a metric from structured log events in the LogGroup.
     * <p>
     * Creates a MetricFilter on this LogGroup that will extract the value
     * of the indicated JSON field in all records where it occurs.
     * <p>
     * The metric will be available in CloudWatch Metrics under the
     * indicated namespace and name.
     * <p>
     * @return A Metric object representing the extracted metric
     * @param jsonField JSON field to extract (example: '$.myfield'). This parameter is required.
     * @param metricNamespace Namespace to emit the metric under. This parameter is required.
     * @param metricName Name to emit the metric under. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric extractMetric(final @org.jetbrains.annotations.NotNull java.lang.String jsonField, final @org.jetbrains.annotations.NotNull java.lang.String metricNamespace, final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "extractMetric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(jsonField, "jsonField is required"), java.util.Objects.requireNonNull(metricNamespace, "metricNamespace is required"), java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * Give the indicated permissions on this log group and all streams.
     * <p>
     * @param grantee This parameter is required.
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Give permissions to read and filter events from this log group.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Give permissions to create and write to streams in this log group.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Public method to get the physical name of this log group.
     * <p>
     * @return Physical name of log group
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String logGroupPhysicalName() {
        return software.amazon.jsii.Kernel.call(this, "logGroupPhysicalName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Creates a CloudWatch metric for this log group.
     * <p>
     * @return A CloudWatch Metric object representing the specified metric for this log group.
     * <p>
     * This method creates a CloudWatch Metric object with predefined settings for the log group.
     * It sets the namespace to 'AWS/Logs' and the statistic to 'Sum' by default.
     * <p>
     * The created metric is automatically associated with this log group using the <code>attachTo</code> method.
     * <p>
     * Common metric names for log groups include:
     * <p>
     * <ul>
     * <li>'IncomingBytes': The volume of log data in bytes ingested into the log group.</li>
     * <li>'IncomingLogEvents': The number of log events ingested into the log group.</li>
     * </ul>
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * @param metricName <ul><li>The name of the metric to create.</li></ul> This parameter is required.
     * @param props <ul><li>Optional.</li></ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Creates a CloudWatch metric for this log group.
     * <p>
     * @return A CloudWatch Metric object representing the specified metric for this log group.
     * <p>
     * This method creates a CloudWatch Metric object with predefined settings for the log group.
     * It sets the namespace to 'AWS/Logs' and the statistic to 'Sum' by default.
     * <p>
     * The created metric is automatically associated with this log group using the <code>attachTo</code> method.
     * <p>
     * Common metric names for log groups include:
     * <p>
     * <ul>
     * <li>'IncomingBytes': The volume of log data in bytes ingested into the log group.</li>
     * <li>'IncomingLogEvents': The number of log events ingested into the log group.</li>
     * </ul>
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * @param metricName <ul><li>The name of the metric to create.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * Creates a CloudWatch metric for the volume of incoming log data in bytes to this log group.
     * <p>
     * @return A CloudWatch Metric object representing the IncomingBytes metric.
     * <p>
     * This method allows you to monitor the volume of data being ingested into the log group.
     * It's useful for understanding the size of your logs, which can impact storage costs
     * and help in identifying unexpectedly large log entries.
     * <p>
     * Example usage:
     * <p>
     * <blockquote><pre>
     * const logGroup = new logs.LogGroup(this, 'MyLogGroup');
     * logGroup.metricIncomingBytes().createAlarm(stack, 'IncomingBytesPerInstanceAlarm', {
     * threshold: 1,
     * evaluationPeriods: 1,
     * });
     * </pre></blockquote>
     * @param props <ul><li>Optional.</li></ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIncomingBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricIncomingBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Creates a CloudWatch metric for the volume of incoming log data in bytes to this log group.
     * <p>
     * @return A CloudWatch Metric object representing the IncomingBytes metric.
     * <p>
     * This method allows you to monitor the volume of data being ingested into the log group.
     * It's useful for understanding the size of your logs, which can impact storage costs
     * and help in identifying unexpectedly large log entries.
     * <p>
     * Example usage:
     * <p>
     * <blockquote><pre>
     * const logGroup = new logs.LogGroup(this, 'MyLogGroup');
     * logGroup.metricIncomingBytes().createAlarm(stack, 'IncomingBytesPerInstanceAlarm', {
     * threshold: 1,
     * evaluationPeriods: 1,
     * });
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIncomingBytes() {
        return software.amazon.jsii.Kernel.call(this, "metricIncomingBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Creates a CloudWatch metric for the number of incoming log events to this log group.
     * <p>
     * @return A CloudWatch Metric object representing the IncomingLogEvents metric.
     * <p>
     * This method allows you to monitor the rate at which log events are being ingested
     * into the log group. It's useful for understanding the volume of logging activity
     * and can help in capacity planning or detecting unusual spikes in logging.
     * <p>
     * Example usage:
     * <p>
     * <blockquote><pre>
     * const logGroup = new logs.LogGroup(this, 'MyLogGroup');
     * logGroup.metricIncomingLogEvents().createAlarm(stack, 'IncomingEventsPerInstanceAlarm', {
     * threshold: 1,
     * evaluationPeriods: 1,
     * });
     * </pre></blockquote>
     * @param props <ul><li>Optional.</li></ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIncomingLogEvents(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricIncomingLogEvents", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Creates a CloudWatch metric for the number of incoming log events to this log group.
     * <p>
     * @return A CloudWatch Metric object representing the IncomingLogEvents metric.
     * <p>
     * This method allows you to monitor the rate at which log events are being ingested
     * into the log group. It's useful for understanding the volume of logging activity
     * and can help in capacity planning or detecting unusual spikes in logging.
     * <p>
     * Example usage:
     * <p>
     * <blockquote><pre>
     * const logGroup = new logs.LogGroup(this, 'MyLogGroup');
     * logGroup.metricIncomingLogEvents().createAlarm(stack, 'IncomingEventsPerInstanceAlarm', {
     * threshold: 1,
     * evaluationPeriods: 1,
     * });
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIncomingLogEvents() {
        return software.amazon.jsii.Kernel.call(this, "metricIncomingLogEvents", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The ARN of this log group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLogGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "logGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of this log group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLogGroupName() {
        return software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.logs.LogGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.LogGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.logs.LogGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Data Protection Policy for this log group.
         * <p>
         * Default: - no data protection policy
         * <p>
         * @return {@code this}
         * @param dataProtectionPolicy Data Protection Policy for this log group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataProtectionPolicy(final software.amazon.awscdk.services.logs.DataProtectionPolicy dataProtectionPolicy) {
            this.props().dataProtectionPolicy(dataProtectionPolicy);
            return this;
        }

        /**
         * The KMS customer managed key to encrypt the log group with.
         * <p>
         * Default: Server-side encryption managed by the CloudWatch Logs service
         * <p>
         * @return {@code this}
         * @param encryptionKey The KMS customer managed key to encrypt the log group with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(final software.amazon.awscdk.interfaces.kms.IKeyRef encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        /**
         * Field Index Policies for this log group.
         * <p>
         * Default: - no field index policies for this log group.
         * <p>
         * @return {@code this}
         * @param fieldIndexPolicies Field Index Policies for this log group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fieldIndexPolicies(final java.util.List<? extends software.amazon.awscdk.services.logs.FieldIndexPolicy> fieldIndexPolicies) {
            this.props().fieldIndexPolicies(fieldIndexPolicies);
            return this;
        }

        /**
         * The class of the log group. Possible values are: STANDARD and INFREQUENT_ACCESS.
         * <p>
         * INFREQUENT_ACCESS class provides customers a cost-effective way to consolidate
         * logs which supports querying using Logs Insights. The logGroupClass property cannot
         * be changed once the log group is created.
         * <p>
         * Default: LogGroupClass.STANDARD
         * <p>
         * @return {@code this}
         * @param logGroupClass The class of the log group. Possible values are: STANDARD and INFREQUENT_ACCESS. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupClass(final software.amazon.awscdk.services.logs.LogGroupClass logGroupClass) {
            this.props().logGroupClass(logGroupClass);
            return this;
        }

        /**
         * Name of the log group.
         * <p>
         * Default: Automatically generated
         * <p>
         * @return {@code this}
         * @param logGroupName Name of the log group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupName(final java.lang.String logGroupName) {
            this.props().logGroupName(logGroupName);
            return this;
        }

        /**
         * Determine the removal policy of this log group.
         * <p>
         * Normally you want to retain the log group so you can diagnose issues
         * from logs even after a deployment that no longer includes the log group.
         * In that case, use the normal date-based retention policy to age out your
         * logs.
         * <p>
         * Default: RemovalPolicy.Retain
         * <p>
         * @return {@code this}
         * @param removalPolicy Determine the removal policy of this log group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        /**
         * How long, in days, the log contents will be retained.
         * <p>
         * To retain all logs, set this value to RetentionDays.INFINITE.
         * <p>
         * Default: RetentionDays.TWO_YEARS
         * <p>
         * @return {@code this}
         * @param retention How long, in days, the log contents will be retained. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retention(final software.amazon.awscdk.services.logs.RetentionDays retention) {
            this.props().retention(retention);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.logs.LogGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.logs.LogGroup build() {
            return new software.amazon.awscdk.services.logs.LogGroup(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.logs.LogGroupProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.logs.LogGroupProps.Builder();
            }
            return this.props;
        }
    }
}
