package software.amazon.awscdk.services.medialive;

/**
 * The AWS::MediaLive::Channel resource is a MediaLive resource type that creates a channel.
 * <p>
 * A MediaLive channel ingests and transcodes (decodes and encodes) source content from the inputs that are attached to that channel, and packages the new content into outputs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:55.616Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel")
public class CfnChannel extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.medialive.IChannelRef, software.amazon.awscdk.ITaggable {

    protected CfnChannel(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnChannel(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.medialive.CfnChannel.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::MediaLive::Channel</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnChannel(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.medialive.CfnChannelProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new <code>AWS::MediaLive::Channel</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnChannel(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Creates a new IChannelRef from an ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param arn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.medialive.IChannelRef fromChannelArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.medialive.CfnChannel.class, "fromChannelArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.medialive.IChannelRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * Creates a new IChannelRef from a channelId.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param channelId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.medialive.IChannelRef fromChannelId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String channelId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.medialive.CfnChannel.class, "fromChannelId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.medialive.IChannelRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(channelId, "channelId is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the MediaLive channel.
     * <p>
     * For example: arn:aws:medialive:us-west-1:111122223333:medialive:channel:1234567
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * User-specified id.
     * <p>
     * This is used in an output group or an output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The inputs that are attached to this channel.
     * <p>
     * The inputs are identified by their IDs (not by their names or their ARNs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrInputs() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrInputs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a Channel resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.medialive.ChannelReference getChannelRef() {
        return software.amazon.jsii.Kernel.get(this, "channelRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.medialive.ChannelReference.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.AnywhereSettingsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAnywhereSettings() {
        return software.amazon.jsii.Kernel.get(this, "anywhereSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnywhereSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "anywhereSettings", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnywhereSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.medialive.CfnChannel.AnywhereSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "anywhereSettings", value);
    }

    /**
     * Specification of CDI inputs for this channel.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.CdiInputSpecificationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCdiInputSpecification() {
        return software.amazon.jsii.Kernel.get(this, "cdiInputSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specification of CDI inputs for this channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCdiInputSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cdiInputSpecification", value);
    }

    /**
     * Specification of CDI inputs for this channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCdiInputSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.medialive.CfnChannel.CdiInputSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "cdiInputSpecification", value);
    }

    /**
     * The class for this channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getChannelClass() {
        return software.amazon.jsii.Kernel.get(this, "channelClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The class for this channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChannelClass(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "channelClass", value);
    }

    /**
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.ChannelEngineVersionRequestProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getChannelEngineVersion() {
        return software.amazon.jsii.Kernel.get(this, "channelEngineVersion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChannelEngineVersion(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "channelEngineVersion", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChannelEngineVersion(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.medialive.CfnChannel.ChannelEngineVersionRequestProperty value) {
        software.amazon.jsii.Kernel.set(this, "channelEngineVersion", value);
    }

    /**
     * The settings that identify the destination for the outputs in this MediaLive output package.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.OutputDestinationProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDestinations() {
        return software.amazon.jsii.Kernel.get(this, "destinations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The settings that identify the destination for the outputs in this MediaLive output package.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDestinations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "destinations", value);
    }

    /**
     * The settings that identify the destination for the outputs in this MediaLive output package.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDestinations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.medialive.CfnChannel.OutputDestinationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.medialive.CfnChannel.OutputDestinationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "destinations", value);
    }

    /**
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDryRun() {
        return software.amazon.jsii.Kernel.get(this, "dryRun", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDryRun(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "dryRun", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDryRun(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dryRun", value);
    }

    /**
     * The encoding configuration for the output content.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.EncoderSettingsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEncoderSettings() {
        return software.amazon.jsii.Kernel.get(this, "encoderSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The encoding configuration for the output content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncoderSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "encoderSettings", value);
    }

    /**
     * The encoding configuration for the output content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncoderSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.medialive.CfnChannel.EncoderSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "encoderSettings", value);
    }

    /**
     * The list of input attachments for the channel.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.InputAttachmentProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInputAttachments() {
        return software.amazon.jsii.Kernel.get(this, "inputAttachments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The list of input attachments for the channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputAttachments(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "inputAttachments", value);
    }

    /**
     * The list of input attachments for the channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputAttachments(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.medialive.CfnChannel.InputAttachmentProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.medialive.CfnChannel.InputAttachmentProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "inputAttachments", value);
    }

    /**
     * The input specification for this channel.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.InputSpecificationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInputSpecification() {
        return software.amazon.jsii.Kernel.get(this, "inputSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The input specification for this channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "inputSpecification", value);
    }

    /**
     * The input specification for this channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.medialive.CfnChannel.InputSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "inputSpecification", value);
    }

    /**
     * The verbosity for logging activity for this channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLogLevel() {
        return software.amazon.jsii.Kernel.get(this, "logLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The verbosity for logging activity for this channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogLevel(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "logLevel", value);
    }

    /**
     * Maintenance settings for this channel.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.MaintenanceCreateSettingsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMaintenance() {
        return software.amazon.jsii.Kernel.get(this, "maintenance", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Maintenance settings for this channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaintenance(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "maintenance", value);
    }

    /**
     * Maintenance settings for this channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaintenance(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.medialive.CfnChannel.MaintenanceCreateSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "maintenance", value);
    }

    /**
     * Name of channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Name of channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The IAM role for MediaLive to assume when running this channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IAM role for MediaLive to assume when running this channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", value);
    }

    /**
     * A collection of tags for this channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTagsRaw() {
        return software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A collection of tags for this channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * Settings to enable VPC mode in the channel, so that the endpoints for all outputs are in your VPC.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.VpcOutputSettingsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpc() {
        return software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings to enable VPC mode in the channel, so that the endpoints for all outputs are in your VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpc(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpc", value);
    }

    /**
     * Settings to enable VPC mode in the channel, so that the endpoints for all outputs are in your VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpc(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.medialive.CfnChannel.VpcOutputSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "vpc", value);
    }
    /**
     * The settings for an AAC audio encode in the output.
     * <p>
     * The parent of this entity is AudioCodecSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AacSettingsProperty aacSettingsProperty = AacSettingsProperty.builder()
     *         .bitrate(123)
     *         .codingMode("codingMode")
     *         .inputType("inputType")
     *         .profile("profile")
     *         .rateControlMode("rateControlMode")
     *         .rawFormat("rawFormat")
     *         .sampleRate(123)
     *         .spec("spec")
     *         .vbrQuality("vbrQuality")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AacSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AacSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AacSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The average bitrate in bits/second.
         * <p>
         * Valid values depend on the rate control mode and profile.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-bitrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-bitrate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBitrate() {
            return null;
        }

        /**
         * Mono, stereo, or 5.1 channel layout. Valid values depend on the rate control mode and profile. The adReceiverMix setting receives a stereo description plus control track, and emits a mono AAC encode of the description track, with control data emitted in the PES header as per ETSI TS 101 154 Annex E.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-codingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-codingmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCodingMode() {
            return null;
        }

        /**
         * Set to broadcasterMixedAd when the input contains pre-mixed main audio + AD (narration) as a stereo pair.
         * <p>
         * The Audio Type field (audioType) will be set to 3, which signals to downstream systems that this stream contains broadcaster mixed AD. Note that the input received by the encoder must contain pre-mixed audio; MediaLive does not perform the mixing. The values in audioTypeControl and audioType (in AudioDescription) are ignored when set to broadcasterMixedAd. Leave this set to normal when the input does not contain pre-mixed audio + AD.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-inputtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-inputtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputType() {
            return null;
        }

        /**
         * The AAC profile.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-profile">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-profile</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProfile() {
            return null;
        }

        /**
         * The rate control mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-ratecontrolmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-ratecontrolmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRateControlMode() {
            return null;
        }

        /**
         * Sets the LATM/LOAS AAC output for raw containers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-rawformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-rawformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRawFormat() {
            return null;
        }

        /**
         * The sample rate in Hz.
         * <p>
         * Valid values depend on the rate control mode and profile.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-samplerate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-samplerate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSampleRate() {
            return null;
        }

        /**
         * Uses MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-spec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-spec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSpec() {
            return null;
        }

        /**
         * The VBR quality level.
         * <p>
         * This is used only if rateControlMode is VBR.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-vbrquality">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-vbrquality</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVbrQuality() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AacSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AacSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AacSettingsProperty> {
            java.lang.Number bitrate;
            java.lang.String codingMode;
            java.lang.String inputType;
            java.lang.String profile;
            java.lang.String rateControlMode;
            java.lang.String rawFormat;
            java.lang.Number sampleRate;
            java.lang.String spec;
            java.lang.String vbrQuality;

            /**
             * Sets the value of {@link AacSettingsProperty#getBitrate}
             * @param bitrate The average bitrate in bits/second.
             *                Valid values depend on the rate control mode and profile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bitrate(java.lang.Number bitrate) {
                this.bitrate = bitrate;
                return this;
            }

            /**
             * Sets the value of {@link AacSettingsProperty#getCodingMode}
             * @param codingMode Mono, stereo, or 5.1 channel layout. Valid values depend on the rate control mode and profile. The adReceiverMix setting receives a stereo description plus control track, and emits a mono AAC encode of the description track, with control data emitted in the PES header as per ETSI TS 101 154 Annex E.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codingMode(java.lang.String codingMode) {
                this.codingMode = codingMode;
                return this;
            }

            /**
             * Sets the value of {@link AacSettingsProperty#getInputType}
             * @param inputType Set to broadcasterMixedAd when the input contains pre-mixed main audio + AD (narration) as a stereo pair.
             *                  The Audio Type field (audioType) will be set to 3, which signals to downstream systems that this stream contains broadcaster mixed AD. Note that the input received by the encoder must contain pre-mixed audio; MediaLive does not perform the mixing. The values in audioTypeControl and audioType (in AudioDescription) are ignored when set to broadcasterMixedAd. Leave this set to normal when the input does not contain pre-mixed audio + AD.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputType(java.lang.String inputType) {
                this.inputType = inputType;
                return this;
            }

            /**
             * Sets the value of {@link AacSettingsProperty#getProfile}
             * @param profile The AAC profile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder profile(java.lang.String profile) {
                this.profile = profile;
                return this;
            }

            /**
             * Sets the value of {@link AacSettingsProperty#getRateControlMode}
             * @param rateControlMode The rate control mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rateControlMode(java.lang.String rateControlMode) {
                this.rateControlMode = rateControlMode;
                return this;
            }

            /**
             * Sets the value of {@link AacSettingsProperty#getRawFormat}
             * @param rawFormat Sets the LATM/LOAS AAC output for raw containers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rawFormat(java.lang.String rawFormat) {
                this.rawFormat = rawFormat;
                return this;
            }

            /**
             * Sets the value of {@link AacSettingsProperty#getSampleRate}
             * @param sampleRate The sample rate in Hz.
             *                   Valid values depend on the rate control mode and profile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sampleRate(java.lang.Number sampleRate) {
                this.sampleRate = sampleRate;
                return this;
            }

            /**
             * Sets the value of {@link AacSettingsProperty#getSpec}
             * @param spec Uses MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spec(java.lang.String spec) {
                this.spec = spec;
                return this;
            }

            /**
             * Sets the value of {@link AacSettingsProperty#getVbrQuality}
             * @param vbrQuality The VBR quality level.
             *                   This is used only if rateControlMode is VBR.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vbrQuality(java.lang.String vbrQuality) {
                this.vbrQuality = vbrQuality;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AacSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AacSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AacSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AacSettingsProperty {
            private final java.lang.Number bitrate;
            private final java.lang.String codingMode;
            private final java.lang.String inputType;
            private final java.lang.String profile;
            private final java.lang.String rateControlMode;
            private final java.lang.String rawFormat;
            private final java.lang.Number sampleRate;
            private final java.lang.String spec;
            private final java.lang.String vbrQuality;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bitrate = software.amazon.jsii.Kernel.get(this, "bitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.codingMode = software.amazon.jsii.Kernel.get(this, "codingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputType = software.amazon.jsii.Kernel.get(this, "inputType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.profile = software.amazon.jsii.Kernel.get(this, "profile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rateControlMode = software.amazon.jsii.Kernel.get(this, "rateControlMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rawFormat = software.amazon.jsii.Kernel.get(this, "rawFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sampleRate = software.amazon.jsii.Kernel.get(this, "sampleRate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.spec = software.amazon.jsii.Kernel.get(this, "spec", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vbrQuality = software.amazon.jsii.Kernel.get(this, "vbrQuality", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bitrate = builder.bitrate;
                this.codingMode = builder.codingMode;
                this.inputType = builder.inputType;
                this.profile = builder.profile;
                this.rateControlMode = builder.rateControlMode;
                this.rawFormat = builder.rawFormat;
                this.sampleRate = builder.sampleRate;
                this.spec = builder.spec;
                this.vbrQuality = builder.vbrQuality;
            }

            @Override
            public final java.lang.Number getBitrate() {
                return this.bitrate;
            }

            @Override
            public final java.lang.String getCodingMode() {
                return this.codingMode;
            }

            @Override
            public final java.lang.String getInputType() {
                return this.inputType;
            }

            @Override
            public final java.lang.String getProfile() {
                return this.profile;
            }

            @Override
            public final java.lang.String getRateControlMode() {
                return this.rateControlMode;
            }

            @Override
            public final java.lang.String getRawFormat() {
                return this.rawFormat;
            }

            @Override
            public final java.lang.Number getSampleRate() {
                return this.sampleRate;
            }

            @Override
            public final java.lang.String getSpec() {
                return this.spec;
            }

            @Override
            public final java.lang.String getVbrQuality() {
                return this.vbrQuality;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBitrate() != null) {
                    data.set("bitrate", om.valueToTree(this.getBitrate()));
                }
                if (this.getCodingMode() != null) {
                    data.set("codingMode", om.valueToTree(this.getCodingMode()));
                }
                if (this.getInputType() != null) {
                    data.set("inputType", om.valueToTree(this.getInputType()));
                }
                if (this.getProfile() != null) {
                    data.set("profile", om.valueToTree(this.getProfile()));
                }
                if (this.getRateControlMode() != null) {
                    data.set("rateControlMode", om.valueToTree(this.getRateControlMode()));
                }
                if (this.getRawFormat() != null) {
                    data.set("rawFormat", om.valueToTree(this.getRawFormat()));
                }
                if (this.getSampleRate() != null) {
                    data.set("sampleRate", om.valueToTree(this.getSampleRate()));
                }
                if (this.getSpec() != null) {
                    data.set("spec", om.valueToTree(this.getSpec()));
                }
                if (this.getVbrQuality() != null) {
                    data.set("vbrQuality", om.valueToTree(this.getVbrQuality()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AacSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AacSettingsProperty.Jsii$Proxy that = (AacSettingsProperty.Jsii$Proxy) o;

                if (this.bitrate != null ? !this.bitrate.equals(that.bitrate) : that.bitrate != null) return false;
                if (this.codingMode != null ? !this.codingMode.equals(that.codingMode) : that.codingMode != null) return false;
                if (this.inputType != null ? !this.inputType.equals(that.inputType) : that.inputType != null) return false;
                if (this.profile != null ? !this.profile.equals(that.profile) : that.profile != null) return false;
                if (this.rateControlMode != null ? !this.rateControlMode.equals(that.rateControlMode) : that.rateControlMode != null) return false;
                if (this.rawFormat != null ? !this.rawFormat.equals(that.rawFormat) : that.rawFormat != null) return false;
                if (this.sampleRate != null ? !this.sampleRate.equals(that.sampleRate) : that.sampleRate != null) return false;
                if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) return false;
                return this.vbrQuality != null ? this.vbrQuality.equals(that.vbrQuality) : that.vbrQuality == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bitrate != null ? this.bitrate.hashCode() : 0;
                result = 31 * result + (this.codingMode != null ? this.codingMode.hashCode() : 0);
                result = 31 * result + (this.inputType != null ? this.inputType.hashCode() : 0);
                result = 31 * result + (this.profile != null ? this.profile.hashCode() : 0);
                result = 31 * result + (this.rateControlMode != null ? this.rateControlMode.hashCode() : 0);
                result = 31 * result + (this.rawFormat != null ? this.rawFormat.hashCode() : 0);
                result = 31 * result + (this.sampleRate != null ? this.sampleRate.hashCode() : 0);
                result = 31 * result + (this.spec != null ? this.spec.hashCode() : 0);
                result = 31 * result + (this.vbrQuality != null ? this.vbrQuality.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for an AC3 audio encode in the output.
     * <p>
     * The parent of this entity is AudioCodecSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * Ac3SettingsProperty ac3SettingsProperty = Ac3SettingsProperty.builder()
     *         .attenuationControl("attenuationControl")
     *         .bitrate(123)
     *         .bitstreamMode("bitstreamMode")
     *         .codingMode("codingMode")
     *         .dialnorm(123)
     *         .drcProfile("drcProfile")
     *         .lfeFilter("lfeFilter")
     *         .metadataControl("metadataControl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.Ac3SettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(Ac3SettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Ac3SettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-attenuationcontrol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-attenuationcontrol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAttenuationControl() {
            return null;
        }

        /**
         * The average bitrate in bits/second.
         * <p>
         * Valid bitrates depend on the coding mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-bitrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-bitrate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBitrate() {
            return null;
        }

        /**
         * Specifies the bitstream mode (bsmod) for the emitted AC-3 stream.
         * <p>
         * For more information about these values, see ATSC A/52-2012.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-bitstreammode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-bitstreammode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBitstreamMode() {
            return null;
        }

        /**
         * The Dolby Digital coding mode.
         * <p>
         * This determines the number of channels.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-codingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-codingmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCodingMode() {
            return null;
        }

        /**
         * Sets the dialnorm for the output.
         * <p>
         * If excluded and the input audio is Dolby Digital, dialnorm is passed through.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-dialnorm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-dialnorm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDialnorm() {
            return null;
        }

        /**
         * If set to filmStandard, adds dynamic range compression signaling to the output bitstream as defined in the Dolby Digital specification.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-drcprofile">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-drcprofile</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDrcProfile() {
            return null;
        }

        /**
         * When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding.
         * <p>
         * This is valid only in codingMode32Lfe mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-lfefilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-lfefilter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLfeFilter() {
            return null;
        }

        /**
         * When set to followInput, encoder metadata is sourced from the DD, DD+, or DolbyE decoder that supplies this audio data.
         * <p>
         * If the audio is supplied from one of these streams, the static metadata settings are used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-metadatacontrol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-metadatacontrol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetadataControl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Ac3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Ac3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Ac3SettingsProperty> {
            java.lang.String attenuationControl;
            java.lang.Number bitrate;
            java.lang.String bitstreamMode;
            java.lang.String codingMode;
            java.lang.Number dialnorm;
            java.lang.String drcProfile;
            java.lang.String lfeFilter;
            java.lang.String metadataControl;

            /**
             * Sets the value of {@link Ac3SettingsProperty#getAttenuationControl}
             * @param attenuationControl the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attenuationControl(java.lang.String attenuationControl) {
                this.attenuationControl = attenuationControl;
                return this;
            }

            /**
             * Sets the value of {@link Ac3SettingsProperty#getBitrate}
             * @param bitrate The average bitrate in bits/second.
             *                Valid bitrates depend on the coding mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bitrate(java.lang.Number bitrate) {
                this.bitrate = bitrate;
                return this;
            }

            /**
             * Sets the value of {@link Ac3SettingsProperty#getBitstreamMode}
             * @param bitstreamMode Specifies the bitstream mode (bsmod) for the emitted AC-3 stream.
             *                      For more information about these values, see ATSC A/52-2012.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bitstreamMode(java.lang.String bitstreamMode) {
                this.bitstreamMode = bitstreamMode;
                return this;
            }

            /**
             * Sets the value of {@link Ac3SettingsProperty#getCodingMode}
             * @param codingMode The Dolby Digital coding mode.
             *                   This determines the number of channels.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codingMode(java.lang.String codingMode) {
                this.codingMode = codingMode;
                return this;
            }

            /**
             * Sets the value of {@link Ac3SettingsProperty#getDialnorm}
             * @param dialnorm Sets the dialnorm for the output.
             *                 If excluded and the input audio is Dolby Digital, dialnorm is passed through.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dialnorm(java.lang.Number dialnorm) {
                this.dialnorm = dialnorm;
                return this;
            }

            /**
             * Sets the value of {@link Ac3SettingsProperty#getDrcProfile}
             * @param drcProfile If set to filmStandard, adds dynamic range compression signaling to the output bitstream as defined in the Dolby Digital specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder drcProfile(java.lang.String drcProfile) {
                this.drcProfile = drcProfile;
                return this;
            }

            /**
             * Sets the value of {@link Ac3SettingsProperty#getLfeFilter}
             * @param lfeFilter When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding.
             *                  This is valid only in codingMode32Lfe mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lfeFilter(java.lang.String lfeFilter) {
                this.lfeFilter = lfeFilter;
                return this;
            }

            /**
             * Sets the value of {@link Ac3SettingsProperty#getMetadataControl}
             * @param metadataControl When set to followInput, encoder metadata is sourced from the DD, DD+, or DolbyE decoder that supplies this audio data.
             *                        If the audio is supplied from one of these streams, the static metadata settings are used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadataControl(java.lang.String metadataControl) {
                this.metadataControl = metadataControl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Ac3SettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Ac3SettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Ac3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Ac3SettingsProperty {
            private final java.lang.String attenuationControl;
            private final java.lang.Number bitrate;
            private final java.lang.String bitstreamMode;
            private final java.lang.String codingMode;
            private final java.lang.Number dialnorm;
            private final java.lang.String drcProfile;
            private final java.lang.String lfeFilter;
            private final java.lang.String metadataControl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attenuationControl = software.amazon.jsii.Kernel.get(this, "attenuationControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bitrate = software.amazon.jsii.Kernel.get(this, "bitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.bitstreamMode = software.amazon.jsii.Kernel.get(this, "bitstreamMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.codingMode = software.amazon.jsii.Kernel.get(this, "codingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dialnorm = software.amazon.jsii.Kernel.get(this, "dialnorm", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.drcProfile = software.amazon.jsii.Kernel.get(this, "drcProfile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lfeFilter = software.amazon.jsii.Kernel.get(this, "lfeFilter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metadataControl = software.amazon.jsii.Kernel.get(this, "metadataControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attenuationControl = builder.attenuationControl;
                this.bitrate = builder.bitrate;
                this.bitstreamMode = builder.bitstreamMode;
                this.codingMode = builder.codingMode;
                this.dialnorm = builder.dialnorm;
                this.drcProfile = builder.drcProfile;
                this.lfeFilter = builder.lfeFilter;
                this.metadataControl = builder.metadataControl;
            }

            @Override
            public final java.lang.String getAttenuationControl() {
                return this.attenuationControl;
            }

            @Override
            public final java.lang.Number getBitrate() {
                return this.bitrate;
            }

            @Override
            public final java.lang.String getBitstreamMode() {
                return this.bitstreamMode;
            }

            @Override
            public final java.lang.String getCodingMode() {
                return this.codingMode;
            }

            @Override
            public final java.lang.Number getDialnorm() {
                return this.dialnorm;
            }

            @Override
            public final java.lang.String getDrcProfile() {
                return this.drcProfile;
            }

            @Override
            public final java.lang.String getLfeFilter() {
                return this.lfeFilter;
            }

            @Override
            public final java.lang.String getMetadataControl() {
                return this.metadataControl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttenuationControl() != null) {
                    data.set("attenuationControl", om.valueToTree(this.getAttenuationControl()));
                }
                if (this.getBitrate() != null) {
                    data.set("bitrate", om.valueToTree(this.getBitrate()));
                }
                if (this.getBitstreamMode() != null) {
                    data.set("bitstreamMode", om.valueToTree(this.getBitstreamMode()));
                }
                if (this.getCodingMode() != null) {
                    data.set("codingMode", om.valueToTree(this.getCodingMode()));
                }
                if (this.getDialnorm() != null) {
                    data.set("dialnorm", om.valueToTree(this.getDialnorm()));
                }
                if (this.getDrcProfile() != null) {
                    data.set("drcProfile", om.valueToTree(this.getDrcProfile()));
                }
                if (this.getLfeFilter() != null) {
                    data.set("lfeFilter", om.valueToTree(this.getLfeFilter()));
                }
                if (this.getMetadataControl() != null) {
                    data.set("metadataControl", om.valueToTree(this.getMetadataControl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.Ac3SettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Ac3SettingsProperty.Jsii$Proxy that = (Ac3SettingsProperty.Jsii$Proxy) o;

                if (this.attenuationControl != null ? !this.attenuationControl.equals(that.attenuationControl) : that.attenuationControl != null) return false;
                if (this.bitrate != null ? !this.bitrate.equals(that.bitrate) : that.bitrate != null) return false;
                if (this.bitstreamMode != null ? !this.bitstreamMode.equals(that.bitstreamMode) : that.bitstreamMode != null) return false;
                if (this.codingMode != null ? !this.codingMode.equals(that.codingMode) : that.codingMode != null) return false;
                if (this.dialnorm != null ? !this.dialnorm.equals(that.dialnorm) : that.dialnorm != null) return false;
                if (this.drcProfile != null ? !this.drcProfile.equals(that.drcProfile) : that.drcProfile != null) return false;
                if (this.lfeFilter != null ? !this.lfeFilter.equals(that.lfeFilter) : that.lfeFilter != null) return false;
                return this.metadataControl != null ? this.metadataControl.equals(that.metadataControl) : that.metadataControl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attenuationControl != null ? this.attenuationControl.hashCode() : 0;
                result = 31 * result + (this.bitrate != null ? this.bitrate.hashCode() : 0);
                result = 31 * result + (this.bitstreamMode != null ? this.bitstreamMode.hashCode() : 0);
                result = 31 * result + (this.codingMode != null ? this.codingMode.hashCode() : 0);
                result = 31 * result + (this.dialnorm != null ? this.dialnorm.hashCode() : 0);
                result = 31 * result + (this.drcProfile != null ? this.drcProfile.hashCode() : 0);
                result = 31 * result + (this.lfeFilter != null ? this.lfeFilter.hashCode() : 0);
                result = 31 * result + (this.metadataControl != null ? this.metadataControl.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AdditionalDestinationsProperty additionalDestinationsProperty = AdditionalDestinationsProperty.builder()
     *         .destination(OutputLocationRefProperty.builder()
     *                 .destinationRefId("destinationRefId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-additionaldestinations.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-additionaldestinations.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AdditionalDestinationsProperty")
    @software.amazon.jsii.Jsii.Proxy(AdditionalDestinationsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdditionalDestinationsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.OutputLocationRefProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-additionaldestinations.html#cfn-medialive-channel-additionaldestinations-destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-additionaldestinations.html#cfn-medialive-channel-additionaldestinations-destination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestination() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdditionalDestinationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdditionalDestinationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdditionalDestinationsProperty> {
            java.lang.Object destination;

            /**
             * Sets the value of {@link AdditionalDestinationsProperty#getDestination}
             * @param destination the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link AdditionalDestinationsProperty#getDestination}
             * @param destination the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.services.medialive.CfnChannel.OutputLocationRefProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdditionalDestinationsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdditionalDestinationsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdditionalDestinationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdditionalDestinationsProperty {
            private final java.lang.Object destination;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = builder.destination;
            }

            @Override
            public final java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestination() != null) {
                    data.set("destination", om.valueToTree(this.getDestination()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AdditionalDestinationsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdditionalDestinationsProperty.Jsii$Proxy that = (AdditionalDestinationsProperty.Jsii$Proxy) o;

                return this.destination != null ? this.destination.equals(that.destination) : that.destination == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destination != null ? this.destination.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Information about the ancillary captions to extract from the input.
     * <p>
     * The parent of this entity is CaptionSelectorSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AncillarySourceSettingsProperty ancillarySourceSettingsProperty = AncillarySourceSettingsProperty.builder()
     *         .sourceAncillaryChannelNumber(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ancillarysourcesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ancillarysourcesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AncillarySourceSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AncillarySourceSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AncillarySourceSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the number (1 to 4) of the captions channel you want to extract from the ancillary captions.
         * <p>
         * If you plan to convert the ancillary captions to another format, complete this field. If you plan to choose Embedded as the captions destination in the output (to pass through all the channels in the ancillary captions), leave this field blank because MediaLive ignores the field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ancillarysourcesettings.html#cfn-medialive-channel-ancillarysourcesettings-sourceancillarychannelnumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ancillarysourcesettings.html#cfn-medialive-channel-ancillarysourcesettings-sourceancillarychannelnumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSourceAncillaryChannelNumber() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AncillarySourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AncillarySourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AncillarySourceSettingsProperty> {
            java.lang.Number sourceAncillaryChannelNumber;

            /**
             * Sets the value of {@link AncillarySourceSettingsProperty#getSourceAncillaryChannelNumber}
             * @param sourceAncillaryChannelNumber Specifies the number (1 to 4) of the captions channel you want to extract from the ancillary captions.
             *                                     If you plan to convert the ancillary captions to another format, complete this field. If you plan to choose Embedded as the captions destination in the output (to pass through all the channels in the ancillary captions), leave this field blank because MediaLive ignores the field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceAncillaryChannelNumber(java.lang.Number sourceAncillaryChannelNumber) {
                this.sourceAncillaryChannelNumber = sourceAncillaryChannelNumber;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AncillarySourceSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AncillarySourceSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AncillarySourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AncillarySourceSettingsProperty {
            private final java.lang.Number sourceAncillaryChannelNumber;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceAncillaryChannelNumber = software.amazon.jsii.Kernel.get(this, "sourceAncillaryChannelNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceAncillaryChannelNumber = builder.sourceAncillaryChannelNumber;
            }

            @Override
            public final java.lang.Number getSourceAncillaryChannelNumber() {
                return this.sourceAncillaryChannelNumber;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSourceAncillaryChannelNumber() != null) {
                    data.set("sourceAncillaryChannelNumber", om.valueToTree(this.getSourceAncillaryChannelNumber()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AncillarySourceSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AncillarySourceSettingsProperty.Jsii$Proxy that = (AncillarySourceSettingsProperty.Jsii$Proxy) o;

                return this.sourceAncillaryChannelNumber != null ? this.sourceAncillaryChannelNumber.equals(that.sourceAncillaryChannelNumber) : that.sourceAncillaryChannelNumber == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceAncillaryChannelNumber != null ? this.sourceAncillaryChannelNumber.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AnywhereSettingsProperty anywhereSettingsProperty = AnywhereSettingsProperty.builder()
     *         .channelPlacementGroupId("channelPlacementGroupId")
     *         .clusterId("clusterId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-anywheresettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-anywheresettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AnywhereSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AnywhereSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnywhereSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-anywheresettings.html#cfn-medialive-channel-anywheresettings-channelplacementgroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-anywheresettings.html#cfn-medialive-channel-anywheresettings-channelplacementgroupid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getChannelPlacementGroupId() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-anywheresettings.html#cfn-medialive-channel-anywheresettings-clusterid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-anywheresettings.html#cfn-medialive-channel-anywheresettings-clusterid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClusterId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnywhereSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnywhereSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnywhereSettingsProperty> {
            java.lang.String channelPlacementGroupId;
            java.lang.String clusterId;

            /**
             * Sets the value of {@link AnywhereSettingsProperty#getChannelPlacementGroupId}
             * @param channelPlacementGroupId the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder channelPlacementGroupId(java.lang.String channelPlacementGroupId) {
                this.channelPlacementGroupId = channelPlacementGroupId;
                return this;
            }

            /**
             * Sets the value of {@link AnywhereSettingsProperty#getClusterId}
             * @param clusterId the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterId(java.lang.String clusterId) {
                this.clusterId = clusterId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnywhereSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnywhereSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnywhereSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnywhereSettingsProperty {
            private final java.lang.String channelPlacementGroupId;
            private final java.lang.String clusterId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.channelPlacementGroupId = software.amazon.jsii.Kernel.get(this, "channelPlacementGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clusterId = software.amazon.jsii.Kernel.get(this, "clusterId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.channelPlacementGroupId = builder.channelPlacementGroupId;
                this.clusterId = builder.clusterId;
            }

            @Override
            public final java.lang.String getChannelPlacementGroupId() {
                return this.channelPlacementGroupId;
            }

            @Override
            public final java.lang.String getClusterId() {
                return this.clusterId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getChannelPlacementGroupId() != null) {
                    data.set("channelPlacementGroupId", om.valueToTree(this.getChannelPlacementGroupId()));
                }
                if (this.getClusterId() != null) {
                    data.set("clusterId", om.valueToTree(this.getClusterId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AnywhereSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnywhereSettingsProperty.Jsii$Proxy that = (AnywhereSettingsProperty.Jsii$Proxy) o;

                if (this.channelPlacementGroupId != null ? !this.channelPlacementGroupId.equals(that.channelPlacementGroupId) : that.channelPlacementGroupId != null) return false;
                return this.clusterId != null ? this.clusterId.equals(that.clusterId) : that.clusterId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.channelPlacementGroupId != null ? this.channelPlacementGroupId.hashCode() : 0;
                result = 31 * result + (this.clusterId != null ? this.clusterId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings to configure the destination of an Archive output.
     * <p>
     * The parent of this entity is ArchiveGroupSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * ArchiveCdnSettingsProperty archiveCdnSettingsProperty = ArchiveCdnSettingsProperty.builder()
     *         .archiveS3Settings(ArchiveS3SettingsProperty.builder()
     *                 .cannedAcl("cannedAcl")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivecdnsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivecdnsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.ArchiveCdnSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ArchiveCdnSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArchiveCdnSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Sets up Amazon S3 as the destination for this Archive output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.ArchiveS3SettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivecdnsettings.html#cfn-medialive-channel-archivecdnsettings-archives3settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivecdnsettings.html#cfn-medialive-channel-archivecdnsettings-archives3settings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getArchiveS3Settings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ArchiveCdnSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArchiveCdnSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArchiveCdnSettingsProperty> {
            java.lang.Object archiveS3Settings;

            /**
             * Sets the value of {@link ArchiveCdnSettingsProperty#getArchiveS3Settings}
             * @param archiveS3Settings Sets up Amazon S3 as the destination for this Archive output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder archiveS3Settings(software.amazon.awscdk.IResolvable archiveS3Settings) {
                this.archiveS3Settings = archiveS3Settings;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveCdnSettingsProperty#getArchiveS3Settings}
             * @param archiveS3Settings Sets up Amazon S3 as the destination for this Archive output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder archiveS3Settings(software.amazon.awscdk.services.medialive.CfnChannel.ArchiveS3SettingsProperty archiveS3Settings) {
                this.archiveS3Settings = archiveS3Settings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArchiveCdnSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArchiveCdnSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArchiveCdnSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArchiveCdnSettingsProperty {
            private final java.lang.Object archiveS3Settings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.archiveS3Settings = software.amazon.jsii.Kernel.get(this, "archiveS3Settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.archiveS3Settings = builder.archiveS3Settings;
            }

            @Override
            public final java.lang.Object getArchiveS3Settings() {
                return this.archiveS3Settings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArchiveS3Settings() != null) {
                    data.set("archiveS3Settings", om.valueToTree(this.getArchiveS3Settings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.ArchiveCdnSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArchiveCdnSettingsProperty.Jsii$Proxy that = (ArchiveCdnSettingsProperty.Jsii$Proxy) o;

                return this.archiveS3Settings != null ? this.archiveS3Settings.equals(that.archiveS3Settings) : that.archiveS3Settings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.archiveS3Settings != null ? this.archiveS3Settings.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The archive container settings.
     * <p>
     * The parent of this entity is ArchiveOutputSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * ArchiveContainerSettingsProperty archiveContainerSettingsProperty = ArchiveContainerSettingsProperty.builder()
     *         .m2TsSettings(M2tsSettingsProperty.builder()
     *                 .absentInputAudioBehavior("absentInputAudioBehavior")
     *                 .arib("arib")
     *                 .aribCaptionsPid("aribCaptionsPid")
     *                 .aribCaptionsPidControl("aribCaptionsPidControl")
     *                 .audioBufferModel("audioBufferModel")
     *                 .audioFramesPerPes(123)
     *                 .audioPids("audioPids")
     *                 .audioStreamType("audioStreamType")
     *                 .bitrate(123)
     *                 .bufferModel("bufferModel")
     *                 .ccDescriptor("ccDescriptor")
     *                 .dvbNitSettings(DvbNitSettingsProperty.builder()
     *                         .networkId(123)
     *                         .networkName("networkName")
     *                         .repInterval(123)
     *                         .build())
     *                 .dvbSdtSettings(DvbSdtSettingsProperty.builder()
     *                         .outputSdt("outputSdt")
     *                         .repInterval(123)
     *                         .serviceName("serviceName")
     *                         .serviceProviderName("serviceProviderName")
     *                         .build())
     *                 .dvbSubPids("dvbSubPids")
     *                 .dvbTdtSettings(DvbTdtSettingsProperty.builder()
     *                         .repInterval(123)
     *                         .build())
     *                 .dvbTeletextPid("dvbTeletextPid")
     *                 .ebif("ebif")
     *                 .ebpAudioInterval("ebpAudioInterval")
     *                 .ebpLookaheadMs(123)
     *                 .ebpPlacement("ebpPlacement")
     *                 .ecmPid("ecmPid")
     *                 .esRateInPes("esRateInPes")
     *                 .etvPlatformPid("etvPlatformPid")
     *                 .etvSignalPid("etvSignalPid")
     *                 .fragmentTime(123)
     *                 .klv("klv")
     *                 .klvDataPids("klvDataPids")
     *                 .nielsenId3Behavior("nielsenId3Behavior")
     *                 .nullPacketBitrate(123)
     *                 .patInterval(123)
     *                 .pcrControl("pcrControl")
     *                 .pcrPeriod(123)
     *                 .pcrPid("pcrPid")
     *                 .pmtInterval(123)
     *                 .pmtPid("pmtPid")
     *                 .programNum(123)
     *                 .rateMode("rateMode")
     *                 .scte27Pids("scte27Pids")
     *                 .scte35Control("scte35Control")
     *                 .scte35Pid("scte35Pid")
     *                 .scte35PrerollPullupMilliseconds(123)
     *                 .segmentationMarkers("segmentationMarkers")
     *                 .segmentationStyle("segmentationStyle")
     *                 .segmentationTime(123)
     *                 .timedMetadataBehavior("timedMetadataBehavior")
     *                 .timedMetadataPid("timedMetadataPid")
     *                 .transportStreamId(123)
     *                 .videoPid("videoPid")
     *                 .build())
     *         .rawSettings(RawSettingsProperty.builder().build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivecontainersettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivecontainersettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.ArchiveContainerSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ArchiveContainerSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArchiveContainerSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The settings for the M2TS in the archive output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.M2tsSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivecontainersettings.html#cfn-medialive-channel-archivecontainersettings-m2tssettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivecontainersettings.html#cfn-medialive-channel-archivecontainersettings-m2tssettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getM2TsSettings() {
            return null;
        }

        /**
         * The settings for Raw archive output type.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.RawSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivecontainersettings.html#cfn-medialive-channel-archivecontainersettings-rawsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivecontainersettings.html#cfn-medialive-channel-archivecontainersettings-rawsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRawSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ArchiveContainerSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArchiveContainerSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArchiveContainerSettingsProperty> {
            java.lang.Object m2TsSettings;
            java.lang.Object rawSettings;

            /**
             * Sets the value of {@link ArchiveContainerSettingsProperty#getM2TsSettings}
             * @param m2TsSettings The settings for the M2TS in the archive output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder m2TsSettings(software.amazon.awscdk.IResolvable m2TsSettings) {
                this.m2TsSettings = m2TsSettings;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveContainerSettingsProperty#getM2TsSettings}
             * @param m2TsSettings The settings for the M2TS in the archive output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder m2TsSettings(software.amazon.awscdk.services.medialive.CfnChannel.M2tsSettingsProperty m2TsSettings) {
                this.m2TsSettings = m2TsSettings;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveContainerSettingsProperty#getRawSettings}
             * @param rawSettings The settings for Raw archive output type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rawSettings(software.amazon.awscdk.IResolvable rawSettings) {
                this.rawSettings = rawSettings;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveContainerSettingsProperty#getRawSettings}
             * @param rawSettings The settings for Raw archive output type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rawSettings(software.amazon.awscdk.services.medialive.CfnChannel.RawSettingsProperty rawSettings) {
                this.rawSettings = rawSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArchiveContainerSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArchiveContainerSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArchiveContainerSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArchiveContainerSettingsProperty {
            private final java.lang.Object m2TsSettings;
            private final java.lang.Object rawSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.m2TsSettings = software.amazon.jsii.Kernel.get(this, "m2TsSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rawSettings = software.amazon.jsii.Kernel.get(this, "rawSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.m2TsSettings = builder.m2TsSettings;
                this.rawSettings = builder.rawSettings;
            }

            @Override
            public final java.lang.Object getM2TsSettings() {
                return this.m2TsSettings;
            }

            @Override
            public final java.lang.Object getRawSettings() {
                return this.rawSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getM2TsSettings() != null) {
                    data.set("m2TsSettings", om.valueToTree(this.getM2TsSettings()));
                }
                if (this.getRawSettings() != null) {
                    data.set("rawSettings", om.valueToTree(this.getRawSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.ArchiveContainerSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArchiveContainerSettingsProperty.Jsii$Proxy that = (ArchiveContainerSettingsProperty.Jsii$Proxy) o;

                if (this.m2TsSettings != null ? !this.m2TsSettings.equals(that.m2TsSettings) : that.m2TsSettings != null) return false;
                return this.rawSettings != null ? this.rawSettings.equals(that.rawSettings) : that.rawSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.m2TsSettings != null ? this.m2TsSettings.hashCode() : 0;
                result = 31 * result + (this.rawSettings != null ? this.rawSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for an archive output group.
     * <p>
     * The parent of this entity is OutputGroupSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * ArchiveGroupSettingsProperty archiveGroupSettingsProperty = ArchiveGroupSettingsProperty.builder()
     *         .archiveCdnSettings(ArchiveCdnSettingsProperty.builder()
     *                 .archiveS3Settings(ArchiveS3SettingsProperty.builder()
     *                         .cannedAcl("cannedAcl")
     *                         .build())
     *                 .build())
     *         .destination(OutputLocationRefProperty.builder()
     *                 .destinationRefId("destinationRefId")
     *                 .build())
     *         .rolloverInterval(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivegroupsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivegroupsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.ArchiveGroupSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ArchiveGroupSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArchiveGroupSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Settings to configure the destination of an Archive output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.ArchiveCdnSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivegroupsettings.html#cfn-medialive-channel-archivegroupsettings-archivecdnsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivegroupsettings.html#cfn-medialive-channel-archivegroupsettings-archivecdnsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getArchiveCdnSettings() {
            return null;
        }

        /**
         * A directory and base file name where archive files should be written.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.OutputLocationRefProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivegroupsettings.html#cfn-medialive-channel-archivegroupsettings-destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivegroupsettings.html#cfn-medialive-channel-archivegroupsettings-destination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestination() {
            return null;
        }

        /**
         * The number of seconds to write to an archive file before closing and starting a new one.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivegroupsettings.html#cfn-medialive-channel-archivegroupsettings-rolloverinterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivegroupsettings.html#cfn-medialive-channel-archivegroupsettings-rolloverinterval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRolloverInterval() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ArchiveGroupSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArchiveGroupSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArchiveGroupSettingsProperty> {
            java.lang.Object archiveCdnSettings;
            java.lang.Object destination;
            java.lang.Number rolloverInterval;

            /**
             * Sets the value of {@link ArchiveGroupSettingsProperty#getArchiveCdnSettings}
             * @param archiveCdnSettings Settings to configure the destination of an Archive output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder archiveCdnSettings(software.amazon.awscdk.IResolvable archiveCdnSettings) {
                this.archiveCdnSettings = archiveCdnSettings;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveGroupSettingsProperty#getArchiveCdnSettings}
             * @param archiveCdnSettings Settings to configure the destination of an Archive output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder archiveCdnSettings(software.amazon.awscdk.services.medialive.CfnChannel.ArchiveCdnSettingsProperty archiveCdnSettings) {
                this.archiveCdnSettings = archiveCdnSettings;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveGroupSettingsProperty#getDestination}
             * @param destination A directory and base file name where archive files should be written.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveGroupSettingsProperty#getDestination}
             * @param destination A directory and base file name where archive files should be written.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.services.medialive.CfnChannel.OutputLocationRefProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveGroupSettingsProperty#getRolloverInterval}
             * @param rolloverInterval The number of seconds to write to an archive file before closing and starting a new one.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rolloverInterval(java.lang.Number rolloverInterval) {
                this.rolloverInterval = rolloverInterval;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArchiveGroupSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArchiveGroupSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArchiveGroupSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArchiveGroupSettingsProperty {
            private final java.lang.Object archiveCdnSettings;
            private final java.lang.Object destination;
            private final java.lang.Number rolloverInterval;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.archiveCdnSettings = software.amazon.jsii.Kernel.get(this, "archiveCdnSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rolloverInterval = software.amazon.jsii.Kernel.get(this, "rolloverInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.archiveCdnSettings = builder.archiveCdnSettings;
                this.destination = builder.destination;
                this.rolloverInterval = builder.rolloverInterval;
            }

            @Override
            public final java.lang.Object getArchiveCdnSettings() {
                return this.archiveCdnSettings;
            }

            @Override
            public final java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.Number getRolloverInterval() {
                return this.rolloverInterval;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArchiveCdnSettings() != null) {
                    data.set("archiveCdnSettings", om.valueToTree(this.getArchiveCdnSettings()));
                }
                if (this.getDestination() != null) {
                    data.set("destination", om.valueToTree(this.getDestination()));
                }
                if (this.getRolloverInterval() != null) {
                    data.set("rolloverInterval", om.valueToTree(this.getRolloverInterval()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.ArchiveGroupSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArchiveGroupSettingsProperty.Jsii$Proxy that = (ArchiveGroupSettingsProperty.Jsii$Proxy) o;

                if (this.archiveCdnSettings != null ? !this.archiveCdnSettings.equals(that.archiveCdnSettings) : that.archiveCdnSettings != null) return false;
                if (this.destination != null ? !this.destination.equals(that.destination) : that.destination != null) return false;
                return this.rolloverInterval != null ? this.rolloverInterval.equals(that.rolloverInterval) : that.rolloverInterval == null;
            }

            @Override
            public final int hashCode() {
                int result = this.archiveCdnSettings != null ? this.archiveCdnSettings.hashCode() : 0;
                result = 31 * result + (this.destination != null ? this.destination.hashCode() : 0);
                result = 31 * result + (this.rolloverInterval != null ? this.rolloverInterval.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The archive output settings.
     * <p>
     * The parent of this entity is OutputSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * ArchiveOutputSettingsProperty archiveOutputSettingsProperty = ArchiveOutputSettingsProperty.builder()
     *         .containerSettings(ArchiveContainerSettingsProperty.builder()
     *                 .m2TsSettings(M2tsSettingsProperty.builder()
     *                         .absentInputAudioBehavior("absentInputAudioBehavior")
     *                         .arib("arib")
     *                         .aribCaptionsPid("aribCaptionsPid")
     *                         .aribCaptionsPidControl("aribCaptionsPidControl")
     *                         .audioBufferModel("audioBufferModel")
     *                         .audioFramesPerPes(123)
     *                         .audioPids("audioPids")
     *                         .audioStreamType("audioStreamType")
     *                         .bitrate(123)
     *                         .bufferModel("bufferModel")
     *                         .ccDescriptor("ccDescriptor")
     *                         .dvbNitSettings(DvbNitSettingsProperty.builder()
     *                                 .networkId(123)
     *                                 .networkName("networkName")
     *                                 .repInterval(123)
     *                                 .build())
     *                         .dvbSdtSettings(DvbSdtSettingsProperty.builder()
     *                                 .outputSdt("outputSdt")
     *                                 .repInterval(123)
     *                                 .serviceName("serviceName")
     *                                 .serviceProviderName("serviceProviderName")
     *                                 .build())
     *                         .dvbSubPids("dvbSubPids")
     *                         .dvbTdtSettings(DvbTdtSettingsProperty.builder()
     *                                 .repInterval(123)
     *                                 .build())
     *                         .dvbTeletextPid("dvbTeletextPid")
     *                         .ebif("ebif")
     *                         .ebpAudioInterval("ebpAudioInterval")
     *                         .ebpLookaheadMs(123)
     *                         .ebpPlacement("ebpPlacement")
     *                         .ecmPid("ecmPid")
     *                         .esRateInPes("esRateInPes")
     *                         .etvPlatformPid("etvPlatformPid")
     *                         .etvSignalPid("etvSignalPid")
     *                         .fragmentTime(123)
     *                         .klv("klv")
     *                         .klvDataPids("klvDataPids")
     *                         .nielsenId3Behavior("nielsenId3Behavior")
     *                         .nullPacketBitrate(123)
     *                         .patInterval(123)
     *                         .pcrControl("pcrControl")
     *                         .pcrPeriod(123)
     *                         .pcrPid("pcrPid")
     *                         .pmtInterval(123)
     *                         .pmtPid("pmtPid")
     *                         .programNum(123)
     *                         .rateMode("rateMode")
     *                         .scte27Pids("scte27Pids")
     *                         .scte35Control("scte35Control")
     *                         .scte35Pid("scte35Pid")
     *                         .scte35PrerollPullupMilliseconds(123)
     *                         .segmentationMarkers("segmentationMarkers")
     *                         .segmentationStyle("segmentationStyle")
     *                         .segmentationTime(123)
     *                         .timedMetadataBehavior("timedMetadataBehavior")
     *                         .timedMetadataPid("timedMetadataPid")
     *                         .transportStreamId(123)
     *                         .videoPid("videoPid")
     *                         .build())
     *                 .rawSettings(RawSettingsProperty.builder().build())
     *                 .build())
     *         .extension("extension")
     *         .nameModifier("nameModifier")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archiveoutputsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archiveoutputsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.ArchiveOutputSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ArchiveOutputSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArchiveOutputSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The settings that are specific to the container type of the file.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.ArchiveContainerSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archiveoutputsettings.html#cfn-medialive-channel-archiveoutputsettings-containersettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archiveoutputsettings.html#cfn-medialive-channel-archiveoutputsettings-containersettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainerSettings() {
            return null;
        }

        /**
         * The output file extension.
         * <p>
         * If excluded, this is auto-selected from the container type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archiveoutputsettings.html#cfn-medialive-channel-archiveoutputsettings-extension">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archiveoutputsettings.html#cfn-medialive-channel-archiveoutputsettings-extension</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExtension() {
            return null;
        }

        /**
         * A string that is concatenated to the end of the destination file name.
         * <p>
         * The string is required for multiple outputs of the same type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archiveoutputsettings.html#cfn-medialive-channel-archiveoutputsettings-namemodifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archiveoutputsettings.html#cfn-medialive-channel-archiveoutputsettings-namemodifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNameModifier() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ArchiveOutputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArchiveOutputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArchiveOutputSettingsProperty> {
            java.lang.Object containerSettings;
            java.lang.String extension;
            java.lang.String nameModifier;

            /**
             * Sets the value of {@link ArchiveOutputSettingsProperty#getContainerSettings}
             * @param containerSettings The settings that are specific to the container type of the file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerSettings(software.amazon.awscdk.IResolvable containerSettings) {
                this.containerSettings = containerSettings;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveOutputSettingsProperty#getContainerSettings}
             * @param containerSettings The settings that are specific to the container type of the file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerSettings(software.amazon.awscdk.services.medialive.CfnChannel.ArchiveContainerSettingsProperty containerSettings) {
                this.containerSettings = containerSettings;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveOutputSettingsProperty#getExtension}
             * @param extension The output file extension.
             *                  If excluded, this is auto-selected from the container type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extension(java.lang.String extension) {
                this.extension = extension;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveOutputSettingsProperty#getNameModifier}
             * @param nameModifier A string that is concatenated to the end of the destination file name.
             *                     The string is required for multiple outputs of the same type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nameModifier(java.lang.String nameModifier) {
                this.nameModifier = nameModifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArchiveOutputSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArchiveOutputSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArchiveOutputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArchiveOutputSettingsProperty {
            private final java.lang.Object containerSettings;
            private final java.lang.String extension;
            private final java.lang.String nameModifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerSettings = software.amazon.jsii.Kernel.get(this, "containerSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.extension = software.amazon.jsii.Kernel.get(this, "extension", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nameModifier = software.amazon.jsii.Kernel.get(this, "nameModifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerSettings = builder.containerSettings;
                this.extension = builder.extension;
                this.nameModifier = builder.nameModifier;
            }

            @Override
            public final java.lang.Object getContainerSettings() {
                return this.containerSettings;
            }

            @Override
            public final java.lang.String getExtension() {
                return this.extension;
            }

            @Override
            public final java.lang.String getNameModifier() {
                return this.nameModifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainerSettings() != null) {
                    data.set("containerSettings", om.valueToTree(this.getContainerSettings()));
                }
                if (this.getExtension() != null) {
                    data.set("extension", om.valueToTree(this.getExtension()));
                }
                if (this.getNameModifier() != null) {
                    data.set("nameModifier", om.valueToTree(this.getNameModifier()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.ArchiveOutputSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArchiveOutputSettingsProperty.Jsii$Proxy that = (ArchiveOutputSettingsProperty.Jsii$Proxy) o;

                if (this.containerSettings != null ? !this.containerSettings.equals(that.containerSettings) : that.containerSettings != null) return false;
                if (this.extension != null ? !this.extension.equals(that.extension) : that.extension != null) return false;
                return this.nameModifier != null ? this.nameModifier.equals(that.nameModifier) : that.nameModifier == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerSettings != null ? this.containerSettings.hashCode() : 0;
                result = 31 * result + (this.extension != null ? this.extension.hashCode() : 0);
                result = 31 * result + (this.nameModifier != null ? this.nameModifier.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Sets up Amazon S3 as the destination for this Archive output.
     * <p>
     * The parent of this entity is ArchiveCdnSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * ArchiveS3SettingsProperty archiveS3SettingsProperty = ArchiveS3SettingsProperty.builder()
     *         .cannedAcl("cannedAcl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archives3settings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archives3settings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.ArchiveS3SettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ArchiveS3SettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArchiveS3SettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specify the canned ACL to apply to each S3 request.
         * <p>
         * Defaults to none.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archives3settings.html#cfn-medialive-channel-archives3settings-cannedacl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archives3settings.html#cfn-medialive-channel-archives3settings-cannedacl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCannedAcl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ArchiveS3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArchiveS3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArchiveS3SettingsProperty> {
            java.lang.String cannedAcl;

            /**
             * Sets the value of {@link ArchiveS3SettingsProperty#getCannedAcl}
             * @param cannedAcl Specify the canned ACL to apply to each S3 request.
             *                  Defaults to none.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cannedAcl(java.lang.String cannedAcl) {
                this.cannedAcl = cannedAcl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArchiveS3SettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArchiveS3SettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArchiveS3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArchiveS3SettingsProperty {
            private final java.lang.String cannedAcl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cannedAcl = software.amazon.jsii.Kernel.get(this, "cannedAcl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cannedAcl = builder.cannedAcl;
            }

            @Override
            public final java.lang.String getCannedAcl() {
                return this.cannedAcl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCannedAcl() != null) {
                    data.set("cannedAcl", om.valueToTree(this.getCannedAcl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.ArchiveS3SettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArchiveS3SettingsProperty.Jsii$Proxy that = (ArchiveS3SettingsProperty.Jsii$Proxy) o;

                return this.cannedAcl != null ? this.cannedAcl.equals(that.cannedAcl) : that.cannedAcl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cannedAcl != null ? this.cannedAcl.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AribDestinationSettingsProperty aribDestinationSettingsProperty = AribDestinationSettingsProperty.builder().build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aribdestinationsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aribdestinationsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AribDestinationSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AribDestinationSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AribDestinationSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @return a {@link Builder} of {@link AribDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AribDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AribDestinationSettingsProperty> {

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AribDestinationSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AribDestinationSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AribDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AribDestinationSettingsProperty {

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();


                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AribDestinationSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AribSourceSettingsProperty aribSourceSettingsProperty = AribSourceSettingsProperty.builder().build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aribsourcesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aribsourcesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AribSourceSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AribSourceSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AribSourceSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @return a {@link Builder} of {@link AribSourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AribSourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AribSourceSettingsProperty> {

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AribSourceSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AribSourceSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AribSourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AribSourceSettingsProperty {

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();


                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AribSourceSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }
        }
    }
    /**
     * The settings for remixing audio.
     * <p>
     * The parent of this entity is RemixSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioChannelMappingProperty audioChannelMappingProperty = AudioChannelMappingProperty.builder()
     *         .inputChannelLevels(List.of(InputChannelLevelProperty.builder()
     *                 .gain(123)
     *                 .inputChannel(123)
     *                 .build()))
     *         .outputChannel(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiochannelmapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiochannelmapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioChannelMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioChannelMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioChannelMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The indices and gain values for each input channel that should be remixed into this output channel.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.InputChannelLevelProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiochannelmapping.html#cfn-medialive-channel-audiochannelmapping-inputchannellevels">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiochannelmapping.html#cfn-medialive-channel-audiochannelmapping-inputchannellevels</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputChannelLevels() {
            return null;
        }

        /**
         * The index of the output channel that is being produced.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiochannelmapping.html#cfn-medialive-channel-audiochannelmapping-outputchannel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiochannelmapping.html#cfn-medialive-channel-audiochannelmapping-outputchannel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOutputChannel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioChannelMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioChannelMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioChannelMappingProperty> {
            java.lang.Object inputChannelLevels;
            java.lang.Number outputChannel;

            /**
             * Sets the value of {@link AudioChannelMappingProperty#getInputChannelLevels}
             * @param inputChannelLevels The indices and gain values for each input channel that should be remixed into this output channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputChannelLevels(software.amazon.awscdk.IResolvable inputChannelLevels) {
                this.inputChannelLevels = inputChannelLevels;
                return this;
            }

            /**
             * Sets the value of {@link AudioChannelMappingProperty#getInputChannelLevels}
             * @param inputChannelLevels The indices and gain values for each input channel that should be remixed into this output channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputChannelLevels(java.util.List<? extends java.lang.Object> inputChannelLevels) {
                this.inputChannelLevels = inputChannelLevels;
                return this;
            }

            /**
             * Sets the value of {@link AudioChannelMappingProperty#getOutputChannel}
             * @param outputChannel The index of the output channel that is being produced.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputChannel(java.lang.Number outputChannel) {
                this.outputChannel = outputChannel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioChannelMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioChannelMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioChannelMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioChannelMappingProperty {
            private final java.lang.Object inputChannelLevels;
            private final java.lang.Number outputChannel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputChannelLevels = software.amazon.jsii.Kernel.get(this, "inputChannelLevels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outputChannel = software.amazon.jsii.Kernel.get(this, "outputChannel", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputChannelLevels = builder.inputChannelLevels;
                this.outputChannel = builder.outputChannel;
            }

            @Override
            public final java.lang.Object getInputChannelLevels() {
                return this.inputChannelLevels;
            }

            @Override
            public final java.lang.Number getOutputChannel() {
                return this.outputChannel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInputChannelLevels() != null) {
                    data.set("inputChannelLevels", om.valueToTree(this.getInputChannelLevels()));
                }
                if (this.getOutputChannel() != null) {
                    data.set("outputChannel", om.valueToTree(this.getOutputChannel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioChannelMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioChannelMappingProperty.Jsii$Proxy that = (AudioChannelMappingProperty.Jsii$Proxy) o;

                if (this.inputChannelLevels != null ? !this.inputChannelLevels.equals(that.inputChannelLevels) : that.inputChannelLevels != null) return false;
                return this.outputChannel != null ? this.outputChannel.equals(that.outputChannel) : that.outputChannel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inputChannelLevels != null ? this.inputChannelLevels.hashCode() : 0;
                result = 31 * result + (this.outputChannel != null ? this.outputChannel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of the audio codec in the audio output.
     * <p>
     * The parent of this entity is AudioDescription.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioCodecSettingsProperty audioCodecSettingsProperty = AudioCodecSettingsProperty.builder()
     *         .aacSettings(AacSettingsProperty.builder()
     *                 .bitrate(123)
     *                 .codingMode("codingMode")
     *                 .inputType("inputType")
     *                 .profile("profile")
     *                 .rateControlMode("rateControlMode")
     *                 .rawFormat("rawFormat")
     *                 .sampleRate(123)
     *                 .spec("spec")
     *                 .vbrQuality("vbrQuality")
     *                 .build())
     *         .ac3Settings(Ac3SettingsProperty.builder()
     *                 .attenuationControl("attenuationControl")
     *                 .bitrate(123)
     *                 .bitstreamMode("bitstreamMode")
     *                 .codingMode("codingMode")
     *                 .dialnorm(123)
     *                 .drcProfile("drcProfile")
     *                 .lfeFilter("lfeFilter")
     *                 .metadataControl("metadataControl")
     *                 .build())
     *         .eac3AtmosSettings(Eac3AtmosSettingsProperty.builder()
     *                 .bitrate(123)
     *                 .codingMode("codingMode")
     *                 .dialnorm(123)
     *                 .drcLine("drcLine")
     *                 .drcRf("drcRf")
     *                 .heightTrim(123)
     *                 .surroundTrim(123)
     *                 .build())
     *         .eac3Settings(Eac3SettingsProperty.builder()
     *                 .attenuationControl("attenuationControl")
     *                 .bitrate(123)
     *                 .bitstreamMode("bitstreamMode")
     *                 .codingMode("codingMode")
     *                 .dcFilter("dcFilter")
     *                 .dialnorm(123)
     *                 .drcLine("drcLine")
     *                 .drcRf("drcRf")
     *                 .lfeControl("lfeControl")
     *                 .lfeFilter("lfeFilter")
     *                 .loRoCenterMixLevel(123)
     *                 .loRoSurroundMixLevel(123)
     *                 .ltRtCenterMixLevel(123)
     *                 .ltRtSurroundMixLevel(123)
     *                 .metadataControl("metadataControl")
     *                 .passthroughControl("passthroughControl")
     *                 .phaseControl("phaseControl")
     *                 .stereoDownmix("stereoDownmix")
     *                 .surroundExMode("surroundExMode")
     *                 .surroundMode("surroundMode")
     *                 .build())
     *         .mp2Settings(Mp2SettingsProperty.builder()
     *                 .bitrate(123)
     *                 .codingMode("codingMode")
     *                 .sampleRate(123)
     *                 .build())
     *         .passThroughSettings(PassThroughSettingsProperty.builder().build())
     *         .wavSettings(WavSettingsProperty.builder()
     *                 .bitDepth(123)
     *                 .codingMode("codingMode")
     *                 .sampleRate(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioCodecSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioCodecSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioCodecSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The setup of the AAC audio codec in the output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.AacSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-aacsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-aacsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAacSettings() {
            return null;
        }

        /**
         * The setup of an AC3 audio codec in the output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.Ac3SettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-ac3settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-ac3settings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAc3Settings() {
            return null;
        }

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.Eac3AtmosSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-eac3atmossettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-eac3atmossettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEac3AtmosSettings() {
            return null;
        }

        /**
         * The setup of an EAC3 audio codec in the output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.Eac3SettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-eac3settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-eac3settings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEac3Settings() {
            return null;
        }

        /**
         * The setup of an MP2 audio codec in the output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.Mp2SettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-mp2settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-mp2settings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMp2Settings() {
            return null;
        }

        /**
         * The setup to pass through the Dolby audio codec to the output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.PassThroughSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-passthroughsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-passthroughsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPassThroughSettings() {
            return null;
        }

        /**
         * Settings for audio encoded with the WAV codec.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.WavSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-wavsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-wavsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWavSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioCodecSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioCodecSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioCodecSettingsProperty> {
            java.lang.Object aacSettings;
            java.lang.Object ac3Settings;
            java.lang.Object eac3AtmosSettings;
            java.lang.Object eac3Settings;
            java.lang.Object mp2Settings;
            java.lang.Object passThroughSettings;
            java.lang.Object wavSettings;

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getAacSettings}
             * @param aacSettings The setup of the AAC audio codec in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aacSettings(software.amazon.awscdk.IResolvable aacSettings) {
                this.aacSettings = aacSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getAacSettings}
             * @param aacSettings The setup of the AAC audio codec in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aacSettings(software.amazon.awscdk.services.medialive.CfnChannel.AacSettingsProperty aacSettings) {
                this.aacSettings = aacSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getAc3Settings}
             * @param ac3Settings The setup of an AC3 audio codec in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ac3Settings(software.amazon.awscdk.IResolvable ac3Settings) {
                this.ac3Settings = ac3Settings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getAc3Settings}
             * @param ac3Settings The setup of an AC3 audio codec in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ac3Settings(software.amazon.awscdk.services.medialive.CfnChannel.Ac3SettingsProperty ac3Settings) {
                this.ac3Settings = ac3Settings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getEac3AtmosSettings}
             * @param eac3AtmosSettings the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eac3AtmosSettings(software.amazon.awscdk.IResolvable eac3AtmosSettings) {
                this.eac3AtmosSettings = eac3AtmosSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getEac3AtmosSettings}
             * @param eac3AtmosSettings the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eac3AtmosSettings(software.amazon.awscdk.services.medialive.CfnChannel.Eac3AtmosSettingsProperty eac3AtmosSettings) {
                this.eac3AtmosSettings = eac3AtmosSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getEac3Settings}
             * @param eac3Settings The setup of an EAC3 audio codec in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eac3Settings(software.amazon.awscdk.IResolvable eac3Settings) {
                this.eac3Settings = eac3Settings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getEac3Settings}
             * @param eac3Settings The setup of an EAC3 audio codec in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eac3Settings(software.amazon.awscdk.services.medialive.CfnChannel.Eac3SettingsProperty eac3Settings) {
                this.eac3Settings = eac3Settings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getMp2Settings}
             * @param mp2Settings The setup of an MP2 audio codec in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mp2Settings(software.amazon.awscdk.IResolvable mp2Settings) {
                this.mp2Settings = mp2Settings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getMp2Settings}
             * @param mp2Settings The setup of an MP2 audio codec in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mp2Settings(software.amazon.awscdk.services.medialive.CfnChannel.Mp2SettingsProperty mp2Settings) {
                this.mp2Settings = mp2Settings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getPassThroughSettings}
             * @param passThroughSettings The setup to pass through the Dolby audio codec to the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder passThroughSettings(software.amazon.awscdk.IResolvable passThroughSettings) {
                this.passThroughSettings = passThroughSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getPassThroughSettings}
             * @param passThroughSettings The setup to pass through the Dolby audio codec to the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder passThroughSettings(software.amazon.awscdk.services.medialive.CfnChannel.PassThroughSettingsProperty passThroughSettings) {
                this.passThroughSettings = passThroughSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getWavSettings}
             * @param wavSettings Settings for audio encoded with the WAV codec.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder wavSettings(software.amazon.awscdk.IResolvable wavSettings) {
                this.wavSettings = wavSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getWavSettings}
             * @param wavSettings Settings for audio encoded with the WAV codec.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder wavSettings(software.amazon.awscdk.services.medialive.CfnChannel.WavSettingsProperty wavSettings) {
                this.wavSettings = wavSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioCodecSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioCodecSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioCodecSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioCodecSettingsProperty {
            private final java.lang.Object aacSettings;
            private final java.lang.Object ac3Settings;
            private final java.lang.Object eac3AtmosSettings;
            private final java.lang.Object eac3Settings;
            private final java.lang.Object mp2Settings;
            private final java.lang.Object passThroughSettings;
            private final java.lang.Object wavSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aacSettings = software.amazon.jsii.Kernel.get(this, "aacSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ac3Settings = software.amazon.jsii.Kernel.get(this, "ac3Settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eac3AtmosSettings = software.amazon.jsii.Kernel.get(this, "eac3AtmosSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eac3Settings = software.amazon.jsii.Kernel.get(this, "eac3Settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mp2Settings = software.amazon.jsii.Kernel.get(this, "mp2Settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.passThroughSettings = software.amazon.jsii.Kernel.get(this, "passThroughSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.wavSettings = software.amazon.jsii.Kernel.get(this, "wavSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aacSettings = builder.aacSettings;
                this.ac3Settings = builder.ac3Settings;
                this.eac3AtmosSettings = builder.eac3AtmosSettings;
                this.eac3Settings = builder.eac3Settings;
                this.mp2Settings = builder.mp2Settings;
                this.passThroughSettings = builder.passThroughSettings;
                this.wavSettings = builder.wavSettings;
            }

            @Override
            public final java.lang.Object getAacSettings() {
                return this.aacSettings;
            }

            @Override
            public final java.lang.Object getAc3Settings() {
                return this.ac3Settings;
            }

            @Override
            public final java.lang.Object getEac3AtmosSettings() {
                return this.eac3AtmosSettings;
            }

            @Override
            public final java.lang.Object getEac3Settings() {
                return this.eac3Settings;
            }

            @Override
            public final java.lang.Object getMp2Settings() {
                return this.mp2Settings;
            }

            @Override
            public final java.lang.Object getPassThroughSettings() {
                return this.passThroughSettings;
            }

            @Override
            public final java.lang.Object getWavSettings() {
                return this.wavSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAacSettings() != null) {
                    data.set("aacSettings", om.valueToTree(this.getAacSettings()));
                }
                if (this.getAc3Settings() != null) {
                    data.set("ac3Settings", om.valueToTree(this.getAc3Settings()));
                }
                if (this.getEac3AtmosSettings() != null) {
                    data.set("eac3AtmosSettings", om.valueToTree(this.getEac3AtmosSettings()));
                }
                if (this.getEac3Settings() != null) {
                    data.set("eac3Settings", om.valueToTree(this.getEac3Settings()));
                }
                if (this.getMp2Settings() != null) {
                    data.set("mp2Settings", om.valueToTree(this.getMp2Settings()));
                }
                if (this.getPassThroughSettings() != null) {
                    data.set("passThroughSettings", om.valueToTree(this.getPassThroughSettings()));
                }
                if (this.getWavSettings() != null) {
                    data.set("wavSettings", om.valueToTree(this.getWavSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioCodecSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioCodecSettingsProperty.Jsii$Proxy that = (AudioCodecSettingsProperty.Jsii$Proxy) o;

                if (this.aacSettings != null ? !this.aacSettings.equals(that.aacSettings) : that.aacSettings != null) return false;
                if (this.ac3Settings != null ? !this.ac3Settings.equals(that.ac3Settings) : that.ac3Settings != null) return false;
                if (this.eac3AtmosSettings != null ? !this.eac3AtmosSettings.equals(that.eac3AtmosSettings) : that.eac3AtmosSettings != null) return false;
                if (this.eac3Settings != null ? !this.eac3Settings.equals(that.eac3Settings) : that.eac3Settings != null) return false;
                if (this.mp2Settings != null ? !this.mp2Settings.equals(that.mp2Settings) : that.mp2Settings != null) return false;
                if (this.passThroughSettings != null ? !this.passThroughSettings.equals(that.passThroughSettings) : that.passThroughSettings != null) return false;
                return this.wavSettings != null ? this.wavSettings.equals(that.wavSettings) : that.wavSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aacSettings != null ? this.aacSettings.hashCode() : 0;
                result = 31 * result + (this.ac3Settings != null ? this.ac3Settings.hashCode() : 0);
                result = 31 * result + (this.eac3AtmosSettings != null ? this.eac3AtmosSettings.hashCode() : 0);
                result = 31 * result + (this.eac3Settings != null ? this.eac3Settings.hashCode() : 0);
                result = 31 * result + (this.mp2Settings != null ? this.mp2Settings.hashCode() : 0);
                result = 31 * result + (this.passThroughSettings != null ? this.passThroughSettings.hashCode() : 0);
                result = 31 * result + (this.wavSettings != null ? this.wavSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The encoding information for one output audio.
     * <p>
     * The parent of this entity is EncoderSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioDescriptionProperty audioDescriptionProperty = AudioDescriptionProperty.builder()
     *         .audioDashRoles(List.of("audioDashRoles"))
     *         .audioNormalizationSettings(AudioNormalizationSettingsProperty.builder()
     *                 .algorithm("algorithm")
     *                 .algorithmControl("algorithmControl")
     *                 .targetLkfs(123)
     *                 .build())
     *         .audioSelectorName("audioSelectorName")
     *         .audioType("audioType")
     *         .audioTypeControl("audioTypeControl")
     *         .audioWatermarkingSettings(AudioWatermarkSettingsProperty.builder()
     *                 .nielsenWatermarksSettings(NielsenWatermarksSettingsProperty.builder()
     *                         .nielsenCbetSettings(NielsenCBETProperty.builder()
     *                                 .cbetCheckDigitString("cbetCheckDigitString")
     *                                 .cbetStepaside("cbetStepaside")
     *                                 .csid("csid")
     *                                 .build())
     *                         .nielsenDistributionType("nielsenDistributionType")
     *                         .nielsenNaesIiNwSettings(NielsenNaesIiNwProperty.builder()
     *                                 .checkDigitString("checkDigitString")
     *                                 .sid(123)
     *                                 .timezone("timezone")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .codecSettings(AudioCodecSettingsProperty.builder()
     *                 .aacSettings(AacSettingsProperty.builder()
     *                         .bitrate(123)
     *                         .codingMode("codingMode")
     *                         .inputType("inputType")
     *                         .profile("profile")
     *                         .rateControlMode("rateControlMode")
     *                         .rawFormat("rawFormat")
     *                         .sampleRate(123)
     *                         .spec("spec")
     *                         .vbrQuality("vbrQuality")
     *                         .build())
     *                 .ac3Settings(Ac3SettingsProperty.builder()
     *                         .attenuationControl("attenuationControl")
     *                         .bitrate(123)
     *                         .bitstreamMode("bitstreamMode")
     *                         .codingMode("codingMode")
     *                         .dialnorm(123)
     *                         .drcProfile("drcProfile")
     *                         .lfeFilter("lfeFilter")
     *                         .metadataControl("metadataControl")
     *                         .build())
     *                 .eac3AtmosSettings(Eac3AtmosSettingsProperty.builder()
     *                         .bitrate(123)
     *                         .codingMode("codingMode")
     *                         .dialnorm(123)
     *                         .drcLine("drcLine")
     *                         .drcRf("drcRf")
     *                         .heightTrim(123)
     *                         .surroundTrim(123)
     *                         .build())
     *                 .eac3Settings(Eac3SettingsProperty.builder()
     *                         .attenuationControl("attenuationControl")
     *                         .bitrate(123)
     *                         .bitstreamMode("bitstreamMode")
     *                         .codingMode("codingMode")
     *                         .dcFilter("dcFilter")
     *                         .dialnorm(123)
     *                         .drcLine("drcLine")
     *                         .drcRf("drcRf")
     *                         .lfeControl("lfeControl")
     *                         .lfeFilter("lfeFilter")
     *                         .loRoCenterMixLevel(123)
     *                         .loRoSurroundMixLevel(123)
     *                         .ltRtCenterMixLevel(123)
     *                         .ltRtSurroundMixLevel(123)
     *                         .metadataControl("metadataControl")
     *                         .passthroughControl("passthroughControl")
     *                         .phaseControl("phaseControl")
     *                         .stereoDownmix("stereoDownmix")
     *                         .surroundExMode("surroundExMode")
     *                         .surroundMode("surroundMode")
     *                         .build())
     *                 .mp2Settings(Mp2SettingsProperty.builder()
     *                         .bitrate(123)
     *                         .codingMode("codingMode")
     *                         .sampleRate(123)
     *                         .build())
     *                 .passThroughSettings(PassThroughSettingsProperty.builder().build())
     *                 .wavSettings(WavSettingsProperty.builder()
     *                         .bitDepth(123)
     *                         .codingMode("codingMode")
     *                         .sampleRate(123)
     *                         .build())
     *                 .build())
     *         .dvbDashAccessibility("dvbDashAccessibility")
     *         .languageCode("languageCode")
     *         .languageCodeControl("languageCodeControl")
     *         .name("name")
     *         .remixSettings(RemixSettingsProperty.builder()
     *                 .channelMappings(List.of(AudioChannelMappingProperty.builder()
     *                         .inputChannelLevels(List.of(InputChannelLevelProperty.builder()
     *                                 .gain(123)
     *                                 .inputChannel(123)
     *                                 .build()))
     *                         .outputChannel(123)
     *                         .build()))
     *                 .channelsIn(123)
     *                 .channelsOut(123)
     *                 .build())
     *         .streamName("streamName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioDescriptionProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioDescriptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioDescriptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audiodashroles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audiodashroles</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAudioDashRoles() {
            return null;
        }

        /**
         * The advanced audio normalization settings.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.AudioNormalizationSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audionormalizationsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audionormalizationsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudioNormalizationSettings() {
            return null;
        }

        /**
         * The name of the AudioSelector that is used as the source for this AudioDescription.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audioselectorname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audioselectorname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAudioSelectorName() {
            return null;
        }

        /**
         * Applies only if audioTypeControl is useConfigured.
         * <p>
         * The values for audioType are defined in ISO-IEC 13818-1.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audiotype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audiotype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAudioType() {
            return null;
        }

        /**
         * Determines how audio type is determined.
         * <p>
         * followInput: If the input contains an ISO 639 audioType, then that value is passed through to the output. If the input contains no ISO 639 audioType, the value in Audio Type is included in the output. useConfigured: The value in Audio Type is included in the output. Note that this field and audioType are both ignored if inputType is broadcasterMixedAd.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audiotypecontrol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audiotypecontrol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAudioTypeControl() {
            return null;
        }

        /**
         * Settings to configure one or more solutions that insert audio watermarks in the audio encode.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.AudioWatermarkSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audiowatermarkingsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audiowatermarkingsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudioWatermarkingSettings() {
            return null;
        }

        /**
         * The audio codec settings.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.AudioCodecSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-codecsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-codecsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCodecSettings() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-dvbdashaccessibility">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-dvbdashaccessibility</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDvbDashAccessibility() {
            return null;
        }

        /**
         * Indicates the language of the audio output track.
         * <p>
         * Used only if languageControlMode is useConfigured, or there is no ISO 639 language code specified in the input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-languagecode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-languagecode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLanguageCode() {
            return null;
        }

        /**
         * Choosing followInput causes the ISO 639 language code of the output to follow the ISO 639 language code of the input.
         * <p>
         * The languageCode setting is used when useConfigured is set, or when followInput is selected but there is no ISO 639 language code specified by the input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-languagecodecontrol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-languagecodecontrol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLanguageCodeControl() {
            return null;
        }

        /**
         * The name of this AudioDescription.
         * <p>
         * Outputs use this name to uniquely identify this AudioDescription. Description names should be unique within this channel.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The settings that control how input audio channels are remixed into the output audio channels.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.RemixSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-remixsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-remixsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRemixSettings() {
            return null;
        }

        /**
         * Used for Microsoft Smooth and Apple HLS outputs.
         * <p>
         * Indicates the name displayed by the player (for example, English or Director Commentary).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-streamname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-streamname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStreamName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioDescriptionProperty> {
            java.util.List<java.lang.String> audioDashRoles;
            java.lang.Object audioNormalizationSettings;
            java.lang.String audioSelectorName;
            java.lang.String audioType;
            java.lang.String audioTypeControl;
            java.lang.Object audioWatermarkingSettings;
            java.lang.Object codecSettings;
            java.lang.String dvbDashAccessibility;
            java.lang.String languageCode;
            java.lang.String languageCodeControl;
            java.lang.String name;
            java.lang.Object remixSettings;
            java.lang.String streamName;

            /**
             * Sets the value of {@link AudioDescriptionProperty#getAudioDashRoles}
             * @param audioDashRoles the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioDashRoles(java.util.List<java.lang.String> audioDashRoles) {
                this.audioDashRoles = audioDashRoles;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getAudioNormalizationSettings}
             * @param audioNormalizationSettings The advanced audio normalization settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioNormalizationSettings(software.amazon.awscdk.IResolvable audioNormalizationSettings) {
                this.audioNormalizationSettings = audioNormalizationSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getAudioNormalizationSettings}
             * @param audioNormalizationSettings The advanced audio normalization settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioNormalizationSettings(software.amazon.awscdk.services.medialive.CfnChannel.AudioNormalizationSettingsProperty audioNormalizationSettings) {
                this.audioNormalizationSettings = audioNormalizationSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getAudioSelectorName}
             * @param audioSelectorName The name of the AudioSelector that is used as the source for this AudioDescription.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioSelectorName(java.lang.String audioSelectorName) {
                this.audioSelectorName = audioSelectorName;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getAudioType}
             * @param audioType Applies only if audioTypeControl is useConfigured.
             *                  The values for audioType are defined in ISO-IEC 13818-1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioType(java.lang.String audioType) {
                this.audioType = audioType;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getAudioTypeControl}
             * @param audioTypeControl Determines how audio type is determined.
             *                         followInput: If the input contains an ISO 639 audioType, then that value is passed through to the output. If the input contains no ISO 639 audioType, the value in Audio Type is included in the output. useConfigured: The value in Audio Type is included in the output. Note that this field and audioType are both ignored if inputType is broadcasterMixedAd.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioTypeControl(java.lang.String audioTypeControl) {
                this.audioTypeControl = audioTypeControl;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getAudioWatermarkingSettings}
             * @param audioWatermarkingSettings Settings to configure one or more solutions that insert audio watermarks in the audio encode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioWatermarkingSettings(software.amazon.awscdk.IResolvable audioWatermarkingSettings) {
                this.audioWatermarkingSettings = audioWatermarkingSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getAudioWatermarkingSettings}
             * @param audioWatermarkingSettings Settings to configure one or more solutions that insert audio watermarks in the audio encode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioWatermarkingSettings(software.amazon.awscdk.services.medialive.CfnChannel.AudioWatermarkSettingsProperty audioWatermarkingSettings) {
                this.audioWatermarkingSettings = audioWatermarkingSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getCodecSettings}
             * @param codecSettings The audio codec settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codecSettings(software.amazon.awscdk.IResolvable codecSettings) {
                this.codecSettings = codecSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getCodecSettings}
             * @param codecSettings The audio codec settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codecSettings(software.amazon.awscdk.services.medialive.CfnChannel.AudioCodecSettingsProperty codecSettings) {
                this.codecSettings = codecSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getDvbDashAccessibility}
             * @param dvbDashAccessibility the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dvbDashAccessibility(java.lang.String dvbDashAccessibility) {
                this.dvbDashAccessibility = dvbDashAccessibility;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getLanguageCode}
             * @param languageCode Indicates the language of the audio output track.
             *                     Used only if languageControlMode is useConfigured, or there is no ISO 639 language code specified in the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder languageCode(java.lang.String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getLanguageCodeControl}
             * @param languageCodeControl Choosing followInput causes the ISO 639 language code of the output to follow the ISO 639 language code of the input.
             *                            The languageCode setting is used when useConfigured is set, or when followInput is selected but there is no ISO 639 language code specified by the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder languageCodeControl(java.lang.String languageCodeControl) {
                this.languageCodeControl = languageCodeControl;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getName}
             * @param name The name of this AudioDescription.
             *             Outputs use this name to uniquely identify this AudioDescription. Description names should be unique within this channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getRemixSettings}
             * @param remixSettings The settings that control how input audio channels are remixed into the output audio channels.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder remixSettings(software.amazon.awscdk.IResolvable remixSettings) {
                this.remixSettings = remixSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getRemixSettings}
             * @param remixSettings The settings that control how input audio channels are remixed into the output audio channels.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder remixSettings(software.amazon.awscdk.services.medialive.CfnChannel.RemixSettingsProperty remixSettings) {
                this.remixSettings = remixSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getStreamName}
             * @param streamName Used for Microsoft Smooth and Apple HLS outputs.
             *                   Indicates the name displayed by the player (for example, English or Director Commentary).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamName(java.lang.String streamName) {
                this.streamName = streamName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioDescriptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioDescriptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioDescriptionProperty {
            private final java.util.List<java.lang.String> audioDashRoles;
            private final java.lang.Object audioNormalizationSettings;
            private final java.lang.String audioSelectorName;
            private final java.lang.String audioType;
            private final java.lang.String audioTypeControl;
            private final java.lang.Object audioWatermarkingSettings;
            private final java.lang.Object codecSettings;
            private final java.lang.String dvbDashAccessibility;
            private final java.lang.String languageCode;
            private final java.lang.String languageCodeControl;
            private final java.lang.String name;
            private final java.lang.Object remixSettings;
            private final java.lang.String streamName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audioDashRoles = software.amazon.jsii.Kernel.get(this, "audioDashRoles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.audioNormalizationSettings = software.amazon.jsii.Kernel.get(this, "audioNormalizationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.audioSelectorName = software.amazon.jsii.Kernel.get(this, "audioSelectorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.audioType = software.amazon.jsii.Kernel.get(this, "audioType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.audioTypeControl = software.amazon.jsii.Kernel.get(this, "audioTypeControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.audioWatermarkingSettings = software.amazon.jsii.Kernel.get(this, "audioWatermarkingSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.codecSettings = software.amazon.jsii.Kernel.get(this, "codecSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dvbDashAccessibility = software.amazon.jsii.Kernel.get(this, "dvbDashAccessibility", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.languageCode = software.amazon.jsii.Kernel.get(this, "languageCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.languageCodeControl = software.amazon.jsii.Kernel.get(this, "languageCodeControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.remixSettings = software.amazon.jsii.Kernel.get(this, "remixSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.streamName = software.amazon.jsii.Kernel.get(this, "streamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audioDashRoles = builder.audioDashRoles;
                this.audioNormalizationSettings = builder.audioNormalizationSettings;
                this.audioSelectorName = builder.audioSelectorName;
                this.audioType = builder.audioType;
                this.audioTypeControl = builder.audioTypeControl;
                this.audioWatermarkingSettings = builder.audioWatermarkingSettings;
                this.codecSettings = builder.codecSettings;
                this.dvbDashAccessibility = builder.dvbDashAccessibility;
                this.languageCode = builder.languageCode;
                this.languageCodeControl = builder.languageCodeControl;
                this.name = builder.name;
                this.remixSettings = builder.remixSettings;
                this.streamName = builder.streamName;
            }

            @Override
            public final java.util.List<java.lang.String> getAudioDashRoles() {
                return this.audioDashRoles;
            }

            @Override
            public final java.lang.Object getAudioNormalizationSettings() {
                return this.audioNormalizationSettings;
            }

            @Override
            public final java.lang.String getAudioSelectorName() {
                return this.audioSelectorName;
            }

            @Override
            public final java.lang.String getAudioType() {
                return this.audioType;
            }

            @Override
            public final java.lang.String getAudioTypeControl() {
                return this.audioTypeControl;
            }

            @Override
            public final java.lang.Object getAudioWatermarkingSettings() {
                return this.audioWatermarkingSettings;
            }

            @Override
            public final java.lang.Object getCodecSettings() {
                return this.codecSettings;
            }

            @Override
            public final java.lang.String getDvbDashAccessibility() {
                return this.dvbDashAccessibility;
            }

            @Override
            public final java.lang.String getLanguageCode() {
                return this.languageCode;
            }

            @Override
            public final java.lang.String getLanguageCodeControl() {
                return this.languageCodeControl;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getRemixSettings() {
                return this.remixSettings;
            }

            @Override
            public final java.lang.String getStreamName() {
                return this.streamName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAudioDashRoles() != null) {
                    data.set("audioDashRoles", om.valueToTree(this.getAudioDashRoles()));
                }
                if (this.getAudioNormalizationSettings() != null) {
                    data.set("audioNormalizationSettings", om.valueToTree(this.getAudioNormalizationSettings()));
                }
                if (this.getAudioSelectorName() != null) {
                    data.set("audioSelectorName", om.valueToTree(this.getAudioSelectorName()));
                }
                if (this.getAudioType() != null) {
                    data.set("audioType", om.valueToTree(this.getAudioType()));
                }
                if (this.getAudioTypeControl() != null) {
                    data.set("audioTypeControl", om.valueToTree(this.getAudioTypeControl()));
                }
                if (this.getAudioWatermarkingSettings() != null) {
                    data.set("audioWatermarkingSettings", om.valueToTree(this.getAudioWatermarkingSettings()));
                }
                if (this.getCodecSettings() != null) {
                    data.set("codecSettings", om.valueToTree(this.getCodecSettings()));
                }
                if (this.getDvbDashAccessibility() != null) {
                    data.set("dvbDashAccessibility", om.valueToTree(this.getDvbDashAccessibility()));
                }
                if (this.getLanguageCode() != null) {
                    data.set("languageCode", om.valueToTree(this.getLanguageCode()));
                }
                if (this.getLanguageCodeControl() != null) {
                    data.set("languageCodeControl", om.valueToTree(this.getLanguageCodeControl()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getRemixSettings() != null) {
                    data.set("remixSettings", om.valueToTree(this.getRemixSettings()));
                }
                if (this.getStreamName() != null) {
                    data.set("streamName", om.valueToTree(this.getStreamName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioDescriptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioDescriptionProperty.Jsii$Proxy that = (AudioDescriptionProperty.Jsii$Proxy) o;

                if (this.audioDashRoles != null ? !this.audioDashRoles.equals(that.audioDashRoles) : that.audioDashRoles != null) return false;
                if (this.audioNormalizationSettings != null ? !this.audioNormalizationSettings.equals(that.audioNormalizationSettings) : that.audioNormalizationSettings != null) return false;
                if (this.audioSelectorName != null ? !this.audioSelectorName.equals(that.audioSelectorName) : that.audioSelectorName != null) return false;
                if (this.audioType != null ? !this.audioType.equals(that.audioType) : that.audioType != null) return false;
                if (this.audioTypeControl != null ? !this.audioTypeControl.equals(that.audioTypeControl) : that.audioTypeControl != null) return false;
                if (this.audioWatermarkingSettings != null ? !this.audioWatermarkingSettings.equals(that.audioWatermarkingSettings) : that.audioWatermarkingSettings != null) return false;
                if (this.codecSettings != null ? !this.codecSettings.equals(that.codecSettings) : that.codecSettings != null) return false;
                if (this.dvbDashAccessibility != null ? !this.dvbDashAccessibility.equals(that.dvbDashAccessibility) : that.dvbDashAccessibility != null) return false;
                if (this.languageCode != null ? !this.languageCode.equals(that.languageCode) : that.languageCode != null) return false;
                if (this.languageCodeControl != null ? !this.languageCodeControl.equals(that.languageCodeControl) : that.languageCodeControl != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.remixSettings != null ? !this.remixSettings.equals(that.remixSettings) : that.remixSettings != null) return false;
                return this.streamName != null ? this.streamName.equals(that.streamName) : that.streamName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.audioDashRoles != null ? this.audioDashRoles.hashCode() : 0;
                result = 31 * result + (this.audioNormalizationSettings != null ? this.audioNormalizationSettings.hashCode() : 0);
                result = 31 * result + (this.audioSelectorName != null ? this.audioSelectorName.hashCode() : 0);
                result = 31 * result + (this.audioType != null ? this.audioType.hashCode() : 0);
                result = 31 * result + (this.audioTypeControl != null ? this.audioTypeControl.hashCode() : 0);
                result = 31 * result + (this.audioWatermarkingSettings != null ? this.audioWatermarkingSettings.hashCode() : 0);
                result = 31 * result + (this.codecSettings != null ? this.codecSettings.hashCode() : 0);
                result = 31 * result + (this.dvbDashAccessibility != null ? this.dvbDashAccessibility.hashCode() : 0);
                result = 31 * result + (this.languageCode != null ? this.languageCode.hashCode() : 0);
                result = 31 * result + (this.languageCodeControl != null ? this.languageCodeControl.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.remixSettings != null ? this.remixSettings.hashCode() : 0);
                result = 31 * result + (this.streamName != null ? this.streamName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioDolbyEDecodeProperty audioDolbyEDecodeProperty = AudioDolbyEDecodeProperty.builder()
     *         .programSelection("programSelection")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodolbyedecode.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodolbyedecode.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioDolbyEDecodeProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioDolbyEDecodeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioDolbyEDecodeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodolbyedecode.html#cfn-medialive-channel-audiodolbyedecode-programselection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodolbyedecode.html#cfn-medialive-channel-audiodolbyedecode-programselection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProgramSelection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioDolbyEDecodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioDolbyEDecodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioDolbyEDecodeProperty> {
            java.lang.String programSelection;

            /**
             * Sets the value of {@link AudioDolbyEDecodeProperty#getProgramSelection}
             * @param programSelection the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder programSelection(java.lang.String programSelection) {
                this.programSelection = programSelection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioDolbyEDecodeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioDolbyEDecodeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioDolbyEDecodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioDolbyEDecodeProperty {
            private final java.lang.String programSelection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.programSelection = software.amazon.jsii.Kernel.get(this, "programSelection", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.programSelection = builder.programSelection;
            }

            @Override
            public final java.lang.String getProgramSelection() {
                return this.programSelection;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getProgramSelection() != null) {
                    data.set("programSelection", om.valueToTree(this.getProgramSelection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioDolbyEDecodeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioDolbyEDecodeProperty.Jsii$Proxy that = (AudioDolbyEDecodeProperty.Jsii$Proxy) o;

                return this.programSelection != null ? this.programSelection.equals(that.programSelection) : that.programSelection == null;
            }

            @Override
            public final int hashCode() {
                int result = this.programSelection != null ? this.programSelection.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Selector for HLS audio rendition.
     * <p>
     * The parent of this entity is AudioSelectorSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioHlsRenditionSelectionProperty audioHlsRenditionSelectionProperty = AudioHlsRenditionSelectionProperty.builder()
     *         .groupId("groupId")
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiohlsrenditionselection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiohlsrenditionselection.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioHlsRenditionSelectionProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioHlsRenditionSelectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioHlsRenditionSelectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the GROUP-ID in the #EXT-X-MEDIA tag of the target HLS audio rendition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiohlsrenditionselection.html#cfn-medialive-channel-audiohlsrenditionselection-groupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiohlsrenditionselection.html#cfn-medialive-channel-audiohlsrenditionselection-groupid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroupId() {
            return null;
        }

        /**
         * Specifies the NAME in the #EXT-X-MEDIA tag of the target HLS audio rendition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiohlsrenditionselection.html#cfn-medialive-channel-audiohlsrenditionselection-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiohlsrenditionselection.html#cfn-medialive-channel-audiohlsrenditionselection-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioHlsRenditionSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioHlsRenditionSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioHlsRenditionSelectionProperty> {
            java.lang.String groupId;
            java.lang.String name;

            /**
             * Sets the value of {@link AudioHlsRenditionSelectionProperty#getGroupId}
             * @param groupId Specifies the GROUP-ID in the #EXT-X-MEDIA tag of the target HLS audio rendition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupId(java.lang.String groupId) {
                this.groupId = groupId;
                return this;
            }

            /**
             * Sets the value of {@link AudioHlsRenditionSelectionProperty#getName}
             * @param name Specifies the NAME in the #EXT-X-MEDIA tag of the target HLS audio rendition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioHlsRenditionSelectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioHlsRenditionSelectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioHlsRenditionSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioHlsRenditionSelectionProperty {
            private final java.lang.String groupId;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.groupId = software.amazon.jsii.Kernel.get(this, "groupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.groupId = builder.groupId;
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getGroupId() {
                return this.groupId;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGroupId() != null) {
                    data.set("groupId", om.valueToTree(this.getGroupId()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioHlsRenditionSelectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioHlsRenditionSelectionProperty.Jsii$Proxy that = (AudioHlsRenditionSelectionProperty.Jsii$Proxy) o;

                if (this.groupId != null ? !this.groupId.equals(that.groupId) : that.groupId != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.groupId != null ? this.groupId.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the audio language to extract.
     * <p>
     * The parent of this entity is AudioSelectorSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioLanguageSelectionProperty audioLanguageSelectionProperty = AudioLanguageSelectionProperty.builder()
     *         .languageCode("languageCode")
     *         .languageSelectionPolicy("languageSelectionPolicy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiolanguageselection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiolanguageselection.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioLanguageSelectionProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioLanguageSelectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioLanguageSelectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Selects a specific three-letter language code from within an audio source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiolanguageselection.html#cfn-medialive-channel-audiolanguageselection-languagecode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiolanguageselection.html#cfn-medialive-channel-audiolanguageselection-languagecode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLanguageCode() {
            return null;
        }

        /**
         * When set to "strict," the transport stream demux strictly identifies audio streams by their language descriptor.
         * <p>
         * If a PMT update occurs such that an audio stream matching the initially selected language is no longer present, then mute is encoded until the language returns. If set to "loose," then on a PMT update the demux chooses another audio stream in the program with the same stream type if it can't find one with the same language.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiolanguageselection.html#cfn-medialive-channel-audiolanguageselection-languageselectionpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiolanguageselection.html#cfn-medialive-channel-audiolanguageselection-languageselectionpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLanguageSelectionPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioLanguageSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioLanguageSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioLanguageSelectionProperty> {
            java.lang.String languageCode;
            java.lang.String languageSelectionPolicy;

            /**
             * Sets the value of {@link AudioLanguageSelectionProperty#getLanguageCode}
             * @param languageCode Selects a specific three-letter language code from within an audio source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder languageCode(java.lang.String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            /**
             * Sets the value of {@link AudioLanguageSelectionProperty#getLanguageSelectionPolicy}
             * @param languageSelectionPolicy When set to "strict," the transport stream demux strictly identifies audio streams by their language descriptor.
             *                                If a PMT update occurs such that an audio stream matching the initially selected language is no longer present, then mute is encoded until the language returns. If set to "loose," then on a PMT update the demux chooses another audio stream in the program with the same stream type if it can't find one with the same language.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder languageSelectionPolicy(java.lang.String languageSelectionPolicy) {
                this.languageSelectionPolicy = languageSelectionPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioLanguageSelectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioLanguageSelectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioLanguageSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioLanguageSelectionProperty {
            private final java.lang.String languageCode;
            private final java.lang.String languageSelectionPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.languageCode = software.amazon.jsii.Kernel.get(this, "languageCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.languageSelectionPolicy = software.amazon.jsii.Kernel.get(this, "languageSelectionPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.languageCode = builder.languageCode;
                this.languageSelectionPolicy = builder.languageSelectionPolicy;
            }

            @Override
            public final java.lang.String getLanguageCode() {
                return this.languageCode;
            }

            @Override
            public final java.lang.String getLanguageSelectionPolicy() {
                return this.languageSelectionPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLanguageCode() != null) {
                    data.set("languageCode", om.valueToTree(this.getLanguageCode()));
                }
                if (this.getLanguageSelectionPolicy() != null) {
                    data.set("languageSelectionPolicy", om.valueToTree(this.getLanguageSelectionPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioLanguageSelectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioLanguageSelectionProperty.Jsii$Proxy that = (AudioLanguageSelectionProperty.Jsii$Proxy) o;

                if (this.languageCode != null ? !this.languageCode.equals(that.languageCode) : that.languageCode != null) return false;
                return this.languageSelectionPolicy != null ? this.languageSelectionPolicy.equals(that.languageSelectionPolicy) : that.languageSelectionPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.languageCode != null ? this.languageCode.hashCode() : 0;
                result = 31 * result + (this.languageSelectionPolicy != null ? this.languageSelectionPolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for normalizing video.
     * <p>
     * The parent of this entity is AudioDescription.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioNormalizationSettingsProperty audioNormalizationSettingsProperty = AudioNormalizationSettingsProperty.builder()
     *         .algorithm("algorithm")
     *         .algorithmControl("algorithmControl")
     *         .targetLkfs(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audionormalizationsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audionormalizationsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioNormalizationSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioNormalizationSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioNormalizationSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The audio normalization algorithm to use.
         * <p>
         * itu17701 conforms to the CALM Act specification. itu17702 conforms to the EBU R-128 specification.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audionormalizationsettings.html#cfn-medialive-channel-audionormalizationsettings-algorithm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audionormalizationsettings.html#cfn-medialive-channel-audionormalizationsettings-algorithm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlgorithm() {
            return null;
        }

        /**
         * When set to correctAudio, the output audio is corrected using the chosen algorithm.
         * <p>
         * If set to measureOnly, the audio is measured but not adjusted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audionormalizationsettings.html#cfn-medialive-channel-audionormalizationsettings-algorithmcontrol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audionormalizationsettings.html#cfn-medialive-channel-audionormalizationsettings-algorithmcontrol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlgorithmControl() {
            return null;
        }

        /**
         * The Target LKFS(loudness) to adjust volume to.
         * <p>
         * If no value is entered, a default value is used according to the chosen algorithm. The CALM Act (1770-1) recommends a target of -24 LKFS. The EBU R-128 specification (1770-2) recommends a target of -23 LKFS.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audionormalizationsettings.html#cfn-medialive-channel-audionormalizationsettings-targetlkfs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audionormalizationsettings.html#cfn-medialive-channel-audionormalizationsettings-targetlkfs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTargetLkfs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioNormalizationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioNormalizationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioNormalizationSettingsProperty> {
            java.lang.String algorithm;
            java.lang.String algorithmControl;
            java.lang.Number targetLkfs;

            /**
             * Sets the value of {@link AudioNormalizationSettingsProperty#getAlgorithm}
             * @param algorithm The audio normalization algorithm to use.
             *                  itu17701 conforms to the CALM Act specification. itu17702 conforms to the EBU R-128 specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder algorithm(java.lang.String algorithm) {
                this.algorithm = algorithm;
                return this;
            }

            /**
             * Sets the value of {@link AudioNormalizationSettingsProperty#getAlgorithmControl}
             * @param algorithmControl When set to correctAudio, the output audio is corrected using the chosen algorithm.
             *                         If set to measureOnly, the audio is measured but not adjusted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder algorithmControl(java.lang.String algorithmControl) {
                this.algorithmControl = algorithmControl;
                return this;
            }

            /**
             * Sets the value of {@link AudioNormalizationSettingsProperty#getTargetLkfs}
             * @param targetLkfs The Target LKFS(loudness) to adjust volume to.
             *                   If no value is entered, a default value is used according to the chosen algorithm. The CALM Act (1770-1) recommends a target of -24 LKFS. The EBU R-128 specification (1770-2) recommends a target of -23 LKFS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetLkfs(java.lang.Number targetLkfs) {
                this.targetLkfs = targetLkfs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioNormalizationSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioNormalizationSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioNormalizationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioNormalizationSettingsProperty {
            private final java.lang.String algorithm;
            private final java.lang.String algorithmControl;
            private final java.lang.Number targetLkfs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.algorithm = software.amazon.jsii.Kernel.get(this, "algorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.algorithmControl = software.amazon.jsii.Kernel.get(this, "algorithmControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetLkfs = software.amazon.jsii.Kernel.get(this, "targetLkfs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.algorithm = builder.algorithm;
                this.algorithmControl = builder.algorithmControl;
                this.targetLkfs = builder.targetLkfs;
            }

            @Override
            public final java.lang.String getAlgorithm() {
                return this.algorithm;
            }

            @Override
            public final java.lang.String getAlgorithmControl() {
                return this.algorithmControl;
            }

            @Override
            public final java.lang.Number getTargetLkfs() {
                return this.targetLkfs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlgorithm() != null) {
                    data.set("algorithm", om.valueToTree(this.getAlgorithm()));
                }
                if (this.getAlgorithmControl() != null) {
                    data.set("algorithmControl", om.valueToTree(this.getAlgorithmControl()));
                }
                if (this.getTargetLkfs() != null) {
                    data.set("targetLkfs", om.valueToTree(this.getTargetLkfs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioNormalizationSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioNormalizationSettingsProperty.Jsii$Proxy that = (AudioNormalizationSettingsProperty.Jsii$Proxy) o;

                if (this.algorithm != null ? !this.algorithm.equals(that.algorithm) : that.algorithm != null) return false;
                if (this.algorithmControl != null ? !this.algorithmControl.equals(that.algorithmControl) : that.algorithmControl != null) return false;
                return this.targetLkfs != null ? this.targetLkfs.equals(that.targetLkfs) : that.targetLkfs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.algorithm != null ? this.algorithm.hashCode() : 0;
                result = 31 * result + (this.algorithmControl != null ? this.algorithmControl.hashCode() : 0);
                result = 31 * result + (this.targetLkfs != null ? this.targetLkfs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of an audio-only HLS output.
     * <p>
     * The parent of this entity is HlsSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioOnlyHlsSettingsProperty audioOnlyHlsSettingsProperty = AudioOnlyHlsSettingsProperty.builder()
     *         .audioGroupId("audioGroupId")
     *         .audioOnlyImage(InputLocationProperty.builder()
     *                 .passwordParam("passwordParam")
     *                 .uri("uri")
     *                 .username("username")
     *                 .build())
     *         .audioTrackType("audioTrackType")
     *         .segmentType("segmentType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioOnlyHlsSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioOnlyHlsSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioOnlyHlsSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the group that the audio rendition belongs to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html#cfn-medialive-channel-audioonlyhlssettings-audiogroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html#cfn-medialive-channel-audioonlyhlssettings-audiogroupid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAudioGroupId() {
            return null;
        }

        /**
         * Used with an audio-only stream.
         * <p>
         * It must be a .jpg or .png file. If given, this image is used as the cover art for the audio-only output. Ideally, it should be formatted for an iPhone screen for two reasons. The iPhone does not resize the image; instead, it crops a centered image on the top/bottom and left/right. Additionally, this image file gets saved bit-for-bit into every 10-second segment file, so it increases bandwidth by {image file size} * {segment count} * {user count.}.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.InputLocationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html#cfn-medialive-channel-audioonlyhlssettings-audioonlyimage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html#cfn-medialive-channel-audioonlyhlssettings-audioonlyimage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudioOnlyImage() {
            return null;
        }

        /**
         * Four types of audio-only tracks are supported: Audio-Only Variant Stream The client can play back this audio-only stream instead of video in low-bandwidth scenarios.
         * <p>
         * Represented as an EXT-X-STREAM-INF in the HLS manifest. Alternate Audio, Auto Select, Default Alternate rendition that the client should try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES Alternate Audio, Auto Select, Not Default Alternate rendition that the client might try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES Alternate Audio, not Auto Select Alternate rendition that the client will not try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html#cfn-medialive-channel-audioonlyhlssettings-audiotracktype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html#cfn-medialive-channel-audioonlyhlssettings-audiotracktype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAudioTrackType() {
            return null;
        }

        /**
         * Specifies the segment type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html#cfn-medialive-channel-audioonlyhlssettings-segmenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html#cfn-medialive-channel-audioonlyhlssettings-segmenttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSegmentType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioOnlyHlsSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioOnlyHlsSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioOnlyHlsSettingsProperty> {
            java.lang.String audioGroupId;
            java.lang.Object audioOnlyImage;
            java.lang.String audioTrackType;
            java.lang.String segmentType;

            /**
             * Sets the value of {@link AudioOnlyHlsSettingsProperty#getAudioGroupId}
             * @param audioGroupId Specifies the group that the audio rendition belongs to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioGroupId(java.lang.String audioGroupId) {
                this.audioGroupId = audioGroupId;
                return this;
            }

            /**
             * Sets the value of {@link AudioOnlyHlsSettingsProperty#getAudioOnlyImage}
             * @param audioOnlyImage Used with an audio-only stream.
             *                       It must be a .jpg or .png file. If given, this image is used as the cover art for the audio-only output. Ideally, it should be formatted for an iPhone screen for two reasons. The iPhone does not resize the image; instead, it crops a centered image on the top/bottom and left/right. Additionally, this image file gets saved bit-for-bit into every 10-second segment file, so it increases bandwidth by {image file size} * {segment count} * {user count.}.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioOnlyImage(software.amazon.awscdk.IResolvable audioOnlyImage) {
                this.audioOnlyImage = audioOnlyImage;
                return this;
            }

            /**
             * Sets the value of {@link AudioOnlyHlsSettingsProperty#getAudioOnlyImage}
             * @param audioOnlyImage Used with an audio-only stream.
             *                       It must be a .jpg or .png file. If given, this image is used as the cover art for the audio-only output. Ideally, it should be formatted for an iPhone screen for two reasons. The iPhone does not resize the image; instead, it crops a centered image on the top/bottom and left/right. Additionally, this image file gets saved bit-for-bit into every 10-second segment file, so it increases bandwidth by {image file size} * {segment count} * {user count.}.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioOnlyImage(software.amazon.awscdk.services.medialive.CfnChannel.InputLocationProperty audioOnlyImage) {
                this.audioOnlyImage = audioOnlyImage;
                return this;
            }

            /**
             * Sets the value of {@link AudioOnlyHlsSettingsProperty#getAudioTrackType}
             * @param audioTrackType Four types of audio-only tracks are supported: Audio-Only Variant Stream The client can play back this audio-only stream instead of video in low-bandwidth scenarios.
             *                       Represented as an EXT-X-STREAM-INF in the HLS manifest. Alternate Audio, Auto Select, Default Alternate rendition that the client should try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES Alternate Audio, Auto Select, Not Default Alternate rendition that the client might try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES Alternate Audio, not Auto Select Alternate rendition that the client will not try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioTrackType(java.lang.String audioTrackType) {
                this.audioTrackType = audioTrackType;
                return this;
            }

            /**
             * Sets the value of {@link AudioOnlyHlsSettingsProperty#getSegmentType}
             * @param segmentType Specifies the segment type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segmentType(java.lang.String segmentType) {
                this.segmentType = segmentType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioOnlyHlsSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioOnlyHlsSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioOnlyHlsSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioOnlyHlsSettingsProperty {
            private final java.lang.String audioGroupId;
            private final java.lang.Object audioOnlyImage;
            private final java.lang.String audioTrackType;
            private final java.lang.String segmentType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audioGroupId = software.amazon.jsii.Kernel.get(this, "audioGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.audioOnlyImage = software.amazon.jsii.Kernel.get(this, "audioOnlyImage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.audioTrackType = software.amazon.jsii.Kernel.get(this, "audioTrackType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.segmentType = software.amazon.jsii.Kernel.get(this, "segmentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audioGroupId = builder.audioGroupId;
                this.audioOnlyImage = builder.audioOnlyImage;
                this.audioTrackType = builder.audioTrackType;
                this.segmentType = builder.segmentType;
            }

            @Override
            public final java.lang.String getAudioGroupId() {
                return this.audioGroupId;
            }

            @Override
            public final java.lang.Object getAudioOnlyImage() {
                return this.audioOnlyImage;
            }

            @Override
            public final java.lang.String getAudioTrackType() {
                return this.audioTrackType;
            }

            @Override
            public final java.lang.String getSegmentType() {
                return this.segmentType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAudioGroupId() != null) {
                    data.set("audioGroupId", om.valueToTree(this.getAudioGroupId()));
                }
                if (this.getAudioOnlyImage() != null) {
                    data.set("audioOnlyImage", om.valueToTree(this.getAudioOnlyImage()));
                }
                if (this.getAudioTrackType() != null) {
                    data.set("audioTrackType", om.valueToTree(this.getAudioTrackType()));
                }
                if (this.getSegmentType() != null) {
                    data.set("segmentType", om.valueToTree(this.getSegmentType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioOnlyHlsSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioOnlyHlsSettingsProperty.Jsii$Proxy that = (AudioOnlyHlsSettingsProperty.Jsii$Proxy) o;

                if (this.audioGroupId != null ? !this.audioGroupId.equals(that.audioGroupId) : that.audioGroupId != null) return false;
                if (this.audioOnlyImage != null ? !this.audioOnlyImage.equals(that.audioOnlyImage) : that.audioOnlyImage != null) return false;
                if (this.audioTrackType != null ? !this.audioTrackType.equals(that.audioTrackType) : that.audioTrackType != null) return false;
                return this.segmentType != null ? this.segmentType.equals(that.segmentType) : that.segmentType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.audioGroupId != null ? this.audioGroupId.hashCode() : 0;
                result = 31 * result + (this.audioOnlyImage != null ? this.audioOnlyImage.hashCode() : 0);
                result = 31 * result + (this.audioTrackType != null ? this.audioTrackType.hashCode() : 0);
                result = 31 * result + (this.segmentType != null ? this.segmentType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Used to extract audio by The PID.
     * <p>
     * The parent of this entity is AudioSelectorSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioPidSelectionProperty audioPidSelectionProperty = AudioPidSelectionProperty.builder()
     *         .pid(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiopidselection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiopidselection.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioPidSelectionProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioPidSelectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioPidSelectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Select the audio by this PID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiopidselection.html#cfn-medialive-channel-audiopidselection-pid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiopidselection.html#cfn-medialive-channel-audiopidselection-pid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPid() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioPidSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioPidSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioPidSelectionProperty> {
            java.lang.Number pid;

            /**
             * Sets the value of {@link AudioPidSelectionProperty#getPid}
             * @param pid Select the audio by this PID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pid(java.lang.Number pid) {
                this.pid = pid;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioPidSelectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioPidSelectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioPidSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioPidSelectionProperty {
            private final java.lang.Number pid;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pid = software.amazon.jsii.Kernel.get(this, "pid", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pid = builder.pid;
            }

            @Override
            public final java.lang.Number getPid() {
                return this.pid;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPid() != null) {
                    data.set("pid", om.valueToTree(this.getPid()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioPidSelectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioPidSelectionProperty.Jsii$Proxy that = (AudioPidSelectionProperty.Jsii$Proxy) o;

                return this.pid != null ? this.pid.equals(that.pid) : that.pid == null;
            }

            @Override
            public final int hashCode() {
                int result = this.pid != null ? this.pid.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Information about one audio to extract from the input.
     * <p>
     * The parent of this entity is InputSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioSelectorProperty audioSelectorProperty = AudioSelectorProperty.builder()
     *         .name("name")
     *         .selectorSettings(AudioSelectorSettingsProperty.builder()
     *                 .audioHlsRenditionSelection(AudioHlsRenditionSelectionProperty.builder()
     *                         .groupId("groupId")
     *                         .name("name")
     *                         .build())
     *                 .audioLanguageSelection(AudioLanguageSelectionProperty.builder()
     *                         .languageCode("languageCode")
     *                         .languageSelectionPolicy("languageSelectionPolicy")
     *                         .build())
     *                 .audioPidSelection(AudioPidSelectionProperty.builder()
     *                         .pid(123)
     *                         .build())
     *                 .audioTrackSelection(AudioTrackSelectionProperty.builder()
     *                         .dolbyEDecode(AudioDolbyEDecodeProperty.builder()
     *                                 .programSelection("programSelection")
     *                                 .build())
     *                         .tracks(List.of(AudioTrackProperty.builder()
     *                                 .track(123)
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselector.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselector.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioSelectorProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioSelectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioSelectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name for this AudioSelector.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselector.html#cfn-medialive-channel-audioselector-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselector.html#cfn-medialive-channel-audioselector-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * Information about the specific audio to extract from the input.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.AudioSelectorSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselector.html#cfn-medialive-channel-audioselector-selectorsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselector.html#cfn-medialive-channel-audioselector-selectorsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSelectorSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioSelectorProperty> {
            java.lang.String name;
            java.lang.Object selectorSettings;

            /**
             * Sets the value of {@link AudioSelectorProperty#getName}
             * @param name A name for this AudioSelector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link AudioSelectorProperty#getSelectorSettings}
             * @param selectorSettings Information about the specific audio to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectorSettings(software.amazon.awscdk.IResolvable selectorSettings) {
                this.selectorSettings = selectorSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioSelectorProperty#getSelectorSettings}
             * @param selectorSettings Information about the specific audio to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectorSettings(software.amazon.awscdk.services.medialive.CfnChannel.AudioSelectorSettingsProperty selectorSettings) {
                this.selectorSettings = selectorSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioSelectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioSelectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioSelectorProperty {
            private final java.lang.String name;
            private final java.lang.Object selectorSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.selectorSettings = software.amazon.jsii.Kernel.get(this, "selectorSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.selectorSettings = builder.selectorSettings;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getSelectorSettings() {
                return this.selectorSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getSelectorSettings() != null) {
                    data.set("selectorSettings", om.valueToTree(this.getSelectorSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioSelectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioSelectorProperty.Jsii$Proxy that = (AudioSelectorProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.selectorSettings != null ? this.selectorSettings.equals(that.selectorSettings) : that.selectorSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.selectorSettings != null ? this.selectorSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the audio to extract from the input.
     * <p>
     * The parent of this entity is AudioSelector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioSelectorSettingsProperty audioSelectorSettingsProperty = AudioSelectorSettingsProperty.builder()
     *         .audioHlsRenditionSelection(AudioHlsRenditionSelectionProperty.builder()
     *                 .groupId("groupId")
     *                 .name("name")
     *                 .build())
     *         .audioLanguageSelection(AudioLanguageSelectionProperty.builder()
     *                 .languageCode("languageCode")
     *                 .languageSelectionPolicy("languageSelectionPolicy")
     *                 .build())
     *         .audioPidSelection(AudioPidSelectionProperty.builder()
     *                 .pid(123)
     *                 .build())
     *         .audioTrackSelection(AudioTrackSelectionProperty.builder()
     *                 .dolbyEDecode(AudioDolbyEDecodeProperty.builder()
     *                         .programSelection("programSelection")
     *                         .build())
     *                 .tracks(List.of(AudioTrackProperty.builder()
     *                         .track(123)
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioSelectorSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioSelectorSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioSelectorSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Selector for HLS audio rendition.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.AudioHlsRenditionSelectionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html#cfn-medialive-channel-audioselectorsettings-audiohlsrenditionselection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html#cfn-medialive-channel-audioselectorsettings-audiohlsrenditionselection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudioHlsRenditionSelection() {
            return null;
        }

        /**
         * The language code of the audio to select.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.AudioLanguageSelectionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html#cfn-medialive-channel-audioselectorsettings-audiolanguageselection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html#cfn-medialive-channel-audioselectorsettings-audiolanguageselection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudioLanguageSelection() {
            return null;
        }

        /**
         * The PID of the audio to select.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.AudioPidSelectionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html#cfn-medialive-channel-audioselectorsettings-audiopidselection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html#cfn-medialive-channel-audioselectorsettings-audiopidselection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudioPidSelection() {
            return null;
        }

        /**
         * Information about the audio track to extract.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.AudioTrackSelectionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html#cfn-medialive-channel-audioselectorsettings-audiotrackselection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html#cfn-medialive-channel-audioselectorsettings-audiotrackselection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudioTrackSelection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioSelectorSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioSelectorSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioSelectorSettingsProperty> {
            java.lang.Object audioHlsRenditionSelection;
            java.lang.Object audioLanguageSelection;
            java.lang.Object audioPidSelection;
            java.lang.Object audioTrackSelection;

            /**
             * Sets the value of {@link AudioSelectorSettingsProperty#getAudioHlsRenditionSelection}
             * @param audioHlsRenditionSelection Selector for HLS audio rendition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioHlsRenditionSelection(software.amazon.awscdk.IResolvable audioHlsRenditionSelection) {
                this.audioHlsRenditionSelection = audioHlsRenditionSelection;
                return this;
            }

            /**
             * Sets the value of {@link AudioSelectorSettingsProperty#getAudioHlsRenditionSelection}
             * @param audioHlsRenditionSelection Selector for HLS audio rendition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioHlsRenditionSelection(software.amazon.awscdk.services.medialive.CfnChannel.AudioHlsRenditionSelectionProperty audioHlsRenditionSelection) {
                this.audioHlsRenditionSelection = audioHlsRenditionSelection;
                return this;
            }

            /**
             * Sets the value of {@link AudioSelectorSettingsProperty#getAudioLanguageSelection}
             * @param audioLanguageSelection The language code of the audio to select.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioLanguageSelection(software.amazon.awscdk.IResolvable audioLanguageSelection) {
                this.audioLanguageSelection = audioLanguageSelection;
                return this;
            }

            /**
             * Sets the value of {@link AudioSelectorSettingsProperty#getAudioLanguageSelection}
             * @param audioLanguageSelection The language code of the audio to select.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioLanguageSelection(software.amazon.awscdk.services.medialive.CfnChannel.AudioLanguageSelectionProperty audioLanguageSelection) {
                this.audioLanguageSelection = audioLanguageSelection;
                return this;
            }

            /**
             * Sets the value of {@link AudioSelectorSettingsProperty#getAudioPidSelection}
             * @param audioPidSelection The PID of the audio to select.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioPidSelection(software.amazon.awscdk.IResolvable audioPidSelection) {
                this.audioPidSelection = audioPidSelection;
                return this;
            }

            /**
             * Sets the value of {@link AudioSelectorSettingsProperty#getAudioPidSelection}
             * @param audioPidSelection The PID of the audio to select.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioPidSelection(software.amazon.awscdk.services.medialive.CfnChannel.AudioPidSelectionProperty audioPidSelection) {
                this.audioPidSelection = audioPidSelection;
                return this;
            }

            /**
             * Sets the value of {@link AudioSelectorSettingsProperty#getAudioTrackSelection}
             * @param audioTrackSelection Information about the audio track to extract.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioTrackSelection(software.amazon.awscdk.IResolvable audioTrackSelection) {
                this.audioTrackSelection = audioTrackSelection;
                return this;
            }

            /**
             * Sets the value of {@link AudioSelectorSettingsProperty#getAudioTrackSelection}
             * @param audioTrackSelection Information about the audio track to extract.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioTrackSelection(software.amazon.awscdk.services.medialive.CfnChannel.AudioTrackSelectionProperty audioTrackSelection) {
                this.audioTrackSelection = audioTrackSelection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioSelectorSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioSelectorSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioSelectorSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioSelectorSettingsProperty {
            private final java.lang.Object audioHlsRenditionSelection;
            private final java.lang.Object audioLanguageSelection;
            private final java.lang.Object audioPidSelection;
            private final java.lang.Object audioTrackSelection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audioHlsRenditionSelection = software.amazon.jsii.Kernel.get(this, "audioHlsRenditionSelection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.audioLanguageSelection = software.amazon.jsii.Kernel.get(this, "audioLanguageSelection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.audioPidSelection = software.amazon.jsii.Kernel.get(this, "audioPidSelection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.audioTrackSelection = software.amazon.jsii.Kernel.get(this, "audioTrackSelection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audioHlsRenditionSelection = builder.audioHlsRenditionSelection;
                this.audioLanguageSelection = builder.audioLanguageSelection;
                this.audioPidSelection = builder.audioPidSelection;
                this.audioTrackSelection = builder.audioTrackSelection;
            }

            @Override
            public final java.lang.Object getAudioHlsRenditionSelection() {
                return this.audioHlsRenditionSelection;
            }

            @Override
            public final java.lang.Object getAudioLanguageSelection() {
                return this.audioLanguageSelection;
            }

            @Override
            public final java.lang.Object getAudioPidSelection() {
                return this.audioPidSelection;
            }

            @Override
            public final java.lang.Object getAudioTrackSelection() {
                return this.audioTrackSelection;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAudioHlsRenditionSelection() != null) {
                    data.set("audioHlsRenditionSelection", om.valueToTree(this.getAudioHlsRenditionSelection()));
                }
                if (this.getAudioLanguageSelection() != null) {
                    data.set("audioLanguageSelection", om.valueToTree(this.getAudioLanguageSelection()));
                }
                if (this.getAudioPidSelection() != null) {
                    data.set("audioPidSelection", om.valueToTree(this.getAudioPidSelection()));
                }
                if (this.getAudioTrackSelection() != null) {
                    data.set("audioTrackSelection", om.valueToTree(this.getAudioTrackSelection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioSelectorSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioSelectorSettingsProperty.Jsii$Proxy that = (AudioSelectorSettingsProperty.Jsii$Proxy) o;

                if (this.audioHlsRenditionSelection != null ? !this.audioHlsRenditionSelection.equals(that.audioHlsRenditionSelection) : that.audioHlsRenditionSelection != null) return false;
                if (this.audioLanguageSelection != null ? !this.audioLanguageSelection.equals(that.audioLanguageSelection) : that.audioLanguageSelection != null) return false;
                if (this.audioPidSelection != null ? !this.audioPidSelection.equals(that.audioPidSelection) : that.audioPidSelection != null) return false;
                return this.audioTrackSelection != null ? this.audioTrackSelection.equals(that.audioTrackSelection) : that.audioTrackSelection == null;
            }

            @Override
            public final int hashCode() {
                int result = this.audioHlsRenditionSelection != null ? this.audioHlsRenditionSelection.hashCode() : 0;
                result = 31 * result + (this.audioLanguageSelection != null ? this.audioLanguageSelection.hashCode() : 0);
                result = 31 * result + (this.audioPidSelection != null ? this.audioPidSelection.hashCode() : 0);
                result = 31 * result + (this.audioTrackSelection != null ? this.audioTrackSelection.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * MediaLive will perform a failover if audio is not detected in this input for the specified period.
     * <p>
     * The parent of this entity is FailoverConditionSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioSilenceFailoverSettingsProperty audioSilenceFailoverSettingsProperty = AudioSilenceFailoverSettingsProperty.builder()
     *         .audioSelectorName("audioSelectorName")
     *         .audioSilenceThresholdMsec(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiosilencefailoversettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiosilencefailoversettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioSilenceFailoverSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioSilenceFailoverSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioSilenceFailoverSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the audio selector in the input that MediaLive should monitor to detect silence.
         * <p>
         * Select your most important rendition. If you didn't create an audio selector in this input, leave blank.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiosilencefailoversettings.html#cfn-medialive-channel-audiosilencefailoversettings-audioselectorname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiosilencefailoversettings.html#cfn-medialive-channel-audiosilencefailoversettings-audioselectorname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAudioSelectorName() {
            return null;
        }

        /**
         * The amount of time (in milliseconds) that the active input must be silent before automatic input failover occurs.
         * <p>
         * Silence is defined as audio loss or audio quieter than -50 dBFS.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiosilencefailoversettings.html#cfn-medialive-channel-audiosilencefailoversettings-audiosilencethresholdmsec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiosilencefailoversettings.html#cfn-medialive-channel-audiosilencefailoversettings-audiosilencethresholdmsec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAudioSilenceThresholdMsec() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioSilenceFailoverSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioSilenceFailoverSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioSilenceFailoverSettingsProperty> {
            java.lang.String audioSelectorName;
            java.lang.Number audioSilenceThresholdMsec;

            /**
             * Sets the value of {@link AudioSilenceFailoverSettingsProperty#getAudioSelectorName}
             * @param audioSelectorName The name of the audio selector in the input that MediaLive should monitor to detect silence.
             *                          Select your most important rendition. If you didn't create an audio selector in this input, leave blank.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioSelectorName(java.lang.String audioSelectorName) {
                this.audioSelectorName = audioSelectorName;
                return this;
            }

            /**
             * Sets the value of {@link AudioSilenceFailoverSettingsProperty#getAudioSilenceThresholdMsec}
             * @param audioSilenceThresholdMsec The amount of time (in milliseconds) that the active input must be silent before automatic input failover occurs.
             *                                  Silence is defined as audio loss or audio quieter than -50 dBFS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioSilenceThresholdMsec(java.lang.Number audioSilenceThresholdMsec) {
                this.audioSilenceThresholdMsec = audioSilenceThresholdMsec;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioSilenceFailoverSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioSilenceFailoverSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioSilenceFailoverSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioSilenceFailoverSettingsProperty {
            private final java.lang.String audioSelectorName;
            private final java.lang.Number audioSilenceThresholdMsec;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audioSelectorName = software.amazon.jsii.Kernel.get(this, "audioSelectorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.audioSilenceThresholdMsec = software.amazon.jsii.Kernel.get(this, "audioSilenceThresholdMsec", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audioSelectorName = builder.audioSelectorName;
                this.audioSilenceThresholdMsec = builder.audioSilenceThresholdMsec;
            }

            @Override
            public final java.lang.String getAudioSelectorName() {
                return this.audioSelectorName;
            }

            @Override
            public final java.lang.Number getAudioSilenceThresholdMsec() {
                return this.audioSilenceThresholdMsec;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAudioSelectorName() != null) {
                    data.set("audioSelectorName", om.valueToTree(this.getAudioSelectorName()));
                }
                if (this.getAudioSilenceThresholdMsec() != null) {
                    data.set("audioSilenceThresholdMsec", om.valueToTree(this.getAudioSilenceThresholdMsec()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioSilenceFailoverSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioSilenceFailoverSettingsProperty.Jsii$Proxy that = (AudioSilenceFailoverSettingsProperty.Jsii$Proxy) o;

                if (this.audioSelectorName != null ? !this.audioSelectorName.equals(that.audioSelectorName) : that.audioSelectorName != null) return false;
                return this.audioSilenceThresholdMsec != null ? this.audioSilenceThresholdMsec.equals(that.audioSilenceThresholdMsec) : that.audioSilenceThresholdMsec == null;
            }

            @Override
            public final int hashCode() {
                int result = this.audioSelectorName != null ? this.audioSelectorName.hashCode() : 0;
                result = 31 * result + (this.audioSilenceThresholdMsec != null ? this.audioSilenceThresholdMsec.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about one audio track to extract. You can select multiple tracks.
     * <p>
     * The parent of this entity is AudioTrackSelection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioTrackProperty audioTrackProperty = AudioTrackProperty.builder()
     *         .track(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiotrack.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiotrack.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioTrackProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioTrackProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioTrackProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * 1-based integer value that maps to a specific audio track.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiotrack.html#cfn-medialive-channel-audiotrack-track">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiotrack.html#cfn-medialive-channel-audiotrack-track</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTrack() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioTrackProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioTrackProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioTrackProperty> {
            java.lang.Number track;

            /**
             * Sets the value of {@link AudioTrackProperty#getTrack}
             * @param track 1-based integer value that maps to a specific audio track.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder track(java.lang.Number track) {
                this.track = track;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioTrackProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioTrackProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioTrackProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioTrackProperty {
            private final java.lang.Number track;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.track = software.amazon.jsii.Kernel.get(this, "track", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.track = builder.track;
            }

            @Override
            public final java.lang.Number getTrack() {
                return this.track;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTrack() != null) {
                    data.set("track", om.valueToTree(this.getTrack()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioTrackProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioTrackProperty.Jsii$Proxy that = (AudioTrackProperty.Jsii$Proxy) o;

                return this.track != null ? this.track.equals(that.track) : that.track == null;
            }

            @Override
            public final int hashCode() {
                int result = this.track != null ? this.track.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Information about the audio track to extract.
     * <p>
     * The parent of this entity is AudioSelectorSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioTrackSelectionProperty audioTrackSelectionProperty = AudioTrackSelectionProperty.builder()
     *         .dolbyEDecode(AudioDolbyEDecodeProperty.builder()
     *                 .programSelection("programSelection")
     *                 .build())
     *         .tracks(List.of(AudioTrackProperty.builder()
     *                 .track(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiotrackselection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiotrackselection.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioTrackSelectionProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioTrackSelectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioTrackSelectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.AudioDolbyEDecodeProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiotrackselection.html#cfn-medialive-channel-audiotrackselection-dolbyedecode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiotrackselection.html#cfn-medialive-channel-audiotrackselection-dolbyedecode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDolbyEDecode() {
            return null;
        }

        /**
         * Selects one or more unique audio tracks from within a source.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.AudioTrackProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiotrackselection.html#cfn-medialive-channel-audiotrackselection-tracks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiotrackselection.html#cfn-medialive-channel-audiotrackselection-tracks</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTracks() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioTrackSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioTrackSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioTrackSelectionProperty> {
            java.lang.Object dolbyEDecode;
            java.lang.Object tracks;

            /**
             * Sets the value of {@link AudioTrackSelectionProperty#getDolbyEDecode}
             * @param dolbyEDecode the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dolbyEDecode(software.amazon.awscdk.IResolvable dolbyEDecode) {
                this.dolbyEDecode = dolbyEDecode;
                return this;
            }

            /**
             * Sets the value of {@link AudioTrackSelectionProperty#getDolbyEDecode}
             * @param dolbyEDecode the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dolbyEDecode(software.amazon.awscdk.services.medialive.CfnChannel.AudioDolbyEDecodeProperty dolbyEDecode) {
                this.dolbyEDecode = dolbyEDecode;
                return this;
            }

            /**
             * Sets the value of {@link AudioTrackSelectionProperty#getTracks}
             * @param tracks Selects one or more unique audio tracks from within a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tracks(software.amazon.awscdk.IResolvable tracks) {
                this.tracks = tracks;
                return this;
            }

            /**
             * Sets the value of {@link AudioTrackSelectionProperty#getTracks}
             * @param tracks Selects one or more unique audio tracks from within a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tracks(java.util.List<? extends java.lang.Object> tracks) {
                this.tracks = tracks;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioTrackSelectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioTrackSelectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioTrackSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioTrackSelectionProperty {
            private final java.lang.Object dolbyEDecode;
            private final java.lang.Object tracks;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dolbyEDecode = software.amazon.jsii.Kernel.get(this, "dolbyEDecode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tracks = software.amazon.jsii.Kernel.get(this, "tracks", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dolbyEDecode = builder.dolbyEDecode;
                this.tracks = builder.tracks;
            }

            @Override
            public final java.lang.Object getDolbyEDecode() {
                return this.dolbyEDecode;
            }

            @Override
            public final java.lang.Object getTracks() {
                return this.tracks;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDolbyEDecode() != null) {
                    data.set("dolbyEDecode", om.valueToTree(this.getDolbyEDecode()));
                }
                if (this.getTracks() != null) {
                    data.set("tracks", om.valueToTree(this.getTracks()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioTrackSelectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioTrackSelectionProperty.Jsii$Proxy that = (AudioTrackSelectionProperty.Jsii$Proxy) o;

                if (this.dolbyEDecode != null ? !this.dolbyEDecode.equals(that.dolbyEDecode) : that.dolbyEDecode != null) return false;
                return this.tracks != null ? this.tracks.equals(that.tracks) : that.tracks == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dolbyEDecode != null ? this.dolbyEDecode.hashCode() : 0;
                result = 31 * result + (this.tracks != null ? this.tracks.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Audio Watermark Settings.
     * <p>
     * The parent of this entity is AudioDescription.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioWatermarkSettingsProperty audioWatermarkSettingsProperty = AudioWatermarkSettingsProperty.builder()
     *         .nielsenWatermarksSettings(NielsenWatermarksSettingsProperty.builder()
     *                 .nielsenCbetSettings(NielsenCBETProperty.builder()
     *                         .cbetCheckDigitString("cbetCheckDigitString")
     *                         .cbetStepaside("cbetStepaside")
     *                         .csid("csid")
     *                         .build())
     *                 .nielsenDistributionType("nielsenDistributionType")
     *                 .nielsenNaesIiNwSettings(NielsenNaesIiNwProperty.builder()
     *                         .checkDigitString("checkDigitString")
     *                         .sid(123)
     *                         .timezone("timezone")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiowatermarksettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiowatermarksettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioWatermarkSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioWatermarkSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioWatermarkSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Settings to configure Nielsen Watermarks in the audio encode.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.NielsenWatermarksSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiowatermarksettings.html#cfn-medialive-channel-audiowatermarksettings-nielsenwatermarkssettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiowatermarksettings.html#cfn-medialive-channel-audiowatermarksettings-nielsenwatermarkssettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNielsenWatermarksSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioWatermarkSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioWatermarkSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioWatermarkSettingsProperty> {
            java.lang.Object nielsenWatermarksSettings;

            /**
             * Sets the value of {@link AudioWatermarkSettingsProperty#getNielsenWatermarksSettings}
             * @param nielsenWatermarksSettings Settings to configure Nielsen Watermarks in the audio encode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nielsenWatermarksSettings(software.amazon.awscdk.IResolvable nielsenWatermarksSettings) {
                this.nielsenWatermarksSettings = nielsenWatermarksSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioWatermarkSettingsProperty#getNielsenWatermarksSettings}
             * @param nielsenWatermarksSettings Settings to configure Nielsen Watermarks in the audio encode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nielsenWatermarksSettings(software.amazon.awscdk.services.medialive.CfnChannel.NielsenWatermarksSettingsProperty nielsenWatermarksSettings) {
                this.nielsenWatermarksSettings = nielsenWatermarksSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioWatermarkSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioWatermarkSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioWatermarkSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioWatermarkSettingsProperty {
            private final java.lang.Object nielsenWatermarksSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.nielsenWatermarksSettings = software.amazon.jsii.Kernel.get(this, "nielsenWatermarksSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.nielsenWatermarksSettings = builder.nielsenWatermarksSettings;
            }

            @Override
            public final java.lang.Object getNielsenWatermarksSettings() {
                return this.nielsenWatermarksSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNielsenWatermarksSettings() != null) {
                    data.set("nielsenWatermarksSettings", om.valueToTree(this.getNielsenWatermarksSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioWatermarkSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioWatermarkSettingsProperty.Jsii$Proxy that = (AudioWatermarkSettingsProperty.Jsii$Proxy) o;

                return this.nielsenWatermarksSettings != null ? this.nielsenWatermarksSettings.equals(that.nielsenWatermarksSettings) : that.nielsenWatermarksSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.nielsenWatermarksSettings != null ? this.nielsenWatermarksSettings.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Settings to configure the conditions that will define the input as unhealthy and that will make MediaLive fail over to the other input in the input failover pair.
     * <p>
     * The parent of this entity is InputAttachment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AutomaticInputFailoverSettingsProperty automaticInputFailoverSettingsProperty = AutomaticInputFailoverSettingsProperty.builder()
     *         .errorClearTimeMsec(123)
     *         .failoverConditions(List.of(FailoverConditionProperty.builder()
     *                 .failoverConditionSettings(FailoverConditionSettingsProperty.builder()
     *                         .audioSilenceSettings(AudioSilenceFailoverSettingsProperty.builder()
     *                                 .audioSelectorName("audioSelectorName")
     *                                 .audioSilenceThresholdMsec(123)
     *                                 .build())
     *                         .inputLossSettings(InputLossFailoverSettingsProperty.builder()
     *                                 .inputLossThresholdMsec(123)
     *                                 .build())
     *                         .videoBlackSettings(VideoBlackFailoverSettingsProperty.builder()
     *                                 .blackDetectThreshold(123)
     *                                 .videoBlackThresholdMsec(123)
     *                                 .build())
     *                         .build())
     *                 .build()))
     *         .inputPreference("inputPreference")
     *         .secondaryInputId("secondaryInputId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AutomaticInputFailoverSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AutomaticInputFailoverSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutomaticInputFailoverSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This clear time defines the requirement a recovered input must meet to be considered healthy.
         * <p>
         * The input must have no failover conditions for this length of time. Enter a time in milliseconds. This value is particularly important if the input_preference for the failover pair is set to PRIMARY_INPUT_PREFERRED, because after this time, MediaLive will switch back to the primary input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html#cfn-medialive-channel-automaticinputfailoversettings-errorcleartimemsec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html#cfn-medialive-channel-automaticinputfailoversettings-errorcleartimemsec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getErrorClearTimeMsec() {
            return null;
        }

        /**
         * A list of failover conditions.
         * <p>
         * If any of these conditions occur, MediaLive will perform a failover to the other input.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.FailoverConditionProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html#cfn-medialive-channel-automaticinputfailoversettings-failoverconditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html#cfn-medialive-channel-automaticinputfailoversettings-failoverconditions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFailoverConditions() {
            return null;
        }

        /**
         * Input preference when deciding which input to make active when a previously failed input has recovered.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html#cfn-medialive-channel-automaticinputfailoversettings-inputpreference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html#cfn-medialive-channel-automaticinputfailoversettings-inputpreference</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputPreference() {
            return null;
        }

        /**
         * The input ID of the secondary input in the automatic input failover pair.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html#cfn-medialive-channel-automaticinputfailoversettings-secondaryinputid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html#cfn-medialive-channel-automaticinputfailoversettings-secondaryinputid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecondaryInputId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutomaticInputFailoverSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutomaticInputFailoverSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutomaticInputFailoverSettingsProperty> {
            java.lang.Number errorClearTimeMsec;
            java.lang.Object failoverConditions;
            java.lang.String inputPreference;
            java.lang.String secondaryInputId;

            /**
             * Sets the value of {@link AutomaticInputFailoverSettingsProperty#getErrorClearTimeMsec}
             * @param errorClearTimeMsec This clear time defines the requirement a recovered input must meet to be considered healthy.
             *                           The input must have no failover conditions for this length of time. Enter a time in milliseconds. This value is particularly important if the input_preference for the failover pair is set to PRIMARY_INPUT_PREFERRED, because after this time, MediaLive will switch back to the primary input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorClearTimeMsec(java.lang.Number errorClearTimeMsec) {
                this.errorClearTimeMsec = errorClearTimeMsec;
                return this;
            }

            /**
             * Sets the value of {@link AutomaticInputFailoverSettingsProperty#getFailoverConditions}
             * @param failoverConditions A list of failover conditions.
             *                           If any of these conditions occur, MediaLive will perform a failover to the other input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failoverConditions(software.amazon.awscdk.IResolvable failoverConditions) {
                this.failoverConditions = failoverConditions;
                return this;
            }

            /**
             * Sets the value of {@link AutomaticInputFailoverSettingsProperty#getFailoverConditions}
             * @param failoverConditions A list of failover conditions.
             *                           If any of these conditions occur, MediaLive will perform a failover to the other input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failoverConditions(java.util.List<? extends java.lang.Object> failoverConditions) {
                this.failoverConditions = failoverConditions;
                return this;
            }

            /**
             * Sets the value of {@link AutomaticInputFailoverSettingsProperty#getInputPreference}
             * @param inputPreference Input preference when deciding which input to make active when a previously failed input has recovered.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputPreference(java.lang.String inputPreference) {
                this.inputPreference = inputPreference;
                return this;
            }

            /**
             * Sets the value of {@link AutomaticInputFailoverSettingsProperty#getSecondaryInputId}
             * @param secondaryInputId The input ID of the secondary input in the automatic input failover pair.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondaryInputId(java.lang.String secondaryInputId) {
                this.secondaryInputId = secondaryInputId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutomaticInputFailoverSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutomaticInputFailoverSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutomaticInputFailoverSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutomaticInputFailoverSettingsProperty {
            private final java.lang.Number errorClearTimeMsec;
            private final java.lang.Object failoverConditions;
            private final java.lang.String inputPreference;
            private final java.lang.String secondaryInputId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.errorClearTimeMsec = software.amazon.jsii.Kernel.get(this, "errorClearTimeMsec", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.failoverConditions = software.amazon.jsii.Kernel.get(this, "failoverConditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inputPreference = software.amazon.jsii.Kernel.get(this, "inputPreference", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secondaryInputId = software.amazon.jsii.Kernel.get(this, "secondaryInputId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.errorClearTimeMsec = builder.errorClearTimeMsec;
                this.failoverConditions = builder.failoverConditions;
                this.inputPreference = builder.inputPreference;
                this.secondaryInputId = builder.secondaryInputId;
            }

            @Override
            public final java.lang.Number getErrorClearTimeMsec() {
                return this.errorClearTimeMsec;
            }

            @Override
            public final java.lang.Object getFailoverConditions() {
                return this.failoverConditions;
            }

            @Override
            public final java.lang.String getInputPreference() {
                return this.inputPreference;
            }

            @Override
            public final java.lang.String getSecondaryInputId() {
                return this.secondaryInputId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getErrorClearTimeMsec() != null) {
                    data.set("errorClearTimeMsec", om.valueToTree(this.getErrorClearTimeMsec()));
                }
                if (this.getFailoverConditions() != null) {
                    data.set("failoverConditions", om.valueToTree(this.getFailoverConditions()));
                }
                if (this.getInputPreference() != null) {
                    data.set("inputPreference", om.valueToTree(this.getInputPreference()));
                }
                if (this.getSecondaryInputId() != null) {
                    data.set("secondaryInputId", om.valueToTree(this.getSecondaryInputId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AutomaticInputFailoverSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutomaticInputFailoverSettingsProperty.Jsii$Proxy that = (AutomaticInputFailoverSettingsProperty.Jsii$Proxy) o;

                if (this.errorClearTimeMsec != null ? !this.errorClearTimeMsec.equals(that.errorClearTimeMsec) : that.errorClearTimeMsec != null) return false;
                if (this.failoverConditions != null ? !this.failoverConditions.equals(that.failoverConditions) : that.failoverConditions != null) return false;
                if (this.inputPreference != null ? !this.inputPreference.equals(that.inputPreference) : that.inputPreference != null) return false;
                return this.secondaryInputId != null ? this.secondaryInputId.equals(that.secondaryInputId) : that.secondaryInputId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.errorClearTimeMsec != null ? this.errorClearTimeMsec.hashCode() : 0;
                result = 31 * result + (this.failoverConditions != null ? this.failoverConditions.hashCode() : 0);
                result = 31 * result + (this.inputPreference != null ? this.inputPreference.hashCode() : 0);
                result = 31 * result + (this.secondaryInputId != null ? this.secondaryInputId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * Object colorSpacePassthroughSettings;
     * Object rec601Settings;
     * Object rec709Settings;
     * Av1ColorSpaceSettingsProperty av1ColorSpaceSettingsProperty = Av1ColorSpaceSettingsProperty.builder()
     *         .colorSpacePassthroughSettings(colorSpacePassthroughSettings)
     *         .hdr10Settings(Hdr10SettingsProperty.builder()
     *                 .maxCll(123)
     *                 .maxFall(123)
     *                 .build())
     *         .rec601Settings(rec601Settings)
     *         .rec709Settings(rec709Settings)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1colorspacesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1colorspacesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.Av1ColorSpaceSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(Av1ColorSpaceSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Av1ColorSpaceSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1colorspacesettings.html#cfn-medialive-channel-av1colorspacesettings-colorspacepassthroughsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1colorspacesettings.html#cfn-medialive-channel-av1colorspacesettings-colorspacepassthroughsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColorSpacePassthroughSettings() {
            return null;
        }

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.Hdr10SettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1colorspacesettings.html#cfn-medialive-channel-av1colorspacesettings-hdr10settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1colorspacesettings.html#cfn-medialive-channel-av1colorspacesettings-hdr10settings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHdr10Settings() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1colorspacesettings.html#cfn-medialive-channel-av1colorspacesettings-rec601settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1colorspacesettings.html#cfn-medialive-channel-av1colorspacesettings-rec601settings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRec601Settings() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1colorspacesettings.html#cfn-medialive-channel-av1colorspacesettings-rec709settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1colorspacesettings.html#cfn-medialive-channel-av1colorspacesettings-rec709settings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRec709Settings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Av1ColorSpaceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Av1ColorSpaceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Av1ColorSpaceSettingsProperty> {
            java.lang.Object colorSpacePassthroughSettings;
            java.lang.Object hdr10Settings;
            java.lang.Object rec601Settings;
            java.lang.Object rec709Settings;

            /**
             * Sets the value of {@link Av1ColorSpaceSettingsProperty#getColorSpacePassthroughSettings}
             * @param colorSpacePassthroughSettings the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colorSpacePassthroughSettings(java.lang.Object colorSpacePassthroughSettings) {
                this.colorSpacePassthroughSettings = colorSpacePassthroughSettings;
                return this;
            }

            /**
             * Sets the value of {@link Av1ColorSpaceSettingsProperty#getHdr10Settings}
             * @param hdr10Settings the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hdr10Settings(software.amazon.awscdk.IResolvable hdr10Settings) {
                this.hdr10Settings = hdr10Settings;
                return this;
            }

            /**
             * Sets the value of {@link Av1ColorSpaceSettingsProperty#getHdr10Settings}
             * @param hdr10Settings the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hdr10Settings(software.amazon.awscdk.services.medialive.CfnChannel.Hdr10SettingsProperty hdr10Settings) {
                this.hdr10Settings = hdr10Settings;
                return this;
            }

            /**
             * Sets the value of {@link Av1ColorSpaceSettingsProperty#getRec601Settings}
             * @param rec601Settings the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rec601Settings(java.lang.Object rec601Settings) {
                this.rec601Settings = rec601Settings;
                return this;
            }

            /**
             * Sets the value of {@link Av1ColorSpaceSettingsProperty#getRec709Settings}
             * @param rec709Settings the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rec709Settings(java.lang.Object rec709Settings) {
                this.rec709Settings = rec709Settings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Av1ColorSpaceSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Av1ColorSpaceSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Av1ColorSpaceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Av1ColorSpaceSettingsProperty {
            private final java.lang.Object colorSpacePassthroughSettings;
            private final java.lang.Object hdr10Settings;
            private final java.lang.Object rec601Settings;
            private final java.lang.Object rec709Settings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.colorSpacePassthroughSettings = software.amazon.jsii.Kernel.get(this, "colorSpacePassthroughSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hdr10Settings = software.amazon.jsii.Kernel.get(this, "hdr10Settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rec601Settings = software.amazon.jsii.Kernel.get(this, "rec601Settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rec709Settings = software.amazon.jsii.Kernel.get(this, "rec709Settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.colorSpacePassthroughSettings = builder.colorSpacePassthroughSettings;
                this.hdr10Settings = builder.hdr10Settings;
                this.rec601Settings = builder.rec601Settings;
                this.rec709Settings = builder.rec709Settings;
            }

            @Override
            public final java.lang.Object getColorSpacePassthroughSettings() {
                return this.colorSpacePassthroughSettings;
            }

            @Override
            public final java.lang.Object getHdr10Settings() {
                return this.hdr10Settings;
            }

            @Override
            public final java.lang.Object getRec601Settings() {
                return this.rec601Settings;
            }

            @Override
            public final java.lang.Object getRec709Settings() {
                return this.rec709Settings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColorSpacePassthroughSettings() != null) {
                    data.set("colorSpacePassthroughSettings", om.valueToTree(this.getColorSpacePassthroughSettings()));
                }
                if (this.getHdr10Settings() != null) {
                    data.set("hdr10Settings", om.valueToTree(this.getHdr10Settings()));
                }
                if (this.getRec601Settings() != null) {
                    data.set("rec601Settings", om.valueToTree(this.getRec601Settings()));
                }
                if (this.getRec709Settings() != null) {
                    data.set("rec709Settings", om.valueToTree(this.getRec709Settings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.Av1ColorSpaceSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Av1ColorSpaceSettingsProperty.Jsii$Proxy that = (Av1ColorSpaceSettingsProperty.Jsii$Proxy) o;

                if (this.colorSpacePassthroughSettings != null ? !this.colorSpacePassthroughSettings.equals(that.colorSpacePassthroughSettings) : that.colorSpacePassthroughSettings != null) return false;
                if (this.hdr10Settings != null ? !this.hdr10Settings.equals(that.hdr10Settings) : that.hdr10Settings != null) return false;
                if (this.rec601Settings != null ? !this.rec601Settings.equals(that.rec601Settings) : that.rec601Settings != null) return false;
                return this.rec709Settings != null ? this.rec709Settings.equals(that.rec709Settings) : that.rec709Settings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.colorSpacePassthroughSettings != null ? this.colorSpacePassthroughSettings.hashCode() : 0;
                result = 31 * result + (this.hdr10Settings != null ? this.hdr10Settings.hashCode() : 0);
                result = 31 * result + (this.rec601Settings != null ? this.rec601Settings.hashCode() : 0);
                result = 31 * result + (this.rec709Settings != null ? this.rec709Settings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * Object colorSpacePassthroughSettings;
     * Object rec601Settings;
     * Object rec709Settings;
     * Av1SettingsProperty av1SettingsProperty = Av1SettingsProperty.builder()
     *         .afdSignaling("afdSignaling")
     *         .bitrate(123)
     *         .bufSize(123)
     *         .colorSpaceSettings(Av1ColorSpaceSettingsProperty.builder()
     *                 .colorSpacePassthroughSettings(colorSpacePassthroughSettings)
     *                 .hdr10Settings(Hdr10SettingsProperty.builder()
     *                         .maxCll(123)
     *                         .maxFall(123)
     *                         .build())
     *                 .rec601Settings(rec601Settings)
     *                 .rec709Settings(rec709Settings)
     *                 .build())
     *         .fixedAfd("fixedAfd")
     *         .framerateDenominator(123)
     *         .framerateNumerator(123)
     *         .gopSize(123)
     *         .gopSizeUnits("gopSizeUnits")
     *         .level("level")
     *         .lookAheadRateControl("lookAheadRateControl")
     *         .maxBitrate(123)
     *         .minBitrate(123)
     *         .minIInterval(123)
     *         .parDenominator(123)
     *         .parNumerator(123)
     *         .qvbrQualityLevel(123)
     *         .rateControlMode("rateControlMode")
     *         .sceneChangeDetect("sceneChangeDetect")
     *         .timecodeBurninSettings(TimecodeBurninSettingsProperty.builder()
     *                 .fontSize("fontSize")
     *                 .position("position")
     *                 .prefix("prefix")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.Av1SettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(Av1SettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Av1SettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-afdsignaling">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-afdsignaling</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAfdSignaling() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-bitrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-bitrate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBitrate() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-bufsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-bufsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBufSize() {
            return null;
        }

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.Av1ColorSpaceSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-colorspacesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-colorspacesettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColorSpaceSettings() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-fixedafd">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-fixedafd</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFixedAfd() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-frameratedenominator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-frameratedenominator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFramerateDenominator() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-frameratenumerator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-frameratenumerator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFramerateNumerator() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-gopsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-gopsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getGopSize() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-gopsizeunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-gopsizeunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGopSizeUnits() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-level">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-level</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLevel() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-lookaheadratecontrol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-lookaheadratecontrol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLookAheadRateControl() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-maxbitrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-maxbitrate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxBitrate() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-minbitrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-minbitrate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinBitrate() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-miniinterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-miniinterval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinIInterval() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-pardenominator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-pardenominator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getParDenominator() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-parnumerator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-parnumerator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getParNumerator() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-qvbrqualitylevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-qvbrqualitylevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getQvbrQualityLevel() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-ratecontrolmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-ratecontrolmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRateControlMode() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-scenechangedetect">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-scenechangedetect</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSceneChangeDetect() {
            return null;
        }

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.TimecodeBurninSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-timecodeburninsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-av1settings.html#cfn-medialive-channel-av1settings-timecodeburninsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimecodeBurninSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Av1SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Av1SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Av1SettingsProperty> {
            java.lang.String afdSignaling;
            java.lang.Number bitrate;
            java.lang.Number bufSize;
            java.lang.Object colorSpaceSettings;
            java.lang.String fixedAfd;
            java.lang.Number framerateDenominator;
            java.lang.Number framerateNumerator;
            java.lang.Number gopSize;
            java.lang.String gopSizeUnits;
            java.lang.String level;
            java.lang.String lookAheadRateControl;
            java.lang.Number maxBitrate;
            java.lang.Number minBitrate;
            java.lang.Number minIInterval;
            java.lang.Number parDenominator;
            java.lang.Number parNumerator;
            java.lang.Number qvbrQualityLevel;
            java.lang.String rateControlMode;
            java.lang.String sceneChangeDetect;
            java.lang.Object timecodeBurninSettings;

            /**
             * Sets the value of {@link Av1SettingsProperty#getAfdSignaling}
             * @param afdSignaling the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder afdSignaling(java.lang.String afdSignaling) {
                this.afdSignaling = afdSignaling;
                return this;
            }

            /**
             * Sets the value of {@link Av1SettingsProperty#getBitrate}
             * @param bitrate the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bitrate(java.lang.Number bitrate) {
                this.bitrate = bitrate;
                return this;
            }

            /**
             * Sets the value of {@link Av1SettingsProperty#getBufSize}
             * @param bufSize the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufSize(java.lang.Number bufSize) {
                this.bufSize = bufSize;
                return this;
            }

            /**
             * Sets the value of {@link Av1SettingsProperty#getColorSpaceSettings}
             * @param colorSpaceSettings the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colorSpaceSettings(software.amazon.awscdk.IResolvable colorSpaceSettings) {
                this.colorSpaceSettings = colorSpaceSettings;
                return this;
            }

            /**
             * Sets the value of {@link Av1SettingsProperty#getColorSpaceSettings}
             * @param colorSpaceSettings the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colorSpaceSettings(software.amazon.awscdk.services.medialive.CfnChannel.Av1ColorSpaceSettingsProperty colorSpaceSettings) {
                this.colorSpaceSettings = colorSpaceSettings;
                return this;
            }

            /**
             * Sets the value of {@link Av1SettingsProperty#getFixedAfd}
             * @param fixedAfd the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fixedAfd(java.lang.String fixedAfd) {
                this.fixedAfd = fixedAfd;
                return this;
            }

            /**
             * Sets the value of {@link Av1SettingsProperty#getFramerateDenominator}
             * @param framerateDenominator the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder framerateDenominator(java.lang.Number framerateDenominator) {
                this.framerateDenominator = framerateDenominator;
                return this;
            }

            /**
             * Sets the value of {@link Av1SettingsProperty#getFramerateNumerator}
             * @param framerateNumerator the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder framerateNumerator(java.lang.Number framerateNumerator) {
                this.framerateNumerator = framerateNumerator;
                return this;
            }

            /**
             * Sets the value of {@link Av1SettingsProperty#getGopSize}
             * @param gopSize the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gopSize(java.lang.Number gopSize) {
                this.gopSize = gopSize;
                return this;
            }

            /**
             * Sets the value of {@link Av1SettingsProperty#getGopSizeUnits}
             * @param gopSizeUnits the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gopSizeUnits(java.lang.String gopSizeUnits) {
                this.gopSizeUnits = gopSizeUnits;
                return this;
            }

            /**
             * Sets the value of {@link Av1SettingsProperty#getLevel}
             * @param level the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder level(java.lang.String level) {
                this.level = level;
                return this;
            }

            /**
             * Sets the value of {@link Av1SettingsProperty#getLookAheadRateControl}
             * @param lookAheadRateControl the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lookAheadRateControl(java.lang.String lookAheadRateControl) {
                this.lookAheadRateControl = lookAheadRateControl;
                return this;
            }

            /**
             * Sets the value of {@link Av1SettingsProperty#getMaxBitrate}
             * @param maxBitrate the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxBitrate(java.lang.Number maxBitrate) {
                this.maxBitrate = maxBitrate;
                return this;
            }

            /**
             * Sets the value of {@link Av1SettingsProperty#getMinBitrate}
             * @param minBitrate the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minBitrate(java.lang.Number minBitrate) {
                this.minBitrate = minBitrate;
                return this;
            }

            /**
             * Sets the value of {@link Av1SettingsProperty#getMinIInterval}
             * @param minIInterval the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minIInterval(java.lang.Number minIInterval) {
                this.minIInterval = minIInterval;
                return this;
            }

            /**
             * Sets the value of {@link Av1SettingsProperty#getParDenominator}
             * @param parDenominator the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parDenominator(java.lang.Number parDenominator) {
                this.parDenominator = parDenominator;
                return this;
            }

            /**
             * Sets the value of {@link Av1SettingsProperty#getParNumerator}
             * @param parNumerator the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parNumerator(java.lang.Number parNumerator) {
                this.parNumerator = parNumerator;
                return this;
            }

            /**
             * Sets the value of {@link Av1SettingsProperty#getQvbrQualityLevel}
             * @param qvbrQualityLevel the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder qvbrQualityLevel(java.lang.Number qvbrQualityLevel) {
                this.qvbrQualityLevel = qvbrQualityLevel;
                return this;
            }

            /**
             * Sets the value of {@link Av1SettingsProperty#getRateControlMode}
             * @param rateControlMode the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rateControlMode(java.lang.String rateControlMode) {
                this.rateControlMode = rateControlMode;
                return this;
            }

            /**
             * Sets the value of {@link Av1SettingsProperty#getSceneChangeDetect}
             * @param sceneChangeDetect the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sceneChangeDetect(java.lang.String sceneChangeDetect) {
                this.sceneChangeDetect = sceneChangeDetect;
                return this;
            }

            /**
             * Sets the value of {@link Av1SettingsProperty#getTimecodeBurninSettings}
             * @param timecodeBurninSettings the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timecodeBurninSettings(software.amazon.awscdk.IResolvable timecodeBurninSettings) {
                this.timecodeBurninSettings = timecodeBurninSettings;
                return this;
            }

            /**
             * Sets the value of {@link Av1SettingsProperty#getTimecodeBurninSettings}
             * @param timecodeBurninSettings the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timecodeBurninSettings(software.amazon.awscdk.services.medialive.CfnChannel.TimecodeBurninSettingsProperty timecodeBurninSettings) {
                this.timecodeBurninSettings = timecodeBurninSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Av1SettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Av1SettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Av1SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Av1SettingsProperty {
            private final java.lang.String afdSignaling;
            private final java.lang.Number bitrate;
            private final java.lang.Number bufSize;
            private final java.lang.Object colorSpaceSettings;
            private final java.lang.String fixedAfd;
            private final java.lang.Number framerateDenominator;
            private final java.lang.Number framerateNumerator;
            private final java.lang.Number gopSize;
            private final java.lang.String gopSizeUnits;
            private final java.lang.String level;
            private final java.lang.String lookAheadRateControl;
            private final java.lang.Number maxBitrate;
            private final java.lang.Number minBitrate;
            private final java.lang.Number minIInterval;
            private final java.lang.Number parDenominator;
            private final java.lang.Number parNumerator;
            private final java.lang.Number qvbrQualityLevel;
            private final java.lang.String rateControlMode;
            private final java.lang.String sceneChangeDetect;
            private final java.lang.Object timecodeBurninSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.afdSignaling = software.amazon.jsii.Kernel.get(this, "afdSignaling", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bitrate = software.amazon.jsii.Kernel.get(this, "bitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.bufSize = software.amazon.jsii.Kernel.get(this, "bufSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.colorSpaceSettings = software.amazon.jsii.Kernel.get(this, "colorSpaceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fixedAfd = software.amazon.jsii.Kernel.get(this, "fixedAfd", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.framerateDenominator = software.amazon.jsii.Kernel.get(this, "framerateDenominator", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.framerateNumerator = software.amazon.jsii.Kernel.get(this, "framerateNumerator", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.gopSize = software.amazon.jsii.Kernel.get(this, "gopSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.gopSizeUnits = software.amazon.jsii.Kernel.get(this, "gopSizeUnits", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.level = software.amazon.jsii.Kernel.get(this, "level", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lookAheadRateControl = software.amazon.jsii.Kernel.get(this, "lookAheadRateControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maxBitrate = software.amazon.jsii.Kernel.get(this, "maxBitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minBitrate = software.amazon.jsii.Kernel.get(this, "minBitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minIInterval = software.amazon.jsii.Kernel.get(this, "minIInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.parDenominator = software.amazon.jsii.Kernel.get(this, "parDenominator", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.parNumerator = software.amazon.jsii.Kernel.get(this, "parNumerator", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.qvbrQualityLevel = software.amazon.jsii.Kernel.get(this, "qvbrQualityLevel", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.rateControlMode = software.amazon.jsii.Kernel.get(this, "rateControlMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sceneChangeDetect = software.amazon.jsii.Kernel.get(this, "sceneChangeDetect", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timecodeBurninSettings = software.amazon.jsii.Kernel.get(this, "timecodeBurninSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.afdSignaling = builder.afdSignaling;
                this.bitrate = builder.bitrate;
                this.bufSize = builder.bufSize;
                this.colorSpaceSettings = builder.colorSpaceSettings;
                this.fixedAfd = builder.fixedAfd;
                this.framerateDenominator = builder.framerateDenominator;
                this.framerateNumerator = builder.framerateNumerator;
                this.gopSize = builder.gopSize;
                this.gopSizeUnits = builder.gopSizeUnits;
                this.level = builder.level;
                this.lookAheadRateControl = builder.lookAheadRateControl;
                this.maxBitrate = builder.maxBitrate;
                this.minBitrate = builder.minBitrate;
                this.minIInterval = builder.minIInterval;
                this.parDenominator = builder.parDenominator;
                this.parNumerator = builder.parNumerator;
                this.qvbrQualityLevel = builder.qvbrQualityLevel;
                this.rateControlMode = builder.rateControlMode;
                this.sceneChangeDetect = builder.sceneChangeDetect;
                this.timecodeBurninSettings = builder.timecodeBurninSettings;
            }

            @Override
            public final java.lang.String getAfdSignaling() {
                return this.afdSignaling;
            }

            @Override
            public final java.lang.Number getBitrate() {
                return this.bitrate;
            }

            @Override
            public final java.lang.Number getBufSize() {
                return this.bufSize;
            }

            @Override
            public final java.lang.Object getColorSpaceSettings() {
                return this.colorSpaceSettings;
            }

            @Override
            public final java.lang.String getFixedAfd() {
                return this.fixedAfd;
            }

            @Override
            public final java.lang.Number getFramerateDenominator() {
                return this.framerateDenominator;
            }

            @Override
            public final java.lang.Number getFramerateNumerator() {
                return this.framerateNumerator;
            }

            @Override
            public final java.lang.Number getGopSize() {
                return this.gopSize;
            }

            @Override
            public final java.lang.String getGopSizeUnits() {
                return this.gopSizeUnits;
            }

            @Override
            public final java.lang.String getLevel() {
                return this.level;
            }

            @Override
            public final java.lang.String getLookAheadRateControl() {
                return this.lookAheadRateControl;
            }

            @Override
            public final java.lang.Number getMaxBitrate() {
                return this.maxBitrate;
            }

            @Override
            public final java.lang.Number getMinBitrate() {
                return this.minBitrate;
            }

            @Override
            public final java.lang.Number getMinIInterval() {
                return this.minIInterval;
            }

            @Override
            public final java.lang.Number getParDenominator() {
                return this.parDenominator;
            }

            @Override
            public final java.lang.Number getParNumerator() {
                return this.parNumerator;
            }

            @Override
            public final java.lang.Number getQvbrQualityLevel() {
                return this.qvbrQualityLevel;
            }

            @Override
            public final java.lang.String getRateControlMode() {
                return this.rateControlMode;
            }

            @Override
            public final java.lang.String getSceneChangeDetect() {
                return this.sceneChangeDetect;
            }

            @Override
            public final java.lang.Object getTimecodeBurninSettings() {
                return this.timecodeBurninSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAfdSignaling() != null) {
                    data.set("afdSignaling", om.valueToTree(this.getAfdSignaling()));
                }
                if (this.getBitrate() != null) {
                    data.set("bitrate", om.valueToTree(this.getBitrate()));
                }
                if (this.getBufSize() != null) {
                    data.set("bufSize", om.valueToTree(this.getBufSize()));
                }
                if (this.getColorSpaceSettings() != null) {
                    data.set("colorSpaceSettings", om.valueToTree(this.getColorSpaceSettings()));
                }
                if (this.getFixedAfd() != null) {
                    data.set("fixedAfd", om.valueToTree(this.getFixedAfd()));
                }
                if (this.getFramerateDenominator() != null) {
                    data.set("framerateDenominator", om.valueToTree(this.getFramerateDenominator()));
                }
                if (this.getFramerateNumerator() != null) {
                    data.set("framerateNumerator", om.valueToTree(this.getFramerateNumerator()));
                }
                if (this.getGopSize() != null) {
                    data.set("gopSize", om.valueToTree(this.getGopSize()));
                }
                if (this.getGopSizeUnits() != null) {
                    data.set("gopSizeUnits", om.valueToTree(this.getGopSizeUnits()));
                }
                if (this.getLevel() != null) {
                    data.set("level", om.valueToTree(this.getLevel()));
                }
                if (this.getLookAheadRateControl() != null) {
                    data.set("lookAheadRateControl", om.valueToTree(this.getLookAheadRateControl()));
                }
                if (this.getMaxBitrate() != null) {
                    data.set("maxBitrate", om.valueToTree(this.getMaxBitrate()));
                }
                if (this.getMinBitrate() != null) {
                    data.set("minBitrate", om.valueToTree(this.getMinBitrate()));
                }
                if (this.getMinIInterval() != null) {
                    data.set("minIInterval", om.valueToTree(this.getMinIInterval()));
                }
                if (this.getParDenominator() != null) {
                    data.set("parDenominator", om.valueToTree(this.getParDenominator()));
                }
                if (this.getParNumerator() != null) {
                    data.set("parNumerator", om.valueToTree(this.getParNumerator()));
                }
                if (this.getQvbrQualityLevel() != null) {
                    data.set("qvbrQualityLevel", om.valueToTree(this.getQvbrQualityLevel()));
                }
                if (this.getRateControlMode() != null) {
                    data.set("rateControlMode", om.valueToTree(this.getRateControlMode()));
                }
                if (this.getSceneChangeDetect() != null) {
                    data.set("sceneChangeDetect", om.valueToTree(this.getSceneChangeDetect()));
                }
                if (this.getTimecodeBurninSettings() != null) {
                    data.set("timecodeBurninSettings", om.valueToTree(this.getTimecodeBurninSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.Av1SettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Av1SettingsProperty.Jsii$Proxy that = (Av1SettingsProperty.Jsii$Proxy) o;

                if (this.afdSignaling != null ? !this.afdSignaling.equals(that.afdSignaling) : that.afdSignaling != null) return false;
                if (this.bitrate != null ? !this.bitrate.equals(that.bitrate) : that.bitrate != null) return false;
                if (this.bufSize != null ? !this.bufSize.equals(that.bufSize) : that.bufSize != null) return false;
                if (this.colorSpaceSettings != null ? !this.colorSpaceSettings.equals(that.colorSpaceSettings) : that.colorSpaceSettings != null) return false;
                if (this.fixedAfd != null ? !this.fixedAfd.equals(that.fixedAfd) : that.fixedAfd != null) return false;
                if (this.framerateDenominator != null ? !this.framerateDenominator.equals(that.framerateDenominator) : that.framerateDenominator != null) return false;
                if (this.framerateNumerator != null ? !this.framerateNumerator.equals(that.framerateNumerator) : that.framerateNumerator != null) return false;
                if (this.gopSize != null ? !this.gopSize.equals(that.gopSize) : that.gopSize != null) return false;
                if (this.gopSizeUnits != null ? !this.gopSizeUnits.equals(that.gopSizeUnits) : that.gopSizeUnits != null) return false;
                if (this.level != null ? !this.level.equals(that.level) : that.level != null) return false;
                if (this.lookAheadRateControl != null ? !this.lookAheadRateControl.equals(that.lookAheadRateControl) : that.lookAheadRateControl != null) return false;
                if (this.maxBitrate != null ? !this.maxBitrate.equals(that.maxBitrate) : that.maxBitrate != null) return false;
                if (this.minBitrate != null ? !this.minBitrate.equals(that.minBitrate) : that.minBitrate != null) return false;
                if (this.minIInterval != null ? !this.minIInterval.equals(that.minIInterval) : that.minIInterval != null) return false;
                if (this.parDenominator != null ? !this.parDenominator.equals(that.parDenominator) : that.parDenominator != null) return false;
                if (this.parNumerator != null ? !this.parNumerator.equals(that.parNumerator) : that.parNumerator != null) return false;
                if (this.qvbrQualityLevel != null ? !this.qvbrQualityLevel.equals(that.qvbrQualityLevel) : that.qvbrQualityLevel != null) return false;
                if (this.rateControlMode != null ? !this.rateControlMode.equals(that.rateControlMode) : that.rateControlMode != null) return false;
                if (this.sceneChangeDetect != null ? !this.sceneChangeDetect.equals(that.sceneChangeDetect) : that.sceneChangeDetect != null) return false;
                return this.timecodeBurninSettings != null ? this.timecodeBurninSettings.equals(that.timecodeBurninSettings) : that.timecodeBurninSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.afdSignaling != null ? this.afdSignaling.hashCode() : 0;
                result = 31 * result + (this.bitrate != null ? this.bitrate.hashCode() : 0);
                result = 31 * result + (this.bufSize != null ? this.bufSize.hashCode() : 0);
                result = 31 * result + (this.colorSpaceSettings != null ? this.colorSpaceSettings.hashCode() : 0);
                result = 31 * result + (this.fixedAfd != null ? this.fixedAfd.hashCode() : 0);
                result = 31 * result + (this.framerateDenominator != null ? this.framerateDenominator.hashCode() : 0);
                result = 31 * result + (this.framerateNumerator != null ? this.framerateNumerator.hashCode() : 0);
                result = 31 * result + (this.gopSize != null ? this.gopSize.hashCode() : 0);
                result = 31 * result + (this.gopSizeUnits != null ? this.gopSizeUnits.hashCode() : 0);
                result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
                result = 31 * result + (this.lookAheadRateControl != null ? this.lookAheadRateControl.hashCode() : 0);
                result = 31 * result + (this.maxBitrate != null ? this.maxBitrate.hashCode() : 0);
                result = 31 * result + (this.minBitrate != null ? this.minBitrate.hashCode() : 0);
                result = 31 * result + (this.minIInterval != null ? this.minIInterval.hashCode() : 0);
                result = 31 * result + (this.parDenominator != null ? this.parDenominator.hashCode() : 0);
                result = 31 * result + (this.parNumerator != null ? this.parNumerator.hashCode() : 0);
                result = 31 * result + (this.qvbrQualityLevel != null ? this.qvbrQualityLevel.hashCode() : 0);
                result = 31 * result + (this.rateControlMode != null ? this.rateControlMode.hashCode() : 0);
                result = 31 * result + (this.sceneChangeDetect != null ? this.sceneChangeDetect.hashCode() : 0);
                result = 31 * result + (this.timecodeBurninSettings != null ? this.timecodeBurninSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of ad avail blanking in the output.
     * <p>
     * The parent of this entity is EncoderSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AvailBlankingProperty availBlankingProperty = AvailBlankingProperty.builder()
     *         .availBlankingImage(InputLocationProperty.builder()
     *                 .passwordParam("passwordParam")
     *                 .uri("uri")
     *                 .username("username")
     *                 .build())
     *         .state("state")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availblanking.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availblanking.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AvailBlankingProperty")
    @software.amazon.jsii.Jsii.Proxy(AvailBlankingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AvailBlankingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The blanking image to be used.
         * <p>
         * Keep empty for solid black. Only .bmp and .png images are supported.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.InputLocationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availblanking.html#cfn-medialive-channel-availblanking-availblankingimage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availblanking.html#cfn-medialive-channel-availblanking-availblankingimage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAvailBlankingImage() {
            return null;
        }

        /**
         * When set to enabled, the video, audio, and captions are blanked when insertion metadata is added.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availblanking.html#cfn-medialive-channel-availblanking-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availblanking.html#cfn-medialive-channel-availblanking-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getState() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AvailBlankingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AvailBlankingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AvailBlankingProperty> {
            java.lang.Object availBlankingImage;
            java.lang.String state;

            /**
             * Sets the value of {@link AvailBlankingProperty#getAvailBlankingImage}
             * @param availBlankingImage The blanking image to be used.
             *                           Keep empty for solid black. Only .bmp and .png images are supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availBlankingImage(software.amazon.awscdk.IResolvable availBlankingImage) {
                this.availBlankingImage = availBlankingImage;
                return this;
            }

            /**
             * Sets the value of {@link AvailBlankingProperty#getAvailBlankingImage}
             * @param availBlankingImage The blanking image to be used.
             *                           Keep empty for solid black. Only .bmp and .png images are supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availBlankingImage(software.amazon.awscdk.services.medialive.CfnChannel.InputLocationProperty availBlankingImage) {
                this.availBlankingImage = availBlankingImage;
                return this;
            }

            /**
             * Sets the value of {@link AvailBlankingProperty#getState}
             * @param state When set to enabled, the video, audio, and captions are blanked when insertion metadata is added.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AvailBlankingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AvailBlankingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AvailBlankingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AvailBlankingProperty {
            private final java.lang.Object availBlankingImage;
            private final java.lang.String state;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availBlankingImage = software.amazon.jsii.Kernel.get(this, "availBlankingImage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availBlankingImage = builder.availBlankingImage;
                this.state = builder.state;
            }

            @Override
            public final java.lang.Object getAvailBlankingImage() {
                return this.availBlankingImage;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailBlankingImage() != null) {
                    data.set("availBlankingImage", om.valueToTree(this.getAvailBlankingImage()));
                }
                if (this.getState() != null) {
                    data.set("state", om.valueToTree(this.getState()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AvailBlankingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AvailBlankingProperty.Jsii$Proxy that = (AvailBlankingProperty.Jsii$Proxy) o;

                if (this.availBlankingImage != null ? !this.availBlankingImage.equals(that.availBlankingImage) : that.availBlankingImage != null) return false;
                return this.state != null ? this.state.equals(that.state) : that.state == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availBlankingImage != null ? this.availBlankingImage.hashCode() : 0;
                result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The setup of ad avail handling in the output.
     * <p>
     * The parent of this entity is EncoderSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AvailConfigurationProperty availConfigurationProperty = AvailConfigurationProperty.builder()
     *         .availSettings(AvailSettingsProperty.builder()
     *                 .esam(EsamProperty.builder()
     *                         .acquisitionPointId("acquisitionPointId")
     *                         .adAvailOffset(123)
     *                         .passwordParam("passwordParam")
     *                         .poisEndpoint("poisEndpoint")
     *                         .username("username")
     *                         .zoneIdentity("zoneIdentity")
     *                         .build())
     *                 .scte35SpliceInsert(Scte35SpliceInsertProperty.builder()
     *                         .adAvailOffset(123)
     *                         .noRegionalBlackoutFlag("noRegionalBlackoutFlag")
     *                         .webDeliveryAllowedFlag("webDeliveryAllowedFlag")
     *                         .build())
     *                 .scte35TimeSignalApos(Scte35TimeSignalAposProperty.builder()
     *                         .adAvailOffset(123)
     *                         .noRegionalBlackoutFlag("noRegionalBlackoutFlag")
     *                         .webDeliveryAllowedFlag("webDeliveryAllowedFlag")
     *                         .build())
     *                 .build())
     *         .scte35SegmentationScope("scte35SegmentationScope")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AvailConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AvailConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AvailConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The setup of ad avail handling in the output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.AvailSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availconfiguration.html#cfn-medialive-channel-availconfiguration-availsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availconfiguration.html#cfn-medialive-channel-availconfiguration-availsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAvailSettings() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availconfiguration.html#cfn-medialive-channel-availconfiguration-scte35segmentationscope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availconfiguration.html#cfn-medialive-channel-availconfiguration-scte35segmentationscope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScte35SegmentationScope() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AvailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AvailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AvailConfigurationProperty> {
            java.lang.Object availSettings;
            java.lang.String scte35SegmentationScope;

            /**
             * Sets the value of {@link AvailConfigurationProperty#getAvailSettings}
             * @param availSettings The setup of ad avail handling in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availSettings(software.amazon.awscdk.IResolvable availSettings) {
                this.availSettings = availSettings;
                return this;
            }

            /**
             * Sets the value of {@link AvailConfigurationProperty#getAvailSettings}
             * @param availSettings The setup of ad avail handling in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availSettings(software.amazon.awscdk.services.medialive.CfnChannel.AvailSettingsProperty availSettings) {
                this.availSettings = availSettings;
                return this;
            }

            /**
             * Sets the value of {@link AvailConfigurationProperty#getScte35SegmentationScope}
             * @param scte35SegmentationScope the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte35SegmentationScope(java.lang.String scte35SegmentationScope) {
                this.scte35SegmentationScope = scte35SegmentationScope;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AvailConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AvailConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AvailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AvailConfigurationProperty {
            private final java.lang.Object availSettings;
            private final java.lang.String scte35SegmentationScope;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availSettings = software.amazon.jsii.Kernel.get(this, "availSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scte35SegmentationScope = software.amazon.jsii.Kernel.get(this, "scte35SegmentationScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availSettings = builder.availSettings;
                this.scte35SegmentationScope = builder.scte35SegmentationScope;
            }

            @Override
            public final java.lang.Object getAvailSettings() {
                return this.availSettings;
            }

            @Override
            public final java.lang.String getScte35SegmentationScope() {
                return this.scte35SegmentationScope;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailSettings() != null) {
                    data.set("availSettings", om.valueToTree(this.getAvailSettings()));
                }
                if (this.getScte35SegmentationScope() != null) {
                    data.set("scte35SegmentationScope", om.valueToTree(this.getScte35SegmentationScope()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AvailConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AvailConfigurationProperty.Jsii$Proxy that = (AvailConfigurationProperty.Jsii$Proxy) o;

                if (this.availSettings != null ? !this.availSettings.equals(that.availSettings) : that.availSettings != null) return false;
                return this.scte35SegmentationScope != null ? this.scte35SegmentationScope.equals(that.scte35SegmentationScope) : that.scte35SegmentationScope == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availSettings != null ? this.availSettings.hashCode() : 0;
                result = 31 * result + (this.scte35SegmentationScope != null ? this.scte35SegmentationScope.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for the ad avail setup in the output.
     * <p>
     * The parent of this entity is AvailConfiguration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AvailSettingsProperty availSettingsProperty = AvailSettingsProperty.builder()
     *         .esam(EsamProperty.builder()
     *                 .acquisitionPointId("acquisitionPointId")
     *                 .adAvailOffset(123)
     *                 .passwordParam("passwordParam")
     *                 .poisEndpoint("poisEndpoint")
     *                 .username("username")
     *                 .zoneIdentity("zoneIdentity")
     *                 .build())
     *         .scte35SpliceInsert(Scte35SpliceInsertProperty.builder()
     *                 .adAvailOffset(123)
     *                 .noRegionalBlackoutFlag("noRegionalBlackoutFlag")
     *                 .webDeliveryAllowedFlag("webDeliveryAllowedFlag")
     *                 .build())
     *         .scte35TimeSignalApos(Scte35TimeSignalAposProperty.builder()
     *                 .adAvailOffset(123)
     *                 .noRegionalBlackoutFlag("noRegionalBlackoutFlag")
     *                 .webDeliveryAllowedFlag("webDeliveryAllowedFlag")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AvailSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AvailSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AvailSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.EsamProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availsettings.html#cfn-medialive-channel-availsettings-esam">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availsettings.html#cfn-medialive-channel-availsettings-esam</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEsam() {
            return null;
        }

        /**
         * The setup for SCTE-35 splice insert handling.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.Scte35SpliceInsertProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availsettings.html#cfn-medialive-channel-availsettings-scte35spliceinsert">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availsettings.html#cfn-medialive-channel-availsettings-scte35spliceinsert</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScte35SpliceInsert() {
            return null;
        }

        /**
         * The setup for SCTE-35 time signal APOS handling.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.Scte35TimeSignalAposProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availsettings.html#cfn-medialive-channel-availsettings-scte35timesignalapos">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availsettings.html#cfn-medialive-channel-availsettings-scte35timesignalapos</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScte35TimeSignalApos() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AvailSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AvailSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AvailSettingsProperty> {
            java.lang.Object esam;
            java.lang.Object scte35SpliceInsert;
            java.lang.Object scte35TimeSignalApos;

            /**
             * Sets the value of {@link AvailSettingsProperty#getEsam}
             * @param esam the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder esam(software.amazon.awscdk.IResolvable esam) {
                this.esam = esam;
                return this;
            }

            /**
             * Sets the value of {@link AvailSettingsProperty#getEsam}
             * @param esam the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder esam(software.amazon.awscdk.services.medialive.CfnChannel.EsamProperty esam) {
                this.esam = esam;
                return this;
            }

            /**
             * Sets the value of {@link AvailSettingsProperty#getScte35SpliceInsert}
             * @param scte35SpliceInsert The setup for SCTE-35 splice insert handling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte35SpliceInsert(software.amazon.awscdk.IResolvable scte35SpliceInsert) {
                this.scte35SpliceInsert = scte35SpliceInsert;
                return this;
            }

            /**
             * Sets the value of {@link AvailSettingsProperty#getScte35SpliceInsert}
             * @param scte35SpliceInsert The setup for SCTE-35 splice insert handling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte35SpliceInsert(software.amazon.awscdk.services.medialive.CfnChannel.Scte35SpliceInsertProperty scte35SpliceInsert) {
                this.scte35SpliceInsert = scte35SpliceInsert;
                return this;
            }

            /**
             * Sets the value of {@link AvailSettingsProperty#getScte35TimeSignalApos}
             * @param scte35TimeSignalApos The setup for SCTE-35 time signal APOS handling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte35TimeSignalApos(software.amazon.awscdk.IResolvable scte35TimeSignalApos) {
                this.scte35TimeSignalApos = scte35TimeSignalApos;
                return this;
            }

            /**
             * Sets the value of {@link AvailSettingsProperty#getScte35TimeSignalApos}
             * @param scte35TimeSignalApos The setup for SCTE-35 time signal APOS handling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte35TimeSignalApos(software.amazon.awscdk.services.medialive.CfnChannel.Scte35TimeSignalAposProperty scte35TimeSignalApos) {
                this.scte35TimeSignalApos = scte35TimeSignalApos;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AvailSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AvailSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AvailSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AvailSettingsProperty {
            private final java.lang.Object esam;
            private final java.lang.Object scte35SpliceInsert;
            private final java.lang.Object scte35TimeSignalApos;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.esam = software.amazon.jsii.Kernel.get(this, "esam", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scte35SpliceInsert = software.amazon.jsii.Kernel.get(this, "scte35SpliceInsert", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scte35TimeSignalApos = software.amazon.jsii.Kernel.get(this, "scte35TimeSignalApos", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.esam = builder.esam;
                this.scte35SpliceInsert = builder.scte35SpliceInsert;
                this.scte35TimeSignalApos = builder.scte35TimeSignalApos;
            }

            @Override
            public final java.lang.Object getEsam() {
                return this.esam;
            }

            @Override
            public final java.lang.Object getScte35SpliceInsert() {
                return this.scte35SpliceInsert;
            }

            @Override
            public final java.lang.Object getScte35TimeSignalApos() {
                return this.scte35TimeSignalApos;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEsam() != null) {
                    data.set("esam", om.valueToTree(this.getEsam()));
                }
                if (this.getScte35SpliceInsert() != null) {
                    data.set("scte35SpliceInsert", om.valueToTree(this.getScte35SpliceInsert()));
                }
                if (this.getScte35TimeSignalApos() != null) {
                    data.set("scte35TimeSignalApos", om.valueToTree(this.getScte35TimeSignalApos()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AvailSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AvailSettingsProperty.Jsii$Proxy that = (AvailSettingsProperty.Jsii$Proxy) o;

                if (this.esam != null ? !this.esam.equals(that.esam) : that.esam != null) return false;
                if (this.scte35SpliceInsert != null ? !this.scte35SpliceInsert.equals(that.scte35SpliceInsert) : that.scte35SpliceInsert != null) return false;
                return this.scte35TimeSignalApos != null ? this.scte35TimeSignalApos.equals(that.scte35TimeSignalApos) : that.scte35TimeSignalApos == null;
            }

            @Override
            public final int hashCode() {
                int result = this.esam != null ? this.esam.hashCode() : 0;
                result = 31 * result + (this.scte35SpliceInsert != null ? this.scte35SpliceInsert.hashCode() : 0);
                result = 31 * result + (this.scte35TimeSignalApos != null ? this.scte35TimeSignalApos.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * BandwidthReductionFilterSettingsProperty bandwidthReductionFilterSettingsProperty = BandwidthReductionFilterSettingsProperty.builder()
     *         .postFilterSharpening("postFilterSharpening")
     *         .strength("strength")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-bandwidthreductionfiltersettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-bandwidthreductionfiltersettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.BandwidthReductionFilterSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(BandwidthReductionFilterSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BandwidthReductionFilterSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-bandwidthreductionfiltersettings.html#cfn-medialive-channel-bandwidthreductionfiltersettings-postfiltersharpening">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-bandwidthreductionfiltersettings.html#cfn-medialive-channel-bandwidthreductionfiltersettings-postfiltersharpening</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPostFilterSharpening() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-bandwidthreductionfiltersettings.html#cfn-medialive-channel-bandwidthreductionfiltersettings-strength">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-bandwidthreductionfiltersettings.html#cfn-medialive-channel-bandwidthreductionfiltersettings-strength</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStrength() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BandwidthReductionFilterSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BandwidthReductionFilterSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BandwidthReductionFilterSettingsProperty> {
            java.lang.String postFilterSharpening;
            java.lang.String strength;

            /**
             * Sets the value of {@link BandwidthReductionFilterSettingsProperty#getPostFilterSharpening}
             * @param postFilterSharpening the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postFilterSharpening(java.lang.String postFilterSharpening) {
                this.postFilterSharpening = postFilterSharpening;
                return this;
            }

            /**
             * Sets the value of {@link BandwidthReductionFilterSettingsProperty#getStrength}
             * @param strength the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder strength(java.lang.String strength) {
                this.strength = strength;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BandwidthReductionFilterSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BandwidthReductionFilterSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BandwidthReductionFilterSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BandwidthReductionFilterSettingsProperty {
            private final java.lang.String postFilterSharpening;
            private final java.lang.String strength;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.postFilterSharpening = software.amazon.jsii.Kernel.get(this, "postFilterSharpening", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.strength = software.amazon.jsii.Kernel.get(this, "strength", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.postFilterSharpening = builder.postFilterSharpening;
                this.strength = builder.strength;
            }

            @Override
            public final java.lang.String getPostFilterSharpening() {
                return this.postFilterSharpening;
            }

            @Override
            public final java.lang.String getStrength() {
                return this.strength;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPostFilterSharpening() != null) {
                    data.set("postFilterSharpening", om.valueToTree(this.getPostFilterSharpening()));
                }
                if (this.getStrength() != null) {
                    data.set("strength", om.valueToTree(this.getStrength()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.BandwidthReductionFilterSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BandwidthReductionFilterSettingsProperty.Jsii$Proxy that = (BandwidthReductionFilterSettingsProperty.Jsii$Proxy) o;

                if (this.postFilterSharpening != null ? !this.postFilterSharpening.equals(that.postFilterSharpening) : that.postFilterSharpening != null) return false;
                return this.strength != null ? this.strength.equals(that.strength) : that.strength == null;
            }

            @Override
            public final int hashCode() {
                int result = this.postFilterSharpening != null ? this.postFilterSharpening.hashCode() : 0;
                result = 31 * result + (this.strength != null ? this.strength.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for a blackout slate.
     * <p>
     * The parent of this entity is EncoderSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * BlackoutSlateProperty blackoutSlateProperty = BlackoutSlateProperty.builder()
     *         .blackoutSlateImage(InputLocationProperty.builder()
     *                 .passwordParam("passwordParam")
     *                 .uri("uri")
     *                 .username("username")
     *                 .build())
     *         .networkEndBlackout("networkEndBlackout")
     *         .networkEndBlackoutImage(InputLocationProperty.builder()
     *                 .passwordParam("passwordParam")
     *                 .uri("uri")
     *                 .username("username")
     *                 .build())
     *         .networkId("networkId")
     *         .state("state")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.BlackoutSlateProperty")
    @software.amazon.jsii.Jsii.Proxy(BlackoutSlateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BlackoutSlateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The blackout slate image to be used.
         * <p>
         * Keep empty for solid black. Only .bmp and .png images are supported.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.InputLocationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-blackoutslateimage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-blackoutslateimage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlackoutSlateImage() {
            return null;
        }

        /**
         * Setting to enabled causes MediaLive to blackout the video, audio, and captions, and raise the "Network Blackout Image" slate when an SCTE104/35 Network End Segmentation Descriptor is encountered.
         * <p>
         * The blackout is lifted when the Network Start Segmentation Descriptor is encountered. The Network End and Network Start descriptors must contain a network ID that matches the value entered in Network ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-networkendblackout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-networkendblackout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNetworkEndBlackout() {
            return null;
        }

        /**
         * The path to the local file to use as the Network End Blackout image.
         * <p>
         * The image is scaled to fill the entire output raster.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.InputLocationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-networkendblackoutimage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-networkendblackoutimage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkEndBlackoutImage() {
            return null;
        }

        /**
         * Provides a Network ID that matches EIDR ID format (for example, "10.XXXX/XXXX-XXXX-XXXX-XXXX-XXXX-C").
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-networkid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-networkid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNetworkId() {
            return null;
        }

        /**
         * When set to enabled, this causes video, audio, and captions to be blanked when indicated by program metadata.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getState() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BlackoutSlateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BlackoutSlateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BlackoutSlateProperty> {
            java.lang.Object blackoutSlateImage;
            java.lang.String networkEndBlackout;
            java.lang.Object networkEndBlackoutImage;
            java.lang.String networkId;
            java.lang.String state;

            /**
             * Sets the value of {@link BlackoutSlateProperty#getBlackoutSlateImage}
             * @param blackoutSlateImage The blackout slate image to be used.
             *                           Keep empty for solid black. Only .bmp and .png images are supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blackoutSlateImage(software.amazon.awscdk.IResolvable blackoutSlateImage) {
                this.blackoutSlateImage = blackoutSlateImage;
                return this;
            }

            /**
             * Sets the value of {@link BlackoutSlateProperty#getBlackoutSlateImage}
             * @param blackoutSlateImage The blackout slate image to be used.
             *                           Keep empty for solid black. Only .bmp and .png images are supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blackoutSlateImage(software.amazon.awscdk.services.medialive.CfnChannel.InputLocationProperty blackoutSlateImage) {
                this.blackoutSlateImage = blackoutSlateImage;
                return this;
            }

            /**
             * Sets the value of {@link BlackoutSlateProperty#getNetworkEndBlackout}
             * @param networkEndBlackout Setting to enabled causes MediaLive to blackout the video, audio, and captions, and raise the "Network Blackout Image" slate when an SCTE104/35 Network End Segmentation Descriptor is encountered.
             *                           The blackout is lifted when the Network Start Segmentation Descriptor is encountered. The Network End and Network Start descriptors must contain a network ID that matches the value entered in Network ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkEndBlackout(java.lang.String networkEndBlackout) {
                this.networkEndBlackout = networkEndBlackout;
                return this;
            }

            /**
             * Sets the value of {@link BlackoutSlateProperty#getNetworkEndBlackoutImage}
             * @param networkEndBlackoutImage The path to the local file to use as the Network End Blackout image.
             *                                The image is scaled to fill the entire output raster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkEndBlackoutImage(software.amazon.awscdk.IResolvable networkEndBlackoutImage) {
                this.networkEndBlackoutImage = networkEndBlackoutImage;
                return this;
            }

            /**
             * Sets the value of {@link BlackoutSlateProperty#getNetworkEndBlackoutImage}
             * @param networkEndBlackoutImage The path to the local file to use as the Network End Blackout image.
             *                                The image is scaled to fill the entire output raster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkEndBlackoutImage(software.amazon.awscdk.services.medialive.CfnChannel.InputLocationProperty networkEndBlackoutImage) {
                this.networkEndBlackoutImage = networkEndBlackoutImage;
                return this;
            }

            /**
             * Sets the value of {@link BlackoutSlateProperty#getNetworkId}
             * @param networkId Provides a Network ID that matches EIDR ID format (for example, "10.XXXX/XXXX-XXXX-XXXX-XXXX-XXXX-C").
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkId(java.lang.String networkId) {
                this.networkId = networkId;
                return this;
            }

            /**
             * Sets the value of {@link BlackoutSlateProperty#getState}
             * @param state When set to enabled, this causes video, audio, and captions to be blanked when indicated by program metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlackoutSlateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BlackoutSlateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BlackoutSlateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BlackoutSlateProperty {
            private final java.lang.Object blackoutSlateImage;
            private final java.lang.String networkEndBlackout;
            private final java.lang.Object networkEndBlackoutImage;
            private final java.lang.String networkId;
            private final java.lang.String state;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.blackoutSlateImage = software.amazon.jsii.Kernel.get(this, "blackoutSlateImage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkEndBlackout = software.amazon.jsii.Kernel.get(this, "networkEndBlackout", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.networkEndBlackoutImage = software.amazon.jsii.Kernel.get(this, "networkEndBlackoutImage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkId = software.amazon.jsii.Kernel.get(this, "networkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blackoutSlateImage = builder.blackoutSlateImage;
                this.networkEndBlackout = builder.networkEndBlackout;
                this.networkEndBlackoutImage = builder.networkEndBlackoutImage;
                this.networkId = builder.networkId;
                this.state = builder.state;
            }

            @Override
            public final java.lang.Object getBlackoutSlateImage() {
                return this.blackoutSlateImage;
            }

            @Override
            public final java.lang.String getNetworkEndBlackout() {
                return this.networkEndBlackout;
            }

            @Override
            public final java.lang.Object getNetworkEndBlackoutImage() {
                return this.networkEndBlackoutImage;
            }

            @Override
            public final java.lang.String getNetworkId() {
                return this.networkId;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBlackoutSlateImage() != null) {
                    data.set("blackoutSlateImage", om.valueToTree(this.getBlackoutSlateImage()));
                }
                if (this.getNetworkEndBlackout() != null) {
                    data.set("networkEndBlackout", om.valueToTree(this.getNetworkEndBlackout()));
                }
                if (this.getNetworkEndBlackoutImage() != null) {
                    data.set("networkEndBlackoutImage", om.valueToTree(this.getNetworkEndBlackoutImage()));
                }
                if (this.getNetworkId() != null) {
                    data.set("networkId", om.valueToTree(this.getNetworkId()));
                }
                if (this.getState() != null) {
                    data.set("state", om.valueToTree(this.getState()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.BlackoutSlateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BlackoutSlateProperty.Jsii$Proxy that = (BlackoutSlateProperty.Jsii$Proxy) o;

                if (this.blackoutSlateImage != null ? !this.blackoutSlateImage.equals(that.blackoutSlateImage) : that.blackoutSlateImage != null) return false;
                if (this.networkEndBlackout != null ? !this.networkEndBlackout.equals(that.networkEndBlackout) : that.networkEndBlackout != null) return false;
                if (this.networkEndBlackoutImage != null ? !this.networkEndBlackoutImage.equals(that.networkEndBlackoutImage) : that.networkEndBlackoutImage != null) return false;
                if (this.networkId != null ? !this.networkId.equals(that.networkId) : that.networkId != null) return false;
                return this.state != null ? this.state.equals(that.state) : that.state == null;
            }

            @Override
            public final int hashCode() {
                int result = this.blackoutSlateImage != null ? this.blackoutSlateImage.hashCode() : 0;
                result = 31 * result + (this.networkEndBlackout != null ? this.networkEndBlackout.hashCode() : 0);
                result = 31 * result + (this.networkEndBlackoutImage != null ? this.networkEndBlackoutImage.hashCode() : 0);
                result = 31 * result + (this.networkId != null ? this.networkId.hashCode() : 0);
                result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for burn-in captions in the output.
     * <p>
     * The parent of this entity is CaptionDestinationSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * BurnInDestinationSettingsProperty burnInDestinationSettingsProperty = BurnInDestinationSettingsProperty.builder()
     *         .alignment("alignment")
     *         .backgroundColor("backgroundColor")
     *         .backgroundOpacity(123)
     *         .font(InputLocationProperty.builder()
     *                 .passwordParam("passwordParam")
     *                 .uri("uri")
     *                 .username("username")
     *                 .build())
     *         .fontColor("fontColor")
     *         .fontOpacity(123)
     *         .fontResolution(123)
     *         .fontSize("fontSize")
     *         .outlineColor("outlineColor")
     *         .outlineSize(123)
     *         .shadowColor("shadowColor")
     *         .shadowOpacity(123)
     *         .shadowXOffset(123)
     *         .shadowYOffset(123)
     *         .subtitleRows("subtitleRows")
     *         .teletextGridControl("teletextGridControl")
     *         .xPosition(123)
     *         .yPosition(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.BurnInDestinationSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(BurnInDestinationSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BurnInDestinationSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If no explicit xPosition or yPosition is provided, setting alignment to centered places the captions at the bottom center of the output.
         * <p>
         * Similarly, setting a left alignment aligns captions to the bottom left of the output. If x and y positions are specified in conjunction with the alignment parameter, the font is justified (either left or centered) relative to those coordinates. Selecting "smart" justification left-justifies live subtitles and center-justifies pre-recorded subtitles. All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-alignment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-alignment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlignment() {
            return null;
        }

        /**
         * Specifies the color of the rectangle behind the captions.
         * <p>
         * All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-backgroundcolor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-backgroundcolor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBackgroundColor() {
            return null;
        }

        /**
         * Specifies the opacity of the background rectangle.
         * <p>
         * 255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-backgroundopacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-backgroundopacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBackgroundOpacity() {
            return null;
        }

        /**
         * The external font file that is used for captions burn-in.
         * <p>
         * The file extension must be .ttf or .tte. Although you can select output fonts for many different types of input captions, embedded, STL, and Teletext sources use a strict grid system. Using external fonts with these captions sources could cause an unexpected display of proportional fonts. All burn-in and DVB-Sub font settings must match.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.InputLocationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-font">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-font</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFont() {
            return null;
        }

        /**
         * Specifies the color of the burned-in captions.
         * <p>
         * This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-fontcolor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-fontcolor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFontColor() {
            return null;
        }

        /**
         * Specifies the opacity of the burned-in captions.
         * <p>
         * 255 is opaque; 0 is transparent. All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-fontopacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-fontopacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFontOpacity() {
            return null;
        }

        /**
         * The font resolution in DPI (dots per inch).
         * <p>
         * The default is 96 dpi. All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-fontresolution">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-fontresolution</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFontResolution() {
            return null;
        }

        /**
         * When set to auto, fontSize scales depending on the size of the output.
         * <p>
         * Providing a positive integer specifies the exact font size in points. All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-fontsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-fontsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFontSize() {
            return null;
        }

        /**
         * Specifies the font outline color.
         * <p>
         * This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-outlinecolor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-outlinecolor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutlineColor() {
            return null;
        }

        /**
         * Specifies font outline size in pixels.
         * <p>
         * This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-outlinesize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-outlinesize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOutlineSize() {
            return null;
        }

        /**
         * Specifies the color of the shadow cast by the captions.
         * <p>
         * All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-shadowcolor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-shadowcolor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getShadowColor() {
            return null;
        }

        /**
         * Specifies the opacity of the shadow.
         * <p>
         * 255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-shadowopacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-shadowopacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getShadowOpacity() {
            return null;
        }

        /**
         * Specifies the horizontal offset of the shadow that is relative to the captions in pixels.
         * <p>
         * A value of -2 would result in a shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-shadowxoffset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-shadowxoffset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getShadowXOffset() {
            return null;
        }

        /**
         * Specifies the vertical offset of the shadow that is relative to the captions in pixels.
         * <p>
         * A value of -2 would result in a shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-shadowyoffset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-shadowyoffset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getShadowYOffset() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-subtitlerows">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-subtitlerows</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubtitleRows() {
            return null;
        }

        /**
         * Controls whether a fixed grid size is used to generate the output subtitles bitmap.
         * <p>
         * This applies only to Teletext inputs and DVB-Sub/Burn-in outputs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-teletextgridcontrol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-teletextgridcontrol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTeletextGridControl() {
            return null;
        }

        /**
         * Specifies the horizontal position of the captions relative to the left side of the output in pixels.
         * <p>
         * A value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit xPosition is provided, the horizontal captions position is determined by the alignment parameter. All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-xposition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-xposition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getXPosition() {
            return null;
        }

        /**
         * Specifies the vertical position of the captions relative to the top of the output in pixels.
         * <p>
         * A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit yPosition is provided, the captions are positioned towards the bottom of the output. All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-yposition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-yposition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getYPosition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BurnInDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BurnInDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BurnInDestinationSettingsProperty> {
            java.lang.String alignment;
            java.lang.String backgroundColor;
            java.lang.Number backgroundOpacity;
            java.lang.Object font;
            java.lang.String fontColor;
            java.lang.Number fontOpacity;
            java.lang.Number fontResolution;
            java.lang.String fontSize;
            java.lang.String outlineColor;
            java.lang.Number outlineSize;
            java.lang.String shadowColor;
            java.lang.Number shadowOpacity;
            java.lang.Number shadowXOffset;
            java.lang.Number shadowYOffset;
            java.lang.String subtitleRows;
            java.lang.String teletextGridControl;
            java.lang.Number xPosition;
            java.lang.Number yPosition;

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getAlignment}
             * @param alignment If no explicit xPosition or yPosition is provided, setting alignment to centered places the captions at the bottom center of the output.
             *                  Similarly, setting a left alignment aligns captions to the bottom left of the output. If x and y positions are specified in conjunction with the alignment parameter, the font is justified (either left or centered) relative to those coordinates. Selecting "smart" justification left-justifies live subtitles and center-justifies pre-recorded subtitles. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alignment(java.lang.String alignment) {
                this.alignment = alignment;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getBackgroundColor}
             * @param backgroundColor Specifies the color of the rectangle behind the captions.
             *                        All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backgroundColor(java.lang.String backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getBackgroundOpacity}
             * @param backgroundOpacity Specifies the opacity of the background rectangle.
             *                          255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backgroundOpacity(java.lang.Number backgroundOpacity) {
                this.backgroundOpacity = backgroundOpacity;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getFont}
             * @param font The external font file that is used for captions burn-in.
             *             The file extension must be .ttf or .tte. Although you can select output fonts for many different types of input captions, embedded, STL, and Teletext sources use a strict grid system. Using external fonts with these captions sources could cause an unexpected display of proportional fonts. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder font(software.amazon.awscdk.IResolvable font) {
                this.font = font;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getFont}
             * @param font The external font file that is used for captions burn-in.
             *             The file extension must be .ttf or .tte. Although you can select output fonts for many different types of input captions, embedded, STL, and Teletext sources use a strict grid system. Using external fonts with these captions sources could cause an unexpected display of proportional fonts. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder font(software.amazon.awscdk.services.medialive.CfnChannel.InputLocationProperty font) {
                this.font = font;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getFontColor}
             * @param fontColor Specifies the color of the burned-in captions.
             *                  This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontColor(java.lang.String fontColor) {
                this.fontColor = fontColor;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getFontOpacity}
             * @param fontOpacity Specifies the opacity of the burned-in captions.
             *                    255 is opaque; 0 is transparent. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontOpacity(java.lang.Number fontOpacity) {
                this.fontOpacity = fontOpacity;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getFontResolution}
             * @param fontResolution The font resolution in DPI (dots per inch).
             *                       The default is 96 dpi. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontResolution(java.lang.Number fontResolution) {
                this.fontResolution = fontResolution;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getFontSize}
             * @param fontSize When set to auto, fontSize scales depending on the size of the output.
             *                 Providing a positive integer specifies the exact font size in points. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontSize(java.lang.String fontSize) {
                this.fontSize = fontSize;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getOutlineColor}
             * @param outlineColor Specifies the font outline color.
             *                     This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outlineColor(java.lang.String outlineColor) {
                this.outlineColor = outlineColor;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getOutlineSize}
             * @param outlineSize Specifies font outline size in pixels.
             *                    This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outlineSize(java.lang.Number outlineSize) {
                this.outlineSize = outlineSize;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getShadowColor}
             * @param shadowColor Specifies the color of the shadow cast by the captions.
             *                    All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shadowColor(java.lang.String shadowColor) {
                this.shadowColor = shadowColor;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getShadowOpacity}
             * @param shadowOpacity Specifies the opacity of the shadow.
             *                      255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shadowOpacity(java.lang.Number shadowOpacity) {
                this.shadowOpacity = shadowOpacity;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getShadowXOffset}
             * @param shadowXOffset Specifies the horizontal offset of the shadow that is relative to the captions in pixels.
             *                      A value of -2 would result in a shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shadowXOffset(java.lang.Number shadowXOffset) {
                this.shadowXOffset = shadowXOffset;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getShadowYOffset}
             * @param shadowYOffset Specifies the vertical offset of the shadow that is relative to the captions in pixels.
             *                      A value of -2 would result in a shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shadowYOffset(java.lang.Number shadowYOffset) {
                this.shadowYOffset = shadowYOffset;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getSubtitleRows}
             * @param subtitleRows the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subtitleRows(java.lang.String subtitleRows) {
                this.subtitleRows = subtitleRows;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getTeletextGridControl}
             * @param teletextGridControl Controls whether a fixed grid size is used to generate the output subtitles bitmap.
             *                            This applies only to Teletext inputs and DVB-Sub/Burn-in outputs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder teletextGridControl(java.lang.String teletextGridControl) {
                this.teletextGridControl = teletextGridControl;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getXPosition}
             * @param xPosition Specifies the horizontal position of the captions relative to the left side of the output in pixels.
             *                  A value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit xPosition is provided, the horizontal captions position is determined by the alignment parameter. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder xPosition(java.lang.Number xPosition) {
                this.xPosition = xPosition;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getYPosition}
             * @param yPosition Specifies the vertical position of the captions relative to the top of the output in pixels.
             *                  A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit yPosition is provided, the captions are positioned towards the bottom of the output. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder yPosition(java.lang.Number yPosition) {
                this.yPosition = yPosition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BurnInDestinationSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BurnInDestinationSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BurnInDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BurnInDestinationSettingsProperty {
            private final java.lang.String alignment;
            private final java.lang.String backgroundColor;
            private final java.lang.Number backgroundOpacity;
            private final java.lang.Object font;
            private final java.lang.String fontColor;
            private final java.lang.Number fontOpacity;
            private final java.lang.Number fontResolution;
            private final java.lang.String fontSize;
            private final java.lang.String outlineColor;
            private final java.lang.Number outlineSize;
            private final java.lang.String shadowColor;
            private final java.lang.Number shadowOpacity;
            private final java.lang.Number shadowXOffset;
            private final java.lang.Number shadowYOffset;
            private final java.lang.String subtitleRows;
            private final java.lang.String teletextGridControl;
            private final java.lang.Number xPosition;
            private final java.lang.Number yPosition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alignment = software.amazon.jsii.Kernel.get(this, "alignment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.backgroundColor = software.amazon.jsii.Kernel.get(this, "backgroundColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.backgroundOpacity = software.amazon.jsii.Kernel.get(this, "backgroundOpacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.font = software.amazon.jsii.Kernel.get(this, "font", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fontColor = software.amazon.jsii.Kernel.get(this, "fontColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fontOpacity = software.amazon.jsii.Kernel.get(this, "fontOpacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.fontResolution = software.amazon.jsii.Kernel.get(this, "fontResolution", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.fontSize = software.amazon.jsii.Kernel.get(this, "fontSize", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outlineColor = software.amazon.jsii.Kernel.get(this, "outlineColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outlineSize = software.amazon.jsii.Kernel.get(this, "outlineSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.shadowColor = software.amazon.jsii.Kernel.get(this, "shadowColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.shadowOpacity = software.amazon.jsii.Kernel.get(this, "shadowOpacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.shadowXOffset = software.amazon.jsii.Kernel.get(this, "shadowXOffset", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.shadowYOffset = software.amazon.jsii.Kernel.get(this, "shadowYOffset", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.subtitleRows = software.amazon.jsii.Kernel.get(this, "subtitleRows", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.teletextGridControl = software.amazon.jsii.Kernel.get(this, "teletextGridControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.xPosition = software.amazon.jsii.Kernel.get(this, "xPosition", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.yPosition = software.amazon.jsii.Kernel.get(this, "yPosition", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alignment = builder.alignment;
                this.backgroundColor = builder.backgroundColor;
                this.backgroundOpacity = builder.backgroundOpacity;
                this.font = builder.font;
                this.fontColor = builder.fontColor;
                this.fontOpacity = builder.fontOpacity;
                this.fontResolution = builder.fontResolution;
                this.fontSize = builder.fontSize;
                this.outlineColor = builder.outlineColor;
                this.outlineSize = builder.outlineSize;
                this.shadowColor = builder.shadowColor;
                this.shadowOpacity = builder.shadowOpacity;
                this.shadowXOffset = builder.shadowXOffset;
                this.shadowYOffset = builder.shadowYOffset;
                this.subtitleRows = builder.subtitleRows;
                this.teletextGridControl = builder.teletextGridControl;
                this.xPosition = builder.xPosition;
                this.yPosition = builder.yPosition;
            }

            @Override
            public final java.lang.String getAlignment() {
                return this.alignment;
            }

            @Override
            public final java.lang.String getBackgroundColor() {
                return this.backgroundColor;
            }

            @Override
            public final java.lang.Number getBackgroundOpacity() {
                return this.backgroundOpacity;
            }

            @Override
            public final java.lang.Object getFont() {
                return this.font;
            }

            @Override
            public final java.lang.String getFontColor() {
                return this.fontColor;
            }

            @Override
            public final java.lang.Number getFontOpacity() {
                return this.fontOpacity;
            }

            @Override
            public final java.lang.Number getFontResolution() {
                return this.fontResolution;
            }

            @Override
            public final java.lang.String getFontSize() {
                return this.fontSize;
            }

            @Override
            public final java.lang.String getOutlineColor() {
                return this.outlineColor;
            }

            @Override
            public final java.lang.Number getOutlineSize() {
                return this.outlineSize;
            }

            @Override
            public final java.lang.String getShadowColor() {
                return this.shadowColor;
            }

            @Override
            public final java.lang.Number getShadowOpacity() {
                return this.shadowOpacity;
            }

            @Override
            public final java.lang.Number getShadowXOffset() {
                return this.shadowXOffset;
            }

            @Override
            public final java.lang.Number getShadowYOffset() {
                return this.shadowYOffset;
            }

            @Override
            public final java.lang.String getSubtitleRows() {
                return this.subtitleRows;
            }

            @Override
            public final java.lang.String getTeletextGridControl() {
                return this.teletextGridControl;
            }

            @Override
            public final java.lang.Number getXPosition() {
                return this.xPosition;
            }

            @Override
            public final java.lang.Number getYPosition() {
                return this.yPosition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlignment() != null) {
                    data.set("alignment", om.valueToTree(this.getAlignment()));
                }
                if (this.getBackgroundColor() != null) {
                    data.set("backgroundColor", om.valueToTree(this.getBackgroundColor()));
                }
                if (this.getBackgroundOpacity() != null) {
                    data.set("backgroundOpacity", om.valueToTree(this.getBackgroundOpacity()));
                }
                if (this.getFont() != null) {
                    data.set("font", om.valueToTree(this.getFont()));
                }
                if (this.getFontColor() != null) {
                    data.set("fontColor", om.valueToTree(this.getFontColor()));
                }
                if (this.getFontOpacity() != null) {
                    data.set("fontOpacity", om.valueToTree(this.getFontOpacity()));
                }
                if (this.getFontResolution() != null) {
                    data.set("fontResolution", om.valueToTree(this.getFontResolution()));
                }
                if (this.getFontSize() != null) {
                    data.set("fontSize", om.valueToTree(this.getFontSize()));
                }
                if (this.getOutlineColor() != null) {
                    data.set("outlineColor", om.valueToTree(this.getOutlineColor()));
                }
                if (this.getOutlineSize() != null) {
                    data.set("outlineSize", om.valueToTree(this.getOutlineSize()));
                }
                if (this.getShadowColor() != null) {
                    data.set("shadowColor", om.valueToTree(this.getShadowColor()));
                }
                if (this.getShadowOpacity() != null) {
                    data.set("shadowOpacity", om.valueToTree(this.getShadowOpacity()));
                }
                if (this.getShadowXOffset() != null) {
                    data.set("shadowXOffset", om.valueToTree(this.getShadowXOffset()));
                }
                if (this.getShadowYOffset() != null) {
                    data.set("shadowYOffset", om.valueToTree(this.getShadowYOffset()));
                }
                if (this.getSubtitleRows() != null) {
                    data.set("subtitleRows", om.valueToTree(this.getSubtitleRows()));
                }
                if (this.getTeletextGridControl() != null) {
                    data.set("teletextGridControl", om.valueToTree(this.getTeletextGridControl()));
                }
                if (this.getXPosition() != null) {
                    data.set("xPosition", om.valueToTree(this.getXPosition()));
                }
                if (this.getYPosition() != null) {
                    data.set("yPosition", om.valueToTree(this.getYPosition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.BurnInDestinationSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BurnInDestinationSettingsProperty.Jsii$Proxy that = (BurnInDestinationSettingsProperty.Jsii$Proxy) o;

                if (this.alignment != null ? !this.alignment.equals(that.alignment) : that.alignment != null) return false;
                if (this.backgroundColor != null ? !this.backgroundColor.equals(that.backgroundColor) : that.backgroundColor != null) return false;
                if (this.backgroundOpacity != null ? !this.backgroundOpacity.equals(that.backgroundOpacity) : that.backgroundOpacity != null) return false;
                if (this.font != null ? !this.font.equals(that.font) : that.font != null) return false;
                if (this.fontColor != null ? !this.fontColor.equals(that.fontColor) : that.fontColor != null) return false;
                if (this.fontOpacity != null ? !this.fontOpacity.equals(that.fontOpacity) : that.fontOpacity != null) return false;
                if (this.fontResolution != null ? !this.fontResolution.equals(that.fontResolution) : that.fontResolution != null) return false;
                if (this.fontSize != null ? !this.fontSize.equals(that.fontSize) : that.fontSize != null) return false;
                if (this.outlineColor != null ? !this.outlineColor.equals(that.outlineColor) : that.outlineColor != null) return false;
                if (this.outlineSize != null ? !this.outlineSize.equals(that.outlineSize) : that.outlineSize != null) return false;
                if (this.shadowColor != null ? !this.shadowColor.equals(that.shadowColor) : that.shadowColor != null) return false;
                if (this.shadowOpacity != null ? !this.shadowOpacity.equals(that.shadowOpacity) : that.shadowOpacity != null) return false;
                if (this.shadowXOffset != null ? !this.shadowXOffset.equals(that.shadowXOffset) : that.shadowXOffset != null) return false;
                if (this.shadowYOffset != null ? !this.shadowYOffset.equals(that.shadowYOffset) : that.shadowYOffset != null) return false;
                if (this.subtitleRows != null ? !this.subtitleRows.equals(that.subtitleRows) : that.subtitleRows != null) return false;
                if (this.teletextGridControl != null ? !this.teletextGridControl.equals(that.teletextGridControl) : that.teletextGridControl != null) return false;
                if (this.xPosition != null ? !this.xPosition.equals(that.xPosition) : that.xPosition != null) return false;
                return this.yPosition != null ? this.yPosition.equals(that.yPosition) : that.yPosition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alignment != null ? this.alignment.hashCode() : 0;
                result = 31 * result + (this.backgroundColor != null ? this.backgroundColor.hashCode() : 0);
                result = 31 * result + (this.backgroundOpacity != null ? this.backgroundOpacity.hashCode() : 0);
                result = 31 * result + (this.font != null ? this.font.hashCode() : 0);
                result = 31 * result + (this.fontColor != null ? this.fontColor.hashCode() : 0);
                result = 31 * result + (this.fontOpacity != null ? this.fontOpacity.hashCode() : 0);
                result = 31 * result + (this.fontResolution != null ? this.fontResolution.hashCode() : 0);
                result = 31 * result + (this.fontSize != null ? this.fontSize.hashCode() : 0);
                result = 31 * result + (this.outlineColor != null ? this.outlineColor.hashCode() : 0);
                result = 31 * result + (this.outlineSize != null ? this.outlineSize.hashCode() : 0);
                result = 31 * result + (this.shadowColor != null ? this.shadowColor.hashCode() : 0);
                result = 31 * result + (this.shadowOpacity != null ? this.shadowOpacity.hashCode() : 0);
                result = 31 * result + (this.shadowXOffset != null ? this.shadowXOffset.hashCode() : 0);
                result = 31 * result + (this.shadowYOffset != null ? this.shadowYOffset.hashCode() : 0);
                result = 31 * result + (this.subtitleRows != null ? this.subtitleRows.hashCode() : 0);
                result = 31 * result + (this.teletextGridControl != null ? this.teletextGridControl.hashCode() : 0);
                result = 31 * result + (this.xPosition != null ? this.xPosition.hashCode() : 0);
                result = 31 * result + (this.yPosition != null ? this.yPosition.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The encoding information for output captions.
     * <p>
     * The parent of this entity is EncoderSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * CaptionDescriptionProperty captionDescriptionProperty = CaptionDescriptionProperty.builder()
     *         .accessibility("accessibility")
     *         .captionDashRoles(List.of("captionDashRoles"))
     *         .captionSelectorName("captionSelectorName")
     *         .destinationSettings(CaptionDestinationSettingsProperty.builder()
     *                 .aribDestinationSettings(AribDestinationSettingsProperty.builder().build())
     *                 .burnInDestinationSettings(BurnInDestinationSettingsProperty.builder()
     *                         .alignment("alignment")
     *                         .backgroundColor("backgroundColor")
     *                         .backgroundOpacity(123)
     *                         .font(InputLocationProperty.builder()
     *                                 .passwordParam("passwordParam")
     *                                 .uri("uri")
     *                                 .username("username")
     *                                 .build())
     *                         .fontColor("fontColor")
     *                         .fontOpacity(123)
     *                         .fontResolution(123)
     *                         .fontSize("fontSize")
     *                         .outlineColor("outlineColor")
     *                         .outlineSize(123)
     *                         .shadowColor("shadowColor")
     *                         .shadowOpacity(123)
     *                         .shadowXOffset(123)
     *                         .shadowYOffset(123)
     *                         .subtitleRows("subtitleRows")
     *                         .teletextGridControl("teletextGridControl")
     *                         .xPosition(123)
     *                         .yPosition(123)
     *                         .build())
     *                 .dvbSubDestinationSettings(DvbSubDestinationSettingsProperty.builder()
     *                         .alignment("alignment")
     *                         .backgroundColor("backgroundColor")
     *                         .backgroundOpacity(123)
     *                         .font(InputLocationProperty.builder()
     *                                 .passwordParam("passwordParam")
     *                                 .uri("uri")
     *                                 .username("username")
     *                                 .build())
     *                         .fontColor("fontColor")
     *                         .fontOpacity(123)
     *                         .fontResolution(123)
     *                         .fontSize("fontSize")
     *                         .outlineColor("outlineColor")
     *                         .outlineSize(123)
     *                         .shadowColor("shadowColor")
     *                         .shadowOpacity(123)
     *                         .shadowXOffset(123)
     *                         .shadowYOffset(123)
     *                         .subtitleRows("subtitleRows")
     *                         .teletextGridControl("teletextGridControl")
     *                         .xPosition(123)
     *                         .yPosition(123)
     *                         .build())
     *                 .ebuTtDDestinationSettings(EbuTtDDestinationSettingsProperty.builder()
     *                         .copyrightHolder("copyrightHolder")
     *                         .defaultFontSize(123)
     *                         .defaultLineHeight(123)
     *                         .fillLineGap("fillLineGap")
     *                         .fontFamily("fontFamily")
     *                         .styleControl("styleControl")
     *                         .build())
     *                 .embeddedDestinationSettings(EmbeddedDestinationSettingsProperty.builder().build())
     *                 .embeddedPlusScte20DestinationSettings(EmbeddedPlusScte20DestinationSettingsProperty.builder().build())
     *                 .rtmpCaptionInfoDestinationSettings(RtmpCaptionInfoDestinationSettingsProperty.builder().build())
     *                 .scte20PlusEmbeddedDestinationSettings(Scte20PlusEmbeddedDestinationSettingsProperty.builder().build())
     *                 .scte27DestinationSettings(Scte27DestinationSettingsProperty.builder().build())
     *                 .smpteTtDestinationSettings(SmpteTtDestinationSettingsProperty.builder().build())
     *                 .teletextDestinationSettings(TeletextDestinationSettingsProperty.builder().build())
     *                 .ttmlDestinationSettings(TtmlDestinationSettingsProperty.builder()
     *                         .styleControl("styleControl")
     *                         .build())
     *                 .webvttDestinationSettings(WebvttDestinationSettingsProperty.builder()
     *                         .styleControl("styleControl")
     *                         .build())
     *                 .build())
     *         .dvbDashAccessibility("dvbDashAccessibility")
     *         .languageCode("languageCode")
     *         .languageDescription("languageDescription")
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.CaptionDescriptionProperty")
    @software.amazon.jsii.Jsii.Proxy(CaptionDescriptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CaptionDescriptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-accessibility">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-accessibility</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessibility() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-captiondashroles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-captiondashroles</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCaptionDashRoles() {
            return null;
        }

        /**
         * Specifies which input captions selector to use as a captions source when generating output captions.
         * <p>
         * This field should match a captionSelector name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-captionselectorname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-captionselectorname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCaptionSelectorName() {
            return null;
        }

        /**
         * Additional settings for a captions destination that depend on the destination type.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.CaptionDestinationSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-destinationsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-destinationsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestinationSettings() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-dvbdashaccessibility">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-dvbdashaccessibility</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDvbDashAccessibility() {
            return null;
        }

        /**
         * An ISO 639-2 three-digit code.
         * <p>
         * For more information, see http://www.loc.gov/standards/iso639-2/.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-languagecode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-languagecode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLanguageCode() {
            return null;
        }

        /**
         * Human-readable information to indicate the captions that are available for players (for example, English or Spanish).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-languagedescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-languagedescription</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLanguageDescription() {
            return null;
        }

        /**
         * The name of the captions description.
         * <p>
         * The name is used to associate a captions description with an output. Names must be unique within a channel.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CaptionDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CaptionDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CaptionDescriptionProperty> {
            java.lang.String accessibility;
            java.util.List<java.lang.String> captionDashRoles;
            java.lang.String captionSelectorName;
            java.lang.Object destinationSettings;
            java.lang.String dvbDashAccessibility;
            java.lang.String languageCode;
            java.lang.String languageDescription;
            java.lang.String name;

            /**
             * Sets the value of {@link CaptionDescriptionProperty#getAccessibility}
             * @param accessibility the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessibility(java.lang.String accessibility) {
                this.accessibility = accessibility;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDescriptionProperty#getCaptionDashRoles}
             * @param captionDashRoles the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captionDashRoles(java.util.List<java.lang.String> captionDashRoles) {
                this.captionDashRoles = captionDashRoles;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDescriptionProperty#getCaptionSelectorName}
             * @param captionSelectorName Specifies which input captions selector to use as a captions source when generating output captions.
             *                            This field should match a captionSelector name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captionSelectorName(java.lang.String captionSelectorName) {
                this.captionSelectorName = captionSelectorName;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDescriptionProperty#getDestinationSettings}
             * @param destinationSettings Additional settings for a captions destination that depend on the destination type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationSettings(software.amazon.awscdk.IResolvable destinationSettings) {
                this.destinationSettings = destinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDescriptionProperty#getDestinationSettings}
             * @param destinationSettings Additional settings for a captions destination that depend on the destination type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.CaptionDestinationSettingsProperty destinationSettings) {
                this.destinationSettings = destinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDescriptionProperty#getDvbDashAccessibility}
             * @param dvbDashAccessibility the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dvbDashAccessibility(java.lang.String dvbDashAccessibility) {
                this.dvbDashAccessibility = dvbDashAccessibility;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDescriptionProperty#getLanguageCode}
             * @param languageCode An ISO 639-2 three-digit code.
             *                     For more information, see http://www.loc.gov/standards/iso639-2/.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder languageCode(java.lang.String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDescriptionProperty#getLanguageDescription}
             * @param languageDescription Human-readable information to indicate the captions that are available for players (for example, English or Spanish).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder languageDescription(java.lang.String languageDescription) {
                this.languageDescription = languageDescription;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDescriptionProperty#getName}
             * @param name The name of the captions description.
             *             The name is used to associate a captions description with an output. Names must be unique within a channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CaptionDescriptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CaptionDescriptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CaptionDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CaptionDescriptionProperty {
            private final java.lang.String accessibility;
            private final java.util.List<java.lang.String> captionDashRoles;
            private final java.lang.String captionSelectorName;
            private final java.lang.Object destinationSettings;
            private final java.lang.String dvbDashAccessibility;
            private final java.lang.String languageCode;
            private final java.lang.String languageDescription;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessibility = software.amazon.jsii.Kernel.get(this, "accessibility", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.captionDashRoles = software.amazon.jsii.Kernel.get(this, "captionDashRoles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.captionSelectorName = software.amazon.jsii.Kernel.get(this, "captionSelectorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.destinationSettings = software.amazon.jsii.Kernel.get(this, "destinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dvbDashAccessibility = software.amazon.jsii.Kernel.get(this, "dvbDashAccessibility", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.languageCode = software.amazon.jsii.Kernel.get(this, "languageCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.languageDescription = software.amazon.jsii.Kernel.get(this, "languageDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessibility = builder.accessibility;
                this.captionDashRoles = builder.captionDashRoles;
                this.captionSelectorName = builder.captionSelectorName;
                this.destinationSettings = builder.destinationSettings;
                this.dvbDashAccessibility = builder.dvbDashAccessibility;
                this.languageCode = builder.languageCode;
                this.languageDescription = builder.languageDescription;
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getAccessibility() {
                return this.accessibility;
            }

            @Override
            public final java.util.List<java.lang.String> getCaptionDashRoles() {
                return this.captionDashRoles;
            }

            @Override
            public final java.lang.String getCaptionSelectorName() {
                return this.captionSelectorName;
            }

            @Override
            public final java.lang.Object getDestinationSettings() {
                return this.destinationSettings;
            }

            @Override
            public final java.lang.String getDvbDashAccessibility() {
                return this.dvbDashAccessibility;
            }

            @Override
            public final java.lang.String getLanguageCode() {
                return this.languageCode;
            }

            @Override
            public final java.lang.String getLanguageDescription() {
                return this.languageDescription;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessibility() != null) {
                    data.set("accessibility", om.valueToTree(this.getAccessibility()));
                }
                if (this.getCaptionDashRoles() != null) {
                    data.set("captionDashRoles", om.valueToTree(this.getCaptionDashRoles()));
                }
                if (this.getCaptionSelectorName() != null) {
                    data.set("captionSelectorName", om.valueToTree(this.getCaptionSelectorName()));
                }
                if (this.getDestinationSettings() != null) {
                    data.set("destinationSettings", om.valueToTree(this.getDestinationSettings()));
                }
                if (this.getDvbDashAccessibility() != null) {
                    data.set("dvbDashAccessibility", om.valueToTree(this.getDvbDashAccessibility()));
                }
                if (this.getLanguageCode() != null) {
                    data.set("languageCode", om.valueToTree(this.getLanguageCode()));
                }
                if (this.getLanguageDescription() != null) {
                    data.set("languageDescription", om.valueToTree(this.getLanguageDescription()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.CaptionDescriptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CaptionDescriptionProperty.Jsii$Proxy that = (CaptionDescriptionProperty.Jsii$Proxy) o;

                if (this.accessibility != null ? !this.accessibility.equals(that.accessibility) : that.accessibility != null) return false;
                if (this.captionDashRoles != null ? !this.captionDashRoles.equals(that.captionDashRoles) : that.captionDashRoles != null) return false;
                if (this.captionSelectorName != null ? !this.captionSelectorName.equals(that.captionSelectorName) : that.captionSelectorName != null) return false;
                if (this.destinationSettings != null ? !this.destinationSettings.equals(that.destinationSettings) : that.destinationSettings != null) return false;
                if (this.dvbDashAccessibility != null ? !this.dvbDashAccessibility.equals(that.dvbDashAccessibility) : that.dvbDashAccessibility != null) return false;
                if (this.languageCode != null ? !this.languageCode.equals(that.languageCode) : that.languageCode != null) return false;
                if (this.languageDescription != null ? !this.languageDescription.equals(that.languageDescription) : that.languageDescription != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessibility != null ? this.accessibility.hashCode() : 0;
                result = 31 * result + (this.captionDashRoles != null ? this.captionDashRoles.hashCode() : 0);
                result = 31 * result + (this.captionSelectorName != null ? this.captionSelectorName.hashCode() : 0);
                result = 31 * result + (this.destinationSettings != null ? this.destinationSettings.hashCode() : 0);
                result = 31 * result + (this.dvbDashAccessibility != null ? this.dvbDashAccessibility.hashCode() : 0);
                result = 31 * result + (this.languageCode != null ? this.languageCode.hashCode() : 0);
                result = 31 * result + (this.languageDescription != null ? this.languageDescription.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of one captions encode in the output.
     * <p>
     * The parent of this entity is CaptionDescription.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * CaptionDestinationSettingsProperty captionDestinationSettingsProperty = CaptionDestinationSettingsProperty.builder()
     *         .aribDestinationSettings(AribDestinationSettingsProperty.builder().build())
     *         .burnInDestinationSettings(BurnInDestinationSettingsProperty.builder()
     *                 .alignment("alignment")
     *                 .backgroundColor("backgroundColor")
     *                 .backgroundOpacity(123)
     *                 .font(InputLocationProperty.builder()
     *                         .passwordParam("passwordParam")
     *                         .uri("uri")
     *                         .username("username")
     *                         .build())
     *                 .fontColor("fontColor")
     *                 .fontOpacity(123)
     *                 .fontResolution(123)
     *                 .fontSize("fontSize")
     *                 .outlineColor("outlineColor")
     *                 .outlineSize(123)
     *                 .shadowColor("shadowColor")
     *                 .shadowOpacity(123)
     *                 .shadowXOffset(123)
     *                 .shadowYOffset(123)
     *                 .subtitleRows("subtitleRows")
     *                 .teletextGridControl("teletextGridControl")
     *                 .xPosition(123)
     *                 .yPosition(123)
     *                 .build())
     *         .dvbSubDestinationSettings(DvbSubDestinationSettingsProperty.builder()
     *                 .alignment("alignment")
     *                 .backgroundColor("backgroundColor")
     *                 .backgroundOpacity(123)
     *                 .font(InputLocationProperty.builder()
     *                         .passwordParam("passwordParam")
     *                         .uri("uri")
     *                         .username("username")
     *                         .build())
     *                 .fontColor("fontColor")
     *                 .fontOpacity(123)
     *                 .fontResolution(123)
     *                 .fontSize("fontSize")
     *                 .outlineColor("outlineColor")
     *                 .outlineSize(123)
     *                 .shadowColor("shadowColor")
     *                 .shadowOpacity(123)
     *                 .shadowXOffset(123)
     *                 .shadowYOffset(123)
     *                 .subtitleRows("subtitleRows")
     *                 .teletextGridControl("teletextGridControl")
     *                 .xPosition(123)
     *                 .yPosition(123)
     *                 .build())
     *         .ebuTtDDestinationSettings(EbuTtDDestinationSettingsProperty.builder()
     *                 .copyrightHolder("copyrightHolder")
     *                 .defaultFontSize(123)
     *                 .defaultLineHeight(123)
     *                 .fillLineGap("fillLineGap")
     *                 .fontFamily("fontFamily")
     *                 .styleControl("styleControl")
     *                 .build())
     *         .embeddedDestinationSettings(EmbeddedDestinationSettingsProperty.builder().build())
     *         .embeddedPlusScte20DestinationSettings(EmbeddedPlusScte20DestinationSettingsProperty.builder().build())
     *         .rtmpCaptionInfoDestinationSettings(RtmpCaptionInfoDestinationSettingsProperty.builder().build())
     *         .scte20PlusEmbeddedDestinationSettings(Scte20PlusEmbeddedDestinationSettingsProperty.builder().build())
     *         .scte27DestinationSettings(Scte27DestinationSettingsProperty.builder().build())
     *         .smpteTtDestinationSettings(SmpteTtDestinationSettingsProperty.builder().build())
     *         .teletextDestinationSettings(TeletextDestinationSettingsProperty.builder().build())
     *         .ttmlDestinationSettings(TtmlDestinationSettingsProperty.builder()
     *                 .styleControl("styleControl")
     *                 .build())
     *         .webvttDestinationSettings(WebvttDestinationSettingsProperty.builder()
     *                 .styleControl("styleControl")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.CaptionDestinationSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(CaptionDestinationSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CaptionDestinationSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration of one ARIB captions encode in the output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.AribDestinationSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-aribdestinationsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-aribdestinationsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAribDestinationSettings() {
            return null;
        }

        /**
         * The configuration of one burn-in captions encode in the output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.BurnInDestinationSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-burnindestinationsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-burnindestinationsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBurnInDestinationSettings() {
            return null;
        }

        /**
         * The configuration of one DVB Sub captions encode in the output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.DvbSubDestinationSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-dvbsubdestinationsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-dvbsubdestinationsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDvbSubDestinationSettings() {
            return null;
        }

        /**
         * Settings for EBU-TT captions in the output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.EbuTtDDestinationSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-ebuttddestinationsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-ebuttddestinationsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbuTtDDestinationSettings() {
            return null;
        }

        /**
         * The configuration of one embedded captions encode in the output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.EmbeddedDestinationSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-embeddeddestinationsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-embeddeddestinationsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmbeddedDestinationSettings() {
            return null;
        }

        /**
         * The configuration of one embedded plus SCTE-20 captions encode in the output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.EmbeddedPlusScte20DestinationSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-embeddedplusscte20destinationsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-embeddedplusscte20destinationsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmbeddedPlusScte20DestinationSettings() {
            return null;
        }

        /**
         * The configuration of one RTMPCaptionInfo captions encode in the output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.RtmpCaptionInfoDestinationSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-rtmpcaptioninfodestinationsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-rtmpcaptioninfodestinationsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRtmpCaptionInfoDestinationSettings() {
            return null;
        }

        /**
         * The configuration of one SCTE20 plus embedded captions encode in the output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.Scte20PlusEmbeddedDestinationSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-scte20plusembeddeddestinationsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-scte20plusembeddeddestinationsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScte20PlusEmbeddedDestinationSettings() {
            return null;
        }

        /**
         * The configuration of one SCTE-27 captions encode in the output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.Scte27DestinationSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-scte27destinationsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-scte27destinationsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScte27DestinationSettings() {
            return null;
        }

        /**
         * The configuration of one SMPTE-TT captions encode in the output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.SmpteTtDestinationSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-smptettdestinationsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-smptettdestinationsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSmpteTtDestinationSettings() {
            return null;
        }

        /**
         * The configuration of one Teletext captions encode in the output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.TeletextDestinationSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-teletextdestinationsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-teletextdestinationsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTeletextDestinationSettings() {
            return null;
        }

        /**
         * The configuration of one TTML captions encode in the output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.TtmlDestinationSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-ttmldestinationsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-ttmldestinationsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTtmlDestinationSettings() {
            return null;
        }

        /**
         * The configuration of one WebVTT captions encode in the output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.WebvttDestinationSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-webvttdestinationsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-webvttdestinationsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWebvttDestinationSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CaptionDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CaptionDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CaptionDestinationSettingsProperty> {
            java.lang.Object aribDestinationSettings;
            java.lang.Object burnInDestinationSettings;
            java.lang.Object dvbSubDestinationSettings;
            java.lang.Object ebuTtDDestinationSettings;
            java.lang.Object embeddedDestinationSettings;
            java.lang.Object embeddedPlusScte20DestinationSettings;
            java.lang.Object rtmpCaptionInfoDestinationSettings;
            java.lang.Object scte20PlusEmbeddedDestinationSettings;
            java.lang.Object scte27DestinationSettings;
            java.lang.Object smpteTtDestinationSettings;
            java.lang.Object teletextDestinationSettings;
            java.lang.Object ttmlDestinationSettings;
            java.lang.Object webvttDestinationSettings;

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getAribDestinationSettings}
             * @param aribDestinationSettings The configuration of one ARIB captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aribDestinationSettings(software.amazon.awscdk.IResolvable aribDestinationSettings) {
                this.aribDestinationSettings = aribDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getAribDestinationSettings}
             * @param aribDestinationSettings The configuration of one ARIB captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aribDestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.AribDestinationSettingsProperty aribDestinationSettings) {
                this.aribDestinationSettings = aribDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getBurnInDestinationSettings}
             * @param burnInDestinationSettings The configuration of one burn-in captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder burnInDestinationSettings(software.amazon.awscdk.IResolvable burnInDestinationSettings) {
                this.burnInDestinationSettings = burnInDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getBurnInDestinationSettings}
             * @param burnInDestinationSettings The configuration of one burn-in captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder burnInDestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.BurnInDestinationSettingsProperty burnInDestinationSettings) {
                this.burnInDestinationSettings = burnInDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getDvbSubDestinationSettings}
             * @param dvbSubDestinationSettings The configuration of one DVB Sub captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dvbSubDestinationSettings(software.amazon.awscdk.IResolvable dvbSubDestinationSettings) {
                this.dvbSubDestinationSettings = dvbSubDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getDvbSubDestinationSettings}
             * @param dvbSubDestinationSettings The configuration of one DVB Sub captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dvbSubDestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.DvbSubDestinationSettingsProperty dvbSubDestinationSettings) {
                this.dvbSubDestinationSettings = dvbSubDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getEbuTtDDestinationSettings}
             * @param ebuTtDDestinationSettings Settings for EBU-TT captions in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebuTtDDestinationSettings(software.amazon.awscdk.IResolvable ebuTtDDestinationSettings) {
                this.ebuTtDDestinationSettings = ebuTtDDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getEbuTtDDestinationSettings}
             * @param ebuTtDDestinationSettings Settings for EBU-TT captions in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebuTtDDestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.EbuTtDDestinationSettingsProperty ebuTtDDestinationSettings) {
                this.ebuTtDDestinationSettings = ebuTtDDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getEmbeddedDestinationSettings}
             * @param embeddedDestinationSettings The configuration of one embedded captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder embeddedDestinationSettings(software.amazon.awscdk.IResolvable embeddedDestinationSettings) {
                this.embeddedDestinationSettings = embeddedDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getEmbeddedDestinationSettings}
             * @param embeddedDestinationSettings The configuration of one embedded captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder embeddedDestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.EmbeddedDestinationSettingsProperty embeddedDestinationSettings) {
                this.embeddedDestinationSettings = embeddedDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getEmbeddedPlusScte20DestinationSettings}
             * @param embeddedPlusScte20DestinationSettings The configuration of one embedded plus SCTE-20 captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder embeddedPlusScte20DestinationSettings(software.amazon.awscdk.IResolvable embeddedPlusScte20DestinationSettings) {
                this.embeddedPlusScte20DestinationSettings = embeddedPlusScte20DestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getEmbeddedPlusScte20DestinationSettings}
             * @param embeddedPlusScte20DestinationSettings The configuration of one embedded plus SCTE-20 captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder embeddedPlusScte20DestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.EmbeddedPlusScte20DestinationSettingsProperty embeddedPlusScte20DestinationSettings) {
                this.embeddedPlusScte20DestinationSettings = embeddedPlusScte20DestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getRtmpCaptionInfoDestinationSettings}
             * @param rtmpCaptionInfoDestinationSettings The configuration of one RTMPCaptionInfo captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rtmpCaptionInfoDestinationSettings(software.amazon.awscdk.IResolvable rtmpCaptionInfoDestinationSettings) {
                this.rtmpCaptionInfoDestinationSettings = rtmpCaptionInfoDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getRtmpCaptionInfoDestinationSettings}
             * @param rtmpCaptionInfoDestinationSettings The configuration of one RTMPCaptionInfo captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rtmpCaptionInfoDestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.RtmpCaptionInfoDestinationSettingsProperty rtmpCaptionInfoDestinationSettings) {
                this.rtmpCaptionInfoDestinationSettings = rtmpCaptionInfoDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getScte20PlusEmbeddedDestinationSettings}
             * @param scte20PlusEmbeddedDestinationSettings The configuration of one SCTE20 plus embedded captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte20PlusEmbeddedDestinationSettings(software.amazon.awscdk.IResolvable scte20PlusEmbeddedDestinationSettings) {
                this.scte20PlusEmbeddedDestinationSettings = scte20PlusEmbeddedDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getScte20PlusEmbeddedDestinationSettings}
             * @param scte20PlusEmbeddedDestinationSettings The configuration of one SCTE20 plus embedded captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte20PlusEmbeddedDestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.Scte20PlusEmbeddedDestinationSettingsProperty scte20PlusEmbeddedDestinationSettings) {
                this.scte20PlusEmbeddedDestinationSettings = scte20PlusEmbeddedDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getScte27DestinationSettings}
             * @param scte27DestinationSettings The configuration of one SCTE-27 captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte27DestinationSettings(software.amazon.awscdk.IResolvable scte27DestinationSettings) {
                this.scte27DestinationSettings = scte27DestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getScte27DestinationSettings}
             * @param scte27DestinationSettings The configuration of one SCTE-27 captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte27DestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.Scte27DestinationSettingsProperty scte27DestinationSettings) {
                this.scte27DestinationSettings = scte27DestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getSmpteTtDestinationSettings}
             * @param smpteTtDestinationSettings The configuration of one SMPTE-TT captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smpteTtDestinationSettings(software.amazon.awscdk.IResolvable smpteTtDestinationSettings) {
                this.smpteTtDestinationSettings = smpteTtDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getSmpteTtDestinationSettings}
             * @param smpteTtDestinationSettings The configuration of one SMPTE-TT captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smpteTtDestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.SmpteTtDestinationSettingsProperty smpteTtDestinationSettings) {
                this.smpteTtDestinationSettings = smpteTtDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getTeletextDestinationSettings}
             * @param teletextDestinationSettings The configuration of one Teletext captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder teletextDestinationSettings(software.amazon.awscdk.IResolvable teletextDestinationSettings) {
                this.teletextDestinationSettings = teletextDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getTeletextDestinationSettings}
             * @param teletextDestinationSettings The configuration of one Teletext captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder teletextDestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.TeletextDestinationSettingsProperty teletextDestinationSettings) {
                this.teletextDestinationSettings = teletextDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getTtmlDestinationSettings}
             * @param ttmlDestinationSettings The configuration of one TTML captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ttmlDestinationSettings(software.amazon.awscdk.IResolvable ttmlDestinationSettings) {
                this.ttmlDestinationSettings = ttmlDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getTtmlDestinationSettings}
             * @param ttmlDestinationSettings The configuration of one TTML captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ttmlDestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.TtmlDestinationSettingsProperty ttmlDestinationSettings) {
                this.ttmlDestinationSettings = ttmlDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getWebvttDestinationSettings}
             * @param webvttDestinationSettings The configuration of one WebVTT captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webvttDestinationSettings(software.amazon.awscdk.IResolvable webvttDestinationSettings) {
                this.webvttDestinationSettings = webvttDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getWebvttDestinationSettings}
             * @param webvttDestinationSettings The configuration of one WebVTT captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webvttDestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.WebvttDestinationSettingsProperty webvttDestinationSettings) {
                this.webvttDestinationSettings = webvttDestinationSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CaptionDestinationSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CaptionDestinationSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CaptionDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CaptionDestinationSettingsProperty {
            private final java.lang.Object aribDestinationSettings;
            private final java.lang.Object burnInDestinationSettings;
            private final java.lang.Object dvbSubDestinationSettings;
            private final java.lang.Object ebuTtDDestinationSettings;
            private final java.lang.Object embeddedDestinationSettings;
            private final java.lang.Object embeddedPlusScte20DestinationSettings;
            private final java.lang.Object rtmpCaptionInfoDestinationSettings;
            private final java.lang.Object scte20PlusEmbeddedDestinationSettings;
            private final java.lang.Object scte27DestinationSettings;
            private final java.lang.Object smpteTtDestinationSettings;
            private final java.lang.Object teletextDestinationSettings;
            private final java.lang.Object ttmlDestinationSettings;
            private final java.lang.Object webvttDestinationSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aribDestinationSettings = software.amazon.jsii.Kernel.get(this, "aribDestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.burnInDestinationSettings = software.amazon.jsii.Kernel.get(this, "burnInDestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dvbSubDestinationSettings = software.amazon.jsii.Kernel.get(this, "dvbSubDestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ebuTtDDestinationSettings = software.amazon.jsii.Kernel.get(this, "ebuTtDDestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.embeddedDestinationSettings = software.amazon.jsii.Kernel.get(this, "embeddedDestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.embeddedPlusScte20DestinationSettings = software.amazon.jsii.Kernel.get(this, "embeddedPlusScte20DestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rtmpCaptionInfoDestinationSettings = software.amazon.jsii.Kernel.get(this, "rtmpCaptionInfoDestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scte20PlusEmbeddedDestinationSettings = software.amazon.jsii.Kernel.get(this, "scte20PlusEmbeddedDestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scte27DestinationSettings = software.amazon.jsii.Kernel.get(this, "scte27DestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.smpteTtDestinationSettings = software.amazon.jsii.Kernel.get(this, "smpteTtDestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.teletextDestinationSettings = software.amazon.jsii.Kernel.get(this, "teletextDestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ttmlDestinationSettings = software.amazon.jsii.Kernel.get(this, "ttmlDestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.webvttDestinationSettings = software.amazon.jsii.Kernel.get(this, "webvttDestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aribDestinationSettings = builder.aribDestinationSettings;
                this.burnInDestinationSettings = builder.burnInDestinationSettings;
                this.dvbSubDestinationSettings = builder.dvbSubDestinationSettings;
                this.ebuTtDDestinationSettings = builder.ebuTtDDestinationSettings;
                this.embeddedDestinationSettings = builder.embeddedDestinationSettings;
                this.embeddedPlusScte20DestinationSettings = builder.embeddedPlusScte20DestinationSettings;
                this.rtmpCaptionInfoDestinationSettings = builder.rtmpCaptionInfoDestinationSettings;
                this.scte20PlusEmbeddedDestinationSettings = builder.scte20PlusEmbeddedDestinationSettings;
                this.scte27DestinationSettings = builder.scte27DestinationSettings;
                this.smpteTtDestinationSettings = builder.smpteTtDestinationSettings;
                this.teletextDestinationSettings = builder.teletextDestinationSettings;
                this.ttmlDestinationSettings = builder.ttmlDestinationSettings;
                this.webvttDestinationSettings = builder.webvttDestinationSettings;
            }

            @Override
            public final java.lang.Object getAribDestinationSettings() {
                return this.aribDestinationSettings;
            }

            @Override
            public final java.lang.Object getBurnInDestinationSettings() {
                return this.burnInDestinationSettings;
            }

            @Override
            public final java.lang.Object getDvbSubDestinationSettings() {
                return this.dvbSubDestinationSettings;
            }

            @Override
            public final java.lang.Object getEbuTtDDestinationSettings() {
                return this.ebuTtDDestinationSettings;
            }

            @Override
            public final java.lang.Object getEmbeddedDestinationSettings() {
                return this.embeddedDestinationSettings;
            }

            @Override
            public final java.lang.Object getEmbeddedPlusScte20DestinationSettings() {
                return this.embeddedPlusScte20DestinationSettings;
            }

            @Override
            public final java.lang.Object getRtmpCaptionInfoDestinationSettings() {
                return this.rtmpCaptionInfoDestinationSettings;
            }

            @Override
            public final java.lang.Object getScte20PlusEmbeddedDestinationSettings() {
                return this.scte20PlusEmbeddedDestinationSettings;
            }

            @Override
            public final java.lang.Object getScte27DestinationSettings() {
                return this.scte27DestinationSettings;
            }

            @Override
            public final java.lang.Object getSmpteTtDestinationSettings() {
                return this.smpteTtDestinationSettings;
            }

            @Override
            public final java.lang.Object getTeletextDestinationSettings() {
                return this.teletextDestinationSettings;
            }

            @Override
            public final java.lang.Object getTtmlDestinationSettings() {
                return this.ttmlDestinationSettings;
            }

            @Override
            public final java.lang.Object getWebvttDestinationSettings() {
                return this.webvttDestinationSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAribDestinationSettings() != null) {
                    data.set("aribDestinationSettings", om.valueToTree(this.getAribDestinationSettings()));
                }
                if (this.getBurnInDestinationSettings() != null) {
                    data.set("burnInDestinationSettings", om.valueToTree(this.getBurnInDestinationSettings()));
                }
                if (this.getDvbSubDestinationSettings() != null) {
                    data.set("dvbSubDestinationSettings", om.valueToTree(this.getDvbSubDestinationSettings()));
                }
                if (this.getEbuTtDDestinationSettings() != null) {
                    data.set("ebuTtDDestinationSettings", om.valueToTree(this.getEbuTtDDestinationSettings()));
                }
                if (this.getEmbeddedDestinationSettings() != null) {
                    data.set("embeddedDestinationSettings", om.valueToTree(this.getEmbeddedDestinationSettings()));
                }
                if (this.getEmbeddedPlusScte20DestinationSettings() != null) {
                    data.set("embeddedPlusScte20DestinationSettings", om.valueToTree(this.getEmbeddedPlusScte20DestinationSettings()));
                }
                if (this.getRtmpCaptionInfoDestinationSettings() != null) {
                    data.set("rtmpCaptionInfoDestinationSettings", om.valueToTree(this.getRtmpCaptionInfoDestinationSettings()));
                }
                if (this.getScte20PlusEmbeddedDestinationSettings() != null) {
                    data.set("scte20PlusEmbeddedDestinationSettings", om.valueToTree(this.getScte20PlusEmbeddedDestinationSettings()));
                }
                if (this.getScte27DestinationSettings() != null) {
                    data.set("scte27DestinationSettings", om.valueToTree(this.getScte27DestinationSettings()));
                }
                if (this.getSmpteTtDestinationSettings() != null) {
                    data.set("smpteTtDestinationSettings", om.valueToTree(this.getSmpteTtDestinationSettings()));
                }
                if (this.getTeletextDestinationSettings() != null) {
                    data.set("teletextDestinationSettings", om.valueToTree(this.getTeletextDestinationSettings()));
                }
                if (this.getTtmlDestinationSettings() != null) {
                    data.set("ttmlDestinationSettings", om.valueToTree(this.getTtmlDestinationSettings()));
                }
                if (this.getWebvttDestinationSettings() != null) {
                    data.set("webvttDestinationSettings", om.valueToTree(this.getWebvttDestinationSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.CaptionDestinationSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CaptionDestinationSettingsProperty.Jsii$Proxy that = (CaptionDestinationSettingsProperty.Jsii$Proxy) o;

                if (this.aribDestinationSettings != null ? !this.aribDestinationSettings.equals(that.aribDestinationSettings) : that.aribDestinationSettings != null) return false;
                if (this.burnInDestinationSettings != null ? !this.burnInDestinationSettings.equals(that.burnInDestinationSettings) : that.burnInDestinationSettings != null) return false;
                if (this.dvbSubDestinationSettings != null ? !this.dvbSubDestinationSettings.equals(that.dvbSubDestinationSettings) : that.dvbSubDestinationSettings != null) return false;
                if (this.ebuTtDDestinationSettings != null ? !this.ebuTtDDestinationSettings.equals(that.ebuTtDDestinationSettings) : that.ebuTtDDestinationSettings != null) return false;
                if (this.embeddedDestinationSettings != null ? !this.embeddedDestinationSettings.equals(that.embeddedDestinationSettings) : that.embeddedDestinationSettings != null) return false;
                if (this.embeddedPlusScte20DestinationSettings != null ? !this.embeddedPlusScte20DestinationSettings.equals(that.embeddedPlusScte20DestinationSettings) : that.embeddedPlusScte20DestinationSettings != null) return false;
                if (this.rtmpCaptionInfoDestinationSettings != null ? !this.rtmpCaptionInfoDestinationSettings.equals(that.rtmpCaptionInfoDestinationSettings) : that.rtmpCaptionInfoDestinationSettings != null) return false;
                if (this.scte20PlusEmbeddedDestinationSettings != null ? !this.scte20PlusEmbeddedDestinationSettings.equals(that.scte20PlusEmbeddedDestinationSettings) : that.scte20PlusEmbeddedDestinationSettings != null) return false;
                if (this.scte27DestinationSettings != null ? !this.scte27DestinationSettings.equals(that.scte27DestinationSettings) : that.scte27DestinationSettings != null) return false;
                if (this.smpteTtDestinationSettings != null ? !this.smpteTtDestinationSettings.equals(that.smpteTtDestinationSettings) : that.smpteTtDestinationSettings != null) return false;
                if (this.teletextDestinationSettings != null ? !this.teletextDestinationSettings.equals(that.teletextDestinationSettings) : that.teletextDestinationSettings != null) return false;
                if (this.ttmlDestinationSettings != null ? !this.ttmlDestinationSettings.equals(that.ttmlDestinationSettings) : that.ttmlDestinationSettings != null) return false;
                return this.webvttDestinationSettings != null ? this.webvttDestinationSettings.equals(that.webvttDestinationSettings) : that.webvttDestinationSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aribDestinationSettings != null ? this.aribDestinationSettings.hashCode() : 0;
                result = 31 * result + (this.burnInDestinationSettings != null ? this.burnInDestinationSettings.hashCode() : 0);
                result = 31 * result + (this.dvbSubDestinationSettings != null ? this.dvbSubDestinationSettings.hashCode() : 0);
                result = 31 * result + (this.ebuTtDDestinationSettings != null ? this.ebuTtDDestinationSettings.hashCode() : 0);
                result = 31 * result + (this.embeddedDestinationSettings != null ? this.embeddedDestinationSettings.hashCode() : 0);
                result = 31 * result + (this.embeddedPlusScte20DestinationSettings != null ? this.embeddedPlusScte20DestinationSettings.hashCode() : 0);
                result = 31 * result + (this.rtmpCaptionInfoDestinationSettings != null ? this.rtmpCaptionInfoDestinationSettings.hashCode() : 0);
                result = 31 * result + (this.scte20PlusEmbeddedDestinationSettings != null ? this.scte20PlusEmbeddedDestinationSettings.hashCode() : 0);
                result = 31 * result + (this.scte27DestinationSettings != null ? this.scte27DestinationSettings.hashCode() : 0);
                result = 31 * result + (this.smpteTtDestinationSettings != null ? this.smpteTtDestinationSettings.hashCode() : 0);
                result = 31 * result + (this.teletextDestinationSettings != null ? this.teletextDestinationSettings.hashCode() : 0);
                result = 31 * result + (this.ttmlDestinationSettings != null ? this.ttmlDestinationSettings.hashCode() : 0);
                result = 31 * result + (this.webvttDestinationSettings != null ? this.webvttDestinationSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Maps a captions channel to an ISO 693-2 language code (http://www.loc.gov/standards/iso639-2), with an optional description.
     * <p>
     * The parent of this entity is HlsGroupSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * CaptionLanguageMappingProperty captionLanguageMappingProperty = CaptionLanguageMappingProperty.builder()
     *         .captionChannel(123)
     *         .languageCode("languageCode")
     *         .languageDescription("languageDescription")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionlanguagemapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionlanguagemapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.CaptionLanguageMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(CaptionLanguageMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CaptionLanguageMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The closed caption channel being described by this CaptionLanguageMapping.
         * <p>
         * Each channel mapping must have a unique channel number (maximum of 4).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionlanguagemapping.html#cfn-medialive-channel-captionlanguagemapping-captionchannel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionlanguagemapping.html#cfn-medialive-channel-captionlanguagemapping-captionchannel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCaptionChannel() {
            return null;
        }

        /**
         * A three-character ISO 639-2 language code (see http://www.loc.gov/standards/iso639-2).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionlanguagemapping.html#cfn-medialive-channel-captionlanguagemapping-languagecode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionlanguagemapping.html#cfn-medialive-channel-captionlanguagemapping-languagecode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLanguageCode() {
            return null;
        }

        /**
         * The textual description of language.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionlanguagemapping.html#cfn-medialive-channel-captionlanguagemapping-languagedescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionlanguagemapping.html#cfn-medialive-channel-captionlanguagemapping-languagedescription</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLanguageDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CaptionLanguageMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CaptionLanguageMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CaptionLanguageMappingProperty> {
            java.lang.Number captionChannel;
            java.lang.String languageCode;
            java.lang.String languageDescription;

            /**
             * Sets the value of {@link CaptionLanguageMappingProperty#getCaptionChannel}
             * @param captionChannel The closed caption channel being described by this CaptionLanguageMapping.
             *                       Each channel mapping must have a unique channel number (maximum of 4).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captionChannel(java.lang.Number captionChannel) {
                this.captionChannel = captionChannel;
                return this;
            }

            /**
             * Sets the value of {@link CaptionLanguageMappingProperty#getLanguageCode}
             * @param languageCode A three-character ISO 639-2 language code (see http://www.loc.gov/standards/iso639-2).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder languageCode(java.lang.String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            /**
             * Sets the value of {@link CaptionLanguageMappingProperty#getLanguageDescription}
             * @param languageDescription The textual description of language.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder languageDescription(java.lang.String languageDescription) {
                this.languageDescription = languageDescription;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CaptionLanguageMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CaptionLanguageMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CaptionLanguageMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CaptionLanguageMappingProperty {
            private final java.lang.Number captionChannel;
            private final java.lang.String languageCode;
            private final java.lang.String languageDescription;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.captionChannel = software.amazon.jsii.Kernel.get(this, "captionChannel", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.languageCode = software.amazon.jsii.Kernel.get(this, "languageCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.languageDescription = software.amazon.jsii.Kernel.get(this, "languageDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.captionChannel = builder.captionChannel;
                this.languageCode = builder.languageCode;
                this.languageDescription = builder.languageDescription;
            }

            @Override
            public final java.lang.Number getCaptionChannel() {
                return this.captionChannel;
            }

            @Override
            public final java.lang.String getLanguageCode() {
                return this.languageCode;
            }

            @Override
            public final java.lang.String getLanguageDescription() {
                return this.languageDescription;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCaptionChannel() != null) {
                    data.set("captionChannel", om.valueToTree(this.getCaptionChannel()));
                }
                if (this.getLanguageCode() != null) {
                    data.set("languageCode", om.valueToTree(this.getLanguageCode()));
                }
                if (this.getLanguageDescription() != null) {
                    data.set("languageDescription", om.valueToTree(this.getLanguageDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.CaptionLanguageMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CaptionLanguageMappingProperty.Jsii$Proxy that = (CaptionLanguageMappingProperty.Jsii$Proxy) o;

                if (this.captionChannel != null ? !this.captionChannel.equals(that.captionChannel) : that.captionChannel != null) return false;
                if (this.languageCode != null ? !this.languageCode.equals(that.languageCode) : that.languageCode != null) return false;
                return this.languageDescription != null ? this.languageDescription.equals(that.languageDescription) : that.languageDescription == null;
            }

            @Override
            public final int hashCode() {
                int result = this.captionChannel != null ? this.captionChannel.hashCode() : 0;
                result = 31 * result + (this.languageCode != null ? this.languageCode.hashCode() : 0);
                result = 31 * result + (this.languageDescription != null ? this.languageDescription.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings to configure the caption rectangle for an output captions that will be created using this Teletext source captions.
     * <p>
     * The parent of this entity is TeletextSourceSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * CaptionRectangleProperty captionRectangleProperty = CaptionRectangleProperty.builder()
     *         .height(123)
     *         .leftOffset(123)
     *         .topOffset(123)
     *         .width(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionrectangle.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionrectangle.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.CaptionRectangleProperty")
    @software.amazon.jsii.Jsii.Proxy(CaptionRectangleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CaptionRectangleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * See the description in leftOffset.
         * <p>
         * For height, specify the entire height of the rectangle as a percentage of the underlying frame height. For example, "80" means the rectangle height is 80% of the underlying frame height. The topOffset and rectangleHeight must add up to 100% or less. This field corresponds to tts:extent - Y in the TTML standard.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionrectangle.html#cfn-medialive-channel-captionrectangle-height">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionrectangle.html#cfn-medialive-channel-captionrectangle-height</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHeight() {
            return null;
        }

        /**
         * Applies only if you plan to convert these source captions to EBU-TT-D or TTML in an output.
         * <p>
         * (Make sure to leave the default if you don't have either of these formats in the output.) You can define a display rectangle for the captions that is smaller than the underlying video frame. You define the rectangle by specifying the position of the left edge, top edge, bottom edge, and right edge of the rectangle, all within the underlying video frame. The units for the measurements are percentages. If you specify a value for one of these fields, you must specify a value for all of them.
         * <p>
         * For leftOffset, specify the position of the left edge of the rectangle, as a percentage of the underlying frame width, and relative to the left edge of the frame. For example, "10" means the measurement is 10% of the underlying frame width. The rectangle left edge starts at that position from the left edge of the frame. This field corresponds to tts:origin - X in the TTML standard.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionrectangle.html#cfn-medialive-channel-captionrectangle-leftoffset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionrectangle.html#cfn-medialive-channel-captionrectangle-leftoffset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLeftOffset() {
            return null;
        }

        /**
         * See the description in leftOffset.
         * <p>
         * For topOffset, specify the position of the top edge of the rectangle, as a percentage of the underlying frame height, and relative to the top edge of the frame. For example, "10" means the measurement is 10% of the underlying frame height. The rectangle top edge starts at that position from the top edge of the frame. This field corresponds to tts:origin - Y in the TTML standard.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionrectangle.html#cfn-medialive-channel-captionrectangle-topoffset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionrectangle.html#cfn-medialive-channel-captionrectangle-topoffset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTopOffset() {
            return null;
        }

        /**
         * See the description in leftOffset.
         * <p>
         * For width, specify the entire width of the rectangle as a percentage of the underlying frame width. For example, "80" means the rectangle width is 80% of the underlying frame width. The leftOffset and rectangleWidth must add up to 100% or less. This field corresponds to tts:extent - X in the TTML standard.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionrectangle.html#cfn-medialive-channel-captionrectangle-width">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionrectangle.html#cfn-medialive-channel-captionrectangle-width</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWidth() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CaptionRectangleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CaptionRectangleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CaptionRectangleProperty> {
            java.lang.Number height;
            java.lang.Number leftOffset;
            java.lang.Number topOffset;
            java.lang.Number width;

            /**
             * Sets the value of {@link CaptionRectangleProperty#getHeight}
             * @param height See the description in leftOffset.
             *               For height, specify the entire height of the rectangle as a percentage of the underlying frame height. For example, "80" means the rectangle height is 80% of the underlying frame height. The topOffset and rectangleHeight must add up to 100% or less. This field corresponds to tts:extent - Y in the TTML standard.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder height(java.lang.Number height) {
                this.height = height;
                return this;
            }

            /**
             * Sets the value of {@link CaptionRectangleProperty#getLeftOffset}
             * @param leftOffset Applies only if you plan to convert these source captions to EBU-TT-D or TTML in an output.
             *                   (Make sure to leave the default if you don't have either of these formats in the output.) You can define a display rectangle for the captions that is smaller than the underlying video frame. You define the rectangle by specifying the position of the left edge, top edge, bottom edge, and right edge of the rectangle, all within the underlying video frame. The units for the measurements are percentages. If you specify a value for one of these fields, you must specify a value for all of them.
             *                   <p>
             *                   For leftOffset, specify the position of the left edge of the rectangle, as a percentage of the underlying frame width, and relative to the left edge of the frame. For example, "10" means the measurement is 10% of the underlying frame width. The rectangle left edge starts at that position from the left edge of the frame. This field corresponds to tts:origin - X in the TTML standard.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder leftOffset(java.lang.Number leftOffset) {
                this.leftOffset = leftOffset;
                return this;
            }

            /**
             * Sets the value of {@link CaptionRectangleProperty#getTopOffset}
             * @param topOffset See the description in leftOffset.
             *                  For topOffset, specify the position of the top edge of the rectangle, as a percentage of the underlying frame height, and relative to the top edge of the frame. For example, "10" means the measurement is 10% of the underlying frame height. The rectangle top edge starts at that position from the top edge of the frame. This field corresponds to tts:origin - Y in the TTML standard.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topOffset(java.lang.Number topOffset) {
                this.topOffset = topOffset;
                return this;
            }

            /**
             * Sets the value of {@link CaptionRectangleProperty#getWidth}
             * @param width See the description in leftOffset.
             *              For width, specify the entire width of the rectangle as a percentage of the underlying frame width. For example, "80" means the rectangle width is 80% of the underlying frame width. The leftOffset and rectangleWidth must add up to 100% or less. This field corresponds to tts:extent - X in the TTML standard.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder width(java.lang.Number width) {
                this.width = width;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CaptionRectangleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CaptionRectangleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CaptionRectangleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CaptionRectangleProperty {
            private final java.lang.Number height;
            private final java.lang.Number leftOffset;
            private final java.lang.Number topOffset;
            private final java.lang.Number width;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.height = software.amazon.jsii.Kernel.get(this, "height", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.leftOffset = software.amazon.jsii.Kernel.get(this, "leftOffset", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.topOffset = software.amazon.jsii.Kernel.get(this, "topOffset", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.width = software.amazon.jsii.Kernel.get(this, "width", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.height = builder.height;
                this.leftOffset = builder.leftOffset;
                this.topOffset = builder.topOffset;
                this.width = builder.width;
            }

            @Override
            public final java.lang.Number getHeight() {
                return this.height;
            }

            @Override
            public final java.lang.Number getLeftOffset() {
                return this.leftOffset;
            }

            @Override
            public final java.lang.Number getTopOffset() {
                return this.topOffset;
            }

            @Override
            public final java.lang.Number getWidth() {
                return this.width;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHeight() != null) {
                    data.set("height", om.valueToTree(this.getHeight()));
                }
                if (this.getLeftOffset() != null) {
                    data.set("leftOffset", om.valueToTree(this.getLeftOffset()));
                }
                if (this.getTopOffset() != null) {
                    data.set("topOffset", om.valueToTree(this.getTopOffset()));
                }
                if (this.getWidth() != null) {
                    data.set("width", om.valueToTree(this.getWidth()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.CaptionRectangleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CaptionRectangleProperty.Jsii$Proxy that = (CaptionRectangleProperty.Jsii$Proxy) o;

                if (this.height != null ? !this.height.equals(that.height) : that.height != null) return false;
                if (this.leftOffset != null ? !this.leftOffset.equals(that.leftOffset) : that.leftOffset != null) return false;
                if (this.topOffset != null ? !this.topOffset.equals(that.topOffset) : that.topOffset != null) return false;
                return this.width != null ? this.width.equals(that.width) : that.width == null;
            }

            @Override
            public final int hashCode() {
                int result = this.height != null ? this.height.hashCode() : 0;
                result = 31 * result + (this.leftOffset != null ? this.leftOffset.hashCode() : 0);
                result = 31 * result + (this.topOffset != null ? this.topOffset.hashCode() : 0);
                result = 31 * result + (this.width != null ? this.width.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about one caption to extract from the input.
     * <p>
     * The parent of this entity is InputSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * CaptionSelectorProperty captionSelectorProperty = CaptionSelectorProperty.builder()
     *         .languageCode("languageCode")
     *         .name("name")
     *         .selectorSettings(CaptionSelectorSettingsProperty.builder()
     *                 .ancillarySourceSettings(AncillarySourceSettingsProperty.builder()
     *                         .sourceAncillaryChannelNumber(123)
     *                         .build())
     *                 .aribSourceSettings(AribSourceSettingsProperty.builder().build())
     *                 .dvbSubSourceSettings(DvbSubSourceSettingsProperty.builder()
     *                         .ocrLanguage("ocrLanguage")
     *                         .pid(123)
     *                         .build())
     *                 .embeddedSourceSettings(EmbeddedSourceSettingsProperty.builder()
     *                         .convert608To708("convert608To708")
     *                         .scte20Detection("scte20Detection")
     *                         .source608ChannelNumber(123)
     *                         .source608TrackNumber(123)
     *                         .build())
     *                 .scte20SourceSettings(Scte20SourceSettingsProperty.builder()
     *                         .convert608To708("convert608To708")
     *                         .source608ChannelNumber(123)
     *                         .build())
     *                 .scte27SourceSettings(Scte27SourceSettingsProperty.builder()
     *                         .ocrLanguage("ocrLanguage")
     *                         .pid(123)
     *                         .build())
     *                 .teletextSourceSettings(TeletextSourceSettingsProperty.builder()
     *                         .outputRectangle(CaptionRectangleProperty.builder()
     *                                 .height(123)
     *                                 .leftOffset(123)
     *                                 .topOffset(123)
     *                                 .width(123)
     *                                 .build())
     *                         .pageNumber("pageNumber")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.CaptionSelectorProperty")
    @software.amazon.jsii.Jsii.Proxy(CaptionSelectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CaptionSelectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * When specified, this field indicates the three-letter language code of the captions track to extract from the source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html#cfn-medialive-channel-captionselector-languagecode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html#cfn-medialive-channel-captionselector-languagecode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLanguageCode() {
            return null;
        }

        /**
         * The name identifier for a captions selector.
         * <p>
         * This name is used to associate this captions selector with one or more captions descriptions. Names must be unique within a channel.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html#cfn-medialive-channel-captionselector-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html#cfn-medialive-channel-captionselector-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * Information about the specific audio to extract from the input.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.CaptionSelectorSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html#cfn-medialive-channel-captionselector-selectorsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html#cfn-medialive-channel-captionselector-selectorsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSelectorSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CaptionSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CaptionSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CaptionSelectorProperty> {
            java.lang.String languageCode;
            java.lang.String name;
            java.lang.Object selectorSettings;

            /**
             * Sets the value of {@link CaptionSelectorProperty#getLanguageCode}
             * @param languageCode When specified, this field indicates the three-letter language code of the captions track to extract from the source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder languageCode(java.lang.String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorProperty#getName}
             * @param name The name identifier for a captions selector.
             *             This name is used to associate this captions selector with one or more captions descriptions. Names must be unique within a channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorProperty#getSelectorSettings}
             * @param selectorSettings Information about the specific audio to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectorSettings(software.amazon.awscdk.IResolvable selectorSettings) {
                this.selectorSettings = selectorSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorProperty#getSelectorSettings}
             * @param selectorSettings Information about the specific audio to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectorSettings(software.amazon.awscdk.services.medialive.CfnChannel.CaptionSelectorSettingsProperty selectorSettings) {
                this.selectorSettings = selectorSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CaptionSelectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CaptionSelectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CaptionSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CaptionSelectorProperty {
            private final java.lang.String languageCode;
            private final java.lang.String name;
            private final java.lang.Object selectorSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.languageCode = software.amazon.jsii.Kernel.get(this, "languageCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.selectorSettings = software.amazon.jsii.Kernel.get(this, "selectorSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.languageCode = builder.languageCode;
                this.name = builder.name;
                this.selectorSettings = builder.selectorSettings;
            }

            @Override
            public final java.lang.String getLanguageCode() {
                return this.languageCode;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getSelectorSettings() {
                return this.selectorSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLanguageCode() != null) {
                    data.set("languageCode", om.valueToTree(this.getLanguageCode()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getSelectorSettings() != null) {
                    data.set("selectorSettings", om.valueToTree(this.getSelectorSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.CaptionSelectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CaptionSelectorProperty.Jsii$Proxy that = (CaptionSelectorProperty.Jsii$Proxy) o;

                if (this.languageCode != null ? !this.languageCode.equals(that.languageCode) : that.languageCode != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.selectorSettings != null ? this.selectorSettings.equals(that.selectorSettings) : that.selectorSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.languageCode != null ? this.languageCode.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.selectorSettings != null ? this.selectorSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Captions Selector Settings.
     * <p>
     * The parent of this entity is CaptionSelector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * CaptionSelectorSettingsProperty captionSelectorSettingsProperty = CaptionSelectorSettingsProperty.builder()
     *         .ancillarySourceSettings(AncillarySourceSettingsProperty.builder()
     *                 .sourceAncillaryChannelNumber(123)
     *                 .build())
     *         .aribSourceSettings(AribSourceSettingsProperty.builder().build())
     *         .dvbSubSourceSettings(DvbSubSourceSettingsProperty.builder()
     *                 .ocrLanguage("ocrLanguage")
     *                 .pid(123)
     *                 .build())
     *         .embeddedSourceSettings(EmbeddedSourceSettingsProperty.builder()
     *                 .convert608To708("convert608To708")
     *                 .scte20Detection("scte20Detection")
     *                 .source608ChannelNumber(123)
     *                 .source608TrackNumber(123)
     *                 .build())
     *         .scte20SourceSettings(Scte20SourceSettingsProperty.builder()
     *                 .convert608To708("convert608To708")
     *                 .source608ChannelNumber(123)
     *                 .build())
     *         .scte27SourceSettings(Scte27SourceSettingsProperty.builder()
     *                 .ocrLanguage("ocrLanguage")
     *                 .pid(123)
     *                 .build())
     *         .teletextSourceSettings(TeletextSourceSettingsProperty.builder()
     *                 .outputRectangle(CaptionRectangleProperty.builder()
     *                         .height(123)
     *                         .leftOffset(123)
     *                         .topOffset(123)
     *                         .width(123)
     *                         .build())
     *                 .pageNumber("pageNumber")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.CaptionSelectorSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(CaptionSelectorSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CaptionSelectorSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about the ancillary captions to extract from the input.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.AncillarySourceSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-ancillarysourcesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-ancillarysourcesettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAncillarySourceSettings() {
            return null;
        }

        /**
         * Information about the ARIB captions to extract from the input.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.AribSourceSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-aribsourcesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-aribsourcesettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAribSourceSettings() {
            return null;
        }

        /**
         * Information about the DVB Sub captions to extract from the input.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.DvbSubSourceSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-dvbsubsourcesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-dvbsubsourcesettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDvbSubSourceSettings() {
            return null;
        }

        /**
         * Information about the embedded captions to extract from the input.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.EmbeddedSourceSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-embeddedsourcesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-embeddedsourcesettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmbeddedSourceSettings() {
            return null;
        }

        /**
         * Information about the SCTE-20 captions to extract from the input.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.Scte20SourceSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-scte20sourcesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-scte20sourcesettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScte20SourceSettings() {
            return null;
        }

        /**
         * Information about the SCTE-27 captions to extract from the input.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.Scte27SourceSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-scte27sourcesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-scte27sourcesettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScte27SourceSettings() {
            return null;
        }

        /**
         * Information about the Teletext captions to extract from the input.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.TeletextSourceSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-teletextsourcesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-teletextsourcesettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTeletextSourceSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CaptionSelectorSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CaptionSelectorSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CaptionSelectorSettingsProperty> {
            java.lang.Object ancillarySourceSettings;
            java.lang.Object aribSourceSettings;
            java.lang.Object dvbSubSourceSettings;
            java.lang.Object embeddedSourceSettings;
            java.lang.Object scte20SourceSettings;
            java.lang.Object scte27SourceSettings;
            java.lang.Object teletextSourceSettings;

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getAncillarySourceSettings}
             * @param ancillarySourceSettings Information about the ancillary captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ancillarySourceSettings(software.amazon.awscdk.IResolvable ancillarySourceSettings) {
                this.ancillarySourceSettings = ancillarySourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getAncillarySourceSettings}
             * @param ancillarySourceSettings Information about the ancillary captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ancillarySourceSettings(software.amazon.awscdk.services.medialive.CfnChannel.AncillarySourceSettingsProperty ancillarySourceSettings) {
                this.ancillarySourceSettings = ancillarySourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getAribSourceSettings}
             * @param aribSourceSettings Information about the ARIB captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aribSourceSettings(software.amazon.awscdk.IResolvable aribSourceSettings) {
                this.aribSourceSettings = aribSourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getAribSourceSettings}
             * @param aribSourceSettings Information about the ARIB captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aribSourceSettings(software.amazon.awscdk.services.medialive.CfnChannel.AribSourceSettingsProperty aribSourceSettings) {
                this.aribSourceSettings = aribSourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getDvbSubSourceSettings}
             * @param dvbSubSourceSettings Information about the DVB Sub captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dvbSubSourceSettings(software.amazon.awscdk.IResolvable dvbSubSourceSettings) {
                this.dvbSubSourceSettings = dvbSubSourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getDvbSubSourceSettings}
             * @param dvbSubSourceSettings Information about the DVB Sub captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dvbSubSourceSettings(software.amazon.awscdk.services.medialive.CfnChannel.DvbSubSourceSettingsProperty dvbSubSourceSettings) {
                this.dvbSubSourceSettings = dvbSubSourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getEmbeddedSourceSettings}
             * @param embeddedSourceSettings Information about the embedded captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder embeddedSourceSettings(software.amazon.awscdk.IResolvable embeddedSourceSettings) {
                this.embeddedSourceSettings = embeddedSourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getEmbeddedSourceSettings}
             * @param embeddedSourceSettings Information about the embedded captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder embeddedSourceSettings(software.amazon.awscdk.services.medialive.CfnChannel.EmbeddedSourceSettingsProperty embeddedSourceSettings) {
                this.embeddedSourceSettings = embeddedSourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getScte20SourceSettings}
             * @param scte20SourceSettings Information about the SCTE-20 captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte20SourceSettings(software.amazon.awscdk.IResolvable scte20SourceSettings) {
                this.scte20SourceSettings = scte20SourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getScte20SourceSettings}
             * @param scte20SourceSettings Information about the SCTE-20 captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte20SourceSettings(software.amazon.awscdk.services.medialive.CfnChannel.Scte20SourceSettingsProperty scte20SourceSettings) {
                this.scte20SourceSettings = scte20SourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getScte27SourceSettings}
             * @param scte27SourceSettings Information about the SCTE-27 captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte27SourceSettings(software.amazon.awscdk.IResolvable scte27SourceSettings) {
                this.scte27SourceSettings = scte27SourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getScte27SourceSettings}
             * @param scte27SourceSettings Information about the SCTE-27 captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte27SourceSettings(software.amazon.awscdk.services.medialive.CfnChannel.Scte27SourceSettingsProperty scte27SourceSettings) {
                this.scte27SourceSettings = scte27SourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getTeletextSourceSettings}
             * @param teletextSourceSettings Information about the Teletext captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder teletextSourceSettings(software.amazon.awscdk.IResolvable teletextSourceSettings) {
                this.teletextSourceSettings = teletextSourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getTeletextSourceSettings}
             * @param teletextSourceSettings Information about the Teletext captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder teletextSourceSettings(software.amazon.awscdk.services.medialive.CfnChannel.TeletextSourceSettingsProperty teletextSourceSettings) {
                this.teletextSourceSettings = teletextSourceSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CaptionSelectorSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CaptionSelectorSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CaptionSelectorSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CaptionSelectorSettingsProperty {
            private final java.lang.Object ancillarySourceSettings;
            private final java.lang.Object aribSourceSettings;
            private final java.lang.Object dvbSubSourceSettings;
            private final java.lang.Object embeddedSourceSettings;
            private final java.lang.Object scte20SourceSettings;
            private final java.lang.Object scte27SourceSettings;
            private final java.lang.Object teletextSourceSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ancillarySourceSettings = software.amazon.jsii.Kernel.get(this, "ancillarySourceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.aribSourceSettings = software.amazon.jsii.Kernel.get(this, "aribSourceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dvbSubSourceSettings = software.amazon.jsii.Kernel.get(this, "dvbSubSourceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.embeddedSourceSettings = software.amazon.jsii.Kernel.get(this, "embeddedSourceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scte20SourceSettings = software.amazon.jsii.Kernel.get(this, "scte20SourceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scte27SourceSettings = software.amazon.jsii.Kernel.get(this, "scte27SourceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.teletextSourceSettings = software.amazon.jsii.Kernel.get(this, "teletextSourceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ancillarySourceSettings = builder.ancillarySourceSettings;
                this.aribSourceSettings = builder.aribSourceSettings;
                this.dvbSubSourceSettings = builder.dvbSubSourceSettings;
                this.embeddedSourceSettings = builder.embeddedSourceSettings;
                this.scte20SourceSettings = builder.scte20SourceSettings;
                this.scte27SourceSettings = builder.scte27SourceSettings;
                this.teletextSourceSettings = builder.teletextSourceSettings;
            }

            @Override
            public final java.lang.Object getAncillarySourceSettings() {
                return this.ancillarySourceSettings;
            }

            @Override
            public final java.lang.Object getAribSourceSettings() {
                return this.aribSourceSettings;
            }

            @Override
            public final java.lang.Object getDvbSubSourceSettings() {
                return this.dvbSubSourceSettings;
            }

            @Override
            public final java.lang.Object getEmbeddedSourceSettings() {
                return this.embeddedSourceSettings;
            }

            @Override
            public final java.lang.Object getScte20SourceSettings() {
                return this.scte20SourceSettings;
            }

            @Override
            public final java.lang.Object getScte27SourceSettings() {
                return this.scte27SourceSettings;
            }

            @Override
            public final java.lang.Object getTeletextSourceSettings() {
                return this.teletextSourceSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAncillarySourceSettings() != null) {
                    data.set("ancillarySourceSettings", om.valueToTree(this.getAncillarySourceSettings()));
                }
                if (this.getAribSourceSettings() != null) {
                    data.set("aribSourceSettings", om.valueToTree(this.getAribSourceSettings()));
                }
                if (this.getDvbSubSourceSettings() != null) {
                    data.set("dvbSubSourceSettings", om.valueToTree(this.getDvbSubSourceSettings()));
                }
                if (this.getEmbeddedSourceSettings() != null) {
                    data.set("embeddedSourceSettings", om.valueToTree(this.getEmbeddedSourceSettings()));
                }
                if (this.getScte20SourceSettings() != null) {
                    data.set("scte20SourceSettings", om.valueToTree(this.getScte20SourceSettings()));
                }
                if (this.getScte27SourceSettings() != null) {
                    data.set("scte27SourceSettings", om.valueToTree(this.getScte27SourceSettings()));
                }
                if (this.getTeletextSourceSettings() != null) {
                    data.set("teletextSourceSettings", om.valueToTree(this.getTeletextSourceSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.CaptionSelectorSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CaptionSelectorSettingsProperty.Jsii$Proxy that = (CaptionSelectorSettingsProperty.Jsii$Proxy) o;

                if (this.ancillarySourceSettings != null ? !this.ancillarySourceSettings.equals(that.ancillarySourceSettings) : that.ancillarySourceSettings != null) return false;
                if (this.aribSourceSettings != null ? !this.aribSourceSettings.equals(that.aribSourceSettings) : that.aribSourceSettings != null) return false;
                if (this.dvbSubSourceSettings != null ? !this.dvbSubSourceSettings.equals(that.dvbSubSourceSettings) : that.dvbSubSourceSettings != null) return false;
                if (this.embeddedSourceSettings != null ? !this.embeddedSourceSettings.equals(that.embeddedSourceSettings) : that.embeddedSourceSettings != null) return false;
                if (this.scte20SourceSettings != null ? !this.scte20SourceSettings.equals(that.scte20SourceSettings) : that.scte20SourceSettings != null) return false;
                if (this.scte27SourceSettings != null ? !this.scte27SourceSettings.equals(that.scte27SourceSettings) : that.scte27SourceSettings != null) return false;
                return this.teletextSourceSettings != null ? this.teletextSourceSettings.equals(that.teletextSourceSettings) : that.teletextSourceSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ancillarySourceSettings != null ? this.ancillarySourceSettings.hashCode() : 0;
                result = 31 * result + (this.aribSourceSettings != null ? this.aribSourceSettings.hashCode() : 0);
                result = 31 * result + (this.dvbSubSourceSettings != null ? this.dvbSubSourceSettings.hashCode() : 0);
                result = 31 * result + (this.embeddedSourceSettings != null ? this.embeddedSourceSettings.hashCode() : 0);
                result = 31 * result + (this.scte20SourceSettings != null ? this.scte20SourceSettings.hashCode() : 0);
                result = 31 * result + (this.scte27SourceSettings != null ? this.scte27SourceSettings.hashCode() : 0);
                result = 31 * result + (this.teletextSourceSettings != null ? this.teletextSourceSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The input specification for this channel.
     * <p>
     * It specifies the key characteristics of CDI inputs for this channel, when those characteristics are different from other inputs.
     * <p>
     * This entity is at the top level in the channel.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * CdiInputSpecificationProperty cdiInputSpecificationProperty = CdiInputSpecificationProperty.builder()
     *         .resolution("resolution")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cdiinputspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cdiinputspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.CdiInputSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(CdiInputSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CdiInputSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Maximum CDI input resolution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cdiinputspecification.html#cfn-medialive-channel-cdiinputspecification-resolution">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cdiinputspecification.html#cfn-medialive-channel-cdiinputspecification-resolution</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResolution() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CdiInputSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CdiInputSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CdiInputSpecificationProperty> {
            java.lang.String resolution;

            /**
             * Sets the value of {@link CdiInputSpecificationProperty#getResolution}
             * @param resolution Maximum CDI input resolution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resolution(java.lang.String resolution) {
                this.resolution = resolution;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CdiInputSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CdiInputSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CdiInputSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CdiInputSpecificationProperty {
            private final java.lang.String resolution;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resolution = software.amazon.jsii.Kernel.get(this, "resolution", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resolution = builder.resolution;
            }

            @Override
            public final java.lang.String getResolution() {
                return this.resolution;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getResolution() != null) {
                    data.set("resolution", om.valueToTree(this.getResolution()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.CdiInputSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CdiInputSpecificationProperty.Jsii$Proxy that = (CdiInputSpecificationProperty.Jsii$Proxy) o;

                return this.resolution != null ? this.resolution.equals(that.resolution) : that.resolution == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resolution != null ? this.resolution.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * ChannelEngineVersionRequestProperty channelEngineVersionRequestProperty = ChannelEngineVersionRequestProperty.builder()
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-channelengineversionrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-channelengineversionrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.ChannelEngineVersionRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(ChannelEngineVersionRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ChannelEngineVersionRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-channelengineversionrequest.html#cfn-medialive-channel-channelengineversionrequest-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-channelengineversionrequest.html#cfn-medialive-channel-channelengineversionrequest-version</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ChannelEngineVersionRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ChannelEngineVersionRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ChannelEngineVersionRequestProperty> {
            java.lang.String version;

            /**
             * Sets the value of {@link ChannelEngineVersionRequestProperty#getVersion}
             * @param version the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ChannelEngineVersionRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ChannelEngineVersionRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ChannelEngineVersionRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ChannelEngineVersionRequestProperty {
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.ChannelEngineVersionRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ChannelEngineVersionRequestProperty.Jsii$Proxy that = (ChannelEngineVersionRequestProperty.Jsii$Proxy) o;

                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.version != null ? this.version.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * CmafIngestCaptionLanguageMappingProperty cmafIngestCaptionLanguageMappingProperty = CmafIngestCaptionLanguageMappingProperty.builder()
     *         .captionChannel(123)
     *         .languageCode("languageCode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestcaptionlanguagemapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestcaptionlanguagemapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.CmafIngestCaptionLanguageMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(CmafIngestCaptionLanguageMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CmafIngestCaptionLanguageMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestcaptionlanguagemapping.html#cfn-medialive-channel-cmafingestcaptionlanguagemapping-captionchannel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestcaptionlanguagemapping.html#cfn-medialive-channel-cmafingestcaptionlanguagemapping-captionchannel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCaptionChannel() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestcaptionlanguagemapping.html#cfn-medialive-channel-cmafingestcaptionlanguagemapping-languagecode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestcaptionlanguagemapping.html#cfn-medialive-channel-cmafingestcaptionlanguagemapping-languagecode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLanguageCode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CmafIngestCaptionLanguageMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CmafIngestCaptionLanguageMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CmafIngestCaptionLanguageMappingProperty> {
            java.lang.Number captionChannel;
            java.lang.String languageCode;

            /**
             * Sets the value of {@link CmafIngestCaptionLanguageMappingProperty#getCaptionChannel}
             * @param captionChannel the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captionChannel(java.lang.Number captionChannel) {
                this.captionChannel = captionChannel;
                return this;
            }

            /**
             * Sets the value of {@link CmafIngestCaptionLanguageMappingProperty#getLanguageCode}
             * @param languageCode the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder languageCode(java.lang.String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CmafIngestCaptionLanguageMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CmafIngestCaptionLanguageMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CmafIngestCaptionLanguageMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CmafIngestCaptionLanguageMappingProperty {
            private final java.lang.Number captionChannel;
            private final java.lang.String languageCode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.captionChannel = software.amazon.jsii.Kernel.get(this, "captionChannel", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.languageCode = software.amazon.jsii.Kernel.get(this, "languageCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.captionChannel = builder.captionChannel;
                this.languageCode = builder.languageCode;
            }

            @Override
            public final java.lang.Number getCaptionChannel() {
                return this.captionChannel;
            }

            @Override
            public final java.lang.String getLanguageCode() {
                return this.languageCode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCaptionChannel() != null) {
                    data.set("captionChannel", om.valueToTree(this.getCaptionChannel()));
                }
                if (this.getLanguageCode() != null) {
                    data.set("languageCode", om.valueToTree(this.getLanguageCode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.CmafIngestCaptionLanguageMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CmafIngestCaptionLanguageMappingProperty.Jsii$Proxy that = (CmafIngestCaptionLanguageMappingProperty.Jsii$Proxy) o;

                if (this.captionChannel != null ? !this.captionChannel.equals(that.captionChannel) : that.captionChannel != null) return false;
                return this.languageCode != null ? this.languageCode.equals(that.languageCode) : that.languageCode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.captionChannel != null ? this.captionChannel.hashCode() : 0;
                result = 31 * result + (this.languageCode != null ? this.languageCode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * CmafIngestGroupSettingsProperty cmafIngestGroupSettingsProperty = CmafIngestGroupSettingsProperty.builder()
     *         .additionalDestinations(List.of(AdditionalDestinationsProperty.builder()
     *                 .destination(OutputLocationRefProperty.builder()
     *                         .destinationRefId("destinationRefId")
     *                         .build())
     *                 .build()))
     *         .captionLanguageMappings(List.of(CmafIngestCaptionLanguageMappingProperty.builder()
     *                 .captionChannel(123)
     *                 .languageCode("languageCode")
     *                 .build()))
     *         .destination(OutputLocationRefProperty.builder()
     *                 .destinationRefId("destinationRefId")
     *                 .build())
     *         .id3Behavior("id3Behavior")
     *         .id3NameModifier("id3NameModifier")
     *         .klvBehavior("klvBehavior")
     *         .klvNameModifier("klvNameModifier")
     *         .nielsenId3Behavior("nielsenId3Behavior")
     *         .nielsenId3NameModifier("nielsenId3NameModifier")
     *         .scte35NameModifier("scte35NameModifier")
     *         .scte35Type("scte35Type")
     *         .segmentLength(123)
     *         .segmentLengthUnits("segmentLengthUnits")
     *         .sendDelayMs(123)
     *         .timedMetadataId3Frame("timedMetadataId3Frame")
     *         .timedMetadataId3Period(123)
     *         .timedMetadataPassthrough("timedMetadataPassthrough")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.CmafIngestGroupSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(CmafIngestGroupSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CmafIngestGroupSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.AdditionalDestinationsProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-additionaldestinations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-additionaldestinations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalDestinations() {
            return null;
        }

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.CmafIngestCaptionLanguageMappingProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-captionlanguagemappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-captionlanguagemappings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCaptionLanguageMappings() {
            return null;
        }

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.OutputLocationRefProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-destination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestination() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-id3behavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-id3behavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getId3Behavior() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-id3namemodifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-id3namemodifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getId3NameModifier() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-klvbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-klvbehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKlvBehavior() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-klvnamemodifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-klvnamemodifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKlvNameModifier() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-nielsenid3behavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-nielsenid3behavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNielsenId3Behavior() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-nielsenid3namemodifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-nielsenid3namemodifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNielsenId3NameModifier() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-scte35namemodifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-scte35namemodifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScte35NameModifier() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-scte35type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-scte35type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScte35Type() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-segmentlength">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-segmentlength</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSegmentLength() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-segmentlengthunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-segmentlengthunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSegmentLengthUnits() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-senddelayms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-senddelayms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSendDelayMs() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-timedmetadataid3frame">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-timedmetadataid3frame</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimedMetadataId3Frame() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-timedmetadataid3period">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-timedmetadataid3period</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimedMetadataId3Period() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-timedmetadatapassthrough">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestgroupsettings.html#cfn-medialive-channel-cmafingestgroupsettings-timedmetadatapassthrough</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimedMetadataPassthrough() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CmafIngestGroupSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CmafIngestGroupSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CmafIngestGroupSettingsProperty> {
            java.lang.Object additionalDestinations;
            java.lang.Object captionLanguageMappings;
            java.lang.Object destination;
            java.lang.String id3Behavior;
            java.lang.String id3NameModifier;
            java.lang.String klvBehavior;
            java.lang.String klvNameModifier;
            java.lang.String nielsenId3Behavior;
            java.lang.String nielsenId3NameModifier;
            java.lang.String scte35NameModifier;
            java.lang.String scte35Type;
            java.lang.Number segmentLength;
            java.lang.String segmentLengthUnits;
            java.lang.Number sendDelayMs;
            java.lang.String timedMetadataId3Frame;
            java.lang.Number timedMetadataId3Period;
            java.lang.String timedMetadataPassthrough;

            /**
             * Sets the value of {@link CmafIngestGroupSettingsProperty#getAdditionalDestinations}
             * @param additionalDestinations the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalDestinations(software.amazon.awscdk.IResolvable additionalDestinations) {
                this.additionalDestinations = additionalDestinations;
                return this;
            }

            /**
             * Sets the value of {@link CmafIngestGroupSettingsProperty#getAdditionalDestinations}
             * @param additionalDestinations the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalDestinations(java.util.List<? extends java.lang.Object> additionalDestinations) {
                this.additionalDestinations = additionalDestinations;
                return this;
            }

            /**
             * Sets the value of {@link CmafIngestGroupSettingsProperty#getCaptionLanguageMappings}
             * @param captionLanguageMappings the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captionLanguageMappings(software.amazon.awscdk.IResolvable captionLanguageMappings) {
                this.captionLanguageMappings = captionLanguageMappings;
                return this;
            }

            /**
             * Sets the value of {@link CmafIngestGroupSettingsProperty#getCaptionLanguageMappings}
             * @param captionLanguageMappings the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captionLanguageMappings(java.util.List<? extends java.lang.Object> captionLanguageMappings) {
                this.captionLanguageMappings = captionLanguageMappings;
                return this;
            }

            /**
             * Sets the value of {@link CmafIngestGroupSettingsProperty#getDestination}
             * @param destination the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link CmafIngestGroupSettingsProperty#getDestination}
             * @param destination the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.services.medialive.CfnChannel.OutputLocationRefProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link CmafIngestGroupSettingsProperty#getId3Behavior}
             * @param id3Behavior the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id3Behavior(java.lang.String id3Behavior) {
                this.id3Behavior = id3Behavior;
                return this;
            }

            /**
             * Sets the value of {@link CmafIngestGroupSettingsProperty#getId3NameModifier}
             * @param id3NameModifier the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id3NameModifier(java.lang.String id3NameModifier) {
                this.id3NameModifier = id3NameModifier;
                return this;
            }

            /**
             * Sets the value of {@link CmafIngestGroupSettingsProperty#getKlvBehavior}
             * @param klvBehavior the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder klvBehavior(java.lang.String klvBehavior) {
                this.klvBehavior = klvBehavior;
                return this;
            }

            /**
             * Sets the value of {@link CmafIngestGroupSettingsProperty#getKlvNameModifier}
             * @param klvNameModifier the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder klvNameModifier(java.lang.String klvNameModifier) {
                this.klvNameModifier = klvNameModifier;
                return this;
            }

            /**
             * Sets the value of {@link CmafIngestGroupSettingsProperty#getNielsenId3Behavior}
             * @param nielsenId3Behavior the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nielsenId3Behavior(java.lang.String nielsenId3Behavior) {
                this.nielsenId3Behavior = nielsenId3Behavior;
                return this;
            }

            /**
             * Sets the value of {@link CmafIngestGroupSettingsProperty#getNielsenId3NameModifier}
             * @param nielsenId3NameModifier the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nielsenId3NameModifier(java.lang.String nielsenId3NameModifier) {
                this.nielsenId3NameModifier = nielsenId3NameModifier;
                return this;
            }

            /**
             * Sets the value of {@link CmafIngestGroupSettingsProperty#getScte35NameModifier}
             * @param scte35NameModifier the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte35NameModifier(java.lang.String scte35NameModifier) {
                this.scte35NameModifier = scte35NameModifier;
                return this;
            }

            /**
             * Sets the value of {@link CmafIngestGroupSettingsProperty#getScte35Type}
             * @param scte35Type the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte35Type(java.lang.String scte35Type) {
                this.scte35Type = scte35Type;
                return this;
            }

            /**
             * Sets the value of {@link CmafIngestGroupSettingsProperty#getSegmentLength}
             * @param segmentLength the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segmentLength(java.lang.Number segmentLength) {
                this.segmentLength = segmentLength;
                return this;
            }

            /**
             * Sets the value of {@link CmafIngestGroupSettingsProperty#getSegmentLengthUnits}
             * @param segmentLengthUnits the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segmentLengthUnits(java.lang.String segmentLengthUnits) {
                this.segmentLengthUnits = segmentLengthUnits;
                return this;
            }

            /**
             * Sets the value of {@link CmafIngestGroupSettingsProperty#getSendDelayMs}
             * @param sendDelayMs the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sendDelayMs(java.lang.Number sendDelayMs) {
                this.sendDelayMs = sendDelayMs;
                return this;
            }

            /**
             * Sets the value of {@link CmafIngestGroupSettingsProperty#getTimedMetadataId3Frame}
             * @param timedMetadataId3Frame the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timedMetadataId3Frame(java.lang.String timedMetadataId3Frame) {
                this.timedMetadataId3Frame = timedMetadataId3Frame;
                return this;
            }

            /**
             * Sets the value of {@link CmafIngestGroupSettingsProperty#getTimedMetadataId3Period}
             * @param timedMetadataId3Period the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timedMetadataId3Period(java.lang.Number timedMetadataId3Period) {
                this.timedMetadataId3Period = timedMetadataId3Period;
                return this;
            }

            /**
             * Sets the value of {@link CmafIngestGroupSettingsProperty#getTimedMetadataPassthrough}
             * @param timedMetadataPassthrough the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timedMetadataPassthrough(java.lang.String timedMetadataPassthrough) {
                this.timedMetadataPassthrough = timedMetadataPassthrough;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CmafIngestGroupSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CmafIngestGroupSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CmafIngestGroupSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CmafIngestGroupSettingsProperty {
            private final java.lang.Object additionalDestinations;
            private final java.lang.Object captionLanguageMappings;
            private final java.lang.Object destination;
            private final java.lang.String id3Behavior;
            private final java.lang.String id3NameModifier;
            private final java.lang.String klvBehavior;
            private final java.lang.String klvNameModifier;
            private final java.lang.String nielsenId3Behavior;
            private final java.lang.String nielsenId3NameModifier;
            private final java.lang.String scte35NameModifier;
            private final java.lang.String scte35Type;
            private final java.lang.Number segmentLength;
            private final java.lang.String segmentLengthUnits;
            private final java.lang.Number sendDelayMs;
            private final java.lang.String timedMetadataId3Frame;
            private final java.lang.Number timedMetadataId3Period;
            private final java.lang.String timedMetadataPassthrough;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.additionalDestinations = software.amazon.jsii.Kernel.get(this, "additionalDestinations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.captionLanguageMappings = software.amazon.jsii.Kernel.get(this, "captionLanguageMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.id3Behavior = software.amazon.jsii.Kernel.get(this, "id3Behavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.id3NameModifier = software.amazon.jsii.Kernel.get(this, "id3NameModifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.klvBehavior = software.amazon.jsii.Kernel.get(this, "klvBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.klvNameModifier = software.amazon.jsii.Kernel.get(this, "klvNameModifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nielsenId3Behavior = software.amazon.jsii.Kernel.get(this, "nielsenId3Behavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nielsenId3NameModifier = software.amazon.jsii.Kernel.get(this, "nielsenId3NameModifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scte35NameModifier = software.amazon.jsii.Kernel.get(this, "scte35NameModifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scte35Type = software.amazon.jsii.Kernel.get(this, "scte35Type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.segmentLength = software.amazon.jsii.Kernel.get(this, "segmentLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.segmentLengthUnits = software.amazon.jsii.Kernel.get(this, "segmentLengthUnits", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sendDelayMs = software.amazon.jsii.Kernel.get(this, "sendDelayMs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.timedMetadataId3Frame = software.amazon.jsii.Kernel.get(this, "timedMetadataId3Frame", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timedMetadataId3Period = software.amazon.jsii.Kernel.get(this, "timedMetadataId3Period", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.timedMetadataPassthrough = software.amazon.jsii.Kernel.get(this, "timedMetadataPassthrough", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.additionalDestinations = builder.additionalDestinations;
                this.captionLanguageMappings = builder.captionLanguageMappings;
                this.destination = builder.destination;
                this.id3Behavior = builder.id3Behavior;
                this.id3NameModifier = builder.id3NameModifier;
                this.klvBehavior = builder.klvBehavior;
                this.klvNameModifier = builder.klvNameModifier;
                this.nielsenId3Behavior = builder.nielsenId3Behavior;
                this.nielsenId3NameModifier = builder.nielsenId3NameModifier;
                this.scte35NameModifier = builder.scte35NameModifier;
                this.scte35Type = builder.scte35Type;
                this.segmentLength = builder.segmentLength;
                this.segmentLengthUnits = builder.segmentLengthUnits;
                this.sendDelayMs = builder.sendDelayMs;
                this.timedMetadataId3Frame = builder.timedMetadataId3Frame;
                this.timedMetadataId3Period = builder.timedMetadataId3Period;
                this.timedMetadataPassthrough = builder.timedMetadataPassthrough;
            }

            @Override
            public final java.lang.Object getAdditionalDestinations() {
                return this.additionalDestinations;
            }

            @Override
            public final java.lang.Object getCaptionLanguageMappings() {
                return this.captionLanguageMappings;
            }

            @Override
            public final java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.String getId3Behavior() {
                return this.id3Behavior;
            }

            @Override
            public final java.lang.String getId3NameModifier() {
                return this.id3NameModifier;
            }

            @Override
            public final java.lang.String getKlvBehavior() {
                return this.klvBehavior;
            }

            @Override
            public final java.lang.String getKlvNameModifier() {
                return this.klvNameModifier;
            }

            @Override
            public final java.lang.String getNielsenId3Behavior() {
                return this.nielsenId3Behavior;
            }

            @Override
            public final java.lang.String getNielsenId3NameModifier() {
                return this.nielsenId3NameModifier;
            }

            @Override
            public final java.lang.String getScte35NameModifier() {
                return this.scte35NameModifier;
            }

            @Override
            public final java.lang.String getScte35Type() {
                return this.scte35Type;
            }

            @Override
            public final java.lang.Number getSegmentLength() {
                return this.segmentLength;
            }

            @Override
            public final java.lang.String getSegmentLengthUnits() {
                return this.segmentLengthUnits;
            }

            @Override
            public final java.lang.Number getSendDelayMs() {
                return this.sendDelayMs;
            }

            @Override
            public final java.lang.String getTimedMetadataId3Frame() {
                return this.timedMetadataId3Frame;
            }

            @Override
            public final java.lang.Number getTimedMetadataId3Period() {
                return this.timedMetadataId3Period;
            }

            @Override
            public final java.lang.String getTimedMetadataPassthrough() {
                return this.timedMetadataPassthrough;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdditionalDestinations() != null) {
                    data.set("additionalDestinations", om.valueToTree(this.getAdditionalDestinations()));
                }
                if (this.getCaptionLanguageMappings() != null) {
                    data.set("captionLanguageMappings", om.valueToTree(this.getCaptionLanguageMappings()));
                }
                if (this.getDestination() != null) {
                    data.set("destination", om.valueToTree(this.getDestination()));
                }
                if (this.getId3Behavior() != null) {
                    data.set("id3Behavior", om.valueToTree(this.getId3Behavior()));
                }
                if (this.getId3NameModifier() != null) {
                    data.set("id3NameModifier", om.valueToTree(this.getId3NameModifier()));
                }
                if (this.getKlvBehavior() != null) {
                    data.set("klvBehavior", om.valueToTree(this.getKlvBehavior()));
                }
                if (this.getKlvNameModifier() != null) {
                    data.set("klvNameModifier", om.valueToTree(this.getKlvNameModifier()));
                }
                if (this.getNielsenId3Behavior() != null) {
                    data.set("nielsenId3Behavior", om.valueToTree(this.getNielsenId3Behavior()));
                }
                if (this.getNielsenId3NameModifier() != null) {
                    data.set("nielsenId3NameModifier", om.valueToTree(this.getNielsenId3NameModifier()));
                }
                if (this.getScte35NameModifier() != null) {
                    data.set("scte35NameModifier", om.valueToTree(this.getScte35NameModifier()));
                }
                if (this.getScte35Type() != null) {
                    data.set("scte35Type", om.valueToTree(this.getScte35Type()));
                }
                if (this.getSegmentLength() != null) {
                    data.set("segmentLength", om.valueToTree(this.getSegmentLength()));
                }
                if (this.getSegmentLengthUnits() != null) {
                    data.set("segmentLengthUnits", om.valueToTree(this.getSegmentLengthUnits()));
                }
                if (this.getSendDelayMs() != null) {
                    data.set("sendDelayMs", om.valueToTree(this.getSendDelayMs()));
                }
                if (this.getTimedMetadataId3Frame() != null) {
                    data.set("timedMetadataId3Frame", om.valueToTree(this.getTimedMetadataId3Frame()));
                }
                if (this.getTimedMetadataId3Period() != null) {
                    data.set("timedMetadataId3Period", om.valueToTree(this.getTimedMetadataId3Period()));
                }
                if (this.getTimedMetadataPassthrough() != null) {
                    data.set("timedMetadataPassthrough", om.valueToTree(this.getTimedMetadataPassthrough()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.CmafIngestGroupSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CmafIngestGroupSettingsProperty.Jsii$Proxy that = (CmafIngestGroupSettingsProperty.Jsii$Proxy) o;

                if (this.additionalDestinations != null ? !this.additionalDestinations.equals(that.additionalDestinations) : that.additionalDestinations != null) return false;
                if (this.captionLanguageMappings != null ? !this.captionLanguageMappings.equals(that.captionLanguageMappings) : that.captionLanguageMappings != null) return false;
                if (this.destination != null ? !this.destination.equals(that.destination) : that.destination != null) return false;
                if (this.id3Behavior != null ? !this.id3Behavior.equals(that.id3Behavior) : that.id3Behavior != null) return false;
                if (this.id3NameModifier != null ? !this.id3NameModifier.equals(that.id3NameModifier) : that.id3NameModifier != null) return false;
                if (this.klvBehavior != null ? !this.klvBehavior.equals(that.klvBehavior) : that.klvBehavior != null) return false;
                if (this.klvNameModifier != null ? !this.klvNameModifier.equals(that.klvNameModifier) : that.klvNameModifier != null) return false;
                if (this.nielsenId3Behavior != null ? !this.nielsenId3Behavior.equals(that.nielsenId3Behavior) : that.nielsenId3Behavior != null) return false;
                if (this.nielsenId3NameModifier != null ? !this.nielsenId3NameModifier.equals(that.nielsenId3NameModifier) : that.nielsenId3NameModifier != null) return false;
                if (this.scte35NameModifier != null ? !this.scte35NameModifier.equals(that.scte35NameModifier) : that.scte35NameModifier != null) return false;
                if (this.scte35Type != null ? !this.scte35Type.equals(that.scte35Type) : that.scte35Type != null) return false;
                if (this.segmentLength != null ? !this.segmentLength.equals(that.segmentLength) : that.segmentLength != null) return false;
                if (this.segmentLengthUnits != null ? !this.segmentLengthUnits.equals(that.segmentLengthUnits) : that.segmentLengthUnits != null) return false;
                if (this.sendDelayMs != null ? !this.sendDelayMs.equals(that.sendDelayMs) : that.sendDelayMs != null) return false;
                if (this.timedMetadataId3Frame != null ? !this.timedMetadataId3Frame.equals(that.timedMetadataId3Frame) : that.timedMetadataId3Frame != null) return false;
                if (this.timedMetadataId3Period != null ? !this.timedMetadataId3Period.equals(that.timedMetadataId3Period) : that.timedMetadataId3Period != null) return false;
                return this.timedMetadataPassthrough != null ? this.timedMetadataPassthrough.equals(that.timedMetadataPassthrough) : that.timedMetadataPassthrough == null;
            }

            @Override
            public final int hashCode() {
                int result = this.additionalDestinations != null ? this.additionalDestinations.hashCode() : 0;
                result = 31 * result + (this.captionLanguageMappings != null ? this.captionLanguageMappings.hashCode() : 0);
                result = 31 * result + (this.destination != null ? this.destination.hashCode() : 0);
                result = 31 * result + (this.id3Behavior != null ? this.id3Behavior.hashCode() : 0);
                result = 31 * result + (this.id3NameModifier != null ? this.id3NameModifier.hashCode() : 0);
                result = 31 * result + (this.klvBehavior != null ? this.klvBehavior.hashCode() : 0);
                result = 31 * result + (this.klvNameModifier != null ? this.klvNameModifier.hashCode() : 0);
                result = 31 * result + (this.nielsenId3Behavior != null ? this.nielsenId3Behavior.hashCode() : 0);
                result = 31 * result + (this.nielsenId3NameModifier != null ? this.nielsenId3NameModifier.hashCode() : 0);
                result = 31 * result + (this.scte35NameModifier != null ? this.scte35NameModifier.hashCode() : 0);
                result = 31 * result + (this.scte35Type != null ? this.scte35Type.hashCode() : 0);
                result = 31 * result + (this.segmentLength != null ? this.segmentLength.hashCode() : 0);
                result = 31 * result + (this.segmentLengthUnits != null ? this.segmentLengthUnits.hashCode() : 0);
                result = 31 * result + (this.sendDelayMs != null ? this.sendDelayMs.hashCode() : 0);
                result = 31 * result + (this.timedMetadataId3Frame != null ? this.timedMetadataId3Frame.hashCode() : 0);
                result = 31 * result + (this.timedMetadataId3Period != null ? this.timedMetadataId3Period.hashCode() : 0);
                result = 31 * result + (this.timedMetadataPassthrough != null ? this.timedMetadataPassthrough.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * CmafIngestOutputSettingsProperty cmafIngestOutputSettingsProperty = CmafIngestOutputSettingsProperty.builder()
     *         .nameModifier("nameModifier")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestoutputsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestoutputsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.CmafIngestOutputSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(CmafIngestOutputSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CmafIngestOutputSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestoutputsettings.html#cfn-medialive-channel-cmafingestoutputsettings-namemodifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cmafingestoutputsettings.html#cfn-medialive-channel-cmafingestoutputsettings-namemodifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNameModifier() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CmafIngestOutputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CmafIngestOutputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CmafIngestOutputSettingsProperty> {
            java.lang.String nameModifier;

            /**
             * Sets the value of {@link CmafIngestOutputSettingsProperty#getNameModifier}
             * @param nameModifier the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nameModifier(java.lang.String nameModifier) {
                this.nameModifier = nameModifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CmafIngestOutputSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CmafIngestOutputSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CmafIngestOutputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CmafIngestOutputSettingsProperty {
            private final java.lang.String nameModifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.nameModifier = software.amazon.jsii.Kernel.get(this, "nameModifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.nameModifier = builder.nameModifier;
            }

            @Override
            public final java.lang.String getNameModifier() {
                return this.nameModifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNameModifier() != null) {
                    data.set("nameModifier", om.valueToTree(this.getNameModifier()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.CmafIngestOutputSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CmafIngestOutputSettingsProperty.Jsii$Proxy that = (CmafIngestOutputSettingsProperty.Jsii$Proxy) o;

                return this.nameModifier != null ? this.nameModifier.equals(that.nameModifier) : that.nameModifier == null;
            }

            @Override
            public final int hashCode() {
                int result = this.nameModifier != null ? this.nameModifier.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * ColorCorrectionProperty colorCorrectionProperty = ColorCorrectionProperty.builder()
     *         .inputColorSpace("inputColorSpace")
     *         .outputColorSpace("outputColorSpace")
     *         .uri("uri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-colorcorrection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-colorcorrection.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.ColorCorrectionProperty")
    @software.amazon.jsii.Jsii.Proxy(ColorCorrectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColorCorrectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-colorcorrection.html#cfn-medialive-channel-colorcorrection-inputcolorspace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-colorcorrection.html#cfn-medialive-channel-colorcorrection-inputcolorspace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputColorSpace() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-colorcorrection.html#cfn-medialive-channel-colorcorrection-outputcolorspace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-colorcorrection.html#cfn-medialive-channel-colorcorrection-outputcolorspace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputColorSpace() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-colorcorrection.html#cfn-medialive-channel-colorcorrection-uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-colorcorrection.html#cfn-medialive-channel-colorcorrection-uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColorCorrectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColorCorrectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColorCorrectionProperty> {
            java.lang.String inputColorSpace;
            java.lang.String outputColorSpace;
            java.lang.String uri;

            /**
             * Sets the value of {@link ColorCorrectionProperty#getInputColorSpace}
             * @param inputColorSpace the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputColorSpace(java.lang.String inputColorSpace) {
                this.inputColorSpace = inputColorSpace;
                return this;
            }

            /**
             * Sets the value of {@link ColorCorrectionProperty#getOutputColorSpace}
             * @param outputColorSpace the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputColorSpace(java.lang.String outputColorSpace) {
                this.outputColorSpace = outputColorSpace;
                return this;
            }

            /**
             * Sets the value of {@link ColorCorrectionProperty#getUri}
             * @param uri the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uri(java.lang.String uri) {
                this.uri = uri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColorCorrectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColorCorrectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColorCorrectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColorCorrectionProperty {
            private final java.lang.String inputColorSpace;
            private final java.lang.String outputColorSpace;
            private final java.lang.String uri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputColorSpace = software.amazon.jsii.Kernel.get(this, "inputColorSpace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputColorSpace = software.amazon.jsii.Kernel.get(this, "outputColorSpace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.uri = software.amazon.jsii.Kernel.get(this, "uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputColorSpace = builder.inputColorSpace;
                this.outputColorSpace = builder.outputColorSpace;
                this.uri = builder.uri;
            }

            @Override
            public final java.lang.String getInputColorSpace() {
                return this.inputColorSpace;
            }

            @Override
            public final java.lang.String getOutputColorSpace() {
                return this.outputColorSpace;
            }

            @Override
            public final java.lang.String getUri() {
                return this.uri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInputColorSpace() != null) {
                    data.set("inputColorSpace", om.valueToTree(this.getInputColorSpace()));
                }
                if (this.getOutputColorSpace() != null) {
                    data.set("outputColorSpace", om.valueToTree(this.getOutputColorSpace()));
                }
                if (this.getUri() != null) {
                    data.set("uri", om.valueToTree(this.getUri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.ColorCorrectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColorCorrectionProperty.Jsii$Proxy that = (ColorCorrectionProperty.Jsii$Proxy) o;

                if (this.inputColorSpace != null ? !this.inputColorSpace.equals(that.inputColorSpace) : that.inputColorSpace != null) return false;
                if (this.outputColorSpace != null ? !this.outputColorSpace.equals(that.outputColorSpace) : that.outputColorSpace != null) return false;
                return this.uri != null ? this.uri.equals(that.uri) : that.uri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inputColorSpace != null ? this.inputColorSpace.hashCode() : 0;
                result = 31 * result + (this.outputColorSpace != null ? this.outputColorSpace.hashCode() : 0);
                result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * ColorCorrectionSettingsProperty colorCorrectionSettingsProperty = ColorCorrectionSettingsProperty.builder()
     *         .globalColorCorrections(List.of(ColorCorrectionProperty.builder()
     *                 .inputColorSpace("inputColorSpace")
     *                 .outputColorSpace("outputColorSpace")
     *                 .uri("uri")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-colorcorrectionsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-colorcorrectionsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.ColorCorrectionSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ColorCorrectionSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColorCorrectionSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.ColorCorrectionProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-colorcorrectionsettings.html#cfn-medialive-channel-colorcorrectionsettings-globalcolorcorrections">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-colorcorrectionsettings.html#cfn-medialive-channel-colorcorrectionsettings-globalcolorcorrections</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGlobalColorCorrections() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColorCorrectionSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColorCorrectionSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColorCorrectionSettingsProperty> {
            java.lang.Object globalColorCorrections;

            /**
             * Sets the value of {@link ColorCorrectionSettingsProperty#getGlobalColorCorrections}
             * @param globalColorCorrections the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder globalColorCorrections(software.amazon.awscdk.IResolvable globalColorCorrections) {
                this.globalColorCorrections = globalColorCorrections;
                return this;
            }

            /**
             * Sets the value of {@link ColorCorrectionSettingsProperty#getGlobalColorCorrections}
             * @param globalColorCorrections the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder globalColorCorrections(java.util.List<? extends java.lang.Object> globalColorCorrections) {
                this.globalColorCorrections = globalColorCorrections;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColorCorrectionSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColorCorrectionSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColorCorrectionSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColorCorrectionSettingsProperty {
            private final java.lang.Object globalColorCorrections;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.globalColorCorrections = software.amazon.jsii.Kernel.get(this, "globalColorCorrections", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.globalColorCorrections = builder.globalColorCorrections;
            }

            @Override
            public final java.lang.Object getGlobalColorCorrections() {
                return this.globalColorCorrections;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGlobalColorCorrections() != null) {
                    data.set("globalColorCorrections", om.valueToTree(this.getGlobalColorCorrections()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.ColorCorrectionSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColorCorrectionSettingsProperty.Jsii$Proxy that = (ColorCorrectionSettingsProperty.Jsii$Proxy) o;

                return this.globalColorCorrections != null ? this.globalColorCorrections.equals(that.globalColorCorrections) : that.globalColorCorrections == null;
            }

            @Override
            public final int hashCode() {
                int result = this.globalColorCorrections != null ? this.globalColorCorrections.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * ColorSpacePassthroughSettingsProperty colorSpacePassthroughSettingsProperty = ColorSpacePassthroughSettingsProperty.builder().build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-colorspacepassthroughsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-colorspacepassthroughsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.ColorSpacePassthroughSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ColorSpacePassthroughSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColorSpacePassthroughSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @return a {@link Builder} of {@link ColorSpacePassthroughSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColorSpacePassthroughSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColorSpacePassthroughSettingsProperty> {

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColorSpacePassthroughSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColorSpacePassthroughSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColorSpacePassthroughSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColorSpacePassthroughSettingsProperty {

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();


                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.ColorSpacePassthroughSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * DolbyVision81SettingsProperty dolbyVision81SettingsProperty = DolbyVision81SettingsProperty.builder().build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dolbyvision81settings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dolbyvision81settings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.DolbyVision81SettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DolbyVision81SettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DolbyVision81SettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @return a {@link Builder} of {@link DolbyVision81SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DolbyVision81SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DolbyVision81SettingsProperty> {

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DolbyVision81SettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DolbyVision81SettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DolbyVision81SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DolbyVision81SettingsProperty {

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();


                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.DolbyVision81SettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }
        }
    }
    /**
     * The configuration of DVB NIT.
     * <p>
     * The parent of this entity is M2tsSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * DvbNitSettingsProperty dvbNitSettingsProperty = DvbNitSettingsProperty.builder()
     *         .networkId(123)
     *         .networkName("networkName")
     *         .repInterval(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbnitsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbnitsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.DvbNitSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DvbNitSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DvbNitSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The numeric value placed in the Network Information Table (NIT).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbnitsettings.html#cfn-medialive-channel-dvbnitsettings-networkid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbnitsettings.html#cfn-medialive-channel-dvbnitsettings-networkid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNetworkId() {
            return null;
        }

        /**
         * The network name text placed in the networkNameDescriptor inside the Network Information Table (NIT).
         * <p>
         * The maximum length is 256 characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbnitsettings.html#cfn-medialive-channel-dvbnitsettings-networkname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbnitsettings.html#cfn-medialive-channel-dvbnitsettings-networkname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNetworkName() {
            return null;
        }

        /**
         * The number of milliseconds between instances of this table in the output transport stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbnitsettings.html#cfn-medialive-channel-dvbnitsettings-repinterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbnitsettings.html#cfn-medialive-channel-dvbnitsettings-repinterval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRepInterval() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DvbNitSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DvbNitSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DvbNitSettingsProperty> {
            java.lang.Number networkId;
            java.lang.String networkName;
            java.lang.Number repInterval;

            /**
             * Sets the value of {@link DvbNitSettingsProperty#getNetworkId}
             * @param networkId The numeric value placed in the Network Information Table (NIT).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkId(java.lang.Number networkId) {
                this.networkId = networkId;
                return this;
            }

            /**
             * Sets the value of {@link DvbNitSettingsProperty#getNetworkName}
             * @param networkName The network name text placed in the networkNameDescriptor inside the Network Information Table (NIT).
             *                    The maximum length is 256 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkName(java.lang.String networkName) {
                this.networkName = networkName;
                return this;
            }

            /**
             * Sets the value of {@link DvbNitSettingsProperty#getRepInterval}
             * @param repInterval The number of milliseconds between instances of this table in the output transport stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repInterval(java.lang.Number repInterval) {
                this.repInterval = repInterval;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DvbNitSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DvbNitSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DvbNitSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DvbNitSettingsProperty {
            private final java.lang.Number networkId;
            private final java.lang.String networkName;
            private final java.lang.Number repInterval;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.networkId = software.amazon.jsii.Kernel.get(this, "networkId", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.networkName = software.amazon.jsii.Kernel.get(this, "networkName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.repInterval = software.amazon.jsii.Kernel.get(this, "repInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.networkId = builder.networkId;
                this.networkName = builder.networkName;
                this.repInterval = builder.repInterval;
            }

            @Override
            public final java.lang.Number getNetworkId() {
                return this.networkId;
            }

            @Override
            public final java.lang.String getNetworkName() {
                return this.networkName;
            }

            @Override
            public final java.lang.Number getRepInterval() {
                return this.repInterval;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNetworkId() != null) {
                    data.set("networkId", om.valueToTree(this.getNetworkId()));
                }
                if (this.getNetworkName() != null) {
                    data.set("networkName", om.valueToTree(this.getNetworkName()));
                }
                if (this.getRepInterval() != null) {
                    data.set("repInterval", om.valueToTree(this.getRepInterval()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.DvbNitSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DvbNitSettingsProperty.Jsii$Proxy that = (DvbNitSettingsProperty.Jsii$Proxy) o;

                if (this.networkId != null ? !this.networkId.equals(that.networkId) : that.networkId != null) return false;
                if (this.networkName != null ? !this.networkName.equals(that.networkName) : that.networkName != null) return false;
                return this.repInterval != null ? this.repInterval.equals(that.repInterval) : that.repInterval == null;
            }

            @Override
            public final int hashCode() {
                int result = this.networkId != null ? this.networkId.hashCode() : 0;
                result = 31 * result + (this.networkName != null ? this.networkName.hashCode() : 0);
                result = 31 * result + (this.repInterval != null ? this.repInterval.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A DVB Service Description Table (SDT).
     * <p>
     * The parent of this entity is M2tsSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * DvbSdtSettingsProperty dvbSdtSettingsProperty = DvbSdtSettingsProperty.builder()
     *         .outputSdt("outputSdt")
     *         .repInterval(123)
     *         .serviceName("serviceName")
     *         .serviceProviderName("serviceProviderName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.DvbSdtSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DvbSdtSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DvbSdtSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Selects a method of inserting SDT information into an output stream.
         * <p>
         * The sdtFollow setting copies SDT information from input stream to output stream. The sdtFollowIfPresent setting copies SDT information from input stream to output stream if SDT information is present in the input. Otherwise, it falls back on the user-defined values. The sdtManual setting means that the user will enter the SDT information. The sdtNone setting means that the output stream will not contain SDT information.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html#cfn-medialive-channel-dvbsdtsettings-outputsdt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html#cfn-medialive-channel-dvbsdtsettings-outputsdt</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputSdt() {
            return null;
        }

        /**
         * The number of milliseconds between instances of this table in the output transport stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html#cfn-medialive-channel-dvbsdtsettings-repinterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html#cfn-medialive-channel-dvbsdtsettings-repinterval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRepInterval() {
            return null;
        }

        /**
         * The service name placed in the serviceDescriptor in the Service Description Table (SDT).
         * <p>
         * The maximum length is 256 characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html#cfn-medialive-channel-dvbsdtsettings-servicename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html#cfn-medialive-channel-dvbsdtsettings-servicename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceName() {
            return null;
        }

        /**
         * The service provider name placed in the serviceDescriptor in the Service Description Table (SDT).
         * <p>
         * The maximum length is 256 characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html#cfn-medialive-channel-dvbsdtsettings-serviceprovidername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html#cfn-medialive-channel-dvbsdtsettings-serviceprovidername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceProviderName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DvbSdtSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DvbSdtSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DvbSdtSettingsProperty> {
            java.lang.String outputSdt;
            java.lang.Number repInterval;
            java.lang.String serviceName;
            java.lang.String serviceProviderName;

            /**
             * Sets the value of {@link DvbSdtSettingsProperty#getOutputSdt}
             * @param outputSdt Selects a method of inserting SDT information into an output stream.
             *                  The sdtFollow setting copies SDT information from input stream to output stream. The sdtFollowIfPresent setting copies SDT information from input stream to output stream if SDT information is present in the input. Otherwise, it falls back on the user-defined values. The sdtManual setting means that the user will enter the SDT information. The sdtNone setting means that the output stream will not contain SDT information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputSdt(java.lang.String outputSdt) {
                this.outputSdt = outputSdt;
                return this;
            }

            /**
             * Sets the value of {@link DvbSdtSettingsProperty#getRepInterval}
             * @param repInterval The number of milliseconds between instances of this table in the output transport stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repInterval(java.lang.Number repInterval) {
                this.repInterval = repInterval;
                return this;
            }

            /**
             * Sets the value of {@link DvbSdtSettingsProperty#getServiceName}
             * @param serviceName The service name placed in the serviceDescriptor in the Service Description Table (SDT).
             *                    The maximum length is 256 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceName(java.lang.String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            /**
             * Sets the value of {@link DvbSdtSettingsProperty#getServiceProviderName}
             * @param serviceProviderName The service provider name placed in the serviceDescriptor in the Service Description Table (SDT).
             *                            The maximum length is 256 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceProviderName(java.lang.String serviceProviderName) {
                this.serviceProviderName = serviceProviderName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DvbSdtSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DvbSdtSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DvbSdtSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DvbSdtSettingsProperty {
            private final java.lang.String outputSdt;
            private final java.lang.Number repInterval;
            private final java.lang.String serviceName;
            private final java.lang.String serviceProviderName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.outputSdt = software.amazon.jsii.Kernel.get(this, "outputSdt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.repInterval = software.amazon.jsii.Kernel.get(this, "repInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceProviderName = software.amazon.jsii.Kernel.get(this, "serviceProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.outputSdt = builder.outputSdt;
                this.repInterval = builder.repInterval;
                this.serviceName = builder.serviceName;
                this.serviceProviderName = builder.serviceProviderName;
            }

            @Override
            public final java.lang.String getOutputSdt() {
                return this.outputSdt;
            }

            @Override
            public final java.lang.Number getRepInterval() {
                return this.repInterval;
            }

            @Override
            public final java.lang.String getServiceName() {
                return this.serviceName;
            }

            @Override
            public final java.lang.String getServiceProviderName() {
                return this.serviceProviderName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOutputSdt() != null) {
                    data.set("outputSdt", om.valueToTree(this.getOutputSdt()));
                }
                if (this.getRepInterval() != null) {
                    data.set("repInterval", om.valueToTree(this.getRepInterval()));
                }
                if (this.getServiceName() != null) {
                    data.set("serviceName", om.valueToTree(this.getServiceName()));
                }
                if (this.getServiceProviderName() != null) {
                    data.set("serviceProviderName", om.valueToTree(this.getServiceProviderName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.DvbSdtSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DvbSdtSettingsProperty.Jsii$Proxy that = (DvbSdtSettingsProperty.Jsii$Proxy) o;

                if (this.outputSdt != null ? !this.outputSdt.equals(that.outputSdt) : that.outputSdt != null) return false;
                if (this.repInterval != null ? !this.repInterval.equals(that.repInterval) : that.repInterval != null) return false;
                if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) return false;
                return this.serviceProviderName != null ? this.serviceProviderName.equals(that.serviceProviderName) : that.serviceProviderName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.outputSdt != null ? this.outputSdt.hashCode() : 0;
                result = 31 * result + (this.repInterval != null ? this.repInterval.hashCode() : 0);
                result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
                result = 31 * result + (this.serviceProviderName != null ? this.serviceProviderName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for DVB Sub captions in the output.
     * <p>
     * The parent of this entity is CaptionDestinationSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * DvbSubDestinationSettingsProperty dvbSubDestinationSettingsProperty = DvbSubDestinationSettingsProperty.builder()
     *         .alignment("alignment")
     *         .backgroundColor("backgroundColor")
     *         .backgroundOpacity(123)
     *         .font(InputLocationProperty.builder()
     *                 .passwordParam("passwordParam")
     *                 .uri("uri")
     *                 .username("username")
     *                 .build())
     *         .fontColor("fontColor")
     *         .fontOpacity(123)
     *         .fontResolution(123)
     *         .fontSize("fontSize")
     *         .outlineColor("outlineColor")
     *         .outlineSize(123)
     *         .shadowColor("shadowColor")
     *         .shadowOpacity(123)
     *         .shadowXOffset(123)
     *         .shadowYOffset(123)
     *         .subtitleRows("subtitleRows")
     *         .teletextGridControl("teletextGridControl")
     *         .xPosition(123)
     *         .yPosition(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.DvbSubDestinationSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DvbSubDestinationSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DvbSubDestinationSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If no explicit xPosition or yPosition is provided, setting the alignment to centered places the captions at the bottom center of the output.
         * <p>
         * Similarly, setting a left alignment aligns captions to the bottom left of the output. If x and y positions are specified in conjunction with the alignment parameter, the font is justified (either left or centered) relative to those coordinates. Selecting "smart" justification left-justifies live subtitles and center-justifies pre-recorded subtitles. This option is not valid for source captions that are STL or 608/embedded. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-alignment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-alignment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlignment() {
            return null;
        }

        /**
         * Specifies the color of the rectangle behind the captions.
         * <p>
         * All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-backgroundcolor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-backgroundcolor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBackgroundColor() {
            return null;
        }

        /**
         * Specifies the opacity of the background rectangle.
         * <p>
         * 255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-backgroundopacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-backgroundopacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBackgroundOpacity() {
            return null;
        }

        /**
         * The external font file that is used for captions burn-in.
         * <p>
         * The file extension must be .ttf or .tte. Although you can select output fonts for many different types of input captions, embedded, STL, and Teletext sources use a strict grid system. Using external fonts with these captions sources could cause an unexpected display of proportional fonts. All burn-in and DVB-Sub font settings must match.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.medialive.CfnChannel.InputLocationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-font">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-font</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFont() {
            return null;
        }

        /**
         * Specifies the color of the burned-in captions.
         * <p>
         * This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-fontcolor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-fontcolor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFontColor() {
            return null;
        }

        /**
         * Specifies the opacity of the burned-in captions.
         * <p>
         * 255 is opaque; 0 is transparent. All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-fontopacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-fontopacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFontOpacity() {
            return null;
        }

        /**
         * The font resolution in DPI (dots per inch).
         * <p>
         * The default is 96 dpi. All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-fontresolution">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-fontresolution</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFontResolution() {
            return null;
        }

        /**
         * When set to auto, fontSize scales depending on the size of the output.
         * <p>
         * Providing a positive integer specifies the exact font size in points. All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-fontsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-fontsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFontSize() {
            return null;
        }

        /**
         * Specifies the font outline color.
         * <p>
         * This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-outlinecolor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-outlinecolor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutlineColor() {
            return null;
        }

        /**
         * Specifies the font outline size in pixels.
         * <p>
         * This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-outlinesize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-outlinesize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOutlineSize() {
            return null;
        }

        /**
         * Specifies the color of the shadow that is cast by the captions.
         * <p>
         * All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-shadowcolor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-shadowcolor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getShadowColor() {
            return null;
        }

        /**
         * Specifies the opacity of the shadow.
         * <p>
         * 255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-shadowopacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-shadowopacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getShadowOpacity() {
            return null;
        }

        /**
         * Specifies the horizontal offset of the shadow relative to the captions in pixels.
         * <p>
         * A value of -2 would result in a shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-shadowxoffset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-shadowxoffset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getShadowXOffset() {
            return null;
        }

        /**
         * Specifies the vertical offset of the shadow relative to the captions in pixels.
         * <p>
         * A value of -2 would result in a shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-shadowyoffset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-shadowyoffset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getShadowYOffset() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-subtitlerows">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-subtitlerows</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubtitleRows() {
            return null;
        }

        /**
         * Controls whether a fixed grid size is used to generate the output subtitles bitmap.
         * <p>
         * This applies to only Teletext inputs and DVB-Sub/Burn-in outputs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-teletextgridcontrol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-teletextgridcontrol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTeletextGridControl() {
            return null;
        }

        /**
         * Specifies the horizontal position of the captions relative to the left side of the output in pixels.
         * <p>
         * A value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit xPosition is provided, the horizontal captions position is determined by the alignment parameter. This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-xposition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-xposition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getXPosition() {
            return null;
        }

        /**
         * Specifies the vertical position of the captions relative to the top of the output in pixels.
         * <p>
         * A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit yPosition is provided, the captions are positioned towards the bottom of the output. This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-yposition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-yposition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getYPosition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DvbSubDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DvbSubDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DvbSubDestinationSettingsProperty> {
            java.lang.String alignment;
            java.lang.String backgroundColor;
            java.lang.Number backgroundOpacity;
            java.lang.Object font;
            java.lang.String fontColor;
            java.lang.Number fontOpacity;
            java.lang.Number fontResolution;
            java.lang.String fontSize;
            java.lang.String outlineColor;
            java.lang.Number outlineSize;
            java.lang.String shadowColor;
            java.lang.Number shadowOpacity;
            java.lang.Number shadowXOffset;
            java.lang.Number shadowYOffset;
            java.lang.String subtitleRows;
            java.lang.String teletextGridControl;
            java.lang.Number xPosition;
            java.lang.Number yPosition;

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getAlignment}
             * @param alignment If no explicit xPosition or yPosition is provided, setting the alignment to centered places the captions at the bottom center of the output.
             *                  Similarly, setting a left alignment aligns captions to the bottom left of the output. If x and y positions are specified in conjunction with the alignment parameter, the font is justified (either left or centered) relative to those coordinates. Selecting "smart" justification left-justifies live subtitles and center-justifies pre-recorded subtitles. This option is not valid for source captions that are STL or 608/embedded. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alignment(java.lang.String alignment) {
                this.alignment = alignment;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getBackgroundColor}
             * @param backgroundColor Specifies the color of the rectangle behind the captions.
             *                        All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backgroundColor(java.lang.String backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getBackgroundOpacity}
             * @param backgroundOpacity Specifies the opacity of the background rectangle.
             *                          255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backgroundOpacity(java.lang.Number backgroundOpacity) {
                this.backgroundOpacity = backgroundOpacity;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getFont}
             * @param font The external font file that is used for captions burn-in.
             *             The file extension must be .ttf or .tte. Although you can select output fonts for many different types of input captions, embedded, STL, and Teletext sources use a strict grid system. Using external fonts with these captions sources could cause an unexpected display of proportional fonts. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder font(software.amazon.awscdk.IResolvable font) {
                this.font = font;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getFont}
             * @param font The external font file that is used for captions burn-in.
             *             The file extension must be .ttf or .tte. Although you can select output fonts for many different types of input captions, embedded, STL, and Teletext sources use a strict grid system. Using external fonts with these captions sources could cause an unexpected display of proportional fonts. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder font(software.amazon.awscdk.services.medialive.CfnChannel.InputLocationProperty font) {
                this.font = font;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getFontColor}
             * @param fontColor Specifies the color of the burned-in captions.
             *                  This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontColor(java.lang.String fontColor) {
                this.fontColor = fontColor;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getFontOpacity}
             * @param fontOpacity Specifies the opacity of the burned-in captions.
             *                    255 is opaque; 0 is transparent. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontOpacity(java.lang.Number fontOpacity) {
                this.fontOpacity = fontOpacity;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getFontResolution}
             * @param fontResolution The font resolution in DPI (dots per inch).
             *                       The default is 96 dpi. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontResolution(java.lang.Number fontResolution) {
                this.fontResolution = fontResolution;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getFontSize}
             * @param fontSize When set to auto, fontSize scales depending on the size of the output.
             *                 Providing a positive integer specifies the exact font size in points. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontSize(java.lang.String fontSize) {
                this.fontSize = fontSize;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getOutlineColor}
             * @param outlineColor Specifies the font outline color.
             *                     This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outlineColor(java.lang.String outlineColor) {
                this.outlineColor = outlineColor;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getOutlineSize}
             * @param outlineSize Specifies the font outline size in pixels.
             *                    This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outlineSize(java.lang.Number outlineSize) {
                this.outlineSize = outlineSize;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getShadowColor}
             * @param shadowColor Specifies the color of the shadow that is cast by the captions.
             *                    All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shadowColor(java.lang.String shadowColor) {
                this.shadowColor = shadowColor;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getShadowOpacity}
             * @param shadowOpacity Specifies the opacity of the shadow.
             *                      255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shadowOpacity(java.lang.Number shadowOpacity) {
                this.shadowOpacity = shadowOpacity;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getShadowXOffset}
             * @param shadowXOffset Specifies the horizontal offset of the shadow relative to the captions in pixels.
             *                      A value of -2 would result in a shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shadowXOffset(java.lang.Number shadowXOffset) {
                this.shadowXOffset = shadowXOffset;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getShadowYOffset}
             * @param shadowYOffset Specifies the vertical offset of the shadow relative to the captions in pixels.
             *                      A value of -2 would result in a shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shadowYOffset(java.lang.Number shadowYOffset) {
                this.shadowYOffset = shadowYOffset;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getSubtitleRows}
             * @param subtitleRows the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subtitleRows(java.lang.String subtitleRows) {
                this.subtitleRows = subtitleRows;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getTeletextGridControl}
             * @param teletextGridControl Controls whether a fixed grid size is used to generate the output subtitles bitmap.
             *                            This applies to only Teletext inputs and DVB-Sub/Burn-in outputs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder teletextGridControl(java.lang.String teletextGridControl) {
                this.teletextGridControl = teletextGridControl;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getXPosition}
             * @param xPosition Specifies the horizontal position of the captions relative to the left side of the output in pixels.
             *                  A value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit xPosition is provided, the horizontal captions position is determined by the alignment parameter. This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder xPosition(java.lang.Number xPosition) {
                this.xPosition = xPosition;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getYPosition}
             * @param yPosition Specifies the vertical position of the captions relative to the top of the output in pixels.
             *                  A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit yPosition is provided, the captions are positioned towards the bottom of the output. This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder yPosition(java.lang.Number yPosition) {
                this.yPosition = yPosition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DvbSubDestinationSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DvbSubDestinationSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DvbSubDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DvbSubDestinationSettingsProperty {
            private final java.lang.String alignment;
            private final java.lang.String backgroundColor;
            private final java.lang.Number backgroundOpacity;
            private final java.lang.Object font;
            private final java.lang.String fontColor;
            private final java.lang.Number fontOpacity;
            private final java.lang.Number fontResolution;
            private final java.lang.String fontSize;
            private final java.lang.String outlineColor;
            private final java.lang.Number outlineSize;
            private final java.lang.String shadowColor;
            private final java.lang.Number shadowOpacity;
            private final java.lang.Number shadowXOffset;
            private final java.lang.Number shadowYOffset;
            private final java.lang.String subtitleRows;
            private final java.lang.String teletextGridControl;
            private final java.lang.Number xPosition;
            private final java.lang.Number yPosition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alignment = software.amazon.jsii.Kernel.get(this, "alignment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.backgroundColor = software.amazon.jsii.Kernel.get(this, "backgroundColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.backgroundOpacity = software.amazon.jsii.Kernel.get(this, "backgroundOpacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.font = software.amazon.jsii.Kernel.get(this, "font", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fontColor = software.amazon.jsii.Kernel.get(this, "fontColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fontOpacity = software.amazon.jsii.Kernel.get(this, "fontOpacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.fontResolution = software.amazon.jsii.Kernel.get(this, "fontResolution", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.fontSize = software.amazon.jsii.Kernel.get(this, "fontSize", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outlineColor = software.amazon.jsii.Kernel.get(this, "outlineColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outlineSize = software.amazon.jsii.Kernel.get(this, "outlineSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.shadowColor = software.amazon.jsii.Kernel.get(this, "shadowColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.shadowOpacity = software.amazon.jsii.Kernel.get(this, "shadowOpacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.shadowXOffset = software.amazon.jsii.Kernel.get(this, "shadowXOffset", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.shadowYOffset = software.amazon.jsii.Kernel.get(this, "shadowYOffset", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.subtitleRows = software.amazon.jsii.Kernel.get(this, "subtitleRows", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.teletextGridControl = software.amazon.jsii.Kernel.get(this, "teletextGridControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.xPosition = software.amazon.jsii.Kernel.get(this, "xPosition", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.yPosition = software.amazon.jsii.Kernel.get(this, "yPosition", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alignment = builder.alignment;
                this.backgroundColor = builder.backgroundColor;
                this.backgroundOpacity = builder.backgroundOpacity;
                this.font = builder.font;
                this.fontColor = builder.fontColor;
                this.fontOpacity = builder.fontOpacity;
                this.fontResolution = builder.fontResolution;
                this.fontSize = builder.fontSize;
                this.outlineColor = builder.outlineColor;
                this.outlineSize = builder.outlineSize;
                this.shadowColor = builder.shadowColor;
                this.shadowOpacity = builder.shadowOpacity;
                this.shadowXOffset = builder.shadowXOffset;
                this.shadowYOffset = builder.shadowYOffset;
                this.subtitleRows = builder.subtitleRows;
                this.teletextGridControl = builder.teletextGridControl;
                this.xPosition = builder.xPosition;
                this.yPosition = builder.yPosition;
            }

            @Override
            public final java.lang.String getAlignment() {
                return this.alignment;
            }

            @Override
            public final java.lang.String getBackgroundColor() {
                return this.backgroundColor;
            }

            @Override
            public final java.lang.Number getBackgroundOpacity() {
                return this.backgroundOpacity;
            }

            @Override
            public final java.lang.Object getFont() {
                return this.font;
            }

            @Override
            public final java.lang.String getFontColor() {
                return this.fontColor;
            }

            @Override
            public final java.lang.Number getFontOpacity() {
                return this.fontOpacity;
            }

            @Override
            public final java.lang.Number getFontResolution() {
                return this.fontResolution;
            }

            @Override
            public final java.lang.String getFontSize() {
                return this.fontSize;
            }

            @Override
            public final java.lang.String getOutlineColor() {
                return this.outlineColor;
            }

            @Override
            public final java.lang.Number getOutlineSize() {
                return this.outlineSize;
            }

            @Override
            public final java.lang.String getShadowColor() {
                return this.shadowColor;
            }

            @Override
            public final java.lang.Number getShadowOpacity() {
                return this.shadowOpacity;
            }

            @Override
            public final java.lang.Number getShadowXOffset() {
                return this.shadowXOffset;
            }

            @Override
            public final java.lang.Number getShadowYOffset() {
                return this.shadowYOffset;
            }

            @Override
            public final java.lang.String getSubtitleRows() {
                return this.subtitleRows;
            }

            @Override
            public final java.lang.String getTeletextGridControl() {
                return this.teletextGridControl;
            }

            @Override
            public final java.lang.Number getXPosition() {
                return this.xPosition;
            }

            @Override
            public final java.lang.Number getYPosition() {
                return this.yPosition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlignment() != null) {
                    data.set("alignment", om.valueToTree(this.getAlignment()));
                }
                if (this.getBackgroundColor() != null) {
                    data.set("backgroundColor", om.valueToTree(this.getBackgroundColor()));
                }
                if (this.getBackgroundOpacity() != null) {
                    data.set("backgroundOpacity", om.valueToTree(this.getBackgroundOpacity()));
                }
                if (this.getFont() != null) {
                    data.set("font", om.valueToTree(this.getFont()));
                }
                if (this.getFontColor() != null) {
                    data.set("fontColor", om.valueToTree(this.getFontColor()));
                }
                if (this.getFontOpacity() != null) {
                    data.set("fontOpacity", om.valueToTree(this.getFontOpacity()));
                }
                if (this.getFontResolution() != null) {
                    data.set("fontResolution", om.valueToTree(this.getFontResolution()));
                }
                if (this.getFontSize() != null) {
                    data.set("fontSize", om.valueToTree(this.getFontSize()));
                }
                if (this.getOutlineColor() != null) {
                    data.set("outlineColor", om.valueToTree(this.getOutlineColor()));
                }
                if (this.getOutlineSize() != null) {
                    data.set("outlineSize", om.valueToTree(this.getOutlineSize()));
                }
                if (this.getShadowColor() != null) {
                    data.set("shadowColor", om.valueToTree(this.getShadowColor()));
                }
                if (this.getShadowOpacity() != null) {
                    data.set("shadowOpacity", om.valueToTree(this.getShadowOpacity()));
                }
                if (this.getShadowXOffset() != null) {
                    data.set("shadowXOffset", om.valueToTree(this.getShadowXOffset()));
                }
                if (this.getShadowYOffset() != null) {
                    data.set("shadowYOffset", om.valueToTree(this.getShadowYOffset()));
                }
                if (this.getSubtitleRows() != null) {
                    data.set("subtitleRows", om.valueToTree(this.getSubtitleRows()));
                }
                if (this.getTeletextGridControl() != null) {
                    data.set("teletextGridControl", om.valueToTree(this.getTeletextGridControl()));
                }
                if (this.getXPosition() != null) {
                    data.set("xPosition", om.valueToTree(this.getXPosition()));
                }
                if (this.getYPosition() != null) {
                    data.set("yPosition", om.valueToTree(this.getYPosition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.DvbSubDestinationSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DvbSubDestinationSettingsProperty.Jsii$Proxy that = (DvbSubDestinationSettingsProperty.Jsii$Proxy) o;

                if (this.alignment != null ? !this.alignment.equals(that.alignment) : that.alignment != null) return false;
                if (this.backgroundColor != null ? !this.backgroundColor.equals(that.backgroundColor) : that.backgroundColor != null) return false;
                if (this.backgroundOpacity != null ? !this.backgroundOpacity.equals(that.backgroundOpacity) : that.backgroundOpacity != null) return false;
                if (this.font != null ? !this.font.equals(that.font) : that.font != null) return false;
                if (this.fontColor != null ? !this.fontColor.equals(that.fontColor) : that.fontColor != null) return false;
                if (this.fontOpacity != null ? !this.fontOpacity.equals(that.fontOpacity) : that.fontOpacity != null) return false;
                if (this.fontResolution != null ? !this.fontResolution.equals(that.fontResolution) : that.fontResolution != null) return false;
                if (this.fontSize != null ? !this.fontSize.equals(that.fontSize) : that.fontSize != null) return false;
                if (this.outlineColor != null ? !this.outlineColor.equals(that.outlineColor) : that.outlineColor != null) return false;
                if (this.outlineSize != null ? !this.outlineSize.equals(that.outlineSize) : that.outlineSize != null) return false;
                if (this.shadowColor != null ? !this.shadowColor.equals(that.shadowColor) : that.shadowColor != null) return false;
                if (this.shadowOpacity != null ? !this.shadowOpacity.equals(that.shadowOpacity) : that.shadowOpacity != null) return false;
                if (this.shadowXOffset != null ? !this.shadowXOffset.equals(that.shadowXOffset) : that.shadowXOffset != null) return false;
                if (this.shadowYOffset != null ? !this.shadowYOffset.equals(that.shadowYOffset) : that.shadowYOffset != null) return false;
                if (this.subtitleRows != null ? !this.subtitleRows.equals(that.subtitleRows) : that.subtitleRows != null) return false;
                if (this.teletextGridControl != null ? !this.teletextGridControl.equals(that.teletextGridControl) : that.teletextGridControl != null) return false;
                if (this.xPosition != null ? !this.xPosition.equals(that.xPosition) : that.xPosition != null) return false;
                return this.yPosition != null ? this.yPosition.equals(that.yPosition) : that.yPosition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alignment != null ? this.alignment.hashCode() : 0;
                result = 31 * result + (this.backgroundColor != null ? this.backgroundColor.hashCode() : 0);
                result = 31 * result + (this.backgroundOpacity != null ? this.backgroundOpacity.hashCode() : 0);
                result = 31 * result + (this.font != null ? this.font.hashCode() : 0);
                result = 31 * result + (this.fontColor != null ? this.fontColor.hashCode() : 0);
                result = 31 * result + (this.fontOpacity != null ? this.fontOpacity.hashCode() : 0);
                result = 31 * result + (this.fontResolution != null ? this.fontResolution.hashCode() : 0);
                result = 31 * result + (this.fontSize != null ? this.fontSize.hashCode() : 0);
                result = 31 * result + (this.outlineColor != null ? this.outlineColor.hashCode() : 0);
                result = 31 * result + (this.outlineSize != null ? this.outlineSize.hashCode() : 0);
                result = 31 * result + (this.shadowColor != null ? this.shadowColor.hashCode() : 0);
                result = 31 * result + (this.shadowOpacity != null ? this.shadowOpacity.hashCode() : 0);
                result = 31 * result + (this.shadowXOffset != null ? this.shadowXOffset.hashCode() : 0);
                result = 31 * result + (this.shadowYOffset != null ? this.shadowYOffset.hashCode() : 0);
                result = 31 * result + (this.subtitleRows != null ? this.subtitleRows.hashCode() : 0);
                result = 31 * result + (this.teletextGridControl != null ? this.teletextGridControl.hashCode() : 0);
                result = 31 * result + (this.xPosition != null ? this.xPosition.hashCode() : 0);
                result = 31 * result + (this.yPosition != null ? this.yPosition.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the DVB Sub captions to extract from the input.
     * <p>
     * The parent of this entity is CaptionSelectorSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * DvbSubSourceSettingsProperty dvbSubSourceSettingsProperty = DvbSubSourceSettingsProperty.builder()
     *         .ocrLanguage("ocrLanguage")
     *         .pid(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubsourcesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubsourcesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.DvbSubSourceSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DvbSubSourceSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DvbSubSourceSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If you will configure a WebVTT caption description that references this caption selector, use this field to provide the language to consider when translating the image-based source to text.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubsourcesettings.html#cfn-medialive-channel-dvbsubsourcesettings-ocrlanguage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubsourcesettings.html#cfn-medialive-channel-dvbsubsourcesettings-ocrlanguage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOcrLanguage() {
            return null;
        }

        /**
         * When using DVB-Sub with burn-in or SMPTE-TT, use this PID for the source content.
         * <p>
         * It is unused for DVB-Sub passthrough. All DVB-Sub content is passed through, regardless of selectors.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubsourcesettings.html#cfn-medialive-channel-dvbsubsourcesettings-pid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubsourcesettings.html#cfn-medialive-channel-dvbsubsourcesettings-pid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPid() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DvbSubSourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DvbSubSourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DvbSubSourceSettingsProperty> {
            java.lang.String ocrLanguage;
            java.lang.Number pid;

            /**
             * Sets the value of {@link DvbSubSourceSettingsProperty#getOcrLanguage}
             * @param ocrLanguage If you will configure a WebVTT caption description that references this caption selector, use this field to provide the language to consider when translating the image-based source to text.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ocrLanguage(java.lang.String ocrLanguage) {
                this.ocrLanguage = ocrLanguage;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubSourceSettingsProperty#getPid}
             * @param pid When using DVB-Sub with burn-in or SMPTE-TT, use this PID for the source content.
             *            It is unused for DVB-Sub passthrough. All DVB-Sub content is passed through, regardless of selectors.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pid(java.lang.Number pid) {
                this.pid = pid;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DvbSubSourceSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DvbSubSourceSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DvbSubSourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DvbSubSourceSettingsProperty {
            private final java.lang.String ocrLanguage;
            private final java.lang.Number pid;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ocrLanguage = software.amazon.jsii.Kernel.get(this, "ocrLanguage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pid = software.amazon.jsii.Kernel.get(this, "pid", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ocrLanguage = builder.ocrLanguage;
                this.pid = builder.pid;
            }

            @Override
            public final java.lang.String getOcrLanguage() {
                return this.ocrLanguage;
            }

            @Override
            public final java.lang.Number getPid() {
                return this.pid;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOcrLanguage() != null) {
                    data.set("ocrLanguage", om.valueToTree(this.getOcrLanguage()));
                }
                if (this.getPid() != null) {
                    data.set("pid", om.valueToTree(this.getPid()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.DvbSubSourceSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DvbSubSourceSettingsProperty.Jsii$Proxy that = (DvbSubSourceSettingsProperty.Jsii$Proxy) o;

                if (this.ocrLanguage != null ? !this.ocrLanguage.equals(that.ocrLanguage) : that.ocrLanguage != null) return false;
                return this.pid != null ? this.pid.equals(that.pid) : that.pid == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ocrLanguage != null ? this.ocrLanguage.hashCode() : 0;
                result = 31 * result + (this.pid != null ? this.pid.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The DVB Time and Date Table (TDT).
     * <p>
     * The parent of this entity is M2tsSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * DvbTdtSettingsProperty dvbTdtSettingsProperty = DvbTdtSettingsProperty.builder()
     *         .repInterval(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbtdtsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbtdtsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.DvbTdtSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DvbTdtSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DvbTdtSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of milliseconds between instances of this table in the output transport stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbtdtsettings.html#cfn-medialive-channel-dvbtdtsettings-repinterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbtdtsettings.html#cfn-medialive-channel-dvbtdtsettings-repinterval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRepInterval() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DvbTdtSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DvbTdtSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DvbTdtSettingsProperty> {
            java.lang.Number repInterval;

            /**
             * Sets the value of {@link DvbTdtSettingsProperty#getRepInterval}
             * @param repInterval The number of milliseconds between instances of this table in the output transport stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repInterval(java.lang.Number repInterval) {
                this.repInterval = repInterval;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DvbTdtSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DvbTdtSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DvbTdtSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DvbTdtSettingsProperty {
            private final java.lang.Number repInterval;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.repInterval = software.amazon.jsii.Kernel.get(this, "repInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.repInterval = builder.repInterval;
            }

            @Override
            public final java.lang.Number getRepInterval() {
                return this.repInterval;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRepInterval() != null) {
                    data.set("repInterval", om.valueToTree(this.getRepInterval()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.DvbTdtSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DvbTdtSettingsProperty.Jsii$Proxy that = (DvbTdtSettingsProperty.Jsii$Proxy) o;

                return this.repInterval != null ? this.repInterval.equals(that.repInterval) : that.repInterval == null;
            }

            @Override
            public final int hashCode() {
                int result = this.repInterval != null ? this.repInterval.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * Eac3AtmosSettingsProperty eac3AtmosSettingsProperty = Eac3AtmosSettingsProperty.builder()
     *         .bitrate(123)
     *         .codingMode("codingMode")
     *         .dialnorm(123)
     *         .drcLine("drcLine")
     *         .drcRf("drcRf")
     *         .heightTrim(123)
     *         .surroundTrim(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3atmossettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3atmossettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.Eac3AtmosSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(Eac3AtmosSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Eac3AtmosSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3atmossettings.html#cfn-medialive-channel-eac3atmossettings-bitrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3atmossettings.html#cfn-medialive-channel-eac3atmossettings-bitrate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBitrate() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3atmossettings.html#cfn-medialive-channel-eac3atmossettings-codingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3atmossettings.html#cfn-medialive-channel-eac3atmossettings-codingmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCodingMode() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3atmossettings.html#cfn-medialive-channel-eac3atmossettings-dialnorm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3atmossettings.html#cfn-medialive-channel-eac3atmossettings-dialnorm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDialnorm() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3atmossettings.html#cfn-medialive-channel-eac3atmossettings-drcline">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3atmossettings.html#cfn-medialive-channel-eac3atmossettings-drcline</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDrcLine() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3atmossettings.html#cfn-medialive-channel-eac3atmossettings-drcrf">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3atmossettings.html#cfn-medialive-channel-eac3atmossettings-drcrf</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDrcRf() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3atmossettings.html#cfn-medialive-channel-eac3atmossettings-heighttrim">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3atmossettings.html#cfn-medialive-channel-eac3atmossettings-heighttrim</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHeightTrim() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3atmossettings.html#cfn-medialive-channel-eac3atmossettings-surroundtrim">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3atmossettings.html#cfn-medialive-channel-eac3atmossettings-surroundtrim</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSurroundTrim() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Eac3AtmosSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Eac3AtmosSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Eac3AtmosSettingsProperty> {
            java.lang.Number bitrate;
            java.lang.String codingMode;
            java.lang.Number dialnorm;
            java.lang.String drcLine;
            java.lang.String drcRf;
            java.lang.Number heightTrim;
            java.lang.Number surroundTrim;

            /**
             * Sets the value of {@link Eac3AtmosSettingsProperty#getBitrate}
             * @param bitrate the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bitrate(java.lang.Number bitrate) {
                this.bitrate = bitrate;
                return this;
            }

            /**
             * Sets the value of {@link Eac3AtmosSettingsProperty#getCodingMode}
             * @param codingMode the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codingMode(java.lang.String codingMode) {
                this.codingMode = codingMode;
                return this;
            }

            /**
             * Sets the value of {@link Eac3AtmosSettingsProperty#getDialnorm}
             * @param dialnorm the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dialnorm(java.lang.Number dialnorm) {
                this.dialnorm = dialnorm;
                return this;
            }

            /**
             * Sets the value of {@link Eac3AtmosSettingsProperty#getDrcLine}
             * @param drcLine the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder drcLine(java.lang.String drcLine) {
                this.drcLine = drcLine;
                return this;
            }

            /**
             * Sets the value of {@link Eac3AtmosSettingsProperty#getDrcRf}
             * @param drcRf the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder drcRf(java.lang.String drcRf) {
                this.drcRf = drcRf;
                return this;
            }

            /**
             * Sets the value of {@link Eac3AtmosSettingsProperty#getHeightTrim}
             * @param heightTrim the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder heightTrim(java.lang.Number heightTrim) {
                this.heightTrim = heightTrim;
                return this;
            }

            /**
             * Sets the value of {@link Eac3AtmosSettingsProperty#getSurroundTrim}
             * @param surroundTrim the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder surroundTrim(java.lang.Number surroundTrim) {
                this.surroundTrim = surroundTrim;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Eac3AtmosSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Eac3AtmosSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Eac3AtmosSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Eac3AtmosSettingsProperty {
            private final java.lang.Number bitrate;
            private final java.lang.String codingMode;
            private final java.lang.Number dialnorm;
            private final java.lang.String drcLine;
            private final java.lang.String drcRf;
            private final java.lang.Number heightTrim;
            private final java.lang.Number surroundTrim;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bitrate = software.amazon.jsii.Kernel.get(this, "bitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.codingMode = software.amazon.jsii.Kernel.get(this, "codingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dialnorm = software.amazon.jsii.Kernel.get(this, "dialnorm", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.drcLine = software.amazon.jsii.Kernel.get(this, "drcLine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.drcRf = software.amazon.jsii.Kernel.get(this, "drcRf", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.heightTrim = software.amazon.jsii.Kernel.get(this, "heightTrim", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.surroundTrim = software.amazon.jsii.Kernel.get(this, "surroundTrim", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bitrate = builder.bitrate;
                this.codingMode = builder.codingMode;
                this.dialnorm = builder.dialnorm;
                this.drcLine = builder.drcLine;
                this.drcRf = builder.drcRf;
                this.heightTrim = builder.heightTrim;
                this.surroundTrim = builder.surroundTrim;
            }

            @Override
            public final java.lang.Number getBitrate() {
                return this.bitrate;
            }

            @Override
            public final java.lang.String getCodingMode() {
                return this.codingMode;
            }

            @Override
            public final java.lang.Number getDialnorm() {
                return this.dialnorm;
            }

            @Override
            public final java.lang.String getDrcLine() {
                return this.drcLine;
            }

            @Override
            public final java.lang.String getDrcRf() {
                return this.drcRf;
            }

            @Override
            public final java.lang.Number getHeightTrim() {
                return this.heightTrim;
            }

            @Override
            public final java.lang.Number getSurroundTrim() {
                return this.surroundTrim;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBitrate() != null) {
                    data.set("bitrate", om.valueToTree(this.getBitrate()));
                }
                if (this.getCodingMode() != null) {
                    data.set("codingMode", om.valueToTree(this.getCodingMode()));
                }
                if (this.getDialnorm() != null) {
                    data.set("dialnorm", om.valueToTree(this.getDialnorm()));
                }
                if (this.getDrcLine() != null) {
                    data.set("drcLine", om.valueToTree(this.getDrcLine()));
                }
                if (this.getDrcRf() != null) {
                    data.set("drcRf", om.valueToTree(this.getDrcRf()));
                }
                if (this.getHeightTrim() != null) {
                    data.set("heightTrim", om.valueToTree(this.getHeightTrim()));
                }
                if (this.getSurroundTrim() != null) {
                    data.set("surroundTrim", om.valueToTree(this.getSurroundTrim()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.Eac3AtmosSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Eac3AtmosSettingsProperty.Jsii$Proxy that = (Eac3AtmosSettingsProperty.Jsii$Proxy) o;

                if (this.bitrate != null ? !this.bitrate.equals(that.bitrate) : that.bitrate != null) return false;
                if (this.codingMode != null ? !this.codingMode.equals(that.codingMode) : that.codingMode != null) return false;
                if (this.dialnorm != null ? !this.dialnorm.equals(that.dialnorm) : that.dialnorm != null) return false;
                if (this.drcLine != null ? !this.drcLine.equals(that.drcLine) : that.drcLine != null) return false;
                if (this.drcRf != null ? !this.drcRf.equals(that.drcRf) : that.drcRf != null) return false;
                if (this.heightTrim != null ? !this.heightTrim.equals(that.heightTrim) : that.heightTrim != null) return false;
                return this.surroundTrim != null ? this.surroundTrim.equals(that.surroundTrim) : that.surroundTrim == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bitrate != null ? this.bitrate.hashCode() : 0;
                result = 31 * result + (this.codingMode != null ? this.codingMode.hashCode() : 0);
                result = 31 * result + (this.dialnorm != null ? this.dialnorm.hashCode() : 0);
                result = 31 * result + (this.drcLine != null ? this.drcLine.hashCode() : 0);
                result = 31 * result + (this.drcRf != null ? this.drcRf.hashCode() : 0);
                result = 31 * result + (this.heightTrim != null ? this.heightTrim.hashCode() : 0);
                result = 31 * result + (this.surroundTrim != null ? this.surroundTrim.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for an EAC3 audio encode in the output.
     * <p>
     * The parent of this entity is AudioCodecSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * Eac3SettingsProperty eac3SettingsProperty = Eac3SettingsProperty.builder()
     *         .attenuationControl("attenuationControl")
     *         .bitrate(123)
     *         .bitstreamMode("bitstreamMode")
     *         .codingMode("codingMode")
     *         .dcFilter("dcFilter")
     *         .dialnorm(123)
     *         .drcLine("drcLine")
     *         .drcRf("drcRf")
     *         .lfeControl("lfeControl")
     *         .lfeFilter("lfeFilter")
     *         .loRoCenterMixLevel(123)
     *         .loRoSurroundMixLevel(123)
     *         .ltRtCenterMixLevel(123)
     *         .ltRtSurroundMixLevel(123)
     *         .metadataControl("metadataControl")
     *         .passthroughControl("passthroughControl")
     *         .phaseControl("phaseControl")
     *         .stereoDownmix("stereoDownmix")
     *         .surroundExMode("surroundExMode")
     *         .surroundMode("surroundMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.Eac3SettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(Eac3SettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Eac3SettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * When set to attenuate3Db, applies a 3 dB attenuation to the surround channels.
         * <p>
         * Used only for the 3/2 coding mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-attenuationcontrol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-attenuationcontrol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAttenuationControl() {
            return null;
        }

        /**
         * The average bitrate in bits/second.
         * <p>
         * Valid bitrates depend on the coding mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-bitrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-bitrate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBitrate() {
            return null;
        }

        /**
         * Specifies the bitstream mode (bsmod) for the emitted E-AC-3 stream.
         * <p>
         * For more information, see ATSC A/52-2012 (Annex E).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-bitstreammode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-bitstreammode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBitstreamMode() {
            return null;
        }

        /**
         * The Dolby Digital Plus coding mode.
         * <p>
         * This mode determines the number of channels.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-codingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-codingmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCodingMode() {
            return null;
        }

        /**
         * When set to enabled, activates a DC highpass filter for all input channels.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-dcfilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-dcfilter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDcFilter() {
            return null;
        }

        /**
         * Sets the dialnorm for the output.
         * <p>
         * If blank and the input audio is Dolby Digital Plus, dialnorm will be passed through.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-dialnorm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-dialnorm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDialnorm() {
            return null;
        }

        /**
         * Sets the Dolby dynamic range compression profile.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-drcline">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-drcline</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDrcLine() {
            return null;
        }

        /**
         * Sets the profile for heavy Dolby dynamic range compression, ensuring that the instantaneous signal peaks do not exceed specified levels.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-drcrf">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-drcrf</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDrcRf() {
            return null;
        }

        /**
         * When encoding 3/2 audio, setting to lfe enables the LFE channel.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-lfecontrol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-lfecontrol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLfeControl() {
            return null;
        }

        /**
         * When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding.
         * <p>
         * Valid only with a codingMode32 coding mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-lfefilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-lfefilter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLfeFilter() {
            return null;
        }

        /**
         * The Left only/Right only center mix level.
         * <p>
         * Used only for the 3/2 coding mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-lorocentermixlevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-lorocentermixlevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLoRoCenterMixLevel() {
            return null;
        }

        /**
         * The Left only/Right only surround mix level.
         * <p>
         * Used only for a 3/2 coding mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-lorosurroundmixlevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-lorosurroundmixlevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLoRoSurroundMixLevel() {
            return null;
        }

        /**
         * The Left total/Right total center mix level.
         * <p>
         * Used only for a 3/2 coding mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-ltrtcentermixlevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-ltrtcentermixlevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLtRtCenterMixLevel() {
            return null;
        }

        /**
         * The Left total/Right total surround mix level.
         * <p>
         * Used only for the 3/2 coding mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-ltrtsurroundmixlevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-ltrtsurroundmixlevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLtRtSurroundMixLevel() {
            return null;
        }

        /**
         * When set to followInput, encoder metadata is sourced from the DD, DD+, or DolbyE decoder that supplies this audio data.
         * <p>
         * If the audio is not supplied from one of these streams, then the static metadata settings are used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-metadatacontrol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-metadatacontrol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetadataControl() {
            return null;
        }

        /**
         * When set to whenPossible, input DD+ audio will be passed through if it is present on the input.
         * <p>
         * This detection is dynamic over the life of the transcode. Inputs that alternate between DD+ and non-DD+ content will have a consistent DD+ output as the system alternates between passthrough and encoding.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-passthroughcontrol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-passthroughcontrol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassthroughControl() {
            return null;
        }

        /**
         * When set to shift90Degrees, applies a 90-degree phase shift to the surround channels.
         * <p>
         * Used only for a 3/2 coding mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-phasecontrol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-phasecontrol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPhaseControl() {
            return null;
        }

        /**
         * A stereo downmix preference.
         * <p>
         * Used only for the 3/2 coding mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-stereodownmix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-stereodownmix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStereoDownmix() {
            return null;
        }

        /**
         * When encoding 3/2 audio, sets whether an extra center back surround channel is matrix encoded into the left and right surround channels.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-surroundexmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-surroundexmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSurroundExMode() {
            return null;
        }

        /**
         * When encoding 2/0 audio, sets whether Dolby Surround is matrix-encoded into the two channels.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-surroundmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-surroundmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSurroundMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Eac3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Eac3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Eac3SettingsProperty> {
            java.lang.String attenuationControl;
            java.lang.Number bitrate;
            java.lang.String bitstreamMode;
            java.lang.String codingMode;
            java.lang.String dcFilter;
            java.lang.Number dialnorm;
            java.lang.String drcLine;
            java.lang.String drcRf;
            java.lang.String lfeControl;
            java.lang.String lfeFilter;
            java.lang.Number loRoCenterMixLevel;
            java.lang.Number loRoSurroundMixLevel;
            java.lang.Number ltRtCenterMixLevel;
            java.lang.Number ltRtSurroundMixLevel;
            java.lang.String metadataControl;
            java.lang.String passthroughControl;
            java.lang.String phaseControl;
            java.lang.String stereoDownmix;
            java.lang.String surroundExMode;
            java.lang.String surroundMode;

            /**
             * Sets the value of {@link Eac3SettingsProperty#getAttenuationControl}
             * @param attenuationControl When set to attenuate3Db, applies a 3 dB attenuation to the surround channels.
             *                           Used only for the 3/2 coding mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attenuationControl(java.lang.String attenuationControl) {
                this.attenuationControl = attenuationControl;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getBitrate}
             * @param bitrate The average bitrate in bits/second.
             *                Valid bitrates depend on the coding mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bitrate(java.lang.Number bitrate) {
                this.bitrate = bitrate;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getBitstreamMode}
             * @param bitstreamMode Specifies the bitstream mode (bsmod) for the emitted E-AC-3 stream.
             *                      For more information, see ATSC A/52-2012 (Annex E).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bitstreamMode(java.lang.String bitstreamMode) {
                this.bitstreamMode = bitstreamMode;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getCodingMode}
             * @param codingMode The Dolby Digital Plus coding mode.
             *                   This mode determines the number of channels.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codingMode(java.lang.String codingMode) {
                this.codingMode = codingMode;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getDcFilter}
             * @param dcFilter When set to enabled, activates a DC highpass filter for all input channels.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dcFilter(java.lang.String dcFilter) {
                this.dcFilter = dcFilter;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getDialnorm}
             * @param dialnorm Sets the dialnorm for the output.
             *                 If blank and the input audio is Dolby Digital Plus, dialnorm will be passed through.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dialnorm(java.lang.Number dialnorm) {
                this.dialnorm = dialnorm;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getDrcLine}
             * @param drcLine Sets the Dolby dynamic range compression profile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder drcLine(java.lang.String drcLine) {
                this.drcLine = drcLine;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getDrcRf}
             * @param drcRf Sets the profile for heavy Dolby dynamic range compression, ensuring that the instantaneous signal peaks do not exceed specified levels.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder drcRf(java.lang.String drcRf) {
                this.drcRf = drcRf;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getLfeControl}
             * @param lfeControl When encoding 3/2 audio, setting to lfe enables the LFE channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lfeControl(java.lang.String lfeControl) {
                this.lfeControl = lfeControl;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getLfeFilter}
             * @param lfeFilter When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding.
             *                  Valid only with a codingMode32 coding mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lfeFilter(java.lang.String lfeFilter) {
                this.lfeFilter = lfeFilter;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getLoRoCenterMixLevel}
             * @param loRoCenterMixLevel The Left only/Right only center mix level.
             *                           Used only for the 3/2 coding mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loRoCenterMixLevel(java.lang.Number loRoCenterMixLevel) {
                this.loRoCenterMixLevel = loRoCenterMixLevel;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getLoRoSurroundMixLevel}
             * @param loRoSurroundMixLevel The Left only/Right only surround mix level.
             *                             Used only for a 3/2 coding mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loRoSurroundMixLevel(java.lang.Number loRoSurroundMixLevel) {
                this.loRoSurroundMixLevel = loRoSurroundMixLevel;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getLtRtCenterMixLevel}
             * @param ltRtCenterMixLevel The Left total/Right total center mix level.
             *                           Used only for a 3/2 coding mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ltRtCenterMixLevel(java.lang.Number ltRtCenterMixLevel) {
                this.ltRtCenterMixLevel = ltRtCenterMixLevel;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getLtRtSurroundMixLevel}
             * @param ltRtSurroundMixLevel The Left total/Right total surround mix level.
             *                             Used only for the 3/2 coding mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ltRtSurroundMixLevel(java.lang.Number ltRtSurroundMixLevel) {
                this.ltRtSurroundMixLevel = ltRtSurroundMixLevel;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getMetadataControl}
             * @param metadataControl When set to followInput, encoder metadata is sourced from the DD, DD+, or DolbyE decoder that supplies this audio data.
             *                        If the audio is not supplied from one of these streams, then the static metadata settings are used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadataControl(java.lang.String metadataControl) {
                this.metadataControl = metadataControl;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getPassthroughControl}
             * @param passthroughControl When set to whenPossible, input DD+ audio will be passed through if it is present on the input.
             *                           This detection is dynamic over the life of the transcode. Inputs that alternate between DD+ and non-DD+ content will have a consistent DD+ output as the system alternates between passthrough and encoding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder passthroughControl(java.lang.String passthroughControl) {
                this.passthroughControl = passthroughControl;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getPhaseControl}
             * @param phaseControl When set to shift90Degrees, applies a 90-degree phase shift to the surround channels.
             *                     Used only for a 3/2 coding mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phaseControl(java.lang.String phaseControl) {
                this.phaseControl = phaseControl;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getStereoDownmix}
             * @param stereoDownmix A stereo downmix preference.
             *                      Used only for the 3/2 coding mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stereoDownmix(java.lang.String stereoDownmix) {
                this.stereoDownmix = stereoDownmix;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getSurroundExMode}
             * @param surroundExMode When encoding 3/2 audio, sets whether an extra center back surround channel is matrix encoded into the left and right surround channels.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder surroundExMode(java.lang.String surroundExMode) {
                this.surroundExMode = surroundExMode;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getSurroundMode}
             * @param surroundMode When encoding 2/0 audio, sets whether Dolby Surround is matrix-encoded into the two channels.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder surroundMode(java.lang.String surroundMode) {
                this.surroundMode = surroundMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Eac3SettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Eac3SettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Eac3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Eac3SettingsProperty {
            private final java.lang.String attenuationControl;
            private final java.lang.Number bitrate;
            private final java.lang.String bitstreamMode;
            private final java.lang.String codingMode;
            private final java.lang.String dcFilter;
            private final java.lang.Number dialnorm;
            private final java.lang.String drcLine;
            private final java.lang.String drcRf;
            private final java.lang.String lfeControl;
            private final java.lang.String lfeFilter;
            private final java.lang.Number loRoCenterMixLevel;
            private final java.lang.Number loRoSurroundMixLevel;
            private final java.lang.Number ltRtCenterMixLevel;
            private final java.lang.Number ltRtSurroundMixLevel;
            private final java.lang.String metadataControl;
            private final java.lang.String passthroughControl;
            private final java.lang.String phaseControl;
            private final java.lang.String stereoDownmix;
            private final java.lang.String surroundExMode;
            private final java.lang.String surroundMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attenuationControl = software.amazon.jsii.Kernel.get(this, "attenuationControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bitrate = software.amazon.jsii.Kernel.get(this, "bitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.bitstreamMode = software.amazon.jsii.Kernel.get(this, "bitstreamMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.codingMode = software.amazon.jsii.Kernel.get(this, "codingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dcFilter = software.amazon.jsii.Kernel.get(this, "dcFilter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dialnorm = software.amazon.jsii.Kernel.get(this, "dialnorm", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.drcLine = software.amazon.jsii.Kernel.get(this, "drcLine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.drcRf = software.amazon.jsii.Kernel.get(this, "drcRf", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lfeControl = software.amazon.jsii.Kernel.get(this, "lfeControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lfeFilter = software.amazon.jsii.Kernel.get(this, "lfeFilter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.loRoCenterMixLevel = software.amazon.jsii.Kernel.get(this, "loRoCenterMixLevel", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.loRoSurroundMixLevel = software.amazon.jsii.Kernel.get(this, "loRoSurroundMixLevel", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ltRtCenterMixLevel = software.amazon.jsii.Kernel.get(this, "ltRtCenterMixLevel", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ltRtSurroundMixLevel = software.amazon.jsii.Kernel.get(this, "ltRtSurroundMixLevel", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.metadataControl = software.amazon.jsii.Kernel.get(this, "metadataControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.passthroughControl = software.amazon.jsii.Kernel.get(this, "passthroughControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.phaseControl = software.amazon.jsii.Kernel.get(this, "phaseControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stereoDownmix = software.amazon.jsii.Kernel.get(this, "stereoDownmix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.surroundExMode = software.amazon.jsii.Kernel.get(this, "surroundExMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.surroundMode = software.amazon.jsii.Kernel.get(this, "surroundMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attenuationControl = builder.attenuationControl;
                this.bitrate = builder.bitrate;
                this.bitstreamMode = builder.bitstreamMode;
                this.codingMode = builder.codingMode;
                this.dcFilter = builder.dcFilter;
                this.dialnorm = builder.dialnorm;
                this.drcLine = builder.drcLine;
                this.drcRf = builder.drcRf;
                this.lfeControl = builder.lfeControl;
                this.lfeFilter = builder.lfeFilter;
                this.loRoCenterMixLevel = builder.loRoCenterMixLevel;
                this.loRoSurroundMixLevel = builder.loRoSurroundMixLevel;
                this.ltRtCenterMixLevel = builder.ltRtCenterMixLevel;
                this.ltRtSurroundMixLevel = builder.ltRtSurroundMixLevel;
                this.metadataControl = builder.metadataControl;
                this.passthroughControl = builder.passthroughControl;
                this.phaseControl = builder.phaseControl;
                this.stereoDownmix = builder.stereoDownmix;
                this.surroundExMode = builder.surroundExMode;
                this.surroundMode = builder.surroundMode;
            }

            @Override
            public final java.lang.String getAttenuationControl() {
                return this.attenuationControl;
            }

            @Override
            public final java.lang.Number getBitrate() {
                return this.bitrate;
            }

            @Override
            public final java.lang.String getBitstreamMode() {
                return this.bitstreamMode;
            }

            @Override
            public final java.lang.String getCodingMode() {
                return this.codingMode;
            }

            @Override
            public final java.lang.String getDcFilter() {
                return this.dcFilter;
            }

            @Override
            public final java.lang.Number getDialnorm() {
                return this.dialnorm;
            }

            @Override
            public final java.lang.String getDrcLine() {
                return this.drcLine;
            }

            @Override
            public final java.lang.String getDrcRf() {
                return this.drcRf;
            }

            @Override
            public final java.lang.String getLfeControl() {
                return this.lfeControl;
            }

            @Override
            public final java.lang.String getLfeFilter() {
                return this.lfeFilter;
            }

            @Override
            public final java.lang.Number getLoRoCenterMixLevel() {
                return this.loRoCenterMixLevel;
            }

            @Override
            public final java.lang.Number getLoRoSurroundMixLevel() {
                return this.loRoSurroundMixLevel;
            }

            @Override
            public final java.lang.Number getLtRtCenterMixLevel() {
                return this.ltRtCenterMixLevel;
            }

            @Override
            public final java.lang.Number getLtRtSurroundMixLevel() {
                return this.ltRtSurroundMixLevel;
            }

            @Override
            public final java.lang.String getMetadataControl() {
                return this.metadataControl;
            }

            @Override
            public final java.lang.String getPassthroughControl() {
                return this.passthroughControl;
            }

            @Override
            public final java.lang.String getPhaseControl() {
                return this.phaseControl;
            }

            @Override
            public final java.lang.String getStereoDownmix() {
                return this.stereoDownmix;
            }

            @Override
            public final java.lang.String getSurroundExMode() {
                return this.surroundExMode;
            }

            @Override
            public final java.lang.String getSurroundMode() {
                return this.surroundMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttenuationControl() != null) {
                    data.set("attenuationControl", om.valueToTree(this.getAttenuationControl()));
                }
                if (this.getBitrate() != null) {
                    data.set("bitrate", om.valueToTree(this.getBitrate()));
                }
                if (this.getBitstreamMode() != null) {
                    data.set("bitstreamMode", om.valueToTree(this.getBitstreamMode()));
                }
                if (this.getCodingMode() != null) {
                    data.set("codingMode", om.valueToTree(this.getCodingMode()));
                }
                if (this.getDcFilter() != null) {
                    data.set("dcFilter", om.valueToTree(this.getDcFilter()));
                }
                if (this.getDialnorm() != null) {
                    data.set("dialnorm", om.valueToTree(this.getDialnorm()));
                }
                if (this.getDrcLine() != null) {
                    data.set("drcLine", om.valueToTree(this.getDrcLine()));
                }
                if (this.getDrcRf() != null) {
                    data.set("drcRf", om.valueToTree(this.getDrcRf()));
                }
                if (this.getLfeControl() != null) {
                    data.set("lfeControl", om.valueToTree(this.getLfeControl()));
                }
                if (this.getLfeFilter() != null) {
                    data.set("lfeFilter", om.valueToTree(this.getLfeFilter()));
                }
                if (this.getLoRoCenterMixLevel() != null) {
                    data.set("loRoCenterMixLevel", om.valueToTree(this.getLoRoCenterMixLevel()));
                }
                if (this.getLoRoSurroundMixLevel() != null) {
                    data.set("loRoSurroundMixLevel", om.valueToTree(this.getLoRoSurroundMixLevel()));
                }
                if (this.getLtRtCenterMixLevel() != null) {
                    data.set("ltRtCenterMixLevel", om.valueToTree(this.getLtRtCenterMixLevel()));
                }
                if (this.getLtRtSurroundMixLevel() != null) {
                    data.set("ltRtSurroundMixLevel", om.valueToTree(this.getLtRtSurroundMixLevel()));
                }
                if (this.getMetadataControl() != null) {
                    data.set("metadataControl", om.valueToTree(this.getMetadataControl()));
                }
                if (this.getPassthroughControl() != null) {
                    data.set("passthroughControl", om.valueToTree(this.getPassthroughControl()));
                }
                if (this.getPhaseControl() != null) {
                    data.set("phaseControl", om.valueToTree(this.getPhaseControl()));
                }
                if (this.getStereoDownmix() != null) {
                    data.set("stereoDownmix", om.valueToTree(this.getStereoDownmix()));
                }
                if (this.getSurroundExMode() != null) {
                    data.set("surroundExMode", om.valueToTree(this.getSurroundExMode()));
                }
                if (this.getSurroundMode() != null) {
                    data.set("surroundMode", om.valueToTree(this.getSurroundMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.Eac3SettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Eac3SettingsProperty.Jsii$Proxy that = (Eac3SettingsProperty.Jsii$Proxy) o;

                if (this.attenuationControl != null ? !this.attenuationControl.equals(that.attenuationControl) : that.attenuationControl != null) return false;
                if (this.bitrate != null ? !this.bitrate.equals(that.bitrate) : that.bitrate != null) return false;
                if (this.bitstreamMode != null ? !this.bitstreamMode.equals(that.bitstreamMode) : that.bitstreamMode != null) return false;
                if (this.codingMode != null ? !this.codingMode.equals(that.codingMode) : that.codingMode != null) return false;
                if (this.dcFilter != null ? !this.dcFilter.equals(that.dcFilter) : that.dcFilter != null) return false;
                if (this.dialnorm != null ? !this.dialnorm.equals(that.dialnorm) : that.dialnorm != null) return false;
                if (this.drcLine != null ? !this.drcLine.equals(that.drcLine) : that.drcLine != null) return false;
                if (this.drcRf != null ? !this.drcRf.equals(that.drcRf) : that.drcRf != null) return false;
                if (this.lfeControl != null ? !this.lfeControl.equals(that.lfeControl) : that.lfeControl != null) return false;
                if (this.lfeFilter != null ? !this.lfeFilter.equals(that.lfeFilter) : that.lfeFilter != null) return false;
                if (this.loRoCenterMixLevel != null ? !this.loRoCenterMixLevel.equals(that.loRoCenterMixLevel) : that.loRoCenterMixLevel != null) return false;
                if (this.loRoSurroundMixLevel != null ? !this.loRoSurroundMixLevel.equals(that.loRoSurroundMixLevel) : that.loRoSurroundMixLevel != null) return false;
                if (this.ltRtCenterMixLevel != null ? !this.ltRtCenterMixLevel.equals(that.ltRtCenterMixLevel) : that.ltRtCenterMixLevel != null) return false;
                if (this.ltRtSurroundMixLevel != null ? !this.ltRtSurroundMixLevel.equals(that.ltRtSurroundMixLevel) : that.ltRtSurroundMixLevel != null) return false;
                if (this.metadataControl != null ? !this.metadataControl.equals(that.metadataControl) : that.metadataControl != null) return false;
                if (this.passthroughControl != null ? !this.passthroughControl.equals(that.passthroughControl) : that.passthroughControl != null) return false;
                if (this.phaseControl != null ? !this.phaseControl.equals(that.phaseControl) : that.phaseControl != null) return false;
                if (this.stereoDownmix != null ? !this.stereoDownmix.equals(that.stereoDownmix) : that.stereoDownmix != null) return false;
                if (this.surroundExMode != null ? !this.surroundExMode.equals(that.surroundExMode) : that.surroundExMode != null) return false;
                return this.surroundMode != null ? this.surroundMode.equals(that.surroundMode) : that.surroundMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attenuationControl != null ? this.attenuationControl.hashCode() : 0;
                result = 31 * result + (this.bitrate != null ? this.bitrate.hashCode() : 0);
                result = 31 * result + (this.bitstreamMode != null ? this.bitstreamMode.hashCode() : 0);
                result = 31 * result + (this.codingMode != null ? this.codingMode.hashCode() : 0);
                result = 31 * result + (this.dcFilter != null ? this.dcFilter.hashCode() : 0);
                result = 31 * result + (this.dialnorm != null ? this.dialnorm.hashCode() : 0);
                result = 31 * result + (this.drcLine != null ? this.drcLine.hashCode() : 0);
                result = 31 * result + (this.drcRf != null ? this.drcRf.hashCode() : 0);
                result = 31 * result + (this.lfeControl != null ? this.lfeControl.hashCode() : 0);
                result = 31 * result + (this.lfeFilter != null ? this.lfeFilter.hashCode() : 0);
                result = 31 * result + (this.loRoCenterMixLevel != null ? this.loRoCenterMixLevel.hashCode() : 0);
                result = 31 * result + (this.loRoSurroundMixLevel != null ? this.loRoSurroundMixLevel.hashCode() : 0);
                result = 31 * result + (this.ltRtCenterMixLevel != null ? this.ltRtCenterMixLevel.hashCode() : 0);
                result = 31 * result + (this.ltRtSurroundMixLevel != null ? this.ltRtSurroundMixLevel.hashCode() : 0);
                result = 31 * result + (this.metadataControl != null ? this.metadataControl.hashCode() : 0);
                result = 31 * result + (this.passthroughControl != null ? this.passthroughControl.hashCode() : 0);
                result = 31 * result + (this.phaseControl != null ? this.phaseControl.hashCode() : 0);
                result = 31 * result + (this.stereoDownmix != null ? this.stereoDownmix.hashCode() : 0);
                result = 31 * result + (this.surroundExMode != null ? this.surroundExMode.hashCode() : 0);
                result = 31 * result + (this.surroundMode != null ? this.surroundMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings for EBU-TT captions in the output.
     * <p>
     * The parent of this entity is CaptionDestinationSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * EbuTtDDestinationSettingsProperty ebuTtDDestinationSettingsProperty = EbuTtDDestinationSettingsProperty.builder()
     *         .copyrightHolder("copyrightHolder")
     *         .defaultFontSize(123)
     *         .defaultLineHeight(123)
     *         .fillLineGap("fillLineGap")
     *         .fontFamily("fontFamily")
     *         .styleControl("styleControl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.EbuTtDDestinationSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(EbuTtDDestinationSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EbuTtDDestinationSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Applies only if you plan to convert these source captions to EBU-TT-D or TTML in an output.
         * <p>
         * Complete this field if you want to include the name of the copyright holder in the copyright metadata tag in the TTML
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html#cfn-medialive-channel-ebuttddestinationsettings-copyrightholder">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html#cfn-medialive-channel-ebuttddestinationsettings-copyrightholder</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCopyrightHolder() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html#cfn-medialive-channel-ebuttddestinationsettings-defaultfontsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html#cfn-medialive-channel-ebuttddestinationsettings-defaultfontsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDefaultFontSize() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html#cfn-medialive-channel-ebuttddestinationsettings-defaultlineheight">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html#cfn-medialive-channel-ebuttddestinationsettings-defaultlineheight</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDefaultLineHeight() {
            return null;
        }

        /**
         * Specifies how to handle the gap between the lines (in multi-line captions).
         * <p>
         * <ul>
         * <li>enabled: Fill with the captions background color (as specified in the input captions).</li>
         * <li>disabled: Leave the gap unfilled.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html#cfn-medialive-channel-ebuttddestinationsettings-filllinegap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html#cfn-medialive-channel-ebuttddestinationsettings-filllinegap</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFillLineGap() {
            return null;
        }

        /**
         * Specifies the font family to include in the font data attached to the EBU-TT captions.
         * <p>
         * Valid only if styleControl is set to include. If you leave this field empty, the font family is set to "monospaced". (If styleControl is set to exclude, the font family is always set to "monospaced".) You specify only the font family. All other style information (color, bold, position and so on) is copied from the input captions. The size is always set to 100% to allow the downstream player to choose the size. - Enter a list of font families, as a comma-separated list of font names, in order of preference. The name can be a font family (such as “Arial”), or a generic font family (such as “serif”), or “default” (to let the downstream player choose the font).
         * <p>
         * <ul>
         * <li>Leave blank to set the family to “monospace”.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html#cfn-medialive-channel-ebuttddestinationsettings-fontfamily">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html#cfn-medialive-channel-ebuttddestinationsettings-fontfamily</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFontFamily() {
            return null;
        }

        /**
         * Specifies the style information (font color, font position, and so on) to include in the font data that is attached to the EBU-TT captions.
         * <p>
         * <ul>
         * <li>include: Take the style information (font color, font position, and so on) from the source captions and include that information in the font data attached to the EBU-TT captions. This option is valid only if the source captions are Embedded or Teletext.</li>
         * <li>exclude: In the font data attached to the EBU-TT captions, set the font family to "monospaced". Do not include any other style information.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html#cfn-medialive-channel-ebuttddestinationsettings-stylecontrol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html#cfn-medialive-channel-ebuttddestinationsettings-stylecontrol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStyleControl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EbuTtDDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EbuTtDDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EbuTtDDestinationSettingsProperty> {
            java.lang.String copyrightHolder;
            java.lang.Number defaultFontSize;
            java.lang.Number defaultLineHeight;
            java.lang.String fillLineGap;
            java.lang.String fontFamily;
            java.lang.String styleControl;

            /**
             * Sets the value of {@link EbuTtDDestinationSettingsProperty#getCopyrightHolder}
             * @param copyrightHolder Applies only if you plan to convert these source captions to EBU-TT-D or TTML in an output.
             *                        Complete this field if you want to include the name of the copyright holder in the copyright metadata tag in the TTML
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyrightHolder(java.lang.String copyrightHolder) {
                this.copyrightHolder = copyrightHolder;
                return this;
            }

            /**
             * Sets the value of {@link EbuTtDDestinationSettingsProperty#getDefaultFontSize}
             * @param defaultFontSize the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultFontSize(java.lang.Number defaultFontSize) {
                this.defaultFontSize = defaultFontSize;
                return this;
            }

            /**
             * Sets the value of {@link EbuTtDDestinationSettingsProperty#getDefaultLineHeight}
             * @param defaultLineHeight the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultLineHeight(java.lang.Number defaultLineHeight) {
                this.defaultLineHeight = defaultLineHeight;
                return this;
            }

            /**
             * Sets the value of {@link EbuTtDDestinationSettingsProperty#getFillLineGap}
             * @param fillLineGap Specifies how to handle the gap between the lines (in multi-line captions).
             *                    <ul>
             *                    <li>enabled: Fill with the captions background color (as specified in the input captions).</li>
             *                    <li>disabled: Leave the gap unfilled.</li>
             *                    </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fillLineGap(java.lang.String fillLineGap) {
                this.fillLineGap = fillLineGap;
                return this;
            }

            /**
             * Sets the value of {@link EbuTtDDestinationSettingsProperty#getFontFamily}
             * @param fontFamily Specifies the font family to include in the font data attached to the EBU-TT captions.
             *                   Valid only if styleControl is set to include. If you leave this field empty, the font family is set to "monospaced". (If styleControl is set to exclude, the font family is always set to "monospaced".) You specify only the font family. All other style information (color, bold, position and so on) is copied from the input captions. The size is always set to 100% to allow the downstream player to choose the size. - Enter a list of font families, as a comma-separated list of font names, in order of preference. The name can be a font family (such as “Arial”), or a generic font family (such as “serif”), or “default” (to let the downstream player choose the font).
             *                   <p>
             *                   <ul>
             *                   <li>Leave blank to set the family to “monospace”.</li>
             *                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontFamily(java.lang.String fontFamily) {
                this.fontFamily = fontFamily;
                return this;
            }

            /**
             * Sets the value of {@link EbuTtDDestinationSettingsProperty#getStyleControl}
             * @param styleControl Specifies the style information (font color, font position, and so on) to include in the font data that is attached to the EBU-TT captions.
             *                     <ul>
             *                     <li>include: Take the style information (font color, font position, and so on) from the source captions and include that information in the font data attached to the EBU-TT captions. This option is valid only if the source captions are Embedded or Teletext.</li>
             *                     <li>exclude: In the font data attached to the EBU-TT captions, set the font family to "monospaced". Do not include any other style information.</li>
             *                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder styleControl(java.lang.String styleControl) {
                this.styleControl = styleControl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbuTtDDestinationSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EbuTtDDestinationSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EbuTtDDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EbuTtDDestinationSettingsProperty {
            private final java.lang.String copyrightHolder;
            private final java.lang.Number defaultFontSize;
            private final java.lang.Number defaultLineHeight;
            private final java.lang.String fillLineGap;
            private final java.lang.String fontFamily;
            private final java.lang.String styleControl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.copyrightHolder = software.amazon.jsii.Kernel.get(this, "copyrightHolder", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultFontSize = software.amazon.jsii.Kernel.get(this, "defaultFontSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.defaultLineHeight = software.amazon.jsii.Kernel.get(this, "defaultLineHeight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.fillLineGap = software.amazon.jsii.Kernel.get(this, "fillLineGap", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fontFamily = software.amazon.jsii.Kernel.get(this, "fontFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.styleControl = software.amazon.jsii.Kernel.get(this, "styleControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.copyrightHolder = builder.copyrightHolder;
                this.defaultFontSize = builder.defaultFontSize;
                this.defaultLineHeight = builder.defaultLineHeight;
                this.fillLineGap = builder.fillLineGap;
                this.fontFamily = builder.fontFamily;
                this.styleControl = builder.styleControl;
            }

            @Override
            public final java.lang.String getCopyrightHolder() {
                return this.copyrightHolder;
            }

            @Override
            public final java.lang.Number getDefaultFontSize() {
                return this.defaultFontSize;
            }

            @Override
            public final java.lang.Number getDefaultLineHeight() {
                return this.defaultLineHeight;
            }

            @Override
            public final java.lang.String getFillLineGap() {
                return this.fillLineGap;
            }

            @Override
            public final java.lang.String getFontFamily() {
                return this.fontFamily;
            }

            @Override
            public final java.lang.String getStyleControl() {
                return this.styleControl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCopyrightHolder() != null) {
                    data.set("copyrightHolder", om.valueToTree(this.getCopyrightHolder()));
                }
                if (this.getDefaultFontSize() != null) {
                    data.set("defaultFontSize", om.valueToTree(this.getDefaultFontSize()));
                }
                if (this.getDefaultLineHeight() != null) {
                    data.set("defaultLineHeight", om.valueToTree(this.getDefaultLineHeight()));
                }
                if (this.getFillLineGap() != null) {
                    data.set("fillLineGap", om.valueToTree(this.getFillLineGap()));
                }
                if (this.getFontFamily() != null) {
                    data.set("fontFamily", om.valueToTree(this.getFontFamily()));
                }
                if (this.getStyleControl() != null) {
                    data.set("styleControl", om.valueToTree(this.getStyleControl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.EbuTtDDestinationSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EbuTtDDestinationSettingsProperty.Jsii$Proxy that = (EbuTtDDestinationSettingsProperty.Jsii$Proxy) o;

                if (this.copyrightHolder != null ? !this.copyrightHolder.equals(that.copyrightHolder) : that.copyrightHolder != null) return false;
                if (this.defaultFontSize != null ? !this.defaultFontSize.equals(that.defaultFontSize) : that.defaultFontSize != null) return false;
                if (this.defaultLineHeight != null ? !this.defaultLineHeight.equals(that.defaultLineHeight) : that.defaultLineHeight != null) return false;
                if (this.fillLineGap != null ? !this.fillLineGap.equals(that.fillLineGap) : that.fillLineGap != null) return false;
                if (this.fontFamily != null ? !this.fontFamily.equals(that.fontFamily) : that.fontFamily != null) return false;
                return this.styleControl != null ? this.styleControl.equals(that.styleControl) : that.styleControl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.copyrightHolder != null ? this.copyrightHolder.hashCode() : 0;
                result = 31 * result + (this.defaultFontSize != null ? this.defaultFontSize.hashCode() : 0);
                result = 31 * result + (this.defaultLineHeight != null ? this.defaultLineHeight.hashCode() : 0);
                result = 31 * result + (this.fillLineGap != null ? this.fillLineGap.hashCode() : 0);
                result = 31 * result + (this.fontFamily != null ? this.fontFamily.hashCode() : 0);
                result = 31 * result + (this.styleControl != null ? this.styleControl.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * EmbeddedDestinationSettingsProperty embeddedDestinationSettingsProperty = EmbeddedDestinationSettingsProperty.builder().build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddeddestinationsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddeddestinationsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.EmbeddedDestinationSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(EmbeddedDestinationSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EmbeddedDestinationSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @return a {@link Builder} of {@link EmbeddedDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EmbeddedDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EmbeddedDestinationSettingsProperty> {

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmbeddedDestinationSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EmbeddedDestinationSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EmbeddedDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmbeddedDestinationSettingsProperty {

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();


                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.EmbeddedDestinationSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * EmbeddedPlusScte20DestinationSettingsProperty embeddedPlusScte20DestinationSettingsProperty = EmbeddedPlusScte20DestinationSettingsProperty.builder().build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedplusscte20destinationsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedplusscte20destinationsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.EmbeddedPlusScte20DestinationSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(EmbeddedPlusScte20DestinationSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EmbeddedPlusScte20DestinationSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @return a {@link Builder} of {@link EmbeddedPlusScte20DestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EmbeddedPlusScte20DestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EmbeddedPlusScte20DestinationSettingsProperty> {

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmbeddedPlusScte20DestinationSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EmbeddedPlusScte20DestinationSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EmbeddedPlusScte20DestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmbeddedPlusScte20DestinationSettingsProperty {

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();


                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.EmbeddedPlusScte20DestinationSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }
        }
    }
    /**
     * Information about the embedded captions to extract from the input.
     * <p>
     * The parent of this entity is CaptionSelectorSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * EmbeddedSourceSettingsProperty embeddedSourceSettingsProperty = EmbeddedSourceSettingsProperty.builder()
     *         .convert608To708("convert608To708")
     *         .scte20Detection("scte20Detection")
     *         .source608ChannelNumber(123)
     *         .source608TrackNumber(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedsourcesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedsourcesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.EmbeddedSourceSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(EmbeddedSourceSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EmbeddedSourceSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If this is upconvert, 608 data is both passed