package software.amazon.awscdk.services.networkfirewall;

/**
 * Properties for defining a <code>CfnFirewall</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkfirewall.*;
 * CfnFirewallProps cfnFirewallProps = CfnFirewallProps.builder()
 *         .firewallName("firewallName")
 *         .firewallPolicyArn("firewallPolicyArn")
 *         // the properties below are optional
 *         .availabilityZoneChangeProtection(false)
 *         .availabilityZoneMappings(List.of(AvailabilityZoneMappingProperty.builder()
 *                 .availabilityZone("availabilityZone")
 *                 .build()))
 *         .deleteProtection(false)
 *         .description("description")
 *         .enabledAnalysisTypes(List.of("enabledAnalysisTypes"))
 *         .firewallPolicyChangeProtection(false)
 *         .subnetChangeProtection(false)
 *         .subnetMappings(List.of(SubnetMappingProperty.builder()
 *                 .subnetId("subnetId")
 *                 // the properties below are optional
 *                 .ipAddressType("ipAddressType")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .transitGatewayId("transitGatewayId")
 *         .vpcId("vpcId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:56.134Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnFirewallProps")
@software.amazon.jsii.Jsii.Proxy(CfnFirewallProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFirewallProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The descriptive name of the firewall.
     * <p>
     * You can't change the name of a firewall after you create it.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-firewallname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-firewallname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFirewallName();

    /**
     * The Amazon Resource Name (ARN) of the firewall policy.
     * <p>
     * The relationship of firewall to firewall policy is many to one. Each firewall requires one firewall policy association, and you can use the same firewall policy for multiple firewalls.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-firewallpolicyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-firewallpolicyarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFirewallPolicyArn();

    /**
     * A setting indicating whether the firewall is protected against changes to its Availability Zone configuration.
     * <p>
     * When set to <code>TRUE</code> , you must first disable this protection before adding or removing Availability Zones.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-availabilityzonechangeprotection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-availabilityzonechangeprotection</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAvailabilityZoneChangeProtection() {
        return null;
    }

    /**
     * The Availability Zones where the firewall endpoints are created for a transit gateway-attached firewall.
     * <p>
     * Each mapping specifies an Availability Zone where the firewall processes traffic.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.networkfirewall.CfnFirewall.AvailabilityZoneMappingProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-availabilityzonemappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-availabilityzonemappings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAvailabilityZoneMappings() {
        return null;
    }

    /**
     * A flag indicating whether it is possible to delete the firewall.
     * <p>
     * A setting of <code>TRUE</code> indicates that the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code> .
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-deleteprotection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-deleteprotection</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteProtection() {
        return null;
    }

    /**
     * A description of the firewall.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * An optional setting indicating the specific traffic analysis types to enable on the firewall.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-enabledanalysistypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-enabledanalysistypes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEnabledAnalysisTypes() {
        return null;
    }

    /**
     * A setting indicating whether the firewall is protected against a change to the firewall policy association.
     * <p>
     * Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code> .
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-firewallpolicychangeprotection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-firewallpolicychangeprotection</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFirewallPolicyChangeProtection() {
        return null;
    }

    /**
     * A setting indicating whether the firewall is protected against changes to the subnet associations.
     * <p>
     * Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code> .
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-subnetchangeprotection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-subnetchangeprotection</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSubnetChangeProtection() {
        return null;
    }

    /**
     * The primary public subnets that Network Firewall is using for the firewall.
     * <p>
     * Network Firewall creates a firewall endpoint in each subnet. Create a subnet mapping for each Availability Zone where you want to use the firewall.
     * <p>
     * These subnets are all defined for a single, primary VPC, and each must belong to a different Availability Zone. Each of these subnets establishes the availability of the firewall in its Availability Zone.
     * <p>
     * In addition to these subnets, you can define other endpoints for the firewall in <code>VpcEndpointAssociation</code> resources. You can define these additional endpoints for any VPC, and for any of the Availability Zones where the firewall resource already has a subnet mapping. VPC endpoint associations give you the ability to protect multiple VPCs using a single firewall, and to define multiple firewall endpoints for a VPC in a single Availability Zone.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.networkfirewall.CfnFirewall.SubnetMappingProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-subnetmappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-subnetmappings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSubnetMappings() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The unique identifier of the transit gateway associated with this firewall.
     * <p>
     * This field is only present for transit gateway-attached firewalls.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-transitgatewayid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-transitgatewayid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTransitGatewayId() {
        return null;
    }

    /**
     * The unique identifier of the VPC where the firewall is in use.
     * <p>
     * You can't change the VPC of a firewall after you create the firewall.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-vpcid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-firewall.html#cfn-networkfirewall-firewall-vpcid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFirewallProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFirewallProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFirewallProps> {
        java.lang.String firewallName;
        java.lang.String firewallPolicyArn;
        java.lang.Object availabilityZoneChangeProtection;
        java.lang.Object availabilityZoneMappings;
        java.lang.Object deleteProtection;
        java.lang.String description;
        java.util.List<java.lang.String> enabledAnalysisTypes;
        java.lang.Object firewallPolicyChangeProtection;
        java.lang.Object subnetChangeProtection;
        java.lang.Object subnetMappings;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String transitGatewayId;
        java.lang.String vpcId;

        /**
         * Sets the value of {@link CfnFirewallProps#getFirewallName}
         * @param firewallName The descriptive name of the firewall. This parameter is required.
         *                     You can't change the name of a firewall after you create it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallName(java.lang.String firewallName) {
            this.firewallName = firewallName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getFirewallPolicyArn}
         * @param firewallPolicyArn The Amazon Resource Name (ARN) of the firewall policy. This parameter is required.
         *                          The relationship of firewall to firewall policy is many to one. Each firewall requires one firewall policy association, and you can use the same firewall policy for multiple firewalls.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallPolicyArn(java.lang.String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getAvailabilityZoneChangeProtection}
         * @param availabilityZoneChangeProtection A setting indicating whether the firewall is protected against changes to its Availability Zone configuration.
         *                                         When set to <code>TRUE</code> , you must first disable this protection before adding or removing Availability Zones.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneChangeProtection(java.lang.Boolean availabilityZoneChangeProtection) {
            this.availabilityZoneChangeProtection = availabilityZoneChangeProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getAvailabilityZoneChangeProtection}
         * @param availabilityZoneChangeProtection A setting indicating whether the firewall is protected against changes to its Availability Zone configuration.
         *                                         When set to <code>TRUE</code> , you must first disable this protection before adding or removing Availability Zones.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneChangeProtection(software.amazon.awscdk.IResolvable availabilityZoneChangeProtection) {
            this.availabilityZoneChangeProtection = availabilityZoneChangeProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getAvailabilityZoneMappings}
         * @param availabilityZoneMappings The Availability Zones where the firewall endpoints are created for a transit gateway-attached firewall.
         *                                 Each mapping specifies an Availability Zone where the firewall processes traffic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneMappings(software.amazon.awscdk.IResolvable availabilityZoneMappings) {
            this.availabilityZoneMappings = availabilityZoneMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getAvailabilityZoneMappings}
         * @param availabilityZoneMappings The Availability Zones where the firewall endpoints are created for a transit gateway-attached firewall.
         *                                 Each mapping specifies an Availability Zone where the firewall processes traffic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneMappings(java.util.List<? extends java.lang.Object> availabilityZoneMappings) {
            this.availabilityZoneMappings = availabilityZoneMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getDeleteProtection}
         * @param deleteProtection A flag indicating whether it is possible to delete the firewall.
         *                         A setting of <code>TRUE</code> indicates that the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteProtection(java.lang.Boolean deleteProtection) {
            this.deleteProtection = deleteProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getDeleteProtection}
         * @param deleteProtection A flag indicating whether it is possible to delete the firewall.
         *                         A setting of <code>TRUE</code> indicates that the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteProtection(software.amazon.awscdk.IResolvable deleteProtection) {
            this.deleteProtection = deleteProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getDescription}
         * @param description A description of the firewall.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getEnabledAnalysisTypes}
         * @param enabledAnalysisTypes An optional setting indicating the specific traffic analysis types to enable on the firewall.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabledAnalysisTypes(java.util.List<java.lang.String> enabledAnalysisTypes) {
            this.enabledAnalysisTypes = enabledAnalysisTypes;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getFirewallPolicyChangeProtection}
         * @param firewallPolicyChangeProtection A setting indicating whether the firewall is protected against a change to the firewall policy association.
         *                                       Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallPolicyChangeProtection(java.lang.Boolean firewallPolicyChangeProtection) {
            this.firewallPolicyChangeProtection = firewallPolicyChangeProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getFirewallPolicyChangeProtection}
         * @param firewallPolicyChangeProtection A setting indicating whether the firewall is protected against a change to the firewall policy association.
         *                                       Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallPolicyChangeProtection(software.amazon.awscdk.IResolvable firewallPolicyChangeProtection) {
            this.firewallPolicyChangeProtection = firewallPolicyChangeProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getSubnetChangeProtection}
         * @param subnetChangeProtection A setting indicating whether the firewall is protected against changes to the subnet associations.
         *                               Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetChangeProtection(java.lang.Boolean subnetChangeProtection) {
            this.subnetChangeProtection = subnetChangeProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getSubnetChangeProtection}
         * @param subnetChangeProtection A setting indicating whether the firewall is protected against changes to the subnet associations.
         *                               Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetChangeProtection(software.amazon.awscdk.IResolvable subnetChangeProtection) {
            this.subnetChangeProtection = subnetChangeProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getSubnetMappings}
         * @param subnetMappings The primary public subnets that Network Firewall is using for the firewall.
         *                       Network Firewall creates a firewall endpoint in each subnet. Create a subnet mapping for each Availability Zone where you want to use the firewall.
         *                       <p>
         *                       These subnets are all defined for a single, primary VPC, and each must belong to a different Availability Zone. Each of these subnets establishes the availability of the firewall in its Availability Zone.
         *                       <p>
         *                       In addition to these subnets, you can define other endpoints for the firewall in <code>VpcEndpointAssociation</code> resources. You can define these additional endpoints for any VPC, and for any of the Availability Zones where the firewall resource already has a subnet mapping. VPC endpoint associations give you the ability to protect multiple VPCs using a single firewall, and to define multiple firewall endpoints for a VPC in a single Availability Zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetMappings(software.amazon.awscdk.IResolvable subnetMappings) {
            this.subnetMappings = subnetMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getSubnetMappings}
         * @param subnetMappings The primary public subnets that Network Firewall is using for the firewall.
         *                       Network Firewall creates a firewall endpoint in each subnet. Create a subnet mapping for each Availability Zone where you want to use the firewall.
         *                       <p>
         *                       These subnets are all defined for a single, primary VPC, and each must belong to a different Availability Zone. Each of these subnets establishes the availability of the firewall in its Availability Zone.
         *                       <p>
         *                       In addition to these subnets, you can define other endpoints for the firewall in <code>VpcEndpointAssociation</code> resources. You can define these additional endpoints for any VPC, and for any of the Availability Zones where the firewall resource already has a subnet mapping. VPC endpoint associations give you the ability to protect multiple VPCs using a single firewall, and to define multiple firewall endpoints for a VPC in a single Availability Zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetMappings(java.util.List<? extends java.lang.Object> subnetMappings) {
            this.subnetMappings = subnetMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getTransitGatewayId}
         * @param transitGatewayId The unique identifier of the transit gateway associated with this firewall.
         *                         This field is only present for transit gateway-attached firewalls.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitGatewayId(java.lang.String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getVpcId}
         * @param vpcId The unique identifier of the VPC where the firewall is in use.
         *              You can't change the VPC of a firewall after you create the firewall.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFirewallProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFirewallProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFirewallProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFirewallProps {
        private final java.lang.String firewallName;
        private final java.lang.String firewallPolicyArn;
        private final java.lang.Object availabilityZoneChangeProtection;
        private final java.lang.Object availabilityZoneMappings;
        private final java.lang.Object deleteProtection;
        private final java.lang.String description;
        private final java.util.List<java.lang.String> enabledAnalysisTypes;
        private final java.lang.Object firewallPolicyChangeProtection;
        private final java.lang.Object subnetChangeProtection;
        private final java.lang.Object subnetMappings;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String transitGatewayId;
        private final java.lang.String vpcId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.firewallName = software.amazon.jsii.Kernel.get(this, "firewallName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.firewallPolicyArn = software.amazon.jsii.Kernel.get(this, "firewallPolicyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.availabilityZoneChangeProtection = software.amazon.jsii.Kernel.get(this, "availabilityZoneChangeProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.availabilityZoneMappings = software.amazon.jsii.Kernel.get(this, "availabilityZoneMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deleteProtection = software.amazon.jsii.Kernel.get(this, "deleteProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enabledAnalysisTypes = software.amazon.jsii.Kernel.get(this, "enabledAnalysisTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.firewallPolicyChangeProtection = software.amazon.jsii.Kernel.get(this, "firewallPolicyChangeProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.subnetChangeProtection = software.amazon.jsii.Kernel.get(this, "subnetChangeProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.subnetMappings = software.amazon.jsii.Kernel.get(this, "subnetMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.transitGatewayId = software.amazon.jsii.Kernel.get(this, "transitGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.firewallName = java.util.Objects.requireNonNull(builder.firewallName, "firewallName is required");
            this.firewallPolicyArn = java.util.Objects.requireNonNull(builder.firewallPolicyArn, "firewallPolicyArn is required");
            this.availabilityZoneChangeProtection = builder.availabilityZoneChangeProtection;
            this.availabilityZoneMappings = builder.availabilityZoneMappings;
            this.deleteProtection = builder.deleteProtection;
            this.description = builder.description;
            this.enabledAnalysisTypes = builder.enabledAnalysisTypes;
            this.firewallPolicyChangeProtection = builder.firewallPolicyChangeProtection;
            this.subnetChangeProtection = builder.subnetChangeProtection;
            this.subnetMappings = builder.subnetMappings;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.transitGatewayId = builder.transitGatewayId;
            this.vpcId = builder.vpcId;
        }

        @Override
        public final java.lang.String getFirewallName() {
            return this.firewallName;
        }

        @Override
        public final java.lang.String getFirewallPolicyArn() {
            return this.firewallPolicyArn;
        }

        @Override
        public final java.lang.Object getAvailabilityZoneChangeProtection() {
            return this.availabilityZoneChangeProtection;
        }

        @Override
        public final java.lang.Object getAvailabilityZoneMappings() {
            return this.availabilityZoneMappings;
        }

        @Override
        public final java.lang.Object getDeleteProtection() {
            return this.deleteProtection;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<java.lang.String> getEnabledAnalysisTypes() {
            return this.enabledAnalysisTypes;
        }

        @Override
        public final java.lang.Object getFirewallPolicyChangeProtection() {
            return this.firewallPolicyChangeProtection;
        }

        @Override
        public final java.lang.Object getSubnetChangeProtection() {
            return this.subnetChangeProtection;
        }

        @Override
        public final java.lang.Object getSubnetMappings() {
            return this.subnetMappings;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        @Override
        public final java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("firewallName", om.valueToTree(this.getFirewallName()));
            data.set("firewallPolicyArn", om.valueToTree(this.getFirewallPolicyArn()));
            if (this.getAvailabilityZoneChangeProtection() != null) {
                data.set("availabilityZoneChangeProtection", om.valueToTree(this.getAvailabilityZoneChangeProtection()));
            }
            if (this.getAvailabilityZoneMappings() != null) {
                data.set("availabilityZoneMappings", om.valueToTree(this.getAvailabilityZoneMappings()));
            }
            if (this.getDeleteProtection() != null) {
                data.set("deleteProtection", om.valueToTree(this.getDeleteProtection()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnabledAnalysisTypes() != null) {
                data.set("enabledAnalysisTypes", om.valueToTree(this.getEnabledAnalysisTypes()));
            }
            if (this.getFirewallPolicyChangeProtection() != null) {
                data.set("firewallPolicyChangeProtection", om.valueToTree(this.getFirewallPolicyChangeProtection()));
            }
            if (this.getSubnetChangeProtection() != null) {
                data.set("subnetChangeProtection", om.valueToTree(this.getSubnetChangeProtection()));
            }
            if (this.getSubnetMappings() != null) {
                data.set("subnetMappings", om.valueToTree(this.getSubnetMappings()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTransitGatewayId() != null) {
                data.set("transitGatewayId", om.valueToTree(this.getTransitGatewayId()));
            }
            if (this.getVpcId() != null) {
                data.set("vpcId", om.valueToTree(this.getVpcId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnFirewallProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFirewallProps.Jsii$Proxy that = (CfnFirewallProps.Jsii$Proxy) o;

            if (!firewallName.equals(that.firewallName)) return false;
            if (!firewallPolicyArn.equals(that.firewallPolicyArn)) return false;
            if (this.availabilityZoneChangeProtection != null ? !this.availabilityZoneChangeProtection.equals(that.availabilityZoneChangeProtection) : that.availabilityZoneChangeProtection != null) return false;
            if (this.availabilityZoneMappings != null ? !this.availabilityZoneMappings.equals(that.availabilityZoneMappings) : that.availabilityZoneMappings != null) return false;
            if (this.deleteProtection != null ? !this.deleteProtection.equals(that.deleteProtection) : that.deleteProtection != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.enabledAnalysisTypes != null ? !this.enabledAnalysisTypes.equals(that.enabledAnalysisTypes) : that.enabledAnalysisTypes != null) return false;
            if (this.firewallPolicyChangeProtection != null ? !this.firewallPolicyChangeProtection.equals(that.firewallPolicyChangeProtection) : that.firewallPolicyChangeProtection != null) return false;
            if (this.subnetChangeProtection != null ? !this.subnetChangeProtection.equals(that.subnetChangeProtection) : that.subnetChangeProtection != null) return false;
            if (this.subnetMappings != null ? !this.subnetMappings.equals(that.subnetMappings) : that.subnetMappings != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.transitGatewayId != null ? !this.transitGatewayId.equals(that.transitGatewayId) : that.transitGatewayId != null) return false;
            return this.vpcId != null ? this.vpcId.equals(that.vpcId) : that.vpcId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.firewallName.hashCode();
            result = 31 * result + (this.firewallPolicyArn.hashCode());
            result = 31 * result + (this.availabilityZoneChangeProtection != null ? this.availabilityZoneChangeProtection.hashCode() : 0);
            result = 31 * result + (this.availabilityZoneMappings != null ? this.availabilityZoneMappings.hashCode() : 0);
            result = 31 * result + (this.deleteProtection != null ? this.deleteProtection.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.enabledAnalysisTypes != null ? this.enabledAnalysisTypes.hashCode() : 0);
            result = 31 * result + (this.firewallPolicyChangeProtection != null ? this.firewallPolicyChangeProtection.hashCode() : 0);
            result = 31 * result + (this.subnetChangeProtection != null ? this.subnetChangeProtection.hashCode() : 0);
            result = 31 * result + (this.subnetMappings != null ? this.subnetMappings.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.transitGatewayId != null ? this.transitGatewayId.hashCode() : 0);
            result = 31 * result + (this.vpcId != null ? this.vpcId.hashCode() : 0);
            return result;
        }
    }
}
