package software.amazon.awscdk.services.omics;

/**
 * Creates a private workflow. Before you create a private workflow, you must create and configure these required resources:.
 * <p>
 * <ul>
 * <li><em>Workflow definition file:</em> A workflow definition file written in WDL, Nextflow, or CWL. The workflow definition specifies the inputs and outputs for runs that use the workflow. It also includes specifications for the runs and run tasks for your workflow, including compute and memory requirements. The workflow definition file must be in <code>.zip</code> format. For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflow-definition-files.html">Workflow definition files</a> in AWS HealthOmics.</li>
 * <li>You can use Amazon Q CLI to build and validate your workflow definition files in WDL, Nextflow, and CWL. For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/getting-started.html#omics-q-prompts">Example prompts for Amazon Q CLI</a> and the <a href="https://docs.aws.amazon.com/https://github.com/aws-samples/aws-healthomics-tutorials/tree/main/generative-ai">AWS HealthOmics Agentic generative AI tutorial</a> on GitHub.</li>
 * <li><em>(Optional) Parameter template file:</em> A parameter template file written in JSON. Create the file to define the run parameters, or AWS HealthOmics generates the parameter template for you. For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/parameter-templates.html">Parameter template files for HealthOmics workflows</a> .</li>
 * <li><em>ECR container images:</em> Create container images for the workflow in a private ECR repository, or synchronize images from a supported upstream registry with your Amazon ECR private repository.</li>
 * <li><em>(Optional) Sentieon licenses:</em> Request a Sentieon license to use the Sentieon software in private workflows.</li>
 * </ul>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/creating-private-workflows.html">Creating or updating a private workflow in AWS HealthOmics</a> in the <em>AWS HealthOmics User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.omics.*;
 * CfnWorkflow cfnWorkflow = CfnWorkflow.Builder.create(this, "MyCfnWorkflow")
 *         .accelerators("accelerators")
 *         .containerRegistryMap(ContainerRegistryMapProperty.builder()
 *                 .imageMappings(List.of(ImageMappingProperty.builder()
 *                         .destinationImage("destinationImage")
 *                         .sourceImage("sourceImage")
 *                         .build()))
 *                 .registryMappings(List.of(RegistryMappingProperty.builder()
 *                         .ecrAccountId("ecrAccountId")
 *                         .ecrRepositoryPrefix("ecrRepositoryPrefix")
 *                         .upstreamRegistryUrl("upstreamRegistryUrl")
 *                         .upstreamRepositoryPrefix("upstreamRepositoryPrefix")
 *                         .build()))
 *                 .build())
 *         .containerRegistryMapUri("containerRegistryMapUri")
 *         .definitionRepository(DefinitionRepositoryProperty.builder()
 *                 .connectionArn("connectionArn")
 *                 .excludeFilePatterns(List.of("excludeFilePatterns"))
 *                 .fullRepositoryId("fullRepositoryId")
 *                 .sourceReference(SourceReferenceProperty.builder()
 *                         .type("type")
 *                         .value("value")
 *                         .build())
 *                 .build())
 *         .definitionUri("definitionUri")
 *         .description("description")
 *         .engine("engine")
 *         .main("main")
 *         .name("name")
 *         .parameterTemplate(Map.of(
 *                 "parameterTemplateKey", WorkflowParameterProperty.builder()
 *                         .description("description")
 *                         .optional(false)
 *                         .build()))
 *         .parameterTemplatePath("parameterTemplatePath")
 *         .readmeMarkdown("readmeMarkdown")
 *         .readmePath("readmePath")
 *         .readmeUri("readmeUri")
 *         .storageCapacity(123)
 *         .storageType("storageType")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .workflowBucketOwnerId("workflowBucketOwnerId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:56.346Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_omics.CfnWorkflow")
public class CfnWorkflow extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.omics.IWorkflowRef, software.amazon.awscdk.ITaggable {

    protected CfnWorkflow(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnWorkflow(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.omics.CfnWorkflow.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::Omics::Workflow</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnWorkflow(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.omics.CfnWorkflowProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new <code>AWS::Omics::Workflow</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnWorkflow(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN for the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * When the workflow was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The workflow's ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The workflow's status.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The workflow's type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrType() {
        return software.amazon.jsii.Kernel.get(this, "attrType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUuid() {
        return software.amazon.jsii.Kernel.get(this, "attrUuid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A reference to a Workflow resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.omics.WorkflowReference getWorkflowRef() {
        return software.amazon.jsii.Kernel.get(this, "workflowRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.omics.WorkflowReference.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAccelerators() {
        return software.amazon.jsii.Kernel.get(this, "accelerators", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccelerators(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "accelerators", value);
    }

    /**
     * Use a container registry map to specify mappings between the ECR private repository and one or more upstream registries.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.omics.CfnWorkflow.ContainerRegistryMapProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getContainerRegistryMap() {
        return software.amazon.jsii.Kernel.get(this, "containerRegistryMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Use a container registry map to specify mappings between the ECR private repository and one or more upstream registries.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContainerRegistryMap(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "containerRegistryMap", value);
    }

    /**
     * Use a container registry map to specify mappings between the ECR private repository and one or more upstream registries.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContainerRegistryMap(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.omics.CfnWorkflow.ContainerRegistryMapProperty value) {
        software.amazon.jsii.Kernel.set(this, "containerRegistryMap", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getContainerRegistryMapUri() {
        return software.amazon.jsii.Kernel.get(this, "containerRegistryMapUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContainerRegistryMapUri(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "containerRegistryMapUri", value);
    }

    /**
     * Contains information about a source code repository that hosts the workflow definition files.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.omics.CfnWorkflow.DefinitionRepositoryProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefinitionRepository() {
        return software.amazon.jsii.Kernel.get(this, "definitionRepository", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains information about a source code repository that hosts the workflow definition files.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinitionRepository(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "definitionRepository", value);
    }

    /**
     * Contains information about a source code repository that hosts the workflow definition files.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinitionRepository(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.omics.CfnWorkflow.DefinitionRepositoryProperty value) {
        software.amazon.jsii.Kernel.set(this, "definitionRepository", value);
    }

    /**
     * The URI of a definition for the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefinitionUri() {
        return software.amazon.jsii.Kernel.get(this, "definitionUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URI of a definition for the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinitionUri(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "definitionUri", value);
    }

    /**
     * The parameter's description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The parameter's description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * An engine for the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngine() {
        return software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An engine for the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngine(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engine", value);
    }

    /**
     * The path of the main definition file for the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMain() {
        return software.amazon.jsii.Kernel.get(this, "main", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The path of the main definition file for the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMain(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "main", value);
    }

    /**
     * The workflow's name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The workflow's name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The workflow's parameter template.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or Map<String, either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.omics.CfnWorkflow.WorkflowParameterProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getParameterTemplate() {
        return software.amazon.jsii.Kernel.get(this, "parameterTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The workflow's parameter template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameterTemplate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "parameterTemplate", value);
    }

    /**
     * The workflow's parameter template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameterTemplate(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.omics.CfnWorkflow.WorkflowParameterProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.omics.CfnWorkflow.WorkflowParameterProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "parameterTemplate", value);
    }

    /**
     * Path to the primary workflow parameter template JSON file inside the repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getParameterTemplatePath() {
        return software.amazon.jsii.Kernel.get(this, "parameterTemplatePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Path to the primary workflow parameter template JSON file inside the repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameterTemplatePath(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "parameterTemplatePath", value);
    }

    /**
     * The markdown content for the workflow's README file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getReadmeMarkdown() {
        return software.amazon.jsii.Kernel.get(this, "readmeMarkdown", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The markdown content for the workflow's README file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReadmeMarkdown(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "readmeMarkdown", value);
    }

    /**
     * The path to the workflow README markdown file within the repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getReadmePath() {
        return software.amazon.jsii.Kernel.get(this, "readmePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The path to the workflow README markdown file within the repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReadmePath(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "readmePath", value);
    }

    /**
     * The S3 URI of the README file for the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getReadmeUri() {
        return software.amazon.jsii.Kernel.get(this, "readmeUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The S3 URI of the README file for the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReadmeUri(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "readmeUri", value);
    }

    /**
     * The default static storage capacity (in gibibytes) for runs that use this workflow or workflow version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getStorageCapacity() {
        return software.amazon.jsii.Kernel.get(this, "storageCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The default static storage capacity (in gibibytes) for runs that use this workflow or workflow version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageCapacity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "storageCapacity", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStorageType() {
        return software.amazon.jsii.Kernel.get(this, "storageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "storageType", value);
    }

    /**
     * Tags for the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * Tags for the workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * Optional workflow bucket owner ID to verify the workflow bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getWorkflowBucketOwnerId() {
        return software.amazon.jsii.Kernel.get(this, "workflowBucketOwnerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Optional workflow bucket owner ID to verify the workflow bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkflowBucketOwnerId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "workflowBucketOwnerId", value);
    }
    /**
     * Use a container registry map to specify mappings between the ECR private repository and one or more upstream registries.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflows-ecr.html">Container images</a> in the <em>AWS HealthOmics User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.omics.*;
     * ContainerRegistryMapProperty containerRegistryMapProperty = ContainerRegistryMapProperty.builder()
     *         .imageMappings(List.of(ImageMappingProperty.builder()
     *                 .destinationImage("destinationImage")
     *                 .sourceImage("sourceImage")
     *                 .build()))
     *         .registryMappings(List.of(RegistryMappingProperty.builder()
     *                 .ecrAccountId("ecrAccountId")
     *                 .ecrRepositoryPrefix("ecrRepositoryPrefix")
     *                 .upstreamRegistryUrl("upstreamRegistryUrl")
     *                 .upstreamRepositoryPrefix("upstreamRepositoryPrefix")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-containerregistrymap.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-containerregistrymap.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_omics.CfnWorkflow.ContainerRegistryMapProperty")
    @software.amazon.jsii.Jsii.Proxy(ContainerRegistryMapProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContainerRegistryMapProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Image mappings specify path mappings between the ECR private repository and their corresponding external repositories.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.omics.CfnWorkflow.ImageMappingProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-containerregistrymap.html#cfn-omics-workflow-containerregistrymap-imagemappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-containerregistrymap.html#cfn-omics-workflow-containerregistrymap-imagemappings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getImageMappings() {
            return null;
        }

        /**
         * Mapping that provides the ECR repository path where upstream container images are pulled and synchronized.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.omics.CfnWorkflow.RegistryMappingProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-containerregistrymap.html#cfn-omics-workflow-containerregistrymap-registrymappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-containerregistrymap.html#cfn-omics-workflow-containerregistrymap-registrymappings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRegistryMappings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ContainerRegistryMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContainerRegistryMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContainerRegistryMapProperty> {
            java.lang.Object imageMappings;
            java.lang.Object registryMappings;

            /**
             * Sets the value of {@link ContainerRegistryMapProperty#getImageMappings}
             * @param imageMappings Image mappings specify path mappings between the ECR private repository and their corresponding external repositories.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageMappings(software.amazon.awscdk.IResolvable imageMappings) {
                this.imageMappings = imageMappings;
                return this;
            }

            /**
             * Sets the value of {@link ContainerRegistryMapProperty#getImageMappings}
             * @param imageMappings Image mappings specify path mappings between the ECR private repository and their corresponding external repositories.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageMappings(java.util.List<? extends java.lang.Object> imageMappings) {
                this.imageMappings = imageMappings;
                return this;
            }

            /**
             * Sets the value of {@link ContainerRegistryMapProperty#getRegistryMappings}
             * @param registryMappings Mapping that provides the ECR repository path where upstream container images are pulled and synchronized.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder registryMappings(software.amazon.awscdk.IResolvable registryMappings) {
                this.registryMappings = registryMappings;
                return this;
            }

            /**
             * Sets the value of {@link ContainerRegistryMapProperty#getRegistryMappings}
             * @param registryMappings Mapping that provides the ECR repository path where upstream container images are pulled and synchronized.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder registryMappings(java.util.List<? extends java.lang.Object> registryMappings) {
                this.registryMappings = registryMappings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContainerRegistryMapProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContainerRegistryMapProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContainerRegistryMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerRegistryMapProperty {
            private final java.lang.Object imageMappings;
            private final java.lang.Object registryMappings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.imageMappings = software.amazon.jsii.Kernel.get(this, "imageMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.registryMappings = software.amazon.jsii.Kernel.get(this, "registryMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.imageMappings = builder.imageMappings;
                this.registryMappings = builder.registryMappings;
            }

            @Override
            public final java.lang.Object getImageMappings() {
                return this.imageMappings;
            }

            @Override
            public final java.lang.Object getRegistryMappings() {
                return this.registryMappings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getImageMappings() != null) {
                    data.set("imageMappings", om.valueToTree(this.getImageMappings()));
                }
                if (this.getRegistryMappings() != null) {
                    data.set("registryMappings", om.valueToTree(this.getRegistryMappings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_omics.CfnWorkflow.ContainerRegistryMapProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContainerRegistryMapProperty.Jsii$Proxy that = (ContainerRegistryMapProperty.Jsii$Proxy) o;

                if (this.imageMappings != null ? !this.imageMappings.equals(that.imageMappings) : that.imageMappings != null) return false;
                return this.registryMappings != null ? this.registryMappings.equals(that.registryMappings) : that.registryMappings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.imageMappings != null ? this.imageMappings.hashCode() : 0;
                result = 31 * result + (this.registryMappings != null ? this.registryMappings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about a source code repository that hosts the workflow definition files.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.omics.*;
     * DefinitionRepositoryProperty definitionRepositoryProperty = DefinitionRepositoryProperty.builder()
     *         .connectionArn("connectionArn")
     *         .excludeFilePatterns(List.of("excludeFilePatterns"))
     *         .fullRepositoryId("fullRepositoryId")
     *         .sourceReference(SourceReferenceProperty.builder()
     *                 .type("type")
     *                 .value("value")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-definitionrepository.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-definitionrepository.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_omics.CfnWorkflow.DefinitionRepositoryProperty")
    @software.amazon.jsii.Jsii.Proxy(DefinitionRepositoryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefinitionRepositoryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the connection to the source code repository.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-definitionrepository.html#cfn-omics-workflow-definitionrepository-connectionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-definitionrepository.html#cfn-omics-workflow-definitionrepository-connectionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectionArn() {
            return null;
        }

        /**
         * A list of file patterns to exclude when retrieving the workflow definition from the repository.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-definitionrepository.html#cfn-omics-workflow-definitionrepository-excludefilepatterns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-definitionrepository.html#cfn-omics-workflow-definitionrepository-excludefilepatterns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludeFilePatterns() {
            return null;
        }

        /**
         * The full repository identifier, including the repository owner and name.
         * <p>
         * For example, 'repository-owner/repository-name'.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-definitionrepository.html#cfn-omics-workflow-definitionrepository-fullrepositoryid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-definitionrepository.html#cfn-omics-workflow-definitionrepository-fullrepositoryid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFullRepositoryId() {
            return null;
        }

        /**
         * The source reference for the repository, such as a branch name, tag, or commit ID.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.omics.CfnWorkflow.SourceReferenceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-definitionrepository.html#cfn-omics-workflow-definitionrepository-sourcereference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-definitionrepository.html#cfn-omics-workflow-definitionrepository-sourcereference</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourceReference() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DefinitionRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefinitionRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DefinitionRepositoryProperty> {
            java.lang.String connectionArn;
            java.util.List<java.lang.String> excludeFilePatterns;
            java.lang.String fullRepositoryId;
            java.lang.Object sourceReference;

            /**
             * Sets the value of {@link DefinitionRepositoryProperty#getConnectionArn}
             * @param connectionArn The Amazon Resource Name (ARN) of the connection to the source code repository.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionArn(java.lang.String connectionArn) {
                this.connectionArn = connectionArn;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionRepositoryProperty#getExcludeFilePatterns}
             * @param excludeFilePatterns A list of file patterns to exclude when retrieving the workflow definition from the repository.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeFilePatterns(java.util.List<java.lang.String> excludeFilePatterns) {
                this.excludeFilePatterns = excludeFilePatterns;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionRepositoryProperty#getFullRepositoryId}
             * @param fullRepositoryId The full repository identifier, including the repository owner and name.
             *                         For example, 'repository-owner/repository-name'.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fullRepositoryId(java.lang.String fullRepositoryId) {
                this.fullRepositoryId = fullRepositoryId;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionRepositoryProperty#getSourceReference}
             * @param sourceReference The source reference for the repository, such as a branch name, tag, or commit ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceReference(software.amazon.awscdk.IResolvable sourceReference) {
                this.sourceReference = sourceReference;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionRepositoryProperty#getSourceReference}
             * @param sourceReference The source reference for the repository, such as a branch name, tag, or commit ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceReference(software.amazon.awscdk.services.omics.CfnWorkflow.SourceReferenceProperty sourceReference) {
                this.sourceReference = sourceReference;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefinitionRepositoryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DefinitionRepositoryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DefinitionRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefinitionRepositoryProperty {
            private final java.lang.String connectionArn;
            private final java.util.List<java.lang.String> excludeFilePatterns;
            private final java.lang.String fullRepositoryId;
            private final java.lang.Object sourceReference;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectionArn = software.amazon.jsii.Kernel.get(this, "connectionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.excludeFilePatterns = software.amazon.jsii.Kernel.get(this, "excludeFilePatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.fullRepositoryId = software.amazon.jsii.Kernel.get(this, "fullRepositoryId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceReference = software.amazon.jsii.Kernel.get(this, "sourceReference", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectionArn = builder.connectionArn;
                this.excludeFilePatterns = builder.excludeFilePatterns;
                this.fullRepositoryId = builder.fullRepositoryId;
                this.sourceReference = builder.sourceReference;
            }

            @Override
            public final java.lang.String getConnectionArn() {
                return this.connectionArn;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludeFilePatterns() {
                return this.excludeFilePatterns;
            }

            @Override
            public final java.lang.String getFullRepositoryId() {
                return this.fullRepositoryId;
            }

            @Override
            public final java.lang.Object getSourceReference() {
                return this.sourceReference;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConnectionArn() != null) {
                    data.set("connectionArn", om.valueToTree(this.getConnectionArn()));
                }
                if (this.getExcludeFilePatterns() != null) {
                    data.set("excludeFilePatterns", om.valueToTree(this.getExcludeFilePatterns()));
                }
                if (this.getFullRepositoryId() != null) {
                    data.set("fullRepositoryId", om.valueToTree(this.getFullRepositoryId()));
                }
                if (this.getSourceReference() != null) {
                    data.set("sourceReference", om.valueToTree(this.getSourceReference()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_omics.CfnWorkflow.DefinitionRepositoryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefinitionRepositoryProperty.Jsii$Proxy that = (DefinitionRepositoryProperty.Jsii$Proxy) o;

                if (this.connectionArn != null ? !this.connectionArn.equals(that.connectionArn) : that.connectionArn != null) return false;
                if (this.excludeFilePatterns != null ? !this.excludeFilePatterns.equals(that.excludeFilePatterns) : that.excludeFilePatterns != null) return false;
                if (this.fullRepositoryId != null ? !this.fullRepositoryId.equals(that.fullRepositoryId) : that.fullRepositoryId != null) return false;
                return this.sourceReference != null ? this.sourceReference.equals(that.sourceReference) : that.sourceReference == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectionArn != null ? this.connectionArn.hashCode() : 0;
                result = 31 * result + (this.excludeFilePatterns != null ? this.excludeFilePatterns.hashCode() : 0);
                result = 31 * result + (this.fullRepositoryId != null ? this.fullRepositoryId.hashCode() : 0);
                result = 31 * result + (this.sourceReference != null ? this.sourceReference.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies image mappings that workflow tasks can use.
     * <p>
     * For example, you can replace all the task references of a public image to use an equivalent image in your private ECR repository. You can use image mappings with upstream registries that don't support pull through cache. You need to manually synchronize the upstream registry with your private repository.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.omics.*;
     * ImageMappingProperty imageMappingProperty = ImageMappingProperty.builder()
     *         .destinationImage("destinationImage")
     *         .sourceImage("sourceImage")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-imagemapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-imagemapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_omics.CfnWorkflow.ImageMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(ImageMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImageMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the URI of the corresponding image in the private ECR registry.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-imagemapping.html#cfn-omics-workflow-imagemapping-destinationimage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-imagemapping.html#cfn-omics-workflow-imagemapping-destinationimage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationImage() {
            return null;
        }

        /**
         * Specifies the URI of the source image in the upstream registry.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-imagemapping.html#cfn-omics-workflow-imagemapping-sourceimage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-imagemapping.html#cfn-omics-workflow-imagemapping-sourceimage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceImage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ImageMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImageMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImageMappingProperty> {
            java.lang.String destinationImage;
            java.lang.String sourceImage;

            /**
             * Sets the value of {@link ImageMappingProperty#getDestinationImage}
             * @param destinationImage Specifies the URI of the corresponding image in the private ECR registry.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationImage(java.lang.String destinationImage) {
                this.destinationImage = destinationImage;
                return this;
            }

            /**
             * Sets the value of {@link ImageMappingProperty#getSourceImage}
             * @param sourceImage Specifies the URI of the source image in the upstream registry.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceImage(java.lang.String sourceImage) {
                this.sourceImage = sourceImage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImageMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImageMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ImageMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImageMappingProperty {
            private final java.lang.String destinationImage;
            private final java.lang.String sourceImage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationImage = software.amazon.jsii.Kernel.get(this, "destinationImage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceImage = software.amazon.jsii.Kernel.get(this, "sourceImage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationImage = builder.destinationImage;
                this.sourceImage = builder.sourceImage;
            }

            @Override
            public final java.lang.String getDestinationImage() {
                return this.destinationImage;
            }

            @Override
            public final java.lang.String getSourceImage() {
                return this.sourceImage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestinationImage() != null) {
                    data.set("destinationImage", om.valueToTree(this.getDestinationImage()));
                }
                if (this.getSourceImage() != null) {
                    data.set("sourceImage", om.valueToTree(this.getSourceImage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_omics.CfnWorkflow.ImageMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImageMappingProperty.Jsii$Proxy that = (ImageMappingProperty.Jsii$Proxy) o;

                if (this.destinationImage != null ? !this.destinationImage.equals(that.destinationImage) : that.destinationImage != null) return false;
                return this.sourceImage != null ? this.sourceImage.equals(that.sourceImage) : that.sourceImage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationImage != null ? this.destinationImage.hashCode() : 0;
                result = 31 * result + (this.sourceImage != null ? this.sourceImage.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * If you are using the ECR pull through cache feature, the registry mapping maps between the ECR repository and the upstream registry where container images are pulled and synchronized.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.omics.*;
     * RegistryMappingProperty registryMappingProperty = RegistryMappingProperty.builder()
     *         .ecrAccountId("ecrAccountId")
     *         .ecrRepositoryPrefix("ecrRepositoryPrefix")
     *         .upstreamRegistryUrl("upstreamRegistryUrl")
     *         .upstreamRepositoryPrefix("upstreamRepositoryPrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-registrymapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-registrymapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_omics.CfnWorkflow.RegistryMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(RegistryMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RegistryMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Account ID of the account that owns the upstream container image.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-registrymapping.html#cfn-omics-workflow-registrymapping-ecraccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-registrymapping.html#cfn-omics-workflow-registrymapping-ecraccountid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEcrAccountId() {
            return null;
        }

        /**
         * The repository prefix to use in the ECR private repository.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-registrymapping.html#cfn-omics-workflow-registrymapping-ecrrepositoryprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-registrymapping.html#cfn-omics-workflow-registrymapping-ecrrepositoryprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEcrRepositoryPrefix() {
            return null;
        }

        /**
         * The URI of the upstream registry.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-registrymapping.html#cfn-omics-workflow-registrymapping-upstreamregistryurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-registrymapping.html#cfn-omics-workflow-registrymapping-upstreamregistryurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUpstreamRegistryUrl() {
            return null;
        }

        /**
         * The repository prefix of the corresponding repository in the upstream registry.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-registrymapping.html#cfn-omics-workflow-registrymapping-upstreamrepositoryprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-registrymapping.html#cfn-omics-workflow-registrymapping-upstreamrepositoryprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUpstreamRepositoryPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RegistryMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RegistryMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RegistryMappingProperty> {
            java.lang.String ecrAccountId;
            java.lang.String ecrRepositoryPrefix;
            java.lang.String upstreamRegistryUrl;
            java.lang.String upstreamRepositoryPrefix;

            /**
             * Sets the value of {@link RegistryMappingProperty#getEcrAccountId}
             * @param ecrAccountId Account ID of the account that owns the upstream container image.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecrAccountId(java.lang.String ecrAccountId) {
                this.ecrAccountId = ecrAccountId;
                return this;
            }

            /**
             * Sets the value of {@link RegistryMappingProperty#getEcrRepositoryPrefix}
             * @param ecrRepositoryPrefix The repository prefix to use in the ECR private repository.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecrRepositoryPrefix(java.lang.String ecrRepositoryPrefix) {
                this.ecrRepositoryPrefix = ecrRepositoryPrefix;
                return this;
            }

            /**
             * Sets the value of {@link RegistryMappingProperty#getUpstreamRegistryUrl}
             * @param upstreamRegistryUrl The URI of the upstream registry.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder upstreamRegistryUrl(java.lang.String upstreamRegistryUrl) {
                this.upstreamRegistryUrl = upstreamRegistryUrl;
                return this;
            }

            /**
             * Sets the value of {@link RegistryMappingProperty#getUpstreamRepositoryPrefix}
             * @param upstreamRepositoryPrefix The repository prefix of the corresponding repository in the upstream registry.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder upstreamRepositoryPrefix(java.lang.String upstreamRepositoryPrefix) {
                this.upstreamRepositoryPrefix = upstreamRepositoryPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RegistryMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RegistryMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RegistryMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RegistryMappingProperty {
            private final java.lang.String ecrAccountId;
            private final java.lang.String ecrRepositoryPrefix;
            private final java.lang.String upstreamRegistryUrl;
            private final java.lang.String upstreamRepositoryPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ecrAccountId = software.amazon.jsii.Kernel.get(this, "ecrAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ecrRepositoryPrefix = software.amazon.jsii.Kernel.get(this, "ecrRepositoryPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.upstreamRegistryUrl = software.amazon.jsii.Kernel.get(this, "upstreamRegistryUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.upstreamRepositoryPrefix = software.amazon.jsii.Kernel.get(this, "upstreamRepositoryPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ecrAccountId = builder.ecrAccountId;
                this.ecrRepositoryPrefix = builder.ecrRepositoryPrefix;
                this.upstreamRegistryUrl = builder.upstreamRegistryUrl;
                this.upstreamRepositoryPrefix = builder.upstreamRepositoryPrefix;
            }

            @Override
            public final java.lang.String getEcrAccountId() {
                return this.ecrAccountId;
            }

            @Override
            public final java.lang.String getEcrRepositoryPrefix() {
                return this.ecrRepositoryPrefix;
            }

            @Override
            public final java.lang.String getUpstreamRegistryUrl() {
                return this.upstreamRegistryUrl;
            }

            @Override
            public final java.lang.String getUpstreamRepositoryPrefix() {
                return this.upstreamRepositoryPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEcrAccountId() != null) {
                    data.set("ecrAccountId", om.valueToTree(this.getEcrAccountId()));
                }
                if (this.getEcrRepositoryPrefix() != null) {
                    data.set("ecrRepositoryPrefix", om.valueToTree(this.getEcrRepositoryPrefix()));
                }
                if (this.getUpstreamRegistryUrl() != null) {
                    data.set("upstreamRegistryUrl", om.valueToTree(this.getUpstreamRegistryUrl()));
                }
                if (this.getUpstreamRepositoryPrefix() != null) {
                    data.set("upstreamRepositoryPrefix", om.valueToTree(this.getUpstreamRepositoryPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_omics.CfnWorkflow.RegistryMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RegistryMappingProperty.Jsii$Proxy that = (RegistryMappingProperty.Jsii$Proxy) o;

                if (this.ecrAccountId != null ? !this.ecrAccountId.equals(that.ecrAccountId) : that.ecrAccountId != null) return false;
                if (this.ecrRepositoryPrefix != null ? !this.ecrRepositoryPrefix.equals(that.ecrRepositoryPrefix) : that.ecrRepositoryPrefix != null) return false;
                if (this.upstreamRegistryUrl != null ? !this.upstreamRegistryUrl.equals(that.upstreamRegistryUrl) : that.upstreamRegistryUrl != null) return false;
                return this.upstreamRepositoryPrefix != null ? this.upstreamRepositoryPrefix.equals(that.upstreamRepositoryPrefix) : that.upstreamRepositoryPrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ecrAccountId != null ? this.ecrAccountId.hashCode() : 0;
                result = 31 * result + (this.ecrRepositoryPrefix != null ? this.ecrRepositoryPrefix.hashCode() : 0);
                result = 31 * result + (this.upstreamRegistryUrl != null ? this.upstreamRegistryUrl.hashCode() : 0);
                result = 31 * result + (this.upstreamRepositoryPrefix != null ? this.upstreamRepositoryPrefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about the source reference in a code repository, such as a branch, tag, or commit.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.omics.*;
     * SourceReferenceProperty sourceReferenceProperty = SourceReferenceProperty.builder()
     *         .type("type")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-sourcereference.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-sourcereference.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_omics.CfnWorkflow.SourceReferenceProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceReferenceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceReferenceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of source reference, such as branch, tag, or commit.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-sourcereference.html#cfn-omics-workflow-sourcereference-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-sourcereference.html#cfn-omics-workflow-sourcereference-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * The value of the source reference, such as the branch name, tag name, or commit ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-sourcereference.html#cfn-omics-workflow-sourcereference-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-sourcereference.html#cfn-omics-workflow-sourcereference-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceReferenceProperty> {
            java.lang.String type;
            java.lang.String value;

            /**
             * Sets the value of {@link SourceReferenceProperty#getType}
             * @param type The type of source reference, such as branch, tag, or commit.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link SourceReferenceProperty#getValue}
             * @param value The value of the source reference, such as the branch name, tag name, or commit ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceReferenceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceReferenceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceReferenceProperty {
            private final java.lang.String type;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = builder.type;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_omics.CfnWorkflow.SourceReferenceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceReferenceProperty.Jsii$Proxy that = (SourceReferenceProperty.Jsii$Proxy) o;

                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type != null ? this.type.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A workflow parameter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.omics.*;
     * WorkflowParameterProperty workflowParameterProperty = WorkflowParameterProperty.builder()
     *         .description("description")
     *         .optional(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-workflowparameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-workflowparameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_omics.CfnWorkflow.WorkflowParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkflowParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkflowParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The parameter's description.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-workflowparameter.html#cfn-omics-workflow-workflowparameter-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-workflowparameter.html#cfn-omics-workflow-workflowparameter-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Whether the parameter is optional.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-workflowparameter.html#cfn-omics-workflow-workflowparameter-optional">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-workflowparameter.html#cfn-omics-workflow-workflowparameter-optional</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOptional() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WorkflowParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkflowParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkflowParameterProperty> {
            java.lang.String description;
            java.lang.Object optional;

            /**
             * Sets the value of {@link WorkflowParameterProperty#getDescription}
             * @param description The parameter's description.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowParameterProperty#getOptional}
             * @param optional Whether the parameter is optional.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder optional(java.lang.Boolean optional) {
                this.optional = optional;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowParameterProperty#getOptional}
             * @param optional Whether the parameter is optional.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder optional(software.amazon.awscdk.IResolvable optional) {
                this.optional = optional;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkflowParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkflowParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkflowParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkflowParameterProperty {
            private final java.lang.String description;
            private final java.lang.Object optional;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.optional = software.amazon.jsii.Kernel.get(this, "optional", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.description = builder.description;
                this.optional = builder.optional;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getOptional() {
                return this.optional;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getOptional() != null) {
                    data.set("optional", om.valueToTree(this.getOptional()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_omics.CfnWorkflow.WorkflowParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkflowParameterProperty.Jsii$Proxy that = (WorkflowParameterProperty.Jsii$Proxy) o;

                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                return this.optional != null ? this.optional.equals(that.optional) : that.optional == null;
            }

            @Override
            public final int hashCode() {
                int result = this.description != null ? this.description.hashCode() : 0;
                result = 31 * result + (this.optional != null ? this.optional.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.omics.CfnWorkflow}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.omics.CfnWorkflow> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.omics.CfnWorkflowProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-accelerators">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-accelerators</a>
         * @param accelerators This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accelerators(final java.lang.String accelerators) {
            this.props().accelerators(accelerators);
            return this;
        }

        /**
         * Use a container registry map to specify mappings between the ECR private repository and one or more upstream registries.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflows-ecr.html">Container images</a> in the <em>AWS HealthOmics User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-containerregistrymap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-containerregistrymap</a>
         * @param containerRegistryMap Use a container registry map to specify mappings between the ECR private repository and one or more upstream registries. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerRegistryMap(final software.amazon.awscdk.IResolvable containerRegistryMap) {
            this.props().containerRegistryMap(containerRegistryMap);
            return this;
        }
        /**
         * Use a container registry map to specify mappings between the ECR private repository and one or more upstream registries.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflows-ecr.html">Container images</a> in the <em>AWS HealthOmics User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-containerregistrymap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-containerregistrymap</a>
         * @param containerRegistryMap Use a container registry map to specify mappings between the ECR private repository and one or more upstream registries. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerRegistryMap(final software.amazon.awscdk.services.omics.CfnWorkflow.ContainerRegistryMapProperty containerRegistryMap) {
            this.props().containerRegistryMap(containerRegistryMap);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-containerregistrymapuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-containerregistrymapuri</a>
         * @param containerRegistryMapUri This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerRegistryMapUri(final java.lang.String containerRegistryMapUri) {
            this.props().containerRegistryMapUri(containerRegistryMapUri);
            return this;
        }

        /**
         * Contains information about a source code repository that hosts the workflow definition files.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-definitionrepository">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-definitionrepository</a>
         * @param definitionRepository Contains information about a source code repository that hosts the workflow definition files. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionRepository(final software.amazon.awscdk.IResolvable definitionRepository) {
            this.props().definitionRepository(definitionRepository);
            return this;
        }
        /**
         * Contains information about a source code repository that hosts the workflow definition files.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-definitionrepository">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-definitionrepository</a>
         * @param definitionRepository Contains information about a source code repository that hosts the workflow definition files. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionRepository(final software.amazon.awscdk.services.omics.CfnWorkflow.DefinitionRepositoryProperty definitionRepository) {
            this.props().definitionRepository(definitionRepository);
            return this;
        }

        /**
         * The URI of a definition for the workflow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-definitionuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-definitionuri</a>
         * @param definitionUri The URI of a definition for the workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionUri(final java.lang.String definitionUri) {
            this.props().definitionUri(definitionUri);
            return this;
        }

        /**
         * The parameter's description.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-description</a>
         * @param description The parameter's description. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * An engine for the workflow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-engine">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-engine</a>
         * @param engine An engine for the workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(final java.lang.String engine) {
            this.props().engine(engine);
            return this;
        }

        /**
         * The path of the main definition file for the workflow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-main">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-main</a>
         * @param main The path of the main definition file for the workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder main(final java.lang.String main) {
            this.props().main(main);
            return this;
        }

        /**
         * The workflow's name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-name</a>
         * @param name The workflow's name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * The workflow's parameter template.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-parametertemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-parametertemplate</a>
         * @param parameterTemplate The workflow's parameter template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterTemplate(final software.amazon.awscdk.IResolvable parameterTemplate) {
            this.props().parameterTemplate(parameterTemplate);
            return this;
        }
        /**
         * The workflow's parameter template.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-parametertemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-parametertemplate</a>
         * @param parameterTemplate The workflow's parameter template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterTemplate(final java.util.Map<java.lang.String, ? extends java.lang.Object> parameterTemplate) {
            this.props().parameterTemplate(parameterTemplate);
            return this;
        }

        /**
         * Path to the primary workflow parameter template JSON file inside the repository.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-parametertemplatepath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-parametertemplatepath</a>
         * @param parameterTemplatePath Path to the primary workflow parameter template JSON file inside the repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterTemplatePath(final java.lang.String parameterTemplatePath) {
            this.props().parameterTemplatePath(parameterTemplatePath);
            return this;
        }

        /**
         * The markdown content for the workflow's README file.
         * <p>
         * This provides documentation and usage information for users of the workflow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-readmemarkdown">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-readmemarkdown</a>
         * @param readmeMarkdown The markdown content for the workflow's README file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readmeMarkdown(final java.lang.String readmeMarkdown) {
            this.props().readmeMarkdown(readmeMarkdown);
            return this;
        }

        /**
         * The path to the workflow README markdown file within the repository.
         * <p>
         * This file provides documentation and usage information for the workflow. If not specified, the README.md file from the root directory of the repository will be used.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-readmepath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-readmepath</a>
         * @param readmePath The path to the workflow README markdown file within the repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readmePath(final java.lang.String readmePath) {
            this.props().readmePath(readmePath);
            return this;
        }

        /**
         * The S3 URI of the README file for the workflow.
         * <p>
         * This file provides documentation and usage information for the workflow. The S3 URI must begin with s3://USER-OWNED-BUCKET/. The requester must have access to the S3 bucket and object. The max README content length is 500 KiB.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-readmeuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-readmeuri</a>
         * @param readmeUri The S3 URI of the README file for the workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readmeUri(final java.lang.String readmeUri) {
            this.props().readmeUri(readmeUri);
            return this;
        }

        /**
         * The default static storage capacity (in gibibytes) for runs that use this workflow or workflow version.
         * <p>
         * The <code>storageCapacity</code> can be overwritten at run time. The storage capacity is not required for runs with a <code>DYNAMIC</code> storage type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-storagecapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-storagecapacity</a>
         * @param storageCapacity The default static storage capacity (in gibibytes) for runs that use this workflow or workflow version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageCapacity(final java.lang.Number storageCapacity) {
            this.props().storageCapacity(storageCapacity);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-storagetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-storagetype</a>
         * @param storageType This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageType(final java.lang.String storageType) {
            this.props().storageType(storageType);
            return this;
        }

        /**
         * Tags for the workflow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-tags</a>
         * @param tags Tags for the workflow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * Optional workflow bucket owner ID to verify the workflow bucket.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-workflowbucketownerid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-workflowbucketownerid</a>
         * @param workflowBucketOwnerId Optional workflow bucket owner ID to verify the workflow bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflowBucketOwnerId(final java.lang.String workflowBucketOwnerId) {
            this.props().workflowBucketOwnerId(workflowBucketOwnerId);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.omics.CfnWorkflow}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.omics.CfnWorkflow build() {
            return new software.amazon.awscdk.services.omics.CfnWorkflow(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.omics.CfnWorkflowProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.omics.CfnWorkflowProps.Builder();
            }
            return this.props;
        }
    }
}
