package software.amazon.awscdk.services.quicksight;

/**
 * Creates a dataset.
 * <p>
 * This operation doesn't support datasets that include uploaded files as a source.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:58.107Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet")
public class CfnDataSet extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.quicksight.IDataSetRef, software.amazon.awscdk.ITaggable {

    protected CfnDataSet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataSet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.quicksight.CfnDataSet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::QuickSight::DataSet</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataSet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new <code>AWS::QuickSight::DataSet</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataSet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * <p>The amount of SPICE capacity used by this dataset.
     * <p>
     * This is 0 if the dataset isn't
     * imported into SPICE.</p>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrConsumedSpiceCapacityInBytes() {
        return software.amazon.jsii.Kernel.get(this, "attrConsumedSpiceCapacityInBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The time this dataset version was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time this dataset version was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastUpdatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastUpdatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * <p>The list of columns after all transforms.
     * <p>
     * These columns are available in templates,
     * analyses, and dashboards.</p>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrOutputColumns() {
        return software.amazon.jsii.Kernel.get(this, "attrOutputColumns", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a DataSet resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.quicksight.DataSetReference getDataSetRef() {
        return software.amazon.jsii.Kernel.get(this, "dataSetRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.quicksight.DataSetReference.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The AWS account ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAwsAccountId() {
        return software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS account ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAwsAccountId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "awsAccountId", value);
    }

    /**
     * Groupings of columns that work together in certain Amazon Quick Sight features.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnGroupProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getColumnGroups() {
        return software.amazon.jsii.Kernel.get(this, "columnGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Groupings of columns that work together in certain Amazon Quick Sight features.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setColumnGroups(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "columnGroups", value);
    }

    /**
     * Groupings of columns that work together in certain Amazon Quick Sight features.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setColumnGroups(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnGroupProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnGroupProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "columnGroups", value);
    }

    /**
     * A set of one or more definitions of a <code>ColumnLevelPermissionRule</code> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnLevelPermissionRuleProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getColumnLevelPermissionRules() {
        return software.amazon.jsii.Kernel.get(this, "columnLevelPermissionRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A set of one or more definitions of a <code>ColumnLevelPermissionRule</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setColumnLevelPermissionRules(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "columnLevelPermissionRules", value);
    }

    /**
     * A set of one or more definitions of a <code>ColumnLevelPermissionRule</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setColumnLevelPermissionRules(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnLevelPermissionRuleProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnLevelPermissionRuleProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "columnLevelPermissionRules", value);
    }

    /**
     * The data preparation configuration associated with this dataset.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataPrepConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDataPrepConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "dataPrepConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The data preparation configuration associated with this dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataPrepConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataPrepConfiguration", value);
    }

    /**
     * The data preparation configuration associated with this dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataPrepConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSet.DataPrepConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "dataPrepConfiguration", value);
    }

    /**
     * An ID for the dataset that you want to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDataSetId() {
        return software.amazon.jsii.Kernel.get(this, "dataSetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An ID for the dataset that you want to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSetId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dataSetId", value);
    }

    /**
     * The parameters that are declared in a dataset.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DatasetParameterProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDatasetParameters() {
        return software.amazon.jsii.Kernel.get(this, "datasetParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The parameters that are declared in a dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatasetParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "datasetParameters", value);
    }

    /**
     * The parameters that are declared in a dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatasetParameters(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnDataSet.DatasetParameterProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.quicksight.CfnDataSet.DatasetParameterProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "datasetParameters", value);
    }

    /**
     * The refresh properties of a dataset.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetRefreshPropertiesProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDataSetRefreshProperties() {
        return software.amazon.jsii.Kernel.get(this, "dataSetRefreshProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The refresh properties of a dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSetRefreshProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataSetRefreshProperties", value);
    }

    /**
     * The refresh properties of a dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSetRefreshProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetRefreshPropertiesProperty value) {
        software.amazon.jsii.Kernel.set(this, "dataSetRefreshProperties", value);
    }

    /**
     * The usage configuration to apply to child datasets that reference this dataset as a source.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetUsageConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDataSetUsageConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "dataSetUsageConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The usage configuration to apply to child datasets that reference this dataset as a source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSetUsageConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataSetUsageConfiguration", value);
    }

    /**
     * The usage configuration to apply to child datasets that reference this dataset as a source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSetUsageConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetUsageConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "dataSetUsageConfiguration", value);
    }

    /**
     * The folder that contains fields and nested subfolders for your dataset.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or Map<String, either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.FieldFolderProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFieldFolders() {
        return software.amazon.jsii.Kernel.get(this, "fieldFolders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The folder that contains fields and nested subfolders for your dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFieldFolders(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "fieldFolders", value);
    }

    /**
     * The folder that contains fields and nested subfolders for your dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFieldFolders(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnDataSet.FieldFolderProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.quicksight.CfnDataSet.FieldFolderProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "fieldFolders", value);
    }

    /**
     * <p>When you create the dataset, Amazon QuickSight adds the dataset to these folders.</p>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFolderArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "folderArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * <p>When you create the dataset, Amazon QuickSight adds the dataset to these folders.</p>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFolderArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "folderArns", value);
    }

    /**
     * Indicates whether you want to import the data into SPICE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getImportMode() {
        return software.amazon.jsii.Kernel.get(this, "importMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates whether you want to import the data into SPICE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImportMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "importMode", value);
    }

    /**
     * The wait policy to use when creating or updating a Dataset.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.IngestionWaitPolicyProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIngestionWaitPolicy() {
        return software.amazon.jsii.Kernel.get(this, "ingestionWaitPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The wait policy to use when creating or updating a Dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIngestionWaitPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ingestionWaitPolicy", value);
    }

    /**
     * The wait policy to use when creating or updating a Dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIngestionWaitPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSet.IngestionWaitPolicyProperty value) {
        software.amazon.jsii.Kernel.set(this, "ingestionWaitPolicy", value);
    }

    /**
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or Map<String, either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.LogicalTableProperty}>
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogicalTableMap() {
        return software.amazon.jsii.Kernel.get(this, "logicalTableMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setLogicalTableMap(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "logicalTableMap", value);
    }

    /**
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setLogicalTableMap(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnDataSet.LogicalTableProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.quicksight.CfnDataSet.LogicalTableProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "logicalTableMap", value);
    }

    /**
     * The display name for the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The display name for the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The performance optimization configuration of a dataset.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.PerformanceConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPerformanceConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "performanceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The performance optimization configuration of a dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPerformanceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "performanceConfiguration", value);
    }

    /**
     * The performance optimization configuration of a dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPerformanceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSet.PerformanceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "performanceConfiguration", value);
    }

    /**
     * A list of resource permissions on the dataset.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.ResourcePermissionProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPermissions() {
        return software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of resource permissions on the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "permissions", value);
    }

    /**
     * A list of resource permissions on the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnDataSet.ResourcePermissionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.quicksight.CfnDataSet.ResourcePermissionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "permissions", value);
    }

    /**
     * Declares the physical tables that are available in the underlying data sources.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or Map<String, either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.PhysicalTableProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPhysicalTableMap() {
        return software.amazon.jsii.Kernel.get(this, "physicalTableMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Declares the physical tables that are available in the underlying data sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPhysicalTableMap(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "physicalTableMap", value);
    }

    /**
     * Declares the physical tables that are available in the underlying data sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPhysicalTableMap(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnDataSet.PhysicalTableProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.quicksight.CfnDataSet.PhysicalTableProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "physicalTableMap", value);
    }

    /**
     * (deprecated) <p>Information about a dataset that contains permissions for row-level security (RLS).
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.RowLevelPermissionDataSetProperty}
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.Nullable java.lang.Object getRowLevelPermissionDataSet() {
        return software.amazon.jsii.Kernel.get(this, "rowLevelPermissionDataSet", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * (deprecated) <p>Information about a dataset that contains permissions for row-level security (RLS).
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setRowLevelPermissionDataSet(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "rowLevelPermissionDataSet", value);
    }

    /**
     * (deprecated) <p>Information about a dataset that contains permissions for row-level security (RLS).
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setRowLevelPermissionDataSet(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSet.RowLevelPermissionDataSetProperty value) {
        software.amazon.jsii.Kernel.set(this, "rowLevelPermissionDataSet", value);
    }

    /**
     * (deprecated) <p>The configuration of tags on a dataset to set row-level security.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.RowLevelPermissionTagConfigurationProperty}
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.Nullable java.lang.Object getRowLevelPermissionTagConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "rowLevelPermissionTagConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * (deprecated) <p>The configuration of tags on a dataset to set row-level security.
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setRowLevelPermissionTagConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "rowLevelPermissionTagConfiguration", value);
    }

    /**
     * (deprecated) <p>The configuration of tags on a dataset to set row-level security.
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setRowLevelPermissionTagConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSet.RowLevelPermissionTagConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "rowLevelPermissionTagConfiguration", value);
    }

    /**
     * The semantic model configuration associated with this dataset.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.SemanticModelConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSemanticModelConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "semanticModelConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The semantic model configuration associated with this dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSemanticModelConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "semanticModelConfiguration", value);
    }

    /**
     * The semantic model configuration associated with this dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSemanticModelConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSet.SemanticModelConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "semanticModelConfiguration", value);
    }

    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The usage of the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getUseAs() {
        return software.amazon.jsii.Kernel.get(this, "useAs", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The usage of the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseAs(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "useAs", value);
    }
    /**
     * A transform operation that groups rows by specified columns and applies aggregation functions to calculate summary values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AggregateOperationProperty aggregateOperationProperty = AggregateOperationProperty.builder()
     *         .aggregations(List.of(AggregationProperty.builder()
     *                 .aggregationFunction(DataPrepAggregationFunctionProperty.builder()
     *                         .listAggregation(DataPrepListAggregationFunctionProperty.builder()
     *                                 .distinct(false)
     *                                 .separator("separator")
     *                                 // the properties below are optional
     *                                 .inputColumnName("inputColumnName")
     *                                 .build())
     *                         .percentileAggregation(DataPrepPercentileAggregationFunctionProperty.builder()
     *                                 .percentileValue(123)
     *                                 // the properties below are optional
     *                                 .inputColumnName("inputColumnName")
     *                                 .build())
     *                         .simpleAggregation(DataPrepSimpleAggregationFunctionProperty.builder()
     *                                 .functionType("functionType")
     *                                 // the properties below are optional
     *                                 .inputColumnName("inputColumnName")
     *                                 .build())
     *                         .build())
     *                 .newColumnId("newColumnId")
     *                 .newColumnName("newColumnName")
     *                 .build()))
     *         .alias("alias")
     *         .source(TransformOperationSourceProperty.builder()
     *                 .transformOperationId("transformOperationId")
     *                 // the properties below are optional
     *                 .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                         .sourceColumnId("sourceColumnId")
     *                         .targetColumnId("targetColumnId")
     *                         .build()))
     *                 .build())
     *         // the properties below are optional
     *         .groupByColumnNames(List.of("groupByColumnNames"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-aggregateoperation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-aggregateoperation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.AggregateOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(AggregateOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AggregateOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of aggregation functions to apply to the grouped data, such as <code>SUM</code> , <code>COUNT</code> , or <code>AVERAGE</code> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.AggregationProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-aggregateoperation.html#cfn-quicksight-dataset-aggregateoperation-aggregations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-aggregateoperation.html#cfn-quicksight-dataset-aggregateoperation-aggregations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAggregations();

        /**
         * Alias for this operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-aggregateoperation.html#cfn-quicksight-dataset-aggregateoperation-alias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-aggregateoperation.html#cfn-quicksight-dataset-aggregateoperation-alias</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlias();

        /**
         * The source transform operation that provides input data for the aggregation.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.TransformOperationSourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-aggregateoperation.html#cfn-quicksight-dataset-aggregateoperation-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-aggregateoperation.html#cfn-quicksight-dataset-aggregateoperation-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSource();

        /**
         * The list of column names to group by when performing the aggregation.
         * <p>
         * Rows with the same values in these columns will be grouped together.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-aggregateoperation.html#cfn-quicksight-dataset-aggregateoperation-groupbycolumnnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-aggregateoperation.html#cfn-quicksight-dataset-aggregateoperation-groupbycolumnnames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGroupByColumnNames() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AggregateOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AggregateOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AggregateOperationProperty> {
            java.lang.Object aggregations;
            java.lang.String alias;
            java.lang.Object source;
            java.util.List<java.lang.String> groupByColumnNames;

            /**
             * Sets the value of {@link AggregateOperationProperty#getAggregations}
             * @param aggregations The list of aggregation functions to apply to the grouped data, such as <code>SUM</code> , <code>COUNT</code> , or <code>AVERAGE</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregations(software.amazon.awscdk.IResolvable aggregations) {
                this.aggregations = aggregations;
                return this;
            }

            /**
             * Sets the value of {@link AggregateOperationProperty#getAggregations}
             * @param aggregations The list of aggregation functions to apply to the grouped data, such as <code>SUM</code> , <code>COUNT</code> , or <code>AVERAGE</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregations(java.util.List<? extends java.lang.Object> aggregations) {
                this.aggregations = aggregations;
                return this;
            }

            /**
             * Sets the value of {@link AggregateOperationProperty#getAlias}
             * @param alias Alias for this operation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alias(java.lang.String alias) {
                this.alias = alias;
                return this;
            }

            /**
             * Sets the value of {@link AggregateOperationProperty#getSource}
             * @param source The source transform operation that provides input data for the aggregation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.IResolvable source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link AggregateOperationProperty#getSource}
             * @param source The source transform operation that provides input data for the aggregation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.services.quicksight.CfnDataSet.TransformOperationSourceProperty source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link AggregateOperationProperty#getGroupByColumnNames}
             * @param groupByColumnNames The list of column names to group by when performing the aggregation.
             *                           Rows with the same values in these columns will be grouped together.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupByColumnNames(java.util.List<java.lang.String> groupByColumnNames) {
                this.groupByColumnNames = groupByColumnNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AggregateOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AggregateOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AggregateOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AggregateOperationProperty {
            private final java.lang.Object aggregations;
            private final java.lang.String alias;
            private final java.lang.Object source;
            private final java.util.List<java.lang.String> groupByColumnNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aggregations = software.amazon.jsii.Kernel.get(this, "aggregations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.groupByColumnNames = software.amazon.jsii.Kernel.get(this, "groupByColumnNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aggregations = java.util.Objects.requireNonNull(builder.aggregations, "aggregations is required");
                this.alias = java.util.Objects.requireNonNull(builder.alias, "alias is required");
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
                this.groupByColumnNames = builder.groupByColumnNames;
            }

            @Override
            public final java.lang.Object getAggregations() {
                return this.aggregations;
            }

            @Override
            public final java.lang.String getAlias() {
                return this.alias;
            }

            @Override
            public final java.lang.Object getSource() {
                return this.source;
            }

            @Override
            public final java.util.List<java.lang.String> getGroupByColumnNames() {
                return this.groupByColumnNames;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("aggregations", om.valueToTree(this.getAggregations()));
                data.set("alias", om.valueToTree(this.getAlias()));
                data.set("source", om.valueToTree(this.getSource()));
                if (this.getGroupByColumnNames() != null) {
                    data.set("groupByColumnNames", om.valueToTree(this.getGroupByColumnNames()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.AggregateOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AggregateOperationProperty.Jsii$Proxy that = (AggregateOperationProperty.Jsii$Proxy) o;

                if (!aggregations.equals(that.aggregations)) return false;
                if (!alias.equals(that.alias)) return false;
                if (!source.equals(that.source)) return false;
                return this.groupByColumnNames != null ? this.groupByColumnNames.equals(that.groupByColumnNames) : that.groupByColumnNames == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aggregations.hashCode();
                result = 31 * result + (this.alias.hashCode());
                result = 31 * result + (this.source.hashCode());
                result = 31 * result + (this.groupByColumnNames != null ? this.groupByColumnNames.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines an aggregation function to be applied to grouped data, creating a new column with the calculated result.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AggregationProperty aggregationProperty = AggregationProperty.builder()
     *         .aggregationFunction(DataPrepAggregationFunctionProperty.builder()
     *                 .listAggregation(DataPrepListAggregationFunctionProperty.builder()
     *                         .distinct(false)
     *                         .separator("separator")
     *                         // the properties below are optional
     *                         .inputColumnName("inputColumnName")
     *                         .build())
     *                 .percentileAggregation(DataPrepPercentileAggregationFunctionProperty.builder()
     *                         .percentileValue(123)
     *                         // the properties below are optional
     *                         .inputColumnName("inputColumnName")
     *                         .build())
     *                 .simpleAggregation(DataPrepSimpleAggregationFunctionProperty.builder()
     *                         .functionType("functionType")
     *                         // the properties below are optional
     *                         .inputColumnName("inputColumnName")
     *                         .build())
     *                 .build())
     *         .newColumnId("newColumnId")
     *         .newColumnName("newColumnName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-aggregation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-aggregation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.AggregationProperty")
    @software.amazon.jsii.Jsii.Proxy(AggregationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AggregationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The aggregation function to apply, such as <code>SUM</code> , <code>COUNT</code> , <code>AVERAGE</code> , <code>MIN</code> , <code>MAX</code>.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataPrepAggregationFunctionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-aggregation.html#cfn-quicksight-dataset-aggregation-aggregationfunction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-aggregation.html#cfn-quicksight-dataset-aggregation-aggregationfunction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAggregationFunction();

        /**
         * A unique identifier for the new column that will contain the aggregated values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-aggregation.html#cfn-quicksight-dataset-aggregation-newcolumnid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-aggregation.html#cfn-quicksight-dataset-aggregation-newcolumnid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNewColumnId();

        /**
         * The name for the new column that will contain the aggregated values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-aggregation.html#cfn-quicksight-dataset-aggregation-newcolumnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-aggregation.html#cfn-quicksight-dataset-aggregation-newcolumnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNewColumnName();

        /**
         * @return a {@link Builder} of {@link AggregationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AggregationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AggregationProperty> {
            java.lang.Object aggregationFunction;
            java.lang.String newColumnId;
            java.lang.String newColumnName;

            /**
             * Sets the value of {@link AggregationProperty#getAggregationFunction}
             * @param aggregationFunction The aggregation function to apply, such as <code>SUM</code> , <code>COUNT</code> , <code>AVERAGE</code> , <code>MIN</code> , <code>MAX</code>. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregationFunction(software.amazon.awscdk.IResolvable aggregationFunction) {
                this.aggregationFunction = aggregationFunction;
                return this;
            }

            /**
             * Sets the value of {@link AggregationProperty#getAggregationFunction}
             * @param aggregationFunction The aggregation function to apply, such as <code>SUM</code> , <code>COUNT</code> , <code>AVERAGE</code> , <code>MIN</code> , <code>MAX</code>. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregationFunction(software.amazon.awscdk.services.quicksight.CfnDataSet.DataPrepAggregationFunctionProperty aggregationFunction) {
                this.aggregationFunction = aggregationFunction;
                return this;
            }

            /**
             * Sets the value of {@link AggregationProperty#getNewColumnId}
             * @param newColumnId A unique identifier for the new column that will contain the aggregated values. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder newColumnId(java.lang.String newColumnId) {
                this.newColumnId = newColumnId;
                return this;
            }

            /**
             * Sets the value of {@link AggregationProperty#getNewColumnName}
             * @param newColumnName The name for the new column that will contain the aggregated values. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder newColumnName(java.lang.String newColumnName) {
                this.newColumnName = newColumnName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AggregationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AggregationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AggregationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AggregationProperty {
            private final java.lang.Object aggregationFunction;
            private final java.lang.String newColumnId;
            private final java.lang.String newColumnName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aggregationFunction = software.amazon.jsii.Kernel.get(this, "aggregationFunction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.newColumnId = software.amazon.jsii.Kernel.get(this, "newColumnId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.newColumnName = software.amazon.jsii.Kernel.get(this, "newColumnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aggregationFunction = java.util.Objects.requireNonNull(builder.aggregationFunction, "aggregationFunction is required");
                this.newColumnId = java.util.Objects.requireNonNull(builder.newColumnId, "newColumnId is required");
                this.newColumnName = java.util.Objects.requireNonNull(builder.newColumnName, "newColumnName is required");
            }

            @Override
            public final java.lang.Object getAggregationFunction() {
                return this.aggregationFunction;
            }

            @Override
            public final java.lang.String getNewColumnId() {
                return this.newColumnId;
            }

            @Override
            public final java.lang.String getNewColumnName() {
                return this.newColumnName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("aggregationFunction", om.valueToTree(this.getAggregationFunction()));
                data.set("newColumnId", om.valueToTree(this.getNewColumnId()));
                data.set("newColumnName", om.valueToTree(this.getNewColumnName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.AggregationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AggregationProperty.Jsii$Proxy that = (AggregationProperty.Jsii$Proxy) o;

                if (!aggregationFunction.equals(that.aggregationFunction)) return false;
                if (!newColumnId.equals(that.newColumnId)) return false;
                return this.newColumnName.equals(that.newColumnName);
            }

            @Override
            public final int hashCode() {
                int result = this.aggregationFunction.hashCode();
                result = 31 * result + (this.newColumnId.hashCode());
                result = 31 * result + (this.newColumnName.hashCode());
                return result;
            }
        }
    }
    /**
     * A transform operation that combines rows from two data sources by stacking them vertically (union operation).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AppendOperationProperty appendOperationProperty = AppendOperationProperty.builder()
     *         .alias("alias")
     *         .appendedColumns(List.of(AppendedColumnProperty.builder()
     *                 .columnName("columnName")
     *                 .newColumnId("newColumnId")
     *                 .build()))
     *         // the properties below are optional
     *         .firstSource(TransformOperationSourceProperty.builder()
     *                 .transformOperationId("transformOperationId")
     *                 // the properties below are optional
     *                 .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                         .sourceColumnId("sourceColumnId")
     *                         .targetColumnId("targetColumnId")
     *                         .build()))
     *                 .build())
     *         .secondSource(TransformOperationSourceProperty.builder()
     *                 .transformOperationId("transformOperationId")
     *                 // the properties below are optional
     *                 .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                         .sourceColumnId("sourceColumnId")
     *                         .targetColumnId("targetColumnId")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-appendoperation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-appendoperation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.AppendOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(AppendOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AppendOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Alias for this operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-appendoperation.html#cfn-quicksight-dataset-appendoperation-alias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-appendoperation.html#cfn-quicksight-dataset-appendoperation-alias</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlias();

        /**
         * The list of columns to include in the appended result, mapping columns from both sources.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.AppendedColumnProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-appendoperation.html#cfn-quicksight-dataset-appendoperation-appendedcolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-appendoperation.html#cfn-quicksight-dataset-appendoperation-appendedcolumns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAppendedColumns();

        /**
         * The first data source to be included in the append operation.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.TransformOperationSourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-appendoperation.html#cfn-quicksight-dataset-appendoperation-firstsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-appendoperation.html#cfn-quicksight-dataset-appendoperation-firstsource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFirstSource() {
            return null;
        }

        /**
         * The second data source to be appended to the first source.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.TransformOperationSourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-appendoperation.html#cfn-quicksight-dataset-appendoperation-secondsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-appendoperation.html#cfn-quicksight-dataset-appendoperation-secondsource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecondSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AppendOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AppendOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AppendOperationProperty> {
            java.lang.String alias;
            java.lang.Object appendedColumns;
            java.lang.Object firstSource;
            java.lang.Object secondSource;

            /**
             * Sets the value of {@link AppendOperationProperty#getAlias}
             * @param alias Alias for this operation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alias(java.lang.String alias) {
                this.alias = alias;
                return this;
            }

            /**
             * Sets the value of {@link AppendOperationProperty#getAppendedColumns}
             * @param appendedColumns The list of columns to include in the appended result, mapping columns from both sources. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appendedColumns(software.amazon.awscdk.IResolvable appendedColumns) {
                this.appendedColumns = appendedColumns;
                return this;
            }

            /**
             * Sets the value of {@link AppendOperationProperty#getAppendedColumns}
             * @param appendedColumns The list of columns to include in the appended result, mapping columns from both sources. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appendedColumns(java.util.List<? extends java.lang.Object> appendedColumns) {
                this.appendedColumns = appendedColumns;
                return this;
            }

            /**
             * Sets the value of {@link AppendOperationProperty#getFirstSource}
             * @param firstSource The first data source to be included in the append operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firstSource(software.amazon.awscdk.IResolvable firstSource) {
                this.firstSource = firstSource;
                return this;
            }

            /**
             * Sets the value of {@link AppendOperationProperty#getFirstSource}
             * @param firstSource The first data source to be included in the append operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firstSource(software.amazon.awscdk.services.quicksight.CfnDataSet.TransformOperationSourceProperty firstSource) {
                this.firstSource = firstSource;
                return this;
            }

            /**
             * Sets the value of {@link AppendOperationProperty#getSecondSource}
             * @param secondSource The second data source to be appended to the first source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondSource(software.amazon.awscdk.IResolvable secondSource) {
                this.secondSource = secondSource;
                return this;
            }

            /**
             * Sets the value of {@link AppendOperationProperty#getSecondSource}
             * @param secondSource The second data source to be appended to the first source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondSource(software.amazon.awscdk.services.quicksight.CfnDataSet.TransformOperationSourceProperty secondSource) {
                this.secondSource = secondSource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AppendOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AppendOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AppendOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppendOperationProperty {
            private final java.lang.String alias;
            private final java.lang.Object appendedColumns;
            private final java.lang.Object firstSource;
            private final java.lang.Object secondSource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.appendedColumns = software.amazon.jsii.Kernel.get(this, "appendedColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.firstSource = software.amazon.jsii.Kernel.get(this, "firstSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secondSource = software.amazon.jsii.Kernel.get(this, "secondSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alias = java.util.Objects.requireNonNull(builder.alias, "alias is required");
                this.appendedColumns = java.util.Objects.requireNonNull(builder.appendedColumns, "appendedColumns is required");
                this.firstSource = builder.firstSource;
                this.secondSource = builder.secondSource;
            }

            @Override
            public final java.lang.String getAlias() {
                return this.alias;
            }

            @Override
            public final java.lang.Object getAppendedColumns() {
                return this.appendedColumns;
            }

            @Override
            public final java.lang.Object getFirstSource() {
                return this.firstSource;
            }

            @Override
            public final java.lang.Object getSecondSource() {
                return this.secondSource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alias", om.valueToTree(this.getAlias()));
                data.set("appendedColumns", om.valueToTree(this.getAppendedColumns()));
                if (this.getFirstSource() != null) {
                    data.set("firstSource", om.valueToTree(this.getFirstSource()));
                }
                if (this.getSecondSource() != null) {
                    data.set("secondSource", om.valueToTree(this.getSecondSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.AppendOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AppendOperationProperty.Jsii$Proxy that = (AppendOperationProperty.Jsii$Proxy) o;

                if (!alias.equals(that.alias)) return false;
                if (!appendedColumns.equals(that.appendedColumns)) return false;
                if (this.firstSource != null ? !this.firstSource.equals(that.firstSource) : that.firstSource != null) return false;
                return this.secondSource != null ? this.secondSource.equals(that.secondSource) : that.secondSource == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alias.hashCode();
                result = 31 * result + (this.appendedColumns.hashCode());
                result = 31 * result + (this.firstSource != null ? this.firstSource.hashCode() : 0);
                result = 31 * result + (this.secondSource != null ? this.secondSource.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a column that will be included in the result of an append operation, combining data from multiple sources.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * AppendedColumnProperty appendedColumnProperty = AppendedColumnProperty.builder()
     *         .columnName("columnName")
     *         .newColumnId("newColumnId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-appendedcolumn.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-appendedcolumn.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.AppendedColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(AppendedColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AppendedColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the column to include in the appended result.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-appendedcolumn.html#cfn-quicksight-dataset-appendedcolumn-columnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-appendedcolumn.html#cfn-quicksight-dataset-appendedcolumn-columnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnName();

        /**
         * A unique identifier for the column in the appended result.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-appendedcolumn.html#cfn-quicksight-dataset-appendedcolumn-newcolumnid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-appendedcolumn.html#cfn-quicksight-dataset-appendedcolumn-newcolumnid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNewColumnId();

        /**
         * @return a {@link Builder} of {@link AppendedColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AppendedColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AppendedColumnProperty> {
            java.lang.String columnName;
            java.lang.String newColumnId;

            /**
             * Sets the value of {@link AppendedColumnProperty#getColumnName}
             * @param columnName The name of the column to include in the appended result. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link AppendedColumnProperty#getNewColumnId}
             * @param newColumnId A unique identifier for the column in the appended result. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder newColumnId(java.lang.String newColumnId) {
                this.newColumnId = newColumnId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AppendedColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AppendedColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AppendedColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppendedColumnProperty {
            private final java.lang.String columnName;
            private final java.lang.String newColumnId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.newColumnId = software.amazon.jsii.Kernel.get(this, "newColumnId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnName = java.util.Objects.requireNonNull(builder.columnName, "columnName is required");
                this.newColumnId = java.util.Objects.requireNonNull(builder.newColumnId, "newColumnId is required");
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.lang.String getNewColumnId() {
                return this.newColumnId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnName", om.valueToTree(this.getColumnName()));
                data.set("newColumnId", om.valueToTree(this.getNewColumnId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.AppendedColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AppendedColumnProperty.Jsii$Proxy that = (AppendedColumnProperty.Jsii$Proxy) o;

                if (!columnName.equals(that.columnName)) return false;
                return this.newColumnId.equals(that.newColumnId);
            }

            @Override
            public final int hashCode() {
                int result = this.columnName.hashCode();
                result = 31 * result + (this.newColumnId.hashCode());
                return result;
            }
        }
    }
    /**
     * A calculated column for a dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CalculatedColumnProperty calculatedColumnProperty = CalculatedColumnProperty.builder()
     *         .columnId("columnId")
     *         .columnName("columnName")
     *         .expression("expression")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-calculatedcolumn.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-calculatedcolumn.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.CalculatedColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(CalculatedColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CalculatedColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A unique ID to identify a calculated column.
         * <p>
         * During a dataset update, if the column ID of a calculated column matches that of an existing calculated column, Quick Sight preserves the existing calculated column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-calculatedcolumn.html#cfn-quicksight-dataset-calculatedcolumn-columnid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-calculatedcolumn.html#cfn-quicksight-dataset-calculatedcolumn-columnid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnId();

        /**
         * Column name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-calculatedcolumn.html#cfn-quicksight-dataset-calculatedcolumn-columnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-calculatedcolumn.html#cfn-quicksight-dataset-calculatedcolumn-columnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnName();

        /**
         * An expression that defines the calculated column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-calculatedcolumn.html#cfn-quicksight-dataset-calculatedcolumn-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-calculatedcolumn.html#cfn-quicksight-dataset-calculatedcolumn-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExpression();

        /**
         * @return a {@link Builder} of {@link CalculatedColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CalculatedColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CalculatedColumnProperty> {
            java.lang.String columnId;
            java.lang.String columnName;
            java.lang.String expression;

            /**
             * Sets the value of {@link CalculatedColumnProperty#getColumnId}
             * @param columnId A unique ID to identify a calculated column. This parameter is required.
             *                 During a dataset update, if the column ID of a calculated column matches that of an existing calculated column, Quick Sight preserves the existing calculated column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnId(java.lang.String columnId) {
                this.columnId = columnId;
                return this;
            }

            /**
             * Sets the value of {@link CalculatedColumnProperty#getColumnName}
             * @param columnName Column name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link CalculatedColumnProperty#getExpression}
             * @param expression An expression that defines the calculated column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CalculatedColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CalculatedColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CalculatedColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CalculatedColumnProperty {
            private final java.lang.String columnId;
            private final java.lang.String columnName;
            private final java.lang.String expression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnId = software.amazon.jsii.Kernel.get(this, "columnId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnId = java.util.Objects.requireNonNull(builder.columnId, "columnId is required");
                this.columnName = java.util.Objects.requireNonNull(builder.columnName, "columnName is required");
                this.expression = java.util.Objects.requireNonNull(builder.expression, "expression is required");
            }

            @Override
            public final java.lang.String getColumnId() {
                return this.columnId;
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnId", om.valueToTree(this.getColumnId()));
                data.set("columnName", om.valueToTree(this.getColumnName()));
                data.set("expression", om.valueToTree(this.getExpression()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.CalculatedColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CalculatedColumnProperty.Jsii$Proxy that = (CalculatedColumnProperty.Jsii$Proxy) o;

                if (!columnId.equals(that.columnId)) return false;
                if (!columnName.equals(that.columnName)) return false;
                return this.expression.equals(that.expression);
            }

            @Override
            public final int hashCode() {
                int result = this.columnId.hashCode();
                result = 31 * result + (this.columnName.hashCode());
                result = 31 * result + (this.expression.hashCode());
                return result;
            }
        }
    }
    /**
     * A transform operation that casts a column to a different type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CastColumnTypeOperationProperty castColumnTypeOperationProperty = CastColumnTypeOperationProperty.builder()
     *         .columnName("columnName")
     *         .newColumnType("newColumnType")
     *         // the properties below are optional
     *         .format("format")
     *         .subType("subType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.CastColumnTypeOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(CastColumnTypeOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CastColumnTypeOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Column name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html#cfn-quicksight-dataset-castcolumntypeoperation-columnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html#cfn-quicksight-dataset-castcolumntypeoperation-columnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnName();

        /**
         * New column data type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html#cfn-quicksight-dataset-castcolumntypeoperation-newcolumntype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html#cfn-quicksight-dataset-castcolumntypeoperation-newcolumntype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNewColumnType();

        /**
         * When casting a column from string to datetime type, you can supply a string in a format supported by Quick Sight to denote the source data format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html#cfn-quicksight-dataset-castcolumntypeoperation-format">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html#cfn-quicksight-dataset-castcolumntypeoperation-format</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFormat() {
            return null;
        }

        /**
         * The sub data type of the new column.
         * <p>
         * Sub types are only available for decimal columns that are part of a SPICE dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html#cfn-quicksight-dataset-castcolumntypeoperation-subtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html#cfn-quicksight-dataset-castcolumntypeoperation-subtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CastColumnTypeOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CastColumnTypeOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CastColumnTypeOperationProperty> {
            java.lang.String columnName;
            java.lang.String newColumnType;
            java.lang.String format;
            java.lang.String subType;

            /**
             * Sets the value of {@link CastColumnTypeOperationProperty#getColumnName}
             * @param columnName Column name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link CastColumnTypeOperationProperty#getNewColumnType}
             * @param newColumnType New column data type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder newColumnType(java.lang.String newColumnType) {
                this.newColumnType = newColumnType;
                return this;
            }

            /**
             * Sets the value of {@link CastColumnTypeOperationProperty#getFormat}
             * @param format When casting a column from string to datetime type, you can supply a string in a format supported by Quick Sight to denote the source data format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Sets the value of {@link CastColumnTypeOperationProperty#getSubType}
             * @param subType The sub data type of the new column.
             *                Sub types are only available for decimal columns that are part of a SPICE dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subType(java.lang.String subType) {
                this.subType = subType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CastColumnTypeOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CastColumnTypeOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CastColumnTypeOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CastColumnTypeOperationProperty {
            private final java.lang.String columnName;
            private final java.lang.String newColumnType;
            private final java.lang.String format;
            private final java.lang.String subType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.newColumnType = software.amazon.jsii.Kernel.get(this, "newColumnType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subType = software.amazon.jsii.Kernel.get(this, "subType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnName = java.util.Objects.requireNonNull(builder.columnName, "columnName is required");
                this.newColumnType = java.util.Objects.requireNonNull(builder.newColumnType, "newColumnType is required");
                this.format = builder.format;
                this.subType = builder.subType;
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.lang.String getNewColumnType() {
                return this.newColumnType;
            }

            @Override
            public final java.lang.String getFormat() {
                return this.format;
            }

            @Override
            public final java.lang.String getSubType() {
                return this.subType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnName", om.valueToTree(this.getColumnName()));
                data.set("newColumnType", om.valueToTree(this.getNewColumnType()));
                if (this.getFormat() != null) {
                    data.set("format", om.valueToTree(this.getFormat()));
                }
                if (this.getSubType() != null) {
                    data.set("subType", om.valueToTree(this.getSubType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.CastColumnTypeOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CastColumnTypeOperationProperty.Jsii$Proxy that = (CastColumnTypeOperationProperty.Jsii$Proxy) o;

                if (!columnName.equals(that.columnName)) return false;
                if (!newColumnType.equals(that.newColumnType)) return false;
                if (this.format != null ? !this.format.equals(that.format) : that.format != null) return false;
                return this.subType != null ? this.subType.equals(that.subType) : that.subType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnName.hashCode();
                result = 31 * result + (this.newColumnType.hashCode());
                result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
                result = 31 * result + (this.subType != null ? this.subType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A transform operation that changes the data types of one or more columns in the dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CastColumnTypesOperationProperty castColumnTypesOperationProperty = CastColumnTypesOperationProperty.builder()
     *         .alias("alias")
     *         .castColumnTypeOperations(List.of(CastColumnTypeOperationProperty.builder()
     *                 .columnName("columnName")
     *                 .newColumnType("newColumnType")
     *                 // the properties below are optional
     *                 .format("format")
     *                 .subType("subType")
     *                 .build()))
     *         .source(TransformOperationSourceProperty.builder()
     *                 .transformOperationId("transformOperationId")
     *                 // the properties below are optional
     *                 .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                         .sourceColumnId("sourceColumnId")
     *                         .targetColumnId("targetColumnId")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypesoperation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypesoperation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.CastColumnTypesOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(CastColumnTypesOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CastColumnTypesOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Alias for this operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypesoperation.html#cfn-quicksight-dataset-castcolumntypesoperation-alias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypesoperation.html#cfn-quicksight-dataset-castcolumntypesoperation-alias</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlias();

        /**
         * The list of column type casting operations to perform.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.CastColumnTypeOperationProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypesoperation.html#cfn-quicksight-dataset-castcolumntypesoperation-castcolumntypeoperations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypesoperation.html#cfn-quicksight-dataset-castcolumntypesoperation-castcolumntypeoperations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCastColumnTypeOperations();

        /**
         * The source transform operation that provides input data for the type casting.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.TransformOperationSourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypesoperation.html#cfn-quicksight-dataset-castcolumntypesoperation-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypesoperation.html#cfn-quicksight-dataset-castcolumntypesoperation-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSource();

        /**
         * @return a {@link Builder} of {@link CastColumnTypesOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CastColumnTypesOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CastColumnTypesOperationProperty> {
            java.lang.String alias;
            java.lang.Object castColumnTypeOperations;
            java.lang.Object source;

            /**
             * Sets the value of {@link CastColumnTypesOperationProperty#getAlias}
             * @param alias Alias for this operation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alias(java.lang.String alias) {
                this.alias = alias;
                return this;
            }

            /**
             * Sets the value of {@link CastColumnTypesOperationProperty#getCastColumnTypeOperations}
             * @param castColumnTypeOperations The list of column type casting operations to perform. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder castColumnTypeOperations(software.amazon.awscdk.IResolvable castColumnTypeOperations) {
                this.castColumnTypeOperations = castColumnTypeOperations;
                return this;
            }

            /**
             * Sets the value of {@link CastColumnTypesOperationProperty#getCastColumnTypeOperations}
             * @param castColumnTypeOperations The list of column type casting operations to perform. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder castColumnTypeOperations(java.util.List<? extends java.lang.Object> castColumnTypeOperations) {
                this.castColumnTypeOperations = castColumnTypeOperations;
                return this;
            }

            /**
             * Sets the value of {@link CastColumnTypesOperationProperty#getSource}
             * @param source The source transform operation that provides input data for the type casting. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.IResolvable source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link CastColumnTypesOperationProperty#getSource}
             * @param source The source transform operation that provides input data for the type casting. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.services.quicksight.CfnDataSet.TransformOperationSourceProperty source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CastColumnTypesOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CastColumnTypesOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CastColumnTypesOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CastColumnTypesOperationProperty {
            private final java.lang.String alias;
            private final java.lang.Object castColumnTypeOperations;
            private final java.lang.Object source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.castColumnTypeOperations = software.amazon.jsii.Kernel.get(this, "castColumnTypeOperations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alias = java.util.Objects.requireNonNull(builder.alias, "alias is required");
                this.castColumnTypeOperations = java.util.Objects.requireNonNull(builder.castColumnTypeOperations, "castColumnTypeOperations is required");
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            }

            @Override
            public final java.lang.String getAlias() {
                return this.alias;
            }

            @Override
            public final java.lang.Object getCastColumnTypeOperations() {
                return this.castColumnTypeOperations;
            }

            @Override
            public final java.lang.Object getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alias", om.valueToTree(this.getAlias()));
                data.set("castColumnTypeOperations", om.valueToTree(this.getCastColumnTypeOperations()));
                data.set("source", om.valueToTree(this.getSource()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.CastColumnTypesOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CastColumnTypesOperationProperty.Jsii$Proxy that = (CastColumnTypesOperationProperty.Jsii$Proxy) o;

                if (!alias.equals(that.alias)) return false;
                if (!castColumnTypeOperations.equals(that.castColumnTypeOperations)) return false;
                return this.source.equals(that.source);
            }

            @Override
            public final int hashCode() {
                int result = this.alias.hashCode();
                result = 31 * result + (this.castColumnTypeOperations.hashCode());
                result = 31 * result + (this.source.hashCode());
                return result;
            }
        }
    }
    /**
     * Metadata that contains a description for a column.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ColumnDescriptionProperty columnDescriptionProperty = ColumnDescriptionProperty.builder()
     *         .text("text")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columndescription.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columndescription.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.ColumnDescriptionProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnDescriptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnDescriptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The text of a description for a column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columndescription.html#cfn-quicksight-dataset-columndescription-text">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columndescription.html#cfn-quicksight-dataset-columndescription-text</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getText() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnDescriptionProperty> {
            java.lang.String text;

            /**
             * Sets the value of {@link ColumnDescriptionProperty#getText}
             * @param text The text of a description for a column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(java.lang.String text) {
                this.text = text;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnDescriptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnDescriptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnDescriptionProperty {
            private final java.lang.String text;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.text = builder.text;
            }

            @Override
            public final java.lang.String getText() {
                return this.text;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getText() != null) {
                    data.set("text", om.valueToTree(this.getText()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.ColumnDescriptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnDescriptionProperty.Jsii$Proxy that = (ColumnDescriptionProperty.Jsii$Proxy) o;

                return this.text != null ? this.text.equals(that.text) : that.text == null;
            }

            @Override
            public final int hashCode() {
                int result = this.text != null ? this.text.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Groupings of columns that work together in certain Quick Sight features.
     * <p>
     * This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ColumnGroupProperty columnGroupProperty = ColumnGroupProperty.builder()
     *         .geoSpatialColumnGroup(GeoSpatialColumnGroupProperty.builder()
     *                 .columns(List.of("columns"))
     *                 .name("name")
     *                 // the properties below are optional
     *                 .countryCode("countryCode")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columngroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columngroup.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.ColumnGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Geospatial column group that denotes a hierarchy.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.GeoSpatialColumnGroupProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columngroup.html#cfn-quicksight-dataset-columngroup-geospatialcolumngroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columngroup.html#cfn-quicksight-dataset-columngroup-geospatialcolumngroup</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGeoSpatialColumnGroup() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnGroupProperty> {
            java.lang.Object geoSpatialColumnGroup;

            /**
             * Sets the value of {@link ColumnGroupProperty#getGeoSpatialColumnGroup}
             * @param geoSpatialColumnGroup Geospatial column group that denotes a hierarchy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder geoSpatialColumnGroup(software.amazon.awscdk.IResolvable geoSpatialColumnGroup) {
                this.geoSpatialColumnGroup = geoSpatialColumnGroup;
                return this;
            }

            /**
             * Sets the value of {@link ColumnGroupProperty#getGeoSpatialColumnGroup}
             * @param geoSpatialColumnGroup Geospatial column group that denotes a hierarchy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder geoSpatialColumnGroup(software.amazon.awscdk.services.quicksight.CfnDataSet.GeoSpatialColumnGroupProperty geoSpatialColumnGroup) {
                this.geoSpatialColumnGroup = geoSpatialColumnGroup;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnGroupProperty {
            private final java.lang.Object geoSpatialColumnGroup;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.geoSpatialColumnGroup = software.amazon.jsii.Kernel.get(this, "geoSpatialColumnGroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.geoSpatialColumnGroup = builder.geoSpatialColumnGroup;
            }

            @Override
            public final java.lang.Object getGeoSpatialColumnGroup() {
                return this.geoSpatialColumnGroup;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGeoSpatialColumnGroup() != null) {
                    data.set("geoSpatialColumnGroup", om.valueToTree(this.getGeoSpatialColumnGroup()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.ColumnGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnGroupProperty.Jsii$Proxy that = (ColumnGroupProperty.Jsii$Proxy) o;

                return this.geoSpatialColumnGroup != null ? this.geoSpatialColumnGroup.equals(that.geoSpatialColumnGroup) : that.geoSpatialColumnGroup == null;
            }

            @Override
            public final int hashCode() {
                int result = this.geoSpatialColumnGroup != null ? this.geoSpatialColumnGroup.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A rule defined to grant access on one or more restricted columns.
     * <p>
     * Each dataset can have multiple rules. To create a restricted column, you add it to one or more rules. Each rule must contain at least one column and at least one user or group. To be able to see a restricted column, a user or group needs to be added to a rule for that column.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ColumnLevelPermissionRuleProperty columnLevelPermissionRuleProperty = ColumnLevelPermissionRuleProperty.builder()
     *         .columnNames(List.of("columnNames"))
     *         .principals(List.of("principals"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columnlevelpermissionrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columnlevelpermissionrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.ColumnLevelPermissionRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnLevelPermissionRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnLevelPermissionRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of column names.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columnlevelpermissionrule.html#cfn-quicksight-dataset-columnlevelpermissionrule-columnnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columnlevelpermissionrule.html#cfn-quicksight-dataset-columnlevelpermissionrule-columnnames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getColumnNames() {
            return null;
        }

        /**
         * An array of Amazon Resource Names (ARNs) for Quick Suite users or groups.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columnlevelpermissionrule.html#cfn-quicksight-dataset-columnlevelpermissionrule-principals">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columnlevelpermissionrule.html#cfn-quicksight-dataset-columnlevelpermissionrule-principals</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPrincipals() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnLevelPermissionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnLevelPermissionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnLevelPermissionRuleProperty> {
            java.util.List<java.lang.String> columnNames;
            java.util.List<java.lang.String> principals;

            /**
             * Sets the value of {@link ColumnLevelPermissionRuleProperty#getColumnNames}
             * @param columnNames An array of column names.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnNames(java.util.List<java.lang.String> columnNames) {
                this.columnNames = columnNames;
                return this;
            }

            /**
             * Sets the value of {@link ColumnLevelPermissionRuleProperty#getPrincipals}
             * @param principals An array of Amazon Resource Names (ARNs) for Quick Suite users or groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder principals(java.util.List<java.lang.String> principals) {
                this.principals = principals;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnLevelPermissionRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnLevelPermissionRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnLevelPermissionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnLevelPermissionRuleProperty {
            private final java.util.List<java.lang.String> columnNames;
            private final java.util.List<java.lang.String> principals;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnNames = software.amazon.jsii.Kernel.get(this, "columnNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.principals = software.amazon.jsii.Kernel.get(this, "principals", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnNames = builder.columnNames;
                this.principals = builder.principals;
            }

            @Override
            public final java.util.List<java.lang.String> getColumnNames() {
                return this.columnNames;
            }

            @Override
            public final java.util.List<java.lang.String> getPrincipals() {
                return this.principals;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumnNames() != null) {
                    data.set("columnNames", om.valueToTree(this.getColumnNames()));
                }
                if (this.getPrincipals() != null) {
                    data.set("principals", om.valueToTree(this.getPrincipals()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.ColumnLevelPermissionRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnLevelPermissionRuleProperty.Jsii$Proxy that = (ColumnLevelPermissionRuleProperty.Jsii$Proxy) o;

                if (this.columnNames != null ? !this.columnNames.equals(that.columnNames) : that.columnNames != null) return false;
                return this.principals != null ? this.principals.equals(that.principals) : that.principals == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnNames != null ? this.columnNames.hashCode() : 0;
                result = 31 * result + (this.principals != null ? this.principals.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A tag for a column in a <code>[TagColumnOperation](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_TagColumnOperation.html)</code> structure. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ColumnTagProperty columnTagProperty = ColumnTagProperty.builder()
     *         .columnDescription(ColumnDescriptionProperty.builder()
     *                 .text("text")
     *                 .build())
     *         .columnGeographicRole("columnGeographicRole")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columntag.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columntag.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.ColumnTagProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnTagProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnTagProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A description for a column.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnDescriptionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columntag.html#cfn-quicksight-dataset-columntag-columndescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columntag.html#cfn-quicksight-dataset-columntag-columndescription</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColumnDescription() {
            return null;
        }

        /**
         * A geospatial role for a column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columntag.html#cfn-quicksight-dataset-columntag-columngeographicrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columntag.html#cfn-quicksight-dataset-columntag-columngeographicrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getColumnGeographicRole() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnTagProperty> {
            java.lang.Object columnDescription;
            java.lang.String columnGeographicRole;

            /**
             * Sets the value of {@link ColumnTagProperty#getColumnDescription}
             * @param columnDescription A description for a column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnDescription(software.amazon.awscdk.IResolvable columnDescription) {
                this.columnDescription = columnDescription;
                return this;
            }

            /**
             * Sets the value of {@link ColumnTagProperty#getColumnDescription}
             * @param columnDescription A description for a column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnDescription(software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnDescriptionProperty columnDescription) {
                this.columnDescription = columnDescription;
                return this;
            }

            /**
             * Sets the value of {@link ColumnTagProperty#getColumnGeographicRole}
             * @param columnGeographicRole A geospatial role for a column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnGeographicRole(java.lang.String columnGeographicRole) {
                this.columnGeographicRole = columnGeographicRole;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnTagProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnTagProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnTagProperty {
            private final java.lang.Object columnDescription;
            private final java.lang.String columnGeographicRole;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnDescription = software.amazon.jsii.Kernel.get(this, "columnDescription", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.columnGeographicRole = software.amazon.jsii.Kernel.get(this, "columnGeographicRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnDescription = builder.columnDescription;
                this.columnGeographicRole = builder.columnGeographicRole;
            }

            @Override
            public final java.lang.Object getColumnDescription() {
                return this.columnDescription;
            }

            @Override
            public final java.lang.String getColumnGeographicRole() {
                return this.columnGeographicRole;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumnDescription() != null) {
                    data.set("columnDescription", om.valueToTree(this.getColumnDescription()));
                }
                if (this.getColumnGeographicRole() != null) {
                    data.set("columnGeographicRole", om.valueToTree(this.getColumnGeographicRole()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.ColumnTagProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnTagProperty.Jsii$Proxy that = (ColumnTagProperty.Jsii$Proxy) o;

                if (this.columnDescription != null ? !this.columnDescription.equals(that.columnDescription) : that.columnDescription != null) return false;
                return this.columnGeographicRole != null ? this.columnGeographicRole.equals(that.columnGeographicRole) : that.columnGeographicRole == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnDescription != null ? this.columnDescription.hashCode() : 0;
                result = 31 * result + (this.columnGeographicRole != null ? this.columnGeographicRole.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a column to be unpivoted, transforming it from a column into rows with associated values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ColumnToUnpivotProperty columnToUnpivotProperty = ColumnToUnpivotProperty.builder()
     *         .columnName("columnName")
     *         .newValue("newValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columntounpivot.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columntounpivot.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.ColumnToUnpivotProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnToUnpivotProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnToUnpivotProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the column to unpivot from the source data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columntounpivot.html#cfn-quicksight-dataset-columntounpivot-columnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columntounpivot.html#cfn-quicksight-dataset-columntounpivot-columnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getColumnName() {
            return null;
        }

        /**
         * The value to assign to this column in the unpivoted result, typically the column name or a descriptive label.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columntounpivot.html#cfn-quicksight-dataset-columntounpivot-newvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columntounpivot.html#cfn-quicksight-dataset-columntounpivot-newvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNewValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnToUnpivotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnToUnpivotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnToUnpivotProperty> {
            java.lang.String columnName;
            java.lang.String newValue;

            /**
             * Sets the value of {@link ColumnToUnpivotProperty#getColumnName}
             * @param columnName The name of the column to unpivot from the source data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link ColumnToUnpivotProperty#getNewValue}
             * @param newValue The value to assign to this column in the unpivoted result, typically the column name or a descriptive label.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder newValue(java.lang.String newValue) {
                this.newValue = newValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnToUnpivotProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnToUnpivotProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnToUnpivotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnToUnpivotProperty {
            private final java.lang.String columnName;
            private final java.lang.String newValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.newValue = software.amazon.jsii.Kernel.get(this, "newValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnName = builder.columnName;
                this.newValue = builder.newValue;
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.lang.String getNewValue() {
                return this.newValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumnName() != null) {
                    data.set("columnName", om.valueToTree(this.getColumnName()));
                }
                if (this.getNewValue() != null) {
                    data.set("newValue", om.valueToTree(this.getNewValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.ColumnToUnpivotProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnToUnpivotProperty.Jsii$Proxy that = (ColumnToUnpivotProperty.Jsii$Proxy) o;

                if (this.columnName != null ? !this.columnName.equals(that.columnName) : that.columnName != null) return false;
                return this.newValue != null ? this.newValue.equals(that.newValue) : that.newValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnName != null ? this.columnName.hashCode() : 0;
                result = 31 * result + (this.newValue != null ? this.newValue.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A transform operation that creates calculated columns.
     * <p>
     * Columns created in one such operation form a lexical closure.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CreateColumnsOperationProperty createColumnsOperationProperty = CreateColumnsOperationProperty.builder()
     *         .columns(List.of(CalculatedColumnProperty.builder()
     *                 .columnId("columnId")
     *                 .columnName("columnName")
     *                 .expression("expression")
     *                 .build()))
     *         // the properties below are optional
     *         .alias("alias")
     *         .source(TransformOperationSourceProperty.builder()
     *                 .transformOperationId("transformOperationId")
     *                 // the properties below are optional
     *                 .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                         .sourceColumnId("sourceColumnId")
     *                         .targetColumnId("targetColumnId")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-createcolumnsoperation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-createcolumnsoperation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.CreateColumnsOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(CreateColumnsOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CreateColumnsOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Calculated columns to create.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.CalculatedColumnProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-createcolumnsoperation.html#cfn-quicksight-dataset-createcolumnsoperation-columns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-createcolumnsoperation.html#cfn-quicksight-dataset-createcolumnsoperation-columns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getColumns();

        /**
         * Alias for this operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-createcolumnsoperation.html#cfn-quicksight-dataset-createcolumnsoperation-alias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-createcolumnsoperation.html#cfn-quicksight-dataset-createcolumnsoperation-alias</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlias() {
            return null;
        }

        /**
         * The source transform operation that provides input data for creating new calculated columns.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.TransformOperationSourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-createcolumnsoperation.html#cfn-quicksight-dataset-createcolumnsoperation-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-createcolumnsoperation.html#cfn-quicksight-dataset-createcolumnsoperation-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CreateColumnsOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CreateColumnsOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CreateColumnsOperationProperty> {
            java.lang.Object columns;
            java.lang.String alias;
            java.lang.Object source;

            /**
             * Sets the value of {@link CreateColumnsOperationProperty#getColumns}
             * @param columns Calculated columns to create. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(software.amazon.awscdk.IResolvable columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link CreateColumnsOperationProperty#getColumns}
             * @param columns Calculated columns to create. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(java.util.List<? extends java.lang.Object> columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link CreateColumnsOperationProperty#getAlias}
             * @param alias Alias for this operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alias(java.lang.String alias) {
                this.alias = alias;
                return this;
            }

            /**
             * Sets the value of {@link CreateColumnsOperationProperty#getSource}
             * @param source The source transform operation that provides input data for creating new calculated columns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.IResolvable source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link CreateColumnsOperationProperty#getSource}
             * @param source The source transform operation that provides input data for creating new calculated columns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.services.quicksight.CfnDataSet.TransformOperationSourceProperty source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreateColumnsOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CreateColumnsOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CreateColumnsOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CreateColumnsOperationProperty {
            private final java.lang.Object columns;
            private final java.lang.String alias;
            private final java.lang.Object source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columns = software.amazon.jsii.Kernel.get(this, "columns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columns = java.util.Objects.requireNonNull(builder.columns, "columns is required");
                this.alias = builder.alias;
                this.source = builder.source;
            }

            @Override
            public final java.lang.Object getColumns() {
                return this.columns;
            }

            @Override
            public final java.lang.String getAlias() {
                return this.alias;
            }

            @Override
            public final java.lang.Object getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columns", om.valueToTree(this.getColumns()));
                if (this.getAlias() != null) {
                    data.set("alias", om.valueToTree(this.getAlias()));
                }
                if (this.getSource() != null) {
                    data.set("source", om.valueToTree(this.getSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.CreateColumnsOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CreateColumnsOperationProperty.Jsii$Proxy that = (CreateColumnsOperationProperty.Jsii$Proxy) o;

                if (!columns.equals(that.columns)) return false;
                if (this.alias != null ? !this.alias.equals(that.alias) : that.alias != null) return false;
                return this.source != null ? this.source.equals(that.source) : that.source == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columns.hashCode();
                result = 31 * result + (this.alias != null ? this.alias.hashCode() : 0);
                result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A physical table type built from the results of the custom SQL query.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CustomSqlProperty customSqlProperty = CustomSqlProperty.builder()
     *         .columns(List.of(InputColumnProperty.builder()
     *                 .name("name")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .id("id")
     *                 .subType("subType")
     *                 .build()))
     *         .dataSourceArn("dataSourceArn")
     *         .name("name")
     *         .sqlQuery("sqlQuery")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.CustomSqlProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomSqlProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomSqlProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The column schema from the SQL query result set.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.InputColumnProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html#cfn-quicksight-dataset-customsql-columns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html#cfn-quicksight-dataset-customsql-columns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getColumns();

        /**
         * The Amazon Resource Name (ARN) of the data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html#cfn-quicksight-dataset-customsql-datasourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html#cfn-quicksight-dataset-customsql-datasourcearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSourceArn();

        /**
         * A display name for the SQL query result.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html#cfn-quicksight-dataset-customsql-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html#cfn-quicksight-dataset-customsql-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The SQL query.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html#cfn-quicksight-dataset-customsql-sqlquery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html#cfn-quicksight-dataset-customsql-sqlquery</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSqlQuery();

        /**
         * @return a {@link Builder} of {@link CustomSqlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomSqlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomSqlProperty> {
            java.lang.Object columns;
            java.lang.String dataSourceArn;
            java.lang.String name;
            java.lang.String sqlQuery;

            /**
             * Sets the value of {@link CustomSqlProperty#getColumns}
             * @param columns The column schema from the SQL query result set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(software.amazon.awscdk.IResolvable columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link CustomSqlProperty#getColumns}
             * @param columns The column schema from the SQL query result set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(java.util.List<? extends java.lang.Object> columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link CustomSqlProperty#getDataSourceArn}
             * @param dataSourceArn The Amazon Resource Name (ARN) of the data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSourceArn(java.lang.String dataSourceArn) {
                this.dataSourceArn = dataSourceArn;
                return this;
            }

            /**
             * Sets the value of {@link CustomSqlProperty#getName}
             * @param name A display name for the SQL query result. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link CustomSqlProperty#getSqlQuery}
             * @param sqlQuery The SQL query. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqlQuery(java.lang.String sqlQuery) {
                this.sqlQuery = sqlQuery;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomSqlProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomSqlProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomSqlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomSqlProperty {
            private final java.lang.Object columns;
            private final java.lang.String dataSourceArn;
            private final java.lang.String name;
            private final java.lang.String sqlQuery;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columns = software.amazon.jsii.Kernel.get(this, "columns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataSourceArn = software.amazon.jsii.Kernel.get(this, "dataSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sqlQuery = software.amazon.jsii.Kernel.get(this, "sqlQuery", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columns = java.util.Objects.requireNonNull(builder.columns, "columns is required");
                this.dataSourceArn = java.util.Objects.requireNonNull(builder.dataSourceArn, "dataSourceArn is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.sqlQuery = java.util.Objects.requireNonNull(builder.sqlQuery, "sqlQuery is required");
            }

            @Override
            public final java.lang.Object getColumns() {
                return this.columns;
            }

            @Override
            public final java.lang.String getDataSourceArn() {
                return this.dataSourceArn;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getSqlQuery() {
                return this.sqlQuery;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columns", om.valueToTree(this.getColumns()));
                data.set("dataSourceArn", om.valueToTree(this.getDataSourceArn()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("sqlQuery", om.valueToTree(this.getSqlQuery()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.CustomSqlProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomSqlProperty.Jsii$Proxy that = (CustomSqlProperty.Jsii$Proxy) o;

                if (!columns.equals(that.columns)) return false;
                if (!dataSourceArn.equals(that.dataSourceArn)) return false;
                if (!name.equals(that.name)) return false;
                return this.sqlQuery.equals(that.sqlQuery);
            }

            @Override
            public final int hashCode() {
                int result = this.columns.hashCode();
                result = 31 * result + (this.dataSourceArn.hashCode());
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.sqlQuery.hashCode());
                return result;
            }
        }
    }
    /**
     * Defines the type of aggregation function to apply to data during data preparation, supporting simple and list aggregations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataPrepAggregationFunctionProperty dataPrepAggregationFunctionProperty = DataPrepAggregationFunctionProperty.builder()
     *         .listAggregation(DataPrepListAggregationFunctionProperty.builder()
     *                 .distinct(false)
     *                 .separator("separator")
     *                 // the properties below are optional
     *                 .inputColumnName("inputColumnName")
     *                 .build())
     *         .percentileAggregation(DataPrepPercentileAggregationFunctionProperty.builder()
     *                 .percentileValue(123)
     *                 // the properties below are optional
     *                 .inputColumnName("inputColumnName")
     *                 .build())
     *         .simpleAggregation(DataPrepSimpleAggregationFunctionProperty.builder()
     *                 .functionType("functionType")
     *                 // the properties below are optional
     *                 .inputColumnName("inputColumnName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-dataprepaggregationfunction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-dataprepaggregationfunction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DataPrepAggregationFunctionProperty")
    @software.amazon.jsii.Jsii.Proxy(DataPrepAggregationFunctionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataPrepAggregationFunctionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list aggregation function that concatenates values from multiple rows into a single delimited string.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataPrepListAggregationFunctionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-dataprepaggregationfunction.html#cfn-quicksight-dataset-dataprepaggregationfunction-listaggregation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-dataprepaggregationfunction.html#cfn-quicksight-dataset-dataprepaggregationfunction-listaggregation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getListAggregation() {
            return null;
        }

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataPrepPercentileAggregationFunctionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-dataprepaggregationfunction.html#cfn-quicksight-dataset-dataprepaggregationfunction-percentileaggregation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-dataprepaggregationfunction.html#cfn-quicksight-dataset-dataprepaggregationfunction-percentileaggregation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPercentileAggregation() {
            return null;
        }

        /**
         * A simple aggregation function such as <code>SUM</code> , <code>COUNT</code> , <code>AVERAGE</code> , <code>MIN</code> , <code>MAX</code> , <code>MEDIAN</code> , <code>VARIANCE</code> , or <code>STANDARD_DEVIATION</code> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataPrepSimpleAggregationFunctionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-dataprepaggregationfunction.html#cfn-quicksight-dataset-dataprepaggregationfunction-simpleaggregation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-dataprepaggregationfunction.html#cfn-quicksight-dataset-dataprepaggregationfunction-simpleaggregation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSimpleAggregation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataPrepAggregationFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataPrepAggregationFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataPrepAggregationFunctionProperty> {
            java.lang.Object listAggregation;
            java.lang.Object percentileAggregation;
            java.lang.Object simpleAggregation;

            /**
             * Sets the value of {@link DataPrepAggregationFunctionProperty#getListAggregation}
             * @param listAggregation A list aggregation function that concatenates values from multiple rows into a single delimited string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder listAggregation(software.amazon.awscdk.IResolvable listAggregation) {
                this.listAggregation = listAggregation;
                return this;
            }

            /**
             * Sets the value of {@link DataPrepAggregationFunctionProperty#getListAggregation}
             * @param listAggregation A list aggregation function that concatenates values from multiple rows into a single delimited string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder listAggregation(software.amazon.awscdk.services.quicksight.CfnDataSet.DataPrepListAggregationFunctionProperty listAggregation) {
                this.listAggregation = listAggregation;
                return this;
            }

            /**
             * Sets the value of {@link DataPrepAggregationFunctionProperty#getPercentileAggregation}
             * @param percentileAggregation the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder percentileAggregation(software.amazon.awscdk.IResolvable percentileAggregation) {
                this.percentileAggregation = percentileAggregation;
                return this;
            }

            /**
             * Sets the value of {@link DataPrepAggregationFunctionProperty#getPercentileAggregation}
             * @param percentileAggregation the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder percentileAggregation(software.amazon.awscdk.services.quicksight.CfnDataSet.DataPrepPercentileAggregationFunctionProperty percentileAggregation) {
                this.percentileAggregation = percentileAggregation;
                return this;
            }

            /**
             * Sets the value of {@link DataPrepAggregationFunctionProperty#getSimpleAggregation}
             * @param simpleAggregation A simple aggregation function such as <code>SUM</code> , <code>COUNT</code> , <code>AVERAGE</code> , <code>MIN</code> , <code>MAX</code> , <code>MEDIAN</code> , <code>VARIANCE</code> , or <code>STANDARD_DEVIATION</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder simpleAggregation(software.amazon.awscdk.IResolvable simpleAggregation) {
                this.simpleAggregation = simpleAggregation;
                return this;
            }

            /**
             * Sets the value of {@link DataPrepAggregationFunctionProperty#getSimpleAggregation}
             * @param simpleAggregation A simple aggregation function such as <code>SUM</code> , <code>COUNT</code> , <code>AVERAGE</code> , <code>MIN</code> , <code>MAX</code> , <code>MEDIAN</code> , <code>VARIANCE</code> , or <code>STANDARD_DEVIATION</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder simpleAggregation(software.amazon.awscdk.services.quicksight.CfnDataSet.DataPrepSimpleAggregationFunctionProperty simpleAggregation) {
                this.simpleAggregation = simpleAggregation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataPrepAggregationFunctionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataPrepAggregationFunctionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataPrepAggregationFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataPrepAggregationFunctionProperty {
            private final java.lang.Object listAggregation;
            private final java.lang.Object percentileAggregation;
            private final java.lang.Object simpleAggregation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.listAggregation = software.amazon.jsii.Kernel.get(this, "listAggregation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.percentileAggregation = software.amazon.jsii.Kernel.get(this, "percentileAggregation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.simpleAggregation = software.amazon.jsii.Kernel.get(this, "simpleAggregation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.listAggregation = builder.listAggregation;
                this.percentileAggregation = builder.percentileAggregation;
                this.simpleAggregation = builder.simpleAggregation;
            }

            @Override
            public final java.lang.Object getListAggregation() {
                return this.listAggregation;
            }

            @Override
            public final java.lang.Object getPercentileAggregation() {
                return this.percentileAggregation;
            }

            @Override
            public final java.lang.Object getSimpleAggregation() {
                return this.simpleAggregation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getListAggregation() != null) {
                    data.set("listAggregation", om.valueToTree(this.getListAggregation()));
                }
                if (this.getPercentileAggregation() != null) {
                    data.set("percentileAggregation", om.valueToTree(this.getPercentileAggregation()));
                }
                if (this.getSimpleAggregation() != null) {
                    data.set("simpleAggregation", om.valueToTree(this.getSimpleAggregation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DataPrepAggregationFunctionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataPrepAggregationFunctionProperty.Jsii$Proxy that = (DataPrepAggregationFunctionProperty.Jsii$Proxy) o;

                if (this.listAggregation != null ? !this.listAggregation.equals(that.listAggregation) : that.listAggregation != null) return false;
                if (this.percentileAggregation != null ? !this.percentileAggregation.equals(that.percentileAggregation) : that.percentileAggregation != null) return false;
                return this.simpleAggregation != null ? this.simpleAggregation.equals(that.simpleAggregation) : that.simpleAggregation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.listAggregation != null ? this.listAggregation.hashCode() : 0;
                result = 31 * result + (this.percentileAggregation != null ? this.percentileAggregation.hashCode() : 0);
                result = 31 * result + (this.simpleAggregation != null ? this.simpleAggregation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for data preparation operations, defining the complete pipeline from source tables through transformations to destination tables.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataPrepConfigurationProperty dataPrepConfigurationProperty = DataPrepConfigurationProperty.builder()
     *         .destinationTableMap(Map.of(
     *                 "destinationTableMapKey", DestinationTableProperty.builder()
     *                         .alias("alias")
     *                         .source(DestinationTableSourceProperty.builder()
     *                                 .transformOperationId("transformOperationId")
     *                                 .build())
     *                         .build()))
     *         .sourceTableMap(Map.of(
     *                 "sourceTableMapKey", SourceTableProperty.builder()
     *                         .dataSet(ParentDataSetProperty.builder()
     *                                 .dataSetArn("dataSetArn")
     *                                 .inputColumns(List.of(InputColumnProperty.builder()
     *                                         .name("name")
     *                                         .type("type")
     *                                         // the properties below are optional
     *                                         .id("id")
     *                                         .subType("subType")
     *                                         .build()))
     *                                 .build())
     *                         .physicalTableId("physicalTableId")
     *                         .build()))
     *         .transformStepMap(Map.of(
     *                 "transformStepMapKey", TransformStepProperty.builder()
     *                         .aggregateStep(AggregateOperationProperty.builder()
     *                                 .aggregations(List.of(AggregationProperty.builder()
     *                                         .aggregationFunction(DataPrepAggregationFunctionProperty.builder()
     *                                                 .listAggregation(DataPrepListAggregationFunctionProperty.builder()
     *                                                         .distinct(false)
     *                                                         .separator("separator")
     *                                                         // the properties below are optional
     *                                                         .inputColumnName("inputColumnName")
     *                                                         .build())
     *                                                 .percentileAggregation(DataPrepPercentileAggregationFunctionProperty.builder()
     *                                                         .percentileValue(123)
     *                                                         // the properties below are optional
     *                                                         .inputColumnName("inputColumnName")
     *                                                         .build())
     *                                                 .simpleAggregation(DataPrepSimpleAggregationFunctionProperty.builder()
     *                                                         .functionType("functionType")
     *                                                         // the properties below are optional
     *                                                         .inputColumnName("inputColumnName")
     *                                                         .build())
     *                                                 .build())
     *                                         .newColumnId("newColumnId")
     *                                         .newColumnName("newColumnName")
     *                                         .build()))
     *                                 .alias("alias")
     *                                 .source(TransformOperationSourceProperty.builder()
     *                                         .transformOperationId("transformOperationId")
     *                                         // the properties below are optional
     *                                         .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                                                 .sourceColumnId("sourceColumnId")
     *                                                 .targetColumnId("targetColumnId")
     *                                                 .build()))
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .groupByColumnNames(List.of("groupByColumnNames"))
     *                                 .build())
     *                         .appendStep(AppendOperationProperty.builder()
     *                                 .alias("alias")
     *                                 .appendedColumns(List.of(AppendedColumnProperty.builder()
     *                                         .columnName("columnName")
     *                                         .newColumnId("newColumnId")
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .firstSource(TransformOperationSourceProperty.builder()
     *                                         .transformOperationId("transformOperationId")
     *                                         // the properties below are optional
     *                                         .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                                                 .sourceColumnId("sourceColumnId")
     *                                                 .targetColumnId("targetColumnId")
     *                                                 .build()))
     *                                         .build())
     *                                 .secondSource(TransformOperationSourceProperty.builder()
     *                                         .transformOperationId("transformOperationId")
     *                                         // the properties below are optional
     *                                         .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                                                 .sourceColumnId("sourceColumnId")
     *                                                 .targetColumnId("targetColumnId")
     *                                                 .build()))
     *                                         .build())
     *                                 .build())
     *                         .castColumnTypesStep(CastColumnTypesOperationProperty.builder()
     *                                 .alias("alias")
     *                                 .castColumnTypeOperations(List.of(CastColumnTypeOperationProperty.builder()
     *                                         .columnName("columnName")
     *                                         .newColumnType("newColumnType")
     *                                         // the properties below are optional
     *                                         .format("format")
     *                                         .subType("subType")
     *                                         .build()))
     *                                 .source(TransformOperationSourceProperty.builder()
     *                                         .transformOperationId("transformOperationId")
     *                                         // the properties below are optional
     *                                         .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                                                 .sourceColumnId("sourceColumnId")
     *                                                 .targetColumnId("targetColumnId")
     *                                                 .build()))
     *                                         .build())
     *                                 .build())
     *                         .createColumnsStep(CreateColumnsOperationProperty.builder()
     *                                 .columns(List.of(CalculatedColumnProperty.builder()
     *                                         .columnId("columnId")
     *                                         .columnName("columnName")
     *                                         .expression("expression")
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .alias("alias")
     *                                 .source(TransformOperationSourceProperty.builder()
     *                                         .transformOperationId("transformOperationId")
     *                                         // the properties below are optional
     *                                         .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                                                 .sourceColumnId("sourceColumnId")
     *                                                 .targetColumnId("targetColumnId")
     *                                                 .build()))
     *                                         .build())
     *                                 .build())
     *                         .filtersStep(FiltersOperationProperty.builder()
     *                                 .alias("alias")
     *                                 .filterOperations(List.of(FilterOperationProperty.builder()
     *                                         .conditionExpression("conditionExpression")
     *                                         .dateFilterCondition(DataSetDateFilterConditionProperty.builder()
     *                                                 .columnName("columnName")
     *                                                 .comparisonFilterCondition(DataSetDateComparisonFilterConditionProperty.builder()
     *                                                         .operator("operator")
     *                                                         // the properties below are optional
     *                                                         .value(DataSetDateFilterValueProperty.builder()
     *                                                                 .staticValue("staticValue")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .rangeFilterCondition(DataSetDateRangeFilterConditionProperty.builder()
     *                                                         .includeMaximum(false)
     *                                                         .includeMinimum(false)
     *                                                         .rangeMaximum(DataSetDateFilterValueProperty.builder()
     *                                                                 .staticValue("staticValue")
     *                                                                 .build())
     *                                                         .rangeMinimum(DataSetDateFilterValueProperty.builder()
     *                                                                 .staticValue("staticValue")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .build())
     *                                         .numericFilterCondition(DataSetNumericFilterConditionProperty.builder()
     *                                                 .columnName("columnName")
     *                                                 .comparisonFilterCondition(DataSetNumericComparisonFilterConditionProperty.builder()
     *                                                         .operator("operator")
     *                                                         // the properties below are optional
     *                                                         .value(DataSetNumericFilterValueProperty.builder()
     *                                                                 .staticValue(123)
     *                                                                 .build())
     *                                                         .build())
     *                                                 .rangeFilterCondition(DataSetNumericRangeFilterConditionProperty.builder()
     *                                                         .includeMaximum(false)
     *                                                         .includeMinimum(false)
     *                                                         .rangeMaximum(DataSetNumericFilterValueProperty.builder()
     *                                                                 .staticValue(123)
     *                                                                 .build())
     *                                                         .rangeMinimum(DataSetNumericFilterValueProperty.builder()
     *                                                                 .staticValue(123)
     *                                                                 .build())
     *                                                         .build())
     *                                                 .build())
     *                                         .stringFilterCondition(DataSetStringFilterConditionProperty.builder()
     *                                                 .columnName("columnName")
     *                                                 .comparisonFilterCondition(DataSetStringComparisonFilterConditionProperty.builder()
     *                                                         .operator("operator")
     *                                                         // the properties below are optional
     *                                                         .value(DataSetStringFilterValueProperty.builder()
     *                                                                 .staticValue("staticValue")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .listFilterCondition(DataSetStringListFilterConditionProperty.builder()
     *                                                         .operator("operator")
     *                                                         // the properties below are optional
     *                                                         .values(DataSetStringListFilterValueProperty.builder()
     *                                                                 .staticValues(List.of("staticValues"))
     *                                                                 .build())
     *                                                         .build())
     *                                                 .build())
     *                                         .build()))
     *                                 .source(TransformOperationSourceProperty.builder()
     *                                         .transformOperationId("transformOperationId")
     *                                         // the properties below are optional
     *                                         .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                                                 .sourceColumnId("sourceColumnId")
     *                                                 .targetColumnId("targetColumnId")
     *                                                 .build()))
     *                                         .build())
     *                                 .build())
     *                         .importTableStep(ImportTableOperationProperty.builder()
     *                                 .alias("alias")
     *                                 .source(ImportTableOperationSourceProperty.builder()
     *                                         .sourceTableId("sourceTableId")
     *                                         // the properties below are optional
     *                                         .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                                                 .sourceColumnId("sourceColumnId")
     *                                                 .targetColumnId("targetColumnId")
     *                                                 .build()))
     *                                         .build())
     *                                 .build())
     *                         .joinStep(JoinOperationProperty.builder()
     *                                 .alias("alias")
     *                                 .leftOperand(TransformOperationSourceProperty.builder()
     *                                         .transformOperationId("transformOperationId")
     *                                         // the properties below are optional
     *                                         .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                                                 .sourceColumnId("sourceColumnId")
     *                                                 .targetColumnId("targetColumnId")
     *                                                 .build()))
     *                                         .build())
     *                                 .onClause("onClause")
     *                                 .rightOperand(TransformOperationSourceProperty.builder()
     *                                         .transformOperationId("transformOperationId")
     *                                         // the properties below are optional
     *                                         .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                                                 .sourceColumnId("sourceColumnId")
     *                                                 .targetColumnId("targetColumnId")
     *                                                 .build()))
     *                                         .build())
     *                                 .type("type")
     *                                 // the properties below are optional
     *                                 .leftOperandProperties(JoinOperandPropertiesProperty.builder()
     *                                         .outputColumnNameOverrides(List.of(OutputColumnNameOverrideProperty.builder()
     *                                                 .outputColumnName("outputColumnName")
     *                                                 // the properties below are optional
     *                                                 .sourceColumnName("sourceColumnName")
     *                                                 .build()))
     *                                         .build())
     *                                 .rightOperandProperties(JoinOperandPropertiesProperty.builder()
     *                                         .outputColumnNameOverrides(List.of(OutputColumnNameOverrideProperty.builder()
     *                                                 .outputColumnName("outputColumnName")
     *                                                 // the properties below are optional
     *                                                 .sourceColumnName("sourceColumnName")
     *                                                 .build()))
     *                                         .build())
     *                                 .build())
     *                         .pivotStep(PivotOperationProperty.builder()
     *                                 .alias("alias")
     *                                 .pivotConfiguration(PivotConfigurationProperty.builder()
     *                                         .pivotedLabels(List.of(PivotedLabelProperty.builder()
     *                                                 .labelName("labelName")
     *                                                 .newColumnId("newColumnId")
     *                                                 .newColumnName("newColumnName")
     *                                                 .build()))
     *                                         // the properties below are optional
     *                                         .labelColumnName("labelColumnName")
     *                                         .build())
     *                                 .source(TransformOperationSourceProperty.builder()
     *                                         .transformOperationId("transformOperationId")
     *                                         // the properties below are optional
     *                                         .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                                                 .sourceColumnId("sourceColumnId")
     *                                                 .targetColumnId("targetColumnId")
     *                                                 .build()))
     *                                         .build())
     *                                 .valueColumnConfiguration(ValueColumnConfigurationProperty.builder()
     *                                         .aggregationFunction(DataPrepAggregationFunctionProperty.builder()
     *                                                 .listAggregation(DataPrepListAggregationFunctionProperty.builder()
     *                                                         .distinct(false)
     *                                                         .separator("separator")
     *                                                         // the properties below are optional
     *                                                         .inputColumnName("inputColumnName")
     *                                                         .build())
     *                                                 .percentileAggregation(DataPrepPercentileAggregationFunctionProperty.builder()
     *                                                         .percentileValue(123)
     *                                                         // the properties below are optional
     *                                                         .inputColumnName("inputColumnName")
     *                                                         .build())
     *                                                 .simpleAggregation(DataPrepSimpleAggregationFunctionProperty.builder()
     *                                                         .functionType("functionType")
     *                                                         // the properties below are optional
     *                                                         .inputColumnName("inputColumnName")
     *                                                         .build())
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .groupByColumnNames(List.of("groupByColumnNames"))
     *                                 .build())
     *                         .projectStep(ProjectOperationProperty.builder()
     *                                 .alias("alias")
     *                                 .projectedColumns(List.of("projectedColumns"))
     *                                 .source(TransformOperationSourceProperty.builder()
     *                                         .transformOperationId("transformOperationId")
     *                                         // the properties below are optional
     *                                         .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                                                 .sourceColumnId("sourceColumnId")
     *                                                 .targetColumnId("targetColumnId")
     *                                                 .build()))
     *                                         .build())
     *                                 .build())
     *                         .renameColumnsStep(RenameColumnsOperationProperty.builder()
     *                                 .alias("alias")
     *                                 .renameColumnOperations(List.of(RenameColumnOperationProperty.builder()
     *                                         .columnName("columnName")
     *                                         .newColumnName("newColumnName")
     *                                         .build()))
     *                                 .source(TransformOperationSourceProperty.builder()
     *                                         .transformOperationId("transformOperationId")
     *                                         // the properties below are optional
     *                                         .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                                                 .sourceColumnId("sourceColumnId")
     *                                                 .targetColumnId("targetColumnId")
     *                                                 .build()))
     *                                         .build())
     *                                 .build())
     *                         .unpivotStep(UnpivotOperationProperty.builder()
     *                                 .alias("alias")
     *                                 .columnsToUnpivot(List.of(ColumnToUnpivotProperty.builder()
     *                                         .columnName("columnName")
     *                                         .newValue("newValue")
     *                                         .build()))
     *                                 .source(TransformOperationSourceProperty.builder()
     *                                         .transformOperationId("transformOperationId")
     *                                         // the properties below are optional
     *                                         .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                                                 .sourceColumnId("sourceColumnId")
     *                                                 .targetColumnId("targetColumnId")
     *                                                 .build()))
     *                                         .build())
     *                                 .unpivotedLabelColumnId("unpivotedLabelColumnId")
     *                                 .unpivotedLabelColumnName("unpivotedLabelColumnName")
     *                                 .unpivotedValueColumnId("unpivotedValueColumnId")
     *                                 .unpivotedValueColumnName("unpivotedValueColumnName")
     *                                 .build())
     *                         .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-dataprepconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-dataprepconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DataPrepConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DataPrepConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataPrepConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A map of destination tables that receive the final prepared data.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or Map<String, either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DestinationTableProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-dataprepconfiguration.html#cfn-quicksight-dataset-dataprepconfiguration-destinationtablemap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-dataprepconfiguration.html#cfn-quicksight-dataset-dataprepconfiguration-destinationtablemap</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestinationTableMap();

        /**
         * A map of source tables that provide information about underlying sources.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or Map<String, either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.SourceTableProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-dataprepconfiguration.html#cfn-quicksight-dataset-dataprepconfiguration-sourcetablemap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-dataprepconfiguration.html#cfn-quicksight-dataset-dataprepconfiguration-sourcetablemap</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSourceTableMap();

        /**
         * A map of transformation steps that process the data.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or Map<String, either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.TransformStepProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-dataprepconfiguration.html#cfn-quicksight-dataset-dataprepconfiguration-transformstepmap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-dataprepconfiguration.html#cfn-quicksight-dataset-dataprepconfiguration-transformstepmap</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTransformStepMap();

        /**
         * @return a {@link Builder} of {@link DataPrepConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataPrepConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataPrepConfigurationProperty> {
            java.lang.Object destinationTableMap;
            java.lang.Object sourceTableMap;
            java.lang.Object transformStepMap;

            /**
             * Sets the value of {@link DataPrepConfigurationProperty#getDestinationTableMap}
             * @param destinationTableMap A map of destination tables that receive the final prepared data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationTableMap(software.amazon.awscdk.IResolvable destinationTableMap) {
                this.destinationTableMap = destinationTableMap;
                return this;
            }

            /**
             * Sets the value of {@link DataPrepConfigurationProperty#getDestinationTableMap}
             * @param destinationTableMap A map of destination tables that receive the final prepared data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationTableMap(java.util.Map<java.lang.String, ? extends java.lang.Object> destinationTableMap) {
                this.destinationTableMap = destinationTableMap;
                return this;
            }

            /**
             * Sets the value of {@link DataPrepConfigurationProperty#getSourceTableMap}
             * @param sourceTableMap A map of source tables that provide information about underlying sources. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceTableMap(software.amazon.awscdk.IResolvable sourceTableMap) {
                this.sourceTableMap = sourceTableMap;
                return this;
            }

            /**
             * Sets the value of {@link DataPrepConfigurationProperty#getSourceTableMap}
             * @param sourceTableMap A map of source tables that provide information about underlying sources. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceTableMap(java.util.Map<java.lang.String, ? extends java.lang.Object> sourceTableMap) {
                this.sourceTableMap = sourceTableMap;
                return this;
            }

            /**
             * Sets the value of {@link DataPrepConfigurationProperty#getTransformStepMap}
             * @param transformStepMap A map of transformation steps that process the data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transformStepMap(software.amazon.awscdk.IResolvable transformStepMap) {
                this.transformStepMap = transformStepMap;
                return this;
            }

            /**
             * Sets the value of {@link DataPrepConfigurationProperty#getTransformStepMap}
             * @param transformStepMap A map of transformation steps that process the data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transformStepMap(java.util.Map<java.lang.String, ? extends java.lang.Object> transformStepMap) {
                this.transformStepMap = transformStepMap;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataPrepConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataPrepConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataPrepConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataPrepConfigurationProperty {
            private final java.lang.Object destinationTableMap;
            private final java.lang.Object sourceTableMap;
            private final java.lang.Object transformStepMap;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationTableMap = software.amazon.jsii.Kernel.get(this, "destinationTableMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceTableMap = software.amazon.jsii.Kernel.get(this, "sourceTableMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.transformStepMap = software.amazon.jsii.Kernel.get(this, "transformStepMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationTableMap = java.util.Objects.requireNonNull(builder.destinationTableMap, "destinationTableMap is required");
                this.sourceTableMap = java.util.Objects.requireNonNull(builder.sourceTableMap, "sourceTableMap is required");
                this.transformStepMap = java.util.Objects.requireNonNull(builder.transformStepMap, "transformStepMap is required");
            }

            @Override
            public final java.lang.Object getDestinationTableMap() {
                return this.destinationTableMap;
            }

            @Override
            public final java.lang.Object getSourceTableMap() {
                return this.sourceTableMap;
            }

            @Override
            public final java.lang.Object getTransformStepMap() {
                return this.transformStepMap;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destinationTableMap", om.valueToTree(this.getDestinationTableMap()));
                data.set("sourceTableMap", om.valueToTree(this.getSourceTableMap()));
                data.set("transformStepMap", om.valueToTree(this.getTransformStepMap()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DataPrepConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataPrepConfigurationProperty.Jsii$Proxy that = (DataPrepConfigurationProperty.Jsii$Proxy) o;

                if (!destinationTableMap.equals(that.destinationTableMap)) return false;
                if (!sourceTableMap.equals(that.sourceTableMap)) return false;
                return this.transformStepMap.equals(that.transformStepMap);
            }

            @Override
            public final int hashCode() {
                int result = this.destinationTableMap.hashCode();
                result = 31 * result + (this.sourceTableMap.hashCode());
                result = 31 * result + (this.transformStepMap.hashCode());
                return result;
            }
        }
    }
    /**
     * An aggregation function that concatenates values from multiple rows into a single string with a specified separator.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataPrepListAggregationFunctionProperty dataPrepListAggregationFunctionProperty = DataPrepListAggregationFunctionProperty.builder()
     *         .distinct(false)
     *         .separator("separator")
     *         // the properties below are optional
     *         .inputColumnName("inputColumnName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datapreplistaggregationfunction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datapreplistaggregationfunction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DataPrepListAggregationFunctionProperty")
    @software.amazon.jsii.Jsii.Proxy(DataPrepListAggregationFunctionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataPrepListAggregationFunctionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether to include only distinct values in the concatenated result, removing duplicates.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datapreplistaggregationfunction.html#cfn-quicksight-dataset-datapreplistaggregationfunction-distinct">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datapreplistaggregationfunction.html#cfn-quicksight-dataset-datapreplistaggregationfunction-distinct</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDistinct();

        /**
         * The string used to separate values in the concatenated result.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datapreplistaggregationfunction.html#cfn-quicksight-dataset-datapreplistaggregationfunction-separator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datapreplistaggregationfunction.html#cfn-quicksight-dataset-datapreplistaggregationfunction-separator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSeparator();

        /**
         * The name of the column containing values to be concatenated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datapreplistaggregationfunction.html#cfn-quicksight-dataset-datapreplistaggregationfunction-inputcolumnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datapreplistaggregationfunction.html#cfn-quicksight-dataset-datapreplistaggregationfunction-inputcolumnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputColumnName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataPrepListAggregationFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataPrepListAggregationFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataPrepListAggregationFunctionProperty> {
            java.lang.Object distinct;
            java.lang.String separator;
            java.lang.String inputColumnName;

            /**
             * Sets the value of {@link DataPrepListAggregationFunctionProperty#getDistinct}
             * @param distinct Whether to include only distinct values in the concatenated result, removing duplicates. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder distinct(java.lang.Boolean distinct) {
                this.distinct = distinct;
                return this;
            }

            /**
             * Sets the value of {@link DataPrepListAggregationFunctionProperty#getDistinct}
             * @param distinct Whether to include only distinct values in the concatenated result, removing duplicates. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder distinct(software.amazon.awscdk.IResolvable distinct) {
                this.distinct = distinct;
                return this;
            }

            /**
             * Sets the value of {@link DataPrepListAggregationFunctionProperty#getSeparator}
             * @param separator The string used to separate values in the concatenated result. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder separator(java.lang.String separator) {
                this.separator = separator;
                return this;
            }

            /**
             * Sets the value of {@link DataPrepListAggregationFunctionProperty#getInputColumnName}
             * @param inputColumnName The name of the column containing values to be concatenated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputColumnName(java.lang.String inputColumnName) {
                this.inputColumnName = inputColumnName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataPrepListAggregationFunctionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataPrepListAggregationFunctionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataPrepListAggregationFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataPrepListAggregationFunctionProperty {
            private final java.lang.Object distinct;
            private final java.lang.String separator;
            private final java.lang.String inputColumnName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.distinct = software.amazon.jsii.Kernel.get(this, "distinct", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.separator = software.amazon.jsii.Kernel.get(this, "separator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputColumnName = software.amazon.jsii.Kernel.get(this, "inputColumnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.distinct = java.util.Objects.requireNonNull(builder.distinct, "distinct is required");
                this.separator = java.util.Objects.requireNonNull(builder.separator, "separator is required");
                this.inputColumnName = builder.inputColumnName;
            }

            @Override
            public final java.lang.Object getDistinct() {
                return this.distinct;
            }

            @Override
            public final java.lang.String getSeparator() {
                return this.separator;
            }

            @Override
            public final java.lang.String getInputColumnName() {
                return this.inputColumnName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("distinct", om.valueToTree(this.getDistinct()));
                data.set("separator", om.valueToTree(this.getSeparator()));
                if (this.getInputColumnName() != null) {
                    data.set("inputColumnName", om.valueToTree(this.getInputColumnName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DataPrepListAggregationFunctionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataPrepListAggregationFunctionProperty.Jsii$Proxy that = (DataPrepListAggregationFunctionProperty.Jsii$Proxy) o;

                if (!distinct.equals(that.distinct)) return false;
                if (!separator.equals(that.separator)) return false;
                return this.inputColumnName != null ? this.inputColumnName.equals(that.inputColumnName) : that.inputColumnName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.distinct.hashCode();
                result = 31 * result + (this.separator.hashCode());
                result = 31 * result + (this.inputColumnName != null ? this.inputColumnName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataPrepPercentileAggregationFunctionProperty dataPrepPercentileAggregationFunctionProperty = DataPrepPercentileAggregationFunctionProperty.builder()
     *         .percentileValue(123)
     *         // the properties below are optional
     *         .inputColumnName("inputColumnName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datapreppercentileaggregationfunction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datapreppercentileaggregationfunction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DataPrepPercentileAggregationFunctionProperty")
    @software.amazon.jsii.Jsii.Proxy(DataPrepPercentileAggregationFunctionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataPrepPercentileAggregationFunctionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datapreppercentileaggregationfunction.html#cfn-quicksight-dataset-datapreppercentileaggregationfunction-percentilevalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datapreppercentileaggregationfunction.html#cfn-quicksight-dataset-datapreppercentileaggregationfunction-percentilevalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPercentileValue();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datapreppercentileaggregationfunction.html#cfn-quicksight-dataset-datapreppercentileaggregationfunction-inputcolumnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datapreppercentileaggregationfunction.html#cfn-quicksight-dataset-datapreppercentileaggregationfunction-inputcolumnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputColumnName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataPrepPercentileAggregationFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataPrepPercentileAggregationFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataPrepPercentileAggregationFunctionProperty> {
            java.lang.Number percentileValue;
            java.lang.String inputColumnName;

            /**
             * Sets the value of {@link DataPrepPercentileAggregationFunctionProperty#getPercentileValue}
             * @param percentileValue the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder percentileValue(java.lang.Number percentileValue) {
                this.percentileValue = percentileValue;
                return this;
            }

            /**
             * Sets the value of {@link DataPrepPercentileAggregationFunctionProperty#getInputColumnName}
             * @param inputColumnName the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputColumnName(java.lang.String inputColumnName) {
                this.inputColumnName = inputColumnName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataPrepPercentileAggregationFunctionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataPrepPercentileAggregationFunctionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataPrepPercentileAggregationFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataPrepPercentileAggregationFunctionProperty {
            private final java.lang.Number percentileValue;
            private final java.lang.String inputColumnName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.percentileValue = software.amazon.jsii.Kernel.get(this, "percentileValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.inputColumnName = software.amazon.jsii.Kernel.get(this, "inputColumnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.percentileValue = java.util.Objects.requireNonNull(builder.percentileValue, "percentileValue is required");
                this.inputColumnName = builder.inputColumnName;
            }

            @Override
            public final java.lang.Number getPercentileValue() {
                return this.percentileValue;
            }

            @Override
            public final java.lang.String getInputColumnName() {
                return this.inputColumnName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("percentileValue", om.valueToTree(this.getPercentileValue()));
                if (this.getInputColumnName() != null) {
                    data.set("inputColumnName", om.valueToTree(this.getInputColumnName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DataPrepPercentileAggregationFunctionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataPrepPercentileAggregationFunctionProperty.Jsii$Proxy that = (DataPrepPercentileAggregationFunctionProperty.Jsii$Proxy) o;

                if (!percentileValue.equals(that.percentileValue)) return false;
                return this.inputColumnName != null ? this.inputColumnName.equals(that.inputColumnName) : that.inputColumnName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.percentileValue.hashCode();
                result = 31 * result + (this.inputColumnName != null ? this.inputColumnName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A simple aggregation function that performs standard statistical operations on a column.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataPrepSimpleAggregationFunctionProperty dataPrepSimpleAggregationFunctionProperty = DataPrepSimpleAggregationFunctionProperty.builder()
     *         .functionType("functionType")
     *         // the properties below are optional
     *         .inputColumnName("inputColumnName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-dataprepsimpleaggregationfunction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-dataprepsimpleaggregationfunction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DataPrepSimpleAggregationFunctionProperty")
    @software.amazon.jsii.Jsii.Proxy(DataPrepSimpleAggregationFunctionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataPrepSimpleAggregationFunctionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of aggregation function to perform, such as <code>COUNT</code> , <code>SUM</code> , <code>AVERAGE</code> , <code>MIN</code> , <code>MAX</code> , <code>MEDIAN</code> , <code>VARIANCE</code> , or <code>STANDARD_DEVIATION</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-dataprepsimpleaggregationfunction.html#cfn-quicksight-dataset-dataprepsimpleaggregationfunction-functiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-dataprepsimpleaggregationfunction.html#cfn-quicksight-dataset-dataprepsimpleaggregationfunction-functiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFunctionType();

        /**
         * The name of the column on which to perform the aggregation function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-dataprepsimpleaggregationfunction.html#cfn-quicksight-dataset-dataprepsimpleaggregationfunction-inputcolumnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-dataprepsimpleaggregationfunction.html#cfn-quicksight-dataset-dataprepsimpleaggregationfunction-inputcolumnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputColumnName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataPrepSimpleAggregationFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataPrepSimpleAggregationFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataPrepSimpleAggregationFunctionProperty> {
            java.lang.String functionType;
            java.lang.String inputColumnName;

            /**
             * Sets the value of {@link DataPrepSimpleAggregationFunctionProperty#getFunctionType}
             * @param functionType The type of aggregation function to perform, such as <code>COUNT</code> , <code>SUM</code> , <code>AVERAGE</code> , <code>MIN</code> , <code>MAX</code> , <code>MEDIAN</code> , <code>VARIANCE</code> , or <code>STANDARD_DEVIATION</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionType(java.lang.String functionType) {
                this.functionType = functionType;
                return this;
            }

            /**
             * Sets the value of {@link DataPrepSimpleAggregationFunctionProperty#getInputColumnName}
             * @param inputColumnName The name of the column on which to perform the aggregation function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputColumnName(java.lang.String inputColumnName) {
                this.inputColumnName = inputColumnName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataPrepSimpleAggregationFunctionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataPrepSimpleAggregationFunctionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataPrepSimpleAggregationFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataPrepSimpleAggregationFunctionProperty {
            private final java.lang.String functionType;
            private final java.lang.String inputColumnName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.functionType = software.amazon.jsii.Kernel.get(this, "functionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputColumnName = software.amazon.jsii.Kernel.get(this, "inputColumnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.functionType = java.util.Objects.requireNonNull(builder.functionType, "functionType is required");
                this.inputColumnName = builder.inputColumnName;
            }

            @Override
            public final java.lang.String getFunctionType() {
                return this.functionType;
            }

            @Override
            public final java.lang.String getInputColumnName() {
                return this.inputColumnName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("functionType", om.valueToTree(this.getFunctionType()));
                if (this.getInputColumnName() != null) {
                    data.set("inputColumnName", om.valueToTree(this.getInputColumnName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DataPrepSimpleAggregationFunctionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataPrepSimpleAggregationFunctionProperty.Jsii$Proxy that = (DataPrepSimpleAggregationFunctionProperty.Jsii$Proxy) o;

                if (!functionType.equals(that.functionType)) return false;
                return this.inputColumnName != null ? this.inputColumnName.equals(that.inputColumnName) : that.inputColumnName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.functionType.hashCode();
                result = 31 * result + (this.inputColumnName != null ? this.inputColumnName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetColumnIdMappingProperty dataSetColumnIdMappingProperty = DataSetColumnIdMappingProperty.builder()
     *         .sourceColumnId("sourceColumnId")
     *         .targetColumnId("targetColumnId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetcolumnidmapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetcolumnidmapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetColumnIdMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetColumnIdMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetColumnIdMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetcolumnidmapping.html#cfn-quicksight-dataset-datasetcolumnidmapping-sourcecolumnid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetcolumnidmapping.html#cfn-quicksight-dataset-datasetcolumnidmapping-sourcecolumnid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSourceColumnId();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetcolumnidmapping.html#cfn-quicksight-dataset-datasetcolumnidmapping-targetcolumnid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetcolumnidmapping.html#cfn-quicksight-dataset-datasetcolumnidmapping-targetcolumnid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetColumnId();

        /**
         * @return a {@link Builder} of {@link DataSetColumnIdMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetColumnIdMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetColumnIdMappingProperty> {
            java.lang.String sourceColumnId;
            java.lang.String targetColumnId;

            /**
             * Sets the value of {@link DataSetColumnIdMappingProperty#getSourceColumnId}
             * @param sourceColumnId the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceColumnId(java.lang.String sourceColumnId) {
                this.sourceColumnId = sourceColumnId;
                return this;
            }

            /**
             * Sets the value of {@link DataSetColumnIdMappingProperty#getTargetColumnId}
             * @param targetColumnId the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetColumnId(java.lang.String targetColumnId) {
                this.targetColumnId = targetColumnId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetColumnIdMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetColumnIdMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetColumnIdMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetColumnIdMappingProperty {
            private final java.lang.String sourceColumnId;
            private final java.lang.String targetColumnId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceColumnId = software.amazon.jsii.Kernel.get(this, "sourceColumnId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetColumnId = software.amazon.jsii.Kernel.get(this, "targetColumnId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceColumnId = java.util.Objects.requireNonNull(builder.sourceColumnId, "sourceColumnId is required");
                this.targetColumnId = java.util.Objects.requireNonNull(builder.targetColumnId, "targetColumnId is required");
            }

            @Override
            public final java.lang.String getSourceColumnId() {
                return this.sourceColumnId;
            }

            @Override
            public final java.lang.String getTargetColumnId() {
                return this.targetColumnId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourceColumnId", om.valueToTree(this.getSourceColumnId()));
                data.set("targetColumnId", om.valueToTree(this.getTargetColumnId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetColumnIdMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetColumnIdMappingProperty.Jsii$Proxy that = (DataSetColumnIdMappingProperty.Jsii$Proxy) o;

                if (!sourceColumnId.equals(that.sourceColumnId)) return false;
                return this.targetColumnId.equals(that.targetColumnId);
            }

            @Override
            public final int hashCode() {
                int result = this.sourceColumnId.hashCode();
                result = 31 * result + (this.targetColumnId.hashCode());
                return result;
            }
        }
    }
    /**
     * A filter condition that compares date values using operators like <code>BEFORE</code> , <code>AFTER</code> , or their inclusive variants.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetDateComparisonFilterConditionProperty dataSetDateComparisonFilterConditionProperty = DataSetDateComparisonFilterConditionProperty.builder()
     *         .operator("operator")
     *         // the properties below are optional
     *         .value(DataSetDateFilterValueProperty.builder()
     *                 .staticValue("staticValue")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdatecomparisonfiltercondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdatecomparisonfiltercondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetDateComparisonFilterConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetDateComparisonFilterConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetDateComparisonFilterConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The comparison operator to use, such as <code>BEFORE</code> , <code>BEFORE_OR_EQUALS_TO</code> , <code>AFTER</code> , or <code>AFTER_OR_EQUALS_TO</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdatecomparisonfiltercondition.html#cfn-quicksight-dataset-datasetdatecomparisonfiltercondition-operator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdatecomparisonfiltercondition.html#cfn-quicksight-dataset-datasetdatecomparisonfiltercondition-operator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOperator();

        /**
         * The date value to compare against.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetDateFilterValueProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdatecomparisonfiltercondition.html#cfn-quicksight-dataset-datasetdatecomparisonfiltercondition-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdatecomparisonfiltercondition.html#cfn-quicksight-dataset-datasetdatecomparisonfiltercondition-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSetDateComparisonFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetDateComparisonFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetDateComparisonFilterConditionProperty> {
            java.lang.String operator;
            java.lang.Object value;

            /**
             * Sets the value of {@link DataSetDateComparisonFilterConditionProperty#getOperator}
             * @param operator The comparison operator to use, such as <code>BEFORE</code> , <code>BEFORE_OR_EQUALS_TO</code> , <code>AFTER</code> , or <code>AFTER_OR_EQUALS_TO</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operator(java.lang.String operator) {
                this.operator = operator;
                return this;
            }

            /**
             * Sets the value of {@link DataSetDateComparisonFilterConditionProperty#getValue}
             * @param value The date value to compare against.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.IResolvable value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link DataSetDateComparisonFilterConditionProperty#getValue}
             * @param value The date value to compare against.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetDateFilterValueProperty value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetDateComparisonFilterConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetDateComparisonFilterConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetDateComparisonFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetDateComparisonFilterConditionProperty {
            private final java.lang.String operator;
            private final java.lang.Object value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.operator = software.amazon.jsii.Kernel.get(this, "operator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.operator = java.util.Objects.requireNonNull(builder.operator, "operator is required");
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getOperator() {
                return this.operator;
            }

            @Override
            public final java.lang.Object getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("operator", om.valueToTree(this.getOperator()));
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetDateComparisonFilterConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetDateComparisonFilterConditionProperty.Jsii$Proxy that = (DataSetDateComparisonFilterConditionProperty.Jsii$Proxy) o;

                if (!operator.equals(that.operator)) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.operator.hashCode();
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A filter condition for date columns, supporting both comparison and range-based filtering.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetDateFilterConditionProperty dataSetDateFilterConditionProperty = DataSetDateFilterConditionProperty.builder()
     *         .columnName("columnName")
     *         .comparisonFilterCondition(DataSetDateComparisonFilterConditionProperty.builder()
     *                 .operator("operator")
     *                 // the properties below are optional
     *                 .value(DataSetDateFilterValueProperty.builder()
     *                         .staticValue("staticValue")
     *                         .build())
     *                 .build())
     *         .rangeFilterCondition(DataSetDateRangeFilterConditionProperty.builder()
     *                 .includeMaximum(false)
     *                 .includeMinimum(false)
     *                 .rangeMaximum(DataSetDateFilterValueProperty.builder()
     *                         .staticValue("staticValue")
     *                         .build())
     *                 .rangeMinimum(DataSetDateFilterValueProperty.builder()
     *                         .staticValue("staticValue")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdatefiltercondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdatefiltercondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetDateFilterConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetDateFilterConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetDateFilterConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the date column to filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdatefiltercondition.html#cfn-quicksight-dataset-datasetdatefiltercondition-columnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdatefiltercondition.html#cfn-quicksight-dataset-datasetdatefiltercondition-columnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getColumnName() {
            return null;
        }

        /**
         * A comparison-based filter condition for the date column.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetDateComparisonFilterConditionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdatefiltercondition.html#cfn-quicksight-dataset-datasetdatefiltercondition-comparisonfiltercondition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdatefiltercondition.html#cfn-quicksight-dataset-datasetdatefiltercondition-comparisonfiltercondition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComparisonFilterCondition() {
            return null;
        }

        /**
         * A range-based filter condition for the date column, filtering values between minimum and maximum dates.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetDateRangeFilterConditionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdatefiltercondition.html#cfn-quicksight-dataset-datasetdatefiltercondition-rangefiltercondition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdatefiltercondition.html#cfn-quicksight-dataset-datasetdatefiltercondition-rangefiltercondition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRangeFilterCondition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSetDateFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetDateFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetDateFilterConditionProperty> {
            java.lang.String columnName;
            java.lang.Object comparisonFilterCondition;
            java.lang.Object rangeFilterCondition;

            /**
             * Sets the value of {@link DataSetDateFilterConditionProperty#getColumnName}
             * @param columnName The name of the date column to filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link DataSetDateFilterConditionProperty#getComparisonFilterCondition}
             * @param comparisonFilterCondition A comparison-based filter condition for the date column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparisonFilterCondition(software.amazon.awscdk.IResolvable comparisonFilterCondition) {
                this.comparisonFilterCondition = comparisonFilterCondition;
                return this;
            }

            /**
             * Sets the value of {@link DataSetDateFilterConditionProperty#getComparisonFilterCondition}
             * @param comparisonFilterCondition A comparison-based filter condition for the date column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparisonFilterCondition(software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetDateComparisonFilterConditionProperty comparisonFilterCondition) {
                this.comparisonFilterCondition = comparisonFilterCondition;
                return this;
            }

            /**
             * Sets the value of {@link DataSetDateFilterConditionProperty#getRangeFilterCondition}
             * @param rangeFilterCondition A range-based filter condition for the date column, filtering values between minimum and maximum dates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeFilterCondition(software.amazon.awscdk.IResolvable rangeFilterCondition) {
                this.rangeFilterCondition = rangeFilterCondition;
                return this;
            }

            /**
             * Sets the value of {@link DataSetDateFilterConditionProperty#getRangeFilterCondition}
             * @param rangeFilterCondition A range-based filter condition for the date column, filtering values between minimum and maximum dates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeFilterCondition(software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetDateRangeFilterConditionProperty rangeFilterCondition) {
                this.rangeFilterCondition = rangeFilterCondition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetDateFilterConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetDateFilterConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetDateFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetDateFilterConditionProperty {
            private final java.lang.String columnName;
            private final java.lang.Object comparisonFilterCondition;
            private final java.lang.Object rangeFilterCondition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.comparisonFilterCondition = software.amazon.jsii.Kernel.get(this, "comparisonFilterCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rangeFilterCondition = software.amazon.jsii.Kernel.get(this, "rangeFilterCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnName = builder.columnName;
                this.comparisonFilterCondition = builder.comparisonFilterCondition;
                this.rangeFilterCondition = builder.rangeFilterCondition;
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.lang.Object getComparisonFilterCondition() {
                return this.comparisonFilterCondition;
            }

            @Override
            public final java.lang.Object getRangeFilterCondition() {
                return this.rangeFilterCondition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumnName() != null) {
                    data.set("columnName", om.valueToTree(this.getColumnName()));
                }
                if (this.getComparisonFilterCondition() != null) {
                    data.set("comparisonFilterCondition", om.valueToTree(this.getComparisonFilterCondition()));
                }
                if (this.getRangeFilterCondition() != null) {
                    data.set("rangeFilterCondition", om.valueToTree(this.getRangeFilterCondition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetDateFilterConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetDateFilterConditionProperty.Jsii$Proxy that = (DataSetDateFilterConditionProperty.Jsii$Proxy) o;

                if (this.columnName != null ? !this.columnName.equals(that.columnName) : that.columnName != null) return false;
                if (this.comparisonFilterCondition != null ? !this.comparisonFilterCondition.equals(that.comparisonFilterCondition) : that.comparisonFilterCondition != null) return false;
                return this.rangeFilterCondition != null ? this.rangeFilterCondition.equals(that.rangeFilterCondition) : that.rangeFilterCondition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnName != null ? this.columnName.hashCode() : 0;
                result = 31 * result + (this.comparisonFilterCondition != null ? this.comparisonFilterCondition.hashCode() : 0);
                result = 31 * result + (this.rangeFilterCondition != null ? this.rangeFilterCondition.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a date value used in filter conditions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetDateFilterValueProperty dataSetDateFilterValueProperty = DataSetDateFilterValueProperty.builder()
     *         .staticValue("staticValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdatefiltervalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdatefiltervalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetDateFilterValueProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetDateFilterValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetDateFilterValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A static date value used for filtering.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdatefiltervalue.html#cfn-quicksight-dataset-datasetdatefiltervalue-staticvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdatefiltervalue.html#cfn-quicksight-dataset-datasetdatefiltervalue-staticvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStaticValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSetDateFilterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetDateFilterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetDateFilterValueProperty> {
            java.lang.String staticValue;

            /**
             * Sets the value of {@link DataSetDateFilterValueProperty#getStaticValue}
             * @param staticValue A static date value used for filtering.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder staticValue(java.lang.String staticValue) {
                this.staticValue = staticValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetDateFilterValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetDateFilterValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetDateFilterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetDateFilterValueProperty {
            private final java.lang.String staticValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.staticValue = software.amazon.jsii.Kernel.get(this, "staticValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.staticValue = builder.staticValue;
            }

            @Override
            public final java.lang.String getStaticValue() {
                return this.staticValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getStaticValue() != null) {
                    data.set("staticValue", om.valueToTree(this.getStaticValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetDateFilterValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetDateFilterValueProperty.Jsii$Proxy that = (DataSetDateFilterValueProperty.Jsii$Proxy) o;

                return this.staticValue != null ? this.staticValue.equals(that.staticValue) : that.staticValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.staticValue != null ? this.staticValue.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A filter condition that filters date values within a specified range.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetDateRangeFilterConditionProperty dataSetDateRangeFilterConditionProperty = DataSetDateRangeFilterConditionProperty.builder()
     *         .includeMaximum(false)
     *         .includeMinimum(false)
     *         .rangeMaximum(DataSetDateFilterValueProperty.builder()
     *                 .staticValue("staticValue")
     *                 .build())
     *         .rangeMinimum(DataSetDateFilterValueProperty.builder()
     *                 .staticValue("staticValue")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdaterangefiltercondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdaterangefiltercondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetDateRangeFilterConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetDateRangeFilterConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetDateRangeFilterConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether to include the maximum value in the filter range.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdaterangefiltercondition.html#cfn-quicksight-dataset-datasetdaterangefiltercondition-includemaximum">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdaterangefiltercondition.html#cfn-quicksight-dataset-datasetdaterangefiltercondition-includemaximum</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeMaximum() {
            return null;
        }

        /**
         * Whether to include the minimum value in the filter range.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdaterangefiltercondition.html#cfn-quicksight-dataset-datasetdaterangefiltercondition-includeminimum">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdaterangefiltercondition.html#cfn-quicksight-dataset-datasetdaterangefiltercondition-includeminimum</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeMinimum() {
            return null;
        }

        /**
         * The maximum date value for the range filter.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetDateFilterValueProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdaterangefiltercondition.html#cfn-quicksight-dataset-datasetdaterangefiltercondition-rangemaximum">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdaterangefiltercondition.html#cfn-quicksight-dataset-datasetdaterangefiltercondition-rangemaximum</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRangeMaximum() {
            return null;
        }

        /**
         * The minimum date value for the range filter.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetDateFilterValueProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdaterangefiltercondition.html#cfn-quicksight-dataset-datasetdaterangefiltercondition-rangeminimum">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetdaterangefiltercondition.html#cfn-quicksight-dataset-datasetdaterangefiltercondition-rangeminimum</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRangeMinimum() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSetDateRangeFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetDateRangeFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetDateRangeFilterConditionProperty> {
            java.lang.Object includeMaximum;
            java.lang.Object includeMinimum;
            java.lang.Object rangeMaximum;
            java.lang.Object rangeMinimum;

            /**
             * Sets the value of {@link DataSetDateRangeFilterConditionProperty#getIncludeMaximum}
             * @param includeMaximum Whether to include the maximum value in the filter range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeMaximum(java.lang.Boolean includeMaximum) {
                this.includeMaximum = includeMaximum;
                return this;
            }

            /**
             * Sets the value of {@link DataSetDateRangeFilterConditionProperty#getIncludeMaximum}
             * @param includeMaximum Whether to include the maximum value in the filter range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeMaximum(software.amazon.awscdk.IResolvable includeMaximum) {
                this.includeMaximum = includeMaximum;
                return this;
            }

            /**
             * Sets the value of {@link DataSetDateRangeFilterConditionProperty#getIncludeMinimum}
             * @param includeMinimum Whether to include the minimum value in the filter range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeMinimum(java.lang.Boolean includeMinimum) {
                this.includeMinimum = includeMinimum;
                return this;
            }

            /**
             * Sets the value of {@link DataSetDateRangeFilterConditionProperty#getIncludeMinimum}
             * @param includeMinimum Whether to include the minimum value in the filter range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeMinimum(software.amazon.awscdk.IResolvable includeMinimum) {
                this.includeMinimum = includeMinimum;
                return this;
            }

            /**
             * Sets the value of {@link DataSetDateRangeFilterConditionProperty#getRangeMaximum}
             * @param rangeMaximum The maximum date value for the range filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeMaximum(software.amazon.awscdk.IResolvable rangeMaximum) {
                this.rangeMaximum = rangeMaximum;
                return this;
            }

            /**
             * Sets the value of {@link DataSetDateRangeFilterConditionProperty#getRangeMaximum}
             * @param rangeMaximum The maximum date value for the range filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeMaximum(software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetDateFilterValueProperty rangeMaximum) {
                this.rangeMaximum = rangeMaximum;
                return this;
            }

            /**
             * Sets the value of {@link DataSetDateRangeFilterConditionProperty#getRangeMinimum}
             * @param rangeMinimum The minimum date value for the range filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeMinimum(software.amazon.awscdk.IResolvable rangeMinimum) {
                this.rangeMinimum = rangeMinimum;
                return this;
            }

            /**
             * Sets the value of {@link DataSetDateRangeFilterConditionProperty#getRangeMinimum}
             * @param rangeMinimum The minimum date value for the range filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeMinimum(software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetDateFilterValueProperty rangeMinimum) {
                this.rangeMinimum = rangeMinimum;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetDateRangeFilterConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetDateRangeFilterConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetDateRangeFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetDateRangeFilterConditionProperty {
            private final java.lang.Object includeMaximum;
            private final java.lang.Object includeMinimum;
            private final java.lang.Object rangeMaximum;
            private final java.lang.Object rangeMinimum;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.includeMaximum = software.amazon.jsii.Kernel.get(this, "includeMaximum", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeMinimum = software.amazon.jsii.Kernel.get(this, "includeMinimum", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rangeMaximum = software.amazon.jsii.Kernel.get(this, "rangeMaximum", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rangeMinimum = software.amazon.jsii.Kernel.get(this, "rangeMinimum", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.includeMaximum = builder.includeMaximum;
                this.includeMinimum = builder.includeMinimum;
                this.rangeMaximum = builder.rangeMaximum;
                this.rangeMinimum = builder.rangeMinimum;
            }

            @Override
            public final java.lang.Object getIncludeMaximum() {
                return this.includeMaximum;
            }

            @Override
            public final java.lang.Object getIncludeMinimum() {
                return this.includeMinimum;
            }

            @Override
            public final java.lang.Object getRangeMaximum() {
                return this.rangeMaximum;
            }

            @Override
            public final java.lang.Object getRangeMinimum() {
                return this.rangeMinimum;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIncludeMaximum() != null) {
                    data.set("includeMaximum", om.valueToTree(this.getIncludeMaximum()));
                }
                if (this.getIncludeMinimum() != null) {
                    data.set("includeMinimum", om.valueToTree(this.getIncludeMinimum()));
                }
                if (this.getRangeMaximum() != null) {
                    data.set("rangeMaximum", om.valueToTree(this.getRangeMaximum()));
                }
                if (this.getRangeMinimum() != null) {
                    data.set("rangeMinimum", om.valueToTree(this.getRangeMinimum()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetDateRangeFilterConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetDateRangeFilterConditionProperty.Jsii$Proxy that = (DataSetDateRangeFilterConditionProperty.Jsii$Proxy) o;

                if (this.includeMaximum != null ? !this.includeMaximum.equals(that.includeMaximum) : that.includeMaximum != null) return false;
                if (this.includeMinimum != null ? !this.includeMinimum.equals(that.includeMinimum) : that.includeMinimum != null) return false;
                if (this.rangeMaximum != null ? !this.rangeMaximum.equals(that.rangeMaximum) : that.rangeMaximum != null) return false;
                return this.rangeMinimum != null ? this.rangeMinimum.equals(that.rangeMinimum) : that.rangeMinimum == null;
            }

            @Override
            public final int hashCode() {
                int result = this.includeMaximum != null ? this.includeMaximum.hashCode() : 0;
                result = 31 * result + (this.includeMinimum != null ? this.includeMinimum.hashCode() : 0);
                result = 31 * result + (this.rangeMaximum != null ? this.rangeMaximum.hashCode() : 0);
                result = 31 * result + (this.rangeMinimum != null ? this.rangeMinimum.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A filter condition that compares numeric values using operators like <code>EQUALS</code> , <code>GREATER_THAN</code> , or <code>LESS_THAN</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetNumericComparisonFilterConditionProperty dataSetNumericComparisonFilterConditionProperty = DataSetNumericComparisonFilterConditionProperty.builder()
     *         .operator("operator")
     *         // the properties below are optional
     *         .value(DataSetNumericFilterValueProperty.builder()
     *                 .staticValue(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericcomparisonfiltercondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericcomparisonfiltercondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetNumericComparisonFilterConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetNumericComparisonFilterConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetNumericComparisonFilterConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The comparison operator to use, such as <code>EQUALS</code> , <code>GREATER_THAN</code> , <code>LESS_THAN</code> , or their variants.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericcomparisonfiltercondition.html#cfn-quicksight-dataset-datasetnumericcomparisonfiltercondition-operator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericcomparisonfiltercondition.html#cfn-quicksight-dataset-datasetnumericcomparisonfiltercondition-operator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOperator();

        /**
         * The numeric value to compare against.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetNumericFilterValueProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericcomparisonfiltercondition.html#cfn-quicksight-dataset-datasetnumericcomparisonfiltercondition-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericcomparisonfiltercondition.html#cfn-quicksight-dataset-datasetnumericcomparisonfiltercondition-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSetNumericComparisonFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetNumericComparisonFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetNumericComparisonFilterConditionProperty> {
            java.lang.String operator;
            java.lang.Object value;

            /**
             * Sets the value of {@link DataSetNumericComparisonFilterConditionProperty#getOperator}
             * @param operator The comparison operator to use, such as <code>EQUALS</code> , <code>GREATER_THAN</code> , <code>LESS_THAN</code> , or their variants. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operator(java.lang.String operator) {
                this.operator = operator;
                return this;
            }

            /**
             * Sets the value of {@link DataSetNumericComparisonFilterConditionProperty#getValue}
             * @param value The numeric value to compare against.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.IResolvable value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link DataSetNumericComparisonFilterConditionProperty#getValue}
             * @param value The numeric value to compare against.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetNumericFilterValueProperty value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetNumericComparisonFilterConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetNumericComparisonFilterConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetNumericComparisonFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetNumericComparisonFilterConditionProperty {
            private final java.lang.String operator;
            private final java.lang.Object value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.operator = software.amazon.jsii.Kernel.get(this, "operator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.operator = java.util.Objects.requireNonNull(builder.operator, "operator is required");
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getOperator() {
                return this.operator;
            }

            @Override
            public final java.lang.Object getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("operator", om.valueToTree(this.getOperator()));
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetNumericComparisonFilterConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetNumericComparisonFilterConditionProperty.Jsii$Proxy that = (DataSetNumericComparisonFilterConditionProperty.Jsii$Proxy) o;

                if (!operator.equals(that.operator)) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.operator.hashCode();
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A filter condition for numeric columns, supporting both comparison and range-based filtering.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetNumericFilterConditionProperty dataSetNumericFilterConditionProperty = DataSetNumericFilterConditionProperty.builder()
     *         .columnName("columnName")
     *         .comparisonFilterCondition(DataSetNumericComparisonFilterConditionProperty.builder()
     *                 .operator("operator")
     *                 // the properties below are optional
     *                 .value(DataSetNumericFilterValueProperty.builder()
     *                         .staticValue(123)
     *                         .build())
     *                 .build())
     *         .rangeFilterCondition(DataSetNumericRangeFilterConditionProperty.builder()
     *                 .includeMaximum(false)
     *                 .includeMinimum(false)
     *                 .rangeMaximum(DataSetNumericFilterValueProperty.builder()
     *                         .staticValue(123)
     *                         .build())
     *                 .rangeMinimum(DataSetNumericFilterValueProperty.builder()
     *                         .staticValue(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericfiltercondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericfiltercondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetNumericFilterConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetNumericFilterConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetNumericFilterConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the numeric column to filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericfiltercondition.html#cfn-quicksight-dataset-datasetnumericfiltercondition-columnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericfiltercondition.html#cfn-quicksight-dataset-datasetnumericfiltercondition-columnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getColumnName() {
            return null;
        }

        /**
         * A comparison-based filter condition for the numeric column.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetNumericComparisonFilterConditionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericfiltercondition.html#cfn-quicksight-dataset-datasetnumericfiltercondition-comparisonfiltercondition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericfiltercondition.html#cfn-quicksight-dataset-datasetnumericfiltercondition-comparisonfiltercondition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComparisonFilterCondition() {
            return null;
        }

        /**
         * A range-based filter condition for the numeric column, filtering values between minimum and maximum numbers.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetNumericRangeFilterConditionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericfiltercondition.html#cfn-quicksight-dataset-datasetnumericfiltercondition-rangefiltercondition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericfiltercondition.html#cfn-quicksight-dataset-datasetnumericfiltercondition-rangefiltercondition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRangeFilterCondition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSetNumericFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetNumericFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetNumericFilterConditionProperty> {
            java.lang.String columnName;
            java.lang.Object comparisonFilterCondition;
            java.lang.Object rangeFilterCondition;

            /**
             * Sets the value of {@link DataSetNumericFilterConditionProperty#getColumnName}
             * @param columnName The name of the numeric column to filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link DataSetNumericFilterConditionProperty#getComparisonFilterCondition}
             * @param comparisonFilterCondition A comparison-based filter condition for the numeric column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparisonFilterCondition(software.amazon.awscdk.IResolvable comparisonFilterCondition) {
                this.comparisonFilterCondition = comparisonFilterCondition;
                return this;
            }

            /**
             * Sets the value of {@link DataSetNumericFilterConditionProperty#getComparisonFilterCondition}
             * @param comparisonFilterCondition A comparison-based filter condition for the numeric column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparisonFilterCondition(software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetNumericComparisonFilterConditionProperty comparisonFilterCondition) {
                this.comparisonFilterCondition = comparisonFilterCondition;
                return this;
            }

            /**
             * Sets the value of {@link DataSetNumericFilterConditionProperty#getRangeFilterCondition}
             * @param rangeFilterCondition A range-based filter condition for the numeric column, filtering values between minimum and maximum numbers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeFilterCondition(software.amazon.awscdk.IResolvable rangeFilterCondition) {
                this.rangeFilterCondition = rangeFilterCondition;
                return this;
            }

            /**
             * Sets the value of {@link DataSetNumericFilterConditionProperty#getRangeFilterCondition}
             * @param rangeFilterCondition A range-based filter condition for the numeric column, filtering values between minimum and maximum numbers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeFilterCondition(software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetNumericRangeFilterConditionProperty rangeFilterCondition) {
                this.rangeFilterCondition = rangeFilterCondition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetNumericFilterConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetNumericFilterConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetNumericFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetNumericFilterConditionProperty {
            private final java.lang.String columnName;
            private final java.lang.Object comparisonFilterCondition;
            private final java.lang.Object rangeFilterCondition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.comparisonFilterCondition = software.amazon.jsii.Kernel.get(this, "comparisonFilterCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rangeFilterCondition = software.amazon.jsii.Kernel.get(this, "rangeFilterCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnName = builder.columnName;
                this.comparisonFilterCondition = builder.comparisonFilterCondition;
                this.rangeFilterCondition = builder.rangeFilterCondition;
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.lang.Object getComparisonFilterCondition() {
                return this.comparisonFilterCondition;
            }

            @Override
            public final java.lang.Object getRangeFilterCondition() {
                return this.rangeFilterCondition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumnName() != null) {
                    data.set("columnName", om.valueToTree(this.getColumnName()));
                }
                if (this.getComparisonFilterCondition() != null) {
                    data.set("comparisonFilterCondition", om.valueToTree(this.getComparisonFilterCondition()));
                }
                if (this.getRangeFilterCondition() != null) {
                    data.set("rangeFilterCondition", om.valueToTree(this.getRangeFilterCondition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetNumericFilterConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetNumericFilterConditionProperty.Jsii$Proxy that = (DataSetNumericFilterConditionProperty.Jsii$Proxy) o;

                if (this.columnName != null ? !this.columnName.equals(that.columnName) : that.columnName != null) return false;
                if (this.comparisonFilterCondition != null ? !this.comparisonFilterCondition.equals(that.comparisonFilterCondition) : that.comparisonFilterCondition != null) return false;
                return this.rangeFilterCondition != null ? this.rangeFilterCondition.equals(that.rangeFilterCondition) : that.rangeFilterCondition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnName != null ? this.columnName.hashCode() : 0;
                result = 31 * result + (this.comparisonFilterCondition != null ? this.comparisonFilterCondition.hashCode() : 0);
                result = 31 * result + (this.rangeFilterCondition != null ? this.rangeFilterCondition.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a numeric value used in filter conditions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetNumericFilterValueProperty dataSetNumericFilterValueProperty = DataSetNumericFilterValueProperty.builder()
     *         .staticValue(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericfiltervalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericfiltervalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetNumericFilterValueProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetNumericFilterValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetNumericFilterValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A static numeric value used for filtering.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericfiltervalue.html#cfn-quicksight-dataset-datasetnumericfiltervalue-staticvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericfiltervalue.html#cfn-quicksight-dataset-datasetnumericfiltervalue-staticvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStaticValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSetNumericFilterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetNumericFilterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetNumericFilterValueProperty> {
            java.lang.Number staticValue;

            /**
             * Sets the value of {@link DataSetNumericFilterValueProperty#getStaticValue}
             * @param staticValue A static numeric value used for filtering.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder staticValue(java.lang.Number staticValue) {
                this.staticValue = staticValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetNumericFilterValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetNumericFilterValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetNumericFilterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetNumericFilterValueProperty {
            private final java.lang.Number staticValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.staticValue = software.amazon.jsii.Kernel.get(this, "staticValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.staticValue = builder.staticValue;
            }

            @Override
            public final java.lang.Number getStaticValue() {
                return this.staticValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getStaticValue() != null) {
                    data.set("staticValue", om.valueToTree(this.getStaticValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetNumericFilterValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetNumericFilterValueProperty.Jsii$Proxy that = (DataSetNumericFilterValueProperty.Jsii$Proxy) o;

                return this.staticValue != null ? this.staticValue.equals(that.staticValue) : that.staticValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.staticValue != null ? this.staticValue.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A filter condition that filters numeric values within a specified range.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetNumericRangeFilterConditionProperty dataSetNumericRangeFilterConditionProperty = DataSetNumericRangeFilterConditionProperty.builder()
     *         .includeMaximum(false)
     *         .includeMinimum(false)
     *         .rangeMaximum(DataSetNumericFilterValueProperty.builder()
     *                 .staticValue(123)
     *                 .build())
     *         .rangeMinimum(DataSetNumericFilterValueProperty.builder()
     *                 .staticValue(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericrangefiltercondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericrangefiltercondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetNumericRangeFilterConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetNumericRangeFilterConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetNumericRangeFilterConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether to include the maximum value in the filter range.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericrangefiltercondition.html#cfn-quicksight-dataset-datasetnumericrangefiltercondition-includemaximum">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericrangefiltercondition.html#cfn-quicksight-dataset-datasetnumericrangefiltercondition-includemaximum</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeMaximum() {
            return null;
        }

        /**
         * Whether to include the minimum value in the filter range.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericrangefiltercondition.html#cfn-quicksight-dataset-datasetnumericrangefiltercondition-includeminimum">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericrangefiltercondition.html#cfn-quicksight-dataset-datasetnumericrangefiltercondition-includeminimum</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeMinimum() {
            return null;
        }

        /**
         * The maximum numeric value for the range filter.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetNumericFilterValueProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericrangefiltercondition.html#cfn-quicksight-dataset-datasetnumericrangefiltercondition-rangemaximum">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericrangefiltercondition.html#cfn-quicksight-dataset-datasetnumericrangefiltercondition-rangemaximum</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRangeMaximum() {
            return null;
        }

        /**
         * The minimum numeric value for the range filter.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetNumericFilterValueProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericrangefiltercondition.html#cfn-quicksight-dataset-datasetnumericrangefiltercondition-rangeminimum">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetnumericrangefiltercondition.html#cfn-quicksight-dataset-datasetnumericrangefiltercondition-rangeminimum</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRangeMinimum() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSetNumericRangeFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetNumericRangeFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetNumericRangeFilterConditionProperty> {
            java.lang.Object includeMaximum;
            java.lang.Object includeMinimum;
            java.lang.Object rangeMaximum;
            java.lang.Object rangeMinimum;

            /**
             * Sets the value of {@link DataSetNumericRangeFilterConditionProperty#getIncludeMaximum}
             * @param includeMaximum Whether to include the maximum value in the filter range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeMaximum(java.lang.Boolean includeMaximum) {
                this.includeMaximum = includeMaximum;
                return this;
            }

            /**
             * Sets the value of {@link DataSetNumericRangeFilterConditionProperty#getIncludeMaximum}
             * @param includeMaximum Whether to include the maximum value in the filter range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeMaximum(software.amazon.awscdk.IResolvable includeMaximum) {
                this.includeMaximum = includeMaximum;
                return this;
            }

            /**
             * Sets the value of {@link DataSetNumericRangeFilterConditionProperty#getIncludeMinimum}
             * @param includeMinimum Whether to include the minimum value in the filter range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeMinimum(java.lang.Boolean includeMinimum) {
                this.includeMinimum = includeMinimum;
                return this;
            }

            /**
             * Sets the value of {@link DataSetNumericRangeFilterConditionProperty#getIncludeMinimum}
             * @param includeMinimum Whether to include the minimum value in the filter range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeMinimum(software.amazon.awscdk.IResolvable includeMinimum) {
                this.includeMinimum = includeMinimum;
                return this;
            }

            /**
             * Sets the value of {@link DataSetNumericRangeFilterConditionProperty#getRangeMaximum}
             * @param rangeMaximum The maximum numeric value for the range filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeMaximum(software.amazon.awscdk.IResolvable rangeMaximum) {
                this.rangeMaximum = rangeMaximum;
                return this;
            }

            /**
             * Sets the value of {@link DataSetNumericRangeFilterConditionProperty#getRangeMaximum}
             * @param rangeMaximum The maximum numeric value for the range filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeMaximum(software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetNumericFilterValueProperty rangeMaximum) {
                this.rangeMaximum = rangeMaximum;
                return this;
            }

            /**
             * Sets the value of {@link DataSetNumericRangeFilterConditionProperty#getRangeMinimum}
             * @param rangeMinimum The minimum numeric value for the range filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeMinimum(software.amazon.awscdk.IResolvable rangeMinimum) {
                this.rangeMinimum = rangeMinimum;
                return this;
            }

            /**
             * Sets the value of {@link DataSetNumericRangeFilterConditionProperty#getRangeMinimum}
             * @param rangeMinimum The minimum numeric value for the range filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeMinimum(software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetNumericFilterValueProperty rangeMinimum) {
                this.rangeMinimum = rangeMinimum;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetNumericRangeFilterConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetNumericRangeFilterConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetNumericRangeFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetNumericRangeFilterConditionProperty {
            private final java.lang.Object includeMaximum;
            private final java.lang.Object includeMinimum;
            private final java.lang.Object rangeMaximum;
            private final java.lang.Object rangeMinimum;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.includeMaximum = software.amazon.jsii.Kernel.get(this, "includeMaximum", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeMinimum = software.amazon.jsii.Kernel.get(this, "includeMinimum", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rangeMaximum = software.amazon.jsii.Kernel.get(this, "rangeMaximum", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rangeMinimum = software.amazon.jsii.Kernel.get(this, "rangeMinimum", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.includeMaximum = builder.includeMaximum;
                this.includeMinimum = builder.includeMinimum;
                this.rangeMaximum = builder.rangeMaximum;
                this.rangeMinimum = builder.rangeMinimum;
            }

            @Override
            public final java.lang.Object getIncludeMaximum() {
                return this.includeMaximum;
            }

            @Override
            public final java.lang.Object getIncludeMinimum() {
                return this.includeMinimum;
            }

            @Override
            public final java.lang.Object getRangeMaximum() {
                return this.rangeMaximum;
            }

            @Override
            public final java.lang.Object getRangeMinimum() {
                return this.rangeMinimum;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIncludeMaximum() != null) {
                    data.set("includeMaximum", om.valueToTree(this.getIncludeMaximum()));
                }
                if (this.getIncludeMinimum() != null) {
                    data.set("includeMinimum", om.valueToTree(this.getIncludeMinimum()));
                }
                if (this.getRangeMaximum() != null) {
                    data.set("rangeMaximum", om.valueToTree(this.getRangeMaximum()));
                }
                if (this.getRangeMinimum() != null) {
                    data.set("rangeMinimum", om.valueToTree(this.getRangeMinimum()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetNumericRangeFilterConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetNumericRangeFilterConditionProperty.Jsii$Proxy that = (DataSetNumericRangeFilterConditionProperty.Jsii$Proxy) o;

                if (this.includeMaximum != null ? !this.includeMaximum.equals(that.includeMaximum) : that.includeMaximum != null) return false;
                if (this.includeMinimum != null ? !this.includeMinimum.equals(that.includeMinimum) : that.includeMinimum != null) return false;
                if (this.rangeMaximum != null ? !this.rangeMaximum.equals(that.rangeMaximum) : that.rangeMaximum != null) return false;
                return this.rangeMinimum != null ? this.rangeMinimum.equals(that.rangeMinimum) : that.rangeMinimum == null;
            }

            @Override
            public final int hashCode() {
                int result = this.includeMaximum != null ? this.includeMaximum.hashCode() : 0;
                result = 31 * result + (this.includeMinimum != null ? this.includeMinimum.hashCode() : 0);
                result = 31 * result + (this.rangeMaximum != null ? this.rangeMaximum.hashCode() : 0);
                result = 31 * result + (this.rangeMinimum != null ? this.rangeMinimum.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The refresh properties of a dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetRefreshPropertiesProperty dataSetRefreshPropertiesProperty = DataSetRefreshPropertiesProperty.builder()
     *         .failureConfiguration(RefreshFailureConfigurationProperty.builder()
     *                 .emailAlert(RefreshFailureEmailAlertProperty.builder()
     *                         .alertStatus("alertStatus")
     *                         .build())
     *                 .build())
     *         .refreshConfiguration(RefreshConfigurationProperty.builder()
     *                 .incrementalRefresh(IncrementalRefreshProperty.builder()
     *                         .lookbackWindow(LookbackWindowProperty.builder()
     *                                 .columnName("columnName")
     *                                 .size(123)
     *                                 .sizeUnit("sizeUnit")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetrefreshproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetrefreshproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetRefreshPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetRefreshPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetRefreshPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The failure configuration for a dataset.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.RefreshFailureConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetrefreshproperties.html#cfn-quicksight-dataset-datasetrefreshproperties-failureconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetrefreshproperties.html#cfn-quicksight-dataset-datasetrefreshproperties-failureconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFailureConfiguration() {
            return null;
        }

        /**
         * The refresh configuration for a dataset.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.RefreshConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetrefreshproperties.html#cfn-quicksight-dataset-datasetrefreshproperties-refreshconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetrefreshproperties.html#cfn-quicksight-dataset-datasetrefreshproperties-refreshconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRefreshConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSetRefreshPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetRefreshPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetRefreshPropertiesProperty> {
            java.lang.Object failureConfiguration;
            java.lang.Object refreshConfiguration;

            /**
             * Sets the value of {@link DataSetRefreshPropertiesProperty#getFailureConfiguration}
             * @param failureConfiguration The failure configuration for a dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureConfiguration(software.amazon.awscdk.IResolvable failureConfiguration) {
                this.failureConfiguration = failureConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSetRefreshPropertiesProperty#getFailureConfiguration}
             * @param failureConfiguration The failure configuration for a dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureConfiguration(software.amazon.awscdk.services.quicksight.CfnDataSet.RefreshFailureConfigurationProperty failureConfiguration) {
                this.failureConfiguration = failureConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSetRefreshPropertiesProperty#getRefreshConfiguration}
             * @param refreshConfiguration The refresh configuration for a dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshConfiguration(software.amazon.awscdk.IResolvable refreshConfiguration) {
                this.refreshConfiguration = refreshConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSetRefreshPropertiesProperty#getRefreshConfiguration}
             * @param refreshConfiguration The refresh configuration for a dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshConfiguration(software.amazon.awscdk.services.quicksight.CfnDataSet.RefreshConfigurationProperty refreshConfiguration) {
                this.refreshConfiguration = refreshConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetRefreshPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetRefreshPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetRefreshPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetRefreshPropertiesProperty {
            private final java.lang.Object failureConfiguration;
            private final java.lang.Object refreshConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.failureConfiguration = software.amazon.jsii.Kernel.get(this, "failureConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.refreshConfiguration = software.amazon.jsii.Kernel.get(this, "refreshConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.failureConfiguration = builder.failureConfiguration;
                this.refreshConfiguration = builder.refreshConfiguration;
            }

            @Override
            public final java.lang.Object getFailureConfiguration() {
                return this.failureConfiguration;
            }

            @Override
            public final java.lang.Object getRefreshConfiguration() {
                return this.refreshConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFailureConfiguration() != null) {
                    data.set("failureConfiguration", om.valueToTree(this.getFailureConfiguration()));
                }
                if (this.getRefreshConfiguration() != null) {
                    data.set("refreshConfiguration", om.valueToTree(this.getRefreshConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetRefreshPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetRefreshPropertiesProperty.Jsii$Proxy that = (DataSetRefreshPropertiesProperty.Jsii$Proxy) o;

                if (this.failureConfiguration != null ? !this.failureConfiguration.equals(that.failureConfiguration) : that.failureConfiguration != null) return false;
                return this.refreshConfiguration != null ? this.refreshConfiguration.equals(that.refreshConfiguration) : that.refreshConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.failureConfiguration != null ? this.failureConfiguration.hashCode() : 0;
                result = 31 * result + (this.refreshConfiguration != null ? this.refreshConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A filter condition that compares string values using operators like <code>EQUALS</code> , <code>CONTAINS</code> , or <code>STARTS_WITH</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetStringComparisonFilterConditionProperty dataSetStringComparisonFilterConditionProperty = DataSetStringComparisonFilterConditionProperty.builder()
     *         .operator("operator")
     *         // the properties below are optional
     *         .value(DataSetStringFilterValueProperty.builder()
     *                 .staticValue("staticValue")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringcomparisonfiltercondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringcomparisonfiltercondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetStringComparisonFilterConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetStringComparisonFilterConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetStringComparisonFilterConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The comparison operator to use, such as <code>EQUALS</code> , <code>CONTAINS</code> , <code>STARTS_WITH</code> , <code>ENDS_WITH</code> , or their negations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringcomparisonfiltercondition.html#cfn-quicksight-dataset-datasetstringcomparisonfiltercondition-operator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringcomparisonfiltercondition.html#cfn-quicksight-dataset-datasetstringcomparisonfiltercondition-operator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOperator();

        /**
         * The string value to compare against.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetStringFilterValueProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringcomparisonfiltercondition.html#cfn-quicksight-dataset-datasetstringcomparisonfiltercondition-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringcomparisonfiltercondition.html#cfn-quicksight-dataset-datasetstringcomparisonfiltercondition-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSetStringComparisonFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetStringComparisonFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetStringComparisonFilterConditionProperty> {
            java.lang.String operator;
            java.lang.Object value;

            /**
             * Sets the value of {@link DataSetStringComparisonFilterConditionProperty#getOperator}
             * @param operator The comparison operator to use, such as <code>EQUALS</code> , <code>CONTAINS</code> , <code>STARTS_WITH</code> , <code>ENDS_WITH</code> , or their negations. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operator(java.lang.String operator) {
                this.operator = operator;
                return this;
            }

            /**
             * Sets the value of {@link DataSetStringComparisonFilterConditionProperty#getValue}
             * @param value The string value to compare against.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.IResolvable value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link DataSetStringComparisonFilterConditionProperty#getValue}
             * @param value The string value to compare against.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetStringFilterValueProperty value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetStringComparisonFilterConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetStringComparisonFilterConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetStringComparisonFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetStringComparisonFilterConditionProperty {
            private final java.lang.String operator;
            private final java.lang.Object value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.operator = software.amazon.jsii.Kernel.get(this, "operator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.operator = java.util.Objects.requireNonNull(builder.operator, "operator is required");
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getOperator() {
                return this.operator;
            }

            @Override
            public final java.lang.Object getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("operator", om.valueToTree(this.getOperator()));
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetStringComparisonFilterConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetStringComparisonFilterConditionProperty.Jsii$Proxy that = (DataSetStringComparisonFilterConditionProperty.Jsii$Proxy) o;

                if (!operator.equals(that.operator)) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.operator.hashCode();
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A filter condition for string columns, supporting both comparison and list-based filtering.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetStringFilterConditionProperty dataSetStringFilterConditionProperty = DataSetStringFilterConditionProperty.builder()
     *         .columnName("columnName")
     *         .comparisonFilterCondition(DataSetStringComparisonFilterConditionProperty.builder()
     *                 .operator("operator")
     *                 // the properties below are optional
     *                 .value(DataSetStringFilterValueProperty.builder()
     *                         .staticValue("staticValue")
     *                         .build())
     *                 .build())
     *         .listFilterCondition(DataSetStringListFilterConditionProperty.builder()
     *                 .operator("operator")
     *                 // the properties below are optional
     *                 .values(DataSetStringListFilterValueProperty.builder()
     *                         .staticValues(List.of("staticValues"))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringfiltercondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringfiltercondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetStringFilterConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetStringFilterConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetStringFilterConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the string column to filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringfiltercondition.html#cfn-quicksight-dataset-datasetstringfiltercondition-columnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringfiltercondition.html#cfn-quicksight-dataset-datasetstringfiltercondition-columnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getColumnName() {
            return null;
        }

        /**
         * A comparison-based filter condition for the string column.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetStringComparisonFilterConditionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringfiltercondition.html#cfn-quicksight-dataset-datasetstringfiltercondition-comparisonfiltercondition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringfiltercondition.html#cfn-quicksight-dataset-datasetstringfiltercondition-comparisonfiltercondition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComparisonFilterCondition() {
            return null;
        }

        /**
         * A list-based filter condition that includes or excludes values from a specified list.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetStringListFilterConditionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringfiltercondition.html#cfn-quicksight-dataset-datasetstringfiltercondition-listfiltercondition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringfiltercondition.html#cfn-quicksight-dataset-datasetstringfiltercondition-listfiltercondition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getListFilterCondition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSetStringFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetStringFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetStringFilterConditionProperty> {
            java.lang.String columnName;
            java.lang.Object comparisonFilterCondition;
            java.lang.Object listFilterCondition;

            /**
             * Sets the value of {@link DataSetStringFilterConditionProperty#getColumnName}
             * @param columnName The name of the string column to filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link DataSetStringFilterConditionProperty#getComparisonFilterCondition}
             * @param comparisonFilterCondition A comparison-based filter condition for the string column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparisonFilterCondition(software.amazon.awscdk.IResolvable comparisonFilterCondition) {
                this.comparisonFilterCondition = comparisonFilterCondition;
                return this;
            }

            /**
             * Sets the value of {@link DataSetStringFilterConditionProperty#getComparisonFilterCondition}
             * @param comparisonFilterCondition A comparison-based filter condition for the string column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparisonFilterCondition(software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetStringComparisonFilterConditionProperty comparisonFilterCondition) {
                this.comparisonFilterCondition = comparisonFilterCondition;
                return this;
            }

            /**
             * Sets the value of {@link DataSetStringFilterConditionProperty#getListFilterCondition}
             * @param listFilterCondition A list-based filter condition that includes or excludes values from a specified list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder listFilterCondition(software.amazon.awscdk.IResolvable listFilterCondition) {
                this.listFilterCondition = listFilterCondition;
                return this;
            }

            /**
             * Sets the value of {@link DataSetStringFilterConditionProperty#getListFilterCondition}
             * @param listFilterCondition A list-based filter condition that includes or excludes values from a specified list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder listFilterCondition(software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetStringListFilterConditionProperty listFilterCondition) {
                this.listFilterCondition = listFilterCondition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetStringFilterConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetStringFilterConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetStringFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetStringFilterConditionProperty {
            private final java.lang.String columnName;
            private final java.lang.Object comparisonFilterCondition;
            private final java.lang.Object listFilterCondition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.comparisonFilterCondition = software.amazon.jsii.Kernel.get(this, "comparisonFilterCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.listFilterCondition = software.amazon.jsii.Kernel.get(this, "listFilterCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnName = builder.columnName;
                this.comparisonFilterCondition = builder.comparisonFilterCondition;
                this.listFilterCondition = builder.listFilterCondition;
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.lang.Object getComparisonFilterCondition() {
                return this.comparisonFilterCondition;
            }

            @Override
            public final java.lang.Object getListFilterCondition() {
                return this.listFilterCondition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumnName() != null) {
                    data.set("columnName", om.valueToTree(this.getColumnName()));
                }
                if (this.getComparisonFilterCondition() != null) {
                    data.set("comparisonFilterCondition", om.valueToTree(this.getComparisonFilterCondition()));
                }
                if (this.getListFilterCondition() != null) {
                    data.set("listFilterCondition", om.valueToTree(this.getListFilterCondition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetStringFilterConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetStringFilterConditionProperty.Jsii$Proxy that = (DataSetStringFilterConditionProperty.Jsii$Proxy) o;

                if (this.columnName != null ? !this.columnName.equals(that.columnName) : that.columnName != null) return false;
                if (this.comparisonFilterCondition != null ? !this.comparisonFilterCondition.equals(that.comparisonFilterCondition) : that.comparisonFilterCondition != null) return false;
                return this.listFilterCondition != null ? this.listFilterCondition.equals(that.listFilterCondition) : that.listFilterCondition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnName != null ? this.columnName.hashCode() : 0;
                result = 31 * result + (this.comparisonFilterCondition != null ? this.comparisonFilterCondition.hashCode() : 0);
                result = 31 * result + (this.listFilterCondition != null ? this.listFilterCondition.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a string value used in filter conditions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetStringFilterValueProperty dataSetStringFilterValueProperty = DataSetStringFilterValueProperty.builder()
     *         .staticValue("staticValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringfiltervalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringfiltervalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetStringFilterValueProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetStringFilterValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetStringFilterValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A static string value used for filtering.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringfiltervalue.html#cfn-quicksight-dataset-datasetstringfiltervalue-staticvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringfiltervalue.html#cfn-quicksight-dataset-datasetstringfiltervalue-staticvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStaticValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSetStringFilterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetStringFilterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetStringFilterValueProperty> {
            java.lang.String staticValue;

            /**
             * Sets the value of {@link DataSetStringFilterValueProperty#getStaticValue}
             * @param staticValue A static string value used for filtering.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder staticValue(java.lang.String staticValue) {
                this.staticValue = staticValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetStringFilterValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetStringFilterValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetStringFilterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetStringFilterValueProperty {
            private final java.lang.String staticValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.staticValue = software.amazon.jsii.Kernel.get(this, "staticValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.staticValue = builder.staticValue;
            }

            @Override
            public final java.lang.String getStaticValue() {
                return this.staticValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getStaticValue() != null) {
                    data.set("staticValue", om.valueToTree(this.getStaticValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetStringFilterValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetStringFilterValueProperty.Jsii$Proxy that = (DataSetStringFilterValueProperty.Jsii$Proxy) o;

                return this.staticValue != null ? this.staticValue.equals(that.staticValue) : that.staticValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.staticValue != null ? this.staticValue.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A filter condition that includes or excludes string values from a specified list.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetStringListFilterConditionProperty dataSetStringListFilterConditionProperty = DataSetStringListFilterConditionProperty.builder()
     *         .operator("operator")
     *         // the properties below are optional
     *         .values(DataSetStringListFilterValueProperty.builder()
     *                 .staticValues(List.of("staticValues"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringlistfiltercondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringlistfiltercondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetStringListFilterConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetStringListFilterConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetStringListFilterConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list operator to use, either <code>INCLUDE</code> to match values in the list or <code>EXCLUDE</code> to filter out values in the list.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringlistfiltercondition.html#cfn-quicksight-dataset-datasetstringlistfiltercondition-operator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringlistfiltercondition.html#cfn-quicksight-dataset-datasetstringlistfiltercondition-operator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOperator();

        /**
         * The list of string values to include or exclude in the filter.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetStringListFilterValueProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringlistfiltercondition.html#cfn-quicksight-dataset-datasetstringlistfiltercondition-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringlistfiltercondition.html#cfn-quicksight-dataset-datasetstringlistfiltercondition-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSetStringListFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetStringListFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetStringListFilterConditionProperty> {
            java.lang.String operator;
            java.lang.Object values;

            /**
             * Sets the value of {@link DataSetStringListFilterConditionProperty#getOperator}
             * @param operator The list operator to use, either <code>INCLUDE</code> to match values in the list or <code>EXCLUDE</code> to filter out values in the list. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operator(java.lang.String operator) {
                this.operator = operator;
                return this;
            }

            /**
             * Sets the value of {@link DataSetStringListFilterConditionProperty#getValues}
             * @param values The list of string values to include or exclude in the filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(software.amazon.awscdk.IResolvable values) {
                this.values = values;
                return this;
            }

            /**
             * Sets the value of {@link DataSetStringListFilterConditionProperty#getValues}
             * @param values The list of string values to include or exclude in the filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetStringListFilterValueProperty values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetStringListFilterConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetStringListFilterConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetStringListFilterConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetStringListFilterConditionProperty {
            private final java.lang.String operator;
            private final java.lang.Object values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.operator = software.amazon.jsii.Kernel.get(this, "operator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.operator = java.util.Objects.requireNonNull(builder.operator, "operator is required");
                this.values = builder.values;
            }

            @Override
            public final java.lang.String getOperator() {
                return this.operator;
            }

            @Override
            public final java.lang.Object getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("operator", om.valueToTree(this.getOperator()));
                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetStringListFilterConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetStringListFilterConditionProperty.Jsii$Proxy that = (DataSetStringListFilterConditionProperty.Jsii$Proxy) o;

                if (!operator.equals(that.operator)) return false;
                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.operator.hashCode();
                result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a list of string values used in filter conditions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetStringListFilterValueProperty dataSetStringListFilterValueProperty = DataSetStringListFilterValueProperty.builder()
     *         .staticValues(List.of("staticValues"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringlistfiltervalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringlistfiltervalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetStringListFilterValueProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetStringListFilterValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetStringListFilterValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of static string values used for filtering.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringlistfiltervalue.html#cfn-quicksight-dataset-datasetstringlistfiltervalue-staticvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetstringlistfiltervalue.html#cfn-quicksight-dataset-datasetstringlistfiltervalue-staticvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStaticValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSetStringListFilterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetStringListFilterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetStringListFilterValueProperty> {
            java.util.List<java.lang.String> staticValues;

            /**
             * Sets the value of {@link DataSetStringListFilterValueProperty#getStaticValues}
             * @param staticValues A list of static string values used for filtering.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder staticValues(java.util.List<java.lang.String> staticValues) {
                this.staticValues = staticValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetStringListFilterValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetStringListFilterValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetStringListFilterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetStringListFilterValueProperty {
            private final java.util.List<java.lang.String> staticValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.staticValues = software.amazon.jsii.Kernel.get(this, "staticValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.staticValues = builder.staticValues;
            }

            @Override
            public final java.util.List<java.lang.String> getStaticValues() {
                return this.staticValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getStaticValues() != null) {
                    data.set("staticValues", om.valueToTree(this.getStaticValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetStringListFilterValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetStringListFilterValueProperty.Jsii$Proxy that = (DataSetStringListFilterValueProperty.Jsii$Proxy) o;

                return this.staticValues != null ? this.staticValues.equals(that.staticValues) : that.staticValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.staticValues != null ? this.staticValues.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The usage configuration to apply to child datasets that reference this dataset as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetUsageConfigurationProperty dataSetUsageConfigurationProperty = DataSetUsageConfigurationProperty.builder()
     *         .disableUseAsDirectQuerySource(false)
     *         .disableUseAsImportedSource(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetusageconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetusageconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetUsageConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetUsageConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetUsageConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An option that controls whether a child dataset of a direct query can use this dataset as a source.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetusageconfiguration.html#cfn-quicksight-dataset-datasetusageconfiguration-disableuseasdirectquerysource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetusageconfiguration.html#cfn-quicksight-dataset-datasetusageconfiguration-disableuseasdirectquerysource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableUseAsDirectQuerySource() {
            return null;
        }

        /**
         * An option that controls whether a child dataset that's stored in Quick Sight can use this dataset as a source.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetusageconfiguration.html#cfn-quicksight-dataset-datasetusageconfiguration-disableuseasimportedsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetusageconfiguration.html#cfn-quicksight-dataset-datasetusageconfiguration-disableuseasimportedsource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableUseAsImportedSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSetUsageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetUsageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetUsageConfigurationProperty> {
            java.lang.Object disableUseAsDirectQuerySource;
            java.lang.Object disableUseAsImportedSource;

            /**
             * Sets the value of {@link DataSetUsageConfigurationProperty#getDisableUseAsDirectQuerySource}
             * @param disableUseAsDirectQuerySource An option that controls whether a child dataset of a direct query can use this dataset as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableUseAsDirectQuerySource(java.lang.Boolean disableUseAsDirectQuerySource) {
                this.disableUseAsDirectQuerySource = disableUseAsDirectQuerySource;
                return this;
            }

            /**
             * Sets the value of {@link DataSetUsageConfigurationProperty#getDisableUseAsDirectQuerySource}
             * @param disableUseAsDirectQuerySource An option that controls whether a child dataset of a direct query can use this dataset as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableUseAsDirectQuerySource(software.amazon.awscdk.IResolvable disableUseAsDirectQuerySource) {
                this.disableUseAsDirectQuerySource = disableUseAsDirectQuerySource;
                return this;
            }

            /**
             * Sets the value of {@link DataSetUsageConfigurationProperty#getDisableUseAsImportedSource}
             * @param disableUseAsImportedSource An option that controls whether a child dataset that's stored in Quick Sight can use this dataset as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableUseAsImportedSource(java.lang.Boolean disableUseAsImportedSource) {
                this.disableUseAsImportedSource = disableUseAsImportedSource;
                return this;
            }

            /**
             * Sets the value of {@link DataSetUsageConfigurationProperty#getDisableUseAsImportedSource}
             * @param disableUseAsImportedSource An option that controls whether a child dataset that's stored in Quick Sight can use this dataset as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableUseAsImportedSource(software.amazon.awscdk.IResolvable disableUseAsImportedSource) {
                this.disableUseAsImportedSource = disableUseAsImportedSource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetUsageConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetUsageConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetUsageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetUsageConfigurationProperty {
            private final java.lang.Object disableUseAsDirectQuerySource;
            private final java.lang.Object disableUseAsImportedSource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.disableUseAsDirectQuerySource = software.amazon.jsii.Kernel.get(this, "disableUseAsDirectQuerySource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.disableUseAsImportedSource = software.amazon.jsii.Kernel.get(this, "disableUseAsImportedSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.disableUseAsDirectQuerySource = builder.disableUseAsDirectQuerySource;
                this.disableUseAsImportedSource = builder.disableUseAsImportedSource;
            }

            @Override
            public final java.lang.Object getDisableUseAsDirectQuerySource() {
                return this.disableUseAsDirectQuerySource;
            }

            @Override
            public final java.lang.Object getDisableUseAsImportedSource() {
                return this.disableUseAsImportedSource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDisableUseAsDirectQuerySource() != null) {
                    data.set("disableUseAsDirectQuerySource", om.valueToTree(this.getDisableUseAsDirectQuerySource()));
                }
                if (this.getDisableUseAsImportedSource() != null) {
                    data.set("disableUseAsImportedSource", om.valueToTree(this.getDisableUseAsImportedSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetUsageConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetUsageConfigurationProperty.Jsii$Proxy that = (DataSetUsageConfigurationProperty.Jsii$Proxy) o;

                if (this.disableUseAsDirectQuerySource != null ? !this.disableUseAsDirectQuerySource.equals(that.disableUseAsDirectQuerySource) : that.disableUseAsDirectQuerySource != null) return false;
                return this.disableUseAsImportedSource != null ? this.disableUseAsImportedSource.equals(that.disableUseAsImportedSource) : that.disableUseAsImportedSource == null;
            }

            @Override
            public final int hashCode() {
                int result = this.disableUseAsDirectQuerySource != null ? this.disableUseAsDirectQuerySource.hashCode() : 0;
                result = 31 * result + (this.disableUseAsImportedSource != null ? this.disableUseAsImportedSource.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameter declarations of the dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DatasetParameterProperty datasetParameterProperty = DatasetParameterProperty.builder()
     *         .dateTimeDatasetParameter(DateTimeDatasetParameterProperty.builder()
     *                 .id("id")
     *                 .name("name")
     *                 .valueType("valueType")
     *                 // the properties below are optional
     *                 .defaultValues(DateTimeDatasetParameterDefaultValuesProperty.builder()
     *                         .staticValues(List.of("staticValues"))
     *                         .build())
     *                 .timeGranularity("timeGranularity")
     *                 .build())
     *         .decimalDatasetParameter(DecimalDatasetParameterProperty.builder()
     *                 .id("id")
     *                 .name("name")
     *                 .valueType("valueType")
     *                 // the properties below are optional
     *                 .defaultValues(DecimalDatasetParameterDefaultValuesProperty.builder()
     *                         .staticValues(List.of(123))
     *                         .build())
     *                 .build())
     *         .integerDatasetParameter(IntegerDatasetParameterProperty.builder()
     *                 .id("id")
     *                 .name("name")
     *                 .valueType("valueType")
     *                 // the properties below are optional
     *                 .defaultValues(IntegerDatasetParameterDefaultValuesProperty.builder()
     *                         .staticValues(List.of(123))
     *                         .build())
     *                 .build())
     *         .stringDatasetParameter(StringDatasetParameterProperty.builder()
     *                 .id("id")
     *                 .name("name")
     *                 .valueType("valueType")
     *                 // the properties below are optional
     *                 .defaultValues(StringDatasetParameterDefaultValuesProperty.builder()
     *                         .staticValues(List.of("staticValues"))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetparameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetparameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DatasetParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(DatasetParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatasetParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A date time parameter that is created in the dataset.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DateTimeDatasetParameterProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetparameter.html#cfn-quicksight-dataset-datasetparameter-datetimedatasetparameter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetparameter.html#cfn-quicksight-dataset-datasetparameter-datetimedatasetparameter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDateTimeDatasetParameter() {
            return null;
        }

        /**
         * A decimal parameter that is created in the dataset.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DecimalDatasetParameterProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetparameter.html#cfn-quicksight-dataset-datasetparameter-decimaldatasetparameter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetparameter.html#cfn-quicksight-dataset-datasetparameter-decimaldatasetparameter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDecimalDatasetParameter() {
            return null;
        }

        /**
         * An integer parameter that is created in the dataset.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.IntegerDatasetParameterProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetparameter.html#cfn-quicksight-dataset-datasetparameter-integerdatasetparameter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetparameter.html#cfn-quicksight-dataset-datasetparameter-integerdatasetparameter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIntegerDatasetParameter() {
            return null;
        }

        /**
         * A string parameter that is created in the dataset.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.StringDatasetParameterProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetparameter.html#cfn-quicksight-dataset-datasetparameter-stringdatasetparameter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetparameter.html#cfn-quicksight-dataset-datasetparameter-stringdatasetparameter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStringDatasetParameter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatasetParameterProperty> {
            java.lang.Object dateTimeDatasetParameter;
            java.lang.Object decimalDatasetParameter;
            java.lang.Object integerDatasetParameter;
            java.lang.Object stringDatasetParameter;

            /**
             * Sets the value of {@link DatasetParameterProperty#getDateTimeDatasetParameter}
             * @param dateTimeDatasetParameter A date time parameter that is created in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateTimeDatasetParameter(software.amazon.awscdk.IResolvable dateTimeDatasetParameter) {
                this.dateTimeDatasetParameter = dateTimeDatasetParameter;
                return this;
            }

            /**
             * Sets the value of {@link DatasetParameterProperty#getDateTimeDatasetParameter}
             * @param dateTimeDatasetParameter A date time parameter that is created in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateTimeDatasetParameter(software.amazon.awscdk.services.quicksight.CfnDataSet.DateTimeDatasetParameterProperty dateTimeDatasetParameter) {
                this.dateTimeDatasetParameter = dateTimeDatasetParameter;
                return this;
            }

            /**
             * Sets the value of {@link DatasetParameterProperty#getDecimalDatasetParameter}
             * @param decimalDatasetParameter A decimal parameter that is created in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decimalDatasetParameter(software.amazon.awscdk.IResolvable decimalDatasetParameter) {
                this.decimalDatasetParameter = decimalDatasetParameter;
                return this;
            }

            /**
             * Sets the value of {@link DatasetParameterProperty#getDecimalDatasetParameter}
             * @param decimalDatasetParameter A decimal parameter that is created in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decimalDatasetParameter(software.amazon.awscdk.services.quicksight.CfnDataSet.DecimalDatasetParameterProperty decimalDatasetParameter) {
                this.decimalDatasetParameter = decimalDatasetParameter;
                return this;
            }

            /**
             * Sets the value of {@link DatasetParameterProperty#getIntegerDatasetParameter}
             * @param integerDatasetParameter An integer parameter that is created in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integerDatasetParameter(software.amazon.awscdk.IResolvable integerDatasetParameter) {
                this.integerDatasetParameter = integerDatasetParameter;
                return this;
            }

            /**
             * Sets the value of {@link DatasetParameterProperty#getIntegerDatasetParameter}
             * @param integerDatasetParameter An integer parameter that is created in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integerDatasetParameter(software.amazon.awscdk.services.quicksight.CfnDataSet.IntegerDatasetParameterProperty integerDatasetParameter) {
                this.integerDatasetParameter = integerDatasetParameter;
                return this;
            }

            /**
             * Sets the value of {@link DatasetParameterProperty#getStringDatasetParameter}
             * @param stringDatasetParameter A string parameter that is created in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringDatasetParameter(software.amazon.awscdk.IResolvable stringDatasetParameter) {
                this.stringDatasetParameter = stringDatasetParameter;
                return this;
            }

            /**
             * Sets the value of {@link DatasetParameterProperty#getStringDatasetParameter}
             * @param stringDatasetParameter A string parameter that is created in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringDatasetParameter(software.amazon.awscdk.services.quicksight.CfnDataSet.StringDatasetParameterProperty stringDatasetParameter) {
                this.stringDatasetParameter = stringDatasetParameter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatasetParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatasetParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatasetParameterProperty {
            private final java.lang.Object dateTimeDatasetParameter;
            private final java.lang.Object decimalDatasetParameter;
            private final java.lang.Object integerDatasetParameter;
            private final java.lang.Object stringDatasetParameter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dateTimeDatasetParameter = software.amazon.jsii.Kernel.get(this, "dateTimeDatasetParameter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.decimalDatasetParameter = software.amazon.jsii.Kernel.get(this, "decimalDatasetParameter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.integerDatasetParameter = software.amazon.jsii.Kernel.get(this, "integerDatasetParameter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stringDatasetParameter = software.amazon.jsii.Kernel.get(this, "stringDatasetParameter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dateTimeDatasetParameter = builder.dateTimeDatasetParameter;
                this.decimalDatasetParameter = builder.decimalDatasetParameter;
                this.integerDatasetParameter = builder.integerDatasetParameter;
                this.stringDatasetParameter = builder.stringDatasetParameter;
            }

            @Override
            public final java.lang.Object getDateTimeDatasetParameter() {
                return this.dateTimeDatasetParameter;
            }

            @Override
            public final java.lang.Object getDecimalDatasetParameter() {
                return this.decimalDatasetParameter;
            }

            @Override
            public final java.lang.Object getIntegerDatasetParameter() {
                return this.integerDatasetParameter;
            }

            @Override
            public final java.lang.Object getStringDatasetParameter() {
                return this.stringDatasetParameter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDateTimeDatasetParameter() != null) {
                    data.set("dateTimeDatasetParameter", om.valueToTree(this.getDateTimeDatasetParameter()));
                }
                if (this.getDecimalDatasetParameter() != null) {
                    data.set("decimalDatasetParameter", om.valueToTree(this.getDecimalDatasetParameter()));
                }
                if (this.getIntegerDatasetParameter() != null) {
                    data.set("integerDatasetParameter", om.valueToTree(this.getIntegerDatasetParameter()));
                }
                if (this.getStringDatasetParameter() != null) {
                    data.set("stringDatasetParameter", om.valueToTree(this.getStringDatasetParameter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DatasetParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatasetParameterProperty.Jsii$Proxy that = (DatasetParameterProperty.Jsii$Proxy) o;

                if (this.dateTimeDatasetParameter != null ? !this.dateTimeDatasetParameter.equals(that.dateTimeDatasetParameter) : that.dateTimeDatasetParameter != null) return false;
                if (this.decimalDatasetParameter != null ? !this.decimalDatasetParameter.equals(that.decimalDatasetParameter) : that.decimalDatasetParameter != null) return false;
                if (this.integerDatasetParameter != null ? !this.integerDatasetParameter.equals(that.integerDatasetParameter) : that.integerDatasetParameter != null) return false;
                return this.stringDatasetParameter != null ? this.stringDatasetParameter.equals(that.stringDatasetParameter) : that.stringDatasetParameter == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dateTimeDatasetParameter != null ? this.dateTimeDatasetParameter.hashCode() : 0;
                result = 31 * result + (this.decimalDatasetParameter != null ? this.decimalDatasetParameter.hashCode() : 0);
                result = 31 * result + (this.integerDatasetParameter != null ? this.integerDatasetParameter.hashCode() : 0);
                result = 31 * result + (this.stringDatasetParameter != null ? this.stringDatasetParameter.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <p>The default values of a date time parameter.</p>.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DateTimeDatasetParameterDefaultValuesProperty dateTimeDatasetParameterDefaultValuesProperty = DateTimeDatasetParameterDefaultValuesProperty.builder()
     *         .staticValues(List.of("staticValues"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameterdefaultvalues.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameterdefaultvalues.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DateTimeDatasetParameterDefaultValuesProperty")
    @software.amazon.jsii.Jsii.Proxy(DateTimeDatasetParameterDefaultValuesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DateTimeDatasetParameterDefaultValuesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of static default values for a given date time parameter.
         * <p>
         * The valid format for this property is <code>yyyy-MM-dd’T’HH:mm:ss’Z’</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameterdefaultvalues.html#cfn-quicksight-dataset-datetimedatasetparameterdefaultvalues-staticvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameterdefaultvalues.html#cfn-quicksight-dataset-datetimedatasetparameterdefaultvalues-staticvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStaticValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DateTimeDatasetParameterDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DateTimeDatasetParameterDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DateTimeDatasetParameterDefaultValuesProperty> {
            java.util.List<java.lang.String> staticValues;

            /**
             * Sets the value of {@link DateTimeDatasetParameterDefaultValuesProperty#getStaticValues}
             * @param staticValues A list of static default values for a given date time parameter.
             *                     The valid format for this property is <code>yyyy-MM-dd’T’HH:mm:ss’Z’</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder staticValues(java.util.List<java.lang.String> staticValues) {
                this.staticValues = staticValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DateTimeDatasetParameterDefaultValuesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DateTimeDatasetParameterDefaultValuesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DateTimeDatasetParameterDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DateTimeDatasetParameterDefaultValuesProperty {
            private final java.util.List<java.lang.String> staticValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.staticValues = software.amazon.jsii.Kernel.get(this, "staticValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.staticValues = builder.staticValues;
            }

            @Override
            public final java.util.List<java.lang.String> getStaticValues() {
                return this.staticValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getStaticValues() != null) {
                    data.set("staticValues", om.valueToTree(this.getStaticValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DateTimeDatasetParameterDefaultValuesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DateTimeDatasetParameterDefaultValuesProperty.Jsii$Proxy that = (DateTimeDatasetParameterDefaultValuesProperty.Jsii$Proxy) o;

                return this.staticValues != null ? this.staticValues.equals(that.staticValues) : that.staticValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.staticValues != null ? this.staticValues.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A date time parameter that is created in the dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DateTimeDatasetParameterProperty dateTimeDatasetParameterProperty = DateTimeDatasetParameterProperty.builder()
     *         .id("id")
     *         .name("name")
     *         .valueType("valueType")
     *         // the properties below are optional
     *         .defaultValues(DateTimeDatasetParameterDefaultValuesProperty.builder()
     *                 .staticValues(List.of("staticValues"))
     *                 .build())
     *         .timeGranularity("timeGranularity")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DateTimeDatasetParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(DateTimeDatasetParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DateTimeDatasetParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An identifier for the parameter that is created in the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html#cfn-quicksight-dataset-datetimedatasetparameter-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html#cfn-quicksight-dataset-datetimedatasetparameter-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * The name of the date time parameter that is created in the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html#cfn-quicksight-dataset-datetimedatasetparameter-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html#cfn-quicksight-dataset-datetimedatasetparameter-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The value type of the dataset parameter.
         * <p>
         * Valid values are <code>single value</code> or <code>multi value</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html#cfn-quicksight-dataset-datetimedatasetparameter-valuetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html#cfn-quicksight-dataset-datetimedatasetparameter-valuetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValueType();

        /**
         * A list of default values for a given date time parameter.
         * <p>
         * This structure only accepts static values.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DateTimeDatasetParameterDefaultValuesProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html#cfn-quicksight-dataset-datetimedatasetparameter-defaultvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html#cfn-quicksight-dataset-datetimedatasetparameter-defaultvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultValues() {
            return null;
        }

        /**
         * The time granularity of the date time parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html#cfn-quicksight-dataset-datetimedatasetparameter-timegranularity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html#cfn-quicksight-dataset-datetimedatasetparameter-timegranularity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimeGranularity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DateTimeDatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DateTimeDatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DateTimeDatasetParameterProperty> {
            java.lang.String id;
            java.lang.String name;
            java.lang.String valueType;
            java.lang.Object defaultValues;
            java.lang.String timeGranularity;

            /**
             * Sets the value of {@link DateTimeDatasetParameterProperty#getId}
             * @param id An identifier for the parameter that is created in the dataset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link DateTimeDatasetParameterProperty#getName}
             * @param name The name of the date time parameter that is created in the dataset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link DateTimeDatasetParameterProperty#getValueType}
             * @param valueType The value type of the dataset parameter. This parameter is required.
             *                  Valid values are <code>single value</code> or <code>multi value</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueType(java.lang.String valueType) {
                this.valueType = valueType;
                return this;
            }

            /**
             * Sets the value of {@link DateTimeDatasetParameterProperty#getDefaultValues}
             * @param defaultValues A list of default values for a given date time parameter.
             *                      This structure only accepts static values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValues(software.amazon.awscdk.IResolvable defaultValues) {
                this.defaultValues = defaultValues;
                return this;
            }

            /**
             * Sets the value of {@link DateTimeDatasetParameterProperty#getDefaultValues}
             * @param defaultValues A list of default values for a given date time parameter.
             *                      This structure only accepts static values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValues(software.amazon.awscdk.services.quicksight.CfnDataSet.DateTimeDatasetParameterDefaultValuesProperty defaultValues) {
                this.defaultValues = defaultValues;
                return this;
            }

            /**
             * Sets the value of {@link DateTimeDatasetParameterProperty#getTimeGranularity}
             * @param timeGranularity The time granularity of the date time parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeGranularity(java.lang.String timeGranularity) {
                this.timeGranularity = timeGranularity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DateTimeDatasetParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DateTimeDatasetParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DateTimeDatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DateTimeDatasetParameterProperty {
            private final java.lang.String id;
            private final java.lang.String name;
            private final java.lang.String valueType;
            private final java.lang.Object defaultValues;
            private final java.lang.String timeGranularity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valueType = software.amazon.jsii.Kernel.get(this, "valueType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultValues = software.amazon.jsii.Kernel.get(this, "defaultValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeGranularity = software.amazon.jsii.Kernel.get(this, "timeGranularity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.valueType = java.util.Objects.requireNonNull(builder.valueType, "valueType is required");
                this.defaultValues = builder.defaultValues;
                this.timeGranularity = builder.timeGranularity;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValueType() {
                return this.valueType;
            }

            @Override
            public final java.lang.Object getDefaultValues() {
                return this.defaultValues;
            }

            @Override
            public final java.lang.String getTimeGranularity() {
                return this.timeGranularity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("valueType", om.valueToTree(this.getValueType()));
                if (this.getDefaultValues() != null) {
                    data.set("defaultValues", om.valueToTree(this.getDefaultValues()));
                }
                if (this.getTimeGranularity() != null) {
                    data.set("timeGranularity", om.valueToTree(this.getTimeGranularity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DateTimeDatasetParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DateTimeDatasetParameterProperty.Jsii$Proxy that = (DateTimeDatasetParameterProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                if (!name.equals(that.name)) return false;
                if (!valueType.equals(that.valueType)) return false;
                if (this.defaultValues != null ? !this.defaultValues.equals(that.defaultValues) : that.defaultValues != null) return false;
                return this.timeGranularity != null ? this.timeGranularity.equals(that.timeGranularity) : that.timeGranularity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.valueType.hashCode());
                result = 31 * result + (this.defaultValues != null ? this.defaultValues.hashCode() : 0);
                result = 31 * result + (this.timeGranularity != null ? this.timeGranularity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A list of default values for a given decimal parameter.
     * <p>
     * This structure only accepts static values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DecimalDatasetParameterDefaultValuesProperty decimalDatasetParameterDefaultValuesProperty = DecimalDatasetParameterDefaultValuesProperty.builder()
     *         .staticValues(List.of(123))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameterdefaultvalues.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameterdefaultvalues.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DecimalDatasetParameterDefaultValuesProperty")
    @software.amazon.jsii.Jsii.Proxy(DecimalDatasetParameterDefaultValuesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DecimalDatasetParameterDefaultValuesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of static default values for a given decimal parameter.
         * <p>
         * Returns union: either List<{@link java.lang.Number}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameterdefaultvalues.html#cfn-quicksight-dataset-decimaldatasetparameterdefaultvalues-staticvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameterdefaultvalues.html#cfn-quicksight-dataset-decimaldatasetparameterdefaultvalues-staticvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStaticValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DecimalDatasetParameterDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DecimalDatasetParameterDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DecimalDatasetParameterDefaultValuesProperty> {
            java.lang.Object staticValues;

            /**
             * Sets the value of {@link DecimalDatasetParameterDefaultValuesProperty#getStaticValues}
             * @param staticValues A list of static default values for a given decimal parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder staticValues(java.util.List<? extends java.lang.Number> staticValues) {
                this.staticValues = staticValues;
                return this;
            }

            /**
             * Sets the value of {@link DecimalDatasetParameterDefaultValuesProperty#getStaticValues}
             * @param staticValues A list of static default values for a given decimal parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder staticValues(software.amazon.awscdk.IResolvable staticValues) {
                this.staticValues = staticValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DecimalDatasetParameterDefaultValuesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DecimalDatasetParameterDefaultValuesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DecimalDatasetParameterDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DecimalDatasetParameterDefaultValuesProperty {
            private final java.lang.Object staticValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.staticValues = software.amazon.jsii.Kernel.get(this, "staticValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.staticValues = builder.staticValues;
            }

            @Override
            public final java.lang.Object getStaticValues() {
                return this.staticValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getStaticValues() != null) {
                    data.set("staticValues", om.valueToTree(this.getStaticValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DecimalDatasetParameterDefaultValuesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DecimalDatasetParameterDefaultValuesProperty.Jsii$Proxy that = (DecimalDatasetParameterDefaultValuesProperty.Jsii$Proxy) o;

                return this.staticValues != null ? this.staticValues.equals(that.staticValues) : that.staticValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.staticValues != null ? this.staticValues.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A decimal parameter that is created in the dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DecimalDatasetParameterProperty decimalDatasetParameterProperty = DecimalDatasetParameterProperty.builder()
     *         .id("id")
     *         .name("name")
     *         .valueType("valueType")
     *         // the properties below are optional
     *         .defaultValues(DecimalDatasetParameterDefaultValuesProperty.builder()
     *                 .staticValues(List.of(123))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DecimalDatasetParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(DecimalDatasetParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DecimalDatasetParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An identifier for the decimal parameter created in the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameter.html#cfn-quicksight-dataset-decimaldatasetparameter-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameter.html#cfn-quicksight-dataset-decimaldatasetparameter-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * The name of the decimal parameter that is created in the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameter.html#cfn-quicksight-dataset-decimaldatasetparameter-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameter.html#cfn-quicksight-dataset-decimaldatasetparameter-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The value type of the dataset parameter.
         * <p>
         * Valid values are <code>single value</code> or <code>multi value</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameter.html#cfn-quicksight-dataset-decimaldatasetparameter-valuetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameter.html#cfn-quicksight-dataset-decimaldatasetparameter-valuetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValueType();

        /**
         * A list of default values for a given decimal parameter.
         * <p>
         * This structure only accepts static values.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DecimalDatasetParameterDefaultValuesProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameter.html#cfn-quicksight-dataset-decimaldatasetparameter-defaultvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameter.html#cfn-quicksight-dataset-decimaldatasetparameter-defaultvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DecimalDatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DecimalDatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DecimalDatasetParameterProperty> {
            java.lang.String id;
            java.lang.String name;
            java.lang.String valueType;
            java.lang.Object defaultValues;

            /**
             * Sets the value of {@link DecimalDatasetParameterProperty#getId}
             * @param id An identifier for the decimal parameter created in the dataset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link DecimalDatasetParameterProperty#getName}
             * @param name The name of the decimal parameter that is created in the dataset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link DecimalDatasetParameterProperty#getValueType}
             * @param valueType The value type of the dataset parameter. This parameter is required.
             *                  Valid values are <code>single value</code> or <code>multi value</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueType(java.lang.String valueType) {
                this.valueType = valueType;
                return this;
            }

            /**
             * Sets the value of {@link DecimalDatasetParameterProperty#getDefaultValues}
             * @param defaultValues A list of default values for a given decimal parameter.
             *                      This structure only accepts static values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValues(software.amazon.awscdk.IResolvable defaultValues) {
                this.defaultValues = defaultValues;
                return this;
            }

            /**
             * Sets the value of {@link DecimalDatasetParameterProperty#getDefaultValues}
             * @param defaultValues A list of default values for a given decimal parameter.
             *                      This structure only accepts static values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValues(software.amazon.awscdk.services.quicksight.CfnDataSet.DecimalDatasetParameterDefaultValuesProperty defaultValues) {
                this.defaultValues = defaultValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DecimalDatasetParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DecimalDatasetParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DecimalDatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DecimalDatasetParameterProperty {
            private final java.lang.String id;
            private final java.lang.String name;
            private final java.lang.String valueType;
            private final java.lang.Object defaultValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valueType = software.amazon.jsii.Kernel.get(this, "valueType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultValues = software.amazon.jsii.Kernel.get(this, "defaultValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.valueType = java.util.Objects.requireNonNull(builder.valueType, "valueType is required");
                this.defaultValues = builder.defaultValues;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValueType() {
                return this.valueType;
            }

            @Override
            public final java.lang.Object getDefaultValues() {
                return this.defaultValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("valueType", om.valueToTree(this.getValueType()));
                if (this.getDefaultValues() != null) {
                    data.set("defaultValues", om.valueToTree(this.getDefaultValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DecimalDatasetParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DecimalDatasetParameterProperty.Jsii$Proxy that = (DecimalDatasetParameterProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                if (!name.equals(that.name)) return false;
                if (!valueType.equals(that.valueType)) return false;
                return this.defaultValues != null ? this.defaultValues.equals(that.defaultValues) : that.defaultValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.valueType.hashCode());
                result = 31 * result + (this.defaultValues != null ? this.defaultValues.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines a destination table in data preparation that receives the final transformed data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DestinationTableProperty destinationTableProperty = DestinationTableProperty.builder()
     *         .alias("alias")
     *         .source(DestinationTableSourceProperty.builder()
     *                 .transformOperationId("transformOperationId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-destinationtable.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-destinationtable.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DestinationTableProperty")
    @software.amazon.jsii.Jsii.Proxy(DestinationTableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DestinationTableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Alias for the destination table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-destinationtable.html#cfn-quicksight-dataset-destinationtable-alias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-destinationtable.html#cfn-quicksight-dataset-destinationtable-alias</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlias();

        /**
         * The source configuration that specifies which transform operation provides data to this destination table.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DestinationTableSourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-destinationtable.html#cfn-quicksight-dataset-destinationtable-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-destinationtable.html#cfn-quicksight-dataset-destinationtable-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSource();

        /**
         * @return a {@link Builder} of {@link DestinationTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DestinationTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DestinationTableProperty> {
            java.lang.String alias;
            java.lang.Object source;

            /**
             * Sets the value of {@link DestinationTableProperty#getAlias}
             * @param alias Alias for the destination table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alias(java.lang.String alias) {
                this.alias = alias;
                return this;
            }

            /**
             * Sets the value of {@link DestinationTableProperty#getSource}
             * @param source The source configuration that specifies which transform operation provides data to this destination table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.IResolvable source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link DestinationTableProperty#getSource}
             * @param source The source configuration that specifies which transform operation provides data to this destination table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.services.quicksight.CfnDataSet.DestinationTableSourceProperty source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationTableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DestinationTableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DestinationTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationTableProperty {
            private final java.lang.String alias;
            private final java.lang.Object source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alias = java.util.Objects.requireNonNull(builder.alias, "alias is required");
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            }

            @Override
            public final java.lang.String getAlias() {
                return this.alias;
            }

            @Override
            public final java.lang.Object getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alias", om.valueToTree(this.getAlias()));
                data.set("source", om.valueToTree(this.getSource()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DestinationTableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationTableProperty.Jsii$Proxy that = (DestinationTableProperty.Jsii$Proxy) o;

                if (!alias.equals(that.alias)) return false;
                return this.source.equals(that.source);
            }

            @Override
            public final int hashCode() {
                int result = this.alias.hashCode();
                result = 31 * result + (this.source.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the source of data for a destination table, including the transform operation and column mappings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DestinationTableSourceProperty destinationTableSourceProperty = DestinationTableSourceProperty.builder()
     *         .transformOperationId("transformOperationId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-destinationtablesource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-destinationtablesource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DestinationTableSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(DestinationTableSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DestinationTableSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the transform operation that provides data to the destination table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-destinationtablesource.html#cfn-quicksight-dataset-destinationtablesource-transformoperationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-destinationtablesource.html#cfn-quicksight-dataset-destinationtablesource-transformoperationid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTransformOperationId();

        /**
         * @return a {@link Builder} of {@link DestinationTableSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DestinationTableSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DestinationTableSourceProperty> {
            java.lang.String transformOperationId;

            /**
             * Sets the value of {@link DestinationTableSourceProperty#getTransformOperationId}
             * @param transformOperationId The identifier of the transform operation that provides data to the destination table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transformOperationId(java.lang.String transformOperationId) {
                this.transformOperationId = transformOperationId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationTableSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DestinationTableSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DestinationTableSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationTableSourceProperty {
            private final java.lang.String transformOperationId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.transformOperationId = software.amazon.jsii.Kernel.get(this, "transformOperationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.transformOperationId = java.util.Objects.requireNonNull(builder.transformOperationId, "transformOperationId is required");
            }

            @Override
            public final java.lang.String getTransformOperationId() {
                return this.transformOperationId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("transformOperationId", om.valueToTree(this.getTransformOperationId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DestinationTableSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationTableSourceProperty.Jsii$Proxy that = (DestinationTableSourceProperty.Jsii$Proxy) o;

                return this.transformOperationId.equals(that.transformOperationId);
            }

            @Override
            public final int hashCode() {
                int result = this.transformOperationId.hashCode();
                return result;
            }
        }
    }
    /**
     * A FieldFolder element is a folder that contains fields and nested subfolders.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * FieldFolderProperty fieldFolderProperty = FieldFolderProperty.builder()
     *         .columns(List.of("columns"))
     *         .description("description")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-fieldfolder.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-fieldfolder.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.FieldFolderProperty")
    @software.amazon.jsii.Jsii.Proxy(FieldFolderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FieldFolderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A folder has a list of columns.
         * <p>
         * A column can only be in one folder.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-fieldfolder.html#cfn-quicksight-dataset-fieldfolder-columns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-fieldfolder.html#cfn-quicksight-dataset-fieldfolder-columns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getColumns() {
            return null;
        }

        /**
         * The description for a field folder.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-fieldfolder.html#cfn-quicksight-dataset-fieldfolder-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-fieldfolder.html#cfn-quicksight-dataset-fieldfolder-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FieldFolderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FieldFolderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FieldFolderProperty> {
            java.util.List<java.lang.String> columns;
            java.lang.String description;

            /**
             * Sets the value of {@link FieldFolderProperty#getColumns}
             * @param columns A folder has a list of columns.
             *                A column can only be in one folder.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(java.util.List<java.lang.String> columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link FieldFolderProperty#getDescription}
             * @param description The description for a field folder.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FieldFolderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FieldFolderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FieldFolderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FieldFolderProperty {
            private final java.util.List<java.lang.String> columns;
            private final java.lang.String description;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columns = software.amazon.jsii.Kernel.get(this, "columns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columns = builder.columns;
                this.description = builder.description;
            }

            @Override
            public final java.util.List<java.lang.String> getColumns() {
                return this.columns;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumns() != null) {
                    data.set("columns", om.valueToTree(this.getColumns()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.FieldFolderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FieldFolderProperty.Jsii$Proxy that = (FieldFolderProperty.Jsii$Proxy) o;

                if (this.columns != null ? !this.columns.equals(that.columns) : that.columns != null) return false;
                return this.description != null ? this.description.equals(that.description) : that.description == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columns != null ? this.columns.hashCode() : 0;
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A transform operation that filters rows based on a condition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * FilterOperationProperty filterOperationProperty = FilterOperationProperty.builder()
     *         .conditionExpression("conditionExpression")
     *         .dateFilterCondition(DataSetDateFilterConditionProperty.builder()
     *                 .columnName("columnName")
     *                 .comparisonFilterCondition(DataSetDateComparisonFilterConditionProperty.builder()
     *                         .operator("operator")
     *                         // the properties below are optional
     *                         .value(DataSetDateFilterValueProperty.builder()
     *                                 .staticValue("staticValue")
     *                                 .build())
     *                         .build())
     *                 .rangeFilterCondition(DataSetDateRangeFilterConditionProperty.builder()
     *                         .includeMaximum(false)
     *                         .includeMinimum(false)
     *                         .rangeMaximum(DataSetDateFilterValueProperty.builder()
     *                                 .staticValue("staticValue")
     *                                 .build())
     *                         .rangeMinimum(DataSetDateFilterValueProperty.builder()
     *                                 .staticValue("staticValue")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .numericFilterCondition(DataSetNumericFilterConditionProperty.builder()
     *                 .columnName("columnName")
     *                 .comparisonFilterCondition(DataSetNumericComparisonFilterConditionProperty.builder()
     *                         .operator("operator")
     *                         // the properties below are optional
     *                         .value(DataSetNumericFilterValueProperty.builder()
     *                                 .staticValue(123)
     *                                 .build())
     *                         .build())
     *                 .rangeFilterCondition(DataSetNumericRangeFilterConditionProperty.builder()
     *                         .includeMaximum(false)
     *                         .includeMinimum(false)
     *                         .rangeMaximum(DataSetNumericFilterValueProperty.builder()
     *                                 .staticValue(123)
     *                                 .build())
     *                         .rangeMinimum(DataSetNumericFilterValueProperty.builder()
     *                                 .staticValue(123)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .stringFilterCondition(DataSetStringFilterConditionProperty.builder()
     *                 .columnName("columnName")
     *                 .comparisonFilterCondition(DataSetStringComparisonFilterConditionProperty.builder()
     *                         .operator("operator")
     *                         // the properties below are optional
     *                         .value(DataSetStringFilterValueProperty.builder()
     *                                 .staticValue("staticValue")
     *                                 .build())
     *                         .build())
     *                 .listFilterCondition(DataSetStringListFilterConditionProperty.builder()
     *                         .operator("operator")
     *                         // the properties below are optional
     *                         .values(DataSetStringListFilterValueProperty.builder()
     *                                 .staticValues(List.of("staticValues"))
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filteroperation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filteroperation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.FilterOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(FilterOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilterOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An expression that must evaluate to a Boolean value.
         * <p>
         * Rows for which the expression evaluates to true are kept in the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filteroperation.html#cfn-quicksight-dataset-filteroperation-conditionexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filteroperation.html#cfn-quicksight-dataset-filteroperation-conditionexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConditionExpression() {
            return null;
        }

        /**
         * A date-based filter condition within a filter operation.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetDateFilterConditionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filteroperation.html#cfn-quicksight-dataset-filteroperation-datefiltercondition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filteroperation.html#cfn-quicksight-dataset-filteroperation-datefiltercondition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDateFilterCondition() {
            return null;
        }

        /**
         * A numeric-based filter condition within a filter operation.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetNumericFilterConditionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filteroperation.html#cfn-quicksight-dataset-filteroperation-numericfiltercondition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filteroperation.html#cfn-quicksight-dataset-filteroperation-numericfiltercondition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNumericFilterCondition() {
            return null;
        }

        /**
         * A string-based filter condition within a filter operation.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetStringFilterConditionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filteroperation.html#cfn-quicksight-dataset-filteroperation-stringfiltercondition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filteroperation.html#cfn-quicksight-dataset-filteroperation-stringfiltercondition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStringFilterCondition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FilterOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FilterOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FilterOperationProperty> {
            java.lang.String conditionExpression;
            java.lang.Object dateFilterCondition;
            java.lang.Object numericFilterCondition;
            java.lang.Object stringFilterCondition;

            /**
             * Sets the value of {@link FilterOperationProperty#getConditionExpression}
             * @param conditionExpression An expression that must evaluate to a Boolean value.
             *                            Rows for which the expression evaluates to true are kept in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditionExpression(java.lang.String conditionExpression) {
                this.conditionExpression = conditionExpression;
                return this;
            }

            /**
             * Sets the value of {@link FilterOperationProperty#getDateFilterCondition}
             * @param dateFilterCondition A date-based filter condition within a filter operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateFilterCondition(software.amazon.awscdk.IResolvable dateFilterCondition) {
                this.dateFilterCondition = dateFilterCondition;
                return this;
            }

            /**
             * Sets the value of {@link FilterOperationProperty#getDateFilterCondition}
             * @param dateFilterCondition A date-based filter condition within a filter operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateFilterCondition(software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetDateFilterConditionProperty dateFilterCondition) {
                this.dateFilterCondition = dateFilterCondition;
                return this;
            }

            /**
             * Sets the value of {@link FilterOperationProperty#getNumericFilterCondition}
             * @param numericFilterCondition A numeric-based filter condition within a filter operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numericFilterCondition(software.amazon.awscdk.IResolvable numericFilterCondition) {
                this.numericFilterCondition = numericFilterCondition;
                return this;
            }

            /**
             * Sets the value of {@link FilterOperationProperty#getNumericFilterCondition}
             * @param numericFilterCondition A numeric-based filter condition within a filter operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numericFilterCondition(software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetNumericFilterConditionProperty numericFilterCondition) {
                this.numericFilterCondition = numericFilterCondition;
                return this;
            }

            /**
             * Sets the value of {@link FilterOperationProperty#getStringFilterCondition}
             * @param stringFilterCondition A string-based filter condition within a filter operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringFilterCondition(software.amazon.awscdk.IResolvable stringFilterCondition) {
                this.stringFilterCondition = stringFilterCondition;
                return this;
            }

            /**
             * Sets the value of {@link FilterOperationProperty#getStringFilterCondition}
             * @param stringFilterCondition A string-based filter condition within a filter operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringFilterCondition(software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetStringFilterConditionProperty stringFilterCondition) {
                this.stringFilterCondition = stringFilterCondition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FilterOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FilterOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilterOperationProperty {
            private final java.lang.String conditionExpression;
            private final java.lang.Object dateFilterCondition;
            private final java.lang.Object numericFilterCondition;
            private final java.lang.Object stringFilterCondition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.conditionExpression = software.amazon.jsii.Kernel.get(this, "conditionExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dateFilterCondition = software.amazon.jsii.Kernel.get(this, "dateFilterCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.numericFilterCondition = software.amazon.jsii.Kernel.get(this, "numericFilterCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stringFilterCondition = software.amazon.jsii.Kernel.get(this, "stringFilterCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.conditionExpression = builder.conditionExpression;
                this.dateFilterCondition = builder.dateFilterCondition;
                this.numericFilterCondition = builder.numericFilterCondition;
                this.stringFilterCondition = builder.stringFilterCondition;
            }

            @Override
            public final java.lang.String getConditionExpression() {
                return this.conditionExpression;
            }

            @Override
            public final java.lang.Object getDateFilterCondition() {
                return this.dateFilterCondition;
            }

            @Override
            public final java.lang.Object getNumericFilterCondition() {
                return this.numericFilterCondition;
            }

            @Override
            public final java.lang.Object getStringFilterCondition() {
                return this.stringFilterCondition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConditionExpression() != null) {
                    data.set("conditionExpression", om.valueToTree(this.getConditionExpression()));
                }
                if (this.getDateFilterCondition() != null) {
                    data.set("dateFilterCondition", om.valueToTree(this.getDateFilterCondition()));
                }
                if (this.getNumericFilterCondition() != null) {
                    data.set("numericFilterCondition", om.valueToTree(this.getNumericFilterCondition()));
                }
                if (this.getStringFilterCondition() != null) {
                    data.set("stringFilterCondition", om.valueToTree(this.getStringFilterCondition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.FilterOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilterOperationProperty.Jsii$Proxy that = (FilterOperationProperty.Jsii$Proxy) o;

                if (this.conditionExpression != null ? !this.conditionExpression.equals(that.conditionExpression) : that.conditionExpression != null) return false;
                if (this.dateFilterCondition != null ? !this.dateFilterCondition.equals(that.dateFilterCondition) : that.dateFilterCondition != null) return false;
                if (this.numericFilterCondition != null ? !this.numericFilterCondition.equals(that.numericFilterCondition) : that.numericFilterCondition != null) return false;
                return this.stringFilterCondition != null ? this.stringFilterCondition.equals(that.stringFilterCondition) : that.stringFilterCondition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.conditionExpression != null ? this.conditionExpression.hashCode() : 0;
                result = 31 * result + (this.dateFilterCondition != null ? this.dateFilterCondition.hashCode() : 0);
                result = 31 * result + (this.numericFilterCondition != null ? this.numericFilterCondition.hashCode() : 0);
                result = 31 * result + (this.stringFilterCondition != null ? this.stringFilterCondition.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A transform operation that applies one or more filter conditions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * FiltersOperationProperty filtersOperationProperty = FiltersOperationProperty.builder()
     *         .alias("alias")
     *         .filterOperations(List.of(FilterOperationProperty.builder()
     *                 .conditionExpression("conditionExpression")
     *                 .dateFilterCondition(DataSetDateFilterConditionProperty.builder()
     *                         .columnName("columnName")
     *                         .comparisonFilterCondition(DataSetDateComparisonFilterConditionProperty.builder()
     *                                 .operator("operator")
     *                                 // the properties below are optional
     *                                 .value(DataSetDateFilterValueProperty.builder()
     *                                         .staticValue("staticValue")
     *                                         .build())
     *                                 .build())
     *                         .rangeFilterCondition(DataSetDateRangeFilterConditionProperty.builder()
     *                                 .includeMaximum(false)
     *                                 .includeMinimum(false)
     *                                 .rangeMaximum(DataSetDateFilterValueProperty.builder()
     *                                         .staticValue("staticValue")
     *                                         .build())
     *                                 .rangeMinimum(DataSetDateFilterValueProperty.builder()
     *                                         .staticValue("staticValue")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .numericFilterCondition(DataSetNumericFilterConditionProperty.builder()
     *                         .columnName("columnName")
     *                         .comparisonFilterCondition(DataSetNumericComparisonFilterConditionProperty.builder()
     *                                 .operator("operator")
     *                                 // the properties below are optional
     *                                 .value(DataSetNumericFilterValueProperty.builder()
     *                                         .staticValue(123)
     *                                         .build())
     *                                 .build())
     *                         .rangeFilterCondition(DataSetNumericRangeFilterConditionProperty.builder()
     *                                 .includeMaximum(false)
     *                                 .includeMinimum(false)
     *                                 .rangeMaximum(DataSetNumericFilterValueProperty.builder()
     *                                         .staticValue(123)
     *                                         .build())
     *                                 .rangeMinimum(DataSetNumericFilterValueProperty.builder()
     *                                         .staticValue(123)
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .stringFilterCondition(DataSetStringFilterConditionProperty.builder()
     *                         .columnName("columnName")
     *                         .comparisonFilterCondition(DataSetStringComparisonFilterConditionProperty.builder()
     *                                 .operator("operator")
     *                                 // the properties below are optional
     *                                 .value(DataSetStringFilterValueProperty.builder()
     *                                         .staticValue("staticValue")
     *                                         .build())
     *                                 .build())
     *                         .listFilterCondition(DataSetStringListFilterConditionProperty.builder()
     *                                 .operator("operator")
     *                                 // the properties below are optional
     *                                 .values(DataSetStringListFilterValueProperty.builder()
     *                                         .staticValues(List.of("staticValues"))
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .build()))
     *         .source(TransformOperationSourceProperty.builder()
     *                 .transformOperationId("transformOperationId")
     *                 // the properties below are optional
     *                 .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                         .sourceColumnId("sourceColumnId")
     *                         .targetColumnId("targetColumnId")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filtersoperation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filtersoperation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.FiltersOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(FiltersOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FiltersOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Alias for this operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filtersoperation.html#cfn-quicksight-dataset-filtersoperation-alias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filtersoperation.html#cfn-quicksight-dataset-filtersoperation-alias</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlias();

        /**
         * The list of filter operations to apply.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.FilterOperationProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filtersoperation.html#cfn-quicksight-dataset-filtersoperation-filteroperations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filtersoperation.html#cfn-quicksight-dataset-filtersoperation-filteroperations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFilterOperations();

        /**
         * The source transform operation that provides input data for filtering.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.TransformOperationSourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filtersoperation.html#cfn-quicksight-dataset-filtersoperation-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filtersoperation.html#cfn-quicksight-dataset-filtersoperation-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSource();

        /**
         * @return a {@link Builder} of {@link FiltersOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FiltersOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FiltersOperationProperty> {
            java.lang.String alias;
            java.lang.Object filterOperations;
            java.lang.Object source;

            /**
             * Sets the value of {@link FiltersOperationProperty#getAlias}
             * @param alias Alias for this operation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alias(java.lang.String alias) {
                this.alias = alias;
                return this;
            }

            /**
             * Sets the value of {@link FiltersOperationProperty#getFilterOperations}
             * @param filterOperations The list of filter operations to apply. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterOperations(software.amazon.awscdk.IResolvable filterOperations) {
                this.filterOperations = filterOperations;
                return this;
            }

            /**
             * Sets the value of {@link FiltersOperationProperty#getFilterOperations}
             * @param filterOperations The list of filter operations to apply. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterOperations(java.util.List<? extends java.lang.Object> filterOperations) {
                this.filterOperations = filterOperations;
                return this;
            }

            /**
             * Sets the value of {@link FiltersOperationProperty#getSource}
             * @param source The source transform operation that provides input data for filtering. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.IResolvable source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link FiltersOperationProperty#getSource}
             * @param source The source transform operation that provides input data for filtering. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.services.quicksight.CfnDataSet.TransformOperationSourceProperty source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FiltersOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FiltersOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FiltersOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FiltersOperationProperty {
            private final java.lang.String alias;
            private final java.lang.Object filterOperations;
            private final java.lang.Object source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.filterOperations = software.amazon.jsii.Kernel.get(this, "filterOperations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alias = java.util.Objects.requireNonNull(builder.alias, "alias is required");
                this.filterOperations = java.util.Objects.requireNonNull(builder.filterOperations, "filterOperations is required");
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            }

            @Override
            public final java.lang.String getAlias() {
                return this.alias;
            }

            @Override
            public final java.lang.Object getFilterOperations() {
                return this.filterOperations;
            }

            @Override
            public final java.lang.Object getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alias", om.valueToTree(this.getAlias()));
                data.set("filterOperations", om.valueToTree(this.getFilterOperations()));
                data.set("source", om.valueToTree(this.getSource()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.FiltersOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FiltersOperationProperty.Jsii$Proxy that = (FiltersOperationProperty.Jsii$Proxy) o;

                if (!alias.equals(that.alias)) return false;
                if (!filterOperations.equals(that.filterOperations)) return false;
                return this.source.equals(that.source);
            }

            @Override
            public final int hashCode() {
                int result = this.alias.hashCode();
                result = 31 * result + (this.filterOperations.hashCode());
                result = 31 * result + (this.source.hashCode());
                return result;
            }
        }
    }
    /**
     * Geospatial column group that denotes a hierarchy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * GeoSpatialColumnGroupProperty geoSpatialColumnGroupProperty = GeoSpatialColumnGroupProperty.builder()
     *         .columns(List.of("columns"))
     *         .name("name")
     *         // the properties below are optional
     *         .countryCode("countryCode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-geospatialcolumngroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-geospatialcolumngroup.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.GeoSpatialColumnGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(GeoSpatialColumnGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GeoSpatialColumnGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Columns in this hierarchy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-geospatialcolumngroup.html#cfn-quicksight-dataset-geospatialcolumngroup-columns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-geospatialcolumngroup.html#cfn-quicksight-dataset-geospatialcolumngroup-columns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getColumns();

        /**
         * A display name for the hierarchy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-geospatialcolumngroup.html#cfn-quicksight-dataset-geospatialcolumngroup-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-geospatialcolumngroup.html#cfn-quicksight-dataset-geospatialcolumngroup-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Country code.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-geospatialcolumngroup.html#cfn-quicksight-dataset-geospatialcolumngroup-countrycode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-geospatialcolumngroup.html#cfn-quicksight-dataset-geospatialcolumngroup-countrycode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCountryCode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GeoSpatialColumnGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GeoSpatialColumnGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GeoSpatialColumnGroupProperty> {
            java.util.List<java.lang.String> columns;
            java.lang.String name;
            java.lang.String countryCode;

            /**
             * Sets the value of {@link GeoSpatialColumnGroupProperty#getColumns}
             * @param columns Columns in this hierarchy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(java.util.List<java.lang.String> columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link GeoSpatialColumnGroupProperty#getName}
             * @param name A display name for the hierarchy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link GeoSpatialColumnGroupProperty#getCountryCode}
             * @param countryCode Country code.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder countryCode(java.lang.String countryCode) {
                this.countryCode = countryCode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GeoSpatialColumnGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GeoSpatialColumnGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GeoSpatialColumnGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GeoSpatialColumnGroupProperty {
            private final java.util.List<java.lang.String> columns;
            private final java.lang.String name;
            private final java.lang.String countryCode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columns = software.amazon.jsii.Kernel.get(this, "columns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.countryCode = software.amazon.jsii.Kernel.get(this, "countryCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columns = java.util.Objects.requireNonNull(builder.columns, "columns is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.countryCode = builder.countryCode;
            }

            @Override
            public final java.util.List<java.lang.String> getColumns() {
                return this.columns;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getCountryCode() {
                return this.countryCode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columns", om.valueToTree(this.getColumns()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getCountryCode() != null) {
                    data.set("countryCode", om.valueToTree(this.getCountryCode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.GeoSpatialColumnGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GeoSpatialColumnGroupProperty.Jsii$Proxy that = (GeoSpatialColumnGroupProperty.Jsii$Proxy) o;

                if (!columns.equals(that.columns)) return false;
                if (!name.equals(that.name)) return false;
                return this.countryCode != null ? this.countryCode.equals(that.countryCode) : that.countryCode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columns.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.countryCode != null ? this.countryCode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A transform operation that imports data from a source table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ImportTableOperationProperty importTableOperationProperty = ImportTableOperationProperty.builder()
     *         .alias("alias")
     *         .source(ImportTableOperationSourceProperty.builder()
     *                 .sourceTableId("sourceTableId")
     *                 // the properties below are optional
     *                 .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                         .sourceColumnId("sourceColumnId")
     *                         .targetColumnId("targetColumnId")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-importtableoperation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-importtableoperation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.ImportTableOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(ImportTableOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImportTableOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Alias for this operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-importtableoperation.html#cfn-quicksight-dataset-importtableoperation-alias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-importtableoperation.html#cfn-quicksight-dataset-importtableoperation-alias</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlias();

        /**
         * The source configuration that specifies which source table to import and any column mappings.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.ImportTableOperationSourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-importtableoperation.html#cfn-quicksight-dataset-importtableoperation-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-importtableoperation.html#cfn-quicksight-dataset-importtableoperation-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSource();

        /**
         * @return a {@link Builder} of {@link ImportTableOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImportTableOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImportTableOperationProperty> {
            java.lang.String alias;
            java.lang.Object source;

            /**
             * Sets the value of {@link ImportTableOperationProperty#getAlias}
             * @param alias Alias for this operation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alias(java.lang.String alias) {
                this.alias = alias;
                return this;
            }

            /**
             * Sets the value of {@link ImportTableOperationProperty#getSource}
             * @param source The source configuration that specifies which source table to import and any column mappings. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.IResolvable source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link ImportTableOperationProperty#getSource}
             * @param source The source configuration that specifies which source table to import and any column mappings. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.services.quicksight.CfnDataSet.ImportTableOperationSourceProperty source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImportTableOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImportTableOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ImportTableOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImportTableOperationProperty {
            private final java.lang.String alias;
            private final java.lang.Object source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alias = java.util.Objects.requireNonNull(builder.alias, "alias is required");
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            }

            @Override
            public final java.lang.String getAlias() {
                return this.alias;
            }

            @Override
            public final java.lang.Object getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alias", om.valueToTree(this.getAlias()));
                data.set("source", om.valueToTree(this.getSource()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.ImportTableOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImportTableOperationProperty.Jsii$Proxy that = (ImportTableOperationProperty.Jsii$Proxy) o;

                if (!alias.equals(that.alias)) return false;
                return this.source.equals(that.source);
            }

            @Override
            public final int hashCode() {
                int result = this.alias.hashCode();
                result = 31 * result + (this.source.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the source table and column mappings for an import table operation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ImportTableOperationSourceProperty importTableOperationSourceProperty = ImportTableOperationSourceProperty.builder()
     *         .sourceTableId("sourceTableId")
     *         // the properties below are optional
     *         .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                 .sourceColumnId("sourceColumnId")
     *                 .targetColumnId("targetColumnId")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-importtableoperationsource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-importtableoperationsource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.ImportTableOperationSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(ImportTableOperationSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImportTableOperationSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the source table to import data from.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-importtableoperationsource.html#cfn-quicksight-dataset-importtableoperationsource-sourcetableid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-importtableoperationsource.html#cfn-quicksight-dataset-importtableoperationsource-sourcetableid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSourceTableId();

        /**
         * The mappings between source column identifiers and target column identifiers during the import.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetColumnIdMappingProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-importtableoperationsource.html#cfn-quicksight-dataset-importtableoperationsource-columnidmappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-importtableoperationsource.html#cfn-quicksight-dataset-importtableoperationsource-columnidmappings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColumnIdMappings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ImportTableOperationSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImportTableOperationSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImportTableOperationSourceProperty> {
            java.lang.String sourceTableId;
            java.lang.Object columnIdMappings;

            /**
             * Sets the value of {@link ImportTableOperationSourceProperty#getSourceTableId}
             * @param sourceTableId The identifier of the source table to import data from. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceTableId(java.lang.String sourceTableId) {
                this.sourceTableId = sourceTableId;
                return this;
            }

            /**
             * Sets the value of {@link ImportTableOperationSourceProperty#getColumnIdMappings}
             * @param columnIdMappings The mappings between source column identifiers and target column identifiers during the import.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnIdMappings(software.amazon.awscdk.IResolvable columnIdMappings) {
                this.columnIdMappings = columnIdMappings;
                return this;
            }

            /**
             * Sets the value of {@link ImportTableOperationSourceProperty#getColumnIdMappings}
             * @param columnIdMappings The mappings between source column identifiers and target column identifiers during the import.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnIdMappings(java.util.List<? extends java.lang.Object> columnIdMappings) {
                this.columnIdMappings = columnIdMappings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImportTableOperationSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImportTableOperationSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ImportTableOperationSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImportTableOperationSourceProperty {
            private final java.lang.String sourceTableId;
            private final java.lang.Object columnIdMappings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceTableId = software.amazon.jsii.Kernel.get(this, "sourceTableId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.columnIdMappings = software.amazon.jsii.Kernel.get(this, "columnIdMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceTableId = java.util.Objects.requireNonNull(builder.sourceTableId, "sourceTableId is required");
                this.columnIdMappings = builder.columnIdMappings;
            }

            @Override
            public final java.lang.String getSourceTableId() {
                return this.sourceTableId;
            }

            @Override
            public final java.lang.Object getColumnIdMappings() {
                return this.columnIdMappings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourceTableId", om.valueToTree(this.getSourceTableId()));
                if (this.getColumnIdMappings() != null) {
                    data.set("columnIdMappings", om.valueToTree(this.getColumnIdMappings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.ImportTableOperationSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImportTableOperationSourceProperty.Jsii$Proxy that = (ImportTableOperationSourceProperty.Jsii$Proxy) o;

                if (!sourceTableId.equals(that.sourceTableId)) return false;
                return this.columnIdMappings != null ? this.columnIdMappings.equals(that.columnIdMappings) : that.columnIdMappings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceTableId.hashCode();
                result = 31 * result + (this.columnIdMappings != null ? this.columnIdMappings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The incremental refresh configuration for a dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * IncrementalRefreshProperty incrementalRefreshProperty = IncrementalRefreshProperty.builder()
     *         .lookbackWindow(LookbackWindowProperty.builder()
     *                 .columnName("columnName")
     *                 .size(123)
     *                 .sizeUnit("sizeUnit")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-incrementalrefresh.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-incrementalrefresh.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.IncrementalRefreshProperty")
    @software.amazon.jsii.Jsii.Proxy(IncrementalRefreshProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IncrementalRefreshProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The lookback window setup for an incremental refresh configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.LookbackWindowProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-incrementalrefresh.html#cfn-quicksight-dataset-incrementalrefresh-lookbackwindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-incrementalrefresh.html#cfn-quicksight-dataset-incrementalrefresh-lookbackwindow</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLookbackWindow();

        /**
         * @return a {@link Builder} of {@link IncrementalRefreshProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IncrementalRefreshProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IncrementalRefreshProperty> {
            java.lang.Object lookbackWindow;

            /**
             * Sets the value of {@link IncrementalRefreshProperty#getLookbackWindow}
             * @param lookbackWindow The lookback window setup for an incremental refresh configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lookbackWindow(software.amazon.awscdk.IResolvable lookbackWindow) {
                this.lookbackWindow = lookbackWindow;
                return this;
            }

            /**
             * Sets the value of {@link IncrementalRefreshProperty#getLookbackWindow}
             * @param lookbackWindow The lookback window setup for an incremental refresh configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lookbackWindow(software.amazon.awscdk.services.quicksight.CfnDataSet.LookbackWindowProperty lookbackWindow) {
                this.lookbackWindow = lookbackWindow;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IncrementalRefreshProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IncrementalRefreshProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IncrementalRefreshProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IncrementalRefreshProperty {
            private final java.lang.Object lookbackWindow;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lookbackWindow = software.amazon.jsii.Kernel.get(this, "lookbackWindow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lookbackWindow = java.util.Objects.requireNonNull(builder.lookbackWindow, "lookbackWindow is required");
            }

            @Override
            public final java.lang.Object getLookbackWindow() {
                return this.lookbackWindow;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("lookbackWindow", om.valueToTree(this.getLookbackWindow()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.IncrementalRefreshProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IncrementalRefreshProperty.Jsii$Proxy that = (IncrementalRefreshProperty.Jsii$Proxy) o;

                return this.lookbackWindow.equals(that.lookbackWindow);
            }

            @Override
            public final int hashCode() {
                int result = this.lookbackWindow.hashCode();
                return result;
            }
        }
    }
    /**
     * The wait policy to use when creating or updating a Dataset.
     * <p>
     * The default is to wait for SPICE ingestion to finish with timeout of 36 hours.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * IngestionWaitPolicyProperty ingestionWaitPolicyProperty = IngestionWaitPolicyProperty.builder()
     *         .ingestionWaitTimeInHours(123)
     *         .waitForSpiceIngestion(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-ingestionwaitpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-ingestionwaitpolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.IngestionWaitPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(IngestionWaitPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IngestionWaitPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum time (in hours) to wait for Ingestion to complete.
         * <p>
         * Default timeout is 36 hours. Applicable only when <code>DataSetImportMode</code> mode is set to SPICE and <code>WaitForSpiceIngestion</code> is set to true.
         * <p>
         * Default: - 36
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-ingestionwaitpolicy.html#cfn-quicksight-dataset-ingestionwaitpolicy-ingestionwaittimeinhours">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-ingestionwaitpolicy.html#cfn-quicksight-dataset-ingestionwaitpolicy-ingestionwaittimeinhours</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIngestionWaitTimeInHours() {
            return null;
        }

        /**
         * Wait for SPICE ingestion to finish to mark dataset creation or update as successful.
         * <p>
         * Default (true). Applicable only when <code>DataSetImportMode</code> mode is set to SPICE.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * Default: - true
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-ingestionwaitpolicy.html#cfn-quicksight-dataset-ingestionwaitpolicy-waitforspiceingestion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-ingestionwaitpolicy.html#cfn-quicksight-dataset-ingestionwaitpolicy-waitforspiceingestion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWaitForSpiceIngestion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IngestionWaitPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IngestionWaitPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IngestionWaitPolicyProperty> {
            java.lang.Number ingestionWaitTimeInHours;
            java.lang.Object waitForSpiceIngestion;

            /**
             * Sets the value of {@link IngestionWaitPolicyProperty#getIngestionWaitTimeInHours}
             * @param ingestionWaitTimeInHours The maximum time (in hours) to wait for Ingestion to complete.
             *                                 Default timeout is 36 hours. Applicable only when <code>DataSetImportMode</code> mode is set to SPICE and <code>WaitForSpiceIngestion</code> is set to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ingestionWaitTimeInHours(java.lang.Number ingestionWaitTimeInHours) {
                this.ingestionWaitTimeInHours = ingestionWaitTimeInHours;
                return this;
            }

            /**
             * Sets the value of {@link IngestionWaitPolicyProperty#getWaitForSpiceIngestion}
             * @param waitForSpiceIngestion Wait for SPICE ingestion to finish to mark dataset creation or update as successful.
             *                              Default (true). Applicable only when <code>DataSetImportMode</code> mode is set to SPICE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder waitForSpiceIngestion(java.lang.Boolean waitForSpiceIngestion) {
                this.waitForSpiceIngestion = waitForSpiceIngestion;
                return this;
            }

            /**
             * Sets the value of {@link IngestionWaitPolicyProperty#getWaitForSpiceIngestion}
             * @param waitForSpiceIngestion Wait for SPICE ingestion to finish to mark dataset creation or update as successful.
             *                              Default (true). Applicable only when <code>DataSetImportMode</code> mode is set to SPICE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder waitForSpiceIngestion(software.amazon.awscdk.IResolvable waitForSpiceIngestion) {
                this.waitForSpiceIngestion = waitForSpiceIngestion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IngestionWaitPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IngestionWaitPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IngestionWaitPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IngestionWaitPolicyProperty {
            private final java.lang.Number ingestionWaitTimeInHours;
            private final java.lang.Object waitForSpiceIngestion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ingestionWaitTimeInHours = software.amazon.jsii.Kernel.get(this, "ingestionWaitTimeInHours", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.waitForSpiceIngestion = software.amazon.jsii.Kernel.get(this, "waitForSpiceIngestion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ingestionWaitTimeInHours = builder.ingestionWaitTimeInHours;
                this.waitForSpiceIngestion = builder.waitForSpiceIngestion;
            }

            @Override
            public final java.lang.Number getIngestionWaitTimeInHours() {
                return this.ingestionWaitTimeInHours;
            }

            @Override
            public final java.lang.Object getWaitForSpiceIngestion() {
                return this.waitForSpiceIngestion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIngestionWaitTimeInHours() != null) {
                    data.set("ingestionWaitTimeInHours", om.valueToTree(this.getIngestionWaitTimeInHours()));
                }
                if (this.getWaitForSpiceIngestion() != null) {
                    data.set("waitForSpiceIngestion", om.valueToTree(this.getWaitForSpiceIngestion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.IngestionWaitPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IngestionWaitPolicyProperty.Jsii$Proxy that = (IngestionWaitPolicyProperty.Jsii$Proxy) o;

                if (this.ingestionWaitTimeInHours != null ? !this.ingestionWaitTimeInHours.equals(that.ingestionWaitTimeInHours) : that.ingestionWaitTimeInHours != null) return false;
                return this.waitForSpiceIngestion != null ? this.waitForSpiceIngestion.equals(that.waitForSpiceIngestion) : that.waitForSpiceIngestion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ingestionWaitTimeInHours != null ? this.ingestionWaitTimeInHours.hashCode() : 0;
                result = 31 * result + (this.waitForSpiceIngestion != null ? this.waitForSpiceIngestion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Metadata for a column that is used as the input of a transform operation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * InputColumnProperty inputColumnProperty = InputColumnProperty.builder()
     *         .name("name")
     *         .type("type")
     *         // the properties below are optional
     *         .id("id")
     *         .subType("subType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-inputcolumn.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-inputcolumn.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.InputColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(InputColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of this column in the underlying data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-inputcolumn.html#cfn-quicksight-dataset-inputcolumn-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-inputcolumn.html#cfn-quicksight-dataset-inputcolumn-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The data type of the column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-inputcolumn.html#cfn-quicksight-dataset-inputcolumn-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-inputcolumn.html#cfn-quicksight-dataset-inputcolumn-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * A unique identifier for the input column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-inputcolumn.html#cfn-quicksight-dataset-inputcolumn-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-inputcolumn.html#cfn-quicksight-dataset-inputcolumn-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getId() {
            return null;
        }

        /**
         * The sub data type of the column.
         * <p>
         * Sub types are only available for decimal columns that are part of a SPICE dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-inputcolumn.html#cfn-quicksight-dataset-inputcolumn-subtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-inputcolumn.html#cfn-quicksight-dataset-inputcolumn-subtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InputColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputColumnProperty> {
            java.lang.String name;
            java.lang.String type;
            java.lang.String id;
            java.lang.String subType;

            /**
             * Sets the value of {@link InputColumnProperty#getName}
             * @param name The name of this column in the underlying data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link InputColumnProperty#getType}
             * @param type The data type of the column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link InputColumnProperty#getId}
             * @param id A unique identifier for the input column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link InputColumnProperty#getSubType}
             * @param subType The sub data type of the column.
             *                Sub types are only available for decimal columns that are part of a SPICE dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subType(java.lang.String subType) {
                this.subType = subType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputColumnProperty {
            private final java.lang.String name;
            private final java.lang.String type;
            private final java.lang.String id;
            private final java.lang.String subType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subType = software.amazon.jsii.Kernel.get(this, "subType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.id = builder.id;
                this.subType = builder.subType;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getSubType() {
                return this.subType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }
                if (this.getSubType() != null) {
                    data.set("subType", om.valueToTree(this.getSubType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.InputColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputColumnProperty.Jsii$Proxy that = (InputColumnProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!type.equals(that.type)) return false;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                return this.subType != null ? this.subType.equals(that.subType) : that.subType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                result = 31 * result + (this.subType != null ? this.subType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A list of default values for a given integer parameter.
     * <p>
     * This structure only accepts static values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * IntegerDatasetParameterDefaultValuesProperty integerDatasetParameterDefaultValuesProperty = IntegerDatasetParameterDefaultValuesProperty.builder()
     *         .staticValues(List.of(123))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameterdefaultvalues.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameterdefaultvalues.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.IntegerDatasetParameterDefaultValuesProperty")
    @software.amazon.jsii.Jsii.Proxy(IntegerDatasetParameterDefaultValuesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IntegerDatasetParameterDefaultValuesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of static default values for a given integer parameter.
         * <p>
         * Returns union: either List<{@link java.lang.Number}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameterdefaultvalues.html#cfn-quicksight-dataset-integerdatasetparameterdefaultvalues-staticvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameterdefaultvalues.html#cfn-quicksight-dataset-integerdatasetparameterdefaultvalues-staticvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStaticValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IntegerDatasetParameterDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntegerDatasetParameterDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IntegerDatasetParameterDefaultValuesProperty> {
            java.lang.Object staticValues;

            /**
             * Sets the value of {@link IntegerDatasetParameterDefaultValuesProperty#getStaticValues}
             * @param staticValues A list of static default values for a given integer parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder staticValues(java.util.List<? extends java.lang.Number> staticValues) {
                this.staticValues = staticValues;
                return this;
            }

            /**
             * Sets the value of {@link IntegerDatasetParameterDefaultValuesProperty#getStaticValues}
             * @param staticValues A list of static default values for a given integer parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder staticValues(software.amazon.awscdk.IResolvable staticValues) {
                this.staticValues = staticValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntegerDatasetParameterDefaultValuesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IntegerDatasetParameterDefaultValuesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IntegerDatasetParameterDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegerDatasetParameterDefaultValuesProperty {
            private final java.lang.Object staticValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.staticValues = software.amazon.jsii.Kernel.get(this, "staticValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.staticValues = builder.staticValues;
            }

            @Override
            public final java.lang.Object getStaticValues() {
                return this.staticValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getStaticValues() != null) {
                    data.set("staticValues", om.valueToTree(this.getStaticValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.IntegerDatasetParameterDefaultValuesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntegerDatasetParameterDefaultValuesProperty.Jsii$Proxy that = (IntegerDatasetParameterDefaultValuesProperty.Jsii$Proxy) o;

                return this.staticValues != null ? this.staticValues.equals(that.staticValues) : that.staticValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.staticValues != null ? this.staticValues.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An integer parameter that is created in the dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * IntegerDatasetParameterProperty integerDatasetParameterProperty = IntegerDatasetParameterProperty.builder()
     *         .id("id")
     *         .name("name")
     *         .valueType("valueType")
     *         // the properties below are optional
     *         .defaultValues(IntegerDatasetParameterDefaultValuesProperty.builder()
     *                 .staticValues(List.of(123))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.IntegerDatasetParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(IntegerDatasetParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IntegerDatasetParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An identifier for the integer parameter created in the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameter.html#cfn-quicksight-dataset-integerdatasetparameter-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameter.html#cfn-quicksight-dataset-integerdatasetparameter-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * The name of the integer parameter that is created in the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameter.html#cfn-quicksight-dataset-integerdatasetparameter-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameter.html#cfn-quicksight-dataset-integerdatasetparameter-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The value type of the dataset parameter.
         * <p>
         * Valid values are <code>single value</code> or <code>multi value</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameter.html#cfn-quicksight-dataset-integerdatasetparameter-valuetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameter.html#cfn-quicksight-dataset-integerdatasetparameter-valuetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValueType();

        /**
         * A list of default values for a given integer parameter.
         * <p>
         * This structure only accepts static values.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.IntegerDatasetParameterDefaultValuesProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameter.html#cfn-quicksight-dataset-integerdatasetparameter-defaultvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameter.html#cfn-quicksight-dataset-integerdatasetparameter-defaultvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IntegerDatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntegerDatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IntegerDatasetParameterProperty> {
            java.lang.String id;
            java.lang.String name;
            java.lang.String valueType;
            java.lang.Object defaultValues;

            /**
             * Sets the value of {@link IntegerDatasetParameterProperty#getId}
             * @param id An identifier for the integer parameter created in the dataset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link IntegerDatasetParameterProperty#getName}
             * @param name The name of the integer parameter that is created in the dataset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link IntegerDatasetParameterProperty#getValueType}
             * @param valueType The value type of the dataset parameter. This parameter is required.
             *                  Valid values are <code>single value</code> or <code>multi value</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueType(java.lang.String valueType) {
                this.valueType = valueType;
                return this;
            }

            /**
             * Sets the value of {@link IntegerDatasetParameterProperty#getDefaultValues}
             * @param defaultValues A list of default values for a given integer parameter.
             *                      This structure only accepts static values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValues(software.amazon.awscdk.IResolvable defaultValues) {
                this.defaultValues = defaultValues;
                return this;
            }

            /**
             * Sets the value of {@link IntegerDatasetParameterProperty#getDefaultValues}
             * @param defaultValues A list of default values for a given integer parameter.
             *                      This structure only accepts static values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValues(software.amazon.awscdk.services.quicksight.CfnDataSet.IntegerDatasetParameterDefaultValuesProperty defaultValues) {
                this.defaultValues = defaultValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntegerDatasetParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IntegerDatasetParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IntegerDatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegerDatasetParameterProperty {
            private final java.lang.String id;
            private final java.lang.String name;
            private final java.lang.String valueType;
            private final java.lang.Object defaultValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valueType = software.amazon.jsii.Kernel.get(this, "valueType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultValues = software.amazon.jsii.Kernel.get(this, "defaultValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.valueType = java.util.Objects.requireNonNull(builder.valueType, "valueType is required");
                this.defaultValues = builder.defaultValues;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValueType() {
                return this.valueType;
            }

            @Override
            public final java.lang.Object getDefaultValues() {
                return this.defaultValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("valueType", om.valueToTree(this.getValueType()));
                if (this.getDefaultValues() != null) {
                    data.set("defaultValues", om.valueToTree(this.getDefaultValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.IntegerDatasetParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntegerDatasetParameterProperty.Jsii$Proxy that = (IntegerDatasetParameterProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                if (!name.equals(that.name)) return false;
                if (!valueType.equals(that.valueType)) return false;
                return this.defaultValues != null ? this.defaultValues.equals(that.defaultValues) : that.defaultValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.valueType.hashCode());
                result = 31 * result + (this.defaultValues != null ? this.defaultValues.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The instructions associated with a join.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * JoinInstructionProperty joinInstructionProperty = JoinInstructionProperty.builder()
     *         .leftOperand("leftOperand")
     *         .onClause("onClause")
     *         .rightOperand("rightOperand")
     *         .type("type")
     *         // the properties below are optional
     *         .leftJoinKeyProperties(JoinKeyPropertiesProperty.builder()
     *                 .uniqueKey(false)
     *                 .build())
     *         .rightJoinKeyProperties(JoinKeyPropertiesProperty.builder()
     *                 .uniqueKey(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.JoinInstructionProperty")
    @software.amazon.jsii.Jsii.Proxy(JoinInstructionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JoinInstructionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The operand on the left side of a join.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-leftoperand">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-leftoperand</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLeftOperand();

        /**
         * The join instructions provided in the <code>ON</code> clause of a join.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-onclause">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-onclause</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOnClause();

        /**
         * The operand on the right side of a join.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-rightoperand">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-rightoperand</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRightOperand();

        /**
         * The type of join that it is.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Join key properties of the left operand.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.JoinKeyPropertiesProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-leftjoinkeyproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-leftjoinkeyproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLeftJoinKeyProperties() {
            return null;
        }

        /**
         * Join key properties of the right operand.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.JoinKeyPropertiesProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-rightjoinkeyproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-rightjoinkeyproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRightJoinKeyProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JoinInstructionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JoinInstructionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JoinInstructionProperty> {
            java.lang.String leftOperand;
            java.lang.String onClause;
            java.lang.String rightOperand;
            java.lang.String type;
            java.lang.Object leftJoinKeyProperties;
            java.lang.Object rightJoinKeyProperties;

            /**
             * Sets the value of {@link JoinInstructionProperty#getLeftOperand}
             * @param leftOperand The operand on the left side of a join. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder leftOperand(java.lang.String leftOperand) {
                this.leftOperand = leftOperand;
                return this;
            }

            /**
             * Sets the value of {@link JoinInstructionProperty#getOnClause}
             * @param onClause The join instructions provided in the <code>ON</code> clause of a join. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onClause(java.lang.String onClause) {
                this.onClause = onClause;
                return this;
            }

            /**
             * Sets the value of {@link JoinInstructionProperty#getRightOperand}
             * @param rightOperand The operand on the right side of a join. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rightOperand(java.lang.String rightOperand) {
                this.rightOperand = rightOperand;
                return this;
            }

            /**
             * Sets the value of {@link JoinInstructionProperty#getType}
             * @param type The type of join that it is. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link JoinInstructionProperty#getLeftJoinKeyProperties}
             * @param leftJoinKeyProperties Join key properties of the left operand.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder leftJoinKeyProperties(software.amazon.awscdk.IResolvable leftJoinKeyProperties) {
                this.leftJoinKeyProperties = leftJoinKeyProperties;
                return this;
            }

            /**
             * Sets the value of {@link JoinInstructionProperty#getLeftJoinKeyProperties}
             * @param leftJoinKeyProperties Join key properties of the left operand.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder leftJoinKeyProperties(software.amazon.awscdk.services.quicksight.CfnDataSet.JoinKeyPropertiesProperty leftJoinKeyProperties) {
                this.leftJoinKeyProperties = leftJoinKeyProperties;
                return this;
            }

            /**
             * Sets the value of {@link JoinInstructionProperty#getRightJoinKeyProperties}
             * @param rightJoinKeyProperties Join key properties of the right operand.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rightJoinKeyProperties(software.amazon.awscdk.IResolvable rightJoinKeyProperties) {
                this.rightJoinKeyProperties = rightJoinKeyProperties;
                return this;
            }

            /**
             * Sets the value of {@link JoinInstructionProperty#getRightJoinKeyProperties}
             * @param rightJoinKeyProperties Join key properties of the right operand.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rightJoinKeyProperties(software.amazon.awscdk.services.quicksight.CfnDataSet.JoinKeyPropertiesProperty rightJoinKeyProperties) {
                this.rightJoinKeyProperties = rightJoinKeyProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JoinInstructionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JoinInstructionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JoinInstructionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JoinInstructionProperty {
            private final java.lang.String leftOperand;
            private final java.lang.String onClause;
            private final java.lang.String rightOperand;
            private final java.lang.String type;
            private final java.lang.Object leftJoinKeyProperties;
            private final java.lang.Object rightJoinKeyProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.leftOperand = software.amazon.jsii.Kernel.get(this, "leftOperand", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.onClause = software.amazon.jsii.Kernel.get(this, "onClause", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rightOperand = software.amazon.jsii.Kernel.get(this, "rightOperand", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.leftJoinKeyProperties = software.amazon.jsii.Kernel.get(this, "leftJoinKeyProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rightJoinKeyProperties = software.amazon.jsii.Kernel.get(this, "rightJoinKeyProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.leftOperand = java.util.Objects.requireNonNull(builder.leftOperand, "leftOperand is required");
                this.onClause = java.util.Objects.requireNonNull(builder.onClause, "onClause is required");
                this.rightOperand = java.util.Objects.requireNonNull(builder.rightOperand, "rightOperand is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.leftJoinKeyProperties = builder.leftJoinKeyProperties;
                this.rightJoinKeyProperties = builder.rightJoinKeyProperties;
            }

            @Override
            public final java.lang.String getLeftOperand() {
                return this.leftOperand;
            }

            @Override
            public final java.lang.String getOnClause() {
                return this.onClause;
            }

            @Override
            public final java.lang.String getRightOperand() {
                return this.rightOperand;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getLeftJoinKeyProperties() {
                return this.leftJoinKeyProperties;
            }

            @Override
            public final java.lang.Object getRightJoinKeyProperties() {
                return this.rightJoinKeyProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("leftOperand", om.valueToTree(this.getLeftOperand()));
                data.set("onClause", om.valueToTree(this.getOnClause()));
                data.set("rightOperand", om.valueToTree(this.getRightOperand()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getLeftJoinKeyProperties() != null) {
                    data.set("leftJoinKeyProperties", om.valueToTree(this.getLeftJoinKeyProperties()));
                }
                if (this.getRightJoinKeyProperties() != null) {
                    data.set("rightJoinKeyProperties", om.valueToTree(this.getRightJoinKeyProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.JoinInstructionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JoinInstructionProperty.Jsii$Proxy that = (JoinInstructionProperty.Jsii$Proxy) o;

                if (!leftOperand.equals(that.leftOperand)) return false;
                if (!onClause.equals(that.onClause)) return false;
                if (!rightOperand.equals(that.rightOperand)) return false;
                if (!type.equals(that.type)) return false;
                if (this.leftJoinKeyProperties != null ? !this.leftJoinKeyProperties.equals(that.leftJoinKeyProperties) : that.leftJoinKeyProperties != null) return false;
                return this.rightJoinKeyProperties != null ? this.rightJoinKeyProperties.equals(that.rightJoinKeyProperties) : that.rightJoinKeyProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.leftOperand.hashCode();
                result = 31 * result + (this.onClause.hashCode());
                result = 31 * result + (this.rightOperand.hashCode());
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.leftJoinKeyProperties != null ? this.leftJoinKeyProperties.hashCode() : 0);
                result = 31 * result + (this.rightJoinKeyProperties != null ? this.rightJoinKeyProperties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Properties associated with the columns participating in a join.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * JoinKeyPropertiesProperty joinKeyPropertiesProperty = JoinKeyPropertiesProperty.builder()
     *         .uniqueKey(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinkeyproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinkeyproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.JoinKeyPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(JoinKeyPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JoinKeyPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A value that indicates that a row in a table is uniquely identified by the columns in a join key.
         * <p>
         * This is used by Quick Suite to optimize query performance.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinkeyproperties.html#cfn-quicksight-dataset-joinkeyproperties-uniquekey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinkeyproperties.html#cfn-quicksight-dataset-joinkeyproperties-uniquekey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUniqueKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JoinKeyPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JoinKeyPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JoinKeyPropertiesProperty> {
            java.lang.Object uniqueKey;

            /**
             * Sets the value of {@link JoinKeyPropertiesProperty#getUniqueKey}
             * @param uniqueKey A value that indicates that a row in a table is uniquely identified by the columns in a join key.
             *                  This is used by Quick Suite to optimize query performance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uniqueKey(java.lang.Boolean uniqueKey) {
                this.uniqueKey = uniqueKey;
                return this;
            }

            /**
             * Sets the value of {@link JoinKeyPropertiesProperty#getUniqueKey}
             * @param uniqueKey A value that indicates that a row in a table is uniquely identified by the columns in a join key.
             *                  This is used by Quick Suite to optimize query performance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uniqueKey(software.amazon.awscdk.IResolvable uniqueKey) {
                this.uniqueKey = uniqueKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JoinKeyPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JoinKeyPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JoinKeyPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JoinKeyPropertiesProperty {
            private final java.lang.Object uniqueKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.uniqueKey = software.amazon.jsii.Kernel.get(this, "uniqueKey", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.uniqueKey = builder.uniqueKey;
            }

            @Override
            public final java.lang.Object getUniqueKey() {
                return this.uniqueKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getUniqueKey() != null) {
                    data.set("uniqueKey", om.valueToTree(this.getUniqueKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.JoinKeyPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JoinKeyPropertiesProperty.Jsii$Proxy that = (JoinKeyPropertiesProperty.Jsii$Proxy) o;

                return this.uniqueKey != null ? this.uniqueKey.equals(that.uniqueKey) : that.uniqueKey == null;
            }

            @Override
            public final int hashCode() {
                int result = this.uniqueKey != null ? this.uniqueKey.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Properties that control how columns are handled for a join operand, including column name overrides.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * JoinOperandPropertiesProperty joinOperandPropertiesProperty = JoinOperandPropertiesProperty.builder()
     *         .outputColumnNameOverrides(List.of(OutputColumnNameOverrideProperty.builder()
     *                 .outputColumnName("outputColumnName")
     *                 // the properties below are optional
     *                 .sourceColumnName("sourceColumnName")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinoperandproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinoperandproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.JoinOperandPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(JoinOperandPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JoinOperandPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of column name overrides to apply to the join operand's output columns.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.OutputColumnNameOverrideProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinoperandproperties.html#cfn-quicksight-dataset-joinoperandproperties-outputcolumnnameoverrides">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinoperandproperties.html#cfn-quicksight-dataset-joinoperandproperties-outputcolumnnameoverrides</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOutputColumnNameOverrides();

        /**
         * @return a {@link Builder} of {@link JoinOperandPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JoinOperandPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JoinOperandPropertiesProperty> {
            java.lang.Object outputColumnNameOverrides;

            /**
             * Sets the value of {@link JoinOperandPropertiesProperty#getOutputColumnNameOverrides}
             * @param outputColumnNameOverrides A list of column name overrides to apply to the join operand's output columns. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputColumnNameOverrides(software.amazon.awscdk.IResolvable outputColumnNameOverrides) {
                this.outputColumnNameOverrides = outputColumnNameOverrides;
                return this;
            }

            /**
             * Sets the value of {@link JoinOperandPropertiesProperty#getOutputColumnNameOverrides}
             * @param outputColumnNameOverrides A list of column name overrides to apply to the join operand's output columns. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputColumnNameOverrides(java.util.List<? extends java.lang.Object> outputColumnNameOverrides) {
                this.outputColumnNameOverrides = outputColumnNameOverrides;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JoinOperandPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JoinOperandPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JoinOperandPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JoinOperandPropertiesProperty {
            private final java.lang.Object outputColumnNameOverrides;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.outputColumnNameOverrides = software.amazon.jsii.Kernel.get(this, "outputColumnNameOverrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.outputColumnNameOverrides = java.util.Objects.requireNonNull(builder.outputColumnNameOverrides, "outputColumnNameOverrides is required");
            }

            @Override
            public final java.lang.Object getOutputColumnNameOverrides() {
                return this.outputColumnNameOverrides;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("outputColumnNameOverrides", om.valueToTree(this.getOutputColumnNameOverrides()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.JoinOperandPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JoinOperandPropertiesProperty.Jsii$Proxy that = (JoinOperandPropertiesProperty.Jsii$Proxy) o;

                return this.outputColumnNameOverrides.equals(that.outputColumnNameOverrides);
            }

            @Override
            public final int hashCode() {
                int result = this.outputColumnNameOverrides.hashCode();
                return result;
            }
        }
    }
    /**
     * A transform operation that combines data from two sources based on specified join conditions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * JoinOperationProperty joinOperationProperty = JoinOperationProperty.builder()
     *         .alias("alias")
     *         .leftOperand(TransformOperationSourceProperty.builder()
     *                 .transformOperationId("transformOperationId")
     *                 // the properties below are optional
     *                 .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                         .sourceColumnId("sourceColumnId")
     *                         .targetColumnId("targetColumnId")
     *                         .build()))
     *                 .build())
     *         .onClause("onClause")
     *         .rightOperand(TransformOperationSourceProperty.builder()
     *                 .transformOperationId("transformOperationId")
     *                 // the properties below are optional
     *                 .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                         .sourceColumnId("sourceColumnId")
     *                         .targetColumnId("targetColumnId")
     *                         .build()))
     *                 .build())
     *         .type("type")
     *         // the properties below are optional
     *         .leftOperandProperties(JoinOperandPropertiesProperty.builder()
     *                 .outputColumnNameOverrides(List.of(OutputColumnNameOverrideProperty.builder()
     *                         .outputColumnName("outputColumnName")
     *                         // the properties below are optional
     *                         .sourceColumnName("sourceColumnName")
     *                         .build()))
     *                 .build())
     *         .rightOperandProperties(JoinOperandPropertiesProperty.builder()
     *                 .outputColumnNameOverrides(List.of(OutputColumnNameOverrideProperty.builder()
     *                         .outputColumnName("outputColumnName")
     *                         // the properties below are optional
     *                         .sourceColumnName("sourceColumnName")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinoperation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinoperation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.JoinOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(JoinOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JoinOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Alias for this operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinoperation.html#cfn-quicksight-dataset-joinoperation-alias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinoperation.html#cfn-quicksight-dataset-joinoperation-alias</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlias();

        /**
         * The left operand for the join operation.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.TransformOperationSourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinoperation.html#cfn-quicksight-dataset-joinoperation-leftoperand">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinoperation.html#cfn-quicksight-dataset-joinoperation-leftoperand</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLeftOperand();

        /**
         * The join condition that specifies how to match rows between the left and right operands.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinoperation.html#cfn-quicksight-dataset-joinoperation-onclause">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinoperation.html#cfn-quicksight-dataset-joinoperation-onclause</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOnClause();

        /**
         * The right operand for the join operation.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.TransformOperationSourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinoperation.html#cfn-quicksight-dataset-joinoperation-rightoperand">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinoperation.html#cfn-quicksight-dataset-joinoperation-rightoperand</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRightOperand();

        /**
         * The type of join to perform, such as <code>INNER</code> , <code>LEFT</code> , <code>RIGHT</code> , or <code>OUTER</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinoperation.html#cfn-quicksight-dataset-joinoperation-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinoperation.html#cfn-quicksight-dataset-joinoperation-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Properties that control how the left operand's columns are handled in the join result.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.JoinOperandPropertiesProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinoperation.html#cfn-quicksight-dataset-joinoperation-leftoperandproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinoperation.html#cfn-quicksight-dataset-joinoperation-leftoperandproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLeftOperandProperties() {
            return null;
        }

        /**
         * Properties that control how the right operand's columns are handled in the join result.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.JoinOperandPropertiesProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinoperation.html#cfn-quicksight-dataset-joinoperation-rightoperandproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinoperation.html#cfn-quicksight-dataset-joinoperation-rightoperandproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRightOperandProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JoinOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JoinOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JoinOperationProperty> {
            java.lang.String alias;
            java.lang.Object leftOperand;
            java.lang.String onClause;
            java.lang.Object rightOperand;
            java.lang.String type;
            java.lang.Object leftOperandProperties;
            java.lang.Object rightOperandProperties;

            /**
             * Sets the value of {@link JoinOperationProperty#getAlias}
             * @param alias Alias for this operation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alias(java.lang.String alias) {
                this.alias = alias;
                return this;
            }

            /**
             * Sets the value of {@link JoinOperationProperty#getLeftOperand}
             * @param leftOperand The left operand for the join operation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder leftOperand(software.amazon.awscdk.IResolvable leftOperand) {
                this.leftOperand = leftOperand;
                return this;
            }

            /**
             * Sets the value of {@link JoinOperationProperty#getLeftOperand}
             * @param leftOperand The left operand for the join operation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder leftOperand(software.amazon.awscdk.services.quicksight.CfnDataSet.TransformOperationSourceProperty leftOperand) {
                this.leftOperand = leftOperand;
                return this;
            }

            /**
             * Sets the value of {@link JoinOperationProperty#getOnClause}
             * @param onClause The join condition that specifies how to match rows between the left and right operands. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onClause(java.lang.String onClause) {
                this.onClause = onClause;
                return this;
            }

            /**
             * Sets the value of {@link JoinOperationProperty#getRightOperand}
             * @param rightOperand The right operand for the join operation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rightOperand(software.amazon.awscdk.IResolvable rightOperand) {
                this.rightOperand = rightOperand;
                return this;
            }

            /**
             * Sets the value of {@link JoinOperationProperty#getRightOperand}
             * @param rightOperand The right operand for the join operation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rightOperand(software.amazon.awscdk.services.quicksight.CfnDataSet.TransformOperationSourceProperty rightOperand) {
                this.rightOperand = rightOperand;
                return this;
            }

            /**
             * Sets the value of {@link JoinOperationProperty#getType}
             * @param type The type of join to perform, such as <code>INNER</code> , <code>LEFT</code> , <code>RIGHT</code> , or <code>OUTER</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link JoinOperationProperty#getLeftOperandProperties}
             * @param leftOperandProperties Properties that control how the left operand's columns are handled in the join result.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder leftOperandProperties(software.amazon.awscdk.IResolvable leftOperandProperties) {
                this.leftOperandProperties = leftOperandProperties;
                return this;
            }

            /**
             * Sets the value of {@link JoinOperationProperty#getLeftOperandProperties}
             * @param leftOperandProperties Properties that control how the left operand's columns are handled in the join result.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder leftOperandProperties(software.amazon.awscdk.services.quicksight.CfnDataSet.JoinOperandPropertiesProperty leftOperandProperties) {
                this.leftOperandProperties = leftOperandProperties;
                return this;
            }

            /**
             * Sets the value of {@link JoinOperationProperty#getRightOperandProperties}
             * @param rightOperandProperties Properties that control how the right operand's columns are handled in the join result.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rightOperandProperties(software.amazon.awscdk.IResolvable rightOperandProperties) {
                this.rightOperandProperties = rightOperandProperties;
                return this;
            }

            /**
             * Sets the value of {@link JoinOperationProperty#getRightOperandProperties}
             * @param rightOperandProperties Properties that control how the right operand's columns are handled in the join result.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rightOperandProperties(software.amazon.awscdk.services.quicksight.CfnDataSet.JoinOperandPropertiesProperty rightOperandProperties) {
                this.rightOperandProperties = rightOperandProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JoinOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JoinOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JoinOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JoinOperationProperty {
            private final java.lang.String alias;
            private final java.lang.Object leftOperand;
            private final java.lang.String onClause;
            private final java.lang.Object rightOperand;
            private final java.lang.String type;
            private final java.lang.Object leftOperandProperties;
            private final java.lang.Object rightOperandProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.leftOperand = software.amazon.jsii.Kernel.get(this, "leftOperand", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.onClause = software.amazon.jsii.Kernel.get(this, "onClause", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rightOperand = software.amazon.jsii.Kernel.get(this, "rightOperand", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.leftOperandProperties = software.amazon.jsii.Kernel.get(this, "leftOperandProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rightOperandProperties = software.amazon.jsii.Kernel.get(this, "rightOperandProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alias = java.util.Objects.requireNonNull(builder.alias, "alias is required");
                this.leftOperand = java.util.Objects.requireNonNull(builder.leftOperand, "leftOperand is required");
                this.onClause = java.util.Objects.requireNonNull(builder.onClause, "onClause is required");
                this.rightOperand = java.util.Objects.requireNonNull(builder.rightOperand, "rightOperand is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.leftOperandProperties = builder.leftOperandProperties;
                this.rightOperandProperties = builder.rightOperandProperties;
            }

            @Override
            public final java.lang.String getAlias() {
                return this.alias;
            }

            @Override
            public final java.lang.Object getLeftOperand() {
                return this.leftOperand;
            }

            @Override
            public final java.lang.String getOnClause() {
                return this.onClause;
            }

            @Override
            public final java.lang.Object getRightOperand() {
                return this.rightOperand;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getLeftOperandProperties() {
                return this.leftOperandProperties;
            }

            @Override
            public final java.lang.Object getRightOperandProperties() {
                return this.rightOperandProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alias", om.valueToTree(this.getAlias()));
                data.set("leftOperand", om.valueToTree(this.getLeftOperand()));
                data.set("onClause", om.valueToTree(this.getOnClause()));
                data.set("rightOperand", om.valueToTree(this.getRightOperand()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getLeftOperandProperties() != null) {
                    data.set("leftOperandProperties", om.valueToTree(this.getLeftOperandProperties()));
                }
                if (this.getRightOperandProperties() != null) {
                    data.set("rightOperandProperties", om.valueToTree(this.getRightOperandProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.JoinOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JoinOperationProperty.Jsii$Proxy that = (JoinOperationProperty.Jsii$Proxy) o;

                if (!alias.equals(that.alias)) return false;
                if (!leftOperand.equals(that.leftOperand)) return false;
                if (!onClause.equals(that.onClause)) return false;
                if (!rightOperand.equals(that.rightOperand)) return false;
                if (!type.equals(that.type)) return false;
                if (this.leftOperandProperties != null ? !this.leftOperandProperties.equals(that.leftOperandProperties) : that.leftOperandProperties != null) return false;
                return this.rightOperandProperties != null ? this.rightOperandProperties.equals(that.rightOperandProperties) : that.rightOperandProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alias.hashCode();
                result = 31 * result + (this.leftOperand.hashCode());
                result = 31 * result + (this.onClause.hashCode());
                result = 31 * result + (this.rightOperand.hashCode());
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.leftOperandProperties != null ? this.leftOperandProperties.hashCode() : 0);
                result = 31 * result + (this.rightOperandProperties != null ? this.rightOperandProperties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <p>A <i>logical table</i> is a unit that joins and that data             transformations operate on.
     * <p>
     * A logical table has a source, which can be either a physical
     * table or result of a join. When a logical table points to a physical table, the logical
     * table acts as a mutable copy of that physical table through transform operations.</p>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * LogicalTableProperty logicalTableProperty = LogicalTableProperty.builder()
     *         .alias("alias")
     *         .source(LogicalTableSourceProperty.builder()
     *                 .dataSetArn("dataSetArn")
     *                 .joinInstruction(JoinInstructionProperty.builder()
     *                         .leftOperand("leftOperand")
     *                         .onClause("onClause")
     *                         .rightOperand("rightOperand")
     *                         .type("type")
     *                         // the properties below are optional
     *                         .leftJoinKeyProperties(JoinKeyPropertiesProperty.builder()
     *                                 .uniqueKey(false)
     *                                 .build())
     *                         .rightJoinKeyProperties(JoinKeyPropertiesProperty.builder()
     *                                 .uniqueKey(false)
     *                                 .build())
     *                         .build())
     *                 .physicalTableId("physicalTableId")
     *                 .build())
     *         // the properties below are optional
     *         .dataTransforms(List.of(TransformOperationProperty.builder()
     *                 .castColumnTypeOperation(CastColumnTypeOperationProperty.builder()
     *                         .columnName("columnName")
     *                         .newColumnType("newColumnType")
     *                         // the properties below are optional
     *                         .format("format")
     *                         .subType("subType")
     *                         .build())
     *                 .createColumnsOperation(CreateColumnsOperationProperty.builder()
     *                         .columns(List.of(CalculatedColumnProperty.builder()
     *                                 .columnId("columnId")
     *                                 .columnName("columnName")
     *                                 .expression("expression")
     *                                 .build()))
     *                         // the properties below are optional
     *                         .alias("alias")
     *                         .source(TransformOperationSourceProperty.builder()
     *                                 .transformOperationId("transformOperationId")
     *                                 // the properties below are optional
     *                                 .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                                         .sourceColumnId("sourceColumnId")
     *                                         .targetColumnId("targetColumnId")
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .filterOperation(FilterOperationProperty.builder()
     *                         .conditionExpression("conditionExpression")
     *                         .dateFilterCondition(DataSetDateFilterConditionProperty.builder()
     *                                 .columnName("columnName")
     *                                 .comparisonFilterCondition(DataSetDateComparisonFilterConditionProperty.builder()
     *                                         .operator("operator")
     *                                         // the properties below are optional
     *                                         .value(DataSetDateFilterValueProperty.builder()
     *                                                 .staticValue("staticValue")
     *                                                 .build())
     *                                         .build())
     *                                 .rangeFilterCondition(DataSetDateRangeFilterConditionProperty.builder()
     *                                         .includeMaximum(false)
     *                                         .includeMinimum(false)
     *                                         .rangeMaximum(DataSetDateFilterValueProperty.builder()
     *                                                 .staticValue("staticValue")
     *                                                 .build())
     *                                         .rangeMinimum(DataSetDateFilterValueProperty.builder()
     *                                                 .staticValue("staticValue")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .numericFilterCondition(DataSetNumericFilterConditionProperty.builder()
     *                                 .columnName("columnName")
     *                                 .comparisonFilterCondition(DataSetNumericComparisonFilterConditionProperty.builder()
     *                                         .operator("operator")
     *                                         // the properties below are optional
     *                                         .value(DataSetNumericFilterValueProperty.builder()
     *                                                 .staticValue(123)
     *                                                 .build())
     *                                         .build())
     *                                 .rangeFilterCondition(DataSetNumericRangeFilterConditionProperty.builder()
     *                                         .includeMaximum(false)
     *                                         .includeMinimum(false)
     *                                         .rangeMaximum(DataSetNumericFilterValueProperty.builder()
     *                                                 .staticValue(123)
     *                                                 .build())
     *                                         .rangeMinimum(DataSetNumericFilterValueProperty.builder()
     *                                                 .staticValue(123)
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .stringFilterCondition(DataSetStringFilterConditionProperty.builder()
     *                                 .columnName("columnName")
     *                                 .comparisonFilterCondition(DataSetStringComparisonFilterConditionProperty.builder()
     *                                         .operator("operator")
     *                                         // the properties below are optional
     *                                         .value(DataSetStringFilterValueProperty.builder()
     *                                                 .staticValue("staticValue")
     *                                                 .build())
     *                                         .build())
     *                                 .listFilterCondition(DataSetStringListFilterConditionProperty.builder()
     *                                         .operator("operator")
     *                                         // the properties below are optional
     *                                         .values(DataSetStringListFilterValueProperty.builder()
     *                                                 .staticValues(List.of("staticValues"))
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .overrideDatasetParameterOperation(OverrideDatasetParameterOperationProperty.builder()
     *                         .parameterName("parameterName")
     *                         // the properties below are optional
     *                         .newDefaultValues(NewDefaultValuesProperty.builder()
     *                                 .dateTimeStaticValues(List.of("dateTimeStaticValues"))
     *                                 .decimalStaticValues(List.of(123))
     *                                 .integerStaticValues(List.of(123))
     *                                 .stringStaticValues(List.of("stringStaticValues"))
     *                                 .build())
     *                         .newParameterName("newParameterName")
     *                         .build())
     *                 .projectOperation(ProjectOperationProperty.builder()
     *                         .alias("alias")
     *                         .projectedColumns(List.of("projectedColumns"))
     *                         .source(TransformOperationSourceProperty.builder()
     *                                 .transformOperationId("transformOperationId")
     *                                 // the properties below are optional
     *                                 .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                                         .sourceColumnId("sourceColumnId")
     *                                         .targetColumnId("targetColumnId")
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .renameColumnOperation(RenameColumnOperationProperty.builder()
     *                         .columnName("columnName")
     *                         .newColumnName("newColumnName")
     *                         .build())
     *                 .tagColumnOperation(TagColumnOperationProperty.builder()
     *                         .columnName("columnName")
     *                         .tags(List.of(ColumnTagProperty.builder()
     *                                 .columnDescription(ColumnDescriptionProperty.builder()
     *                                         .text("text")
     *                                         .build())
     *                                 .columnGeographicRole("columnGeographicRole")
     *                                 .build()))
     *                         .build())
     *                 .untagColumnOperation(UntagColumnOperationProperty.builder()
     *                         .columnName("columnName")
     *                         .tagNames(List.of("tagNames"))
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltable.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltable.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.LogicalTableProperty")
    @software.amazon.jsii.Jsii.Proxy(LogicalTableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogicalTableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * <p>A display name for the logical table.</p>.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltable.html#cfn-quicksight-dataset-logicaltable-alias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltable.html#cfn-quicksight-dataset-logicaltable-alias</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlias();

        /**
         * <p>Information about the source of a logical table.
         * <p>
         * This is a variant type structure. For
         * this structure to be valid, only one of the attributes can be non-null.</p>
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.LogicalTableSourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltable.html#cfn-quicksight-dataset-logicaltable-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltable.html#cfn-quicksight-dataset-logicaltable-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSource();

        /**
         * <p>Transform operations that act on this logical table.
         * <p>
         * For this structure to be valid, only one of the attributes can be non-null. </p>
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.TransformOperationProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltable.html#cfn-quicksight-dataset-logicaltable-datatransforms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltable.html#cfn-quicksight-dataset-logicaltable-datatransforms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataTransforms() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogicalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogicalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogicalTableProperty> {
            java.lang.String alias;
            java.lang.Object source;
            java.lang.Object dataTransforms;

            /**
             * Sets the value of {@link LogicalTableProperty#getAlias}
             * @param alias <p>A display name for the logical table.</p>. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alias(java.lang.String alias) {
                this.alias = alias;
                return this;
            }

            /**
             * Sets the value of {@link LogicalTableProperty#getSource}
             * @param source <p>Information about the source of a logical table. This parameter is required.
             *               This is a variant type structure. For
             *               this structure to be valid, only one of the attributes can be non-null.</p>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.IResolvable source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link LogicalTableProperty#getSource}
             * @param source <p>Information about the source of a logical table. This parameter is required.
             *               This is a variant type structure. For
             *               this structure to be valid, only one of the attributes can be non-null.</p>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.services.quicksight.CfnDataSet.LogicalTableSourceProperty source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link LogicalTableProperty#getDataTransforms}
             * @param dataTransforms <p>Transform operations that act on this logical table.
             *                       For this structure to be valid, only one of the attributes can be non-null. </p>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTransforms(software.amazon.awscdk.IResolvable dataTransforms) {
                this.dataTransforms = dataTransforms;
                return this;
            }

            /**
             * Sets the value of {@link LogicalTableProperty#getDataTransforms}
             * @param dataTransforms <p>Transform operations that act on this logical table.
             *                       For this structure to be valid, only one of the attributes can be non-null. </p>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTransforms(java.util.List<? extends java.lang.Object> dataTransforms) {
                this.dataTransforms = dataTransforms;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogicalTableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogicalTableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogicalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogicalTableProperty {
            private final java.lang.String alias;
            private final java.lang.Object source;
            private final java.lang.Object dataTransforms;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataTransforms = software.amazon.jsii.Kernel.get(this, "dataTransforms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alias = java.util.Objects.requireNonNull(builder.alias, "alias is required");
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
                this.dataTransforms = builder.dataTransforms;
            }

            @Override
            public final java.lang.String getAlias() {
                return this.alias;
            }

            @Override
            public final java.lang.Object getSource() {
                return this.source;
            }

            @Override
            public final java.lang.Object getDataTransforms() {
                return this.dataTransforms;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alias", om.valueToTree(this.getAlias()));
                data.set("source", om.valueToTree(this.getSource()));
                if (this.getDataTransforms() != null) {
                    data.set("dataTransforms", om.valueToTree(this.getDataTransforms()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.LogicalTableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogicalTableProperty.Jsii$Proxy that = (LogicalTableProperty.Jsii$Proxy) o;

                if (!alias.equals(that.alias)) return false;
                if (!source.equals(that.source)) return false;
                return this.dataTransforms != null ? this.dataTransforms.equals(that.dataTransforms) : that.dataTransforms == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alias.hashCode();
                result = 31 * result + (this.source.hashCode());
                result = 31 * result + (this.dataTransforms != null ? this.dataTransforms.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the source of a logical table.
     * <p>
     * This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * LogicalTableSourceProperty logicalTableSourceProperty = LogicalTableSourceProperty.builder()
     *         .dataSetArn("dataSetArn")
     *         .joinInstruction(JoinInstructionProperty.builder()
     *                 .leftOperand("leftOperand")
     *                 .onClause("onClause")
     *                 .rightOperand("rightOperand")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .leftJoinKeyProperties(JoinKeyPropertiesProperty.builder()
     *                         .uniqueKey(false)
     *                         .build())
     *                 .rightJoinKeyProperties(JoinKeyPropertiesProperty.builder()
     *                         .uniqueKey(false)
     *                         .build())
     *                 .build())
     *         .physicalTableId("physicalTableId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltablesource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltablesource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.LogicalTableSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(LogicalTableSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogicalTableSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Number (ARN) of the parent dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltablesource.html#cfn-quicksight-dataset-logicaltablesource-datasetarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltablesource.html#cfn-quicksight-dataset-logicaltablesource-datasetarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataSetArn() {
            return null;
        }

        /**
         * Specifies the result of a join of two logical tables.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.JoinInstructionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltablesource.html#cfn-quicksight-dataset-logicaltablesource-joininstruction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltablesource.html#cfn-quicksight-dataset-logicaltablesource-joininstruction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJoinInstruction() {
            return null;
        }

        /**
         * Physical table ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltablesource.html#cfn-quicksight-dataset-logicaltablesource-physicaltableid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltablesource.html#cfn-quicksight-dataset-logicaltablesource-physicaltableid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPhysicalTableId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogicalTableSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogicalTableSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogicalTableSourceProperty> {
            java.lang.String dataSetArn;
            java.lang.Object joinInstruction;
            java.lang.String physicalTableId;

            /**
             * Sets the value of {@link LogicalTableSourceProperty#getDataSetArn}
             * @param dataSetArn The Amazon Resource Number (ARN) of the parent dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetArn(java.lang.String dataSetArn) {
                this.dataSetArn = dataSetArn;
                return this;
            }

            /**
             * Sets the value of {@link LogicalTableSourceProperty#getJoinInstruction}
             * @param joinInstruction Specifies the result of a join of two logical tables.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder joinInstruction(software.amazon.awscdk.IResolvable joinInstruction) {
                this.joinInstruction = joinInstruction;
                return this;
            }

            /**
             * Sets the value of {@link LogicalTableSourceProperty#getJoinInstruction}
             * @param joinInstruction Specifies the result of a join of two logical tables.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder joinInstruction(software.amazon.awscdk.services.quicksight.CfnDataSet.JoinInstructionProperty joinInstruction) {
                this.joinInstruction = joinInstruction;
                return this;
            }

            /**
             * Sets the value of {@link LogicalTableSourceProperty#getPhysicalTableId}
             * @param physicalTableId Physical table ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder physicalTableId(java.lang.String physicalTableId) {
                this.physicalTableId = physicalTableId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogicalTableSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogicalTableSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogicalTableSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogicalTableSourceProperty {
            private final java.lang.String dataSetArn;
            private final java.lang.Object joinInstruction;
            private final java.lang.String physicalTableId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataSetArn = software.amazon.jsii.Kernel.get(this, "dataSetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.joinInstruction = software.amazon.jsii.Kernel.get(this, "joinInstruction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.physicalTableId = software.amazon.jsii.Kernel.get(this, "physicalTableId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataSetArn = builder.dataSetArn;
                this.joinInstruction = builder.joinInstruction;
                this.physicalTableId = builder.physicalTableId;
            }

            @Override
            public final java.lang.String getDataSetArn() {
                return this.dataSetArn;
            }

            @Override
            public final java.lang.Object getJoinInstruction() {
                return this.joinInstruction;
            }

            @Override
            public final java.lang.String getPhysicalTableId() {
                return this.physicalTableId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDataSetArn() != null) {
                    data.set("dataSetArn", om.valueToTree(this.getDataSetArn()));
                }
                if (this.getJoinInstruction() != null) {
                    data.set("joinInstruction", om.valueToTree(this.getJoinInstruction()));
                }
                if (this.getPhysicalTableId() != null) {
                    data.set("physicalTableId", om.valueToTree(this.getPhysicalTableId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.LogicalTableSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogicalTableSourceProperty.Jsii$Proxy that = (LogicalTableSourceProperty.Jsii$Proxy) o;

                if (this.dataSetArn != null ? !this.dataSetArn.equals(that.dataSetArn) : that.dataSetArn != null) return false;
                if (this.joinInstruction != null ? !this.joinInstruction.equals(that.joinInstruction) : that.joinInstruction != null) return false;
                return this.physicalTableId != null ? this.physicalTableId.equals(that.physicalTableId) : that.physicalTableId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataSetArn != null ? this.dataSetArn.hashCode() : 0;
                result = 31 * result + (this.joinInstruction != null ? this.joinInstruction.hashCode() : 0);
                result = 31 * result + (this.physicalTableId != null ? this.physicalTableId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The lookback window setup of an incremental refresh configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * LookbackWindowProperty lookbackWindowProperty = LookbackWindowProperty.builder()
     *         .columnName("columnName")
     *         .size(123)
     *         .sizeUnit("sizeUnit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-lookbackwindow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-lookbackwindow.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.LookbackWindowProperty")
    @software.amazon.jsii.Jsii.Proxy(LookbackWindowProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LookbackWindowProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the lookback window column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-lookbackwindow.html#cfn-quicksight-dataset-lookbackwindow-columnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-lookbackwindow.html#cfn-quicksight-dataset-lookbackwindow-columnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnName();

        /**
         * The lookback window column size.
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-lookbackwindow.html#cfn-quicksight-dataset-lookbackwindow-size">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-lookbackwindow.html#cfn-quicksight-dataset-lookbackwindow-size</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getSize();

        /**
         * The size unit that is used for the lookback window column.
         * <p>
         * Valid values for this structure are <code>HOUR</code> , <code>DAY</code> , and <code>WEEK</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-lookbackwindow.html#cfn-quicksight-dataset-lookbackwindow-sizeunit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-lookbackwindow.html#cfn-quicksight-dataset-lookbackwindow-sizeunit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSizeUnit();

        /**
         * @return a {@link Builder} of {@link LookbackWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LookbackWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LookbackWindowProperty> {
            java.lang.String columnName;
            java.lang.Number size;
            java.lang.String sizeUnit;

            /**
             * Sets the value of {@link LookbackWindowProperty#getColumnName}
             * @param columnName The name of the lookback window column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link LookbackWindowProperty#getSize}
             * @param size The lookback window column size. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder size(java.lang.Number size) {
                this.size = size;
                return this;
            }

            /**
             * Sets the value of {@link LookbackWindowProperty#getSizeUnit}
             * @param sizeUnit The size unit that is used for the lookback window column. This parameter is required.
             *                 Valid values for this structure are <code>HOUR</code> , <code>DAY</code> , and <code>WEEK</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeUnit(java.lang.String sizeUnit) {
                this.sizeUnit = sizeUnit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LookbackWindowProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LookbackWindowProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LookbackWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LookbackWindowProperty {
            private final java.lang.String columnName;
            private final java.lang.Number size;
            private final java.lang.String sizeUnit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.size = software.amazon.jsii.Kernel.get(this, "size", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sizeUnit = software.amazon.jsii.Kernel.get(this, "sizeUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnName = java.util.Objects.requireNonNull(builder.columnName, "columnName is required");
                this.size = java.util.Objects.requireNonNull(builder.size, "size is required");
                this.sizeUnit = java.util.Objects.requireNonNull(builder.sizeUnit, "sizeUnit is required");
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.lang.Number getSize() {
                return this.size;
            }

            @Override
            public final java.lang.String getSizeUnit() {
                return this.sizeUnit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnName", om.valueToTree(this.getColumnName()));
                data.set("size", om.valueToTree(this.getSize()));
                data.set("sizeUnit", om.valueToTree(this.getSizeUnit()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.LookbackWindowProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LookbackWindowProperty.Jsii$Proxy that = (LookbackWindowProperty.Jsii$Proxy) o;

                if (!columnName.equals(that.columnName)) return false;
                if (!size.equals(that.size)) return false;
                return this.sizeUnit.equals(that.sizeUnit);
            }

            @Override
            public final int hashCode() {
                int result = this.columnName.hashCode();
                result = 31 * result + (this.size.hashCode());
                result = 31 * result + (this.sizeUnit.hashCode());
                return result;
            }
        }
    }
    /**
     * The new default values for the parameter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * NewDefaultValuesProperty newDefaultValuesProperty = NewDefaultValuesProperty.builder()
     *         .dateTimeStaticValues(List.of("dateTimeStaticValues"))
     *         .decimalStaticValues(List.of(123))
     *         .integerStaticValues(List.of(123))
     *         .stringStaticValues(List.of("stringStaticValues"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-newdefaultvalues.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-newdefaultvalues.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.NewDefaultValuesProperty")
    @software.amazon.jsii.Jsii.Proxy(NewDefaultValuesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NewDefaultValuesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of static default values for a given date time parameter.
         * <p>
         * The valid format for this property is <code>yyyy-MM-dd’T’HH:mm:ss’Z’</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-newdefaultvalues.html#cfn-quicksight-dataset-newdefaultvalues-datetimestaticvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-newdefaultvalues.html#cfn-quicksight-dataset-newdefaultvalues-datetimestaticvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDateTimeStaticValues() {
            return null;
        }

        /**
         * A list of static default values for a given decimal parameter.
         * <p>
         * Returns union: either List<{@link java.lang.Number}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-newdefaultvalues.html#cfn-quicksight-dataset-newdefaultvalues-decimalstaticvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-newdefaultvalues.html#cfn-quicksight-dataset-newdefaultvalues-decimalstaticvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDecimalStaticValues() {
            return null;
        }

        /**
         * A list of static default values for a given integer parameter.
         * <p>
         * Returns union: either List<{@link java.lang.Number}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-newdefaultvalues.html#cfn-quicksight-dataset-newdefaultvalues-integerstaticvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-newdefaultvalues.html#cfn-quicksight-dataset-newdefaultvalues-integerstaticvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIntegerStaticValues() {
            return null;
        }

        /**
         * A list of static default values for a given string parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-newdefaultvalues.html#cfn-quicksight-dataset-newdefaultvalues-stringstaticvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-newdefaultvalues.html#cfn-quicksight-dataset-newdefaultvalues-stringstaticvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStringStaticValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NewDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NewDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NewDefaultValuesProperty> {
            java.util.List<java.lang.String> dateTimeStaticValues;
            java.lang.Object decimalStaticValues;
            java.lang.Object integerStaticValues;
            java.util.List<java.lang.String> stringStaticValues;

            /**
             * Sets the value of {@link NewDefaultValuesProperty#getDateTimeStaticValues}
             * @param dateTimeStaticValues A list of static default values for a given date time parameter.
             *                             The valid format for this property is <code>yyyy-MM-dd’T’HH:mm:ss’Z’</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateTimeStaticValues(java.util.List<java.lang.String> dateTimeStaticValues) {
                this.dateTimeStaticValues = dateTimeStaticValues;
                return this;
            }

            /**
             * Sets the value of {@link NewDefaultValuesProperty#getDecimalStaticValues}
             * @param decimalStaticValues A list of static default values for a given decimal parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decimalStaticValues(java.util.List<? extends java.lang.Number> decimalStaticValues) {
                this.decimalStaticValues = decimalStaticValues;
                return this;
            }

            /**
             * Sets the value of {@link NewDefaultValuesProperty#getDecimalStaticValues}
             * @param decimalStaticValues A list of static default values for a given decimal parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decimalStaticValues(software.amazon.awscdk.IResolvable decimalStaticValues) {
                this.decimalStaticValues = decimalStaticValues;
                return this;
            }

            /**
             * Sets the value of {@link NewDefaultValuesProperty#getIntegerStaticValues}
             * @param integerStaticValues A list of static default values for a given integer parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integerStaticValues(java.util.List<? extends java.lang.Number> integerStaticValues) {
                this.integerStaticValues = integerStaticValues;
                return this;
            }

            /**
             * Sets the value of {@link NewDefaultValuesProperty#getIntegerStaticValues}
             * @param integerStaticValues A list of static default values for a given integer parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integerStaticValues(software.amazon.awscdk.IResolvable integerStaticValues) {
                this.integerStaticValues = integerStaticValues;
                return this;
            }

            /**
             * Sets the value of {@link NewDefaultValuesProperty#getStringStaticValues}
             * @param stringStaticValues A list of static default values for a given string parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringStaticValues(java.util.List<java.lang.String> stringStaticValues) {
                this.stringStaticValues = stringStaticValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NewDefaultValuesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NewDefaultValuesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NewDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NewDefaultValuesProperty {
            private final java.util.List<java.lang.String> dateTimeStaticValues;
            private final java.lang.Object decimalStaticValues;
            private final java.lang.Object integerStaticValues;
            private final java.util.List<java.lang.String> stringStaticValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dateTimeStaticValues = software.amazon.jsii.Kernel.get(this, "dateTimeStaticValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.decimalStaticValues = software.amazon.jsii.Kernel.get(this, "decimalStaticValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.integerStaticValues = software.amazon.jsii.Kernel.get(this, "integerStaticValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stringStaticValues = software.amazon.jsii.Kernel.get(this, "stringStaticValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dateTimeStaticValues = builder.dateTimeStaticValues;
                this.decimalStaticValues = builder.decimalStaticValues;
                this.integerStaticValues = builder.integerStaticValues;
                this.stringStaticValues = builder.stringStaticValues;
            }

            @Override
            public final java.util.List<java.lang.String> getDateTimeStaticValues() {
                return this.dateTimeStaticValues;
            }

            @Override
            public final java.lang.Object getDecimalStaticValues() {
                return this.decimalStaticValues;
            }

            @Override
            public final java.lang.Object getIntegerStaticValues() {
                return this.integerStaticValues;
            }

            @Override
            public final java.util.List<java.lang.String> getStringStaticValues() {
                return this.stringStaticValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDateTimeStaticValues() != null) {
                    data.set("dateTimeStaticValues", om.valueToTree(this.getDateTimeStaticValues()));
                }
                if (this.getDecimalStaticValues() != null) {
                    data.set("decimalStaticValues", om.valueToTree(this.getDecimalStaticValues()));
                }
                if (this.getIntegerStaticValues() != null) {
                    data.set("integerStaticValues", om.valueToTree(this.getIntegerStaticValues()));
                }
                if (this.getStringStaticValues() != null) {
                    data.set("stringStaticValues", om.valueToTree(this.getStringStaticValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.NewDefaultValuesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NewDefaultValuesProperty.Jsii$Proxy that = (NewDefaultValuesProperty.Jsii$Proxy) o;

                if (this.dateTimeStaticValues != null ? !this.dateTimeStaticValues.equals(that.dateTimeStaticValues) : that.dateTimeStaticValues != null) return false;
                if (this.decimalStaticValues != null ? !this.decimalStaticValues.equals(that.decimalStaticValues) : that.decimalStaticValues != null) return false;
                if (this.integerStaticValues != null ? !this.integerStaticValues.equals(that.integerStaticValues) : that.integerStaticValues != null) return false;
                return this.stringStaticValues != null ? this.stringStaticValues.equals(that.stringStaticValues) : that.stringStaticValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dateTimeStaticValues != null ? this.dateTimeStaticValues.hashCode() : 0;
                result = 31 * result + (this.decimalStaticValues != null ? this.decimalStaticValues.hashCode() : 0);
                result = 31 * result + (this.integerStaticValues != null ? this.integerStaticValues.hashCode() : 0);
                result = 31 * result + (this.stringStaticValues != null ? this.stringStaticValues.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a mapping to override the name of an output column from a transform operation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * OutputColumnNameOverrideProperty outputColumnNameOverrideProperty = OutputColumnNameOverrideProperty.builder()
     *         .outputColumnName("outputColumnName")
     *         // the properties below are optional
     *         .sourceColumnName("sourceColumnName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumnnameoverride.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumnnameoverride.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.OutputColumnNameOverrideProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputColumnNameOverrideProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputColumnNameOverrideProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The new name to assign to the column in the output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumnnameoverride.html#cfn-quicksight-dataset-outputcolumnnameoverride-outputcolumnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumnnameoverride.html#cfn-quicksight-dataset-outputcolumnnameoverride-outputcolumnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOutputColumnName();

        /**
         * The original name of the column from the source transform operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumnnameoverride.html#cfn-quicksight-dataset-outputcolumnnameoverride-sourcecolumnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumnnameoverride.html#cfn-quicksight-dataset-outputcolumnnameoverride-sourcecolumnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceColumnName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OutputColumnNameOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputColumnNameOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputColumnNameOverrideProperty> {
            java.lang.String outputColumnName;
            java.lang.String sourceColumnName;

            /**
             * Sets the value of {@link OutputColumnNameOverrideProperty#getOutputColumnName}
             * @param outputColumnName The new name to assign to the column in the output. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputColumnName(java.lang.String outputColumnName) {
                this.outputColumnName = outputColumnName;
                return this;
            }

            /**
             * Sets the value of {@link OutputColumnNameOverrideProperty#getSourceColumnName}
             * @param sourceColumnName The original name of the column from the source transform operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceColumnName(java.lang.String sourceColumnName) {
                this.sourceColumnName = sourceColumnName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputColumnNameOverrideProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputColumnNameOverrideProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputColumnNameOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputColumnNameOverrideProperty {
            private final java.lang.String outputColumnName;
            private final java.lang.String sourceColumnName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.outputColumnName = software.amazon.jsii.Kernel.get(this, "outputColumnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceColumnName = software.amazon.jsii.Kernel.get(this, "sourceColumnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.outputColumnName = java.util.Objects.requireNonNull(builder.outputColumnName, "outputColumnName is required");
                this.sourceColumnName = builder.sourceColumnName;
            }

            @Override
            public final java.lang.String getOutputColumnName() {
                return this.outputColumnName;
            }

            @Override
            public final java.lang.String getSourceColumnName() {
                return this.sourceColumnName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("outputColumnName", om.valueToTree(this.getOutputColumnName()));
                if (this.getSourceColumnName() != null) {
                    data.set("sourceColumnName", om.valueToTree(this.getSourceColumnName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.OutputColumnNameOverrideProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputColumnNameOverrideProperty.Jsii$Proxy that = (OutputColumnNameOverrideProperty.Jsii$Proxy) o;

                if (!outputColumnName.equals(that.outputColumnName)) return false;
                return this.sourceColumnName != null ? this.sourceColumnName.equals(that.sourceColumnName) : that.sourceColumnName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.outputColumnName.hashCode();
                result = 31 * result + (this.sourceColumnName != null ? this.sourceColumnName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Output column.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * OutputColumnProperty outputColumnProperty = OutputColumnProperty.builder()
     *         .description("description")
     *         .id("id")
     *         .name("name")
     *         .subType("subType")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.OutputColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A description for a column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html#cfn-quicksight-dataset-outputcolumn-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html#cfn-quicksight-dataset-outputcolumn-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * A unique identifier for the output column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html#cfn-quicksight-dataset-outputcolumn-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html#cfn-quicksight-dataset-outputcolumn-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getId() {
            return null;
        }

        /**
         * The display name of the column..
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html#cfn-quicksight-dataset-outputcolumn-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html#cfn-quicksight-dataset-outputcolumn-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The sub data type of the column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html#cfn-quicksight-dataset-outputcolumn-subtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html#cfn-quicksight-dataset-outputcolumn-subtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubType() {
            return null;
        }

        /**
         * The data type of the column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html#cfn-quicksight-dataset-outputcolumn-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html#cfn-quicksight-dataset-outputcolumn-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OutputColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputColumnProperty> {
            java.lang.String description;
            java.lang.String id;
            java.lang.String name;
            java.lang.String subType;
            java.lang.String type;

            /**
             * Sets the value of {@link OutputColumnProperty#getDescription}
             * @param description A description for a column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link OutputColumnProperty#getId}
             * @param id A unique identifier for the output column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link OutputColumnProperty#getName}
             * @param name The display name of the column..
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link OutputColumnProperty#getSubType}
             * @param subType The sub data type of the column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subType(java.lang.String subType) {
                this.subType = subType;
                return this;
            }

            /**
             * Sets the value of {@link OutputColumnProperty#getType}
             * @param type The data type of the column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputColumnProperty {
            private final java.lang.String description;
            private final java.lang.String id;
            private final java.lang.String name;
            private final java.lang.String subType;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subType = software.amazon.jsii.Kernel.get(this, "subType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.description = builder.description;
                this.id = builder.id;
                this.name = builder.name;
                this.subType = builder.subType;
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getSubType() {
                return this.subType;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getSubType() != null) {
                    data.set("subType", om.valueToTree(this.getSubType()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.OutputColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputColumnProperty.Jsii$Proxy that = (OutputColumnProperty.Jsii$Proxy) o;

                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.subType != null ? !this.subType.equals(that.subType) : that.subType != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.description != null ? this.description.hashCode() : 0;
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.subType != null ? this.subType.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A transform operation that overrides the dataset parameter values that are defined in another dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * OverrideDatasetParameterOperationProperty overrideDatasetParameterOperationProperty = OverrideDatasetParameterOperationProperty.builder()
     *         .parameterName("parameterName")
     *         // the properties below are optional
     *         .newDefaultValues(NewDefaultValuesProperty.builder()
     *                 .dateTimeStaticValues(List.of("dateTimeStaticValues"))
     *                 .decimalStaticValues(List.of(123))
     *                 .integerStaticValues(List.of(123))
     *                 .stringStaticValues(List.of("stringStaticValues"))
     *                 .build())
     *         .newParameterName("newParameterName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-overridedatasetparameteroperation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-overridedatasetparameteroperation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.OverrideDatasetParameterOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(OverrideDatasetParameterOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OverrideDatasetParameterOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the parameter to be overridden with different values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-overridedatasetparameteroperation.html#cfn-quicksight-dataset-overridedatasetparameteroperation-parametername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-overridedatasetparameteroperation.html#cfn-quicksight-dataset-overridedatasetparameteroperation-parametername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getParameterName();

        /**
         * The new default values for the parameter.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.NewDefaultValuesProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-overridedatasetparameteroperation.html#cfn-quicksight-dataset-overridedatasetparameteroperation-newdefaultvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-overridedatasetparameteroperation.html#cfn-quicksight-dataset-overridedatasetparameteroperation-newdefaultvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNewDefaultValues() {
            return null;
        }

        /**
         * The new name for the parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-overridedatasetparameteroperation.html#cfn-quicksight-dataset-overridedatasetparameteroperation-newparametername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-overridedatasetparameteroperation.html#cfn-quicksight-dataset-overridedatasetparameteroperation-newparametername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNewParameterName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OverrideDatasetParameterOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OverrideDatasetParameterOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OverrideDatasetParameterOperationProperty> {
            java.lang.String parameterName;
            java.lang.Object newDefaultValues;
            java.lang.String newParameterName;

            /**
             * Sets the value of {@link OverrideDatasetParameterOperationProperty#getParameterName}
             * @param parameterName The name of the parameter to be overridden with different values. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameterName(java.lang.String parameterName) {
                this.parameterName = parameterName;
                return this;
            }

            /**
             * Sets the value of {@link OverrideDatasetParameterOperationProperty#getNewDefaultValues}
             * @param newDefaultValues The new default values for the parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder newDefaultValues(software.amazon.awscdk.IResolvable newDefaultValues) {
                this.newDefaultValues = newDefaultValues;
                return this;
            }

            /**
             * Sets the value of {@link OverrideDatasetParameterOperationProperty#getNewDefaultValues}
             * @param newDefaultValues The new default values for the parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder newDefaultValues(software.amazon.awscdk.services.quicksight.CfnDataSet.NewDefaultValuesProperty newDefaultValues) {
                this.newDefaultValues = newDefaultValues;
                return this;
            }

            /**
             * Sets the value of {@link OverrideDatasetParameterOperationProperty#getNewParameterName}
             * @param newParameterName The new name for the parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder newParameterName(java.lang.String newParameterName) {
                this.newParameterName = newParameterName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OverrideDatasetParameterOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OverrideDatasetParameterOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OverrideDatasetParameterOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OverrideDatasetParameterOperationProperty {
            private final java.lang.String parameterName;
            private final java.lang.Object newDefaultValues;
            private final java.lang.String newParameterName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.parameterName = software.amazon.jsii.Kernel.get(this, "parameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.newDefaultValues = software.amazon.jsii.Kernel.get(this, "newDefaultValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.newParameterName = software.amazon.jsii.Kernel.get(this, "newParameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.parameterName = java.util.Objects.requireNonNull(builder.parameterName, "parameterName is required");
                this.newDefaultValues = builder.newDefaultValues;
                this.newParameterName = builder.newParameterName;
            }

            @Override
            public final java.lang.String getParameterName() {
                return this.parameterName;
            }

            @Override
            public final java.lang.Object getNewDefaultValues() {
                return this.newDefaultValues;
            }

            @Override
            public final java.lang.String getNewParameterName() {
                return this.newParameterName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("parameterName", om.valueToTree(this.getParameterName()));
                if (this.getNewDefaultValues() != null) {
                    data.set("newDefaultValues", om.valueToTree(this.getNewDefaultValues()));
                }
                if (this.getNewParameterName() != null) {
                    data.set("newParameterName", om.valueToTree(this.getNewParameterName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.OverrideDatasetParameterOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OverrideDatasetParameterOperationProperty.Jsii$Proxy that = (OverrideDatasetParameterOperationProperty.Jsii$Proxy) o;

                if (!parameterName.equals(that.parameterName)) return false;
                if (this.newDefaultValues != null ? !this.newDefaultValues.equals(that.newDefaultValues) : that.newDefaultValues != null) return false;
                return this.newParameterName != null ? this.newParameterName.equals(that.newParameterName) : that.newParameterName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.parameterName.hashCode();
                result = 31 * result + (this.newDefaultValues != null ? this.newDefaultValues.hashCode() : 0);
                result = 31 * result + (this.newParameterName != null ? this.newParameterName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * References a parent dataset that serves as a data source, including its columns and metadata.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ParentDataSetProperty parentDataSetProperty = ParentDataSetProperty.builder()
     *         .dataSetArn("dataSetArn")
     *         .inputColumns(List.of(InputColumnProperty.builder()
     *                 .name("name")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .id("id")
     *                 .subType("subType")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-parentdataset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-parentdataset.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.ParentDataSetProperty")
    @software.amazon.jsii.Jsii.Proxy(ParentDataSetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParentDataSetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the parent dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-parentdataset.html#cfn-quicksight-dataset-parentdataset-datasetarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-parentdataset.html#cfn-quicksight-dataset-parentdataset-datasetarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSetArn();

        /**
         * The list of input columns available from the parent dataset.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.InputColumnProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-parentdataset.html#cfn-quicksight-dataset-parentdataset-inputcolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-parentdataset.html#cfn-quicksight-dataset-parentdataset-inputcolumns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getInputColumns();

        /**
         * @return a {@link Builder} of {@link ParentDataSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParentDataSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParentDataSetProperty> {
            java.lang.String dataSetArn;
            java.lang.Object inputColumns;

            /**
             * Sets the value of {@link ParentDataSetProperty#getDataSetArn}
             * @param dataSetArn The Amazon Resource Name (ARN) of the parent dataset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetArn(java.lang.String dataSetArn) {
                this.dataSetArn = dataSetArn;
                return this;
            }

            /**
             * Sets the value of {@link ParentDataSetProperty#getInputColumns}
             * @param inputColumns The list of input columns available from the parent dataset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputColumns(software.amazon.awscdk.IResolvable inputColumns) {
                this.inputColumns = inputColumns;
                return this;
            }

            /**
             * Sets the value of {@link ParentDataSetProperty#getInputColumns}
             * @param inputColumns The list of input columns available from the parent dataset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputColumns(java.util.List<? extends java.lang.Object> inputColumns) {
                this.inputColumns = inputColumns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParentDataSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParentDataSetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParentDataSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParentDataSetProperty {
            private final java.lang.String dataSetArn;
            private final java.lang.Object inputColumns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataSetArn = software.amazon.jsii.Kernel.get(this, "dataSetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputColumns = software.amazon.jsii.Kernel.get(this, "inputColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataSetArn = java.util.Objects.requireNonNull(builder.dataSetArn, "dataSetArn is required");
                this.inputColumns = java.util.Objects.requireNonNull(builder.inputColumns, "inputColumns is required");
            }

            @Override
            public final java.lang.String getDataSetArn() {
                return this.dataSetArn;
            }

            @Override
            public final java.lang.Object getInputColumns() {
                return this.inputColumns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataSetArn", om.valueToTree(this.getDataSetArn()));
                data.set("inputColumns", om.valueToTree(this.getInputColumns()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.ParentDataSetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParentDataSetProperty.Jsii$Proxy that = (ParentDataSetProperty.Jsii$Proxy) o;

                if (!dataSetArn.equals(that.dataSetArn)) return false;
                return this.inputColumns.equals(that.inputColumns);
            }

            @Override
            public final int hashCode() {
                int result = this.dataSetArn.hashCode();
                result = 31 * result + (this.inputColumns.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * PerformanceConfigurationProperty performanceConfigurationProperty = PerformanceConfigurationProperty.builder()
     *         .uniqueKeys(List.of(UniqueKeyProperty.builder()
     *                 .columnNames(List.of("columnNames"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-performanceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-performanceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.PerformanceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PerformanceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PerformanceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.UniqueKeyProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-performanceconfiguration.html#cfn-quicksight-dataset-performanceconfiguration-uniquekeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-performanceconfiguration.html#cfn-quicksight-dataset-performanceconfiguration-uniquekeys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUniqueKeys() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PerformanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PerformanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PerformanceConfigurationProperty> {
            java.lang.Object uniqueKeys;

            /**
             * Sets the value of {@link PerformanceConfigurationProperty#getUniqueKeys}
             * @param uniqueKeys the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uniqueKeys(software.amazon.awscdk.IResolvable uniqueKeys) {
                this.uniqueKeys = uniqueKeys;
                return this;
            }

            /**
             * Sets the value of {@link PerformanceConfigurationProperty#getUniqueKeys}
             * @param uniqueKeys the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uniqueKeys(java.util.List<? extends java.lang.Object> uniqueKeys) {
                this.uniqueKeys = uniqueKeys;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PerformanceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PerformanceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PerformanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PerformanceConfigurationProperty {
            private final java.lang.Object uniqueKeys;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.uniqueKeys = software.amazon.jsii.Kernel.get(this, "uniqueKeys", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.uniqueKeys = builder.uniqueKeys;
            }

            @Override
            public final java.lang.Object getUniqueKeys() {
                return this.uniqueKeys;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getUniqueKeys() != null) {
                    data.set("uniqueKeys", om.valueToTree(this.getUniqueKeys()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.PerformanceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PerformanceConfigurationProperty.Jsii$Proxy that = (PerformanceConfigurationProperty.Jsii$Proxy) o;

                return this.uniqueKeys != null ? this.uniqueKeys.equals(that.uniqueKeys) : that.uniqueKeys == null;
            }

            @Override
            public final int hashCode() {
                int result = this.uniqueKeys != null ? this.uniqueKeys.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A view of a data source that contains information about the shape of the data in the underlying source.
     * <p>
     * This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * PhysicalTableProperty physicalTableProperty = PhysicalTableProperty.builder()
     *         .customSql(CustomSqlProperty.builder()
     *                 .columns(List.of(InputColumnProperty.builder()
     *                         .name("name")
     *                         .type("type")
     *                         // the properties below are optional
     *                         .id("id")
     *                         .subType("subType")
     *                         .build()))
     *                 .dataSourceArn("dataSourceArn")
     *                 .name("name")
     *                 .sqlQuery("sqlQuery")
     *                 .build())
     *         .relationalTable(RelationalTableProperty.builder()
     *                 .dataSourceArn("dataSourceArn")
     *                 .inputColumns(List.of(InputColumnProperty.builder()
     *                         .name("name")
     *                         .type("type")
     *                         // the properties below are optional
     *                         .id("id")
     *                         .subType("subType")
     *                         .build()))
     *                 .name("name")
     *                 // the properties below are optional
     *                 .catalog("catalog")
     *                 .schema("schema")
     *                 .build())
     *         .s3Source(S3SourceProperty.builder()
     *                 .dataSourceArn("dataSourceArn")
     *                 .inputColumns(List.of(InputColumnProperty.builder()
     *                         .name("name")
     *                         .type("type")
     *                         // the properties below are optional
     *                         .id("id")
     *                         .subType("subType")
     *                         .build()))
     *                 // the properties below are optional
     *                 .uploadSettings(UploadSettingsProperty.builder()
     *                         .containsHeader(false)
     *                         .delimiter("delimiter")
     *                         .format("format")
     *                         .startFromRow(123)
     *                         .textQualifier("textQualifier")
     *                         .build())
     *                 .build())
     *         .saaSTable(SaaSTableProperty.builder()
     *                 .dataSourceArn("dataSourceArn")
     *                 .inputColumns(List.of(InputColumnProperty.builder()
     *                         .name("name")
     *                         .type("type")
     *                         // the properties below are optional
     *                         .id("id")
     *                         .subType("subType")
     *                         .build()))
     *                 .tablePath(List.of(TablePathElementProperty.builder()
     *                         .id("id")
     *                         .name("name")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-physicaltable.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-physicaltable.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.PhysicalTableProperty")
    @software.amazon.jsii.Jsii.Proxy(PhysicalTableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PhysicalTableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A physical table type built from the results of the custom SQL query.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.CustomSqlProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-physicaltable.html#cfn-quicksight-dataset-physicaltable-customsql">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-physicaltable.html#cfn-quicksight-dataset-physicaltable-customsql</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomSql() {
            return null;
        }

        /**
         * A physical table type for relational data sources.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.RelationalTableProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-physicaltable.html#cfn-quicksight-dataset-physicaltable-relationaltable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-physicaltable.html#cfn-quicksight-dataset-physicaltable-relationaltable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRelationalTable() {
            return null;
        }

        /**
         * A physical table type for as S3 data source.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.S3SourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-physicaltable.html#cfn-quicksight-dataset-physicaltable-s3source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-physicaltable.html#cfn-quicksight-dataset-physicaltable-s3source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Source() {
            return null;
        }

        /**
         * A physical table type for Software-as-a-Service (SaaS) sources.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.SaaSTableProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-physicaltable.html#cfn-quicksight-dataset-physicaltable-saastable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-physicaltable.html#cfn-quicksight-dataset-physicaltable-saastable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSaaSTable() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PhysicalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PhysicalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PhysicalTableProperty> {
            java.lang.Object customSql;
            java.lang.Object relationalTable;
            java.lang.Object s3Source;
            java.lang.Object saaSTable;

            /**
             * Sets the value of {@link PhysicalTableProperty#getCustomSql}
             * @param customSql A physical table type built from the results of the custom SQL query.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customSql(software.amazon.awscdk.IResolvable customSql) {
                this.customSql = customSql;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalTableProperty#getCustomSql}
             * @param customSql A physical table type built from the results of the custom SQL query.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customSql(software.amazon.awscdk.services.quicksight.CfnDataSet.CustomSqlProperty customSql) {
                this.customSql = customSql;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalTableProperty#getRelationalTable}
             * @param relationalTable A physical table type for relational data sources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relationalTable(software.amazon.awscdk.IResolvable relationalTable) {
                this.relationalTable = relationalTable;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalTableProperty#getRelationalTable}
             * @param relationalTable A physical table type for relational data sources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relationalTable(software.amazon.awscdk.services.quicksight.CfnDataSet.RelationalTableProperty relationalTable) {
                this.relationalTable = relationalTable;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalTableProperty#getS3Source}
             * @param s3Source A physical table type for as S3 data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Source(software.amazon.awscdk.IResolvable s3Source) {
                this.s3Source = s3Source;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalTableProperty#getS3Source}
             * @param s3Source A physical table type for as S3 data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Source(software.amazon.awscdk.services.quicksight.CfnDataSet.S3SourceProperty s3Source) {
                this.s3Source = s3Source;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalTableProperty#getSaaSTable}
             * @param saaSTable A physical table type for Software-as-a-Service (SaaS) sources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder saaSTable(software.amazon.awscdk.IResolvable saaSTable) {
                this.saaSTable = saaSTable;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalTableProperty#getSaaSTable}
             * @param saaSTable A physical table type for Software-as-a-Service (SaaS) sources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder saaSTable(software.amazon.awscdk.services.quicksight.CfnDataSet.SaaSTableProperty saaSTable) {
                this.saaSTable = saaSTable;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PhysicalTableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PhysicalTableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PhysicalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PhysicalTableProperty {
            private final java.lang.Object customSql;
            private final java.lang.Object relationalTable;
            private final java.lang.Object s3Source;
            private final java.lang.Object saaSTable;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customSql = software.amazon.jsii.Kernel.get(this, "customSql", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.relationalTable = software.amazon.jsii.Kernel.get(this, "relationalTable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Source = software.amazon.jsii.Kernel.get(this, "s3Source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.saaSTable = software.amazon.jsii.Kernel.get(this, "saaSTable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customSql = builder.customSql;
                this.relationalTable = builder.relationalTable;
                this.s3Source = builder.s3Source;
                this.saaSTable = builder.saaSTable;
            }

            @Override
            public final java.lang.Object getCustomSql() {
                return this.customSql;
            }

            @Override
            public final java.lang.Object getRelationalTable() {
                return this.relationalTable;
            }

            @Override
            public final java.lang.Object getS3Source() {
                return this.s3Source;
            }

            @Override
            public final java.lang.Object getSaaSTable() {
                return this.saaSTable;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomSql() != null) {
                    data.set("customSql", om.valueToTree(this.getCustomSql()));
                }
                if (this.getRelationalTable() != null) {
                    data.set("relationalTable", om.valueToTree(this.getRelationalTable()));
                }
                if (this.getS3Source() != null) {
                    data.set("s3Source", om.valueToTree(this.getS3Source()));
                }
                if (this.getSaaSTable() != null) {
                    data.set("saaSTable", om.valueToTree(this.getSaaSTable()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.PhysicalTableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PhysicalTableProperty.Jsii$Proxy that = (PhysicalTableProperty.Jsii$Proxy) o;

                if (this.customSql != null ? !this.customSql.equals(that.customSql) : that.customSql != null) return false;
                if (this.relationalTable != null ? !this.relationalTable.equals(that.relationalTable) : that.relationalTable != null) return false;
                if (this.s3Source != null ? !this.s3Source.equals(that.s3Source) : that.s3Source != null) return false;
                return this.saaSTable != null ? this.saaSTable.equals(that.saaSTable) : that.saaSTable == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customSql != null ? this.customSql.hashCode() : 0;
                result = 31 * result + (this.relationalTable != null ? this.relationalTable.hashCode() : 0);
                result = 31 * result + (this.s3Source != null ? this.s3Source.hashCode() : 0);
                result = 31 * result + (this.saaSTable != null ? this.saaSTable.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for a pivot operation, specifying which column contains labels and how to pivot them.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * PivotConfigurationProperty pivotConfigurationProperty = PivotConfigurationProperty.builder()
     *         .pivotedLabels(List.of(PivotedLabelProperty.builder()
     *                 .labelName("labelName")
     *                 .newColumnId("newColumnId")
     *                 .newColumnName("newColumnName")
     *                 .build()))
     *         // the properties below are optional
     *         .labelColumnName("labelColumnName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.PivotConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PivotConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PivotConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of specific label values to pivot into separate columns.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.PivotedLabelProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotconfiguration.html#cfn-quicksight-dataset-pivotconfiguration-pivotedlabels">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotconfiguration.html#cfn-quicksight-dataset-pivotconfiguration-pivotedlabels</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPivotedLabels();

        /**
         * The name of the column that contains the labels to be pivoted into separate columns.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotconfiguration.html#cfn-quicksight-dataset-pivotconfiguration-labelcolumnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotconfiguration.html#cfn-quicksight-dataset-pivotconfiguration-labelcolumnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLabelColumnName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PivotConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PivotConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PivotConfigurationProperty> {
            java.lang.Object pivotedLabels;
            java.lang.String labelColumnName;

            /**
             * Sets the value of {@link PivotConfigurationProperty#getPivotedLabels}
             * @param pivotedLabels The list of specific label values to pivot into separate columns. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pivotedLabels(software.amazon.awscdk.IResolvable pivotedLabels) {
                this.pivotedLabels = pivotedLabels;
                return this;
            }

            /**
             * Sets the value of {@link PivotConfigurationProperty#getPivotedLabels}
             * @param pivotedLabels The list of specific label values to pivot into separate columns. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pivotedLabels(java.util.List<? extends java.lang.Object> pivotedLabels) {
                this.pivotedLabels = pivotedLabels;
                return this;
            }

            /**
             * Sets the value of {@link PivotConfigurationProperty#getLabelColumnName}
             * @param labelColumnName The name of the column that contains the labels to be pivoted into separate columns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder labelColumnName(java.lang.String labelColumnName) {
                this.labelColumnName = labelColumnName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PivotConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PivotConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PivotConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PivotConfigurationProperty {
            private final java.lang.Object pivotedLabels;
            private final java.lang.String labelColumnName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pivotedLabels = software.amazon.jsii.Kernel.get(this, "pivotedLabels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.labelColumnName = software.amazon.jsii.Kernel.get(this, "labelColumnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pivotedLabels = java.util.Objects.requireNonNull(builder.pivotedLabels, "pivotedLabels is required");
                this.labelColumnName = builder.labelColumnName;
            }

            @Override
            public final java.lang.Object getPivotedLabels() {
                return this.pivotedLabels;
            }

            @Override
            public final java.lang.String getLabelColumnName() {
                return this.labelColumnName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("pivotedLabels", om.valueToTree(this.getPivotedLabels()));
                if (this.getLabelColumnName() != null) {
                    data.set("labelColumnName", om.valueToTree(this.getLabelColumnName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.PivotConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PivotConfigurationProperty.Jsii$Proxy that = (PivotConfigurationProperty.Jsii$Proxy) o;

                if (!pivotedLabels.equals(that.pivotedLabels)) return false;
                return this.labelColumnName != null ? this.labelColumnName.equals(that.labelColumnName) : that.labelColumnName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.pivotedLabels.hashCode();
                result = 31 * result + (this.labelColumnName != null ? this.labelColumnName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A transform operation that pivots data by converting row values into columns.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * PivotOperationProperty pivotOperationProperty = PivotOperationProperty.builder()
     *         .alias("alias")
     *         .pivotConfiguration(PivotConfigurationProperty.builder()
     *                 .pivotedLabels(List.of(PivotedLabelProperty.builder()
     *                         .labelName("labelName")
     *                         .newColumnId("newColumnId")
     *                         .newColumnName("newColumnName")
     *                         .build()))
     *                 // the properties below are optional
     *                 .labelColumnName("labelColumnName")
     *                 .build())
     *         .source(TransformOperationSourceProperty.builder()
     *                 .transformOperationId("transformOperationId")
     *                 // the properties below are optional
     *                 .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                         .sourceColumnId("sourceColumnId")
     *                         .targetColumnId("targetColumnId")
     *                         .build()))
     *                 .build())
     *         .valueColumnConfiguration(ValueColumnConfigurationProperty.builder()
     *                 .aggregationFunction(DataPrepAggregationFunctionProperty.builder()
     *                         .listAggregation(DataPrepListAggregationFunctionProperty.builder()
     *                                 .distinct(false)
     *                                 .separator("separator")
     *                                 // the properties below are optional
     *                                 .inputColumnName("inputColumnName")
     *                                 .build())
     *                         .percentileAggregation(DataPrepPercentileAggregationFunctionProperty.builder()
     *                                 .percentileValue(123)
     *                                 // the properties below are optional
     *                                 .inputColumnName("inputColumnName")
     *                                 .build())
     *                         .simpleAggregation(DataPrepSimpleAggregationFunctionProperty.builder()
     *                                 .functionType("functionType")
     *                                 // the properties below are optional
     *                                 .inputColumnName("inputColumnName")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .groupByColumnNames(List.of("groupByColumnNames"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotoperation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotoperation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.PivotOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(PivotOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PivotOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Alias for this operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotoperation.html#cfn-quicksight-dataset-pivotoperation-alias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotoperation.html#cfn-quicksight-dataset-pivotoperation-alias</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlias();

        /**
         * Configuration that specifies which labels to pivot and how to structure the resulting columns.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.PivotConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotoperation.html#cfn-quicksight-dataset-pivotoperation-pivotconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotoperation.html#cfn-quicksight-dataset-pivotoperation-pivotconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPivotConfiguration();

        /**
         * The source transform operation that provides input data for pivoting.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.TransformOperationSourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotoperation.html#cfn-quicksight-dataset-pivotoperation-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotoperation.html#cfn-quicksight-dataset-pivotoperation-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSource();

        /**
         * Configuration for how to aggregate values when multiple rows map to the same pivoted column.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.ValueColumnConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotoperation.html#cfn-quicksight-dataset-pivotoperation-valuecolumnconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotoperation.html#cfn-quicksight-dataset-pivotoperation-valuecolumnconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValueColumnConfiguration();

        /**
         * The list of column names to group by when performing the pivot operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotoperation.html#cfn-quicksight-dataset-pivotoperation-groupbycolumnnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotoperation.html#cfn-quicksight-dataset-pivotoperation-groupbycolumnnames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGroupByColumnNames() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PivotOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PivotOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PivotOperationProperty> {
            java.lang.String alias;
            java.lang.Object pivotConfiguration;
            java.lang.Object source;
            java.lang.Object valueColumnConfiguration;
            java.util.List<java.lang.String> groupByColumnNames;

            /**
             * Sets the value of {@link PivotOperationProperty#getAlias}
             * @param alias Alias for this operation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alias(java.lang.String alias) {
                this.alias = alias;
                return this;
            }

            /**
             * Sets the value of {@link PivotOperationProperty#getPivotConfiguration}
             * @param pivotConfiguration Configuration that specifies which labels to pivot and how to structure the resulting columns. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pivotConfiguration(software.amazon.awscdk.IResolvable pivotConfiguration) {
                this.pivotConfiguration = pivotConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PivotOperationProperty#getPivotConfiguration}
             * @param pivotConfiguration Configuration that specifies which labels to pivot and how to structure the resulting columns. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pivotConfiguration(software.amazon.awscdk.services.quicksight.CfnDataSet.PivotConfigurationProperty pivotConfiguration) {
                this.pivotConfiguration = pivotConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PivotOperationProperty#getSource}
             * @param source The source transform operation that provides input data for pivoting. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.IResolvable source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link PivotOperationProperty#getSource}
             * @param source The source transform operation that provides input data for pivoting. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.services.quicksight.CfnDataSet.TransformOperationSourceProperty source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link PivotOperationProperty#getValueColumnConfiguration}
             * @param valueColumnConfiguration Configuration for how to aggregate values when multiple rows map to the same pivoted column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueColumnConfiguration(software.amazon.awscdk.IResolvable valueColumnConfiguration) {
                this.valueColumnConfiguration = valueColumnConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PivotOperationProperty#getValueColumnConfiguration}
             * @param valueColumnConfiguration Configuration for how to aggregate values when multiple rows map to the same pivoted column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueColumnConfiguration(software.amazon.awscdk.services.quicksight.CfnDataSet.ValueColumnConfigurationProperty valueColumnConfiguration) {
                this.valueColumnConfiguration = valueColumnConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PivotOperationProperty#getGroupByColumnNames}
             * @param groupByColumnNames The list of column names to group by when performing the pivot operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupByColumnNames(java.util.List<java.lang.String> groupByColumnNames) {
                this.groupByColumnNames = groupByColumnNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PivotOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PivotOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PivotOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PivotOperationProperty {
            private final java.lang.String alias;
            private final java.lang.Object pivotConfiguration;
            private final java.lang.Object source;
            private final java.lang.Object valueColumnConfiguration;
            private final java.util.List<java.lang.String> groupByColumnNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pivotConfiguration = software.amazon.jsii.Kernel.get(this, "pivotConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.valueColumnConfiguration = software.amazon.jsii.Kernel.get(this, "valueColumnConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.groupByColumnNames = software.amazon.jsii.Kernel.get(this, "groupByColumnNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alias = java.util.Objects.requireNonNull(builder.alias, "alias is required");
                this.pivotConfiguration = java.util.Objects.requireNonNull(builder.pivotConfiguration, "pivotConfiguration is required");
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
                this.valueColumnConfiguration = java.util.Objects.requireNonNull(builder.valueColumnConfiguration, "valueColumnConfiguration is required");
                this.groupByColumnNames = builder.groupByColumnNames;
            }

            @Override
            public final java.lang.String getAlias() {
                return this.alias;
            }

            @Override
            public final java.lang.Object getPivotConfiguration() {
                return this.pivotConfiguration;
            }

            @Override
            public final java.lang.Object getSource() {
                return this.source;
            }

            @Override
            public final java.lang.Object getValueColumnConfiguration() {
                return this.valueColumnConfiguration;
            }

            @Override
            public final java.util.List<java.lang.String> getGroupByColumnNames() {
                return this.groupByColumnNames;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alias", om.valueToTree(this.getAlias()));
                data.set("pivotConfiguration", om.valueToTree(this.getPivotConfiguration()));
                data.set("source", om.valueToTree(this.getSource()));
                data.set("valueColumnConfiguration", om.valueToTree(this.getValueColumnConfiguration()));
                if (this.getGroupByColumnNames() != null) {
                    data.set("groupByColumnNames", om.valueToTree(this.getGroupByColumnNames()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.PivotOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PivotOperationProperty.Jsii$Proxy that = (PivotOperationProperty.Jsii$Proxy) o;

                if (!alias.equals(that.alias)) return false;
                if (!pivotConfiguration.equals(that.pivotConfiguration)) return false;
                if (!source.equals(that.source)) return false;
                if (!valueColumnConfiguration.equals(that.valueColumnConfiguration)) return false;
                return this.groupByColumnNames != null ? this.groupByColumnNames.equals(that.groupByColumnNames) : that.groupByColumnNames == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alias.hashCode();
                result = 31 * result + (this.pivotConfiguration.hashCode());
                result = 31 * result + (this.source.hashCode());
                result = 31 * result + (this.valueColumnConfiguration.hashCode());
                result = 31 * result + (this.groupByColumnNames != null ? this.groupByColumnNames.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a label value to be pivoted into a separate column, including the new column name and identifier.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * PivotedLabelProperty pivotedLabelProperty = PivotedLabelProperty.builder()
     *         .labelName("labelName")
     *         .newColumnId("newColumnId")
     *         .newColumnName("newColumnName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotedlabel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotedlabel.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.PivotedLabelProperty")
    @software.amazon.jsii.Jsii.Proxy(PivotedLabelProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PivotedLabelProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The label value from the source data to be pivoted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotedlabel.html#cfn-quicksight-dataset-pivotedlabel-labelname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotedlabel.html#cfn-quicksight-dataset-pivotedlabel-labelname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLabelName();

        /**
         * A unique identifier for the new column created from this pivoted label.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotedlabel.html#cfn-quicksight-dataset-pivotedlabel-newcolumnid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotedlabel.html#cfn-quicksight-dataset-pivotedlabel-newcolumnid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNewColumnId();

        /**
         * The name for the new column created from this pivoted label.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotedlabel.html#cfn-quicksight-dataset-pivotedlabel-newcolumnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-pivotedlabel.html#cfn-quicksight-dataset-pivotedlabel-newcolumnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNewColumnName();

        /**
         * @return a {@link Builder} of {@link PivotedLabelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PivotedLabelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PivotedLabelProperty> {
            java.lang.String labelName;
            java.lang.String newColumnId;
            java.lang.String newColumnName;

            /**
             * Sets the value of {@link PivotedLabelProperty#getLabelName}
             * @param labelName The label value from the source data to be pivoted. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder labelName(java.lang.String labelName) {
                this.labelName = labelName;
                return this;
            }

            /**
             * Sets the value of {@link PivotedLabelProperty#getNewColumnId}
             * @param newColumnId A unique identifier for the new column created from this pivoted label. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder newColumnId(java.lang.String newColumnId) {
                this.newColumnId = newColumnId;
                return this;
            }

            /**
             * Sets the value of {@link PivotedLabelProperty#getNewColumnName}
             * @param newColumnName The name for the new column created from this pivoted label. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder newColumnName(java.lang.String newColumnName) {
                this.newColumnName = newColumnName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PivotedLabelProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PivotedLabelProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PivotedLabelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PivotedLabelProperty {
            private final java.lang.String labelName;
            private final java.lang.String newColumnId;
            private final java.lang.String newColumnName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.labelName = software.amazon.jsii.Kernel.get(this, "labelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.newColumnId = software.amazon.jsii.Kernel.get(this, "newColumnId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.newColumnName = software.amazon.jsii.Kernel.get(this, "newColumnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.labelName = java.util.Objects.requireNonNull(builder.labelName, "labelName is required");
                this.newColumnId = java.util.Objects.requireNonNull(builder.newColumnId, "newColumnId is required");
                this.newColumnName = java.util.Objects.requireNonNull(builder.newColumnName, "newColumnName is required");
            }

            @Override
            public final java.lang.String getLabelName() {
                return this.labelName;
            }

            @Override
            public final java.lang.String getNewColumnId() {
                return this.newColumnId;
            }

            @Override
            public final java.lang.String getNewColumnName() {
                return this.newColumnName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("labelName", om.valueToTree(this.getLabelName()));
                data.set("newColumnId", om.valueToTree(this.getNewColumnId()));
                data.set("newColumnName", om.valueToTree(this.getNewColumnName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.PivotedLabelProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PivotedLabelProperty.Jsii$Proxy that = (PivotedLabelProperty.Jsii$Proxy) o;

                if (!labelName.equals(that.labelName)) return false;
                if (!newColumnId.equals(that.newColumnId)) return false;
                return this.newColumnName.equals(that.newColumnName);
            }

            @Override
            public final int hashCode() {
                int result = this.labelName.hashCode();
                result = 31 * result + (this.newColumnId.hashCode());
                result = 31 * result + (this.newColumnName.hashCode());
                return result;
            }
        }
    }
    /**
     * A transform operation that projects columns.
     * <p>
     * Operations that come after a projection can only refer to projected columns.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ProjectOperationProperty projectOperationProperty = ProjectOperationProperty.builder()
     *         .alias("alias")
     *         .projectedColumns(List.of("projectedColumns"))
     *         .source(TransformOperationSourceProperty.builder()
     *                 .transformOperationId("transformOperationId")
     *                 // the properties below are optional
     *                 .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                         .sourceColumnId("sourceColumnId")
     *                         .targetColumnId("targetColumnId")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-projectoperation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-projectoperation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.ProjectOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(ProjectOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProjectOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Alias for this operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-projectoperation.html#cfn-quicksight-dataset-projectoperation-alias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-projectoperation.html#cfn-quicksight-dataset-projectoperation-alias</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlias() {
            return null;
        }

        /**
         * Projected columns.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-projectoperation.html#cfn-quicksight-dataset-projectoperation-projectedcolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-projectoperation.html#cfn-quicksight-dataset-projectoperation-projectedcolumns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getProjectedColumns() {
            return null;
        }

        /**
         * The source transform operation that provides input data for column projection.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.TransformOperationSourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-projectoperation.html#cfn-quicksight-dataset-projectoperation-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-projectoperation.html#cfn-quicksight-dataset-projectoperation-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProjectOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProjectOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProjectOperationProperty> {
            java.lang.String alias;
            java.util.List<java.lang.String> projectedColumns;
            java.lang.Object source;

            /**
             * Sets the value of {@link ProjectOperationProperty#getAlias}
             * @param alias Alias for this operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alias(java.lang.String alias) {
                this.alias = alias;
                return this;
            }

            /**
             * Sets the value of {@link ProjectOperationProperty#getProjectedColumns}
             * @param projectedColumns Projected columns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projectedColumns(java.util.List<java.lang.String> projectedColumns) {
                this.projectedColumns = projectedColumns;
                return this;
            }

            /**
             * Sets the value of {@link ProjectOperationProperty#getSource}
             * @param source The source transform operation that provides input data for column projection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.IResolvable source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link ProjectOperationProperty#getSource}
             * @param source The source transform operation that provides input data for column projection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.services.quicksight.CfnDataSet.TransformOperationSourceProperty source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProjectOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProjectOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProjectOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProjectOperationProperty {
            private final java.lang.String alias;
            private final java.util.List<java.lang.String> projectedColumns;
            private final java.lang.Object source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.projectedColumns = software.amazon.jsii.Kernel.get(this, "projectedColumns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alias = builder.alias;
                this.projectedColumns = builder.projectedColumns;
                this.source = builder.source;
            }

            @Override
            public final java.lang.String getAlias() {
                return this.alias;
            }

            @Override
            public final java.util.List<java.lang.String> getProjectedColumns() {
                return this.projectedColumns;
            }

            @Override
            public final java.lang.Object getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlias() != null) {
                    data.set("alias", om.valueToTree(this.getAlias()));
                }
                if (this.getProjectedColumns() != null) {
                    data.set("projectedColumns", om.valueToTree(this.getProjectedColumns()));
                }
                if (this.getSource() != null) {
                    data.set("source", om.valueToTree(this.getSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.ProjectOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProjectOperationProperty.Jsii$Proxy that = (ProjectOperationProperty.Jsii$Proxy) o;

                if (this.alias != null ? !this.alias.equals(that.alias) : that.alias != null) return false;
                if (this.projectedColumns != null ? !this.projectedColumns.equals(that.projectedColumns) : that.projectedColumns != null) return false;
                return this.source != null ? this.source.equals(that.source) : that.source == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alias != null ? this.alias.hashCode() : 0;
                result = 31 * result + (this.projectedColumns != null ? this.projectedColumns.hashCode() : 0);
                result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The refresh configuration of a dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * RefreshConfigurationProperty refreshConfigurationProperty = RefreshConfigurationProperty.builder()
     *         .incrementalRefresh(IncrementalRefreshProperty.builder()
     *                 .lookbackWindow(LookbackWindowProperty.builder()
     *                         .columnName("columnName")
     *                         .size(123)
     *                         .sizeUnit("sizeUnit")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.RefreshConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RefreshConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RefreshConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The incremental refresh for the dataset.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.IncrementalRefreshProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshconfiguration.html#cfn-quicksight-dataset-refreshconfiguration-incrementalrefresh">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshconfiguration.html#cfn-quicksight-dataset-refreshconfiguration-incrementalrefresh</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIncrementalRefresh();

        /**
         * @return a {@link Builder} of {@link RefreshConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RefreshConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RefreshConfigurationProperty> {
            java.lang.Object incrementalRefresh;

            /**
             * Sets the value of {@link RefreshConfigurationProperty#getIncrementalRefresh}
             * @param incrementalRefresh The incremental refresh for the dataset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder incrementalRefresh(software.amazon.awscdk.IResolvable incrementalRefresh) {
                this.incrementalRefresh = incrementalRefresh;
                return this;
            }

            /**
             * Sets the value of {@link RefreshConfigurationProperty#getIncrementalRefresh}
             * @param incrementalRefresh The incremental refresh for the dataset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder incrementalRefresh(software.amazon.awscdk.services.quicksight.CfnDataSet.IncrementalRefreshProperty incrementalRefresh) {
                this.incrementalRefresh = incrementalRefresh;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RefreshConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RefreshConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RefreshConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RefreshConfigurationProperty {
            private final java.lang.Object incrementalRefresh;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.incrementalRefresh = software.amazon.jsii.Kernel.get(this, "incrementalRefresh", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.incrementalRefresh = java.util.Objects.requireNonNull(builder.incrementalRefresh, "incrementalRefresh is required");
            }

            @Override
            public final java.lang.Object getIncrementalRefresh() {
                return this.incrementalRefresh;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("incrementalRefresh", om.valueToTree(this.getIncrementalRefresh()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.RefreshConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RefreshConfigurationProperty.Jsii$Proxy that = (RefreshConfigurationProperty.Jsii$Proxy) o;

                return this.incrementalRefresh.equals(that.incrementalRefresh);
            }

            @Override
            public final int hashCode() {
                int result = this.incrementalRefresh.hashCode();
                return result;
            }
        }
    }
    /**
     * The failure configuration of a dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * RefreshFailureConfigurationProperty refreshFailureConfigurationProperty = RefreshFailureConfigurationProperty.builder()
     *         .emailAlert(RefreshFailureEmailAlertProperty.builder()
     *                 .alertStatus("alertStatus")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshfailureconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshfailureconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.RefreshFailureConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RefreshFailureConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RefreshFailureConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The email alert configuration for a dataset refresh failure.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.RefreshFailureEmailAlertProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshfailureconfiguration.html#cfn-quicksight-dataset-refreshfailureconfiguration-emailalert">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshfailureconfiguration.html#cfn-quicksight-dataset-refreshfailureconfiguration-emailalert</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmailAlert() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RefreshFailureConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RefreshFailureConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RefreshFailureConfigurationProperty> {
            java.lang.Object emailAlert;

            /**
             * Sets the value of {@link RefreshFailureConfigurationProperty#getEmailAlert}
             * @param emailAlert The email alert configuration for a dataset refresh failure.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailAlert(software.amazon.awscdk.IResolvable emailAlert) {
                this.emailAlert = emailAlert;
                return this;
            }

            /**
             * Sets the value of {@link RefreshFailureConfigurationProperty#getEmailAlert}
             * @param emailAlert The email alert configuration for a dataset refresh failure.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailAlert(software.amazon.awscdk.services.quicksight.CfnDataSet.RefreshFailureEmailAlertProperty emailAlert) {
                this.emailAlert = emailAlert;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RefreshFailureConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RefreshFailureConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RefreshFailureConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RefreshFailureConfigurationProperty {
            private final java.lang.Object emailAlert;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.emailAlert = software.amazon.jsii.Kernel.get(this, "emailAlert", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.emailAlert = builder.emailAlert;
            }

            @Override
            public final java.lang.Object getEmailAlert() {
                return this.emailAlert;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEmailAlert() != null) {
                    data.set("emailAlert", om.valueToTree(this.getEmailAlert()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.RefreshFailureConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RefreshFailureConfigurationProperty.Jsii$Proxy that = (RefreshFailureConfigurationProperty.Jsii$Proxy) o;

                return this.emailAlert != null ? this.emailAlert.equals(that.emailAlert) : that.emailAlert == null;
            }

            @Override
            public final int hashCode() {
                int result = this.emailAlert != null ? this.emailAlert.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The configuration settings for the email alerts that are sent when a dataset refresh fails.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * RefreshFailureEmailAlertProperty refreshFailureEmailAlertProperty = RefreshFailureEmailAlertProperty.builder()
     *         .alertStatus("alertStatus")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshfailureemailalert.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshfailureemailalert.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.RefreshFailureEmailAlertProperty")
    @software.amazon.jsii.Jsii.Proxy(RefreshFailureEmailAlertProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RefreshFailureEmailAlertProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The status value that determines if email alerts are sent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshfailureemailalert.html#cfn-quicksight-dataset-refreshfailureemailalert-alertstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshfailureemailalert.html#cfn-quicksight-dataset-refreshfailureemailalert-alertstatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlertStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RefreshFailureEmailAlertProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RefreshFailureEmailAlertProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RefreshFailureEmailAlertProperty> {
            java.lang.String alertStatus;

            /**
             * Sets the value of {@link RefreshFailureEmailAlertProperty#getAlertStatus}
             * @param alertStatus The status value that determines if email alerts are sent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alertStatus(java.lang.String alertStatus) {
                this.alertStatus = alertStatus;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RefreshFailureEmailAlertProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RefreshFailureEmailAlertProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RefreshFailureEmailAlertProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RefreshFailureEmailAlertProperty {
            private final java.lang.String alertStatus;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alertStatus = software.amazon.jsii.Kernel.get(this, "alertStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alertStatus = builder.alertStatus;
            }

            @Override
            public final java.lang.String getAlertStatus() {
                return this.alertStatus;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlertStatus() != null) {
                    data.set("alertStatus", om.valueToTree(this.getAlertStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.RefreshFailureEmailAlertProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RefreshFailureEmailAlertProperty.Jsii$Proxy that = (RefreshFailureEmailAlertProperty.Jsii$Proxy) o;

                return this.alertStatus != null ? this.alertStatus.equals(that.alertStatus) : that.alertStatus == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alertStatus != null ? this.alertStatus.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A physical table type for relational data sources.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * RelationalTableProperty relationalTableProperty = RelationalTableProperty.builder()
     *         .dataSourceArn("dataSourceArn")
     *         .inputColumns(List.of(InputColumnProperty.builder()
     *                 .name("name")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .id("id")
     *                 .subType("subType")
     *                 .build()))
     *         .name("name")
     *         // the properties below are optional
     *         .catalog("catalog")
     *         .schema("schema")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.RelationalTableProperty")
    @software.amazon.jsii.Jsii.Proxy(RelationalTableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RelationalTableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) for the data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-datasourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-datasourcearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSourceArn();

        /**
         * The column schema of the table.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.InputColumnProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-inputcolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-inputcolumns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getInputColumns();

        /**
         * The name of the relational table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The catalog associated with a table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-catalog">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-catalog</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCatalog() {
            return null;
        }

        /**
         * The schema name.
         * <p>
         * This name applies to certain relational database engines.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-schema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-schema</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSchema() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RelationalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RelationalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RelationalTableProperty> {
            java.lang.String dataSourceArn;
            java.lang.Object inputColumns;
            java.lang.String name;
            java.lang.String catalog;
            java.lang.String schema;

            /**
             * Sets the value of {@link RelationalTableProperty#getDataSourceArn}
             * @param dataSourceArn The Amazon Resource Name (ARN) for the data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSourceArn(java.lang.String dataSourceArn) {
                this.dataSourceArn = dataSourceArn;
                return this;
            }

            /**
             * Sets the value of {@link RelationalTableProperty#getInputColumns}
             * @param inputColumns The column schema of the table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputColumns(software.amazon.awscdk.IResolvable inputColumns) {
                this.inputColumns = inputColumns;
                return this;
            }

            /**
             * Sets the value of {@link RelationalTableProperty#getInputColumns}
             * @param inputColumns The column schema of the table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputColumns(java.util.List<? extends java.lang.Object> inputColumns) {
                this.inputColumns = inputColumns;
                return this;
            }

            /**
             * Sets the value of {@link RelationalTableProperty#getName}
             * @param name The name of the relational table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RelationalTableProperty#getCatalog}
             * @param catalog The catalog associated with a table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalog(java.lang.String catalog) {
                this.catalog = catalog;
                return this;
            }

            /**
             * Sets the value of {@link RelationalTableProperty#getSchema}
             * @param schema The schema name.
             *               This name applies to certain relational database engines.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schema(java.lang.String schema) {
                this.schema = schema;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RelationalTableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RelationalTableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RelationalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RelationalTableProperty {
            private final java.lang.String dataSourceArn;
            private final java.lang.Object inputColumns;
            private final java.lang.String name;
            private final java.lang.String catalog;
            private final java.lang.String schema;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataSourceArn = software.amazon.jsii.Kernel.get(this, "dataSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputColumns = software.amazon.jsii.Kernel.get(this, "inputColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.catalog = software.amazon.jsii.Kernel.get(this, "catalog", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.schema = software.amazon.jsii.Kernel.get(this, "schema", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataSourceArn = java.util.Objects.requireNonNull(builder.dataSourceArn, "dataSourceArn is required");
                this.inputColumns = java.util.Objects.requireNonNull(builder.inputColumns, "inputColumns is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.catalog = builder.catalog;
                this.schema = builder.schema;
            }

            @Override
            public final java.lang.String getDataSourceArn() {
                return this.dataSourceArn;
            }

            @Override
            public final java.lang.Object getInputColumns() {
                return this.inputColumns;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getCatalog() {
                return this.catalog;
            }

            @Override
            public final java.lang.String getSchema() {
                return this.schema;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataSourceArn", om.valueToTree(this.getDataSourceArn()));
                data.set("inputColumns", om.valueToTree(this.getInputColumns()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getCatalog() != null) {
                    data.set("catalog", om.valueToTree(this.getCatalog()));
                }
                if (this.getSchema() != null) {
                    data.set("schema", om.valueToTree(this.getSchema()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.RelationalTableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RelationalTableProperty.Jsii$Proxy that = (RelationalTableProperty.Jsii$Proxy) o;

                if (!dataSourceArn.equals(that.dataSourceArn)) return false;
                if (!inputColumns.equals(that.inputColumns)) return false;
                if (!name.equals(that.name)) return false;
                if (this.catalog != null ? !this.catalog.equals(that.catalog) : that.catalog != null) return false;
                return this.schema != null ? this.schema.equals(that.schema) : that.schema == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataSourceArn.hashCode();
                result = 31 * result + (this.inputColumns.hashCode());
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.catalog != null ? this.catalog.hashCode() : 0);
                result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A transform operation that renames a column.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * RenameColumnOperationProperty renameColumnOperationProperty = RenameColumnOperationProperty.builder()
     *         .columnName("columnName")
     *         .newColumnName("newColumnName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnoperation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnoperation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.RenameColumnOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(RenameColumnOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RenameColumnOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the column to be renamed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnoperation.html#cfn-quicksight-dataset-renamecolumnoperation-columnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnoperation.html#cfn-quicksight-dataset-renamecolumnoperation-columnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnName();

        /**
         * The new name for the column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnoperation.html#cfn-quicksight-dataset-renamecolumnoperation-newcolumnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnoperation.html#cfn-quicksight-dataset-renamecolumnoperation-newcolumnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNewColumnName();

        /**
         * @return a {@link Builder} of {@link RenameColumnOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RenameColumnOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RenameColumnOperationProperty> {
            java.lang.String columnName;
            java.lang.String newColumnName;

            /**
             * Sets the value of {@link RenameColumnOperationProperty#getColumnName}
             * @param columnName The name of the column to be renamed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link RenameColumnOperationProperty#getNewColumnName}
             * @param newColumnName The new name for the column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder newColumnName(java.lang.String newColumnName) {
                this.newColumnName = newColumnName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RenameColumnOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RenameColumnOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RenameColumnOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RenameColumnOperationProperty {
            private final java.lang.String columnName;
            private final java.lang.String newColumnName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.newColumnName = software.amazon.jsii.Kernel.get(this, "newColumnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnName = java.util.Objects.requireNonNull(builder.columnName, "columnName is required");
                this.newColumnName = java.util.Objects.requireNonNull(builder.newColumnName, "newColumnName is required");
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.lang.String getNewColumnName() {
                return this.newColumnName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnName", om.valueToTree(this.getColumnName()));
                data.set("newColumnName", om.valueToTree(this.getNewColumnName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.RenameColumnOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RenameColumnOperationProperty.Jsii$Proxy that = (RenameColumnOperationProperty.Jsii$Proxy) o;

                if (!columnName.equals(that.columnName)) return false;
                return this.newColumnName.equals(that.newColumnName);
            }

            @Override
            public final int hashCode() {
                int result = this.columnName.hashCode();
                result = 31 * result + (this.newColumnName.hashCode());
                return result;
            }
        }
    }
    /**
     * A transform operation that renames one or more columns in the dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * RenameColumnsOperationProperty renameColumnsOperationProperty = RenameColumnsOperationProperty.builder()
     *         .alias("alias")
     *         .renameColumnOperations(List.of(RenameColumnOperationProperty.builder()
     *                 .columnName("columnName")
     *                 .newColumnName("newColumnName")
     *                 .build()))
     *         .source(TransformOperationSourceProperty.builder()
     *                 .transformOperationId("transformOperationId")
     *                 // the properties below are optional
     *                 .columnIdMappings(List.of(DataSetColumnIdMappingProperty.builder()
     *                         .sourceColumnId("sourceColumnId")
     *                         .targetColumnId("targetColumnId")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnsoperation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnsoperation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.RenameColumnsOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(RenameColumnsOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RenameColumnsOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Alias for this operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnsoperation.html#cfn-quicksight-dataset-renamecolumnsoperation-alias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnsoperation.html#cfn-quicksight-dataset-renamecolumnsoperation-alias</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlias();

        /**
         * The list of column rename operations to perform, specifying old and new column names.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.RenameColumnOperationProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnsoperation.html#cfn-quicksight-dataset-renamecolumnsoperation-renamecolumnoperations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnsoperation.html#cfn-quicksight-dataset-renamecolumnsoperation-renamecolumnoperations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRenameColumnOperations();

        /**
         * The source transform operation that provides input data for column renaming.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.TransformOperationSourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnsoperation.html#cfn-quicksight-dataset-renamecolumnsoperation-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnsoperation.html#cfn-quicksight-dataset-renamecolumnsoperation-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSource();

        /**
         * @return a {@link Builder} of {@link RenameColumnsOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RenameColumnsOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RenameColumnsOperationProperty> {
            java.lang.String alias;
            java.lang.Object renameColumnOperations;
            java.lang.Object source;

            /**
             * Sets the value of {@link RenameColumnsOperationProperty#getAlias}
             * @param alias Alias for this operation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alias(java.lang.String alias) {
                this.alias = alias;
                return this;
            }

            /**
             * Sets the value of {@link RenameColumnsOperationProperty#getRenameColumnOperations}
             * @param renameColumnOperations The list of column rename operations to perform, specifying old and new column names. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder renameColumnOperations(software.amazon.awscdk.IResolvable renameColumnOperations) {
                this.renameColumnOperations = renameColumnOperations;
                return this;
            }

            /**
             * Sets the value of {@link RenameColumnsOperationProperty#getRenameColumnOperations}
             * @param renameColumnOperations The list of column rename operations to perform, specifying old and new column names. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder renameColumnOperations(java.util.List<? extends java.lang.Object> renameColumnOperations) {
                this.renameColumnOperations = renameColumnOperations;
                return this;
            }

            /**
             * Sets the value of {@link RenameColumnsOperationProperty#getSource}
             * @param source The source transform operation that provides input data for column renaming. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.IResolvable source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link RenameColumnsOperationProperty#getSource}
             * @param source The source transform operation that provides input data for column renaming. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.services.quicksight.CfnDataSet.TransformOperationSourceProperty source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RenameColumnsOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RenameColumnsOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RenameColumnsOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RenameColumnsOperationProperty {
            private final java.lang.String alias;
            private final java.lang.Object renameColumnOperations;
            private final java.lang.Object source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.renameColumnOperations = software.amazon.jsii.Kernel.get(this, "renameColumnOperations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alias = java.util.Objects.requireNonNull(builder.alias, "alias is required");
                this.renameColumnOperations = java.util.Objects.requireNonNull(builder.renameColumnOperations, "renameColumnOperations is required");
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            }

            @Override
            public final java.lang.String getAlias() {
                return this.alias;
            }

            @Override
            public final java.lang.Object getRenameColumnOperations() {
                return this.renameColumnOperations;
            }

            @Override
            public final java.lang.Object getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alias", om.valueToTree(this.getAlias()));
                data.set("renameColumnOperations", om.valueToTree(this.getRenameColumnOperations()));
                data.set("source", om.valueToTree(this.getSource()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.RenameColumnsOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RenameColumnsOperationProperty.Jsii$Proxy that = (RenameColumnsOperationProperty.Jsii$Proxy) o;

                if (!alias.equals(that.alias)) return false;
                if (!renameColumnOperations.equals(that.renameColumnOperations)) return false;
                return this.source.equals(that.source);
            }

            @Override
            public final int hashCode() {
                int result = this.alias.hashCode();
                result = 31 * result + (this.renameColumnOperations.hashCode());
                result = 31 * result + (this.source.hashCode());
                return result;
            }
        }
    }
    /**
     * Permission for the resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ResourcePermissionProperty resourcePermissionProperty = ResourcePermissionProperty.builder()
     *         .actions(List.of("actions"))
     *         .principal("principal")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-resourcepermission.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-resourcepermission.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.ResourcePermissionProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourcePermissionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourcePermissionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IAM action to grant or revoke permisions on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-resourcepermission.html#cfn-quicksight-dataset-resourcepermission-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-resourcepermission.html#cfn-quicksight-dataset-resourcepermission-actions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getActions();

        /**
         * The Amazon Resource Name (ARN) of the principal. This can be one of the following:.
         * <p>
         * <ul>
         * <li>The ARN of an Amazon Quick Suite user or group associated with a data source or dataset. (This is common.)</li>
         * <li>The ARN of an Amazon Quick Suite user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</li>
         * <li>The ARN of an AWS account root: This is an IAM ARN rather than a Quick Suite ARN. Use this option only to share resources (templates) across AWS accounts . (This is less common.)</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-resourcepermission.html#cfn-quicksight-dataset-resourcepermission-principal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-resourcepermission.html#cfn-quicksight-dataset-resourcepermission-principal</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrincipal();

        /**
         * @return a {@link Builder} of {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourcePermissionProperty> {
            java.util.List<java.lang.String> actions;
            java.lang.String principal;

            /**
             * Sets the value of {@link ResourcePermissionProperty#getActions}
             * @param actions The IAM action to grant or revoke permisions on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(java.util.List<java.lang.String> actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link ResourcePermissionProperty#getPrincipal}
             * @param principal The Amazon Resource Name (ARN) of the principal. This can be one of the following:. This parameter is required.
             *                  <ul>
             *                  <li>The ARN of an Amazon Quick Suite user or group associated with a data source or dataset. (This is common.)</li>
             *                  <li>The ARN of an Amazon Quick Suite user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</li>
             *                  <li>The ARN of an AWS account root: This is an IAM ARN rather than a Quick Suite ARN. Use this option only to share resources (templates) across AWS accounts . (This is less common.)</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder principal(java.lang.String principal) {
                this.principal = principal;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourcePermissionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourcePermissionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourcePermissionProperty {
            private final java.util.List<java.lang.String> actions;
            private final java.lang.String principal;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.principal = software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
                this.principal = java.util.Objects.requireNonNull(builder.principal, "principal is required");
            }

            @Override
            public final java.util.List<java.lang.String> getActions() {
                return this.actions;
            }

            @Override
            public final java.lang.String getPrincipal() {
                return this.principal;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actions", om.valueToTree(this.getActions()));
                data.set("principal", om.valueToTree(this.getPrincipal()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.ResourcePermissionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourcePermissionProperty.Jsii$Proxy that = (ResourcePermissionProperty.Jsii$Proxy) o;

                if (!actions.equals(that.actions)) return false;
                return this.principal.equals(that.principal);
            }

            @Override
            public final int hashCode() {
                int result = this.actions.hashCode();
                result = 31 * result + (this.principal.hashCode());
                return result;
            }
        }
    }
    /**
     * Configuration for row level security.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * Object tagRuleConfigurations;
     * RowLevelPermissionConfigurationProperty rowLevelPermissionConfigurationProperty = RowLevelPermissionConfigurationProperty.builder()
     *         .rowLevelPermissionDataSet(RowLevelPermissionDataSetProperty.builder()
     *                 .arn("arn")
     *                 .permissionPolicy("permissionPolicy")
     *                 // the properties below are optional
     *                 .formatVersion("formatVersion")
     *                 .namespace("namespace")
     *                 .status("status")
     *                 .build())
     *         .tagConfiguration(RowLevelPermissionTagConfigurationProperty.builder()
     *                 .tagRules(List.of(RowLevelPermissionTagRuleProperty.builder()
     *                         .columnName("columnName")
     *                         .tagKey("tagKey")
     *                         // the properties below are optional
     *                         .matchAllValue("matchAllValue")
     *                         .tagMultiValueDelimiter("tagMultiValueDelimiter")
     *                         .build()))
     *                 // the properties below are optional
     *                 .status("status")
     *                 .tagRuleConfigurations(tagRuleConfigurations)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.RowLevelPermissionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RowLevelPermissionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RowLevelPermissionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * <p>Information about a dataset that contains permissions for row-level security (RLS).
         * <p>
         * The permissions dataset maps fields to users or groups. For more information, see
         * <a href="https://docs.aws.amazon.com/quicksight/latest/user/restrict-access-to-a-data-set-using-row-level-security.html">Using Row-Level Security (RLS) to Restrict Access to a Dataset</a> in the <i>Amazon QuickSight User
         * Guide</i>.</p>
         * <p>
         * <p>The option to deny permissions by setting <code>PermissionPolicy</code> to <code>DENY_ACCESS</code> is
         * not supported for new RLS datasets.</p>
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.RowLevelPermissionDataSetProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissionconfiguration.html#cfn-quicksight-dataset-rowlevelpermissionconfiguration-rowlevelpermissiondataset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissionconfiguration.html#cfn-quicksight-dataset-rowlevelpermissionconfiguration-rowlevelpermissiondataset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRowLevelPermissionDataSet() {
            return null;
        }

        /**
         * <p>The configuration of tags on a dataset to set row-level security.
         * <p>
         * </p>
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnDataSet.RowLevelPermissionTagConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissionconfiguration.html#cfn-quicksight-dataset-rowlevelpermissionconfiguration-tagconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissionconfiguration.html#cfn-quicksight-dataset-rowlevelpermissionconfiguration-tagconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RowLevelPermissionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RowLevelPermissionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RowLevelPermissionConfigurationProperty> {
            java.lang.Object rowLevelPermissionDataSet;
            java.lang.Object tagConfiguration;

            /**
             * Sets the value of {@link RowLevelPermissionConfigurationProperty#getRowLevelPermissionDataSet}
             * @param rowLevelPermissionDataSet <p>Information about a dataset that contains permissions for row-level security (RLS).
             *                                  The permissions dataset maps fields to users or groups. For more information, see
             *                                  <a href="https://docs.aws.amazon.com/quicksight/latest/user/restrict-access-to-a-data-set-using-row-level-security.html">Using Row-Level Security (RLS) to Restrict Access to a Dataset</a> in the <i>Amazon QuickSight User
             *                                  Guide</i>.</p>
             *                                  <p>
             *                                  <p>The option to deny permissions by setting <code>PermissionPolicy</code> to <code>DENY_ACCESS</code> is
             *                                  not supported for new RLS datasets.</p>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rowLevelPermissionDataSet(software.amazon.awscdk.IResolvable rowLevelPermissionDataSet) {
                this.rowLevelPermissionDataSet = rowLevelPermissionDataSet;
                return this;
            }

            /**
             * Sets the value of {@link RowLevelPermissionConfigurationProperty#getRowLevelPermissionDataSet}
             * @param rowLevelPermissionDataSet <p>Information about a dataset that contains permissions for row-level security (RLS).
             *                                  The permissions dataset maps fields to users or groups. For more information, see
             *                                  <a href="https://docs.aws.amazon.com/quicksight/latest/user/restrict-access-to-a-data-set-using-row-level-security.html">Using Row-Level Security (RLS) to Restrict Access to a Dataset</a> in the <i>Amazon QuickSight User
             *                                  Guide</i>.</p>
             *                                  <p>
             *                                  <p>The option to deny permissions by setting <code>PermissionPolicy</code> to <code>DENY_ACCESS</code> is
             *                                  not supported for new RLS datasets.</p>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rowLevelPermissionDataSet(software.amazon.awscdk.services.quicksight.CfnDataSet.RowLevelPermissionDataSetProperty rowLevelPermissionDataSet) {
                this.rowLevelPermissionDataSet = rowLevelPermissionDataSet;
                return this;
            }

            /**
             * Sets the value of {@link RowLevelPermissionConfigurationProperty#getTagConfiguration}
             * @param tagConfiguration <p>The configuration of tags on a dataset to set row-level security.
             *                         </p>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagConfiguration(software.amazon.awscdk.IResolvable tagConfiguration) {
                this.tagConfiguration = tagConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RowLevelPermissionConfigurationProperty#getTagConfiguration}
             * @param tagConfiguration <p>The configuration of tags on a dataset to set row-level security.
             *                         </p>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagConfiguration(software.amazon.awscdk.services.quicksight.CfnDataSet.RowLevelPermissionTagConfigurationProperty tagConfiguration) {
                this.tagConfiguration = tagConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RowLevelPermissionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RowLevelPermissionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RowLevelPermissionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RowLevelPermissionConfigurationProperty {
            private final java.lang.Object rowLevelPermissionDataSet;
            private final java.lang.Object tagConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rowLevelPermissionDataSet = software.amazon.jsii.Kernel.get(this, "rowLevelPermissionDataSet", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tagConfiguration = software.amazon.jsii.Kernel.get(this, "tagConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rowLevelPermissionDataSet = builder.rowLevelPermissionDataSet;
                this.tagConfiguration = builder.tagConfiguration;
            }

            @Override
            public final java.lang.Object getRowLevelPermissionDataSet() {
                return this.rowLevelPermissionDataSet;
            }

            @Override
            public final java.lang.Object getTagConfiguration() {
                return this.tagConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRowLevelPermissionDataSet() != null) {
                    data.set("rowLevelPermissionDataSet", om.valueToTree(this.getRowLevelPermissionDataSet()));
                }
                if (this.getTagConfiguration() != null) {
                    data.set("tagConfiguration", om.valueToTree(this.getTagConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.RowLevelPermissionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RowLevelPermissionConfigurationProperty.Jsii$Proxy that = (RowLevelPermissionConfigurationProperty.Jsii$Proxy) o;

                if (this.rowLevelPermissionDataSet != null ? !this.rowLevelPermissionDataSet.equals(that.rowLevelPermissionDataSet) : that.rowLevelPermissionDataSet != null) return false;
                return this.tagConfiguration != null ? this.tagConfiguration.equals(that.tagConfiguration) : that.tagConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.rowLevelPermissionDataSet != null ? this.rowLevelPermissionDataSet.hashCode() : 0;
                result = 31 * result + (this.tagConfiguration != null ? this.tagConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a dataset that contains permissions for row-level security (RLS).
     * <p>
     * The permissions dataset maps fields to users or groups. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/restrict-access-to-a-data-set-using-row-level-security.html">Using Row-Level Security (RLS) to Restrict Access to a Dataset</a> in the <em>Quick Sight User Guide</em> .
     * <p>
     * The option to deny permissions by setting <code>PermissionPolicy</code> to <code>DENY_ACCESS</code> is not supported for new RLS datasets.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * RowLevelPermissionDataSetProperty rowLevelPermissionDataSetProperty = RowLevelPermissionDataSetProperty.builder()
     *         .arn("arn")
     *         .permissionPolicy("permissionPolicy")
     *         // the properties below are optional
     *         .formatVersion("formatVersion")
     *         .namespace("namespace")
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.RowLevelPermissionDataSetProperty")
    @software.amazon.jsii.Jsii.Proxy(RowLevelPermissionDataSetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RowLevelPermissionDataSetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the dataset that contains permissions for RLS.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset-arn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * The type of permissions to use when interpreting the permissions for RLS.
         * <p>
         * <code>DENY_ACCESS</code> is included for backward compatibility only.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset-permissionpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset-permissionpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPermissionPolicy();

        /**
         * The user or group rules associated with the dataset that contains permissions for RLS.
         * <p>
         * By default, <code>FormatVersion</code> is <code>VERSION_1</code> . When <code>FormatVersion</code> is <code>VERSION_1</code> , <code>UserName</code> and <code>GroupName</code> are required. When <code>FormatVersion</code> is <code>VERSION_2</code> , <code>UserARN</code> and <code>GroupARN</code> are required, and <code>Namespace</code> must not exist.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset-formatversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset-formatversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFormatVersion() {
            return null;
        }

        /**
         * The namespace associated with the dataset that contains permissions for RLS.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-