package software.amazon.awscdk.services.rds;

/**
 * Create a clustered database with a given number of instances.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .engine(DatabaseClusterEngine.auroraMysql(AuroraMysqlClusterEngineProps.builder()
 *                 .version(AuroraMysqlEngineVersion.VER_3_03_0)
 *                 .build()))
 *         .writer(ClusterInstance.provisioned("writer"))
 *         .vpc(vpc)
 *         .build();
 * DatabaseProxy proxy = DatabaseProxy.Builder.create(this, "Proxy")
 *         .proxyTarget(ProxyTarget.fromCluster(cluster))
 *         .secrets(List.of(cluster.getSecret()))
 *         .vpc(vpc)
 *         .clientPasswordAuthType(ClientPasswordAuthType.MYSQL_NATIVE_PASSWORD)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:59.059Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.DatabaseCluster")
public class DatabaseCluster extends software.amazon.awscdk.services.rds.DatabaseClusterBase {

    protected DatabaseCluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseCluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseCluster.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DatabaseCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.DatabaseClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing DatabaseCluster from properties.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IDatabaseCluster fromDatabaseClusterAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.DatabaseClusterAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseCluster.class, "fromDatabaseClusterAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IDatabaseCluster.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Lookup an existing DatabaseCluster using clusterIdentifier.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IDatabaseCluster fromLookup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.DatabaseClusterLookupOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseCluster.class, "fromLookup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IDatabaseCluster.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds the multi user rotation to this cluster.
     * <p>
     * See <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets_strategies.html#rotating-secrets-two-users">Alternating users rotation strategy</a>
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotation addRotationMultiUser(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.RotationMultiUserOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addRotationMultiUser", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotation.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds the single user rotation of the master password to this cluster.
     * <p>
     * See <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets_strategies.html#rotating-secrets-one-user-one-password">Single user rotation strategy</a>
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotation addRotationSingleUser(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.RotationSingleUserOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addRotationSingleUser", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotation.class), new Object[] { options });
    }

    /**
     * Adds the single user rotation of the master password to this cluster.
     * <p>
     * See <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets_strategies.html#rotating-secrets-one-user-one-password">Single user rotation strategy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotation addRotationSingleUser() {
        return software.amazon.jsii.Kernel.call(this, "addRotationSingleUser", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotation.class));
    }

    /**
     * This value is represented as a percentage.
     * <p>
     * It's calculated as the value of the
     * ServerlessDatabaseCapacity metric divided by the maximum ACU value of the DB cluster.
     * <p>
     * If this metric approaches a value of 100.0, the DB instance has scaled up as high as it can.
     * Consider increasing the maximum ACU setting for the cluster.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricACUUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricACUUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * This value is represented as a percentage.
     * <p>
     * It's calculated as the value of the
     * ServerlessDatabaseCapacity metric divided by the maximum ACU value of the DB cluster.
     * <p>
     * If this metric approaches a value of 100.0, the DB instance has scaled up as high as it can.
     * Consider increasing the maximum ACU setting for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricACUUtilization() {
        return software.amazon.jsii.Kernel.call(this, "metricACUUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * As a cluster-level metric, it represents the average of the ServerlessDatabaseCapacity values of all the Aurora Serverless v2 DB instances in the cluster.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricServerlessDatabaseCapacity(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricServerlessDatabaseCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * As a cluster-level metric, it represents the average of the ServerlessDatabaseCapacity values of all the Aurora Serverless v2 DB instances in the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricServerlessDatabaseCapacity() {
        return software.amazon.jsii.Kernel.call(this, "metricServerlessDatabaseCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The log group is created when <code>cloudwatchLogsExports</code> is set.
     * <p>
     * Each export value will create a separate log group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.amazon.awscdk.services.logs.ILogGroup> getCloudwatchLogGroups() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cloudwatchLogGroups", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class))));
    }

    /**
     * The endpoint to use for read/write operations.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.Endpoint getClusterEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "clusterEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Endpoint.class));
    }

    /**
     * Identifier of the cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Endpoint to use for load-balanced read-only operations.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.Endpoint getClusterReadEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "clusterReadEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Endpoint.class));
    }

    /**
     * The immutable identifier for the cluster; for example: cluster-ABCD1234EFGH5678IJKL90MNOP.
     * <p>
     * This AWS Region-unique identifier is used in things like IAM authentication policies.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterResourceIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "clusterResourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Access to the network connections.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * Endpoints which address each individual replica.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.rds.Endpoint> getInstanceEndpoints() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "instanceEndpoints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Endpoint.class))));
    }

    /**
     * Identifiers of the replicas.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getInstanceIdentifiers() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "instanceIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Application for multi user rotation to this cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotationApplication getMultiUserRotationApplication() {
        return software.amazon.jsii.Kernel.get(this, "multiUserRotationApplication", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.CfnDBClusterProps getNewCfnProps() {
        return software.amazon.jsii.Kernel.get(this, "newCfnProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.CfnDBClusterProps.class));
    }

    /**
     * Whether Performance Insights is enabled at cluster level.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getPerformanceInsightsEnabled() {
        return software.amazon.jsii.Kernel.get(this, "performanceInsightsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class))));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Number getServerlessV2MaxCapacity() {
        return software.amazon.jsii.Kernel.get(this, "serverlessV2MaxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Number getServerlessV2MinCapacity() {
        return software.amazon.jsii.Kernel.get(this, "serverlessV2MinCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Application for single user rotation of the master password to this cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotationApplication getSingleUserRotationApplication() {
        return software.amazon.jsii.Kernel.get(this, "singleUserRotationApplication", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.ISubnetGroup getSubnetGroup() {
        return software.amazon.jsii.Kernel.get(this, "subnetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.ISubnetGroup.class));
    }

    /**
     * The VPC network to place the cluster in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
    }

    /**
     * The database insights mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.DatabaseInsightsMode getDatabaseInsightsMode() {
        return software.amazon.jsii.Kernel.get(this, "databaseInsightsMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.DatabaseInsightsMode.class));
    }

    /**
     * The engine for this Cluster.
     * <p>
     * Never undefined.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.IClusterEngine getEngine() {
        return software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterEngine.class));
    }

    /**
     * The IAM role for the enhanced monitoring.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getMonitoringRole() {
        return software.amazon.jsii.Kernel.get(this, "monitoringRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * The AWS KMS key for encryption of Performance Insights data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getPerformanceInsightEncryptionKey() {
        return software.amazon.jsii.Kernel.get(this, "performanceInsightEncryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * The amount of time, in days, to retain Performance Insights data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.PerformanceInsightRetention getPerformanceInsightRetention() {
        return software.amazon.jsii.Kernel.get(this, "performanceInsightRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PerformanceInsightRetention.class));
    }

    /**
     * The secret attached to this cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecret() {
        return software.amazon.jsii.Kernel.get(this, "secret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getServerlessV2AutoPauseDuration() {
        return software.amazon.jsii.Kernel.get(this, "serverlessV2AutoPauseDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
    }

    /**
     * The cluster's subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableDataApi() {
        return software.amazon.jsii.Kernel.get(this, "enableDataApi", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setEnableDataApi(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableDataApi", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.Boolean getHasServerlessInstance() {
        return software.amazon.jsii.Kernel.get(this, "hasServerlessInstance", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setHasServerlessInstance(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "hasServerlessInstance", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rds.DatabaseCluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rds.DatabaseCluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.rds.DatabaseClusterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.rds.DatabaseClusterProps.Builder();
        }

        /**
         * What kind of database to start.
         * <p>
         * @return {@code this}
         * @param engine What kind of database to start. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(final software.amazon.awscdk.services.rds.IClusterEngine engine) {
            this.props.engine(engine);
            return this;
        }

        /**
         * Specifies whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param autoMinorVersionUpgrade Specifies whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(final java.lang.Boolean autoMinorVersionUpgrade) {
            this.props.autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }

        /**
         * The number of seconds to set a cluster's target backtrack window to.
         * <p>
         * This feature is only supported by the Aurora MySQL database engine and
         * cannot be enabled on existing clusters.
         * <p>
         * Default: 0 seconds (no backtrack)
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Managing.Backtrack.html">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Managing.Backtrack.html</a>
         * @param backtrackWindow The number of seconds to set a cluster's target backtrack window to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backtrackWindow(final software.amazon.awscdk.Duration backtrackWindow) {
            this.props.backtrackWindow(backtrackWindow);
            return this;
        }

        /**
         * Backup settings.
         * <p>
         * Default: - Backup retention period for automated backups is 1 day.
         * Backup preferred window is set to a 30-minute window selected at random from an
         * 8-hour block of time for each AWS Region, occurring on a random day of the week.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow</a>
         * @param backup Backup settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backup(final software.amazon.awscdk.services.rds.BackupProps backup) {
            this.props.backup(backup);
            return this;
        }

        /**
         * The list of log types that need to be enabled for exporting to CloudWatch Logs.
         * <p>
         * Default: - no log exports
         * <p>
         * @return {@code this}
         * @param cloudwatchLogsExports The list of log types that need to be enabled for exporting to CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudwatchLogsExports(final java.util.List<java.lang.String> cloudwatchLogsExports) {
            this.props.cloudwatchLogsExports(cloudwatchLogsExports);
            return this;
        }

        /**
         * The number of days log events are kept in CloudWatch Logs.
         * <p>
         * When updating
         * this property, unsetting it doesn't remove the log retention policy. To
         * remove the retention policy, set the value to <code>Infinity</code>.
         * <p>
         * Default: - logs never expire
         * <p>
         * @return {@code this}
         * @param cloudwatchLogsRetention The number of days log events are kept in CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudwatchLogsRetention(final software.amazon.awscdk.services.logs.RetentionDays cloudwatchLogsRetention) {
            this.props.cloudwatchLogsRetention(cloudwatchLogsRetention);
            return this;
        }

        /**
         * The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
         * <p>
         * Default: - a new role is created.
         * <p>
         * @return {@code this}
         * @param cloudwatchLogsRetentionRole The IAM role for the Lambda function associated with the custom resource that sets the retention policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudwatchLogsRetentionRole(final software.amazon.awscdk.services.iam.IRole cloudwatchLogsRetentionRole) {
            this.props.cloudwatchLogsRetentionRole(cloudwatchLogsRetentionRole);
            return this;
        }

        /**
         * An optional identifier for the cluster.
         * <p>
         * Default: - A name is automatically generated.
         * <p>
         * @return {@code this}
         * @param clusterIdentifier An optional identifier for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterIdentifier(final java.lang.String clusterIdentifier) {
            this.props.clusterIdentifier(clusterIdentifier);
            return this;
        }

        /**
         * (deprecated) [Misspelled] Specifies the scalability mode of the Aurora DB cluster.
         * <p>
         * Set LIMITLESS if you want to use a limitless database; otherwise, set it to STANDARD.
         * <p>
         * Default: ClusterScailabilityType.STANDARD
         * <p>
         * @return {@code this}
         * @deprecated Use clusterScalabilityType instead. This will be removed in the next major version.
         * @param clusterScailabilityType [Misspelled] Specifies the scalability mode of the Aurora DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder clusterScailabilityType(final software.amazon.awscdk.services.rds.ClusterScailabilityType clusterScailabilityType) {
            this.props.clusterScailabilityType(clusterScailabilityType);
            return this;
        }

        /**
         * Specifies the scalability mode of the Aurora DB cluster.
         * <p>
         * Set LIMITLESS if you want to use a limitless database; otherwise, set it to STANDARD.
         * <p>
         * Default: ClusterScalabilityType.STANDARD
         * <p>
         * @return {@code this}
         * @param clusterScalabilityType Specifies the scalability mode of the Aurora DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterScalabilityType(final software.amazon.awscdk.services.rds.ClusterScalabilityType clusterScalabilityType) {
            this.props.clusterScalabilityType(clusterScalabilityType);
            return this;
        }

        /**
         * Whether to copy tags to the snapshot when a snapshot is created.
         * <p>
         * Default: - true
         * <p>
         * @return {@code this}
         * @param copyTagsToSnapshot Whether to copy tags to the snapshot when a snapshot is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(final java.lang.Boolean copyTagsToSnapshot) {
            this.props.copyTagsToSnapshot(copyTagsToSnapshot);
            return this;
        }

        /**
         * Credentials for the administrative user.
         * <p>
         * Default: - A username of 'admin' (or 'postgres' for PostgreSQL) and SecretsManager-generated password
         * <p>
         * @return {@code this}
         * @param credentials Credentials for the administrative user. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(final software.amazon.awscdk.services.rds.Credentials credentials) {
            this.props.credentials(credentials);
            return this;
        }

        /**
         * The database insights mode.
         * <p>
         * Default: - DatabaseInsightsMode.STANDARD when performance insights are enabled and Amazon Aurora engine is used, otherwise not set.
         * <p>
         * @return {@code this}
         * @param databaseInsightsMode The database insights mode. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseInsightsMode(final software.amazon.awscdk.services.rds.DatabaseInsightsMode databaseInsightsMode) {
            this.props.databaseInsightsMode(databaseInsightsMode);
            return this;
        }

        /**
         * Name of a database which is automatically created inside the cluster.
         * <p>
         * Default: - Database is not created in cluster.
         * <p>
         * @return {@code this}
         * @param defaultDatabaseName Name of a database which is automatically created inside the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultDatabaseName(final java.lang.String defaultDatabaseName) {
            this.props.defaultDatabaseName(defaultDatabaseName);
            return this;
        }

        /**
         * Specifies whether to remove automated backups immediately after the DB cluster is deleted.
         * <p>
         * Default: undefined - AWS RDS default is to remove automated backups immediately after the DB cluster is deleted, unless the AWS Backup policy specifies a point-in-time restore rule.
         * <p>
         * @return {@code this}
         * @param deleteAutomatedBackups Specifies whether to remove automated backups immediately after the DB cluster is deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteAutomatedBackups(final java.lang.Boolean deleteAutomatedBackups) {
            this.props.deleteAutomatedBackups(deleteAutomatedBackups);
            return this;
        }

        /**
         * Indicates whether the DB cluster should have deletion protection enabled.
         * <p>
         * Default: - true if `removalPolicy` is RETAIN, `undefined` otherwise, which will not enable deletion protection.
         * To disable deletion protection after it has been enabled, you must explicitly set this value to `false`.
         * <p>
         * @return {@code this}
         * @param deletionProtection Indicates whether the DB cluster should have deletion protection enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final java.lang.Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        /**
         * Directory ID for associating the DB cluster with a specific Active Directory.
         * <p>
         * Necessary for enabling Kerberos authentication. If specified, the DB cluster joins the given Active Directory, enabling Kerberos authentication.
         * If not specified, the DB cluster will not be associated with any Active Directory, and Kerberos authentication will not be enabled.
         * <p>
         * Default: - DB cluster is not associated with an Active Directory; Kerberos authentication is not enabled.
         * <p>
         * @return {@code this}
         * @param domain Directory ID for associating the DB cluster with a specific Active Directory. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(final java.lang.String domain) {
            this.props.domain(domain);
            return this;
        }

        /**
         * The IAM role to be used when making API calls to the Directory Service.
         * <p>
         * The role needs the AWS-managed policy
         * <code>AmazonRDSDirectoryServiceAccess</code> or equivalent.
         * <p>
         * Default: - If `DatabaseClusterBaseProps.domain` is specified, a role with the `AmazonRDSDirectoryServiceAccess` policy is automatically created.
         * <p>
         * @return {@code this}
         * @param domainRole The IAM role to be used when making API calls to the Directory Service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainRole(final software.amazon.awscdk.services.iam.IRole domainRole) {
            this.props.domainRole(domainRole);
            return this;
        }

        /**
         * Whether to enable enhanced monitoring at the cluster level.
         * <p>
         * If set to true, <code>monitoringInterval</code> and <code>monitoringRole</code> are applied to not the instances, but the cluster.
         * <code>monitoringInterval</code> is required to be set if <code>enableClusterLevelEnhancedMonitoring</code> is set to true.
         * <p>
         * Default: - When the `monitoringInterval` is set, enhanced monitoring is enabled for each instance.
         * <p>
         * @return {@code this}
         * @param enableClusterLevelEnhancedMonitoring Whether to enable enhanced monitoring at the cluster level. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableClusterLevelEnhancedMonitoring(final java.lang.Boolean enableClusterLevelEnhancedMonitoring) {
            this.props.enableClusterLevelEnhancedMonitoring(enableClusterLevelEnhancedMonitoring);
            return this;
        }

        /**
         * Whether to enable the Data API for the cluster.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param enableDataApi Whether to enable the Data API for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDataApi(final java.lang.Boolean enableDataApi) {
            this.props.enableDataApi(enableDataApi);
            return this;
        }

        /**
         * Whether read replicas can forward write operations to the writer DB instance in the DB cluster.
         * <p>
         * This setting can only be enabled for Aurora MySQL 3.04 or higher, and for Aurora PostgreSQL 16.4
         * or higher (for version 16), 15.8 or higher (for version 15), and 14.13 or higher (for version 14).
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-postgresql-write-forwarding.html">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-postgresql-write-forwarding.html</a>
         * @param enableLocalWriteForwarding Whether read replicas can forward write operations to the writer DB instance in the DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableLocalWriteForwarding(final java.lang.Boolean enableLocalWriteForwarding) {
            this.props.enableLocalWriteForwarding(enableLocalWriteForwarding);
            return this;
        }

        /**
         * Whether to enable Performance Insights for the DB cluster.
         * <p>
         * Default: - false, unless `performanceInsightRetention` or `performanceInsightEncryptionKey` is set,
         * or `databaseInsightsMode` is set to `DatabaseInsightsMode.ADVANCED`.
         * <p>
         * @return {@code this}
         * @param enablePerformanceInsights Whether to enable Performance Insights for the DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePerformanceInsights(final java.lang.Boolean enablePerformanceInsights) {
            this.props.enablePerformanceInsights(enablePerformanceInsights);
            return this;
        }

        /**
         * The life cycle type for this DB cluster.
         * <p>
         * Default: undefined - AWS RDS default setting is `EngineLifecycleSupport.OPEN_SOURCE_RDS_EXTENDED_SUPPORT`
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html</a>
         * @param engineLifecycleSupport The life cycle type for this DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineLifecycleSupport(final software.amazon.awscdk.services.rds.EngineLifecycleSupport engineLifecycleSupport) {
            this.props.engineLifecycleSupport(engineLifecycleSupport);
            return this;
        }

        /**
         * Whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param iamAuthentication Whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamAuthentication(final java.lang.Boolean iamAuthentication) {
            this.props.iamAuthentication(iamAuthentication);
            return this;
        }

        /**
         * Base identifier for instances.
         * <p>
         * Every replica is named by appending the replica number to this string, 1-based.
         * <p>
         * Default: - clusterIdentifier is used with the word "Instance" appended.
         * If clusterIdentifier is not provided, the identifier is automatically generated.
         * <p>
         * @return {@code this}
         * @param instanceIdentifierBase Base identifier for instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceIdentifierBase(final java.lang.String instanceIdentifierBase) {
            this.props.instanceIdentifierBase(instanceIdentifierBase);
            return this;
        }

        /**
         * (deprecated) Settings for the individual instances that are launched.
         * <p>
         * @return {@code this}
         * @deprecated <ul>
         * <li>use writer and readers instead</li>
         * </ul>
         * @param instanceProps Settings for the individual instances that are launched. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder instanceProps(final software.amazon.awscdk.services.rds.InstanceProps instanceProps) {
            this.props.instanceProps(instanceProps);
            return this;
        }

        /**
         * (deprecated) How many replicas/instances to create.
         * <p>
         * Has to be at least 1.
         * <p>
         * Default: 2
         * <p>
         * @return {@code this}
         * @deprecated <ul>
         * <li>use writer and readers instead</li>
         * </ul>
         * @param instances How many replicas/instances to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder instances(final java.lang.Number instances) {
            this.props.instances(instances);
            return this;
        }

        /**
         * The ordering of updates for instances.
         * <p>
         * Default: InstanceUpdateBehaviour.BULK
         * <p>
         * @return {@code this}
         * @param instanceUpdateBehaviour The ordering of updates for instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceUpdateBehaviour(final software.amazon.awscdk.services.rds.InstanceUpdateBehaviour instanceUpdateBehaviour) {
            this.props.instanceUpdateBehaviour(instanceUpdateBehaviour);
            return this;
        }

        /**
         * The interval between points when Amazon RDS collects enhanced monitoring metrics.
         * <p>
         * If you enable <code>enableClusterLevelEnhancedMonitoring</code>, this property is applied to the cluster,
         * otherwise it is applied to the instances.
         * <p>
         * Default: - no enhanced monitoring
         * <p>
         * @return {@code this}
         * @param monitoringInterval The interval between points when Amazon RDS collects enhanced monitoring metrics. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringInterval(final software.amazon.awscdk.Duration monitoringInterval) {
            this.props.monitoringInterval(monitoringInterval);
            return this;
        }

        /**
         * Role that will be used to manage DB monitoring.
         * <p>
         * If you enable <code>enableClusterLevelEnhancedMonitoring</code>, this property is applied to the cluster,
         * otherwise it is applied to the instances.
         * <p>
         * Default: - A role is automatically created for you
         * <p>
         * @return {@code this}
         * @param monitoringRole Role that will be used to manage DB monitoring. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringRole(final software.amazon.awscdk.services.iam.IRole monitoringRole) {
            this.props.monitoringRole(monitoringRole);
            return this;
        }

        /**
         * The network type of the DB instance.
         * <p>
         * Default: - IPV4
         * <p>
         * @return {@code this}
         * @param networkType The network type of the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkType(final software.amazon.awscdk.services.rds.NetworkType networkType) {
            this.props.networkType(networkType);
            return this;
        }

        /**
         * Additional parameters to pass to the database engine.
         * <p>
         * Default: - No parameter group.
         * <p>
         * @return {@code this}
         * @param parameterGroup Additional parameters to pass to the database engine. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterGroup(final software.amazon.awscdk.services.rds.IParameterGroup parameterGroup) {
            this.props.parameterGroup(parameterGroup);
            return this;
        }

        /**
         * The parameters in the DBClusterParameterGroup to create automatically.
         * <p>
         * You can only specify parameterGroup or parameters but not both.
         * You need to use a versioned engine to auto-generate a DBClusterParameterGroup.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param parameters The parameters in the DBClusterParameterGroup to create automatically. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * The AWS KMS key for encryption of Performance Insights data.
         * <p>
         * Default: - default master key
         * <p>
         * @return {@code this}
         * @param performanceInsightEncryptionKey The AWS KMS key for encryption of Performance Insights data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceInsightEncryptionKey(final software.amazon.awscdk.services.kms.IKey performanceInsightEncryptionKey) {
            this.props.performanceInsightEncryptionKey(performanceInsightEncryptionKey);
            return this;
        }

        /**
         * The amount of time, in days, to retain Performance Insights data.
         * <p>
         * If you set <code>databaseInsightsMode</code> to <code>DatabaseInsightsMode.ADVANCED</code>, you must set this property to <code>PerformanceInsightRetention.MONTHS_15</code>.
         * <p>
         * Default: - 7
         * <p>
         * @return {@code this}
         * @param performanceInsightRetention The amount of time, in days, to retain Performance Insights data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceInsightRetention(final software.amazon.awscdk.services.rds.PerformanceInsightRetention performanceInsightRetention) {
            this.props.performanceInsightRetention(performanceInsightRetention);
            return this;
        }

        /**
         * What port to listen on.
         * <p>
         * Default: - The default for the engine is used.
         * <p>
         * @return {@code this}
         * @param port What port to listen on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * A preferred maintenance window day/time range. Should be specified as a range ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC).
         * <p>
         * Example: 'Sun:23:45-Mon:00:15'
         * <p>
         * Default: - 30-minute window selected at random from an 8-hour block of time for
         * each AWS Region, occurring on a random day of the week.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance</a>
         * @param preferredMaintenanceWindow A preferred maintenance window day/time range. Should be specified as a range ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(final java.lang.String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        /**
         * A list of instances to create as cluster reader instances.
         * <p>
         * Default: - no readers are created. The cluster will have a single writer/reader
         * <p>
         * @return {@code this}
         * @param readers A list of instances to create as cluster reader instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readers(final java.util.List<? extends software.amazon.awscdk.services.rds.IClusterInstance> readers) {
            this.props.readers(readers);
            return this;
        }

        /**
         * The removal policy to apply when the cluster and its instances are removed from the stack or replaced during an update.
         * <p>
         * Default: - RemovalPolicy.SNAPSHOT (remove the cluster and instances, but retain a snapshot of the data)
         * <p>
         * @return {@code this}
         * @param removalPolicy The removal policy to apply when the cluster and its instances are removed from the stack or replaced during an update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.
         * <p>
         * Cannot be used with credentials.
         * <p>
         * Default: - This DB Cluster is not a read replica
         * <p>
         * @return {@code this}
         * @param replicationSourceIdentifier The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationSourceIdentifier(final java.lang.String replicationSourceIdentifier) {
            this.props.replicationSourceIdentifier(replicationSourceIdentifier);
            return this;
        }

        /**
         * S3 buckets that you want to load data into. This feature is only supported by the Aurora database engine.
         * <p>
         * This property must not be used if <code>s3ExportRole</code> is used.
         * <p>
         * For MySQL:
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/postgresql-s3-export.html">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/postgresql-s3-export.html</a>
         * @param s3ExportBuckets S3 buckets that you want to load data into. This feature is only supported by the Aurora database engine. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3ExportBuckets(final java.util.List<? extends software.amazon.awscdk.services.s3.IBucket> s3ExportBuckets) {
            this.props.s3ExportBuckets(s3ExportBuckets);
            return this;
        }

        /**
         * Role that will be associated with this DB cluster to enable S3 export.
         * <p>
         * This feature is only supported by the Aurora database engine.
         * <p>
         * This property must not be used if <code>s3ExportBuckets</code> is used.
         * To use this property with Aurora PostgreSQL, it must be configured with the S3 export feature enabled when creating the DatabaseClusterEngine
         * For MySQL:
         * <p>
         * Default: - New role is created if `s3ExportBuckets` is set, no role is defined otherwise
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/postgresql-s3-export.html">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/postgresql-s3-export.html</a>
         * @param s3ExportRole Role that will be associated with this DB cluster to enable S3 export. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3ExportRole(final software.amazon.awscdk.services.iam.IRole s3ExportRole) {
            this.props.s3ExportRole(s3ExportRole);
            return this;
        }

        /**
         * S3 buckets that you want to load data from. This feature is only supported by the Aurora database engine.
         * <p>
         * This property must not be used if <code>s3ImportRole</code> is used.
         * <p>
         * For MySQL:
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Migrating.html">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Migrating.html</a>
         * @param s3ImportBuckets S3 buckets that you want to load data from. This feature is only supported by the Aurora database engine. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3ImportBuckets(final java.util.List<? extends software.amazon.awscdk.services.s3.IBucket> s3ImportBuckets) {
            this.props.s3ImportBuckets(s3ImportBuckets);
            return this;
        }

        /**
         * Role that will be associated with this DB cluster to enable S3 import.
         * <p>
         * This feature is only supported by the Aurora database engine.
         * <p>
         * This property must not be used if <code>s3ImportBuckets</code> is used.
         * To use this property with Aurora PostgreSQL, it must be configured with the S3 import feature enabled when creating the DatabaseClusterEngine
         * For MySQL:
         * <p>
         * Default: - New role is created if `s3ImportBuckets` is set, no role is defined otherwise
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Migrating.html">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Migrating.html</a>
         * @param s3ImportRole Role that will be associated with this DB cluster to enable S3 import. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3ImportRole(final software.amazon.awscdk.services.iam.IRole s3ImportRole) {
            this.props.s3ImportRole(s3ImportRole);
            return this;
        }

        /**
         * Security group.
         * <p>
         * Default: - a new security group is created.
         * <p>
         * @return {@code this}
         * @param securityGroups Security group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * Specifies the duration an Aurora Serverless v2 DB instance must be idle before Aurora attempts to automatically pause it.
         * <p>
         * The duration must be between 300 seconds (5 minutes) and 86,400 seconds (24 hours).
         * <p>
         * Default: - The default is 300 seconds (5 minutes).
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2-auto-pause.html">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2-auto-pause.html</a>
         * @param serverlessV2AutoPauseDuration Specifies the duration an Aurora Serverless v2 DB instance must be idle before Aurora attempts to automatically pause it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverlessV2AutoPauseDuration(final software.amazon.awscdk.Duration serverlessV2AutoPauseDuration) {
            this.props.serverlessV2AutoPauseDuration(serverlessV2AutoPauseDuration);
            return this;
        }

        /**
         * The maximum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster.
         * <p>
         * You can specify ACU values in half-step increments, such as 40, 40.5, 41, and so on.
         * The largest value that you can use is 256.
         * <p>
         * The maximum capacity must be higher than 0.5 ACUs.
         * <p>
         * Default: 2
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.setting-capacity.html#aurora-serverless-v2.max_capacity_considerations">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.setting-capacity.html#aurora-serverless-v2.max_capacity_considerations</a>
         * @param serverlessV2MaxCapacity The maximum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverlessV2MaxCapacity(final java.lang.Number serverlessV2MaxCapacity) {
            this.props.serverlessV2MaxCapacity(serverlessV2MaxCapacity);
            return this;
        }

        /**
         * The minimum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster.
         * <p>
         * You can specify ACU values in half-step increments, such as 8, 8.5, 9, and so on.
         * The smallest value that you can use is 0.
         * <p>
         * For Aurora versions that support the Aurora Serverless v2 auto-pause feature, the smallest value that you can use is 0.
         * For versions that don't support Aurora Serverless v2 auto-pause, the smallest value that you can use is 0.5.
         * <p>
         * Default: 0.5
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.setting-capacity.html#aurora-serverless-v2.min_capacity_considerations">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.setting-capacity.html#aurora-serverless-v2.min_capacity_considerations</a>
         * @param serverlessV2MinCapacity The minimum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverlessV2MinCapacity(final java.lang.Number serverlessV2MinCapacity) {
            this.props.serverlessV2MinCapacity(serverlessV2MinCapacity);
            return this;
        }

        /**
         * Whether to enable storage encryption.
         * <p>
         * Default: - true if storageEncryptionKey is provided, false otherwise
         * <p>
         * @return {@code this}
         * @param storageEncrypted Whether to enable storage encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(final java.lang.Boolean storageEncrypted) {
            this.props.storageEncrypted(storageEncrypted);
            return this;
        }

        /**
         * The KMS key for storage encryption.
         * <p>
         * If specified, <code>storageEncrypted</code> will be set to <code>true</code>.
         * <p>
         * Default: - if storageEncrypted is true then the default master key, no key otherwise
         * <p>
         * @return {@code this}
         * @param storageEncryptionKey The KMS key for storage encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncryptionKey(final software.amazon.awscdk.interfaces.kms.IKeyRef storageEncryptionKey) {
            this.props.storageEncryptionKey(storageEncryptionKey);
            return this;
        }

        /**
         * The storage type to be associated with the DB cluster.
         * <p>
         * Default: - DBClusterStorageType.AURORA
         * <p>
         * @return {@code this}
         * @param storageType The storage type to be associated with the DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageType(final software.amazon.awscdk.services.rds.DBClusterStorageType storageType) {
            this.props.storageType(storageType);
            return this;
        }

        /**
         * Existing subnet group for the cluster.
         * <p>
         * Default: - a new subnet group will be created.
         * <p>
         * @return {@code this}
         * @param subnetGroup Existing subnet group for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetGroup(final software.amazon.awscdk.services.rds.ISubnetGroup subnetGroup) {
            this.props.subnetGroup(subnetGroup);
            return this;
        }

        /**
         * What subnets to run the RDS instances in.
         * <p>
         * Must be at least 2 subnets in two different AZs.
         * <p>
         * @return {@code this}
         * @param vpc What subnets to run the RDS instances in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Where to place the instances within the VPC.
         * <p>
         * Default: - the Vpc default strategy if not specified.
         * <p>
         * @return {@code this}
         * @param vpcSubnets Where to place the instances within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * The instance to use for the cluster writer.
         * <p>
         * Default: - required if instanceProps is not provided
         * <p>
         * @return {@code this}
         * @param writer The instance to use for the cluster writer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writer(final software.amazon.awscdk.services.rds.IClusterInstance writer) {
            this.props.writer(writer);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.rds.DatabaseCluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rds.DatabaseCluster build() {
            return new software.amazon.awscdk.services.rds.DatabaseCluster(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
