package software.amazon.awscdk.services.rds;

/**
 * Properties that describe an existing cluster instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Function fn;
 * Secret secret;
 * // Create a serverless V1 cluster
 * ServerlessCluster serverlessV1Cluster = ServerlessCluster.Builder.create(this, "AnotherCluster")
 *         .engine(DatabaseClusterEngine.AURORA_MYSQL)
 *         .vpc(vpc) // this parameter is optional for serverless Clusters
 *         .enableDataApi(true)
 *         .build();
 * serverlessV1Cluster.grantDataApiAccess(fn);
 * // Create an Aurora cluster
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Cluster")
 *         .engine(DatabaseClusterEngine.AURORA_MYSQL)
 *         .vpc(vpc)
 *         .enableDataApi(true)
 *         .build();
 * cluster.grantDataApiAccess(fn);
 * // Import an Aurora cluster
 * IDatabaseCluster importedCluster = DatabaseCluster.fromDatabaseClusterAttributes(this, "ImportedCluster", DatabaseClusterAttributes.builder()
 *         .clusterIdentifier("clusterIdentifier")
 *         .secret(secret)
 *         .dataApiEnabled(true)
 *         .build());
 * importedCluster.grantDataApiAccess(fn);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:59.077Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.DatabaseClusterAttributes")
@software.amazon.jsii.Jsii.Proxy(DatabaseClusterAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DatabaseClusterAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * Identifier for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterIdentifier();

    /**
     * Cluster endpoint address.
     * <p>
     * Default: - no endpoint address
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterEndpointAddress() {
        return null;
    }

    /**
     * The immutable identifier for the cluster; for example: cluster-ABCD1234EFGH5678IJKL90MNOP.
     * <p>
     * This AWS Region-unique identifier is used to grant access to the cluster.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterResourceIdentifier() {
        return null;
    }

    /**
     * Whether the Data API for the cluster is enabled.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDataApiEnabled() {
        return null;
    }

    /**
     * The engine of the existing Cluster.
     * <p>
     * Default: - the imported Cluster's engine is unknown
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.IClusterEngine getEngine() {
        return null;
    }

    /**
     * Endpoint addresses of individual instances.
     * <p>
     * Default: - no instance endpoints
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstanceEndpointAddresses() {
        return null;
    }

    /**
     * Identifier for the instances.
     * <p>
     * Default: - no instance identifiers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstanceIdentifiers() {
        return null;
    }

    /**
     * The database port.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * Reader endpoint address.
     * <p>
     * Default: - no reader address
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReaderEndpointAddress() {
        return null;
    }

    /**
     * The secret attached to the database cluster.
     * <p>
     * Default: - the imported Cluster's secret is unknown
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecret() {
        return null;
    }

    /**
     * The security groups of the database cluster.
     * <p>
     * Default: - no security groups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DatabaseClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DatabaseClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DatabaseClusterAttributes> {
        java.lang.String clusterIdentifier;
        java.lang.String clusterEndpointAddress;
        java.lang.String clusterResourceIdentifier;
        java.lang.Boolean dataApiEnabled;
        software.amazon.awscdk.services.rds.IClusterEngine engine;
        java.util.List<java.lang.String> instanceEndpointAddresses;
        java.util.List<java.lang.String> instanceIdentifiers;
        java.lang.Number port;
        java.lang.String readerEndpointAddress;
        software.amazon.awscdk.services.secretsmanager.ISecret secret;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getClusterIdentifier}
         * @param clusterIdentifier Identifier for the cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterIdentifier(java.lang.String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getClusterEndpointAddress}
         * @param clusterEndpointAddress Cluster endpoint address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterEndpointAddress(java.lang.String clusterEndpointAddress) {
            this.clusterEndpointAddress = clusterEndpointAddress;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getClusterResourceIdentifier}
         * @param clusterResourceIdentifier The immutable identifier for the cluster; for example: cluster-ABCD1234EFGH5678IJKL90MNOP.
         *                                  This AWS Region-unique identifier is used to grant access to the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterResourceIdentifier(java.lang.String clusterResourceIdentifier) {
            this.clusterResourceIdentifier = clusterResourceIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getDataApiEnabled}
         * @param dataApiEnabled Whether the Data API for the cluster is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataApiEnabled(java.lang.Boolean dataApiEnabled) {
            this.dataApiEnabled = dataApiEnabled;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getEngine}
         * @param engine The engine of the existing Cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(software.amazon.awscdk.services.rds.IClusterEngine engine) {
            this.engine = engine;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getInstanceEndpointAddresses}
         * @param instanceEndpointAddresses Endpoint addresses of individual instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceEndpointAddresses(java.util.List<java.lang.String> instanceEndpointAddresses) {
            this.instanceEndpointAddresses = instanceEndpointAddresses;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getInstanceIdentifiers}
         * @param instanceIdentifiers Identifier for the instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceIdentifiers(java.util.List<java.lang.String> instanceIdentifiers) {
            this.instanceIdentifiers = instanceIdentifiers;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getPort}
         * @param port The database port.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getReaderEndpointAddress}
         * @param readerEndpointAddress Reader endpoint address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readerEndpointAddress(java.lang.String readerEndpointAddress) {
            this.readerEndpointAddress = readerEndpointAddress;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getSecret}
         * @param secret The secret attached to the database cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secret(software.amazon.awscdk.services.secretsmanager.ISecret secret) {
            this.secret = secret;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getSecurityGroups}
         * @param securityGroups The security groups of the database cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DatabaseClusterAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DatabaseClusterAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DatabaseClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseClusterAttributes {
        private final java.lang.String clusterIdentifier;
        private final java.lang.String clusterEndpointAddress;
        private final java.lang.String clusterResourceIdentifier;
        private final java.lang.Boolean dataApiEnabled;
        private final software.amazon.awscdk.services.rds.IClusterEngine engine;
        private final java.util.List<java.lang.String> instanceEndpointAddresses;
        private final java.util.List<java.lang.String> instanceIdentifiers;
        private final java.lang.Number port;
        private final java.lang.String readerEndpointAddress;
        private final software.amazon.awscdk.services.secretsmanager.ISecret secret;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterIdentifier = software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterEndpointAddress = software.amazon.jsii.Kernel.get(this, "clusterEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterResourceIdentifier = software.amazon.jsii.Kernel.get(this, "clusterResourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataApiEnabled = software.amazon.jsii.Kernel.get(this, "dataApiEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.engine = software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterEngine.class));
            this.instanceEndpointAddresses = software.amazon.jsii.Kernel.get(this, "instanceEndpointAddresses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.instanceIdentifiers = software.amazon.jsii.Kernel.get(this, "instanceIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.readerEndpointAddress = software.amazon.jsii.Kernel.get(this, "readerEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.secret = software.amazon.jsii.Kernel.get(this, "secret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterIdentifier = java.util.Objects.requireNonNull(builder.clusterIdentifier, "clusterIdentifier is required");
            this.clusterEndpointAddress = builder.clusterEndpointAddress;
            this.clusterResourceIdentifier = builder.clusterResourceIdentifier;
            this.dataApiEnabled = builder.dataApiEnabled;
            this.engine = builder.engine;
            this.instanceEndpointAddresses = builder.instanceEndpointAddresses;
            this.instanceIdentifiers = builder.instanceIdentifiers;
            this.port = builder.port;
            this.readerEndpointAddress = builder.readerEndpointAddress;
            this.secret = builder.secret;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
        }

        @Override
        public final java.lang.String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final java.lang.String getClusterEndpointAddress() {
            return this.clusterEndpointAddress;
        }

        @Override
        public final java.lang.String getClusterResourceIdentifier() {
            return this.clusterResourceIdentifier;
        }

        @Override
        public final java.lang.Boolean getDataApiEnabled() {
            return this.dataApiEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.rds.IClusterEngine getEngine() {
            return this.engine;
        }

        @Override
        public final java.util.List<java.lang.String> getInstanceEndpointAddresses() {
            return this.instanceEndpointAddresses;
        }

        @Override
        public final java.util.List<java.lang.String> getInstanceIdentifiers() {
            return this.instanceIdentifiers;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getReaderEndpointAddress() {
            return this.readerEndpointAddress;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.ISecret getSecret() {
            return this.secret;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clusterIdentifier", om.valueToTree(this.getClusterIdentifier()));
            if (this.getClusterEndpointAddress() != null) {
                data.set("clusterEndpointAddress", om.valueToTree(this.getClusterEndpointAddress()));
            }
            if (this.getClusterResourceIdentifier() != null) {
                data.set("clusterResourceIdentifier", om.valueToTree(this.getClusterResourceIdentifier()));
            }
            if (this.getDataApiEnabled() != null) {
                data.set("dataApiEnabled", om.valueToTree(this.getDataApiEnabled()));
            }
            if (this.getEngine() != null) {
                data.set("engine", om.valueToTree(this.getEngine()));
            }
            if (this.getInstanceEndpointAddresses() != null) {
                data.set("instanceEndpointAddresses", om.valueToTree(this.getInstanceEndpointAddresses()));
            }
            if (this.getInstanceIdentifiers() != null) {
                data.set("instanceIdentifiers", om.valueToTree(this.getInstanceIdentifiers()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getReaderEndpointAddress() != null) {
                data.set("readerEndpointAddress", om.valueToTree(this.getReaderEndpointAddress()));
            }
            if (this.getSecret() != null) {
                data.set("secret", om.valueToTree(this.getSecret()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.DatabaseClusterAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DatabaseClusterAttributes.Jsii$Proxy that = (DatabaseClusterAttributes.Jsii$Proxy) o;

            if (!clusterIdentifier.equals(that.clusterIdentifier)) return false;
            if (this.clusterEndpointAddress != null ? !this.clusterEndpointAddress.equals(that.clusterEndpointAddress) : that.clusterEndpointAddress != null) return false;
            if (this.clusterResourceIdentifier != null ? !this.clusterResourceIdentifier.equals(that.clusterResourceIdentifier) : that.clusterResourceIdentifier != null) return false;
            if (this.dataApiEnabled != null ? !this.dataApiEnabled.equals(that.dataApiEnabled) : that.dataApiEnabled != null) return false;
            if (this.engine != null ? !this.engine.equals(that.engine) : that.engine != null) return false;
            if (this.instanceEndpointAddresses != null ? !this.instanceEndpointAddresses.equals(that.instanceEndpointAddresses) : that.instanceEndpointAddresses != null) return false;
            if (this.instanceIdentifiers != null ? !this.instanceIdentifiers.equals(that.instanceIdentifiers) : that.instanceIdentifiers != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.readerEndpointAddress != null ? !this.readerEndpointAddress.equals(that.readerEndpointAddress) : that.readerEndpointAddress != null) return false;
            if (this.secret != null ? !this.secret.equals(that.secret) : that.secret != null) return false;
            return this.securityGroups != null ? this.securityGroups.equals(that.securityGroups) : that.securityGroups == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clusterIdentifier.hashCode();
            result = 31 * result + (this.clusterEndpointAddress != null ? this.clusterEndpointAddress.hashCode() : 0);
            result = 31 * result + (this.clusterResourceIdentifier != null ? this.clusterResourceIdentifier.hashCode() : 0);
            result = 31 * result + (this.dataApiEnabled != null ? this.dataApiEnabled.hashCode() : 0);
            result = 31 * result + (this.engine != null ? this.engine.hashCode() : 0);
            result = 31 * result + (this.instanceEndpointAddresses != null ? this.instanceEndpointAddresses.hashCode() : 0);
            result = 31 * result + (this.instanceIdentifiers != null ? this.instanceIdentifiers.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.readerEndpointAddress != null ? this.readerEndpointAddress.hashCode() : 0);
            result = 31 * result + (this.secret != null ? this.secret.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            return result;
        }
    }
}
