package software.amazon.awscdk.services.rds;

/**
 * Properties that describe an existing instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.rds.*;
 * IInstanceEngine instanceEngine;
 * SecurityGroup securityGroup;
 * DatabaseInstanceAttributes databaseInstanceAttributes = DatabaseInstanceAttributes.builder()
 *         .instanceEndpointAddress("instanceEndpointAddress")
 *         .instanceIdentifier("instanceIdentifier")
 *         .port(123)
 *         .securityGroups(List.of(securityGroup))
 *         // the properties below are optional
 *         .engine(instanceEngine)
 *         .instanceResourceId("instanceResourceId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:59.106Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.DatabaseInstanceAttributes")
@software.amazon.jsii.Jsii.Proxy(DatabaseInstanceAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DatabaseInstanceAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The endpoint address.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceEndpointAddress();

    /**
     * The instance identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceIdentifier();

    /**
     * The database port.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getPort();

    /**
     * The security groups of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups();

    /**
     * The engine of the existing database Instance.
     * <p>
     * Default: - the imported Instance's engine is unknown
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.IInstanceEngine getEngine() {
        return null;
    }

    /**
     * The AWS Region-unique, immutable identifier for the DB instance.
     * <p>
     * This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB instance is accessed.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#aws-resource-rds-dbinstance-return-values">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#aws-resource-rds-dbinstance-return-values</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceResourceId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DatabaseInstanceAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DatabaseInstanceAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DatabaseInstanceAttributes> {
        java.lang.String instanceEndpointAddress;
        java.lang.String instanceIdentifier;
        java.lang.Number port;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        software.amazon.awscdk.services.rds.IInstanceEngine engine;
        java.lang.String instanceResourceId;

        /**
         * Sets the value of {@link DatabaseInstanceAttributes#getInstanceEndpointAddress}
         * @param instanceEndpointAddress The endpoint address. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceEndpointAddress(java.lang.String instanceEndpointAddress) {
            this.instanceEndpointAddress = instanceEndpointAddress;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceAttributes#getInstanceIdentifier}
         * @param instanceIdentifier The instance identifier. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceIdentifier(java.lang.String instanceIdentifier) {
            this.instanceIdentifier = instanceIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceAttributes#getPort}
         * @param port The database port. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceAttributes#getSecurityGroups}
         * @param securityGroups The security groups of the instance. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceAttributes#getEngine}
         * @param engine The engine of the existing database Instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(software.amazon.awscdk.services.rds.IInstanceEngine engine) {
            this.engine = engine;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceAttributes#getInstanceResourceId}
         * @param instanceResourceId The AWS Region-unique, immutable identifier for the DB instance.
         *                           This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB instance is accessed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceResourceId(java.lang.String instanceResourceId) {
            this.instanceResourceId = instanceResourceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DatabaseInstanceAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DatabaseInstanceAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DatabaseInstanceAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseInstanceAttributes {
        private final java.lang.String instanceEndpointAddress;
        private final java.lang.String instanceIdentifier;
        private final java.lang.Number port;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.services.rds.IInstanceEngine engine;
        private final java.lang.String instanceResourceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceEndpointAddress = software.amazon.jsii.Kernel.get(this, "instanceEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceIdentifier = software.amazon.jsii.Kernel.get(this, "instanceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.engine = software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class));
            this.instanceResourceId = software.amazon.jsii.Kernel.get(this, "instanceResourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceEndpointAddress = java.util.Objects.requireNonNull(builder.instanceEndpointAddress, "instanceEndpointAddress is required");
            this.instanceIdentifier = java.util.Objects.requireNonNull(builder.instanceIdentifier, "instanceIdentifier is required");
            this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)java.util.Objects.requireNonNull(builder.securityGroups, "securityGroups is required");
            this.engine = builder.engine;
            this.instanceResourceId = builder.instanceResourceId;
        }

        @Override
        public final java.lang.String getInstanceEndpointAddress() {
            return this.instanceEndpointAddress;
        }

        @Override
        public final java.lang.String getInstanceIdentifier() {
            return this.instanceIdentifier;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.services.rds.IInstanceEngine getEngine() {
            return this.engine;
        }

        @Override
        public final java.lang.String getInstanceResourceId() {
            return this.instanceResourceId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceEndpointAddress", om.valueToTree(this.getInstanceEndpointAddress()));
            data.set("instanceIdentifier", om.valueToTree(this.getInstanceIdentifier()));
            data.set("port", om.valueToTree(this.getPort()));
            data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            if (this.getEngine() != null) {
                data.set("engine", om.valueToTree(this.getEngine()));
            }
            if (this.getInstanceResourceId() != null) {
                data.set("instanceResourceId", om.valueToTree(this.getInstanceResourceId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.DatabaseInstanceAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DatabaseInstanceAttributes.Jsii$Proxy that = (DatabaseInstanceAttributes.Jsii$Proxy) o;

            if (!instanceEndpointAddress.equals(that.instanceEndpointAddress)) return false;
            if (!instanceIdentifier.equals(that.instanceIdentifier)) return false;
            if (!port.equals(that.port)) return false;
            if (!securityGroups.equals(that.securityGroups)) return false;
            if (this.engine != null ? !this.engine.equals(that.engine) : that.engine != null) return false;
            return this.instanceResourceId != null ? this.instanceResourceId.equals(that.instanceResourceId) : that.instanceResourceId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceEndpointAddress.hashCode();
            result = 31 * result + (this.instanceIdentifier.hashCode());
            result = 31 * result + (this.port.hashCode());
            result = 31 * result + (this.securityGroups.hashCode());
            result = 31 * result + (this.engine != null ? this.engine.hashCode() : 0);
            result = 31 * result + (this.instanceResourceId != null ? this.instanceResourceId.hashCode() : 0);
            return result;
        }
    }
}
