package software.amazon.awscdk.services.rds;

/**
 * RDS Database Proxy Endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.rds.*;
 * DatabaseProxy databaseProxy;
 * SecurityGroup securityGroup;
 * Subnet subnet;
 * SubnetFilter subnetFilter;
 * Vpc vpc;
 * DatabaseProxyEndpoint databaseProxyEndpoint = DatabaseProxyEndpoint.Builder.create(this, "MyDatabaseProxyEndpoint")
 *         .dbProxy(databaseProxy)
 *         .vpc(vpc)
 *         // the properties below are optional
 *         .dbProxyEndpointName("dbProxyEndpointName")
 *         .securityGroups(List.of(securityGroup))
 *         .targetRole(ProxyEndpointTargetRole.READ_WRITE)
 *         .vpcSubnets(SubnetSelection.builder()
 *                 .availabilityZones(List.of("availabilityZones"))
 *                 .onePerAz(false)
 *                 .subnetFilters(List.of(subnetFilter))
 *                 .subnetGroupName("subnetGroupName")
 *                 .subnets(List.of(subnet))
 *                 .subnetType(SubnetType.PRIVATE_ISOLATED)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:59.143Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.DatabaseProxyEndpoint")
public class DatabaseProxyEndpoint extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.rds.IDatabaseProxyEndpoint {

    protected DatabaseProxyEndpoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseProxyEndpoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseProxyEndpoint.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DatabaseProxyEndpoint(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.DatabaseProxyEndpointProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing database proxy endpoint.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IDatabaseProxyEndpoint fromDatabaseProxyEndpointAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.DatabaseProxyEndpointAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseProxyEndpoint.class, "fromDatabaseProxyEndpointAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IDatabaseProxyEndpoint.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * DB Proxy Endpoint ARN.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDbProxyEndpointArn() {
        return software.amazon.jsii.Kernel.get(this, "dbProxyEndpointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * DB Proxy Endpoint Name.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDbProxyEndpointName() {
        return software.amazon.jsii.Kernel.get(this, "dbProxyEndpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The endpoint that you can use to connect to the DB proxy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rds.DatabaseProxyEndpoint}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rds.DatabaseProxyEndpoint> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.rds.DatabaseProxyEndpointProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.rds.DatabaseProxyEndpointProps.Builder();
        }

        /**
         * The VPC of the DB proxy endpoint.
         * <p>
         * @return {@code this}
         * @param vpc The VPC of the DB proxy endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * The name of the DB proxy endpoint.
         * <p>
         * Default: - a CDK generated name
         * <p>
         * @return {@code this}
         * @param dbProxyEndpointName The name of the DB proxy endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbProxyEndpointName(final java.lang.String dbProxyEndpointName) {
            this.props.dbProxyEndpointName(dbProxyEndpointName);
            return this;
        }

        /**
         * The VPC security groups to associate with the new proxy endpoint.
         * <p>
         * Default: - Default security group for the VPC
         * <p>
         * @return {@code this}
         * @param securityGroups The VPC security groups to associate with the new proxy endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * A value that indicates whether the DB proxy endpoint can be used for read/write or read-only operations.
         * <p>
         * Default: - ProxyEndpointTargetRole.READ_WRITE
         * <p>
         * @return {@code this}
         * @param targetRole A value that indicates whether the DB proxy endpoint can be used for read/write or read-only operations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetRole(final software.amazon.awscdk.services.rds.ProxyEndpointTargetRole targetRole) {
            this.props.targetRole(targetRole);
            return this;
        }

        /**
         * The subnets of DB proxy endpoint.
         * <p>
         * Default: - the VPC default strategy if not specified.
         * <p>
         * @return {@code this}
         * @param vpcSubnets The subnets of DB proxy endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * The DB proxy associated with the DB proxy endpoint.
         * <p>
         * @return {@code this}
         * @param dbProxy The DB proxy associated with the DB proxy endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbProxy(final software.amazon.awscdk.services.rds.IDatabaseProxy dbProxy) {
            this.props.dbProxy(dbProxy);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.rds.DatabaseProxyEndpoint}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rds.DatabaseProxyEndpoint build() {
            return new software.amazon.awscdk.services.rds.DatabaseProxyEndpoint(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
