package software.amazon.awscdk.services.route53;

/**
 * The ALPN protocol identifier.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cloudfront.*;
 * HostedZone myZone;
 * CloudFrontWebDistribution distribution;
 * // Alias to CloudFront target
 * // Alias to CloudFront target
 * HttpsRecord.Builder.create(this, "HttpsRecord-CloudFrontAlias")
 *         .zone(myZone)
 *         .target(RecordTarget.fromAlias(new CloudFrontTarget(distribution)))
 *         .build();
 * // ServiceMode (priority &gt;= 1)
 * // ServiceMode (priority &gt;= 1)
 * HttpsRecord.Builder.create(this, "HttpsRecord-ServiceMode")
 *         .zone(myZone)
 *         .values(List.of(HttpsRecordValue.service(HttpsRecordServiceModeProps.builder().alpn(List.of(Alpn.H3, Alpn.H2)).build())))
 *         .build();
 * // AliasMode (priority = 0)
 * // AliasMode (priority = 0)
 * HttpsRecord.Builder.create(this, "HttpsRecord-AliasMode")
 *         .zone(myZone)
 *         .values(List.of(HttpsRecordValue.alias("service.example.com")))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:59.429Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.Alpn")
public class Alpn extends software.amazon.jsii.JsiiObject {

    protected Alpn(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Alpn(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        H2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.route53.Alpn.class, "H2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.Alpn.class));
        H3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.route53.Alpn.class, "H3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.Alpn.class));
        HTTP1_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.route53.Alpn.class, "HTTP1_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.Alpn.class));
    }

    /**
     * A custom ALPN protocol identifier.
     * <p>
     * @param protocol The ALPN protocol identifier. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.Alpn of(final @org.jetbrains.annotations.NotNull java.lang.String protocol) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.Alpn.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.Alpn.class), new Object[] { java.util.Objects.requireNonNull(protocol, "protocol is required") });
    }

    /**
     * HTTP2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.route53.Alpn H2;

    /**
     * HTTP3 (QUIC).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.route53.Alpn H3;

    /**
     * HTTP/1.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.route53.Alpn HTTP1_1;

    /**
     * The ALPN protocol identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProtocol() {
        return software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
