package software.amazon.awscdk.services.route53;

/**
 * Properties for configuring CIDR routing in Route 53 resource record set objects.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * HostedZone myZone;
 * CfnCidrCollection cidrCollection = CfnCidrCollection.Builder.create(this, "CidrCollection")
 *         .name("test-collection")
 *         .locations(List.of(LocationProperty.builder()
 *                 .cidrList(List.of("192.168.1.0/24"))
 *                 .locationName("my_location")
 *                 .build()))
 *         .build();
 * ARecord.Builder.create(this, "CidrRoutingConfig")
 *         .zone(myZone)
 *         .target(RecordTarget.fromIpAddresses("1.2.3.4"))
 *         .setIdentifier("test")
 *         .cidrRoutingConfig(CidrRoutingConfig.create(CidrRoutingConfigProps.builder()
 *                 .collectionId(cidrCollection.getAttrId())
 *                 .locationName("test_location")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:59.517Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.CidrRoutingConfigProps")
@software.amazon.jsii.Jsii.Proxy(CidrRoutingConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CidrRoutingConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The CIDR collection ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCollectionId();

    /**
     * The CIDR collection location name.
     * <p>
     * Default: `*`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLocationName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CidrRoutingConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CidrRoutingConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CidrRoutingConfigProps> {
        java.lang.String collectionId;
        java.lang.String locationName;

        /**
         * Sets the value of {@link CidrRoutingConfigProps#getCollectionId}
         * @param collectionId The CIDR collection ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder collectionId(java.lang.String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        /**
         * Sets the value of {@link CidrRoutingConfigProps#getLocationName}
         * @param locationName The CIDR collection location name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locationName(java.lang.String locationName) {
            this.locationName = locationName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CidrRoutingConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CidrRoutingConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CidrRoutingConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CidrRoutingConfigProps {
        private final java.lang.String collectionId;
        private final java.lang.String locationName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.collectionId = software.amazon.jsii.Kernel.get(this, "collectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.locationName = software.amazon.jsii.Kernel.get(this, "locationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.collectionId = java.util.Objects.requireNonNull(builder.collectionId, "collectionId is required");
            this.locationName = builder.locationName;
        }

        @Override
        public final java.lang.String getCollectionId() {
            return this.collectionId;
        }

        @Override
        public final java.lang.String getLocationName() {
            return this.locationName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("collectionId", om.valueToTree(this.getCollectionId()));
            if (this.getLocationName() != null) {
                data.set("locationName", om.valueToTree(this.getLocationName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.CidrRoutingConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CidrRoutingConfigProps.Jsii$Proxy that = (CidrRoutingConfigProps.Jsii$Proxy) o;

            if (!collectionId.equals(that.collectionId)) return false;
            return this.locationName != null ? this.locationName.equals(that.locationName) : that.locationName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.collectionId.hashCode();
            result = 31 * result + (this.locationName != null ? this.locationName.hashCode() : 0);
            return result;
        }
    }
}
