package software.amazon.awscdk.services.route53;

/**
 * Options for the delegation permissions granted.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Role betaCrossAccountRole;
 * Role prodCrossAccountRole;
 * PublicHostedZone parentZone = PublicHostedZone.Builder.create(this, "HostedZone")
 *         .zoneName("someexample.com")
 *         .build();
 * parentZone.grantDelegation(betaCrossAccountRole, GrantDelegationOptions.builder()
 *         .delegatedZoneNames(List.of("beta.someexample.com"))
 *         .build());
 * parentZone.grantDelegation(prodCrossAccountRole, GrantDelegationOptions.builder()
 *         .delegatedZoneNames(List.of("prod.someexample.com"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:59.531Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.GrantDelegationOptions")
@software.amazon.jsii.Jsii.Proxy(GrantDelegationOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GrantDelegationOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * List of hosted zone names to allow delegation to in the grant permissions.
     * <p>
     * If the delegated zone name contains an unresolved token,
     * it must resolve to a zone name that satisfies the requirements according to the documentation:
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/specifying-conditions-route53.html#route53_rrset_conditionkeys_normalization
     * <p>
     * <blockquote>
     * <p>
     * All letters must be lowercase.
     * The DNS name must be without the trailing dot.
     * Characters other than a–z, 0–9, - (hyphen), _ (underscore), and . (period, as a delimiter between labels) must use escape codes in the format \three-digit octal code. For example, \052 is the octal code for character *.
     * <p>
     * </blockquote>
     * <p>
     * Default: the grant allows delegation to any hosted zone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDelegatedZoneNames() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GrantDelegationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GrantDelegationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GrantDelegationOptions> {
        java.util.List<java.lang.String> delegatedZoneNames;

        /**
         * Sets the value of {@link GrantDelegationOptions#getDelegatedZoneNames}
         * @param delegatedZoneNames List of hosted zone names to allow delegation to in the grant permissions.
         *                           If the delegated zone name contains an unresolved token,
         *                           it must resolve to a zone name that satisfies the requirements according to the documentation:
         *                           https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/specifying-conditions-route53.html#route53_rrset_conditionkeys_normalization
         *                           <p>
         *                           <blockquote>
         *                           <p>
         *                           All letters must be lowercase.
         *                           The DNS name must be without the trailing dot.
         *                           Characters other than a–z, 0–9, - (hyphen), _ (underscore), and . (period, as a delimiter between labels) must use escape codes in the format \three-digit octal code. For example, \052 is the octal code for character *.
         *                           <p>
         *                           </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder delegatedZoneNames(java.util.List<java.lang.String> delegatedZoneNames) {
            this.delegatedZoneNames = delegatedZoneNames;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GrantDelegationOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GrantDelegationOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GrantDelegationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrantDelegationOptions {
        private final java.util.List<java.lang.String> delegatedZoneNames;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.delegatedZoneNames = software.amazon.jsii.Kernel.get(this, "delegatedZoneNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.delegatedZoneNames = builder.delegatedZoneNames;
        }

        @Override
        public final java.util.List<java.lang.String> getDelegatedZoneNames() {
            return this.delegatedZoneNames;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDelegatedZoneNames() != null) {
                data.set("delegatedZoneNames", om.valueToTree(this.getDelegatedZoneNames()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.GrantDelegationOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GrantDelegationOptions.Jsii$Proxy that = (GrantDelegationOptions.Jsii$Proxy) o;

            return this.delegatedZoneNames != null ? this.delegatedZoneNames.equals(that.delegatedZoneNames) : that.delegatedZoneNames == null;
        }

        @Override
        public final int hashCode() {
            int result = this.delegatedZoneNames != null ? this.delegatedZoneNames.hashCode() : 0;
            return result;
        }
    }
}
