package software.amazon.awscdk.services.route53;

/**
 * Represents an HTTPS record value.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cloudfront.*;
 * HostedZone myZone;
 * CloudFrontWebDistribution distribution;
 * // Alias to CloudFront target
 * // Alias to CloudFront target
 * HttpsRecord.Builder.create(this, "HttpsRecord-CloudFrontAlias")
 *         .zone(myZone)
 *         .target(RecordTarget.fromAlias(new CloudFrontTarget(distribution)))
 *         .build();
 * // ServiceMode (priority &gt;= 1)
 * // ServiceMode (priority &gt;= 1)
 * HttpsRecord.Builder.create(this, "HttpsRecord-ServiceMode")
 *         .zone(myZone)
 *         .values(List.of(HttpsRecordValue.service(HttpsRecordServiceModeProps.builder().alpn(List.of(Alpn.H3, Alpn.H2)).build())))
 *         .build();
 * // AliasMode (priority = 0)
 * // AliasMode (priority = 0)
 * HttpsRecord.Builder.create(this, "HttpsRecord-AliasMode")
 *         .zone(myZone)
 *         .values(List.of(HttpsRecordValue.alias("service.example.com")))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:59.540Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.HttpsRecordValue")
public class HttpsRecordValue extends software.amazon.jsii.JsiiObject {

    protected HttpsRecordValue(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpsRecordValue(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * An HTTPS AliasMode record value.
     * <p>
     * @param targetName The domain name of the alternative endpoint. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.HttpsRecordValue alias(final @org.jetbrains.annotations.NotNull java.lang.String targetName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.HttpsRecordValue.class, "alias", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.HttpsRecordValue.class), new Object[] { java.util.Objects.requireNonNull(targetName, "targetName is required") });
    }

    /**
     * An HTTPS ServiceMode record value.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.HttpsRecordValue service(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.HttpsRecordServiceModeProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.HttpsRecordValue.class, "service", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.HttpsRecordValue.class), new Object[] { props });
    }

    /**
     * An HTTPS ServiceMode record value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.HttpsRecordValue service() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.HttpsRecordValue.class, "service", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.HttpsRecordValue.class));
    }

    /**
     * Returns the string representation of SVCB and HTTPS record value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
