package software.amazon.awscdk.services.route53;

/**
 * Represents an SVCB record value.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53.*;
 * SvcbRecordValue svcbRecordValue = SvcbRecordValue.alias("targetName");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:59.575Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.SvcbRecordValue")
public class SvcbRecordValue extends software.amazon.jsii.JsiiObject {

    protected SvcbRecordValue(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SvcbRecordValue(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * An SVCB AliasMode record value.
     * <p>
     * @param targetName The domain name of the alternative endpoint. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.SvcbRecordValue alias(final @org.jetbrains.annotations.NotNull java.lang.String targetName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.SvcbRecordValue.class, "alias", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.SvcbRecordValue.class), new Object[] { java.util.Objects.requireNonNull(targetName, "targetName is required") });
    }

    /**
     * An SVCB ServiceMode record value.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.SvcbRecordValue service(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.SvcbRecordServiceModeProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.SvcbRecordValue.class, "service", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.SvcbRecordValue.class), new Object[] { props });
    }

    /**
     * An SVCB ServiceMode record value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.SvcbRecordValue service() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.SvcbRecordValue.class, "service", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.SvcbRecordValue.class));
    }

    /**
     * Returns the string representation of SVCB and HTTPS record value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
