package software.amazon.awscdk.services.rtbfabric;

/**
 * Properties for defining a <code>CfnLink</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rtbfabric.*;
 * CfnLinkProps cfnLinkProps = CfnLinkProps.builder()
 *         .gatewayId("gatewayId")
 *         .linkLogSettings(LinkLogSettingsProperty.builder()
 *                 .applicationLogs(ApplicationLogsProperty.builder()
 *                         .linkApplicationLogSampling(LinkApplicationLogSamplingProperty.builder()
 *                                 .errorLog(123)
 *                                 .filterLog(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .peerGatewayId("peerGatewayId")
 *         // the properties below are optional
 *         .httpResponderAllowed(false)
 *         .linkAttributes(LinkAttributesProperty.builder()
 *                 .customerProvidedId("customerProvidedId")
 *                 .responderErrorMasking(List.of(ResponderErrorMaskingForHttpCodeProperty.builder()
 *                         .action("action")
 *                         .httpCode("httpCode")
 *                         .loggingTypes(List.of("loggingTypes"))
 *                         // the properties below are optional
 *                         .responseLoggingPercentage(123)
 *                         .build()))
 *                 .build())
 *         .moduleConfigurationList(List.of(ModuleConfigurationProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .dependsOn(List.of("dependsOn"))
 *                 .moduleParameters(ModuleParametersProperty.builder()
 *                         .noBid(NoBidModuleParametersProperty.builder()
 *                                 .passThroughPercentage(123)
 *                                 .reason("reason")
 *                                 .reasonCode(123)
 *                                 .build())
 *                         .openRtbAttribute(OpenRtbAttributeModuleParametersProperty.builder()
 *                                 .action(ActionProperty.builder()
 *                                         .headerTag(HeaderTagActionProperty.builder()
 *                                                 .name("name")
 *                                                 .value("value")
 *                                                 .build())
 *                                         .noBid(NoBidActionProperty.builder()
 *                                                 .noBidReasonCode(123)
 *                                                 .build())
 *                                         .build())
 *                                 .filterConfiguration(List.of(FilterProperty.builder()
 *                                         .criteria(List.of(FilterCriterionProperty.builder()
 *                                                 .path("path")
 *                                                 .values(List.of("values"))
 *                                                 .build()))
 *                                         .build()))
 *                                 .filterType("filterType")
 *                                 .holdbackPercentage(123)
 *                                 .build())
 *                         .build())
 *                 .version("version")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-link.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-link.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:59.678Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rtbfabric.CfnLinkProps")
@software.amazon.jsii.Jsii.Proxy(CfnLinkProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLinkProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique identifier of the gateway.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-link.html#cfn-rtbfabric-link-gatewayid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-link.html#cfn-rtbfabric-link-gatewayid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGatewayId();

    /**
     * Settings for the application logs.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.rtbfabric.CfnLink.LinkLogSettingsProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-link.html#cfn-rtbfabric-link-linklogsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-link.html#cfn-rtbfabric-link-linklogsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getLinkLogSettings();

    /**
     * The unique identifier of the peer gateway.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-link.html#cfn-rtbfabric-link-peergatewayid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-link.html#cfn-rtbfabric-link-peergatewayid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPeerGatewayId();

    /**
     * Boolean to specify if an HTTP responder is allowed.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-link.html#cfn-rtbfabric-link-httpresponderallowed">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-link.html#cfn-rtbfabric-link-httpresponderallowed</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHttpResponderAllowed() {
        return null;
    }

    /**
     * Attributes of the link.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.rtbfabric.CfnLink.LinkAttributesProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-link.html#cfn-rtbfabric-link-linkattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-link.html#cfn-rtbfabric-link-linkattributes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLinkAttributes() {
        return null;
    }

    /**
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.rtbfabric.CfnLink.ModuleConfigurationProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-link.html#cfn-rtbfabric-link-moduleconfigurationlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-link.html#cfn-rtbfabric-link-moduleconfigurationlist</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getModuleConfigurationList() {
        return null;
    }

    /**
     * A map of the key-value pairs of the tag or tags to assign to the resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-link.html#cfn-rtbfabric-link-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-link.html#cfn-rtbfabric-link-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLinkProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLinkProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLinkProps> {
        java.lang.String gatewayId;
        java.lang.Object linkLogSettings;
        java.lang.String peerGatewayId;
        java.lang.Object httpResponderAllowed;
        java.lang.Object linkAttributes;
        java.lang.Object moduleConfigurationList;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnLinkProps#getGatewayId}
         * @param gatewayId The unique identifier of the gateway. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayId(java.lang.String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLinkProps#getLinkLogSettings}
         * @param linkLogSettings Settings for the application logs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linkLogSettings(software.amazon.awscdk.IResolvable linkLogSettings) {
            this.linkLogSettings = linkLogSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnLinkProps#getLinkLogSettings}
         * @param linkLogSettings Settings for the application logs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linkLogSettings(software.amazon.awscdk.services.rtbfabric.CfnLink.LinkLogSettingsProperty linkLogSettings) {
            this.linkLogSettings = linkLogSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnLinkProps#getPeerGatewayId}
         * @param peerGatewayId The unique identifier of the peer gateway. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder peerGatewayId(java.lang.String peerGatewayId) {
            this.peerGatewayId = peerGatewayId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLinkProps#getHttpResponderAllowed}
         * @param httpResponderAllowed Boolean to specify if an HTTP responder is allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpResponderAllowed(java.lang.Boolean httpResponderAllowed) {
            this.httpResponderAllowed = httpResponderAllowed;
            return this;
        }

        /**
         * Sets the value of {@link CfnLinkProps#getHttpResponderAllowed}
         * @param httpResponderAllowed Boolean to specify if an HTTP responder is allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpResponderAllowed(software.amazon.awscdk.IResolvable httpResponderAllowed) {
            this.httpResponderAllowed = httpResponderAllowed;
            return this;
        }

        /**
         * Sets the value of {@link CfnLinkProps#getLinkAttributes}
         * @param linkAttributes Attributes of the link.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linkAttributes(software.amazon.awscdk.IResolvable linkAttributes) {
            this.linkAttributes = linkAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnLinkProps#getLinkAttributes}
         * @param linkAttributes Attributes of the link.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linkAttributes(software.amazon.awscdk.services.rtbfabric.CfnLink.LinkAttributesProperty linkAttributes) {
            this.linkAttributes = linkAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnLinkProps#getModuleConfigurationList}
         * @param moduleConfigurationList the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder moduleConfigurationList(software.amazon.awscdk.IResolvable moduleConfigurationList) {
            this.moduleConfigurationList = moduleConfigurationList;
            return this;
        }

        /**
         * Sets the value of {@link CfnLinkProps#getModuleConfigurationList}
         * @param moduleConfigurationList the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder moduleConfigurationList(java.util.List<? extends java.lang.Object> moduleConfigurationList) {
            this.moduleConfigurationList = moduleConfigurationList;
            return this;
        }

        /**
         * Sets the value of {@link CfnLinkProps#getTags}
         * @param tags A map of the key-value pairs of the tag or tags to assign to the resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLinkProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLinkProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLinkProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLinkProps {
        private final java.lang.String gatewayId;
        private final java.lang.Object linkLogSettings;
        private final java.lang.String peerGatewayId;
        private final java.lang.Object httpResponderAllowed;
        private final java.lang.Object linkAttributes;
        private final java.lang.Object moduleConfigurationList;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.gatewayId = software.amazon.jsii.Kernel.get(this, "gatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.linkLogSettings = software.amazon.jsii.Kernel.get(this, "linkLogSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.peerGatewayId = software.amazon.jsii.Kernel.get(this, "peerGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.httpResponderAllowed = software.amazon.jsii.Kernel.get(this, "httpResponderAllowed", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.linkAttributes = software.amazon.jsii.Kernel.get(this, "linkAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.moduleConfigurationList = software.amazon.jsii.Kernel.get(this, "moduleConfigurationList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.gatewayId = java.util.Objects.requireNonNull(builder.gatewayId, "gatewayId is required");
            this.linkLogSettings = java.util.Objects.requireNonNull(builder.linkLogSettings, "linkLogSettings is required");
            this.peerGatewayId = java.util.Objects.requireNonNull(builder.peerGatewayId, "peerGatewayId is required");
            this.httpResponderAllowed = builder.httpResponderAllowed;
            this.linkAttributes = builder.linkAttributes;
            this.moduleConfigurationList = builder.moduleConfigurationList;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getGatewayId() {
            return this.gatewayId;
        }

        @Override
        public final java.lang.Object getLinkLogSettings() {
            return this.linkLogSettings;
        }

        @Override
        public final java.lang.String getPeerGatewayId() {
            return this.peerGatewayId;
        }

        @Override
        public final java.lang.Object getHttpResponderAllowed() {
            return this.httpResponderAllowed;
        }

        @Override
        public final java.lang.Object getLinkAttributes() {
            return this.linkAttributes;
        }

        @Override
        public final java.lang.Object getModuleConfigurationList() {
            return this.moduleConfigurationList;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("gatewayId", om.valueToTree(this.getGatewayId()));
            data.set("linkLogSettings", om.valueToTree(this.getLinkLogSettings()));
            data.set("peerGatewayId", om.valueToTree(this.getPeerGatewayId()));
            if (this.getHttpResponderAllowed() != null) {
                data.set("httpResponderAllowed", om.valueToTree(this.getHttpResponderAllowed()));
            }
            if (this.getLinkAttributes() != null) {
                data.set("linkAttributes", om.valueToTree(this.getLinkAttributes()));
            }
            if (this.getModuleConfigurationList() != null) {
                data.set("moduleConfigurationList", om.valueToTree(this.getModuleConfigurationList()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rtbfabric.CfnLinkProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLinkProps.Jsii$Proxy that = (CfnLinkProps.Jsii$Proxy) o;

            if (!gatewayId.equals(that.gatewayId)) return false;
            if (!linkLogSettings.equals(that.linkLogSettings)) return false;
            if (!peerGatewayId.equals(that.peerGatewayId)) return false;
            if (this.httpResponderAllowed != null ? !this.httpResponderAllowed.equals(that.httpResponderAllowed) : that.httpResponderAllowed != null) return false;
            if (this.linkAttributes != null ? !this.linkAttributes.equals(that.linkAttributes) : that.linkAttributes != null) return false;
            if (this.moduleConfigurationList != null ? !this.moduleConfigurationList.equals(that.moduleConfigurationList) : that.moduleConfigurationList != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.gatewayId.hashCode();
            result = 31 * result + (this.linkLogSettings.hashCode());
            result = 31 * result + (this.peerGatewayId.hashCode());
            result = 31 * result + (this.httpResponderAllowed != null ? this.httpResponderAllowed.hashCode() : 0);
            result = 31 * result + (this.linkAttributes != null ? this.linkAttributes.hashCode() : 0);
            result = 31 * result + (this.moduleConfigurationList != null ? this.moduleConfigurationList.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
