package software.amazon.awscdk.services.s3vectors;

/**
 * The <code>AWS::S3Vectors::Index</code> resource defines a vector index within an Amazon S3 vector bucket.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-create-index.html">Creating a vector index in a vector bucket</a> in the <em>Amazon Simple Storage Service User Guide</em> .
 * <p>
 * You must specify either <code>VectorBucketName</code> or <code>VectorBucketArn</code> to identify the bucket that contains the index.
 * <p>
 * To control how AWS CloudFormation handles the vector index when the stack is deleted, you can set a deletion policy for your index. You can choose to <em>retain</em> the index or to <em>delete</em> the index. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html">DeletionPolicy attribute</a> .
 * <p>
 * <ul>
 * <li><strong>Permissions</strong> - The required permissions for CloudFormation to use are based on the operations that are performed on the stack.</li>
 * <li>Create</li>
 * <li>s3vectors:CreateIndex</li>
 * <li>s3vectors:GetIndex</li>
 * <li>Read</li>
 * <li>s3vectors:GetIndex</li>
 * <li>Delete</li>
 * <li>s3vectors:DeleteIndex</li>
 * <li>s3vectors:GetIndex</li>
 * <li>List</li>
 * <li>s3vectors:ListIndexes</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3vectors.*;
 * CfnIndex cfnIndex = CfnIndex.Builder.create(this, "MyCfnIndex")
 *         .dataType("dataType")
 *         .dimension(123)
 *         .distanceMetric("distanceMetric")
 *         // the properties below are optional
 *         .indexName("indexName")
 *         .metadataConfiguration(MetadataConfigurationProperty.builder()
 *                 .nonFilterableMetadataKeys(List.of("nonFilterableMetadataKeys"))
 *                 .build())
 *         .vectorBucketArn("vectorBucketArn")
 *         .vectorBucketName("vectorBucketName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:59.986Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3vectors.CfnIndex")
public class CfnIndex extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.s3vectors.IIndexRef {

    protected CfnIndex(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIndex(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.s3vectors.CfnIndex.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::S3Vectors::Index</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIndex(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3vectors.CfnIndexProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the date and time when the vector index was created.
     * <p>
     * Example: <code>2024-12-21T10:30:00Z</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the Amazon Resource Name (ARN) of the specified index.
     * <p>
     * Example: <code>arn:aws:s3vectors:us-east-1:123456789012:bucket/amzn-s3-demo-vector-bucket/index/my-index</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIndexArn() {
        return software.amazon.jsii.Kernel.get(this, "attrIndexArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a Index resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.s3vectors.IndexReference getIndexRef() {
        return software.amazon.jsii.Kernel.get(this, "indexRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.s3vectors.IndexReference.class));
    }

    /**
     * The data type of the vectors to be inserted into the vector index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDataType() {
        return software.amazon.jsii.Kernel.get(this, "dataType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The data type of the vectors to be inserted into the vector index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dataType", java.util.Objects.requireNonNull(value, "dataType is required"));
    }

    /**
     * The dimensions of the vectors to be inserted into the vector index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getDimension() {
        return software.amazon.jsii.Kernel.get(this, "dimension", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The dimensions of the vectors to be inserted into the vector index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDimension(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "dimension", java.util.Objects.requireNonNull(value, "dimension is required"));
    }

    /**
     * The distance metric to be used for similarity search.
     * <p>
     * Valid values are:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDistanceMetric() {
        return software.amazon.jsii.Kernel.get(this, "distanceMetric", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The distance metric to be used for similarity search.
     * <p>
     * Valid values are:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDistanceMetric(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "distanceMetric", java.util.Objects.requireNonNull(value, "distanceMetric is required"));
    }

    /**
     * The name of the vector index to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIndexName() {
        return software.amazon.jsii.Kernel.get(this, "indexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the vector index to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIndexName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "indexName", value);
    }

    /**
     * The metadata configuration for the vector index.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.s3vectors.CfnIndex.MetadataConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMetadataConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "metadataConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The metadata configuration for the vector index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetadataConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "metadataConfiguration", value);
    }

    /**
     * The metadata configuration for the vector index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetadataConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3vectors.CfnIndex.MetadataConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "metadataConfiguration", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the vector bucket that contains the vector index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVectorBucketArn() {
        return software.amazon.jsii.Kernel.get(this, "vectorBucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the vector bucket that contains the vector index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVectorBucketArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vectorBucketArn", value);
    }

    /**
     * The name of the vector bucket that contains the vector index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVectorBucketName() {
        return software.amazon.jsii.Kernel.get(this, "vectorBucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the vector bucket that contains the vector index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVectorBucketName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vectorBucketName", value);
    }
    /**
     * The metadata configuration for the vector index.
     * <p>
     * This configuration allows you to specify which metadata keys should be treated as non-filterable.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3vectors.*;
     * MetadataConfigurationProperty metadataConfigurationProperty = MetadataConfigurationProperty.builder()
     *         .nonFilterableMetadataKeys(List.of("nonFilterableMetadataKeys"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3vectors-index-metadataconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3vectors-index-metadataconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3vectors.CfnIndex.MetadataConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MetadataConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetadataConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Non-filterable metadata keys allow you to enrich vectors with additional context during storage and retrieval.
         * <p>
         * Unlike default metadata keys, these keys can't be used as query filters. Non-filterable metadata keys can be retrieved but can't be searched, queried, or filtered. You can access non-filterable metadata keys of your vectors after finding the vectors.
         * <p>
         * You can specify 1 to 10 non-filterable metadata keys. Each key must be 1 to 63 characters long.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3vectors-index-metadataconfiguration.html#cfn-s3vectors-index-metadataconfiguration-nonfilterablemetadatakeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3vectors-index-metadataconfiguration.html#cfn-s3vectors-index-metadataconfiguration-nonfilterablemetadatakeys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNonFilterableMetadataKeys() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetadataConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetadataConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetadataConfigurationProperty> {
            java.util.List<java.lang.String> nonFilterableMetadataKeys;

            /**
             * Sets the value of {@link MetadataConfigurationProperty#getNonFilterableMetadataKeys}
             * @param nonFilterableMetadataKeys Non-filterable metadata keys allow you to enrich vectors with additional context during storage and retrieval.
             *                                  Unlike default metadata keys, these keys can't be used as query filters. Non-filterable metadata keys can be retrieved but can't be searched, queried, or filtered. You can access non-filterable metadata keys of your vectors after finding the vectors.
             *                                  <p>
             *                                  You can specify 1 to 10 non-filterable metadata keys. Each key must be 1 to 63 characters long.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nonFilterableMetadataKeys(java.util.List<java.lang.String> nonFilterableMetadataKeys) {
                this.nonFilterableMetadataKeys = nonFilterableMetadataKeys;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetadataConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetadataConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetadataConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetadataConfigurationProperty {
            private final java.util.List<java.lang.String> nonFilterableMetadataKeys;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.nonFilterableMetadataKeys = software.amazon.jsii.Kernel.get(this, "nonFilterableMetadataKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.nonFilterableMetadataKeys = builder.nonFilterableMetadataKeys;
            }

            @Override
            public final java.util.List<java.lang.String> getNonFilterableMetadataKeys() {
                return this.nonFilterableMetadataKeys;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNonFilterableMetadataKeys() != null) {
                    data.set("nonFilterableMetadataKeys", om.valueToTree(this.getNonFilterableMetadataKeys()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3vectors.CfnIndex.MetadataConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetadataConfigurationProperty.Jsii$Proxy that = (MetadataConfigurationProperty.Jsii$Proxy) o;

                return this.nonFilterableMetadataKeys != null ? this.nonFilterableMetadataKeys.equals(that.nonFilterableMetadataKeys) : that.nonFilterableMetadataKeys == null;
            }

            @Override
            public final int hashCode() {
                int result = this.nonFilterableMetadataKeys != null ? this.nonFilterableMetadataKeys.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.s3vectors.CfnIndex}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.s3vectors.CfnIndex> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.s3vectors.CfnIndexProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.s3vectors.CfnIndexProps.Builder();
        }

        /**
         * The data type of the vectors to be inserted into the vector index.
         * <p>
         * Currently, only <code>float32</code> is supported, which represents 32-bit floating-point numbers.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-datatype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-datatype</a>
         * @param dataType The data type of the vectors to be inserted into the vector index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataType(final java.lang.String dataType) {
            this.props.dataType(dataType);
            return this;
        }

        /**
         * The dimensions of the vectors to be inserted into the vector index.
         * <p>
         * This value must be between 1 and 4096, inclusive. All vectors stored in the index must have the same number of dimensions.
         * <p>
         * The dimension value affects the storage requirements and search performance. Higher dimensions require more storage space and may impact search latency.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-dimension">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-dimension</a>
         * @param dimension The dimensions of the vectors to be inserted into the vector index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dimension(final java.lang.Number dimension) {
            this.props.dimension(dimension);
            return this;
        }

        /**
         * The distance metric to be used for similarity search. Valid values are:.
         * <p>
         * <ul>
         * <li><code>cosine</code> - Measures the cosine of the angle between two vectors.</li>
         * <li><code>euclidean</code> - Measures the straight-line distance between two points in multi-dimensional space. Lower values indicate greater similarity.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-distancemetric">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-distancemetric</a>
         * @param distanceMetric The distance metric to be used for similarity search. Valid values are:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distanceMetric(final java.lang.String distanceMetric) {
            this.props.distanceMetric(distanceMetric);
            return this;
        }

        /**
         * The name of the vector index to create.
         * <p>
         * The index name must be between 3 and 63 characters long and can contain only lowercase letters, numbers, hyphens (-), and dots (.). The index name must be unique within the vector bucket.
         * <p>
         * If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the index name.
         * <p>
         * <blockquote>
         * <p>
         * If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you need to replace the resource, specify a new name.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-indexname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-indexname</a>
         * @param indexName The name of the vector index to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder indexName(final java.lang.String indexName) {
            this.props.indexName(indexName);
            return this;
        }

        /**
         * The metadata configuration for the vector index.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-metadataconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-metadataconfiguration</a>
         * @param metadataConfiguration The metadata configuration for the vector index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadataConfiguration(final software.amazon.awscdk.IResolvable metadataConfiguration) {
            this.props.metadataConfiguration(metadataConfiguration);
            return this;
        }
        /**
         * The metadata configuration for the vector index.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-metadataconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-metadataconfiguration</a>
         * @param metadataConfiguration The metadata configuration for the vector index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadataConfiguration(final software.amazon.awscdk.services.s3vectors.CfnIndex.MetadataConfigurationProperty metadataConfiguration) {
            this.props.metadataConfiguration(metadataConfiguration);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the vector bucket that contains the vector index.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-vectorbucketarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-vectorbucketarn</a>
         * @param vectorBucketArn The Amazon Resource Name (ARN) of the vector bucket that contains the vector index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorBucketArn(final java.lang.String vectorBucketArn) {
            this.props.vectorBucketArn(vectorBucketArn);
            return this;
        }

        /**
         * The name of the vector bucket that contains the vector index.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-vectorbucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-vectorbucketname</a>
         * @param vectorBucketName The name of the vector bucket that contains the vector index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorBucketName(final java.lang.String vectorBucketName) {
            this.props.vectorBucketName(vectorBucketName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.s3vectors.CfnIndex}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.s3vectors.CfnIndex build() {
            return new software.amazon.awscdk.services.s3vectors.CfnIndex(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
