package software.amazon.awscdk.services.s3vectors;

/**
 * Properties for defining a <code>CfnIndex</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3vectors.*;
 * CfnIndexProps cfnIndexProps = CfnIndexProps.builder()
 *         .dataType("dataType")
 *         .dimension(123)
 *         .distanceMetric("distanceMetric")
 *         // the properties below are optional
 *         .indexName("indexName")
 *         .metadataConfiguration(MetadataConfigurationProperty.builder()
 *                 .nonFilterableMetadataKeys(List.of("nonFilterableMetadataKeys"))
 *                 .build())
 *         .vectorBucketArn("vectorBucketArn")
 *         .vectorBucketName("vectorBucketName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:59.988Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3vectors.CfnIndexProps")
@software.amazon.jsii.Jsii.Proxy(CfnIndexProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIndexProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The data type of the vectors to be inserted into the vector index.
     * <p>
     * Currently, only <code>float32</code> is supported, which represents 32-bit floating-point numbers.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-datatype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-datatype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataType();

    /**
     * The dimensions of the vectors to be inserted into the vector index.
     * <p>
     * This value must be between 1 and 4096, inclusive. All vectors stored in the index must have the same number of dimensions.
     * <p>
     * The dimension value affects the storage requirements and search performance. Higher dimensions require more storage space and may impact search latency.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-dimension">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-dimension</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getDimension();

    /**
     * The distance metric to be used for similarity search. Valid values are:.
     * <p>
     * <ul>
     * <li><code>cosine</code> - Measures the cosine of the angle between two vectors.</li>
     * <li><code>euclidean</code> - Measures the straight-line distance between two points in multi-dimensional space. Lower values indicate greater similarity.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-distancemetric">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-distancemetric</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDistanceMetric();

    /**
     * The name of the vector index to create.
     * <p>
     * The index name must be between 3 and 63 characters long and can contain only lowercase letters, numbers, hyphens (-), and dots (.). The index name must be unique within the vector bucket.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the index name.
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you need to replace the resource, specify a new name.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-indexname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-indexname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIndexName() {
        return null;
    }

    /**
     * The metadata configuration for the vector index.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.s3vectors.CfnIndex.MetadataConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-metadataconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-metadataconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMetadataConfiguration() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the vector bucket that contains the vector index.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-vectorbucketarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-vectorbucketarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVectorBucketArn() {
        return null;
    }

    /**
     * The name of the vector bucket that contains the vector index.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-vectorbucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-index.html#cfn-s3vectors-index-vectorbucketname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVectorBucketName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIndexProps> {
        java.lang.String dataType;
        java.lang.Number dimension;
        java.lang.String distanceMetric;
        java.lang.String indexName;
        java.lang.Object metadataConfiguration;
        java.lang.String vectorBucketArn;
        java.lang.String vectorBucketName;

        /**
         * Sets the value of {@link CfnIndexProps#getDataType}
         * @param dataType The data type of the vectors to be inserted into the vector index. This parameter is required.
         *                 Currently, only <code>float32</code> is supported, which represents 32-bit floating-point numbers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataType(java.lang.String dataType) {
            this.dataType = dataType;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getDimension}
         * @param dimension The dimensions of the vectors to be inserted into the vector index. This parameter is required.
         *                  This value must be between 1 and 4096, inclusive. All vectors stored in the index must have the same number of dimensions.
         *                  <p>
         *                  The dimension value affects the storage requirements and search performance. Higher dimensions require more storage space and may impact search latency.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dimension(java.lang.Number dimension) {
            this.dimension = dimension;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getDistanceMetric}
         * @param distanceMetric The distance metric to be used for similarity search. Valid values are:. This parameter is required.
         *                       <ul>
         *                       <li><code>cosine</code> - Measures the cosine of the angle between two vectors.</li>
         *                       <li><code>euclidean</code> - Measures the straight-line distance between two points in multi-dimensional space. Lower values indicate greater similarity.</li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distanceMetric(java.lang.String distanceMetric) {
            this.distanceMetric = distanceMetric;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getIndexName}
         * @param indexName The name of the vector index to create.
         *                  The index name must be between 3 and 63 characters long and can contain only lowercase letters, numbers, hyphens (-), and dots (.). The index name must be unique within the vector bucket.
         *                  <p>
         *                  If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the index name.
         *                  <p>
         *                  <blockquote>
         *                  <p>
         *                  If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you need to replace the resource, specify a new name.
         *                  <p>
         *                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder indexName(java.lang.String indexName) {
            this.indexName = indexName;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getMetadataConfiguration}
         * @param metadataConfiguration The metadata configuration for the vector index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadataConfiguration(software.amazon.awscdk.IResolvable metadataConfiguration) {
            this.metadataConfiguration = metadataConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getMetadataConfiguration}
         * @param metadataConfiguration The metadata configuration for the vector index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadataConfiguration(software.amazon.awscdk.services.s3vectors.CfnIndex.MetadataConfigurationProperty metadataConfiguration) {
            this.metadataConfiguration = metadataConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getVectorBucketArn}
         * @param vectorBucketArn The Amazon Resource Name (ARN) of the vector bucket that contains the vector index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorBucketArn(java.lang.String vectorBucketArn) {
            this.vectorBucketArn = vectorBucketArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnIndexProps#getVectorBucketName}
         * @param vectorBucketName The name of the vector bucket that contains the vector index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorBucketName(java.lang.String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIndexProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIndexProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIndexProps {
        private final java.lang.String dataType;
        private final java.lang.Number dimension;
        private final java.lang.String distanceMetric;
        private final java.lang.String indexName;
        private final java.lang.Object metadataConfiguration;
        private final java.lang.String vectorBucketArn;
        private final java.lang.String vectorBucketName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataType = software.amazon.jsii.Kernel.get(this, "dataType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dimension = software.amazon.jsii.Kernel.get(this, "dimension", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.distanceMetric = software.amazon.jsii.Kernel.get(this, "distanceMetric", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.indexName = software.amazon.jsii.Kernel.get(this, "indexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.metadataConfiguration = software.amazon.jsii.Kernel.get(this, "metadataConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vectorBucketArn = software.amazon.jsii.Kernel.get(this, "vectorBucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vectorBucketName = software.amazon.jsii.Kernel.get(this, "vectorBucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataType = java.util.Objects.requireNonNull(builder.dataType, "dataType is required");
            this.dimension = java.util.Objects.requireNonNull(builder.dimension, "dimension is required");
            this.distanceMetric = java.util.Objects.requireNonNull(builder.distanceMetric, "distanceMetric is required");
            this.indexName = builder.indexName;
            this.metadataConfiguration = builder.metadataConfiguration;
            this.vectorBucketArn = builder.vectorBucketArn;
            this.vectorBucketName = builder.vectorBucketName;
        }

        @Override
        public final java.lang.String getDataType() {
            return this.dataType;
        }

        @Override
        public final java.lang.Number getDimension() {
            return this.dimension;
        }

        @Override
        public final java.lang.String getDistanceMetric() {
            return this.distanceMetric;
        }

        @Override
        public final java.lang.String getIndexName() {
            return this.indexName;
        }

        @Override
        public final java.lang.Object getMetadataConfiguration() {
            return this.metadataConfiguration;
        }

        @Override
        public final java.lang.String getVectorBucketArn() {
            return this.vectorBucketArn;
        }

        @Override
        public final java.lang.String getVectorBucketName() {
            return this.vectorBucketName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dataType", om.valueToTree(this.getDataType()));
            data.set("dimension", om.valueToTree(this.getDimension()));
            data.set("distanceMetric", om.valueToTree(this.getDistanceMetric()));
            if (this.getIndexName() != null) {
                data.set("indexName", om.valueToTree(this.getIndexName()));
            }
            if (this.getMetadataConfiguration() != null) {
                data.set("metadataConfiguration", om.valueToTree(this.getMetadataConfiguration()));
            }
            if (this.getVectorBucketArn() != null) {
                data.set("vectorBucketArn", om.valueToTree(this.getVectorBucketArn()));
            }
            if (this.getVectorBucketName() != null) {
                data.set("vectorBucketName", om.valueToTree(this.getVectorBucketName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3vectors.CfnIndexProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIndexProps.Jsii$Proxy that = (CfnIndexProps.Jsii$Proxy) o;

            if (!dataType.equals(that.dataType)) return false;
            if (!dimension.equals(that.dimension)) return false;
            if (!distanceMetric.equals(that.distanceMetric)) return false;
            if (this.indexName != null ? !this.indexName.equals(that.indexName) : that.indexName != null) return false;
            if (this.metadataConfiguration != null ? !this.metadataConfiguration.equals(that.metadataConfiguration) : that.metadataConfiguration != null) return false;
            if (this.vectorBucketArn != null ? !this.vectorBucketArn.equals(that.vectorBucketArn) : that.vectorBucketArn != null) return false;
            return this.vectorBucketName != null ? this.vectorBucketName.equals(that.vectorBucketName) : that.vectorBucketName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dataType.hashCode();
            result = 31 * result + (this.dimension.hashCode());
            result = 31 * result + (this.distanceMetric.hashCode());
            result = 31 * result + (this.indexName != null ? this.indexName.hashCode() : 0);
            result = 31 * result + (this.metadataConfiguration != null ? this.metadataConfiguration.hashCode() : 0);
            result = 31 * result + (this.vectorBucketArn != null ? this.vectorBucketArn.hashCode() : 0);
            result = 31 * result + (this.vectorBucketName != null ? this.vectorBucketName.hashCode() : 0);
            return result;
        }
    }
}
