package software.amazon.awscdk.services.s3vectors;

/**
 * The <code>AWS::S3Vectors::VectorBucketPolicy</code> resource defines an Amazon S3 vector bucket policy to control access to an Amazon S3 vector bucket.
 * <p>
 * Vector bucket policies are written in JSON and allow you to grant or deny permissions across all (or a subset of) objects within a vector bucket.
 * <p>
 * You must specify either <code>VectorBucketName</code> or <code>VectorBucketArn</code> to identify the target bucket.
 * <p>
 * To control how AWS CloudFormation handles the vector bucket policy when the stack is deleted, you can set a deletion policy for your policy. You can choose to <em>retain</em> the policy or to <em>delete</em> the policy. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html">DeletionPolicy attribute</a> .
 * <p>
 * <ul>
 * <li><strong>Permissions</strong> - The required permissions for CloudFormation to use are based on the operations that are performed on the stack.</li>
 * <li>Create</li>
 * <li>s3vectors:GetVectorBucketPolicy</li>
 * <li>s3vectors:PutVectorBucketPolicy</li>
 * <li>Read</li>
 * <li>s3vectors:GetVectorBucketPolicy</li>
 * <li>Update</li>
 * <li>s3vectors:GetVectorBucketPolicy</li>
 * <li>s3vectors:PutVectorBucketPolicy</li>
 * <li>Delete</li>
 * <li>s3vectors:GetVectorBucketPolicy</li>
 * <li>s3vectors:DeleteVectorBucketPolicy</li>
 * <li>List</li>
 * <li>s3vectors:GetVectorBucketPolicy</li>
 * <li>s3vectors:ListVectorBuckets</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3vectors.*;
 * Object policy;
 * CfnVectorBucketPolicy cfnVectorBucketPolicy = CfnVectorBucketPolicy.Builder.create(this, "MyCfnVectorBucketPolicy")
 *         .policy(policy)
 *         // the properties below are optional
 *         .vectorBucketArn("vectorBucketArn")
 *         .vectorBucketName("vectorBucketName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-vectorbucketpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-vectorbucketpolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:59.990Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3vectors.CfnVectorBucketPolicy")
public class CfnVectorBucketPolicy extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.s3vectors.IVectorBucketPolicyRef {

    protected CfnVectorBucketPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnVectorBucketPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.s3vectors.CfnVectorBucketPolicy.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::S3Vectors::VectorBucketPolicy</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnVectorBucketPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3vectors.CfnVectorBucketPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a VectorBucketPolicy resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.s3vectors.VectorBucketPolicyReference getVectorBucketPolicyRef() {
        return software.amazon.jsii.Kernel.get(this, "vectorBucketPolicyRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.s3vectors.VectorBucketPolicyReference.class));
    }

    /**
     * A policy document containing permissions to add to the specified vector bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getPolicy() {
        return software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A policy document containing permissions to add to the specified vector bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicy(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "policy", java.util.Objects.requireNonNull(value, "policy is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the S3 vector bucket to which the policy applies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVectorBucketArn() {
        return software.amazon.jsii.Kernel.get(this, "vectorBucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the S3 vector bucket to which the policy applies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVectorBucketArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vectorBucketArn", value);
    }

    /**
     * The name of the S3 vector bucket to which the policy applies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVectorBucketName() {
        return software.amazon.jsii.Kernel.get(this, "vectorBucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the S3 vector bucket to which the policy applies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVectorBucketName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vectorBucketName", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.s3vectors.CfnVectorBucketPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.s3vectors.CfnVectorBucketPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.s3vectors.CfnVectorBucketPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.s3vectors.CfnVectorBucketPolicyProps.Builder();
        }

        /**
         * A policy document containing permissions to add to the specified vector bucket.
         * <p>
         * In IAM , you must provide policy documents in JSON format. However, in CloudFormation you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to IAM .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-vectorbucketpolicy.html#cfn-s3vectors-vectorbucketpolicy-policy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-vectorbucketpolicy.html#cfn-s3vectors-vectorbucketpolicy-policy</a>
         * @param policy A policy document containing permissions to add to the specified vector bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(final java.lang.Object policy) {
            this.props.policy(policy);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the S3 vector bucket to which the policy applies.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-vectorbucketpolicy.html#cfn-s3vectors-vectorbucketpolicy-vectorbucketarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-vectorbucketpolicy.html#cfn-s3vectors-vectorbucketpolicy-vectorbucketarn</a>
         * @param vectorBucketArn The Amazon Resource Name (ARN) of the S3 vector bucket to which the policy applies. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorBucketArn(final java.lang.String vectorBucketArn) {
            this.props.vectorBucketArn(vectorBucketArn);
            return this;
        }

        /**
         * The name of the S3 vector bucket to which the policy applies.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-vectorbucketpolicy.html#cfn-s3vectors-vectorbucketpolicy-vectorbucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-vectorbucketpolicy.html#cfn-s3vectors-vectorbucketpolicy-vectorbucketname</a>
         * @param vectorBucketName The name of the S3 vector bucket to which the policy applies. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorBucketName(final java.lang.String vectorBucketName) {
            this.props.vectorBucketName(vectorBucketName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.s3vectors.CfnVectorBucketPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.s3vectors.CfnVectorBucketPolicy build() {
            return new software.amazon.awscdk.services.s3vectors.CfnVectorBucketPolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
