package software.amazon.awscdk.services.s3vectors;

/**
 * Properties for defining a <code>CfnVectorBucketPolicy</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3vectors.*;
 * Object policy;
 * CfnVectorBucketPolicyProps cfnVectorBucketPolicyProps = CfnVectorBucketPolicyProps.builder()
 *         .policy(policy)
 *         // the properties below are optional
 *         .vectorBucketArn("vectorBucketArn")
 *         .vectorBucketName("vectorBucketName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-vectorbucketpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-vectorbucketpolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:59.991Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3vectors.CfnVectorBucketPolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnVectorBucketPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVectorBucketPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A policy document containing permissions to add to the specified vector bucket.
     * <p>
     * In IAM , you must provide policy documents in JSON format. However, in CloudFormation you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to IAM .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-vectorbucketpolicy.html#cfn-s3vectors-vectorbucketpolicy-policy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-vectorbucketpolicy.html#cfn-s3vectors-vectorbucketpolicy-policy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getPolicy();

    /**
     * The Amazon Resource Name (ARN) of the S3 vector bucket to which the policy applies.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-vectorbucketpolicy.html#cfn-s3vectors-vectorbucketpolicy-vectorbucketarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-vectorbucketpolicy.html#cfn-s3vectors-vectorbucketpolicy-vectorbucketarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVectorBucketArn() {
        return null;
    }

    /**
     * The name of the S3 vector bucket to which the policy applies.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-vectorbucketpolicy.html#cfn-s3vectors-vectorbucketpolicy-vectorbucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-vectorbucketpolicy.html#cfn-s3vectors-vectorbucketpolicy-vectorbucketname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVectorBucketName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVectorBucketPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVectorBucketPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVectorBucketPolicyProps> {
        java.lang.Object policy;
        java.lang.String vectorBucketArn;
        java.lang.String vectorBucketName;

        /**
         * Sets the value of {@link CfnVectorBucketPolicyProps#getPolicy}
         * @param policy A policy document containing permissions to add to the specified vector bucket. This parameter is required.
         *               In IAM , you must provide policy documents in JSON format. However, in CloudFormation you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to IAM .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(java.lang.Object policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Sets the value of {@link CfnVectorBucketPolicyProps#getVectorBucketArn}
         * @param vectorBucketArn The Amazon Resource Name (ARN) of the S3 vector bucket to which the policy applies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorBucketArn(java.lang.String vectorBucketArn) {
            this.vectorBucketArn = vectorBucketArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnVectorBucketPolicyProps#getVectorBucketName}
         * @param vectorBucketName The name of the S3 vector bucket to which the policy applies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorBucketName(java.lang.String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVectorBucketPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVectorBucketPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVectorBucketPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVectorBucketPolicyProps {
        private final java.lang.Object policy;
        private final java.lang.String vectorBucketArn;
        private final java.lang.String vectorBucketName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.policy = software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vectorBucketArn = software.amazon.jsii.Kernel.get(this, "vectorBucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vectorBucketName = software.amazon.jsii.Kernel.get(this, "vectorBucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.policy = java.util.Objects.requireNonNull(builder.policy, "policy is required");
            this.vectorBucketArn = builder.vectorBucketArn;
            this.vectorBucketName = builder.vectorBucketName;
        }

        @Override
        public final java.lang.Object getPolicy() {
            return this.policy;
        }

        @Override
        public final java.lang.String getVectorBucketArn() {
            return this.vectorBucketArn;
        }

        @Override
        public final java.lang.String getVectorBucketName() {
            return this.vectorBucketName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("policy", om.valueToTree(this.getPolicy()));
            if (this.getVectorBucketArn() != null) {
                data.set("vectorBucketArn", om.valueToTree(this.getVectorBucketArn()));
            }
            if (this.getVectorBucketName() != null) {
                data.set("vectorBucketName", om.valueToTree(this.getVectorBucketName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3vectors.CfnVectorBucketPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVectorBucketPolicyProps.Jsii$Proxy that = (CfnVectorBucketPolicyProps.Jsii$Proxy) o;

            if (!policy.equals(that.policy)) return false;
            if (this.vectorBucketArn != null ? !this.vectorBucketArn.equals(that.vectorBucketArn) : that.vectorBucketArn != null) return false;
            return this.vectorBucketName != null ? this.vectorBucketName.equals(that.vectorBucketName) : that.vectorBucketName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.policy.hashCode();
            result = 31 * result + (this.vectorBucketArn != null ? this.vectorBucketArn.hashCode() : 0);
            result = 31 * result + (this.vectorBucketName != null ? this.vectorBucketName.hashCode() : 0);
            return result;
        }
    }
}
