package software.amazon.awscdk.services.scheduler;

/**
 * Construction properties for <code>Schedule</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * IDeliveryStream deliveryStream;
 * Map&lt;String, String&gt; payload = Map.of(
 *         "Data", "record");
 * Schedule.Builder.create(this, "Schedule")
 *         .schedule(ScheduleExpression.rate(Duration.minutes(60)))
 *         .target(FirehosePutRecord.Builder.create(deliveryStream)
 *                 .input(ScheduleTargetInput.fromObject(payload))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:00.545Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.ScheduleProps")
@software.amazon.jsii.Jsii.Proxy(ScheduleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ScheduleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The expression that defines when the schedule runs.
     * <p>
     * Can be either a <code>at</code>, <code>rate</code>
     * or <code>cron</code> expression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.ScheduleExpression getSchedule();

    /**
     * The schedule's target details.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.IScheduleTarget getTarget();

    /**
     * The description you specify for the schedule.
     * <p>
     * Default: - no value
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Indicates whether the schedule is enabled.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * The date, in UTC, before which the schedule can invoke its target.
     * <p>
     * EventBridge Scheduler ignores end for one-time schedules.
     * <p>
     * Default: - no value
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.time.Instant getEnd() {
        return null;
    }

    /**
     * The customer managed KMS key that EventBridge Scheduler will use to encrypt and decrypt your data.
     * <p>
     * Default: - All events in Scheduler are encrypted with a key that AWS owns and manages.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getKey() {
        return null;
    }

    /**
     * The schedule's group.
     * <p>
     * Default: - By default a schedule will be associated with the `default` group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.scheduler.IScheduleGroup getScheduleGroup() {
        return null;
    }

    /**
     * The name of the schedule.
     * <p>
     * Up to 64 letters (uppercase and lowercase), numbers, hyphens, underscores and dots are allowed.
     * <p>
     * Default: - A unique name will be generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getScheduleName() {
        return null;
    }

    /**
     * The date, in UTC, after which the schedule can begin invoking its target.
     * <p>
     * EventBridge Scheduler ignores start for one-time schedules.
     * <p>
     * Default: - no value
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.time.Instant getStart() {
        return null;
    }

    /**
     * A time window during which EventBridge Scheduler invokes the schedule.
     * <p>
     * Default: TimeWindow.off()
     * <p>
     * @see <a href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-schedule-flexible-time-windows.html">https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-schedule-flexible-time-windows.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.scheduler.TimeWindow getTimeWindow() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ScheduleProps> {
        software.amazon.awscdk.services.scheduler.ScheduleExpression schedule;
        software.amazon.awscdk.services.scheduler.IScheduleTarget target;
        java.lang.String description;
        java.lang.Boolean enabled;
        java.time.Instant end;
        software.amazon.awscdk.services.kms.IKey key;
        software.amazon.awscdk.services.scheduler.IScheduleGroup scheduleGroup;
        java.lang.String scheduleName;
        java.time.Instant start;
        software.amazon.awscdk.services.scheduler.TimeWindow timeWindow;

        /**
         * Sets the value of {@link ScheduleProps#getSchedule}
         * @param schedule The expression that defines when the schedule runs. This parameter is required.
         *                 Can be either a <code>at</code>, <code>rate</code>
         *                 or <code>cron</code> expression.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.services.scheduler.ScheduleExpression schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link ScheduleProps#getTarget}
         * @param target The schedule's target details. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(software.amazon.awscdk.services.scheduler.IScheduleTarget target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link ScheduleProps#getDescription}
         * @param description The description you specify for the schedule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ScheduleProps#getEnabled}
         * @param enabled Indicates whether the schedule is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link ScheduleProps#getEnd}
         * @param end The date, in UTC, before which the schedule can invoke its target.
         *            EventBridge Scheduler ignores end for one-time schedules.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder end(java.time.Instant end) {
            this.end = end;
            return this;
        }

        /**
         * Sets the value of {@link ScheduleProps#getKey}
         * @param key The customer managed KMS key that EventBridge Scheduler will use to encrypt and decrypt your data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder key(software.amazon.awscdk.services.kms.IKey key) {
            this.key = key;
            return this;
        }

        /**
         * Sets the value of {@link ScheduleProps#getScheduleGroup}
         * @param scheduleGroup The schedule's group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleGroup(software.amazon.awscdk.services.scheduler.IScheduleGroup scheduleGroup) {
            this.scheduleGroup = scheduleGroup;
            return this;
        }

        /**
         * Sets the value of {@link ScheduleProps#getScheduleName}
         * @param scheduleName The name of the schedule.
         *                     Up to 64 letters (uppercase and lowercase), numbers, hyphens, underscores and dots are allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleName(java.lang.String scheduleName) {
            this.scheduleName = scheduleName;
            return this;
        }

        /**
         * Sets the value of {@link ScheduleProps#getStart}
         * @param start The date, in UTC, after which the schedule can begin invoking its target.
         *              EventBridge Scheduler ignores start for one-time schedules.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder start(java.time.Instant start) {
            this.start = start;
            return this;
        }

        /**
         * Sets the value of {@link ScheduleProps#getTimeWindow}
         * @param timeWindow A time window during which EventBridge Scheduler invokes the schedule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeWindow(software.amazon.awscdk.services.scheduler.TimeWindow timeWindow) {
            this.timeWindow = timeWindow;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ScheduleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ScheduleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleProps {
        private final software.amazon.awscdk.services.scheduler.ScheduleExpression schedule;
        private final software.amazon.awscdk.services.scheduler.IScheduleTarget target;
        private final java.lang.String description;
        private final java.lang.Boolean enabled;
        private final java.time.Instant end;
        private final software.amazon.awscdk.services.kms.IKey key;
        private final software.amazon.awscdk.services.scheduler.IScheduleGroup scheduleGroup;
        private final java.lang.String scheduleName;
        private final java.time.Instant start;
        private final software.amazon.awscdk.services.scheduler.TimeWindow timeWindow;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.ScheduleExpression.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.IScheduleTarget.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.end = software.amazon.jsii.Kernel.get(this, "end", software.amazon.jsii.NativeType.forClass(java.time.Instant.class));
            this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.scheduleGroup = software.amazon.jsii.Kernel.get(this, "scheduleGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.IScheduleGroup.class));
            this.scheduleName = software.amazon.jsii.Kernel.get(this, "scheduleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.start = software.amazon.jsii.Kernel.get(this, "start", software.amazon.jsii.NativeType.forClass(java.time.Instant.class));
            this.timeWindow = software.amazon.jsii.Kernel.get(this, "timeWindow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.TimeWindow.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.schedule = java.util.Objects.requireNonNull(builder.schedule, "schedule is required");
            this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
            this.description = builder.description;
            this.enabled = builder.enabled;
            this.end = builder.end;
            this.key = builder.key;
            this.scheduleGroup = builder.scheduleGroup;
            this.scheduleName = builder.scheduleName;
            this.start = builder.start;
            this.timeWindow = builder.timeWindow;
        }

        @Override
        public final software.amazon.awscdk.services.scheduler.ScheduleExpression getSchedule() {
            return this.schedule;
        }

        @Override
        public final software.amazon.awscdk.services.scheduler.IScheduleTarget getTarget() {
            return this.target;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.time.Instant getEnd() {
            return this.end;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getKey() {
            return this.key;
        }

        @Override
        public final software.amazon.awscdk.services.scheduler.IScheduleGroup getScheduleGroup() {
            return this.scheduleGroup;
        }

        @Override
        public final java.lang.String getScheduleName() {
            return this.scheduleName;
        }

        @Override
        public final java.time.Instant getStart() {
            return this.start;
        }

        @Override
        public final software.amazon.awscdk.services.scheduler.TimeWindow getTimeWindow() {
            return this.timeWindow;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("schedule", om.valueToTree(this.getSchedule()));
            data.set("target", om.valueToTree(this.getTarget()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getEnd() != null) {
                data.set("end", om.valueToTree(this.getEnd()));
            }
            if (this.getKey() != null) {
                data.set("key", om.valueToTree(this.getKey()));
            }
            if (this.getScheduleGroup() != null) {
                data.set("scheduleGroup", om.valueToTree(this.getScheduleGroup()));
            }
            if (this.getScheduleName() != null) {
                data.set("scheduleName", om.valueToTree(this.getScheduleName()));
            }
            if (this.getStart() != null) {
                data.set("start", om.valueToTree(this.getStart()));
            }
            if (this.getTimeWindow() != null) {
                data.set("timeWindow", om.valueToTree(this.getTimeWindow()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_scheduler.ScheduleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ScheduleProps.Jsii$Proxy that = (ScheduleProps.Jsii$Proxy) o;

            if (!schedule.equals(that.schedule)) return false;
            if (!target.equals(that.target)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.end != null ? !this.end.equals(that.end) : that.end != null) return false;
            if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
            if (this.scheduleGroup != null ? !this.scheduleGroup.equals(that.scheduleGroup) : that.scheduleGroup != null) return false;
            if (this.scheduleName != null ? !this.scheduleName.equals(that.scheduleName) : that.scheduleName != null) return false;
            if (this.start != null ? !this.start.equals(that.start) : that.start != null) return false;
            return this.timeWindow != null ? this.timeWindow.equals(that.timeWindow) : that.timeWindow == null;
        }

        @Override
        public final int hashCode() {
            int result = this.schedule.hashCode();
            result = 31 * result + (this.target.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            result = 31 * result + (this.scheduleGroup != null ? this.scheduleGroup.hashCode() : 0);
            result = 31 * result + (this.scheduleName != null ? this.scheduleName.hashCode() : 0);
            result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
            result = 31 * result + (this.timeWindow != null ? this.timeWindow.hashCode() : 0);
            return result;
        }
    }
}
